/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#include <qfile.h>
#include <qtextstream.h>
#include <qstring.h>

#include "translator.h"
#include "powerkadu.h"
#include "cmdline.h"

#include "chat_manager.h"
#include "misc.h"
#include "debug.h"

Translator::Translator(QString cType, QObject *parent, const char *name)
: QObject(parent, name)
{
	kdebugf();
	codeType = cType;
	QFile dataFile(dataPath("kadu/modules/data/powerkadu/" + codeType + "_code.data"));
	if(dataFile.open(IO_ReadOnly))
	{
		QTextStream s(&dataFile);
		QString tmpStr;
		while(!s.atEnd())
		{
			tmpStr = s.readLine();
			keyList[tmpStr[0]] = tmpStr.section(' ', 1, 1);
		}
		dataFile.close();
	}
	powerKadu->cmds()->addCmd(codeType, this, SLOT(translateCmd(Chat*, const UserGroup*, QString&, QStringList&, QCString&)));
	kdebugf2();
}

Translator::~Translator()
{
	kdebugf();
	kdebugf2();
}

QString Translator::encode(const QString &text)
{
	kdebugf();
	QString tmpStr = "";
	for(unsigned int i = 0; i < text.length(); i++)
	{
		if(keyList[text[i]] != "")
			tmpStr += keyList[text[i]];
		else
			tmpStr += text[i];

		if(codeType == "morse")
			tmpStr += "  ";
	}
	return (tmpStr + "  (" + codeType + ")");
}

void Translator::translateCmd(Chat* chat, const UserGroup* users, QString &cmd, QStringList &args, QCString &msg)
{
	kdebugf();
	CHECK_CMD(codeType);

	chat->edit()->setText( encode(args.join(" ")) );
	chat->sendMessage();

	kdebugf2();
}
