#ifndef KADU_USERINFO_H
#define KADU_USERINFO_H

#include <qhbox.h>
#include <qvaluelist.h>

#include "userlistelement.h"
#include "misc.h"

class LayoutHelper;
class QCheckBox;
class QDns;
class QLineEdit;
class QPushButton;
class QTabWidget;
class QVBox;
class QVGroupBox;

/**
	Klasa ta reprezentuje okno, z ktrym mamy do czynienia podczas dodawania nowego kontaktu,
	lub podczas edycji danych istniejcego ju kontaktu.
	\class UserInfo
	\brief Okno dialogowe pokazujce informacje o wybranym kontakcie
**/
class UserInfo : public QHBox
{
	Q_OBJECT
	public:
		/**
			\var static CreateNotifier createNotifier
			Statyczny obiekt wysyajcy sygna CreateNotifier::objectCreated
			jeli powstanie nowa instancja okienka.
		**/
		static CreateNotifier createNotifier;

		/**
			\fn UserInfo(const QString &altnick, bool addUser = false, QDialog* parent=0, const char *name=0)
			Konstruktor tworzcy okno dialogowe z informacjami o danym kontakcie.
			\param altnick pseudonim kontaktu wywietlany na licie.
			\param addUser TRUE gdy dodajemy kontakt, FALSE gdy edytujemy dane istniejcego. Domylnie FALSE.
			\param parent wskanik do obiektu stanowicego rodzica. Domylnie 0.
			\param name nazwa kontrolki. Domylnie 0.
		**/
		UserInfo(UserListElement user, QDialog* parent = 0, const char *name = 0);
		~UserInfo();

		QTabWidget *tabs() {return tw_main;}
		UserListElement user() const {return User;}
		static bool acceptableGroupName(const QString &groupName);

	private:
		UserListElement User;
		QLineEdit *e_firstname;
		QLineEdit *e_lastname;
		QLineEdit *e_nickname;
		QLineEdit *e_altnick;
		QLineEdit *e_mobile;
		QLineEdit *e_uin;
		QLineEdit *e_addr;
		QLineEdit *e_ver;
		QLineEdit *e_email;
		QLineEdit *e_dnsname;
		QCheckBox *c_blocking;
		QCheckBox *c_offtouser;
		QCheckBox *c_notify;
		QPushButton *pb_addapply;
		QTabWidget *tw_main;
		QVGroupBox *vgb_general;
		QDns *dns;

		QValueList<QCheckBox *> groups;
		QValueList<QCheckBox *> hiddenCheckBoxes;
		QLineEdit *newGroup;
		QVBox *groupsBox;
		LayoutHelper *layoutHelper;

		void keyPressEvent(QKeyEvent *);

	protected:
		/**
			\fn void setupTab1()
			Tworzy pierwsz zakadk.
		**/
		void setupTab1();

		/**
			\fn void setupTab2()
			Tworzy drug zakadk.
		**/
		void setupTab2();

		/**
			\fn void setupTab3()
			Tworzy trzeci zakadk.
		**/
		void setupTab3();

		virtual void resizeEvent(QResizeEvent *);

	public slots:
		/**
			\fn void updateUserlist()
			Wcinicie przycisku Dodaj/Uaktualnij
		**/
		void updateUserlist();

	private slots:
		/**
			\fn void resultsReady()
			Ustawia warto pola DNS na znalezion nazw domeny.
		**/
		void resultsReady();

		/**
			\fn void newGroupClicked()
			wcinito przycisk tworzenia nowej grupy
		**/
		void newGroupClicked();
	signals:
		void updateClicked(UserInfo *);
};

#endif
