/***************************************************************************
 *   Copyright (C) 2004, 2005 Thomas Nagy                                  *
 *   tnagy2^8@yahoo.fr                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation (see COPYING)            *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 ***************************************************************************/

#ifndef _KDISSOOODOC_H
#define _KDISSOOODOC_H

#include <qstringlist.h>
#include <qobject.h>
#include <klibloader.h>
#include "DGenerator.h"

class kdissOOOdocFactory : KLibFactory { Q_OBJECT public: QObject *createObject(QObject *, const char *, const char *, const QStringList & = QStringList()); };

class DDataItem;
/**
 * OpenOffice.org writer document generator
 *
 * @short OpenOffice.org writer document generator
 * @author Thomas Nagy <tnagy2^8@yahoo.fr>
 */
class kdissOOOdoc : public DGenerator
{
    public:
	kdissOOOdoc() : DGenerator() {}
	~kdissOOOdoc() {}

	const QString identifikation();
	const QString fullName();
	const QString group();
	const QString description();
	const QString quickstart();

    private:
	bool writeMaindoc(DDataItem*, const QString &);
	void writeItem(DDataItem* item, QTextStream & s, int level);
	void writePics(DDataControl*, QString);
	void outputData(DDataItem* item, QTextStream & s, int level);

	/// write recursively the pics of a tree to the manifest file
	void writeItemPic(DDataControl*, DDataItem *item, QTextStream & m);
};

#endif // _KDISSOOODOC_H
