/***************************************************************************
                          chatview.h  -  description
                             -------------------
    begin                : Wed Jan 15 2003
    copyright            : (C) 2003 by Mike K. Bennett
    email                : mkb137b@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CHATVIEW_H
#define CHATVIEW_H

#include <qpoint.h>
#include <qtimer.h>
#include <qwidget.h>
#include "chatviewinterface.h"

// Forward declarations
class CurrentAccount;
class Emoticon;
class EmoticonCollection;
class EmoticonChooser;
class KMessTest;

/**The view widget of a chat with a contact with message display and entry.
  *@author Mike K. Bennett
  */

class ChatView : public ChatViewInterface
{
  Q_OBJECT

  friend class KMessTest;

  public:
    // The constructor
  	                   ChatView(QWidget *parent=0, const char *name=0);
    // The destructor
  	                  ~ChatView();
    // Initialize the object
    bool                initialize();
    // Whether or not the message area is empty
    bool                isEmpty() const;
    // Scroll to the bottom of the chat browser
    void                scrollChatToBottom();
    // Show the emoticon chooser at the given point.
    void                showEmoticonChooser(QPoint point);

  public slots:
    // Show a preformatted application message in the message browser.
    void                showAppMessage(QString html);
    // Show a server-related message.
    void                showSystemMessage(QString message);
    // Add the given message to the message browser.
    void                showMessage(QString handle, QString name, QString text, QFont font, QString color, QString nameColor);

  private: // Private methods
    // Add the given text to the chat browser and scroll to the end
    void                addTextToBrowser( QString text );
    // Delete the newline behind the message edit's cursor.
    void                deleteNewlineAtCursor();
    // Initialize the current account
    bool                initializeCurrentAccount();
    // Create the emoticons
    bool                initializeEmoticons();
    // Initialize the emoticon chooser
    bool                initializeEmoticonChooser();
    // Do some effects characters (ie, bold, underline and italic specials)
    void                parseEffects(QString &text) const;
    // Replace any urls with a real clickable URL.
    void                parseUrls(QString &text) const;
    // Parse the text for the given tag and insert a clickable URL for it.
    void                parseUrlsForTag(QString &text, QString tag) const;
    // Send a message via the server
    void                sendMessage();

  private slots: // Private slots
    // The user pressed return in the message editor, so send the message
    void                enterPressed();
    // Insert an emoticon into the message editor
    void                insertEmoticon( QString emoticonText );
    // The message text changed, so the user is typing
    void                messageTextChanged();
    // The user clicked the new line button so insert a new line in the editor
    void                newLineClicked();
    // The user clicked send, so send the message
    void                sendClicked();
    // Update the editor's font to match the account's font
    void                updateEditorFont();
    // The user clicked a url in the chat browser
    void                urlClicked(const QString &url);

  private: // Private attributes
    // A pointer to the instance of the current account
    CurrentAccount      *currentAccount_;
    // Whether or not typing messages should be sent (true except the very moment a text message is sent)
    bool                doSendTypingMessages_;
    // The emoticons
    EmoticonCollection *emoticons_;
    // The popup emoticon chooser dialog
    EmoticonChooser    *emoticonChooser_;
    // Whether or not the object was initialized
    bool                initialized_;
    // Whether or not the chat message area is empty
    bool                isEmpty_;
    // A timer to time whether a "user is typing" message should be sent.
    QTimer              userTypingTimer_;

  private slots:
    // The color in the text box changed.
    void                editorColorChanged(const QColor &color);

  signals: // Public signals
    // Signal that there's an application command
    void                appCommand(QString cookie, QString method);
    // Signal that the given text should be sent as a message
    void                sendMessageToContact(QString text);
    // Signal that the user is typing
    void                userIsTyping();
};

#endif
