/***************************************************************************
                          contactsidebar.h  -  description
                             -------------------
    begin                : Thu Jan 16 2003
    copyright            : (C) 2003 by Mike K. Bennett
    email                : mkb137b@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CONTACTSIDEBAR_H
#define CONTACTSIDEBAR_H

#include <qptrlist.h>
#include <qscrollview.h>
#include <qwidget.h>

// Forward declarations
class ContactBase;
class ContactFrame;
class ContactList;
class InvitedContact;
class QVBoxLayout;

/**The sidebar in a chat that contains the little contact information frames.
  *@author Mike K. Bennett
  */

class ContactSidebar : public QScrollView
{
  Q_OBJECT

  public:
    // The constructor
                               ContactSidebar(QWidget *parent=0, const char *name=0);
    // The destructor
                              ~ContactSidebar();
    // Initialize the object
    bool                       initialize();
    // A message was received from one of the contacts... notify its frame
    void                       messageReceived(const QString& handle);
    // Set the contact list
    void                       setContactList(ContactList *contactList);

  protected:
    // do we want this drop?
    void contentsDropEvent( QDropEvent *event );
    // something being dragged has entered our widget
    void contentsDragEnterEvent( QDragEnterEvent *event );
    // something being dragged has been moved in our widget
    void contentsDragMoveEvent( QDragMoveEvent *event );

  public slots: // Public slots
    // A contact joined the chat
    void                       contactJoined(QString handle, QString friendlyName);
    // A contact left the chat
    void                       contactLeft(QString handle);
    // A contact is typing
    void                       contactTyping(QString handle, QString friendlyName);

  signals:
    // invite a contact to a chat (result of a drag and drop operation)
    void                       inviteContact( QString handle );

  private: // Private methods
    // Find the contact with the given contact handle in the lists
    ContactBase*               getContactByHandle(QString handle, QString friendlyName = "");
    // Find the contact frame with the given handle
    ContactFrame*              getContactFrameByHandle(const QString& handle);
    // Return the first inactive contact frame
    ContactFrame*              getFirstInactiveContactFrame();

  private: // Private attributes
    // The list of pointers to the frames in the sidebar
    QPtrList<ContactFrame>     contactFrames_;
    // The contact list
    ContactList               *contactList_;
    // A list of invited contacts, kept separate from the contact list
    QPtrList<InvitedContact>   invitedContacts_;
    // the box to put contact frames into
    QVBoxLayout               *viewBox_;
    // the widget looking after the layout (they can't look after themselves...)
    QWidget                   *viewBoxHolder_;
};

#endif
