/***************************************************************************
                          emoticonbutton.cpp  -  description
                             -------------------
    begin                : Mon May 6 2002
    copyright            : (C) 2002 by Mike K. Bennett
    email                : mkb137b@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "emoticonbutton.h"

#include <qcolor.h>
#include <qpalette.h>
#include <qpixmap.h>
#include <qregexp.h>
#include <qstyle.h>
#include <qtooltip.h>

#include <kdebug.h>

#include "../emoticon.h"
#include "../kmessdebug.h"

EmoticonButton::EmoticonButton(const Emoticon *emoticon, QWidget *parent,
 const char *name )
 : QToolButton(parent,name),
   emoticon_(emoticon)
{
  QString emoticonFile;

  emoticonFile = emoticon_->getFile();
#ifdef KMESSDEBUG_EMOTICONBUTTON
  kdDebug() << "EmoticonButton: file is at " << emoticonFile;
#endif
  // Set the button's pixmap to match the emoticon file
  setPixmap( QPixmap( emoticonFile ) );
  // Make the button flat.
  setAutoRaise(true);
  // Add a tooltip, if present
  if( emoticon_->hasTooltip() )
  {
    QToolTip::add( this, emoticon_->getTooltip() );
  }
  // Connect the button's own clicked signal to the clicked slot
  connect( this, SIGNAL(     clicked() ),
           this, SLOT  ( slotClicked() ) );
}



EmoticonButton::~EmoticonButton()
{
}



// The button was clicked.
void EmoticonButton::slotClicked()
{
  // Send the emoticon's text, i.e. :)
  QString text;
  text = emoticon_->getText();
#ifdef KMESSDEBUG_EMOTICONBUTTON
  kdDebug() << "Emoticon text before: " << text << endl;
#endif
  text = text.replace( QRegExp("\\\\"), "" );
#ifdef KMESSDEBUG_EMOTICONBUTTON
  kdDebug() << "Emoticon text after:  " << text << endl;
#endif
  // Signal the text code for the emoticon
  emit insertEmoticon( text );
}

#include "emoticonbutton.moc"
