/***************************************************************************
                          contactbase.h  -  description
                             -------------------
    begin                : Thu Jan 16 2003
    copyright            : (C) 2003 by Mike K. Bennett
    email                : mkb137b@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CONTACTBASE_H
#define CONTACTBASE_H

#include <qwidget.h>

/**
 * The base class of a contact, used for polymorphism with invited contacts.
 * @author Mike K. Bennett
 */
class ContactBase : public QObject
{
  Q_OBJECT

  public: // Public methods
    // The destructor
    virtual             ~ContactBase();
    // Return the default contact picture path
    QString              getContactDefaultPicturePath() const;
    // Return the path to the contact's picture
    virtual QString      getContactPicturePath() const = 0;
    // Return the contact's friendly name
    virtual QString      getFriendlyName() const;
    // Return the contact's handle
    QString              getHandle() const;
    // Return the contact's status
    virtual QString      getStatus() const = 0;
    // Return true if the contact is offline
    bool                 isOffline() const;
    // Return true if the contact is online
    bool                 isOnline() const;

  protected: // Protected methods
    // The constructor
                         ContactBase(QString handle, QString friendlyName);

  protected: // Protected attributes
    // The contact's friendly name
    QString              friendlyName_;
    // The contact's handle
    QString              handle_;
    // The contact's online status
    QString              status_;

  signals: // Public signals
    // Signal that the contact's friendly name changed
    void                 changedFriendlyName();
    // Signal that the contact's picture path has changed
    void                 changedPicture();
    // Signal that the contact's status changed
    void                 changedStatus();
};

#endif
