/***************************************************************************
                          currentaccount.h  -  description
                             -------------------
    begin                : Sun Jan 5 2003
    copyright            : (C) 2003 by Mike K. Bennett
    email                : mkb137b@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CURRENTACCOUNT_H
#define CURRENTACCOUNT_H

#include "account.h"

#include <qstringlist.h>
#include <qtimer.h>

// Forward declarations
class KMessTest;

/**A singleton giving the account used to connect to the network and current-session-only relevent data.
  *@author Mike K. Bennett
  */

class CurrentAccount : public Account
{
  Q_OBJECT

  friend class KMessTest;

  public:
    // Receive notice that some emails were deleted
    void                     changeNoEmails( int change );
    // Copy an account
    virtual void             copyAccount( const Account *account );
    // Delete the instance of the contact list
    static void              destroy();
    // Return whether or not to autoreply to messages
    bool                     getAutoreply() const;
    // Return the compose command.
    const QString&           getComposeCommand() const;
    // Return the email URL
    const QString&           getEmailUrl() const;
    // Return the external IP, as seen from the MSN server.
    const QString&           getExternalIP() const;
    // Return the external port, as seen from the MSN server.
    uint                     getExternalPort() const;
    // Return the inbox command.
    const QString&           getInboxCommand() const;
    // Return the number of email in the inbox
    int                      getNoEmails() const;
    // Return the user's staus
    QString                  getStatus() const;
    // Return a singleton instance of the current account
    static CurrentAccount*   instance();
    // Open hotmail with the given command, url, and folder
    void                     openHotmail(const QString&  command, const QString&  folder, const QString&  url);
    // Open hotmail at the compose page with the given contact handle
    void                     openHotmailAtCompose(QString contactHandle);
    // Open hotmail at the user's inbox
    void                     openHotmailAtInbox();
    // Set some account information
    void                     setAccountInformation( QString authorization, QString kv, QString preferredEmail,
                                                    QString sid, bool emailSupported, QString externalIP, uint externalPort );
    // Set whether or not to autoreply to a contact's chat message.
    void                     setAutoreply(bool autoreply);
    // Set compose properties
    void                     setComposeInformation( QString command, QString folder, QString url );
    // Set inbox properties.
    void                     setInboxInformation( QString command, QString folder, QString url );
    // Set initial email information
    void                     setInitialEmailInformation( QString emailUrl, int noEmailsInInbox, int noEmailsInOtherFolders );
    // Set the number of emails
    void                     setNoEmails( int noEmails );
    // Set the user's status
    void                     setStatus( QString status );

  private: // Private methods
    // The constructor
                             CurrentAccount();
    // The destructor
                            ~CurrentAccount();
    // Calculate the length of the session with the notification server.
    int                      getSessionLength() const;

  private slots: // Private slots
    // Remove the html file used to get into hotmail from the disk.
    void                     removeHotmailFile();

  private:  // private methods
    // Start a process
    void                     startProcess(QString command);

  private: // Private attributes
    // The MS Passport authorization used to access hotmail.
    QString                  authorization_;
    // Whether or not the program should autoreply to chat messages.
    bool                     autoreply_;
    // The HTTPS command to use when connecting to hotmail's compose.
    QString                  composeCommand_;
    // The folder for email composition, i.e. cgi-bin/compose
    QString                  composeFolder_;
    // The URL to go to when opening the compose folder.
    QString                  composeUrl_;
    // The user's preferred email URL (i.e. www.hotmail.com)
    QString                  emailUrl_;
    // Our (external) IP address seen from the MSN server.
    QString                  externalIP_;
    // Our (external) Port seen from the MSN server.
    uint                     externalPort_;
    // A timer used to remove the html file used to get into hotmail.
    QTimer                   fileRemovalTimer_;
    // A list of hotmail temporary files
    QStringList              hotmailFileList_;
    // The HTTPS command to use when connecting to the inbox.
    QString                  inboxCommand_;
    // The inbox folder, i.e. /cgi-bin/HoTMaiL.
    QString                  inboxFolder_;
    //The URL of the inbox
    QString                  inboxUrl_;
    // The instance of the singleton account
    static CurrentAccount   *instance_;
    // A value used to access the user's hotmail account.
    QString                  kv_;
    // The time at which the user synchronized with the notification server.
    unsigned int             loginTime_;
    // The number of emails in the user's inbox.
    int                      noEmails_;
    // The email address considered by the server to be the user's preferred address.  I don't know when it differs from the handle.
    QString                  preferredEmail_;
    // A value used to access the user's hotmail account.
    QString                  sid_;
    // The online status of the user.
    QString                  status_;

  signals: // Public signals
    // Signal that the number of emails has changed
    void                     changedNoEmails();
    // Signal that the user's status has changed
    void                     changedStatus();
};

#endif
