/***************************************************************************
                          kmesstest.h  -  description
                             -------------------
    begin                : Sun Jan 5 2003
    copyright            : (C) 2003 by Mike K. Bennett
    email                : mkb137b@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KMESSTEST_H
#define KMESSTEST_H

#include "kmessdebug.h"  // for KMESSTEST

#include <qobject.h>

// forward declarations
class KMess;

/**A class responsible for testing the other classes.
  *@author Mike K. Bennett
  */

class KMessTest : public QObject
{
  Q_OBJECT

  public:
    // The constructor
               KMessTest(KMess *kmess);
    // The destructor
              ~KMessTest();
    // The main testing function
    void       test();

#ifdef KMESSTEST
  private: // Private methods
    void       testNotificationConnection();
    void       testContactListWithNotificationConnection();
    void       testConnect();
    void       testSettings();
    void       testSwitchboardConnection();
    void       testNotifications();
    void       testUpnpConnection();
#endif

  private: // Private attributes
    // A pointer to the main widget, also used to gain access to all its attributes
    KMess     *kmess_;
};

#endif
