/***************************************************************************
                          ksubtile.cpp  -  description
                             -------------------
    begin                : di feb  4 15:33:11 CET 2003
    copyright            : (C) 2003 by Tom Deblauwe
    email                : tom.deblauwe@pandora.be
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// include files for QT
#include <qdir.h>
// #include <qprinter.h>
#include <qpainter.h>
#include <qtabwidget.h>
#include <qregexp.h>
#include <qdatetimeedit.h>
#include <qspinbox.h>
#include <qcheckbox.h>
#include <qpopupmenu.h>
#include <qslider.h>

// include files for KDE
#include <kiconloader.h>
#include <kmessagebox.h>
#include <kencodingfiledialog.h>
#include <kmenubar.h>
#include <kstatusbar.h>
#include <klocale.h>
#include <kconfig.h>
#include <kstdaction.h>
#include <kprocess.h>
#include <ksqueezedtextlabel.h>
#include <kkeydialog.h>
#include <kedittoolbar.h>
#include <kdeversion.h>
#include <kpushbutton.h>
#include <kurl.h>
#include <kio/netaccess.h>
#include <ktempfile.h>
#include "kdockwidget.h"

// application specific includes
#include "ksubtile.h"
#include "ksubtileview.h"
#include "ksubtiledoc.h"
#include "pref.h"
#include "subtitlenavigator.h"
#include "csubtitles.h"


#define ID_STATUS_MSG 1

KSubtileApp::KSubtileApp(QWidget* , const char* name):KDockMainWindow(0, name, WType_TopLevel | WDestructiveClose | WStyle_ContextHelp )
{

    copySubtitles = 0;


    ///////////////////////////////////////////////////////////////////
    // call inits to invoke all other construction parts
    initStatusBar();
    initActions();
    initDocument();
    initView();

    readOptions();

    ///////////////////////////////////////////////////////////////////
    // disable actions at startup
    fileSave->setEnabled(false);

    connect(getDocument(), SIGNAL(docModified(bool)), this, SLOT(slotSetModified(bool)));
    connect(getDocument(), SIGNAL(checkPlayer()), this, SLOT(slotSettingsCheckForMPlayer()));

    //check for mplayer at startup
    slotSettingsCheckForMPlayer();

    //   getDocument()->newDocument();
}

KSubtileApp::~KSubtileApp()
{
    //clean up copySubtitles
    if(copySubtitles != 0)
    {
        copySubtitles->setAutoDelete(true);
        delete copySubtitles;
    }
}

void KSubtileApp::initActions()
{

    fileNew = KStdAction::openNew(this, SLOT(slotFileNew()), actionCollection());
    fileOpen = KStdAction::open(this, SLOT(slotFileOpen()), actionCollection());
    //  fileOpenRecent = KStdAction::openRecent(this, SLOT(slotFileOpenRecent(const KURL&)), actionCollection());
    fileSave = KStdAction::save(this, SLOT(slotFileSave()), actionCollection());
    fileSaveAs = KStdAction::saveAs(this, SLOT(slotFileSaveAs()), actionCollection());
    fileQuit = KStdAction::quit(this, SLOT(slotFileQuit()), actionCollection());
    viewToolBar = KStdAction::showToolbar(this, SLOT(slotViewToolBar()), actionCollection());
    viewStatusBar = KStdAction::showStatusbar(this, SLOT(slotViewStatusBar()), actionCollection());

    KStdAction::keyBindings(this, SLOT(optionsConfigureKeys()), actionCollection());
    //     KStdAction::configureToolbars(this, SLOT(optionsConfigureToolbars()), actionCollection());
    KStdAction::preferences(this, SLOT(optionsPreferences()), actionCollection());

    //make own action collection
    // 	mActionCollection = new KActionCollection(this);

    KIconLoader* loader = KGlobal::iconLoader();

    settingsCheckForMPlayer = new KAction(i18n("Check for &MPlayer"), loader->loadIconSet("player_play", KIcon::Small), CTRL+Key_M, this, SLOT(slotSettingsCheckForMPlayer()), actionCollection(), "settings_checkformplayer");
    fileImport = new KAction(i18n("&Import..."), loader->loadIconSet("fileimport", KIcon::Small), CTRL+Key_I, this, SLOT(slotFileImport()), actionCollection(), "file_import");


    fileNew->setStatusText(i18n("Creates a new document"));
    fileOpen->setStatusText(i18n("Opens an existing document"));
    //fileOpenRecent->setStatusText(i18n("Opens a recently used file"));
    fileSave->setStatusText(i18n("Saves the actual document"));
    fileSaveAs->setStatusText(i18n("Saves the actual document as..."));
    fileQuit->setStatusText(i18n("Quits the application"));
    viewToolBar->setStatusText(i18n("Enables/disables the toolbar"));
    viewStatusBar->setStatusText(i18n("Enables/disables the statusbar"));
    settingsCheckForMPlayer->setStatusText(i18n("Check if mplayer is installed and enable player accordingly"));
    fileImport->setStatusText(i18n("Import other formats than SRT using MPlayer"));

    // use the absolute path to your ksubtileui.rc file for testing purpose in createGUI();
    createGUI("ksubtileui.rc");

    QPopupMenu* menu = findMenu( menuBar(), "settings" );
    menu->insertItem(loader->loadIconSet("run", KIcon::Small), i18n("Too&ls"), dockHideShowMenu(), -1, 0);
}

QPopupMenu* KSubtileApp::findMenu(QMenuData* menu, QString name)
{
    if (menu)
    {
        int menuCount = menu->count();
        for (int i=0; i<menuCount; i++)
        {
            int idAt = menu->idAt(i);
            QPopupMenu* popupMenu = menu->findItem(idAt)->popup();
            if (popupMenu)
            {
                QString menuName = popupMenu->name();
                if( menuName == name)
                {
                    return popupMenu;
                }
            }
        }
    }
    return 0;
}

void KSubtileApp::initStatusBar()
{
    ///////////////////////////////////////////////////////////////////
    // STATUSBAR
    // TODO: add your own items you need for displaying current application status.
    statusBar()->insertItem(i18n("Ready."), ID_STATUS_MSG);
}

void KSubtileApp::initDocument()
{
    doc = new KSubtileDoc(this);
    doc->newDocument();
}

void KSubtileApp::initView()
{
    KIconLoader* loader = KGlobal::iconLoader();

    KDockWidget* mainDock;
    mainDock = createDockWidget( "editor", loader->loadIcon("ksubtile", KIcon::Small), 0L, i18n("Editor"));

    //use the maindockwidget as view
    setView( mainDock );
    setMainDockWidget(mainDock);

    //create the editor dock
    view = new KSubtileView(mainDock);

    //add it to the mainDock
    mainDock->setWidget( view );

    //create the player dock
    KDockWidget* dockUp;
    dockUp = createDockWidget( "player", loader->loadIcon("player_play", KIcon::Small), 0L, i18n("MPlayer controls"));
    player = new KSubtilePlayer(dockUp);
    dockUp->setWidget( player );
    dockUp->manualDock( mainDock,              // dock target
                        KDockWidget::DockTop, // dock site
                        20 );

    //make the view know about the app
    view->theApp = this;

    //make the doc know about the editor
    doc->addView(view);

    //set the caption of the mainwindow
    setCaption(doc->URL().fileName(),false);

}

void KSubtileApp::optionsConfigureKeys()
{
    KKeyDialog::configure(actionCollection());
}

// void KSubtileApp::optionsConfigureToolbars()
// {
//     // use the standard toolbar editor
// #if defined(KDE_MAKE_VERSION)
// # if KDE_VERSION >= KDE_MAKE_VERSION(3,1,0)
//     saveMainWindowSettings(KGlobal::config(), autoSaveGroup());
// # else
//     saveMainWindowSettings(KGlobal::config());
// # endif
// #else
//     saveMainWindowSettings(KGlobal::config());
// #endif
// }
//
// void KSubtileApp::newToolbarConfig()
// {
//     // this slot is called when user clicks "Ok" or "Apply" in the toolbar editor.
//     // recreate our GUI, and re-apply the settings (e.g. "text under icons", etc.)
//     createGUI("ksubtileui.rc");
//
// #if defined(KDE_MAKE_VERSION)
// # if KDE_VERSION >= KDE_MAKE_VERSION(3,1,0)
//     applyMainWindowSettings(KGlobal::config(), autoSaveGroup());
// # else
//     applyMainWindowSettings(KGlobal::config());
// # endif
// #else
//     applyMainWindowSettings(KGlobal::config());
// #endif
// }

void KSubtileApp::optionsPreferences()
{
    // popup some sort of preference dialog, here
    ksubtilePreferences dlg;

    //fill in the saved values

    kapp->config()->setGroup("MPlayer Options");
    dlg.setMPlayerPosition( (ksubtilePreferences::MPlayerPosition) kapp->config()->readNumEntry("MPlayer Position", ksubtilePreferences::pref_MPlayerPosition));
    dlg.setMPlayerAutomaticResize( kapp->config()->readBoolEntry("Automatic Resize", ksubtilePreferences::pref_MPlayerAutomaticResize));
    //set mplayer audio and video output
    dlg.setAudioOutputDriver( kapp->config()->readEntry("Audio Output Driver", ksubtilePreferences::pref_AudioOutputDriver()) );
    dlg.setVideoOutputDriver( kapp->config()->readEntry("Video Output Driver", ksubtilePreferences::pref_VideoOutputDriver()) );


    kapp->config()->setGroup("Editor Options");
    dlg.setDefaultAddNewLength( kapp->config()->readNumEntry("Default Add New Length", ksubtilePreferences::pref_DefaultAddNewLength) );
    dlg.setNavigatorSubtitleColor( kapp->config()->readColorEntry("Navigator Subtitle Color", &ksubtilePreferences::pref_NavigatorSubtitleColor) );
    dlg.setNavigatorHighlightSubtitleColor( kapp->config()->readColorEntry("Navigator Highlight Subtitle Color", &ksubtilePreferences::pref_NavigatorHighlightSubtitleColor) );
    dlg.setNavigatorBackgroundColor( kapp->config()->readColorEntry("Navigator Background Color", &ksubtilePreferences::pref_NavigatorBackgroundColor) );
    dlg.setNavigatorDisplayText( kapp->config()->readBoolEntry("Display Text", ksubtilePreferences::pref_NavigatorDisplayText) );
    dlg.setDefaultPasteOffset( kapp->config()->readNumEntry("Default Paste Offset", ksubtilePreferences::pref_DefaultPasteOffset) );
    
    if (dlg.exec())
    {
        // redo your settings

        kapp->config()->setGroup("Editor Options");
        kapp->config()->writeEntry("Default Add New Length", dlg.getDefaultAddNewLength());
        kapp->config()->writeEntry("Navigator Subtitle Color", dlg.getNavigatorSubtitleColor());
        kapp->config()->writeEntry("Navigator Highlight Subtitle Color", dlg.getNavigatorHighlightSubtitleColor());
        kapp->config()->writeEntry("Navigator Background Color", dlg.getNavigatorBackgroundColor());
        kapp->config()->writeEntry("Display Text", dlg.getNavigatorDisplayText());
        kapp->config()->writeEntry("Default Paste Offset", dlg.getDefaultPasteOffset());
	
        kapp->config()->setGroup("MPlayer Options");
        kapp->config()->writeEntry("MPlayer Position", dlg.getMPlayerPosition());
        kapp->config()->writeEntry("Automatic Resize", dlg.getMPlayerAutomaticResize());
        kapp->config()->writeEntry("Audio Output Driver", dlg.getAudioOutputDriver());
        kapp->config()->writeEntry("Video Output Driver", dlg.getVideoOutputDriver());

        //repaint navigator
        KSubtileView* current = (KSubtileView*) getDocument()->pViewList->first();
        current->pm_editor_navigator_bar->drawSubs(getDocument()->subtitles, false, current->pm_editor_navigator_bar->getSelectedSubtitle());
    }
}

void KSubtileApp::openDocumentFile(const KURL& url)
{
    slotStatusMsg(i18n("Opening file..."));

    doc->openDocument( url);
    setCaption(url.fileName(), getDocument()->modified);
    //fileOpenRecent->addURL( url );
    slotStatusMsg(i18n("Ready."));
    
    //select info tab    
    KSubtileView* current = (KSubtileView*) getDocument()->pViewList->first();		
    current->tw_editor->setCurrentPage( 0 );    
}


KSubtileDoc *KSubtileApp::getDocument() const
{
    return doc;
}

void KSubtileApp::saveOptions()
{
    kapp->config()->setGroup("General Options");
    kapp->config()->writeEntry("Geometry", size());
    kapp->config()->writeEntry("Show Toolbar", viewToolBar->isChecked());
    kapp->config()->writeEntry("Show Statusbar",viewStatusBar->isChecked());
    kapp->config()->writeEntry("ToolBarPos", (int) toolBar("mainToolBar")->barPos());

    //docking config
    manager()->writeConfig( kapp->config() , "Docking Config" );


    //     fileOpenRecent->saveEntries(config,"Recent Files");
}


void KSubtileApp::readOptions()
{

    kapp->config()->setGroup("General Options");

    // bar status settings
    bool bViewToolbar = kapp->config()->readBoolEntry("Show Toolbar", true);
    viewToolBar->setChecked(bViewToolbar);
    slotViewToolBar();

    bool bViewStatusbar = kapp->config()->readBoolEntry("Show Statusbar", true);
    viewStatusBar->setChecked(bViewStatusbar);
    slotViewStatusBar();


    // bar position settings
    KToolBar::BarPosition toolBarPos;
    toolBarPos=(KToolBar::BarPosition) kapp->config()->readNumEntry("ToolBarPos",KToolBar::Top);
    toolBar("mainToolBar")->setBarPos(toolBarPos);

    //dockbar positions
    manager()->readConfig( kapp->config(), "Docking Config" );

    // initialize the recent file list
    //fileOpenRecent->loadEntries(config,"Recent Files");

    QSize size = kapp->config()->readSizeEntry("Geometry");
    if(!size.isEmpty())
    {
        resize(size);
    }
}

void KSubtileApp::saveProperties(KConfig *_cfg)
{
    if(doc->URL().fileName()!=i18n("Untitled") && !doc->isModified())
    {
        // saving to tempfile not necessary

    }
    else
    {
        KURL url=doc->URL();
        _cfg->writeEntry("filename", url.url());
        _cfg->writeEntry("modified", doc->isModified());
        QString tempname = kapp->tempSaveName(url.url());
        QString tempurl= KURL::encode_string(tempname);
        KURL _url(tempurl);
        doc->saveDocument(_url);
    }
}


void KSubtileApp::readProperties(KConfig* _cfg)
{
    QString filename = _cfg->readEntry("filename", "");
    KURL url(filename);
    bool modified = _cfg->readBoolEntry("modified", false);
    if(modified)
    {
        bool canRecover;
        QString tempname = kapp->checkRecoverFile(filename, canRecover);
        KURL _url(tempname);

        if(canRecover)
        {
            doc->openDocument(_url);
            doc->setModified();
            setCaption(_url.fileName(),true);
            QFile::remove
                (tempname);
        }
    }
    else
    {
        if(!filename.isEmpty())
        {
            doc->openDocument(url);
            setCaption(url.fileName(),false);
        }
    }
}

bool KSubtileApp::queryClose()
{
    bool ok = doc->saveModified();
    //if ok to close the program, we delete the contents so the memory gets freed
    if(ok)
    {
        doc->deleteContents();
        return true;
    }
    //user pressed cancel when asked to save
    return false;
}

bool KSubtileApp::queryExit()
{
    saveOptions();
    return true;
}

/////////////////////////////////////////////////////////////////////
// SLOT IMPLEMENTATION
/////////////////////////////////////////////////////////////////////

//void KSubtileApp::slotFileNewWindow()
//{
//  slotStatusMsg(i18n("Opening a new application window..."));
//
//  KSubtileApp *new_window= new KSubtileApp();
//  new_window->show();
//
//  slotStatusMsg(i18n("Ready."));
//}

void KSubtileApp::slotFileNew()
{
    slotStatusMsg(i18n("Creating new document..."));

    if(!doc->saveModified())
    {
        // here saving wasn't successful

    }
    else
    {	
	doc->newDocument();
        setCaption(doc->URL().fileName(), false);
	
	KSubtileView* current = (KSubtileView*) getDocument()->pViewList->first();

        //select info tab
        current->tw_editor->setCurrentPage( 0 );

    }

    slotStatusMsg(i18n("Ready."));
}

void KSubtileApp::slotFileOpen()
{
    slotStatusMsg(i18n("Opening file..."));

    if(!doc->saveModified())
    {
        // here saving wasn't successful

    }
    else
    {
    	KEncodingFileDialog::Result res;
        res = KEncodingFileDialog::getOpenURLAndEncoding(QString::null, QString::null,
                                         i18n("*.srt|SRT Files"), this, i18n("Open File..."));
	KURL url = res.URLs.first();
        if(!url.isEmpty())
        {
            doc->text_codec = res.encoding;
	    	
            bool ok = doc->openDocument(url);
            if(ok)
            {
                KSubtileView* current = (KSubtileView*) getDocument()->pViewList->first();		
                setCaption(url.fileName(), getDocument()->modified);
                //select info tab
                current->tw_editor->setCurrentPage( 0 );
                //fileOpenRecent->addURL( url );
            }
            else
            {
                KMessageBox::sorry(this, i18n("Could not open the SRT file! Perhaps try the Import... feature in the File menu?"), i18n("Sorry!"));
            }
        }
    }
    slotStatusMsg(i18n("Ready."));
}

// void KSubtileApp::slotFileOpenRecent(const KURL& url)
// {
//   slotStatusMsg(i18n("Opening file..."));
//
//   if(!doc->saveModified())
//   {
//      // here saving wasn't successful
//   }
//   else
//   {
// //    printf( "url:%s", (url).url().latin1() );
//     doc->openDocument(url);
//     setCaption(url.fileName(), false);
//   }
//
//   slotStatusMsg(i18n("Ready."));
// }

void KSubtileApp::slotFileSave()
{
    slotStatusMsg(i18n("Saving file..."));

    doc->saveDocument(doc->URL());
    slotStatusMsg(i18n("Ready."));
}

void KSubtileApp::slotFileSaveAs()
{
    slotStatusMsg(i18n("Saving file with a new filename..."));

   	KEncodingFileDialog::Result res;
    res = KEncodingFileDialog::getSaveURLAndEncoding(doc->text_codec, QDir::currentDirPath(),
                                    	i18n("*.srt|SRT files"), this, i18n("Save as..."));
    KURL url = res.URLs.first();
	if(!url.isEmpty())
    {
		doc->text_codec = res.encoding;
        doc->saveDocument(url);
        //    if(ok)
        //    {
        //      fileOpenRecent->addURL(url);
        setCaption(url.fileName(),doc->isModified());
        KSubtileView* current = (KSubtileView*) getDocument()->pViewList->first();
        current->tw_editor->setCurrentPage( current->tw_editor->indexOf(current->tw_editor->currentPage()) );
        //    }
    }

    slotStatusMsg(i18n("Ready."));
}

void KSubtileApp::slotSetModified(bool m)
{
    if (doc->URL().fileName() == i18n("Untitled"))
    {
        //we can't enable save, no filename yet
    }
    else
    {
        fileSave->setEnabled(m);
    }

    QString theCaption = caption();
    //   printf("%s\n", theCaption.latin1());
    QString toRemove = " - KSubtile";
    theCaption.remove(toRemove);
    toRemove = " [";
    toRemove.append(i18n("modified"));
    toRemove.append("]");
    theCaption.remove(toRemove);
    //   printf("%s\n", theCaption.latin1());
    setCaption(theCaption, m);
}

void KSubtileApp::slotFileQuit()
{
    slotStatusMsg(i18n("Exiting..."));
    saveOptions();
    // close the first window, the list makes the next one the first again.
    // This ensures that queryClose() is called on each window to ask for closing
    KMainWindow* w;
    if(memberList)
    {
        w=memberList->first();
        w->close();
    }

}

void KSubtileApp::slotViewToolBar()
{
    slotStatusMsg(i18n("Toggling toolbar..."));
    ///////////////////////////////////////////////////////////////////
    // turn Toolbar on or off
    if(!viewToolBar->isChecked())
    {
        toolBar("mainToolBar")->hide();
    }
    else
    {
        toolBar("mainToolBar")->show();
    }

    slotStatusMsg(i18n("Ready."));
}

void KSubtileApp::slotViewStatusBar()
{
    slotStatusMsg(i18n("Toggle the statusbar..."));
    ///////////////////////////////////////////////////////////////////
    //turn Statusbar on or off
    if(!viewStatusBar->isChecked())
    {
        statusBar()->hide();
    }
    else
    {
        statusBar()->show();
    }

    slotStatusMsg(i18n("Ready."));
}

void KSubtileApp::slotFileImport()
{

    //show an open dialog
    KURL url=KEncodingFileDialog::getOpenURL(QString::null, i18n("*.utf *.utf8 *.utf-8 *.sub *.srt *.smi *.rt *.txt *.ssa *.aqt *.jss *.ass|Subtitle Files\n*|All Files"), this, i18n("Import Subtitle File..."));
    if(!url.isEmpty())
    {

        fileToImport  = url.path();
        //check if we have a movie file loaded!
        KSubtileView* current = (KSubtileView*) getDocument()->pViewList->first();
        if(current->getPlayer()->l_player_fileName->text().stripWhiteSpace() == "")
        {
            //we don't have a movie name, so ask to select one
            //connect the opened signal
            connect(current->getPlayer(), SIGNAL(movieLoaded(QString)), this, SLOT(slotImportMovieLoaded(QString)));
            current->getPlayer()->pb_player_open_clicked();
        }
        else
        {
            importFile(fileToImport, current->getPlayer()->l_player_fileName->text().stripWhiteSpace());
        }

    }

    //cancelled the import
}

void KSubtileApp::importFile(QString fileName, QString movieFileName)
{
    //we have a subtitle file and a movie file, so use mplayer to convert it to SRT
    KProcess procDump;

    //give mplayer the sub to be converted
    procDump << "mplayer" << "-sub" << fileName;

    //convert to srt format
    procDump << "-dumpsrtsub";

    //make no output and only play the first frame so the movie stops immediately
    procDump << "-vo" << "null" << "-ao" << "null" << "-frames" << "1";
    procDump << movieFileName;

    KTempFile* tmp = new KTempFile();
    tmp->setAutoDelete(true);
    KURL tmpUrl(tmp->name());
    delete tmp;

    //set the right working directory so we find dumpsub.srt
    procDump.setWorkingDirectory(tmpUrl.directory());
    procDump.start(KProcess::Block, KProcess::All);

    procDump.kill();

    slotFileNew();
    //Open the generated file
    getDocument()->openDocument(tmpUrl.directory() + "/dumpsub.srt");

    //delete dumpsub.srt

    KIO::NetAccess::del( KURL(tmpUrl.directory() + "/dumpsub.srt"), this );

    KURL* untitled = new KURL();
    untitled->setFileName(i18n("Untitled"));
    getDocument()->setURL( *untitled );
    getDocument()->setModified(true);

}

void KSubtileApp::slotImportMovieLoaded(QString fileName)
{
    if(fileName != "")
    {
        //movie is loaded! Import the subs!
        importFile(fileToImport, fileName);
    }
    else
    {
        //no movie loaded so no import
    }

    //remove the connection otherwise this slot would always be executed when someone loads a movie
    KSubtileView* current = (KSubtileView*) getDocument()->pViewList->first();
    disconnect(current->getPlayer(), SIGNAL(movieLoaded(QString)), this, SLOT(slotImportMovieLoaded(QString)));
}

void KSubtileApp::slotSettingsCheckForMPlayer()
{
    KSubtileView* current = (KSubtileView*) getDocument()->pViewList->first();

    KProcess *proc = new KProcess;

    *proc << "mplayer";
    QApplication::connect(proc, SIGNAL(processExited(KProcess *)),
                          this, SLOT(slotCheckForMPlayerTest(KProcess *)));

    bool found = proc->start();
    if(!found)
    {
        // 		printf("not found mplayer");
        //disable the player totally
        current->getPlayer()->pb_player_play->setEnabled(false);
        current->getPlayer()->pb_player_pause->setEnabled(false);
        current->getPlayer()->pb_player_stop->setEnabled(false);
        current->getPlayer()->pb_player_backward->setEnabled(false);
        current->getPlayer()->pb_player_forward->setEnabled(false);
        current->getPlayer()->te_player_startTime->setEnabled(false);
        current->getPlayer()->cb_player_withSubtitles->setEnabled(false);
        current->getPlayer()->pb_player_open->setEnabled(false);
        current->getPlayer()->l_player_fileName->setText( QString("") );
        //enable check-for-mplayer menu item
        current->getPlayer()->sl_player_currentPosition->setValue(0);
        current->getPlayer()->sl_player_currentPosition->setEnabled(false);
        // 		settingsCheckForMPlayer->setEnabled(true);
        fileImport->setEnabled(false);
        KMessageBox::sorry(0, i18n("MPlayer not found so player and import are disabled! Make sure the mplayer executable is in your PATH."), i18n("Sorry!"));
        slotStatusMsg(i18n("MPlayer not found so player and import are disabled."));
    }
}

void KSubtileApp::slotCheckForMPlayerTest(KProcess * proc)
{
    if(proc->normalExit())
    {
        if(proc->exitStatus() == 0)
        {
            //ok mplayer started and exited alright
            //      printf("mplayer found!");

            KSubtileView* current = (KSubtileView*) getDocument()->pViewList->first();

            //enable player(enable the open file icon)
            current->getPlayer()->pb_player_open->setEnabled(true);

            fileImport->setEnabled(true);

            slotStatusMsg(i18n("MPlayer was found!"));
        }
    }
}

void KSubtileApp::slotStatusMsg(const QString &text)
{
    ///////////////////////////////////////////////////////////////////
    // change status message permanently
    statusBar()->clear();
    statusBar()->changeItem(text, ID_STATUS_MSG);
}

