/***************************************************************************
                          ksubtiledoc.h  -  description
                             -------------------
    begin                : di feb  4 15:33:11 CET 2003
    copyright            : (C) 2003 by Tom Deblauwe
    email                : tom.deblauwe@pandora.be
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KSUBTILEDOC_H
#define KSUBTILEDOC_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif 

// include files for QT
#include <qobject.h>
#include <qstring.h>
#include <qptrlist.h>
#include <qtextstream.h>
#include <qtextcodec.h>

// include files for KDE
#include <kurl.h>

#include <csubtitles.h>

// forward declaration of the KSubtile classes
class KSubtileView;

/**	KSubtileDoc provides a document object for a document-view model.
  *
  * The KSubtileDoc class provides a document object that can be used in conjunction with the classes KSubtileApp and KSubtileView
  * to create a document-view model for standard KDE applications based on KApplication and KMainWindow. Thereby, the document object
  * is created by the KSubtileApp instance and contains the document structure with the according methods for manipulation of the document
  * data by KSubtileView objects. Also, KSubtileDoc contains the methods for serialization of the document data from and to files.
  * @author Source Framework Automatically Generated by KDevelop, (c) The KDevelop Team.
  * @version KDevelop version 1.2 code generation  */
class KSubtileDoc : public QObject{
  Q_OBJECT
  public:
    /** Constructor for the fileclass of the application */
    KSubtileDoc(QWidget *parent, const char *name=0);
    /** Destructor for the fileclass of the application */
    ~KSubtileDoc();

    /** adds a view to the document which represents the document contents. Usually this is your main view. */
    void addView(KSubtileView *view);
    /** removes a view from the list of currently connected views */
    void removeView(KSubtileView *view);
    /** sets the modified flag for the document after a modifying action on the view connected to the document.*/
    void setModified(bool m=true);
    /** returns if the document is modified or not. Use this to determine if your document needs saving by the user on closing.*/
    bool isModified(){ return modified; };
    /** "save modified" - asks the user for saving if the document is modified */
    bool saveModified();
    /** deletes the document's contents */
    void deleteContents();
    /** initializes the document generally */
    bool newDocument();
    /** closes the acutal document */
    void closeDocument();
    /** loads the document by filename and format and emits the updateViews() signal */
    bool openDocument(const KURL& url, const char *format=0);
    /** saves the document under filename and format.*/
    bool saveDocument(const KURL& url, const char *format=0);
    /** returns the KURL of the document */
    const KURL& URL() const;
    /** sets the URL of the document */
    void setURL(const KURL& url);

  public slots:
    /** calls repaint() on all views connected to the document object and is called by the view by which the document has been changed.
     * As this view normally repaints itself, it is excluded from the paintEvent.     */
    void slotUpdateAllViews(KSubtileView *sender);

  signals:
    void docModified(bool);
    void checkPlayer(void);

  public:
    /** the list of the views currently connected to the document */
    static QPtrList<KSubtileView> *pViewList;
	/** A pointer to the CSubtitles object which represents all loaded subtitles.
	*/
    CSubtitles* subtitles;

    /** the modified flag of the current document */
    bool modified;

    /** the name of the codec for the text in the subtitles */
    QString text_codec;

  private:
    KURL doc_url;
};

#endif // KSUBTILEDOC_H
