/***************************************************************************
                          main.cpp  -  description
                             -------------------
    begin                : di feb  4 15:33:11 CET 2003
    copyright            : (C) 2003 by Tom Deblauwe <tom.deblauwe@pandora.be>
                         : (C) 2005 by Isaac Clerencia <isaac@warp.es>
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <kcmdlineargs.h>
#include <kaboutdata.h>
#include <klocale.h>

#include "ksubtile.h"

static const char *description =
	I18N_NOOP("KSubtile, an SRT subtitle editor");
// INSERT A DESCRIPTION FOR YOUR APPLICATION HERE
	
	
static KCmdLineOptions options[] =
{
  { "+[File]", I18N_NOOP("file to open"), 0 },
  { 0, 0, 0 }
  // INSERT YOUR COMMANDLINE OPTIONS HERE
};

int main(int argc, char *argv[])
{
	KLocale::setMainCatalogue("ksubtile");    

	KAboutData aboutData( "ksubtile", I18N_NOOP("KSubtile"),
		"1.1", description, KAboutData::License_GPL,
		"(c) 2003-2004, Tom Deblauwe", 0, 0, "tom.deblauwe@pandora.be");
	aboutData.addAuthor("Tom Deblauwe", "Main programmer", "tom.deblauwe@pandora.be");
	aboutData.addAuthor("Isaac Clerencia", "Current maintainer", "isaac@warp.es");
	aboutData.addCredit("Dimitris Michail", "Bug fixes & find subtitles in list feature", "michail@mpi-sb.mpg.de");
	KCmdLineArgs::init( argc, argv, &aboutData );
	KCmdLineArgs::addCmdLineOptions( options ); // Add our own options.

	KApplication app;

	if (app.isRestored()) {
		RESTORE(KSubtileApp);
	} else {
		KSubtileApp *ksubtile = new KSubtileApp();
		ksubtile->show();

		KCmdLineArgs *args = KCmdLineArgs::parsedArgs();

		if (args->count()) {
			ksubtile->openDocumentFile(args->arg(0));
		} else {
			ksubtile->openDocumentFile();
		}
		args->clear();
	}

	return app.exec();
}  
