/***************************************************************************
 *   Copyright (C) 2003 by Tom Deblauwe                                    *
 *   tomNOSPAM.deblauwe@pandora.be                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/
#ifndef SELECTFROMLISTDIALOG_H
#define SELECTFROMLISTDIALOG_H

#include <selectfromlistdlg.h>
#include "csubtitle.h"
#include "csubtitles.h"
#include "qlistview.h"

/**
@author Tom Deblauwe
*/
class SelectFromListDialog : public SelectFromListDlg
{
Q_OBJECT
public:

    SelectFromListDialog(QWidget * parent = 0, const char * name = 0, bool modal = false);
    ~SelectFromListDialog();

	CSubtitle* getSubtitle(void);
    void loadSubtitles(CSubtitles* subtitles, CSubtitle* highlightSub);

public slots:
	void slotDoubleClicked(QListViewItem * item);

private:
    virtual void pb_select_clicked(void);
    virtual void pb_cancel_clicked(void);
    virtual void pb_next_clicked(void);
    virtual void cb_case_stateChanged(int);

	//to hold the collection of subtitles
	CSubtitles* subtitles;
    CSubtitle* selectedSubtitle;
    bool caseFind;
};

#endif
