// part of KSUDOKU - by Francesco Rossi <redsh@email.it> 2005
#ifndef SUDOKU_SOLVER_H
#define SUDOKU_SOLVER_H


#define ITERATE(i,s) for(int ((i))=0; ((i))<((s)); ((i))++)
#define RANDOM(x) (int) (x*((float)rand())/(RAND_MAX+1.0f))
//j=1+(int) (10.0*rand()/(RAND_MAX+1.0));
//#define RANDOM(x) std::rand() % ((x))
#define SUDOKU_HARDEST -1
#define SUDOKU_HARD    0
#define SUDOKU_MEDIUM  1
#define SUDOKU_EASY    2
#define LEVINC         2

#define SIMMETRY_RANDOM 0
#define SIMMETRY_NONE 1
#define SIMMETRY_DIAGONAL 2
#define SIMMETRY_CENTRAL 3
#define SIMMETRY_FOURWAY 4

#define SUDOKU  0
#define ROXDOKU 1

#include <stdio.h>
#include <cstdlib>

/**
@author Francesco Rossi
*/

#include <math.h>
//#include "sudoku_types.h"
// SUDOKU PUZZLE SOLVER BASIC ALGORITHM - BY FRANCESCO ROSSI 2005 redsh@email.it
class skBase
{
public:
	int base;
	int order;
	int size;
	char zerochar;
	bool threedimensional;
	void setorder(int k, bool threedimensionalf = false)
	{
		threedimensional = threedimensionalf; 
		order = k; 
		base = (int) sqrt(order); 
		size = threedimensional ?  base*base*base :  (order*order) ;
		if(order>9) zerochar = 'a'-1; else zerochar = '0';};
	skBase(int i=9, bool threedimensionalf = false){setorder(i, threedimensionalf);};
};
class skPuzzle : public skBase
{
public:
	unsigned char numbers[625];
	unsigned char flags[625][26];

	skPuzzle(int oi=9, bool threedimensionalf = false) : skBase(oi,threedimensionalf )
	{
		/*numbers = new (unsigned char ) [size+1];
		flags   = new (unsigned char*) [size];
		ITERATE(j,size) flags[j] = new unsigned char[order+1];*/

		ITERATE(i,size)
		{ 
			numbers[i]=0; 
			ITERATE(j,order+1) flags[i][j]=1;
		}
		
	}
	~skPuzzle()
	{
		/*delete numbers;
		delete []  flags;*/
		
	}
};
class skGraph  : public skBase
{
public:
	bool graph[625][625];
	int optimized_d[625];
	int optimized[625][625]; //pointer-style list of connected nodes
	//int optimized_sc_d;
	//int optimized_sc[25*5][625];
	bool strongly_connected[125][625];
	int  sc_count;
	
	//unsigned int optimized_sc;

	skGraph(int o=9, bool threedimensionalf = false) : skBase(o, threedimensionalf)
	{
		ITERATE(i,size)
		{
			ITERATE(j,size) graph[i][j]=0; 
			optimized_d[i]=0;
		}
	}
};

class skSolver{
public:
    skSolver(int n=9, bool threedimensionalf = false);
    ~skSolver();
	
public:
	skGraph* g;
	int base;
	int size;
	int order;
	char zerochar;
	bool threedimensional;
	
public:
	int remove_numbers(skPuzzle* p, int difficulty, int simmetry, int type);
	int solve(skPuzzle* puzzle,  int max_solutions = 1, skPuzzle* out_solutions = 0, int* forks=0);
	int solve_engine(skPuzzle *s,  int& solutions, skPuzzle* out_solutions = 0, int maxsolutions = 1, int last_add=-1, int dynindex=-1, int dynvalue=0, int* forks=0);
	int init();
	int fscc(bool* visited, bool* done, bool* mask, int node);
	void copy(skPuzzle* dest, skPuzzle* src);
};

extern bool guidedMode;

extern skSolver* solver09;
extern skSolver* solver16;
extern skSolver* solver25;

extern skSolver* solver3d09;
extern skSolver* solver3d16;
extern skSolver* solver3d25;
#endif

