type token =
  | CODE of (string)
  | SNIPPET of (string option * string)
  | IMAGE of (string * string)
  | HREF of (string*string)
  | HEADER of (int*string option*string)
  | WORD of (string)
  | TITLE of (string)
  | ANTIQUOTE of (string)
  | SPACE
  | MANY_NEWLINES
  | NEWLINE
  | LI
  | LEM
  | REM
  | LBF
  | RBF
  | EOF

val doc_title :
  (Lexing.lexbuf  -> token) -> Lexing.lexbuf -> string option * Liqi.doc
