/*
    Copyright (c) 2003, Intel Corporation. All rights reserved.
    Created by:  majid.awad REMOVE-THIS AT intel DOT com
    This file is licensed under the GPL license.  For the full content 
    of this license, see the COPYING file at the top level of this 
    source tree.
 */

/*
 * unamed semaphore is used in subsequent of sem_post.
*/

#include <sys/types.h>
#include <stdio.h>
#include <errno.h>
#include <unistd.h>
#include <semaphore.h>
#include <sys/stat.h>
#include <fcntl.h>
#include "posixtest.h"

#define TEST "2-1"
#define FUNCTION "sem_init"
#define ERROR_PREFIX "unexpected error: " FUNCTION " " TEST ": "


int main ()
{
	sem_t   mysemp;
	unsigned int val;

	if ( sem_init (&mysemp, 0, 0) == -1 ) {
		perror(ERROR_PREFIX "sem_init");
		return PTS_UNRESOLVED;
	}

	if (sem_post(&mysemp) == -1 ) {
		perror(ERROR_PREFIX "trywait");
                return PTS_UNRESOLVED;
        }

        if( sem_getvalue(&mysemp, &val) < 0 ) {
                perror(ERROR_PREFIX "sem_getvalue");
                return PTS_UNRESOLVED;
        }

        if (val == 1 ) {
                puts("TEST PASSED");
		sem_destroy(&mysemp);
                return PTS_PASS;
        } else {
                puts("TEST FAILED");
                return PTS_FAIL;
	}
}

