/***************************************************************************
 $RCSfile$
 -------------------
 cvs         : $Id: chkacc.c 727 2005-12-23 02:16:25Z aquamaniac $
 begin       : Tue May 03 2005
 copyright   : (C) 2005 by Martin Preuss
 email       : martin@libchipcard.de

 ***************************************************************************
 *          Please see toplevel file COPYING for license details           *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#include "globals.h"
#include <gwenhywfar/text.h>



static
int chkIban(AB_BANKING *ab,
            GWEN_DB_NODE *dbArgs,
            int argc,
            char **argv) {
  GWEN_DB_NODE *db;
  int rv;
  AB_BANKINFO_CHECKRESULT res;
  const char *iban;
  const GWEN_ARGS args[]={
  {
    GWEN_ARGS_FLAGS_HAS_ARGUMENT, /* flags */
    GWEN_ArgsType_Char,            /* type */
    "iban",                       /* name */
    1,                            /* minnum */
    1,                            /* maxnum */
    0,                            /* short option */
    "iban",                       /* long option */
    "Specify the IBAN to check",  /* short description */
    "Specify the IBAN to check"   /* long description */
  },
  {
    GWEN_ARGS_FLAGS_HELP | GWEN_ARGS_FLAGS_LAST, /* flags */
    GWEN_ArgsType_Int,             /* type */
    "help",                       /* name */
    0,                            /* minnum */
    0,                            /* maxnum */
    "h",                          /* short option */
    "help",                       /* long option */
    "Show this help screen",      /* short description */
    "Show this help screen"       /* long description */
  }
  };

  db=GWEN_DB_GetGroup(dbArgs, GWEN_DB_FLAGS_DEFAULT, "local");
  rv=GWEN_Args_Check(argc, argv, 1,
                     0 /*GWEN_ARGS_MODE_ALLOW_FREEPARAM*/,
                     args,
                     db);
  if (rv==GWEN_ARGS_RESULT_ERROR) {
    fprintf(stderr, "ERROR: Could not parse arguments\n");
    return 1;
  }
  else if (rv==GWEN_ARGS_RESULT_HELP) {
    GWEN_BUFFER *ubuf;

    ubuf=GWEN_Buffer_new(0, 1024, 0, 1);
    if (GWEN_Args_Usage(args, ubuf, GWEN_ArgsOutType_Txt)) {
      fprintf(stderr, "ERROR: Could not create help string\n");
      return 1;
    }
    fprintf(stderr,
            I18N("This command checks the given combination of account id\n"
                 "and bank code for validity.\n"
                 "\n"
                 "Return codes:\n"
                 " 1: missing/bad arguments\n"
                 " 2: error while initializing AqBanking\n"
                 " 3: given combination is definately invalid\n"
                 " 5: error while deinitializing AqBanking\n"
                 "\n"
                 "Arguments:\n"
                 "%s\n"),
            GWEN_Buffer_GetStart(ubuf));
    GWEN_Buffer_free(ubuf);
    return 0;
  }

  iban=GWEN_DB_GetCharValue(db, "iban", 0, 0);
  assert(iban);

  rv=AB_Banking_Init(ab);
  if (rv) {
    DBG_ERROR(0, "Error on init (%d)", rv);
    return 2;
  }

  res=AB_Banking_CheckIban(iban);
  if (res) {
    DBG_ERROR(0,
              "IBAN is invalid");
    return 3;
  }

  rv=AB_Banking_Fini(ab);
  if (rv) {
    fprintf(stderr, "ERROR: Error on deinit (%d)\n", rv);
    return 5;
  }

  return 0;
}






