/**
 * =========================================
 * LibFormula : a free Java formula library
 * =========================================
 *
 * Project Info:  http://reporting.pentaho.org/libformula/
 *
 * (C) Copyright 2006-2008, by Pentaho Corporation and Contributors.
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * [Java is a trademark or registered trademark of Sun Microsystems, Inc.
 * in the United States and other countries.]
 *
 *
 * ------------
 * ContextLookup.java
 * ------------
 */
package org.pentaho.reporting.libraries.formula.lvalues;

import org.pentaho.reporting.libraries.formula.typing.Type;
import org.pentaho.reporting.libraries.formula.typing.coretypes.ErrorType;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.EvaluationException;

/**
 * A reference that queries the datarow.
 *
 * @author Thomas Morgner
 */
public class ContextLookup extends AbstractLValue
{
  private String name;
  private static final long serialVersionUID = 2882834743999159722L;

  public ContextLookup(final String name)
  {
    this(name, null);
  }
  public ContextLookup(final String name, final ParsePosition parsePosition)
  {
    this.name = name;
    setParsePosition(parsePosition);
  }

  public TypeValuePair evaluate() throws EvaluationException
  {
    final FormulaContext context = getContext();
    final Object value = context.resolveReference(name);
    final Type type = context.resolveReferenceType(name);
    return new TypeValuePair(type, value);
  }

  public Type getValueType()
  {
    try
    {
      final FormulaContext context = getContext();
      return context.resolveReferenceType(name);
    }
    catch (final EvaluationException evalex)
    {
      // exception ignored.
      return ErrorType.TYPE;
    }
  }

  public String toString()
  {
    return '[' +  name + ']';
  }

  /**
   * Checks whether the LValue is constant. Constant lvalues always return the
   * same value.
   *
   * @return
   */
  public boolean isConstant()
  {
    return false;
  }

  public String getName()
  {
    return name;
  }
}
