/*--------------------------------------------------------------------*//*:Ignore this sentence.
Copyright (C) 1999, 2001 SIL International. All rights reserved.

Distributable under the terms of either the Common Public License or the
GNU Lesser General Public License, as specified in the LICENSING.txt file.

File: PangoTextSrc.cpp
Responsibility: Daniel Glassey
Last reviewed: Not yet.

Description:
	A simple text source that shows how to use this interface within Graphite.
-------------------------------------------------------------------------------*//*:End Ignore*/

//:>********************************************************************************************
//:>	Include files
//:>********************************************************************************************
// any other headers (not precompiled)

#include <graphite/GrClient.h>
#include <graphite/GrDebug.h>
#include <graphite/ITextSource.h>
#include "PangoTextSrc.h"

#undef THIS_FILE
DEFINE_THIS_FILE

namespace gr {

//:>********************************************************************************************
//:>	Forward declarations
//:>********************************************************************************************

//:>********************************************************************************************
//:>	Methods: old interface
//:>********************************************************************************************

/*----------------------------------------------------------------------------------------------
	Constructors.
----------------------------------------------------------------------------------------------*/
PangoTextSrc::PangoTextSrc(const char * pszText, int bytelength, int rtl, const char *language)
{
	m_cchLength = bytelength;
	m_prgchText = new gchar[bytelength + 1];
	std::copy(pszText, pszText + bytelength, m_prgchText);
	m_prgchText[bytelength] = 0; // zero-terminate
    m_fRtl = rtl;
}

PangoTextSrc::PangoTextSrc(PangoTextSrc & textsrc) : 
	m_cchLength(textsrc.getLength()), m_langid(textsrc.getLanguage(0))
{
	m_prgchText = new gchar[m_cchLength + 1];
	std::copy(textsrc.getText(), textsrc.getText() + m_cchLength, m_prgchText);
	m_prgchText[m_cchLength] = 0; // zero-terminate
    m_fRtl = textsrc.getRightToLeft(0);
}


/*----------------------------------------------------------------------------------------------
	Destructor.
----------------------------------------------------------------------------------------------*/
PangoTextSrc::~PangoTextSrc()
{
	delete[] m_prgchText;
}

//:>********************************************************************************************
//:>	Methods: new interface
//:>********************************************************************************************
#include <glib.h>
/*----------------------------------------------------------------------------------------------
	Get the specified range of text
----------------------------------------------------------------------------------------------*/
size_t PangoTextSrc::fetch(toffset ichMin, size_t cch, gr::utf8 * prgchwBuffer)
{
	size_t ichRet = std::min(cch, static_cast<size_t>(m_cchLength - ichMin));
	
	std::copy(m_prgchText + ichMin, m_prgchText + ichMin + ichRet, prgchwBuffer);
	return ichRet;
}

/*----------------------------------------------------------------------------------------------
	Fill in the buffer with the font face name at the given character position.
	Return the number of characters needed, whether or not there is room.
----------------------------------------------------------------------------------------------*/
GrResult PangoTextSrc::getFaceName(int ich, unsigned int cchMax,
	gr::utf16 * prgchFaceName, unsigned int * pcchLen)
{
	Assert(false); // eventually this method will be removed from the interface
	return gr::kresNotImpl;
}


/*----------------------------------------------------------------------------------------------
	Return language
----------------------------------------------------------------------------------------------*/
isocode PangoTextSrc::getLanguage(toffset ich)
{
  return m_langid;
}

/*----------------------------------------------------------------------------------------------
	Return true if the text uses a right-to-left writing system.
----------------------------------------------------------------------------------------------*/
bool PangoTextSrc::getRightToLeft(toffset ich)
{
	return m_fRtl;
}

/*----------------------------------------------------------------------------------------------
	Return the depth of embedding of the writing system.
----------------------------------------------------------------------------------------------*/
unsigned int PangoTextSrc::getDirectionDepth(toffset ich)
{
	if (m_fRtl)
		return 1;
	else;
		return 0;
}

/*----------------------------------------------------------------------------------------------
	Return the vertical offset of the text. This simple implementation provides no
	vertical offset.
----------------------------------------------------------------------------------------------*/
float PangoTextSrc::getVerticalOffset(toffset ich)
{
	return 0;
}

}; //namespace gr
