/**
 * ===========================================================
 * LibRepository : a free Java content repository access layer
 * ===========================================================
 *
 * Project Info:  http://reporting.pentaho.org/librepository/
 *
 * (C) Copyright 2006-2008, by Pentaho Corporation and Contributors.
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * [Java is a trademark or registered trademark of Sun Microsystems, Inc.
 * in the United States and other countries.]
 *
 * ------------
 * ContentCreationException.java
 * ------------
 */

package org.pentaho.reporting.libraries.repository;

/**
 * A exception that indicates that a new ContentEntry could not be created in the repository.
 *
 * @author Thomas Morgner
 */
public class ContentCreationException extends ContentIOException
{
  private static final long serialVersionUID = 8817127426694197164L;

  /**
   * Creates a ContentCreationException with no message and no parent.
   */
  public ContentCreationException()
  {
  }

  /**
   * Creates an ContentCreationException.
   *
   * @param message the exception message.
   * @param ex      the parent exception.
   */
  public ContentCreationException(final String message, final Exception ex)
  {
    super(message, ex);
  }

  /**
   * Creates an ContentCreationException.
   *
   * @param message the exception message.
   */
  public ContentCreationException(final String message)
  {
    super(message);
  }
}
