#ifndef MSWATCH_CONFIG_H
#define MSWATCH_CONFIG_H

#include <map>
#include <string>

#include <time.h>

#include "mailstore_watcher.h"

using std::map;
using std::string;

#define NWATCHERS 2

class mswatch_config
{
  public:
	mswatch_config();
	~mswatch_config();

	bool dry;
	bool quiet;
	time_t base_delay;
	time_t default_inter_delay;
	map<string, time_t> inter_delays; // mailbox_name->delay
	time_t max_delay;
	char** sync_bin;
	char* mailbox_prefix[2];
	unsigned sync_bin_len;
	struct mailstore_config store[NWATCHERS];
};

#endif // MSWATCH_CONFIG_H
