/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.rte.comm;

import com.sap.dbtech.jdbc.DriverSapDB;
import com.sap.dbtech.rte.comm.BasicSocketComm;
import com.sap.dbtech.rte.comm.JdbcCommFactory;
import com.sap.dbtech.rte.comm.JdbcCommunication;
import com.sap.dbtech.rte.comm.RTEException;
import com.sap.dbtech.rte.comm.RteC;
import com.sap.dbtech.util.MessageTranslator;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Properties;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.security.auth.x500.X500Principal;

public class SecureCommunication
extends BasicSocketComm {
    public static final JdbcCommFactory factory = new JdbcCommFactory(){

        public JdbcCommunication open(String string, String string2, Properties properties) throws RTEException {
            SecureCommunication secureCommunication = new SecureCommunication(string, properties);
            secureCommunication.connectDB(string2);
            return secureCommunication;
        }

        public JdbcCommunication xopen(String string, String string2, String string3, String string4, Properties properties) throws RTEException {
            SecureCommunication secureCommunication = new SecureCommunication(string, properties);
            secureCommunication.connectAdmin(string2, string3, string4);
            return secureCommunication;
        }
    };
    private boolean ignoreServerCertificate;
    private boolean ignoreHostNameInCertificate;

    private SecureCommunication(String string, Properties properties) throws RTEException {
        super(string, properties);
        this.ignoreHostNameInCertificate = DriverSapDB.getBooleanProperty(properties, "ignoreHostNameInCert", false);
        this.ignoreServerCertificate = DriverSapDB.getBooleanProperty(properties, "acceptServerCertAlways", false);
        this.openSocket();
    }

    protected void openSocket() throws RTEException {
        try {
            Object object;
            SSLContext sSLContext = null;
            SSLSocketFactory sSLSocketFactory = null;
            if (this.ignoreServerCertificate) {
                object = new TrustManager[]{new X509TrustManager(){

                    public X509Certificate[] getAcceptedIssuers() {
                        return null;
                    }

                    public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) {
                    }

                    public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) {
                    }
                }};
                sSLContext = SSLContext.getInstance("SSL");
                sSLContext.init(null, (TrustManager[])object, new SecureRandom());
                sSLSocketFactory = sSLContext.getSocketFactory();
            } else {
                sSLSocketFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
            }
            this.socket = sSLSocketFactory.createSocket(this.host, this.lookupPort());
            object = (SSLSocket)this.socket;
            ((SSLSocket)object).startHandshake();
            if (!this.ignoreHostNameInCertificate) {
                Certificate[] certificateArray = ((SSLSocket)object).getSession().getPeerCertificates();
                if (certificateArray.length == 0) {
                    throw new RTEException(MessageTranslator.translate("error.host.connect", this.host, "No certificate in SSL session", new Integer(RteC.CommunicationErrorCodeMap_C[5])), RteC.CommunicationErrorCodeMap_C[5]);
                }
                try {
                    X509Certificate x509Certificate = (X509Certificate)certificateArray[0];
                    X500Principal x500Principal = x509Certificate.getSubjectX500Principal();
                    String string = x500Principal.getName("RFC2253");
                    if (!this.validate(string, this.host)) {
                        throw new RTEException(MessageTranslator.translate("error.host.connect", this.host, "Host name verification failed, found " + string + ", expected CN=" + this.host, new Integer(RteC.CommunicationErrorCodeMap_C[5])), RteC.CommunicationErrorCodeMap_C[5]);
                    }
                }
                catch (ClassCastException classCastException) {
                    throw new RTEException(MessageTranslator.translate("error.host.connect", this.host, "SSL connection works currently only with X509 certificates", new Integer(RteC.CommunicationErrorCodeMap_C[5])), RteC.CommunicationErrorCodeMap_C[5]);
                }
            }
            try {
                ((Socket)object).setSoTimeout(this.socketTimeOut);
                ((Socket)object).setTcpNoDelay(true);
                ((Socket)object).setReceiveBufferSize(36864);
                ((Socket)object).setSendBufferSize(36864);
            }
            catch (SocketException socketException) {
                // empty catch block
            }
            this.instream = this.socket.getInputStream();
            this.outstream = this.socket.getOutputStream();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RTEException(MessageTranslator.translate("error.host.connect", this.host, noSuchAlgorithmException.getMessage(), new Integer(RteC.CommunicationErrorCodeMap_C[5])), RteC.CommunicationErrorCodeMap_C[5]);
        }
        catch (KeyManagementException keyManagementException) {
            throw new RTEException(MessageTranslator.translate("error.host.connect", this.host, keyManagementException.getMessage(), new Integer(RteC.CommunicationErrorCodeMap_C[5])), RteC.CommunicationErrorCodeMap_C[5]);
        }
        catch (UnknownHostException unknownHostException) {
            throw new RTEException(MessageTranslator.translate("error.unknown.host", this.host, unknownHostException.getMessage(), new Integer(RteC.CommunicationErrorCodeMap_C[13])), RteC.CommunicationErrorCodeMap_C[13]);
        }
        catch (IOException iOException) {
            throw new RTEException(MessageTranslator.translate("error.host.connect", this.host, iOException.getMessage(), new Integer(RteC.CommunicationErrorCodeMap_C[5])), RteC.CommunicationErrorCodeMap_C[5]);
        }
    }

    private boolean validate(String string, String string2) {
        int n = string.indexOf(",");
        String string3 = string.substring(0, n).toUpperCase();
        String string4 = ("CN=" + string2).toUpperCase();
        return string4.equals(string3);
    }

    protected BasicSocketComm getNewCommunication() throws RTEException {
        return new SecureCommunication(this.host + ":" + this.port, null);
    }

    protected int getDefaultPort() {
        return 7270;
    }

    protected boolean socketMustClosedAfterInfoRequest() {
        return true;
    }
}

