/* Copyright (C) 2005 MySQL AB

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA */

#ifndef _MWLAYERTREE_H_
#define _MWLAYERTREE_H_

#include <gtkmm/treeview.h>
#include <gtkmm/treestore.h>
#include <gtkmm/treerowreference.h>
#include <MySQLGRT/MGRT.h>
#include <map>

class MWLayerTree : public Gtk::TreeView {
    class Columns : public Gtk::TreeModel::ColumnRecord {
      public:
        Columns() {
          add(icon);
          add(text);
          add(grt);
          add(object);
          add(is_layer);
          add(color);
        };
        Gtk::TreeModelColumn<Glib::RefPtr<Gdk::Pixbuf> > icon;
        Gtk::TreeModelColumn<Glib::ustring> text;
        Gtk::TreeModelColumn<MYX_GRT_VALUE*> grt;
        Gtk::TreeModelColumn<MYX_GRT_VALUE*> object;
        Gtk::TreeModelColumn<bool> is_layer;
        Gtk::TreeModelColumn<Glib::ustring> color;
    } _columns;

    MGRT *_grt;
    
    Glib::RefPtr<Gtk::TreeStore> _store;

    std::map<Glib::ustring, Glib::ustring> _color_value;
    
    MYX_GRT_VALUE *_root_layer;
    
    Glib::RefPtr<Gdk::Pixbuf> _layer_icon;
    Glib::RefPtr<Gdk::Pixbuf> _routine_icon;
    Glib::RefPtr<Gdk::Pixbuf> _table_icon;
    Glib::RefPtr<Gdk::Pixbuf> _view_icon;
    
    std::map<MYX_GRT_VALUE*,Gtk::TreeRowReference> _value_rows;
    
    void update_element(Gtk::TreeIter &iter, MYX_GRT_VALUE *elem);
    
    bool compare_object(const Gtk::TreeIter &iter, Gtk::TreeIter *found,
                        MYX_GRT_VALUE *object);
    
    Gtk::TreeIter get_parent_layer(MYX_GRT_VALUE *layer);
    MYX_GRT_VALUE *find_new_parent_layer(MYX_GRT_VALUE *layer, MYX_GRT_VALUE *root=0);
    
    
    void rescan_children(const MGRTValue &child, Gtk::TreeIter &node);

    void select_items_in_list(Gtk::TreeIter iter, MYX_GRT_VALUE **value, int count);
  public:
    MWLayerTree(GtkTreeView *tree);

    void set_grt(MGRT *grt);
    void change(MYX_GRT_VALUE *root_layer, Glib::RefPtr<Gtk::TreeStore> model);
    
    MYX_GRT_VALUE *root_layer() { return _root_layer; };
   
    Glib::RefPtr<Gtk::TreeStore> create_model();
    
    void rescan(MGRTValue root);

    void handle_element_add(MYX_GRT_VALUE *elem);
    void handle_element_change(MYX_GRT_VALUE *elem);
    void handle_element_delete(MYX_GRT_VALUE *elem);

    Gtk::TreeIter handle_layer_add(MYX_GRT_VALUE *layer);
    void handle_layer_change(MYX_GRT_VALUE *layer);
    void handle_layer_delete(MYX_GRT_VALUE *layer);
    void handle_layer_move(MYX_GRT_VALUE *layer);
    
    void select_objects(MYX_GRT_VALUE**objects, int count);
    std::list<MYX_GRT_VALUE*> get_selected_objects();
    
    
    void set_color_values(const std::map<Glib::ustring,Glib::ustring> &color_values);
};

#endif /* _MWLAYERTREE_H_ */
