//
//  MWEditCanvasView.mm
//  MySQL Workbench
//
//  Created by Alfredo Kojima on 05/9/8.
//  Copyright 2005 MySQL AB. All rights reserved.
//

#import "MWEditCanvasView.h"
#import <MySQLGRT/MGRTValue.h>
#import <MySQLGRT/MGRTTreeDataSource.h>


@implementation MWEditCanvasView


- (void)setMarker:(id)sender
{
  [super setMarker:sender];
  
  [_statusText setStringValue:[NSString stringWithFormat:@"Stored marker %i",[sender tag]]];
}


- (void)goToMarker:(id)sender
{
  [super goToMarker:sender];
  
  [_statusText setStringValue:[NSString stringWithFormat:@"Restored marker %i",[sender tag]]];  
}


- (void)setStatusText:(NSTextField*)text
{
  _statusText= text;
}


- (void)setStatus:(NSString*)text
{
  [_statusText setStringValue:text];
}


- (BOOL)hasSelection
{
  MGRTValue viewRef(MGRTValue::fromGlobal([_grt grt], "/workbench/model/currentView"));
  MGRTValue selection(MGRTValue::refObject([_grt grt], viewRef.asString())["selection"]);
  
  if (selection.count() > 0)
    return YES;
  return NO;
}


- (BOOL)validateMenuItem:(id <NSMenuItem>)menuItem
{
  if ([menuItem action] == @selector(deleteSelection:))
    return [self hasSelection];

  if ([menuItem action] == @selector(alignToGrid:))
    return NO;
    //return [self hasSelection];

  if ([menuItem action] == @selector(bringToFront:))
    return [self hasSelection];
  
  if ([menuItem action] == @selector(autoArrangeElements:) && [menuItem tag] == 51)
    return [self hasSelection];
    
  if ([menuItem action] == @selector(setMarker:))
    return YES;
  else if ([menuItem action] == @selector(goToMarker:))
    return [self hasMarker:[menuItem tag]];

  return YES;
}

- (void)deleteSelection:(id)sender
{
  [_grt performModule:@"Workbench"
            procedure:@"deleteSelection"
            arguments:nil];
}



- (NSDragOperation)draggingEntered:(id <NSDraggingInfo>)sender
{
  NSArray *items= [[sender draggingPasteboard] propertyListForType:MGRTTreeNodePboardType];
  int i;
  for (i= 0; i < [items count]; i++)
  {
    NSString *objId= [items objectAtIndex:i];
    MYX_GRT_VALUE *object;
    object= myx_grt_reference_cache_lookup([_grt grt], [objId UTF8String]);
    
    if (object && 
        (myx_grt_dict_struct_is_or_inherits_from([_grt grt], object, "db.Table")
         || myx_grt_dict_struct_is_or_inherits_from([_grt grt], object, "db.View")
         || myx_grt_dict_struct_is_or_inherits_from([_grt grt], object, "db.Routine")))      
      return NSDragOperationGeneric;
  }
  
  return NSDragOperationNone;
}


- (NSDragOperation)draggingUpdated:(id <NSDraggingInfo>)sender
{
  return NSDragOperationGeneric;
}


- (void)draggingExited:(id <NSDraggingInfo>)sender
{
}


- (BOOL)prepareForDragOperation:(id <NSDraggingInfo>)sender
{
  return YES;
}


- (void)keyDown:(NSEvent*)event
{
  if (![_delegate editCanvas:self keyDown:event])
    [super keyDown:event];
}


- (BOOL)performDragOperation:(id <NSDraggingInfo>)sender
{
  NSArray *items= [[sender draggingPasteboard] propertyListForType:MGRTTreeNodePboardType];
  int i;
  MYX_GRT_VALUE *dropList= myx_grt_list_new(MYX_DICT_VALUE, NULL);
  
  for (i= 0; i < [items count]; i++)
  {
    NSString *objId= [items objectAtIndex:i];
    MYX_GRT_VALUE *object;
    
    object= myx_grt_reference_cache_lookup([_grt grt], [objId UTF8String]);
    if (object && 
        (myx_grt_dict_struct_is_or_inherits_from([_grt grt], object, "db.Table")
         || myx_grt_dict_struct_is_or_inherits_from([_grt grt], object, "db.View")
         || myx_grt_dict_struct_is_or_inherits_from([_grt grt], object, "db.Routine")))
    {
      myx_grt_list_item_add(dropList, object);
    }
  }
  
  NSPoint dropPoint= [self convertToCanvasPoint:[self convertPoint:[sender draggingLocation]
                                                          fromView:nil]];
  
  [_grt performModule:@"Workbench"
            procedure:@"arrangeObjectsOnCurrentView"
            arguments:[NSArray arrayWithObjects:
              [NSValue valueWithPointer:dropList],
              [NSNumber numberWithFloat:dropPoint.x],
              [NSNumber numberWithFloat:dropPoint.y],
              nil]];
  
  return YES;
}


- (void)selectAll:(id)sender
{
  [_grt performModule:@"Workbench" procedure:@"selectAll" arguments:nil];
}


- (void)bringToFront:(id)sender
{
  if ([sender tag] == 50)
  {
    [_grt performModule:@"Workbench"
              procedure:@"bringSelectionToFront"
              arguments:nil];
  }
  else
  {
    [_grt performModule:@"Workbench"
              procedure:@"sendSelectionToBack"
              arguments:nil];    
  }
}


- (void)alignToGrid:(id)sender
{
}


- (void)autoArrangeElements:(id)sender
{
  BOOL selected;
  NSArray *array;
  if ([sender tag] == 50)
    selected= NO;
  else
    selected= YES;
  
  array= [NSArray arrayWithObjects:[_grt globalGRTRefValue:"/workbench/model/currentView"],
    [NSNumber numberWithInt:selected?1:0], nil];
  
  [_grt performModule:@"WorkbenchController"
            procedure:@"arrangeObjects"
            arguments:array];
}

@end
