#ifndef MYX_SQL_TREE_ITEM
#define MYX_SQL_TREE_ITEM

//#include "../source/myx_sql_parser.tab.hh"
//typedef yytokentype TokenName;

#include "myx_sql_parser_public_interface.h"

#ifdef __cplusplus
extern "C" {
#endif

extern void *new_simple_tree_item(const void *name, const void *value);
extern void *new_tree_item(const void *name, const void *value, void *list);
extern void delete_tree_item(void *tree_item_list);

extern void *new_tree_item_list();
extern void *new_tree_item_list_reuse(void *tree_item_from);
extern void tree_item_list_add(void *tree_item_list, void *tree_item);
extern void tree_item_list_add_all(void *tree_item_list, void *tree_item);

#ifdef __cplusplus
}
#endif


#ifdef __cplusplus

#include <list>
#include <iostream>
#include <string.h>

// pattern "composite"
class MyxSQLTreeItem
{
public:

  typedef std::list<MyxSQLTreeItem *> SubItemList;

protected:

  mutable bool _del_list; // not a part of business object
  char *_name;
  char *_value;
  SubItemList* _subitems;

public:

  MyxSQLTreeItem(const char *name, const char *value, SubItemList *items) 
    : _subitems(items), _name(strcpy(new char[strlen(name)+1], name)), _value(strcpy(new char[strlen(value)+1], value)), _del_list(true)
  {}
  
  virtual ~MyxSQLTreeItem() 
  {
    delete[] _name;
    delete[] _value; 
    if(_del_list)
    {
      delete _subitems;
    }
  }

  virtual bool name_equals(const char *to) const { return strcmp(_name, to) == 0 ? true: false; }

  virtual const char *get_name() const { return _name; }
  
  virtual const char *get_value() const { return _value; }
  
  virtual const SubItemList *get_subitems() const { return _subitems; }

  virtual const MyxSQLTreeItem *get_subitem_by_name(const char *name);
  virtual const MyxSQLTreeItem *rget_subitem_by_name(const char *name); // reverse

  virtual void del_list(bool del_list) const { _del_list= del_list; }

  friend void *new_tree_item_list();
};

class MyxSQLSimpleTreeItem : public MyxSQLTreeItem 
{
  static SubItemList _empty_list;

public:

  MyxSQLSimpleTreeItem(const char *name, const char *value) : MyxSQLTreeItem(name, value, 0) {} 
  
  virtual const SubItemList *get_subitems() const { return &_empty_list; }

  friend void *new_tree_item_list_reuse(void *tree_item_from);
};

MYX_PUBLIC_FUNC std::ostream& operator << (std::ostream&, const MyxSQLTreeItem&);

//////////////////////////////////////////////////////////////////////////////////////////////////
// Helper Classes

class MyxSchemaTreeItemHelperBase
{
protected:
  static bool check1word(MyxSQLTreeItem *tree, const char *w1);
  static bool check2words(MyxSQLTreeItem *tree, const char *w1, const char *w2);
};

class MYX_PUBLIC_FUNC MyxCreateSchemaTreeItem : public MyxSchemaTreeItemHelperBase
{
  MyxSQLTreeItem *_item;

  const char *schema_name;

public:

  static bool check(MyxSQLTreeItem *tree);

  MyxCreateSchemaTreeItem(MyxSQLTreeItem *tree);
  ~MyxCreateSchemaTreeItem();

  const char *get_schema_name() const { return schema_name; } 
};

class MYX_PUBLIC_FUNC MyxCreateTableTreeItem : public MyxSchemaTreeItemHelperBase
{
  MyxSQLTreeItem *_item;

  const char *schema_name;
  const char *table_name;
  const char *table_engine;
  const char *row_format;
  const char *next_auto_inc;
  const char *def_collation;
  const char *delay_key_write;
  const char *comment;
  bool temporary;

public:

  static bool check(MyxSQLTreeItem *tree);

  MyxCreateTableTreeItem(MyxSQLTreeItem *tree);
  ~MyxCreateTableTreeItem();

  const char *get_schema_name() const { return schema_name; } 
  const char *get_table_name() const { return table_name; } 
  const char *get_table_engine() const { return table_engine; } 
  const char *get_row_format() const { return row_format; } 
  const char *get_next_auto_inc() const { return next_auto_inc; } 
  const char *get_def_collation() const { return def_collation; }
  const char *get_delay_key_write() const { return delay_key_write; }
  const char *get_comment() const { return comment; }
  bool is_temporary() const { return temporary; }
};

class MYX_PUBLIC_FUNC MyxUseSchemaTreeItem : public MyxSchemaTreeItemHelperBase
{
  MyxSQLTreeItem *_item;

  const char *schema_name;

public:

  static bool check(MyxSQLTreeItem *tree);

  MyxUseSchemaTreeItem(MyxSQLTreeItem *tree);
  ~MyxUseSchemaTreeItem();

  const char *get_schema_name() const { return schema_name; } 
};

#endif // __cplusplus


#endif // MYX_SQL_TREE_ITEM