unit MyxViewEditor;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, TntStdCtrls, UniCodeEditor, ComCtrls, TntComCtrls,
  UCEHighlighter, UCESQLHighlighter, ExtCtrls, TntExtCtrls,
  MyxEditor, ActnList, TntActnList;

type
  TMyxViewEditorForm = class(TMyxEditorForm)
    BottomPnl: TTntPanel;
    ApplyChangesBtn: TTntButton;
    CancelBtn: TTntButton;
    HeaderPnl: TTntPanel;
    NameLbl: TTntLabel;
    NameEd: TTntEdit;
    LeftPnl: TTntPanel;
    RightPnl: TTntPanel;
    PageControl: TTntPageControl;
    SQLTabSheet: TTntTabSheet;
    CommentTabSheet: TTntTabSheet;
    CommentMemo: TTntMemo;
    SqlUce: TUniCodeEdit;
    UCESQLHighlighter: TUCESQLHighlighter;
    TntActionList1: TTntActionList;
    ApplyChangesAndCloseAction: TTntAction;
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormDestroy(Sender: TObject);
    procedure ApplyChangesBtnClick(Sender: TObject);
    procedure CancelBtnClick(Sender: TObject);
    procedure DataChange(Sender: TObject);
    procedure ApplyChangesAndCloseActionExecute(Sender: TObject);
  private
    { Private declarations }
  protected
    procedure SetModified(Modified: Boolean); override;
    procedure DoSqlUceChange(Sender: TObject; Line: TUCELine);
  public
    { Public declarations }
    procedure StartEditObject(Obj: Pointer); override;
    procedure ApplyChanges; override;
  end;

var
  MyxViewEditorForm: TMyxViewEditorForm;

implementation

{$R *.dfm}

// -----------------------------------------------------------------------------

procedure TMyxViewEditorForm.FormCreate(Sender: TObject);

begin
  PageControl.ActivePageIndex := 0;

  SqlUce.Content.OnChangeLine := DoSqlUceChange;
end;

// -----------------------------------------------------------------------------

procedure TMyxViewEditorForm.FormDestroy(Sender: TObject);

begin
  //
end;

// -----------------------------------------------------------------------------

procedure TMyxViewEditorForm.FormClose(Sender: TObject;
  var Action: TCloseAction);

begin
  Action := caFree;
end;

// -----------------------------------------------------------------------------

procedure TMyxViewEditorForm.StartEditObject(Obj: Pointer);

begin
  inherited;

  NameEd.Text := Grt.DictString[Obj, 'name'];

  SqlUce.Content.Text := Grt.DictString[Obj, 'queryExpression'];

  CommentMemo.Text := Grt.DictString[Obj, 'comment'];
end;

// -----------------------------------------------------------------------------

procedure TMyxViewEditorForm.SetModified(Modified: Boolean);

begin
  inherited;

  ApplyChangesBtn.Enabled := Modified;
end;

// -----------------------------------------------------------------------------

procedure TMyxViewEditorForm.ApplyChanges;

begin
  if (NameEd.Text <> '') then
    Grt.DictString[Obj, 'name'] := NameEd.Text;

  Grt.DictString[Obj, 'queryExpression'] := SqlUce.Content.Text;

  Grt.DictString[Obj, 'comment'] := CommentMemo.Text;

  inherited;
end;

// -----------------------------------------------------------------------------

procedure TMyxViewEditorForm.ApplyChangesBtnClick(Sender: TObject);

begin
  ApplyChanges;
end;

// -----------------------------------------------------------------------------

procedure TMyxViewEditorForm.CancelBtnClick(Sender: TObject);

begin
  Close;
end;

// -----------------------------------------------------------------------------

procedure TMyxViewEditorForm.DoSqlUceChange(Sender: TObject; Line: TUCELine);

begin
  Modified := True;
end;

// -----------------------------------------------------------------------------

procedure TMyxViewEditorForm.DataChange(Sender: TObject);

begin
  Modified := True;
end;

// -----------------------------------------------------------------------------

procedure TMyxViewEditorForm.ApplyChangesAndCloseActionExecute(
  Sender: TObject);

begin
  ApplyChanges;
  Close;
end;

end.
