#!/usr/bin/perl -w

# ng-rmrrd.pl - deleting of hashed rrd filenames
# Copyright (C) 2004, NETWAYS GmbH, Gerd Mueller, Marius Hein
# $Id: ngrmrrd.pl 619 2006-01-10 14:26:46Z mhein $
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

use NagiosGrapher;
use strict;
use File::Basename;
use Getopt::Long;
use Data::Dumper;

my $VERSION = '1.0';
my $PROGNAME = basename($0);

my $ng = new NagiosGrapher();

my $host = undef;
my $service = undef;
my $list = undef;
my $help = undef;
my $force = undef;

Getopt::Long::Configure('bundling');
GetOptions (
	'help'		=> \$help,
	'h'			=> \$help,
	
	'service=s' => \$service,
	's=s'		=> \$service,
	
	'host=s'	=> \$host,
	'H=s'		=> \$host,
	
	'list'		=> \$list,
	'l'			=> \$list,
	
	'force'		=> \$force,
);

if ($help) {
print "
$PROGNAME ($VERSION) - removes the rrds and the xml entries.

Usage: $PROGNAME -H <host> [ -s <service> ] [ -l ]

	-h		--help		Show's this screen
	-s		--service	The service
	-H		--host		The host
	-l		--list		Only lists the services no deletion.
	
$PROGNAME v$VERSION, Copyright (C) 2004 NETWYS GmbH, GPLv2\n";
	exit (0);
}

unless ($host) {
	print "Too few arguments. Try '$PROGNAME --help' for further information.\n";
}
else {
    $ng->read_ngrapher_cfg();
    $ng->read_ngrapher_def();
    $ng->read_ngrapher_xml();
    $ng->read_nagios_cfg($ng->get_ngraphercfg_value('nagios_config'));
    
    my $h = $ng->get_ngrapherxml();
    my $rrd_path = $ng->get_ngraphercfg_value('rrdpath');
    my $tmp_path = $ng->get_ngraphercfg_value('tmppath');
    
    my $xml_file = $rrd_path. 'index.xml';
    my $tmp_file = $tmp_path. '$PROGNAME.tmp';
    
    while (my ($host_name, $host_hash) = each(%{$h->{host}})) {
    	if ($host_name eq $host) {
    		$rrd_path .= $host_name. '/';
    		while (my ($service_name, $service_hash) = each(%{$host_hash->{'service'}})) {
    			my $rrd_file = $service_hash->{'rrd_file'};
    			if (defined $service && $service eq $service_name || !defined $service && $force || !defined $service && defined $list) {
    				unless (defined $list) {
    					system ('rm', '-f', $rrd_path.$rrd_file);
    					delete $h->{host}->{$host_name}->{service}->{$service_name};
    				}
    				elsif (defined $list) {
	    				print "$host_name ($service_name): $rrd_path$rrd_file\n";
    				}
    			}
    			elsif (!defined $service && !$force) {
    				print "You have to use '$PROGNAME --force' to delete all service from a host.\n";
    				exit (0);
    			}
    		}
    	}
    }
    
    $ng->write_ngrapherxml($tmp_file, $xml_file, $h);
}

exit (0);