/* OpenCP Module Player
 * copyright (c) '94-'05 Niklas Beisert <nbeisert@physik.tu-muenchen.de>
 *
 * Frames per second lock
 *
 * revision history: (please note changes here)
 *  -ss050118   Stian Skjelstad <stian@nixia.no>
 *    -first release
 */

#include "config.h"
#include "types.h"
#include <sys/time.h>
#include <unistd.h>
#include "boot/plinkman.h"
#include "boot/pmain.h"
#include "boot/psetting.h"
#include "stuff/err.h"
#include "framelock.h"
#ifdef DISABLE_SIGALRM
#include "timer.h"
#endif

static int fps=20;

static int fpsInit(void)
{
	fps=cfGetProfileInt("screen", "fps", 20, 0);
	if (fps<=0)
		fps=20;
	return errOk;
}

static void fpsDone(void)
{
}

void framelock(void)
{
	static struct timeval target = {0, 0};
	static struct timeval curr;
rerun:
	gettimeofday(&curr, 0);
	if (curr.tv_sec!=target.tv_sec)
	{
		target.tv_sec=curr.tv_sec;
		target.tv_usec=1000000/fps;
		return;
	} else if (curr.tv_usec<target.tv_usec)
	{
		usleep(target.tv_usec-curr.tv_usec);
		goto rerun;
	}
	target.tv_usec+=1000000/fps;

#ifdef DISABLE_SIGALRM
	tmTimerHandler();
#endif
}

struct initcloseregstruct fpsReg={fpsInit, fpsDone};

char *dllinfo = "initcloseafter fpsReg";
struct linkinfostruct dllextinfo = {"fps", "OpenCP Frames Per Second lock (c) 2005 Stian Skjelstad", DLLVERSION, 0};
