/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: portab.hxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2006/10/27 23:07:40 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifndef _PORTAB_HXX
#define _PORTAB_HXX

#include "porglue.hxx"
namespace binfilter {

/*************************************************************************
 *                      class SwTabPortion
 *************************************************************************/

class SwTabPortion : public SwFixPortion
{
	const KSHORT nTabPos;
	const xub_Unicode cFill;

	// Das Format() verzweigt entweder in Pre- oder PostFormat()
	sal_Bool PreFormat( SwTxtFormatInfo &rInf );
public:
	SwTabPortion( const KSHORT nTabPos, const xub_Unicode cFill = '\0' );
	virtual sal_Bool Format( SwTxtFormatInfo &rInf );
	virtual void FormatEOL( SwTxtFormatInfo &rInf );
	sal_Bool PostFormat( SwTxtFormatInfo &rInf );
	inline  sal_Bool IsFilled() const { return 0 != cFill; }
	inline  KSHORT GetTabPos() const { return nTabPos; }

    // Accessibility: pass information about this portion to the PortionHandler

	OUTPUT_OPERATOR
};

/*************************************************************************
 *                  class SwTabLeftPortion
 *************************************************************************/

class SwTabLeftPortion : public SwTabPortion
{
public:
	inline SwTabLeftPortion( const KSHORT nTabPos, const xub_Unicode cFill='\0' )
		 : SwTabPortion( nTabPos, cFill )
	{ SetWhichPor( POR_TABLEFT ); }
	OUTPUT_OPERATOR
};

/*************************************************************************
 *                  class SwTabRightPortion
 *************************************************************************/

class SwTabRightPortion : public SwTabPortion
{
public:
	inline SwTabRightPortion( const KSHORT nTabPos, const xub_Unicode cFill='\0' )
		 : SwTabPortion( nTabPos, cFill )
	{ SetWhichPor( POR_TABRIGHT ); }
	OUTPUT_OPERATOR
};

/*************************************************************************
 *                  class SwTabCenterPortion
 *************************************************************************/

class SwTabCenterPortion : public SwTabPortion
{
public:
	inline SwTabCenterPortion( const KSHORT nTabPos, const xub_Unicode cFill='\0' )
		 : SwTabPortion( nTabPos, cFill )
	{ SetWhichPor( POR_TABCENTER );	}
	OUTPUT_OPERATOR
};

/*************************************************************************
 *                  class SwTabDecimalPortion
 *************************************************************************/

class SwTabDecimalPortion : public SwTabPortion
{
	const xub_Unicode cTab;
public:
	inline SwTabDecimalPortion( const KSHORT nTabPos, const xub_Unicode cTab,
								const xub_Unicode cFill = '\0' )
		 : SwTabPortion( nTabPos, cFill ), cTab(cTab)
	{ SetWhichPor( POR_TABDECIMAL ); }
	inline xub_Unicode GetTabDecimal() const { return cTab; }
	OUTPUT_OPERATOR
};

CLASSIO( SwTabPortion )
CLASSIO( SwTabLeftPortion )
CLASSIO( SwTabRightPortion )
CLASSIO( SwTabCenterPortion )
CLASSIO( SwTabDecimalPortion )


} //namespace binfilter
#endif
