/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: swtblfmt.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 16:33:45 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifndef _SWTBLFMT_HXX
#define _SWTBLFMT_HXX

#ifndef _FRMFMT_HXX
#include <frmfmt.hxx>
#endif
namespace binfilter {

class SwDoc;

class SwTableFmt : public SwFrmFmt
{
	friend class SwDoc;

protected:
	SwTableFmt( SwAttrPool& rPool, const sal_Char* pFmtNm,
					SwFrmFmt *pDrvdFrm )
		: SwFrmFmt( rPool, pFmtNm, pDrvdFrm, RES_FRMFMT, aTableSetRange )
	{}
	SwTableFmt( SwAttrPool& rPool, const String &rFmtNm,
					SwFrmFmt *pDrvdFrm )
		: SwFrmFmt( rPool, rFmtNm, pDrvdFrm, RES_FRMFMT, aTableSetRange )
	{}


public:
	TYPEINFO();		//Bereits in Basisklasse Client drin.

	DECL_FIXEDMEMPOOL_NEWDEL(SwTableFmt)
};

class SwTableLineFmt : public SwFrmFmt
{
	friend class SwDoc;

protected:
	SwTableLineFmt( SwAttrPool& rPool, const sal_Char* pFmtNm,
					SwFrmFmt *pDrvdFrm )
		: SwFrmFmt( rPool, pFmtNm, pDrvdFrm, RES_FRMFMT, aTableLineSetRange )
	{}
	SwTableLineFmt( SwAttrPool& rPool, const String &rFmtNm,
					SwFrmFmt *pDrvdFrm )
		: SwFrmFmt( rPool, rFmtNm, pDrvdFrm, RES_FRMFMT, aTableLineSetRange )
	{}

public:
	TYPEINFO();		//Bereits in Basisklasse Client drin.

	DECL_FIXEDMEMPOOL_NEWDEL(SwTableLineFmt)
};

class SwTableBoxFmt : public SwFrmFmt
{
	friend class SwDoc;

protected:
	SwTableBoxFmt( SwAttrPool& rPool, const sal_Char* pFmtNm,
					SwFrmFmt *pDrvdFrm )
		: SwFrmFmt( rPool, pFmtNm, pDrvdFrm, RES_FRMFMT, aTableBoxSetRange )
	{}
	SwTableBoxFmt( SwAttrPool& rPool, const String &rFmtNm,
					SwFrmFmt *pDrvdFrm )
		: SwFrmFmt( rPool, rFmtNm, pDrvdFrm, RES_FRMFMT, aTableBoxSetRange )
	{}

public:
	TYPEINFO();		//Bereits in Basisklasse Client drin.

	// zum Erkennen von Veraenderungen (haupts. TableBoxAttribute)
	virtual void Modify( SfxPoolItem* pOldValue, SfxPoolItem* pNewValue );

	DECL_FIXEDMEMPOOL_NEWDEL(SwTableBoxFmt)
};


} //namespace binfilter
#endif
