/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: b3ipoint.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: obo $ $Date: 2006/09/17 08:00:49 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_basegfx.hxx"

#ifndef _BGFX_POINT_B3IPOINT_HXX
#include <basegfx/point/b3ipoint.hxx>
#endif

#ifndef _BGFX_MATRIX_B3DHOMMATRIX_HXX
#include <basegfx/matrix/b3dhommatrix.hxx>
#endif

#ifndef _BGFX_NUMERIC_FTOOLS_HXX
#include <basegfx/numeric/ftools.hxx>
#endif

namespace basegfx
{
	B3IPoint& B3IPoint::operator*=( const ::basegfx::B3DHomMatrix& rMat )
	{
		double fTempX(
			rMat.get(0, 0) * mnX +
			rMat.get(0, 1) * mnY +
			rMat.get(0, 2) * mnZ +
			rMat.get(0, 3));
		double fTempY(
			rMat.get(1, 0) * mnX +
			rMat.get(1, 1) * mnY +
			rMat.get(1, 2) * mnZ +
			rMat.get(1, 3));
		double fTempZ(
			rMat.get(2, 0) * mnX +
			rMat.get(2, 1) * mnY +
			rMat.get(2, 2) * mnZ +
			rMat.get(2, 3));

		if(!rMat.isLastLineDefault())
		{
			const double fOne(1.0);
			const double fTempM(
				rMat.get(3, 0) * mnX + 
				rMat.get(3, 1) * mnY + 
				rMat.get(3, 2) * mnZ + 
				rMat.get(3, 3));

			if(!fTools::equalZero(fTempM) && !fTools::equal(fOne, fTempM))
			{
				fTempX /= fTempM;
				fTempY /= fTempM;
				fTempZ /= fTempM;
			}
		}

		mnX = fround(fTempX);
		mnY = fround(fTempY);
		mnZ = fround(fTempZ);

		return *this;
	}
} // end of namespace basegfx

// eof
