/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: overlayobjectlist.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: ihi $ $Date: 2006/11/14 13:08:22 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _SDR_OVERLAY_OVERLAYOBJECTLIST_HXX
#define _SDR_OVERLAY_OVERLAYOBJECTLIST_HXX

#ifndef _SDR_OVERLAY_OVERLAYOBJECT_HXX
#include <svx/sdr/overlay/overlayobject.hxx>
#endif

#ifndef _SV_GEN_HXX
#include <tools/gen.hxx>
#endif

#ifndef INCLUDED_SVXDLLAPI_H
#include "svx/svxdllapi.h"
#endif

//////////////////////////////////////////////////////////////////////////////

#define	DEFAULT_VALUE_FOR_HITTEST_PIXEL			(2L)

//////////////////////////////////////////////////////////////////////////////

namespace sdr
{
	namespace overlay
	{
		class SVX_DLLPUBLIC OverlayObjectList
		{
		protected:
			// the vector of OverlayObjects
			OverlayObjectVector						maVector;

			// default value for HiTestPixel
			sal_uInt32 getDefaultValueForHitTestPixel() const { return 4L; }

		public:
			OverlayObjectList() {}
			~OverlayObjectList();

			// clear list, this includes deletion of all contained objects
			void clear();

			// append/remove objects
			void append(OverlayObject& rOverlayObject) { maVector.push_back(&rOverlayObject); }
			void remove(OverlayObject& rOverlayObject);

			// access to objects
			sal_uInt32 count() const { return maVector.size(); }
			OverlayObject& getOverlayObject(sal_uInt32 nIndex) const { return *(maVector[nIndex]); }

			// Hittest with logical coordinates
			sal_Bool isHit(const basegfx::B2DPoint& rPos, double fTol = 0.0) const;

			// Hittest with pixel coordinates and pixel tolerance
			sal_Bool isHitPixel(const Point& rPos, sal_uInt32 nTol = DEFAULT_VALUE_FOR_HITTEST_PIXEL) const;

			// calculate BaseRange of all included OverlayObjects and return
			basegfx::B2DRange getBaseRange() const;

			// transform all members coordinates
			void transform(const basegfx::B2DHomMatrix& rMatrix);
		};
	} // end of namespace overlay
} // end of namespace sdr

//////////////////////////////////////////////////////////////////////////////

#endif //_SDR_OVERLAY_OVERLAYOBJECTLIST_HXX

// eof
