/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: animationinfo.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: obo $ $Date: 2006/09/17 05:32:56 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_svx.hxx"

#ifndef _SDR_ANIMATION_ANIMATIONINFO_HXX
#include <svx/sdr/animation/animationinfo.hxx>
#endif

#ifndef _TOOLS_DEBUG_HXX
#include <tools/debug.hxx>
#endif

#ifndef _SDR_MIXER_BASICMIXER_HXX
#include <svx/sdr/mixer/basicmixer.hxx>
#endif

#ifndef _SDR_ANIMATION_ANIMATIONSTATE_HXX
#include <svx/sdr/animation/animationstate.hxx>
#endif

#ifndef _SDR_CONTACT_VIEWOBJECTCONTACT_HXX
#include <svx/sdr/contact/viewobjectcontact.hxx>
#endif

#ifndef _SDR_CONTACT_VIEWCONTACT_HXX
#include <svx/sdr/contact/viewcontact.hxx>
#endif

//////////////////////////////////////////////////////////////////////////////

namespace sdr
{
	namespace animation
	{
		// This is called whenever a parameter changes. Default does nothing.
		void AnimationInfo::ParameterChange()
		{
		}

		AnimationInfo::AnimationInfo()
		{
		}

		AnimationInfo::~AnimationInfo()
		{
		}

		// This method has to create a fitting AnimationState for the
		// AnimationInfo. It gets the ViewObjectContact it is intended for. This
		// method has to return an Incarnation in every case.
		AnimationState* AnimationInfo::CreateAnimationState(sdr::contact::ViewObjectContact& rVOContact)
		{
			// Default incarnates standard AnimationState.
			return new AnimationState(rVOContact);
		}

		// paint method. These needs to paint the object in state of given time point. For
		// this, normally object parameters are changed, then paint from the associated
		// ViewContact is called, then object parameters restored.
		sal_Bool AnimationInfo::PaintObjectAtTime(
			sal_uInt32 /*nTime*/, sdr::contact::DisplayInfo& rDisplayInfo, 
			Rectangle& rPaintRectangle, const sdr::contact::ViewObjectContact& rAssociatedVOC)
		{
			// Default just calls the paint at ViewContact.
			return rAssociatedVOC.GetViewContact().PaintObject(rDisplayInfo, rPaintRectangle, rAssociatedVOC);
		}

		// Get animation start time, the time it needs to be triggered the
		// first time. 
		sal_uInt32 AnimationInfo::GetStartTime() const
		{
			// Default returns 0L which means to start at once.
			return 0L;
		}

		// React on changes of the object of this AnimationInfo.
		void AnimationInfo::ActionChanged()
		{
			// Default does nothing.
		}

		// Decide if animation is allowed for the given VOC. Default always returns
		// sal_True. Maybe necessary to switch off for accessibility (e.g.)
		sal_Bool AnimationInfo::IsAnimationAllowed(const sdr::contact::ViewObjectContact& /*rVOContact*/) const
		{
			return sal_True;
		}

		// Return smallest time unit in ms which is handled
		sal_uInt32 AnimationInfo::GetSmallestStepTime()
		{
			// set fix to 10 ATM.
			return 10L;
		}

		// Return biggest time unit in ms which is handled
		sal_uInt32 AnimationInfo::GetBiggestStepTime()
		{
			// set fix
			return 0xffffffff;
		}
	} // end of namespace animation
} // end of namespace sdr

//////////////////////////////////////////////////////////////////////////////

namespace sdr
{
	namespace animation
	{
		// basic constructor.
		AInfoDummy::AInfoDummy()
		{
		}

		// destructor
		AInfoDummy::~AInfoDummy()
		{
		}

		// test if to register at ObjectAnimator again after given time.
		// Fill in the new time value and return accordingly.
		sal_Bool AInfoDummy::DoRegisterAgain(sal_uInt32 /*nTime*/, sal_uInt32& /*rNewTime*/, const AnimationState& /*rAssociatedAS*/) const
		{
			return sal_False;
		}
	} // end of namespace animation
} // end of namespace sdr

//////////////////////////////////////////////////////////////////////////////

namespace sdr
{
	namespace animation
	{
		// Access the BasicMixer, plus creation on demand. Will use CreateBasicMixer() then.
		sdr::mixer::BasicMixer& AInfoMixer::GetBasicMixer() const
		{
			if(!mpMixer)
			{
				// create on demand
				((AInfoMixer*)this)->mpMixer = ((AInfoMixer*)this)->CreateBasicMixer();
			}

			return *mpMixer;
		}

		AInfoMixer::AInfoMixer()
		:	mpMixer(0L)
		{
		}

		AInfoMixer::~AInfoMixer()
		{
			if(mpMixer)
			{
				delete mpMixer;
				mpMixer = 0L;
			}
		}

		// paint method. This implementation uses the mixer to paint the object
		// in the current state.
		sal_Bool AInfoMixer::PaintObjectAtTime(sal_uInt32 nTime, sdr::contact::DisplayInfo& rDisplayInfo, 
			Rectangle& rPaintRectangle, const sdr::contact::ViewObjectContact& rAssociatedVOC)
		{
			// get mixer state for given time
			double fMixerState = GetMixerState(nTime, rDisplayInfo);

			// paint in that state using the mixer
			return GetBasicMixer().PaintObject(fMixerState, rDisplayInfo, rPaintRectangle, rAssociatedVOC);
		}
	} // end of namespace animation
} // end of namespace sdr

//////////////////////////////////////////////////////////////////////////////
// eof
