/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: salsound.hxx,v $
 *
 *  $Revision: 1.7 $
 *
 *  last change: $Author: kz $ $Date: 2007/10/09 15:11:34 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _SV_SALSOUND_HXX
#define _SV_SALSOUND_HXX

#include "tools/gen.hxx"
#include "tools/string.hxx"
#include "vcl/sv.h"
#include "vcl/salframe.hxx"
#include "vcl/salstype.hxx"

// ------------
// - SalSound -
// ------------

class SalSound
{
private:
	static ULONG		mnSoundState;
	SALSOUNDPROC		mpProc;
	void*				mpInst;
	BOOL				mbLoop;
	BOOL				mbPaused;

public:
						SalSound();
						~SalSound();

	BOOL				Create();
	static void 		Release();
	static BOOL 		IsValid() { return( SOUND_STATE_VALID == SalSound::mnSoundState ); }

	BOOL				Init( SalFrame* pFrame, const String& rSoundName, ULONG& rSoundLen );
	BOOL				Init( SalFrame* pFrame, const BYTE* pSound, ULONG nDataLen, ULONG& rSoundLen );
	void				Play( ULONG nStartTime, ULONG nPlayTime, BOOL bLoop );
	void				Stop();
	void				Pause();

	void				SetNotifyProc( void* pInst, SALSOUNDPROC pProc )
							{ mpInst = pInst; mpProc = pProc; }
};

#endif // _SV_SALSOUND_HXX
