/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: Logger.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: hbrinkm $ $Date: 2006/11/01 09:14:27 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

/*  Copyright 2005 Sun Microsystems, Inc. */

#ifndef INCLUDED_LOGGER_HXX
#define INCLUDED_LOGGER_HXX

#include <string>

namespace util {

  /** A logger interface. 
   */
  class Logger
  {
  public:
      virtual void beginTree() = 0;
      virtual void endTree() = 0;

      virtual void beginNode(const std::string& nodeId, const std::string& value, const std::string& refersToNodeId, bool inUse) = 0;
      virtual void endNode(const std::string& nodeId) = 0;

  protected:
	virtual ~Logger() {}
  };

} // namespace util

#endif // INCLUDED_LOGGER_HXX
