/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: CKeys.cxx,v $
 *
 *  $Revision: 1.25 $
 *
 *  last change: $Author: obo $ $Date: 2006/09/17 06:30:23 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_dbaccess.hxx"

#ifndef DBACCESS_CORE_API_KEYS_HXX
#include "CKeys.hxx"
#endif
#ifndef DBACCESS_CORE_API_KEY_HXX
#include "CKey.hxx"
#endif
#ifndef _COM_SUN_STAR_SDBC_XROW_HPP_
#include <com/sun/star/sdbc/XRow.hpp>
#endif
#ifndef _COM_SUN_STAR_SDBC_XRESULTSET_HPP_
#include <com/sun/star/sdbc/XResultSet.hpp>
#endif
#ifndef _COM_SUN_STAR_SDBCX_KEYTYPE_HPP_
#include <com/sun/star/sdbcx/KeyType.hpp>
#endif
#ifndef _COM_SUN_STAR_SDBC_KEYRULE_HPP_
#include <com/sun/star/sdbc/KeyRule.hpp>
#endif
#ifndef _CONNECTIVITY_DBTOOLS_HXX_
#include <connectivity/dbtools.hxx>
#endif
#ifndef DBACCESS_SHARED_DBASTRINGS_HRC
#include "dbastrings.hrc"
#endif
#ifndef _COMPHELPER_EXTRACT_HXX_
#include <comphelper/extract.hxx>
#endif
#ifndef _COMPHELPER_TYPES_HXX_
#include <comphelper/types.hxx>
#endif
#ifndef _COMPHELPER_PROPERTY_HXX_
#include <comphelper/property.hxx>
#endif

namespace dbaccess
{
using namespace comphelper;
using namespace connectivity::sdbcx;
using namespace connectivity;
using namespace dbtools;
using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::beans;
using namespace ::com::sun::star::sdbcx;
using namespace ::com::sun::star::sdbc;
using namespace ::com::sun::star::container;
using namespace ::com::sun::star::lang;



typedef connectivity::OKeysHelper OCollection_TYPE;

// -------------------------------------------------------------------------
connectivity::sdbcx::ObjectType OKeys::createObject(const ::rtl::OUString& _rName)
{
	connectivity::sdbcx::ObjectType xRet = NULL;

	Reference<XPropertySet> xKey;
	if ( m_xMasterKeys.is() )
	{
		sal_Int32 nCount = m_xMasterKeys->getCount();
		for(sal_Int32 i=0;i< nCount;++i)
		{
			::cppu::extractInterface(xKey,m_xMasterKeys->getByIndex(i));
			if(xKey.is() && ::comphelper::getString(xKey->getPropertyValue(PROPERTY_NAME)) == _rName)
				break;
			xKey = NULL;
		}
	}
	
	if ( xKey.is() )
	{
		Reference<XColumnsSupplier > xSup(xKey,UNO_QUERY);
		OSL_ENSURE(xSup.is(),"A Key must be a columns supplier!");

		OTableKey* pRet = new OTableKey(getTable(),
										_rName,
										::comphelper::getString(xKey->getPropertyValue(PROPERTY_REFERENCEDTABLE)),
										::comphelper::getINT32(xKey->getPropertyValue(PROPERTY_TYPE)),
										::comphelper::getINT32(xKey->getPropertyValue(PROPERTY_UPDATERULE)),
										::comphelper::getINT32(xKey->getPropertyValue(PROPERTY_DELETERULE)),
										xSup);
		xRet = pRet;
	}
	else
		xRet = OCollection_TYPE::createObject(_rName);

	return xRet;
}
// -------------------------------------------------------------------------
Reference< XPropertySet > OKeys::createDescriptor()
{
	Reference<XDataDescriptorFactory> xDataFac(m_xMasterKeys,UNO_QUERY);
	if ( xDataFac.is() )
		return 	xDataFac->createDataDescriptor();

	return OCollection_TYPE::createDescriptor();
}
// -------------------------------------------------------------------------
// XAppend
ObjectType OKeys::appendObject( const ::rtl::OUString& _rForName, const Reference< XPropertySet >& descriptor )
{
	Reference<XAppend> xAppend(m_xMasterKeys,UNO_QUERY);
	if ( !xAppend.is() )
		return OCollection_TYPE::appendObject( _rForName, descriptor );

    xAppend->appendByDescriptor(descriptor);
    return createObject( _rForName );
}
// -------------------------------------------------------------------------
// XDrop
void OKeys::dropObject(sal_Int32 _nPos,const ::rtl::OUString _sElementName)
{
	Reference<XDrop> xDrop(m_xMasterKeys,UNO_QUERY);
	if ( xDrop.is() )
		xDrop->dropByName(_sElementName);
	else
		OCollection_TYPE::dropObject( _nPos,_sElementName );
}
// -----------------------------------------------------------------------------
} // namespace dbaccess
// -----------------------------------------------------------------------------
