/*
 * OOInterfacePanel.java
 *
 * Created on July 24, 2002, 3:01 PM
 */

package org.netbeans.modules.openoffice.wizard.panels.service;

import javax.swing.JPanel;
import java.awt.event.ActionEvent;
import org.openide.DialogDescriptor;
import org.openide.NotifyDescriptor;
import org.openide.TopManager;
import javax.swing.DefaultListModel;
import org.netbeans.modules.openoffice.wizard.OOServiceData;
import org.openide.src.Identifier;
import org.netbeans.modules.openoffice.wizard.util.OOIDLParser;
import org.netbeans.modules.openoffice.wizard.IDLInterface;

/**
 *
 * @author  Bertram Nolte
 */
public class OOInterfacePanel extends JPanel {
    private DefaultListModel defaultlistmodel;
    private OOServiceData ooservicedata;
    
    /** Creates new form OOInterfacePanel */
    public OOInterfacePanel() {
         defaultlistmodel = new DefaultListModel();

        initComponents();
        
        jListInterfaces.setModel( defaultlistmodel );
    }
    
    /** Creates new form OOInterfacePanel */
    public OOInterfacePanel( OOServiceData data ) {
        Identifier[] identifierInterfaceName = data.getInterfaces();
        ooservicedata = data;
        defaultlistmodel = new DefaultListModel();
        for ( int intIndexInterfaces = 0;
        intIndexInterfaces < identifierInterfaceName.length; 
        intIndexInterfaces++ ) {
            defaultlistmodel.addElement( 
            identifierInterfaceName[ intIndexInterfaces ].getFullName() );
        }
        
        initComponents();
        
        jListInterfaces.setModel( defaultlistmodel );
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        jButtonAddInterface = new javax.swing.JButton();
        jButtonRemoveInterface = new javax.swing.JButton();
        jScrollPaneInterfaces = new javax.swing.JScrollPane();
        jListInterfaces = new javax.swing.JList();
        jLabelInterfaces = new javax.swing.JLabel();

        setLayout(new java.awt.GridBagLayout());

        jButtonAddInterface.setText("Add");
        jButtonAddInterface.setToolTipText("Add interface to list.");
        jButtonAddInterface.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonAddInterfaceActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(1, 1, 1, 1);
        add(jButtonAddInterface, gridBagConstraints);

        jButtonRemoveInterface.setText("Remove");
        jButtonRemoveInterface.setToolTipText("Remove Interface from list.");
        jButtonRemoveInterface.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonRemoveInterfaceActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(1, 1, 1, 1);
        add(jButtonRemoveInterface, gridBagConstraints);

        jListInterfaces.setBorder(new javax.swing.border.EtchedBorder());
        jListInterfaces.setToolTipText("Interfaces to be implemented.");
        jListInterfaces.setPreferredSize(new java.awt.Dimension(300, 300));
        jScrollPaneInterfaces.setViewportView(jListInterfaces);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(1, 1, 1, 1);
        add(jScrollPaneInterfaces, gridBagConstraints);

        jLabelInterfaces.setText("Interfaces:");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(10, 1, 1, 1);
        add(jLabelInterfaces, gridBagConstraints);

    }//GEN-END:initComponents

    private void jButtonRemoveInterfaceActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonRemoveInterfaceActionPerformed
        Object[] objectInterfaces = jListInterfaces.getSelectedValues();
        
        for ( int intIndexInterfaces = 0;
        intIndexInterfaces < objectInterfaces.length;
        intIndexInterfaces++ ) {
//            IDLInterface idlinterface = 
//            ( IDLInterface ) objectInterfaces[ intIndexInterfaces ];
            
            ooservicedata.removeIDLInterface( 
//            idlinterface.getIDLName().getFullName() );
            ( String ) objectInterfaces[ intIndexInterfaces ] );
            
            defaultlistmodel.removeElement( 
            ( String ) objectInterfaces[ intIndexInterfaces ] );
//            defaultlistmodel.removeElement( idlinterface );
        }
    }//GEN-LAST:event_jButtonRemoveInterfaceActionPerformed

    private void jButtonAddInterfaceActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonAddInterfaceActionPerformed
        InterfacePickUp interfacepickupPanel = new InterfacePickUp();
        
        if ( interfacepickupPanel.display() ) {
            OOIDLParser ooidlparser = new OOIDLParser(
            interfacepickupPanel.getInterfaceFile() );
            
            IDLInterface iDLInterface = ooidlparser.createIDLInterface();
            
            if( iDLInterface == null ) {
                // Message that the IDL does not contain a Interface
                TopManager.getDefault().notify(
                new NotifyDescriptor.Message(
                "The IDL file you have choosen, does not contain an "
                + "Interface. Please pick up an other one." ) );
            }
            else {
                if ( ooservicedata.addIDLInterface( iDLInterface ) ) {
                    defaultlistmodel.addElement(
                    iDLInterface.getIDLName().getFullName() );
                }
            }
        }
    }//GEN-LAST:event_jButtonAddInterfaceActionPerformed
    
    boolean display() {
        DialogDescriptor dialogdescriptor = new DialogDescriptor( this,
        "Interfaces to implement by your Service", true, 2,
        NotifyDescriptor.OK_OPTION, 0, null, null);
        
        TopManager.getDefault().notify( dialogdescriptor );
        return dialogdescriptor.getValue() == NotifyDescriptor.OK_OPTION;
    }
    
    Object[] getInterfaces() {
        return defaultlistmodel.toArray();
    }
    
    void addButtonActionPerformed(ActionEvent actionevent) {
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButtonRemoveInterface;
    private javax.swing.JButton jButtonAddInterface;
    private javax.swing.JLabel jLabelInterfaces;
    private javax.swing.JList jListInterfaces;
    private javax.swing.JScrollPane jScrollPaneInterfaces;
    // End of variables declaration//GEN-END:variables
    
}
