/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: doctxm.hxx,v $
 *
 *  $Revision: 1.8 $
 *
 *  last change: $Author: hr $ $Date: 2007/09/27 08:55:03 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifndef _DOCTXM_HXX
#define _DOCTXM_HXX


#ifndef _SVARRAY_HXX //autogen
#include <svtools/svarray.hxx>
#endif
#ifndef _SV_GEN_HXX
#include <tools/gen.hxx>
#endif

#ifndef _TOX_HXX
#include <tox.hxx>
#endif
#ifndef _SECTION_HXX
#include <section.hxx>
#endif

class  SwTOXInternational;
class  SvUShorts;
class  SvStringsDtor;
class  SvPtrarr;
class  SwPageDesc;
class  SwTxtNode;
class  SwTxtFmtColl;
struct SwPosition;
struct SwTOXSortTabBase;

typedef SwTOXSortTabBase* SwTOXSortTabBasePtr;

SV_DECL_PTRARR(SwTOXSortTabBases, SwTOXSortTabBasePtr, 0, 5 )

/*--------------------------------------------------------------------
	 Beschreibung: Ring der speziellen Verzeichnisse
 --------------------------------------------------------------------*/

class SwTOXBaseSection : public SwTOXBase, public SwSection
{
	SwTOXSortTabBases aSortArr;

	void 	UpdateMarks( const SwTOXInternational& rIntl,
							const SwTxtNode* pOwnChapterNode );
	void 	UpdateOutline( const SwTxtNode* pOwnChapterNode );
	void 	UpdateTemplate( const SwTxtNode* pOwnChapterNode );
	void 	UpdateCntnt( SwTOXElement eType,
							const SwTxtNode* pOwnChapterNode );
	void 	UpdateTable( const SwTxtNode* pOwnChapterNode );
	void 	UpdateSequence( const SwTxtNode* pOwnChapterNode );
	void 	UpdateAuthorities( const SwTOXInternational& rIntl );
	void	UpdateAll();

	// Sortiert einfuegen ins Array fuer die Generierung
	void	InsertSorted(SwTOXSortTabBase* pBase);

	// Alpha-Trennzeichen bei der Generierung einfuegen
	void	InsertAlphaDelimitter( const SwTOXInternational& rIntl );

	// Textrumpf generieren
    // OD 18.03.2003 #106329# - add parameter <_TOXSectNdIdx> and <_pDefaultPageDesc>
    void GenerateText( USHORT nArrayIdx,
                       USHORT nCount,
                       SvStringsDtor&,
                       const sal_uInt32   _nTOXSectNdIdx,
                       const SwPageDesc*  _pDefaultPageDesc );

	// Seitennummerplatzhalter gegen aktuelle Nummern austauschen
	void	_UpdatePageNum( SwTxtNode* pNd,
							const SvUShorts& rNums,
							const SvPtrarr &rDescs,
							const SvUShorts* pMainEntryNums,
							const SwTOXInternational& rIntl );

	// Bereich fuer Stichwort einfuegen suchen
    Range GetKeyRange( const String& rStr, const String& rStrReading,
                       const SwTOXSortTabBase& rNew, USHORT nLevel,
                       const Range& rRange );

	// returne die TextCollection ueber den Namen / aus Format-Pool
	SwTxtFmtColl* GetTxtFmtColl( USHORT nLevel );

public:
	SwTOXBaseSection( const SwTOXBase& rBase );
	virtual ~SwTOXBaseSection();

    // OD 19.03.2003 #106329# - add parameter <_bNewTOX> in order to distinguish
    // between the creation of a new table-of-content or an update of
    // a table-of-content. Default value: false
    void Update( const SfxItemSet* pAttr = 0,
                 const bool        _bNewTOX = false ); // Formatieren
	void UpdatePageNum();   			// Seitennummern einfuegen
	TYPEINFO();							// fuers rtti

	BOOL SetPosAtStartEnd( SwPosition& rPos, BOOL bAtStart = TRUE ) const;
};
/* -----------------02.09.99 07:52-------------------

 --------------------------------------------------*/
struct SwDefTOXBase_Impl
{
	SwTOXBase* pContBase;
	SwTOXBase* pIdxBase;
	SwTOXBase* pUserBase;
	SwTOXBase* pTblBase;
	SwTOXBase* pObjBase;
	SwTOXBase* pIllBase;
	SwTOXBase* pAuthBase;

	SwDefTOXBase_Impl() :
	pContBase(0),
	pIdxBase(0),
	pUserBase(0),
	pTblBase(0),
	pObjBase(0),
	pIllBase(0),
	pAuthBase(0)
	{}
	~SwDefTOXBase_Impl()
	{
		delete pContBase;
		delete pIdxBase;
		delete pUserBase;
		delete pTblBase;
		delete pObjBase;
		delete pIllBase;
		delete pAuthBase;
	}

};

#endif	// _DOCTXM_HXX
