/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: NamespaceMapper.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: fridrich_strba $ $Date: 2007/05/16 14:35:30 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifndef INCLUDED_NAMSPACE_MAPPER_HXX
#define INCLUDED_NAMSPACE_MAPPER_HXX

#include <map>

#ifndef INCLUDED_TOKEN_MAP_HXX
#include "TokenMap.hxx"
#endif

namespace ooxml
{
class NamespaceMapper
{
public:
    typedef boost::shared_ptr<NamespaceMapper> Pointer_t;

private:
    typedef map<rtl::OUString, rtl::OUString> Map_t;
    Map_t mMap;

public:
    NamespaceMapper();
    virtual ~NamespaceMapper();

    void addMapping(const rtl::OUString & rPrefix, const rtl::OUString & rUrl);
    TokenEnum_t getToken(TokenMap::TokenType_t nType,
                         const rtl::OUString & rTokenString);
#ifdef DEBUG_NAMESPACEMAPPER
    void dump();
#endif
};
}

#endif // INCLUDED_NAMSPACE_MAPPER_HXX
