/*************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 * 
 * Copyright 2008 by Sun Microsystems, Inc.
 *
 * OpenOffice.org - a multi-platform office productivity suite
 *
 * $RCSfile: cx_idlco.hxx,v $
 * $Revision: 1.4 $
 *
 * This file is part of OpenOffice.org.
 *
 * OpenOffice.org is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * OpenOffice.org is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with OpenOffice.org.  If not, see
 * <http://www.openoffice.org/license.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/

#ifndef LUIDL_CX_IDLCO_HXX
#define LUIDL_CX_IDLCO_HXX

// USED SERVICES
	// BASE CLASSES
#include <tokens/tkpcont2.hxx>
	// COMPONENTS
#include <tokens/tkpstam2.hxx>
	// PARAMETERS


namespace csi
{
namespace uidl
{

class Token_Receiver;
class Token;

/**
*/
class Context_UidlCode : public TkpContext,
						 private StateMachineContext
{
  public:
	// 	LIFECYCLE
						Context_UidlCode(
							Token_Receiver &	o_rReceiver,
							DYN TkpDocuContext &
												let_drContext_Docu	);
						~Context_UidlCode();
	//	OPERATORS

	//	OPERATIONS
	virtual void		ReadCharChain(
							CharacterSource &	io_rText );
	virtual bool		PassNewToken();

	//	INQUIRY
	virtual TkpContext &
						FollowUpContext();
  private:
	//	SERVICE FUNCTIONS
	void				PerformStatusFunction(
							uintt				i_nStatusSignal,
							UINT16 	      	    i_nTokenId,
							CharacterSource &	io_rText );
	void				SetupStateMachine();

	//	DATA
	StateMachin2		aStateMachine;
	Token_Receiver *	pReceiver;

		// Contexts
	Dyn<TkpDocuContext>	pDocuContext;

	Dyn<TkpContext>    dpContext_MLComment;
	Dyn<TkpContext>    dpContext_SLComment;
	Dyn<TkpContext>    dpContext_Preprocessor;
	Dyn<TkpContext>    dpContext_Assignment;

		// Temporary data, used during ReadCharChain()
	Dyn<Token>			pNewToken;
	::TkpContext *		pFollowUpContext;
};


}   // namespace uidl
}   // namespace csi

#endif
