/*************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 * 
 * Copyright 2008 by Sun Microsystems, Inc.
 *
 * OpenOffice.org - a multi-platform office productivity suite
 *
 * $RCSfile: e3dproperties.cxx,v $
 * $Revision: 1.7 $
 *
 * This file is part of OpenOffice.org.
 *
 * OpenOffice.org is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * OpenOffice.org is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with OpenOffice.org.  If not, see
 * <http://www.openoffice.org/license.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_svx.hxx"
#include <svx/sdr/properties/e3dproperties.hxx>
#include <svtools/itemset.hxx>
#include <svx/svddef.hxx>
#include <svx/obj3d.hxx>

//////////////////////////////////////////////////////////////////////////////

namespace sdr
{
	namespace properties
	{
		// create a new itemset
		SfxItemSet& E3dProperties::CreateObjectSpecificItemSet(SfxItemPool& rPool)
		{
			return *(new SfxItemSet(rPool,

				// ranges from SdrAttrObj
				SDRATTR_START, SDRATTR_SHADOW_LAST,
				SDRATTR_MISC_FIRST, SDRATTR_MISC_LAST,
				SDRATTR_TEXTDIRECTION, SDRATTR_TEXTDIRECTION,

				// ranges from E3dObject, contains object and scene because of GetMergedItemSet()
				SDRATTR_3D_FIRST, SDRATTR_3D_LAST,

				// end
				0, 0));
		}

		E3dProperties::E3dProperties(SdrObject& rObj)
		:	AttributeProperties(rObj)
		{
		}

		E3dProperties::E3dProperties(const E3dProperties& rProps, SdrObject& rObj)
		:	AttributeProperties(rProps, rObj)
		{
		}

		E3dProperties::~E3dProperties()
		{
		}
		
		BaseProperties& E3dProperties::Clone(SdrObject& rObj) const
		{
			return *(new E3dProperties(*this, rObj));
		}

		void E3dProperties::ItemSetChanged(const SfxItemSet& rSet)
		{
			E3dObject& rObj = (E3dObject&)GetSdrObject();

			// call parent
			AttributeProperties::ItemSetChanged(rSet);

			// local changes
			rObj.StructureChanged(&rObj);
		}

		void E3dProperties::SetStyleSheet(SfxStyleSheet* pNewStyleSheet, sal_Bool bDontRemoveHardAttr)
		{
			// call parent
			AttributeProperties::SetStyleSheet(pNewStyleSheet, bDontRemoveHardAttr);

			// propagate call to contained objects
			const SdrObjList* pSub = ((const E3dObject&)GetSdrObject()).GetSubList();
			const sal_uInt32 nCount(pSub->GetObjCount());

			for(sal_uInt32 a(0L); a < nCount; a++)
			{
				pSub->GetObj(a)->GetProperties().SetStyleSheet(pNewStyleSheet, bDontRemoveHardAttr);
			}
		}
	} // end of namespace properties
} // end of namespace sdr

//////////////////////////////////////////////////////////////////////////////
// eof
