/*************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 * 
 * Copyright 2008 by Sun Microsystems, Inc.
 *
 * OpenOffice.org - a multi-platform office productivity suite
 *
 * $RCSfile: vocbitmapbuffer.hxx,v $
 * $Revision: 1.6 $
 *
 * This file is part of OpenOffice.org.
 *
 * OpenOffice.org is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * OpenOffice.org is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with OpenOffice.org.  If not, see
 * <http://www.openoffice.org/license.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/

#ifndef _SDR_CONTACT_VOCBITMAPBUFFER_HXX
#define _SDR_CONTACT_VOCBITMAPBUFFER_HXX

#include <svx/sdr/contact/viewobjectcontact.hxx>
#include <vcl/bitmapex.hxx>

//////////////////////////////////////////////////////////////////////////////
// predeclarations
class VirtualDevice;

//////////////////////////////////////////////////////////////////////////////
// class BufferHelper

namespace sdr
{
	namespace contact
	{
		class BufferHelper
		{
		protected:
			// The ViewObjectContact this buffer belongs to
			ViewObjectContact&							mrViewObjectContact;

			// The remembered MapMode of the buffered part
			MapMode										maBufferedMapMode;

			// Flagarray
			// Flag to remember state of Buffering. Default is sal_False.
			unsigned									mbBufferValid : 1;

			// helper methods
			Rectangle ImpCalculateClippedPixelRectangle(DisplayInfo& rDisplayInfo) const;
			virtual Size ImpGetBufferedSizePixel() const = 0;
			void ImpCheckForChanges(DisplayInfo& rDisplayInfo);
			bool ImpBufferingAllowed(DisplayInfo& rDisplayInfo) const;
			virtual void ImpPaintUsingBuffer(DisplayInfo& rDisplayInfo) const = 0;
			void ImpTryToCreateBuffer(DisplayInfo& rDisplayInfo);
			virtual VirtualDevice* ImpPrepareVirtualDevice(DisplayInfo& rDisplayInfo) const = 0;
			virtual void ImpCreateBufferFromVDev(VirtualDevice& rVirtualDevice) = 0;

		public:
			BufferHelper(ViewObjectContact& rViewObjectContact);
			virtual ~BufferHelper();

			// Get bool flag about buffer status
			bool BufferIsValid() const { return mbBufferValid; }

			// Try to paint from buffer
			bool TryToPaintObjectWithBuffer(DisplayInfo& rDisplayInfo);

			// dispose buffer
			virtual void DisposeBuffer() = 0;

			// access to MapMode
			const MapMode& GetBufferedMapMode() const { return maBufferedMapMode; }
		};
	} // end of namespace contact
} // end of namespace sdr

//////////////////////////////////////////////////////////////////////////////
// class BufferHelperBitmap

namespace sdr
{
	namespace contact
	{
		class BufferHelperBitmap : public BufferHelper
		{
		protected:
			// The buffered bitmap
			Bitmap										maBuffer;

			// helper methods
			virtual Size ImpGetBufferedSizePixel() const;
			virtual void ImpPaintUsingBuffer(DisplayInfo& rDisplayInfo) const;
			virtual VirtualDevice* ImpPrepareVirtualDevice(DisplayInfo& rDisplayInfo) const;
			virtual void ImpCreateBufferFromVDev(VirtualDevice& rVirtualDevice);

		public:
			BufferHelperBitmap(ViewObjectContact& rViewObjectContact);
			virtual ~BufferHelperBitmap();

			// dispose buffer
			virtual void DisposeBuffer();

			// access to bitmap
			const Bitmap& GetBufferedBitmap() const { return maBuffer; }

			// access if buffered data needs to be injected
			void SetBufferedData(const MapMode& rMapMode, const Bitmap& rBitmap);
		};
	} // end of namespace contact
} // end of namespace sdr

//////////////////////////////////////////////////////////////////////////////
// class BufferHelperBitmapEx

namespace sdr
{
	namespace contact
	{
		class BufferHelperBitmapEx : public BufferHelper
		{
		protected:
			// The buffered bitmap
			BitmapEx									maBuffer;

			// helper methods
			virtual Size ImpGetBufferedSizePixel() const;
			virtual void ImpPaintUsingBuffer(DisplayInfo& rDisplayInfo) const;
			virtual VirtualDevice* ImpPrepareVirtualDevice(DisplayInfo& rDisplayInfo) const;
			virtual void ImpCreateBufferFromVDev(VirtualDevice& rVirtualDevice);

		public:
			BufferHelperBitmapEx(ViewObjectContact& rViewObjectContact);
			virtual ~BufferHelperBitmapEx();

			// dispose buffer
			virtual void DisposeBuffer();

			// access to bitmapEx
			const BitmapEx& GetBufferedBitmapEx() const { return maBuffer; }

			// access if buffered data needs to be injected
			void SetBufferedData(const MapMode& rMapMode, const BitmapEx& rBitmapEx);
		};
	} // end of namespace contact
} // end of namespace sdr

//////////////////////////////////////////////////////////////////////////////
// class VOCBitmapBuffer

namespace sdr
{
	namespace contact
	{
		class VOCBitmapBuffer : public ViewObjectContact
		{
		protected:
			// The Buffer itself
			BufferHelperBitmap							maBuffer;

		public:
			// basic constructor.
			VOCBitmapBuffer(ObjectContact& rObjectContact, ViewContact& rViewContact);

			// The destructor.
			virtual ~VOCBitmapBuffer();

			// Prepare deletion of this object.
			virtual void PrepareDelete();

			// Paint this object. This is before evtl. SubObjects get painted. This method
			// needs to set the flag mbIsPainted and to set the
			// maPaintedRectangle member. This information is later used for invalidates
			// and repaints.
			virtual void PaintObject(DisplayInfo& rDisplayInfo);

			// React on changes of the object of this ViewContact
			virtual void ActionChanged();

			// Take some action when new objects are inserted
			virtual void ActionChildInserted(const Rectangle& rInitialRectangle);
		};
	} // end of namespace contact
} // end of namespace sdr

//////////////////////////////////////////////////////////////////////////////
// class VOCBitmapExBuffer

namespace sdr
{
	namespace contact
	{
		class VOCBitmapExBuffer : public ViewObjectContact
		{
		protected:
			// The Buffer itself
			BufferHelperBitmapEx						maBuffer;

		public:
			// basic constructor.
			VOCBitmapExBuffer(ObjectContact& rObjectContact, ViewContact& rViewContact);

			// The destructor.
			virtual ~VOCBitmapExBuffer();

			// Prepare deletion of this object.
			virtual void PrepareDelete();

			// Paint this object. This is before evtl. SubObjects get painted. This method
			// needs to set the flag mbIsPainted and to set the
			// maPaintedRectangle member. This information is later used for invalidates
			// and repaints.
			virtual void PaintObject(DisplayInfo& rDisplayInfo);

			// React on changes of the object of this ViewContact
			virtual void ActionChanged();

			// Take some action when new objects are inserted
			virtual void ActionChildInserted(const Rectangle& rInitialRectangle);
		};
	} // end of namespace contact
} // end of namespace sdr

//////////////////////////////////////////////////////////////////////////////

//namespace sdr
//{
//	namespace contact
//	{
//		class VOCBitmapBuffer_old : public ViewObjectContact
//		{
//			// The Bitmap to remember the rendered, buffered content
//			BitmapEx									maBitmapEx;
//
//			// #i36136# The remembered MapMode of the cached part
//			MapMode										maCachedMapMode;
//
//			// Flagarray
//			// Flag to remember state ob BitmapCaching Bitmap. Default is sal_False.
//			unsigned									mbCachedBitmapValid : 1;
//
//			// #i36136# Flag to know if Alpha-Channel shall be used. Dfault is true. If
//			// true, a Alpha-VDev is used for creation of buffered context.
//			unsigned									mbUseAlphaChannel : 1;
//
//			// Calculate the clipped PixelSize (visible area) and the offset from the
//			// top left of the original object position
//			Rectangle CalculateClippedPixelRectangle(DisplayInfo& rDisplayInfo);
//
//			// Buffer Bitmap creation/deletion
//			void TryToCreateBuffer(const Rectangle& rNewSizePixel, DisplayInfo& rDisplayInfo);
//			void DisposeBuffer();
//
//			// Get bool flag about buffer status
//			sal_Bool CachedBitmapIsValid() const { return mbCachedBitmapValid; }
//
//			// Get bool flag about alpha channel
//			sal_Bool DoUseAlphaChannel() const { return mbUseAlphaChannel; }
//
//		public:
//			// basic constructor.
//			VOCBitmapBuffer_old(
//				ObjectContact& rObjectContact, ViewContact& rViewContact,
//				bool bUseAlphaChannel = true);
//
//			// The destructor.
//			virtual ~VOCBitmapBuffer_old();
//
//			// Prepare deletion of this object.
//			virtual void PrepareDelete();
//
//			// Paint this object. This is before evtl. SubObjects get painted. This method
//			// needs to set the flag mbIsPainted and to set the
//			// maPaintedRectangle member. This information is later used for invalidates
//			// and repaints.
//			virtual void PaintObject(DisplayInfo& rDisplayInfo);
//
//			// React on changes of the object of this ViewContact
//			virtual void ActionChanged();
//
//			// Take some action when new objects are inserted
//			virtual void ActionChildInserted(const Rectangle& rInitialRectangle);
//		};
//	} // end of namespace contact
//} // end of namespace sdr

//////////////////////////////////////////////////////////////////////////////

#endif //_SDR_CONTACT_VOCBITMAPBUFFER_HXX

// eof
