/*************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 * 
 * Copyright 2008 by Sun Microsystems, Inc.
 *
 * OpenOffice.org - a multi-platform office productivity suite
 *
 * $RCSfile: xout.cxx,v $
 * $Revision: 1.18 $
 *
 * This file is part of OpenOffice.org.
 *
 * OpenOffice.org is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * OpenOffice.org is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with OpenOffice.org.  If not, see
 * <http://www.openoffice.org/license.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_svx.hxx"

#include <stdlib.h>
#include <vcl/wrkwin.hxx>
#include <vcl/svapp.hxx>
#include <tools/poly.hxx>
#include <vcl/window.hxx>
#include <vcl/gradient.hxx>
#include <svtools/itemset.hxx>
#include <goodies/grfmgr.hxx>
#include "xattr.hxx"
#include <svx/xpool.hxx>
#include <svx/xpoly.hxx>
#include <svx/xoutx.hxx>
#include "xoutbmp.hxx"
#include <basegfx/polygon/b2dpolygontools.hxx>
#include <basegfx/polygon/b2dpolypolygontools.hxx>
#include <basegfx/numeric/ftools.hxx>
#include <vcl/salbtype.hxx>		// FRound
#include <basegfx/matrix/b2dhommatrix.hxx>

#define ITEMVALUE(ItemSet,Id,Cast)	((const Cast&)(ItemSet).Get(Id)).GetValue()
#define	MTF_DIVISOR 2

/*************************************************************************
|*
|*	  XOutputDevice::XOutputDevice()
|*
|*	  Beschreibung
|*	  Ersterstellung	08.11.94
|*	  Letzte Aenderung	08.11.94
|*
*************************************************************************/

XOutputDevice::XOutputDevice(OutputDevice* pOutDev) 
:	pTransGradient		( 0L ),
	bSolidHatch			( sal_False ),
	pLinePattern		( NULL ),
	nLinePatternCnt		( 0 ),
	eLineStyle			( XLINE_SOLID ),
	nLineTransparence	( 0 ),
	nLineWidth			( 0 ),
	nLineStartSqLen		( 0 ),
	nLineEndSqLen		( 0 ),
	bLineStart			( FALSE ),
	bLineEnd			( FALSE ),
	bHair				( FALSE ),
	eFillStyle			( XFILL_SOLID ),
	nFillTransparence   ( 0 ),
    mpFillGraphicObject ( new GraphicObject ),
	mnBmpPerCentX		( 0 ),
	mnBmpPerCentY		( 0 ),
	mnBmpOffX			( 0 ),
	mnBmpOffY			( 0 ),
	mnBmpOffPosX		( 0 ),
	mnBmpOffPosY		( 0 ),
	meLastOutDevType	( OUTDEV_WINDOW ),
	meBmpRectPoint		( RP_MM ),
	mbBmpTile			( FALSE ),
	mbBmpStretch		( TRUE ),
	mbBmpLogSize		( FALSE ),
	mbRecalc			( TRUE ),
	aGradient			( COL_BLACK, COL_WHITE ),
	aHatch				( COL_BLACK, XHATCH_SINGLE ),
	bDither				( ( pOutDev ? pOutDev : Application::GetDefaultDevice() )->GetColorCount() <= 256 ),
	bIgnoreLineAttr		( FALSE ),
	bIgnoreLineStyle	( FALSE ),
	bIgnoreFillAttr     ( FALSE ),
	eFormTextStyle		( XFT_UPRIGHT ),
	eFormTextAdjust		( XFT_AUTOSIZE ),
	nFormTextDistance	( 0 ),
	nFormTextStart		( 0 ),
	bFormTextMirror		( FALSE ),
	bFormTextOutline	( FALSE ),
	eFormTextShadow		( XFTSHADOW_NONE ),
	aFormTextShdwColor	( COL_LIGHTGRAY ),
	nFormTextShdwTransp	( 0 ),
	nFormTextShdwXVal	( 0 ),
	nFormTextShdwYVal	( 0 ),
	eFormTextStdForm	( XFTFORM_NONE ),
	bFormTextHideForm	( FALSE ),
	nFtAutoHeightSave	( 0 ),
	pOut				( pOutDev )
{
}

/*************************************************************************
|*
|*	  XOutputDevice::~XOutputDevice()
|*
|*	  Beschreibung
|*	  Ersterstellung	08.11.94
|*	  Letzte Aenderung	08.11.94
|*
*************************************************************************/

XOutputDevice::~XOutputDevice()
{
	delete[] pLinePattern;
    delete mpFillGraphicObject;

    delete pTransGradient;
}

/*************************************************************************
|*
|*	  XOutputDevice::DrawLine()
|*
|*	  Beschreibung
|*	  Ersterstellung	08.11.94
|*	  Letzte Aenderung	02.02.94 ESO
|*
*************************************************************************/

void XOutputDevice::DrawLine( const Point& rStart, const Point& rEnd )
{
	Polygon aPoly(2);

	aPoly[0] = rStart;
	aPoly[1] = rEnd;
	DrawLinePolygon( aPoly, FALSE );
}

/*************************************************************************
|*
|*	  XOutputDevice::DrawPolyLine()
|*
|*	  Beschreibung
|*	  Ersterstellung	08.11.94
|*	  Letzte Aenderung	08.11.94
|*
*************************************************************************/

void XOutputDevice::DrawPolyLine( const Polygon& rPoly )
{
	DrawLinePolygon( rPoly, FALSE );
}

/*************************************************************************
|*
|*	  XOutputDevice::DrawXPolyLine()
|*
|*	  Beschreibung
|*	  Ersterstellung	08.11.94
|*	  Letzte Aenderung	29.11.94 ESO
|*
*************************************************************************/

void XOutputDevice::DrawPolyLine( const basegfx::B2DPolygon& rPolygon )
{
	if(rPolygon.count())
	{
        // #100127# Too much hassle below this method
		// const Polygon aPoly( XOutCreatePolygonBezier(rXPoly, pOut) );
		const Polygon aDrawPolygon(basegfx::tools::adaptiveSubdivideByAngle(rPolygon));
		DrawLinePolygon(aDrawPolygon, FALSE);
	}
}

/*************************************************************************
|*
|*	  XOutputDevice::DrawRect()
|*
|*	  Beschreibung
|*	  Ersterstellung	08.11.94
|*	  Letzte Aenderung	29.11.94 ESO
|*
*************************************************************************/

void XOutputDevice::DrawRect( const Rectangle& rRect, ULONG nXRound,
							  ULONG nYRound )
{
	const Polygon aPoly( rRect, nXRound, nYRound );
	
	DrawFillPolyPolygon( aPoly, TRUE );
	DrawLinePolygon( aPoly, TRUE );
}


/*************************************************************************
|*
|*	  XOutputDevice::DrawEllipse()
|*
|*	  Beschreibung
|*	  Ersterstellung	08.11.94
|*	  Letzte Aenderung	08.11.94
|*
*************************************************************************/

void XOutputDevice::DrawEllipse( const Rectangle& rRect )
{
	const Polygon aPoly( rRect.Center(), rRect.GetWidth() >> 1, rRect.GetHeight() >> 1 );
	
	DrawFillPolyPolygon( aPoly );
	DrawLinePolygon( aPoly, TRUE );
}


/*************************************************************************
|*
|*	  XOutputDevice::DrawArc()
|*
|*	  Beschreibung
|*	  Ersterstellung	09.11.94
|*	  Letzte Aenderung	09.11.94
|*
*************************************************************************/

void XOutputDevice::DrawArc( const Rectangle& rRect, const Point& rStart,
							 const Point& rEnd )
{
	const Polygon aPoly( rRect, rStart, rEnd, POLY_ARC );
	
	DrawFillPolyPolygon( aPoly );
	DrawLinePolygon( aPoly, TRUE );
}


/*************************************************************************
|*
|*	  XOutputDevice::DrawPie()
|*
|*	  Beschreibung
|*	  Ersterstellung	09.11.94
|*	  Letzte Aenderung	09.11.94
|*
*************************************************************************/

void XOutputDevice::DrawPie( const Rectangle& rRect, const Point& rStart,
							 const Point& rEnd )
{
	const Polygon aPoly( rRect, rStart, rEnd, POLY_PIE );
	
	DrawFillPolyPolygon( aPoly );
	DrawLinePolygon( aPoly, TRUE );
}

/*************************************************************************
|*
|*	  XOutputDevice::DrawPolygon()
|*
|*	  Beschreibung
|*	  Ersterstellung	08.11.94
|*	  Letzte Aenderung	08.11.94
|*
*************************************************************************/

void XOutputDevice::DrawPolygon( const Polygon& rPoly )
{
	DrawFillPolyPolygon( rPoly );
	DrawLinePolygon( rPoly, TRUE );
}

/*************************************************************************
|*
|*	  XOutputDevice::DrawXPolygon()
|*
|*	  Beschreibung		Polygon mit Linien- und Fuellstilen zeichnen
|*	  Ersterstellung	28.11.94 ESO
|*	  Letzte Aenderung	29.11.94 ESO
|*
\************************************************************************/

void XOutputDevice::DrawPolygon(const basegfx::B2DPolygon& rPolygon)
{
	if(rPolygon.count())
	{
        // #100127# Too much hassle below this method
		// const Polygon aPoly( XOutCreatePolygonBezier(rXPoly, pOut) );
		const Polygon aDrawPolygon(basegfx::tools::adaptiveSubdivideByAngle(rPolygon));
		DrawFillPolyPolygon(aDrawPolygon);
		DrawLinePolygon(aDrawPolygon, TRUE);
	}
}

/*************************************************************************
|*
|*	  XOutputDevice::DrawPolyPolygon()
|*
|*	  Beschreibung
|*	  Ersterstellung	08.11.94
|*	  Letzte Aenderung	08.11.94
|*
*************************************************************************/

void XOutputDevice::DrawPolyPolygon( const PolyPolygon& rPolyPoly )
{
	DrawFillPolyPolygon( rPolyPoly );

	if( eLineStyle != XLINE_NONE )
	{
		const USHORT nCount = rPolyPoly.Count();
		USHORT i;

		for( i = 0; i < nCount; i++ )
			DrawLinePolygon( rPolyPoly.GetObject(i), TRUE );
	}
}

/*************************************************************************
|*
|*	  XOutputDevice::DrawPolyPolygon()
|*
|*	  Beschreibung
|*	  Ersterstellung	08.11.94
|*	  Letzte Aenderung	29.11.94 ESO
|*
*************************************************************************/

void XOutputDevice::DrawPolyPolygon( const basegfx::B2DPolyPolygon& rPolyPolygon )
{
	const basegfx::B2DPolyPolygon aSubdividedPolyPolygon(basegfx::tools::adaptiveSubdivideByAngle(rPolyPolygon));
	const PolyPolygon aDrawPolyPolygon(aSubdividedPolyPolygon);
	DrawFillPolyPolygon(aDrawPolyPolygon);

	if(XLINE_NONE != eLineStyle)
	{
		const sal_uInt32 nCount(aSubdividedPolyPolygon.count());

		for(sal_uInt32 a(0L); a < nCount; a++ )
		{
			// #i74631# changed implicit Polygon constructor usage
			const Polygon aCandidate(aSubdividedPolyPolygon.getB2DPolygon(a));
			DrawLinePolygon(aCandidate, TRUE);
		}
	}
}

/*************************************************************************
|*
|*	  XOutputDevice::InitLineStartEnd()
|*
|*	  Polygon fuer Linienanfang bzw. -ende initialisieren; gibt die
|*	  Entfernung vom Polygon-Fixpunkt zum Linienansatz zurueck
|*	  Ersterstellung	16.01.95 ESO
|*	  Letzte Aenderung	28.07.95 SOH
|*
\************************************************************************/

long XOutputDevice::getLineStartEndDistance(const basegfx::B2DPolyPolygon& rPolyPolygon, long nNewWidth, bool bCenter)
{
	const basegfx::B2DRange aPolygonRange(basegfx::tools::getRange(basegfx::tools::adaptiveSubdivideByAngle(rPolyPolygon)));
	const double fOldWidth(aPolygonRange.getWidth() > 1.0 ? aPolygonRange.getWidth() : 1.0);
	const double fScale((double)nNewWidth / fOldWidth);
	long nHeight(FRound(aPolygonRange.getHeight() * fScale));

	if(bCenter)
	{
		nHeight /= 2L;
	}

	return nHeight;
}

long XOutputDevice::ImpInitLineStartEnd(basegfx::B2DPolyPolygon& rPolyPolygon, long nNewWidth, bool bCenter)
{
	const basegfx::B2DRange aPolygonRange(basegfx::tools::getRange(basegfx::tools::adaptiveSubdivideByAngle(rPolyPolygon)));
	const double fOldWidth(aPolygonRange.getWidth() > 1.0 ? aPolygonRange.getWidth() : 1.0);
	const double fScale((double)nNewWidth / fOldWidth);
	basegfx::B2DHomMatrix aMatrix;

	aMatrix.translate(-aPolygonRange.getCenter().getX(), (bCenter) ? -aPolygonRange.getCenter().getY() : -aPolygonRange.getMinY());
	aMatrix.scale(fScale, fScale);
	rPolyPolygon.transform(aMatrix);

	long nHeight(FRound(aPolygonRange.getHeight() * fScale));

	if(bCenter)
	{
		nHeight /= 2L;
	}

	return nHeight;
}

/*************************************************************************
|*
|*	  XOutputDevice::SetLineAttr()
|*
|*	  Linienattribute aus ItemSet auslesen und am OutputDevice setzen
|*	  Ersterstellung	17.11.94 ESO
|*	  Letzte Aenderung	09.10.95 ESO
|*
\************************************************************************/

//-/void XOutputDevice::SetLineAttr(const XLineAttrSetItem& rAttr)
void XOutputDevice::SetLineAttr(const SfxItemSet& rSet)
{
//-/	const SfxItemSet&	rSet = rAttr.GetItemSet();
	const BOOL			bPureMtf = ( pOut->GetOutDevType() != OUTDEV_PRINTER ) && ( pOut->GetConnectMetaFile() != NULL );

	aLineColor = ((const XLineColorItem&)(rSet.Get(XATTR_LINECOLOR))).GetColorValue();
	nLineTransparence = ITEMVALUE( rSet, XATTR_LINETRANSPARENCE, XLineTransparenceItem );

	delete[] pLinePattern;
	pLinePattern = NULL;
	bLineStart = FALSE;
	bLineEnd = FALSE;
	bHair = TRUE;
	nLineWidth = ITEMVALUE( rSet, XATTR_LINEWIDTH, XLineWidthItem );

	if( bIgnoreLineAttr )
	{
		// fuer Linien mit Staerke Null wird im "Nur Haarlinienmodus" ein Hellgrau-Pen benutzt
		if( nLineWidth == 0 )
			pOut->SetLineColor( COL_LIGHTGRAY );
		else
		{
			nLineWidth = 0;
			pOut->SetLineColor( aLineColor );
		}
	}
	else
	{
		long nMinLineWidth = Max( nLineWidth, pOut->PixelToLogic( Size( 2, 2 ) ) .Width() );

		eLineStyle = ITEMVALUE( rSet, XATTR_LINESTYLE, XLineStyleItem );

		// Falls wir Linienstil ignorieren, setzen wir Linienstil auf Solid
		if ( bIgnoreLineStyle )
		{
			eLineStyle = XLINE_SOLID;
			pOut->SetLineColor( COL_BLACK );
		}

		// bei reinen Metafiles auch sehr duenne Linien als Polygone ausgeben,
		// damit wir hier eine hoehere Genauigkeit wegen der Systemunabhaegigkeit erreichen
		// SB: aber nicht, wenn gedruckt wird (dabei wird immer ein Metafile aufgezeichnet)
		if ( bPureMtf )
			nMinLineWidth /= MTF_DIVISOR;

		if ( eLineStyle == XLINE_DASH )
		{
			USHORT	i, nCnt, nDotCnt;
			long	nDotLen, nDashLen, nDistance;
			long	nMinLength = nMinLineWidth;

			const XDash& rDash = ((const XLineDashItem&)(rSet.Get(XATTR_LINEDASH))).GetDashValue();

			// Sonderbehandlung fuer Haarlinien
			if ( nLineWidth < nMinLineWidth )
				nMinLength = 30;

			nDotCnt = rDash.GetDots() << 1;
			nLinePatternCnt = nDotCnt + ( rDash.GetDashes() << 1 ) + 1;
			pLinePattern = new long[nLinePatternCnt];
			nCnt = 0;
			nDotLen = rDash.GetDotLen();
			nDashLen = rDash.GetDashLen();
			nDistance = rDash.GetDistance();

			if ( rDash.GetDashStyle() == XDASH_RECTRELATIVE || rDash.GetDashStyle() == XDASH_ROUNDRELATIVE )
			{
				// Der Teilungsfaktor ist abhaengig davon,
				// ob wir uns in einer reinen Mtf-Aufzeichnung
				// befinden oder nicht. Wenn ja, muessen
				// wir dieses bei der Laengenberechn. beruecks.,
				// um gleiche Ergebnisse zu bekommen; die hoehere
				// Genauigkeit im Mtf bezieht sich nur auf die Breite
				// (KA 29.09.96)
				const long nFactor = nMinLength * ( bPureMtf ? MTF_DIVISOR : 1 );

				nDotLen = nDotLen * nFactor / 100;
				nDashLen = nDashLen * nFactor / 100;
				nDistance = nDistance * nFactor / 100;
			}

			if ( nDotLen == 0 )
				nDotLen = nMinLength;
			if ( nDashLen == 0 )
				nDashLen = nMinLength;

			for (i = 0; i < nDotCnt; i += 2)
			{
				if ( nDotLen )
				{
					pLinePattern[nCnt++] = nDotLen;
					pLinePattern[nCnt++] = nDistance;
				}
			}
			for ( ; i < nLinePatternCnt - 1; i += 2)
			{
				if ( nDashLen )
				{
					pLinePattern[nCnt++] = nDashLen;
					pLinePattern[nCnt++] = nDistance;
				}
			}
			if ( !nCnt )
			{
				eLineStyle = XLINE_SOLID;
				delete pLinePattern;
				pLinePattern = NULL;
			}
			else
				pLinePattern[nCnt] = 0;
		}


		if ( nLineWidth < nMinLineWidth && eLineStyle == XLINE_SOLID )
		{
			nLineWidth = 0;
			pOut->SetLineColor( aLineColor );
		}
		else
		{
			bHair = FALSE;
			pOut->SetLineColor();
			
			if( nLineWidth < nMinLineWidth )
				nLineWidth = 0;
		}
		const SfxPoolItem* pPoolItem;

		// Polygon und Daten fuer Linienanfang und -ende initialisieren
		if ( rSet.GetItemState(XATTR_LINESTART, TRUE, &pPoolItem) == SFX_ITEM_SET )
		{
			long nWidth = ITEMVALUE( rSet, XATTR_LINESTARTWIDTH, XLineStartWidthItem );

			maLineStartPolyPolygon = ((XLineStartItem*) pPoolItem)->GetLineStartValue();

			// Nur aktivieren, wenn Polygonbreite > 0
			if ( nWidth )
			{
				// Breite negativ: Prozentwert
				if ( nWidth < 0 )
				{
					nWidth = - nMinLineWidth * nWidth / 100;
					if ( nWidth == 0 ) nWidth = nMinLineWidth;
				}
				BOOL bCenter = ITEMVALUE( rSet, XATTR_LINESTARTCENTER, XLineStartCenterItem );
				nLineStartSqLen = ImpInitLineStartEnd(maLineStartPolyPolygon, nWidth, bCenter);
				// 4/5, um Ueberschneidung zu Gewaehrleisten
				nLineStartSqLen = nLineStartSqLen * 4 / 5;
				nLineStartSqLen = nLineStartSqLen * nLineStartSqLen;
				bLineStart = TRUE;
			}
		}
		if ( rSet.GetItemState(XATTR_LINEEND, TRUE, &pPoolItem) == SFX_ITEM_SET )
		{
			long nWidth = ITEMVALUE( rSet, XATTR_LINEENDWIDTH, XLineEndWidthItem );

			maLineEndPolyPolygon = ((XLineEndItem*) pPoolItem)->GetLineEndValue();

			if ( nWidth )
			{
				// Breite negativ: Prozentwert
				if ( nWidth < 0 )
				{
					nWidth = - nMinLineWidth * nWidth / 100;
					if ( nWidth == 0 ) nWidth = nMinLineWidth;
				}
				BOOL bCenter = ITEMVALUE( rSet, XATTR_LINEENDCENTER, XLineEndCenterItem );
				nLineEndSqLen = ImpInitLineStartEnd(maLineEndPolyPolygon, nWidth, bCenter);
				nLineEndSqLen = nLineEndSqLen * 4 / 5;
				nLineEndSqLen = nLineEndSqLen * nLineEndSqLen;
				bLineEnd = TRUE;
			}
		}
	}
}

/*************************************************************************
|*
|*	  XOutputDevice::SetFillAttr()
|*
|*	  Fuellattribute aus ItemSet auslesen und am OutputDevice setzen
|*	  Ersterstellung	17.11.94 ESO
|*	  Letzte Aenderung	26.06.95 ESO
|*
\************************************************************************/

//-/void XOutputDevice::SetFillAttr(const XFillAttrSetItem& rAttr)
void XOutputDevice::SetFillAttr(const SfxItemSet& rSet)
{
//-/	const SfxItemSet&					rSet = rAttr.GetItemSet();
	const XFillFloatTransparenceItem&	rFloatTransItem =  (const XFillFloatTransparenceItem&) rSet.Get( XATTR_FILLFLOATTRANSPARENCE );
	
	eFillStyle = bIgnoreFillAttr ? XFILL_NONE : ITEMVALUE( rSet, XATTR_FILLSTYLE, XFillStyleItem );
	nFillTransparence = ITEMVALUE( rSet, XATTR_FILLTRANSPARENCE, XFillTransparenceItem );

	// clear bitmap
	if( eFillStyle != XFILL_BITMAP )
	{
        maFillBitmap.SetEmpty();
		maFillBitmapSize.Width() = maFillBitmapSize.Height() = 0L;
	}

	// assign transparent gradient?
	if( ( eFillStyle != XFILL_NONE ) && ( rFloatTransItem.IsEnabled() || nFillTransparence ) )
	{
		XGradient aXGrad;

		if( rFloatTransItem.IsEnabled() )
			aXGrad = rFloatTransItem.GetGradientValue();
		else
		{
			const BYTE	cTrans = (BYTE) ( nFillTransparence * 255 / 100 );
			const Color aTransCol( cTrans, cTrans, cTrans );

			aXGrad.SetGradientStyle( XGRAD_LINEAR );
			aXGrad.SetStartColor( aTransCol );
			aXGrad.SetEndColor( aTransCol );
			aXGrad.SetAngle( 0 );
			aXGrad.SetBorder( 0 );
			aXGrad.SetXOffset( 0 );
			aXGrad.SetYOffset( 0 );
			aXGrad.SetStartIntens( 100 );
			aXGrad.SetEndIntens( 100 );
			aXGrad.SetSteps( 3 );
		}

		if( pTransGradient )
			*pTransGradient = aXGrad;
		else
			pTransGradient	= new XGradient( aXGrad );
	}
	else if( pTransGradient )
	{
		delete pTransGradient;
		pTransGradient = NULL;
	}

	if( eFillStyle != XFILL_NONE )
	{
		aFillColor = ((const XFillColorItem&)(rSet.Get(XATTR_FILLCOLOR))).GetColorValue();
		pOut->SetFillColor(aFillColor);

		if( eFillStyle == XFILL_BITMAP )
		{
			MapMode		aMapMode( pOut->GetMapMode() );
			Bitmap		aBmp(((const XFillBitmapItem&)(rSet.Get(XATTR_FILLBITMAP))).GetBitmapValue().GetBitmap());
			USHORT		nOffX = ITEMVALUE( rSet, XATTR_FILLBMP_TILEOFFSETX, SfxUInt16Item );
			USHORT		nOffY = ITEMVALUE( rSet, XATTR_FILLBMP_TILEOFFSETY, SfxUInt16Item );
			USHORT		nOffPosX = ITEMVALUE( rSet, XATTR_FILLBMP_POSOFFSETX, SfxUInt16Item );
			USHORT		nOffPosY = ITEMVALUE( rSet, XATTR_FILLBMP_POSOFFSETY, SfxUInt16Item );
			RECT_POINT	eRectPoint = (RECT_POINT) ITEMVALUE( rSet, XATTR_FILLBMP_POS, SfxEnumItem );
			BOOL		bTile = ITEMVALUE( rSet, XATTR_FILLBMP_TILE, SfxBoolItem );
			BOOL		bStretch = ITEMVALUE( rSet, XATTR_FILLBMP_STRETCH, SfxBoolItem );
			BOOL		bLogSize = ITEMVALUE( rSet, XATTR_FILLBMP_SIZELOG, SfxBoolItem );
			Size		aSize( labs( ITEMVALUE( rSet, XATTR_FILLBMP_SIZEX, SfxMetricItem ) ),
                               labs( ITEMVALUE( rSet, XATTR_FILLBMP_SIZEY, SfxMetricItem ) ) );

			// #116949#
			// removed the caching of the last output bitmap.
			maFillBitmap = aBmp;
			maLastMapMode = aMapMode;
			meLastOutDevType = pOut->GetOutDevType();

			mbBmpTile = bTile;
			mbBmpStretch = bStretch;
			mbBmpLogSize = bLogSize;
			mnBmpOffX = nOffX;
			mnBmpOffY = nOffY;
			meBmpRectPoint = eRectPoint;
			mnBmpOffPosX = nOffPosX;
			mnBmpOffPosY = nOffPosY;

			if( bLogSize )
				maBmpSize = aSize;
			else
			{
				mnBmpPerCentX = (USHORT) aSize.Width();
				mnBmpPerCentY = (USHORT) aSize.Height();
			}

			mbRecalc = TRUE;
		}
		else if (eFillStyle == XFILL_GRADIENT)
		{
			aGradient = ((const XFillGradientItem&)(rSet.Get(XATTR_FILLGRADIENT))).GetGradientValue();
			aGradient.SetSteps( ITEMVALUE( rSet, XATTR_GRADIENTSTEPCOUNT, XGradientStepCountItem ) );
		}
		else if( eFillStyle == XFILL_HATCH )
		{
			bSolidHatch = ITEMVALUE( rSet, XATTR_FILLBACKGROUND, XFillBackgroundItem );
			aHatch = ((const XFillHatchItem&)(rSet.Get(XATTR_FILLHATCH))).GetHatchValue();
		}
	}
	else
		pOut->SetFillColor();
}


/*************************************************************************
|*
|*	  XOutputDevice::SetTextAttr()
|*
|*	  Textattribute aus ItemSet auslesen und am OutputDevice setzen
|*	  Ersterstellung	02.02.95 ESO
|*	  Letzte Aenderung	27.06.95 ESO
|*
\************************************************************************/

//-/void XOutputDevice::SetTextAttr(const XTextAttrSetItem& rAttr)
void XOutputDevice::SetTextAttr(const SfxItemSet& rSet)
{
//-/	const SfxItemSet& rSet = rAttr.GetItemSet();

	eFormTextStyle = ITEMVALUE( rSet, XATTR_FORMTXTSTYLE, XFormTextStyleItem );
	eFormTextAdjust = ITEMVALUE( rSet, XATTR_FORMTXTADJUST, XFormTextAdjustItem );
	nFormTextDistance = ITEMVALUE( rSet, XATTR_FORMTXTDISTANCE, XFormTextDistanceItem );
	nFormTextStart = ITEMVALUE( rSet, XATTR_FORMTXTSTART, XFormTextStartItem );
	bFormTextMirror = ITEMVALUE( rSet, XATTR_FORMTXTMIRROR, XFormTextMirrorItem );

	// Neu ab 27.06.95 ESO
	bFormTextOutline = ITEMVALUE( rSet, XATTR_FORMTXTOUTLINE, XFormTextOutlineItem );
	eFormTextShadow = ITEMVALUE( rSet, XATTR_FORMTXTSHADOW, XFormTextShadowItem );
	aFormTextShdwColor = ((const XFormTextShadowColorItem&)(rSet.Get(XATTR_FORMTXTSHDWCOLOR))).GetColorValue();

	// Neu ab 09.11.95 KA
	nFormTextShdwTransp	= ITEMVALUE( rSet, XATTR_FORMTXTSHDWTRANSP, XFormTextShadowTranspItem );
	nFormTextShdwXVal = ITEMVALUE( rSet, XATTR_FORMTXTSHDWXVAL, XFormTextShadowXValItem );
	nFormTextShdwYVal = ITEMVALUE( rSet, XATTR_FORMTXTSHDWYVAL, XFormTextShadowYValItem );
	eFormTextStdForm = ITEMVALUE( rSet, XATTR_FORMTXTSTDFORM, XFormTextStdFormItem );
	bFormTextHideForm = ITEMVALUE( rSet, XATTR_FORMTXTHIDEFORM, XFormTextHideFormItem );
}

/*************************************************************************
|*
|*	  XOutputDevice:OverrideLineColor()
|*
|*	  StarView-Linecolor temporaer ueberschreiben, wenn SetLineAttr zu
|*	  zeitkritisch ist. !ACHTUNG! Vor weiteren XOut-Ausgaben muessen
|*	  die Attribute mit SetLineAttr neu gesetzt werden
|*	  Ersterstellung	26.06.95 ESO
|*	  Letzte Aenderung	26.06.95 ESO
|*
\************************************************************************/

void XOutputDevice::OverrideLineColor(const Color& rColor )
{
	nLineWidth = 0;
	bHair = TRUE;
	bLineStart = FALSE;
	bLineEnd = FALSE;
	eLineStyle = ( rColor.GetColor() == COL_TRANSPARENT ) ? XLINE_NONE : XLINE_SOLID;
	pOut->SetLineColor( rColor );
}

/*************************************************************************
|*
|*	  XOutputDevice::OverrideFillColor()
|*
|*	  StarView-Brush temporaer ueberschreiben, wenn SetFillAttr zu
|*	  zeitkritisch ist. !ACHTUNG! Vor weiteren XOut-Ausgaben muessen
|*	  die Attribute mit SetFillAttr neu gesetzt werden
|*	  Ersterstellung	26.06.95 ESO
|*	  Letzte Aenderung	26.06.95 ESO
|*
\************************************************************************/

void XOutputDevice::OverrideFillColor( const Color& rColor )
{
	eFillStyle = ( rColor.GetColor() == COL_TRANSPARENT ) ? XFILL_NONE : XFILL_SOLID;
	pOut->SetFillColor( rColor );
}
