import com.sun.star.uno.Type;
/*************************************************************************
 *
 *  $RCSfile: XUnoNode.java,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2007-04-04 09:25:00 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  the BSD license.
 *  
 *  Copyright (c) 2003 by Sun Microsystems, Inc.
 *  All rights reserved.
 *
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions
 *  are met:
 *  1. Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 *  2. Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution.
 *  3. Neither the name of Sun Microsystems, Inc. nor the names of its
 *     contributors may be used to endorse or promote products derived
 *     from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 *  FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 *  COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 *  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 *  BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS
 *  OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 *  ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
 *  TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 *  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *     
 *************************************************************************/


public interface XUnoNode {

    public static final int nINTERFACE = 1;
    public static final int nSERVICE = 2;
    public static final int nOTHERS = 3;
    
    public String getAnchor();
    
    public String getClassName();
    
    public void openIdlDescription(String _sIDLUrl);
    
    public boolean isFilterApplicable(String _sFilter);
    
    public void setVisible(String _sFilter);
                
    public void setParameterObjects(Object[] _oParamObjects);
    
    public Object[] getParameterObjects();
    
    public String getName();
    
    public void setFoldable(boolean _bIsFoldable);
    
    public Object getUnoObject();
    
    public XUnoNode getParentNode();
    
    public void addChildNode(XUnoNode _xUnoNode);
    
    public void  setLabel(String _sLabel);

    public String getLabel();
    
    public int getChildCount();
    
    public XUnoNode getChild(int _index);
    
    public int getNodeType();
    
    // possible values are nINTERFACE, nSERVICE, nOTHERS
    public void setNodeType(int _nNodeType);
    
    /** delivers only the Uno-Type when the NodeType is set to nINTERFACE
     *  otherwise (when the NodeType has not been set returns null
     */
    public Type getUnoType();
}
