/*************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 * 
 * Copyright 2008 by Sun Microsystems, Inc.
 *
 * OpenOffice.org - a multi-platform office productivity suite
 *
 * $RCSfile: encryptionengine.hxx,v $
 * $Revision: 1.4 $
 *
 * This file is part of OpenOffice.org.
 *
 * OpenOffice.org is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * OpenOffice.org is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with OpenOffice.org.  If not, see
 * <http://www.openoffice.org/license.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/

#ifndef _ENCRYPTIONENGINE_HXX
#define _ENCRYPTIONENGINE_HXX

#include <com/sun/star/xml/crypto/sax/XReferenceResolvedListener.hpp>
#include <com/sun/star/xml/crypto/sax/XReferenceResolvedBroadcaster.hpp>
#include <com/sun/star/xml/crypto/sax/XBlockerMonitor.hpp>
#include <com/sun/star/xml/crypto/sax/XKeyCollector.hpp>
#include <com/sun/star/xml/crypto/sax/XMissionTaker.hpp>
#include <com/sun/star/xml/crypto/sax/XSAXEventKeeper.hpp>
#include <com/sun/star/xml/crypto/XXMLSecurityContext.hpp>
#include <com/sun/star/xml/crypto/XXMLEncryption.hpp>
#include <cppuhelper/implbase1.hxx>

#include "securityengine.hxx"

class EncryptionEngine : public cppu::ImplInheritanceHelper1
< 
	SecurityEngine, 
	com::sun::star::xml::crypto::sax::XBlockerMonitor
>
/****** encryptionEngine.hxx/CLASS encryptionEngine ***************************
 *
 *   NAME
 *	EncryptionEngine -- Base class of Encryptor and Decryptor
 *
 *   FUNCTION
 *	Maintains common members and methods related with encryption.
 *
 *   HISTORY
 *	05.01.2004 -	Interface supported: XBlockerMonitor
 *
 *   AUTHOR
 *	Michael Mi
 *	Email: michael.mi@sun.com
 ******************************************************************************/
{
protected:
	/*
	 * the Encryption bridge component, which performs encrypt and decrypt
	 * operation based on xmlsec library.
	 */
	com::sun::star::uno::Reference< 
		com::sun::star::xml::crypto::XXMLEncryption > m_xXMLEncryption;

	/*
	 * the Id of template blocker.
	 */
	sal_Int32 m_nIdOfBlocker;
	
protected:
	EncryptionEngine( );
	virtual ~EncryptionEngine(){};
	
	virtual void tryToPerform( ) 
		throw (com::sun::star::uno::Exception, com::sun::star::uno::RuntimeException);
	virtual void clearUp( ) const;	
	virtual bool checkReady() const;
	
	/*
	 * starts the main function. This method will be implemented by any sub-class.
	 * For a Encryptor, it performs encryption operation;
	 * for a Decryptor, decryption operation is performed.
	 */
	virtual void startEngine( const com::sun::star::uno::Reference< 
		com::sun::star::xml::crypto::XXMLEncryptionTemplate >&)
		throw (com::sun::star::uno::Exception, com::sun::star::uno::RuntimeException)
		{};

public:
	/* XBlockerMonitor */
	virtual void SAL_CALL setBlockerId( sal_Int32 id )
    		throw (com::sun::star::uno::Exception, com::sun::star::uno::RuntimeException);
};

#endif

