/* A Bison parser, made by GNU Bison 1.875.  */

/* Skeleton parser for Yacc-like parsing with Bison,
   Copyright (C) 1984, 1989, 1990, 2000, 2001, 2002 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

/* As a special exception, when this file is copied by Bison into a
   Bison output file, you may use that output file without restriction.
   This special exception was added by the Free Software Foundation
   in version 1.24 of Bison.  */

/* Written by Richard Stallman by simplifying the original so called
   ``semantic'' parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Using locations.  */
#define YYLSP_NEEDED 1

/* If NAME_PREFIX is specified substitute the variables and functions
   names.  */
#define yyparse base_yyparse
#define yylex   base_yylex
#define yyerror base_yyerror
#define yylval  base_yylval
#define yychar  base_yychar
#define yydebug base_yydebug
#define yynerrs base_yynerrs
#define yylloc base_yylloc

/* Tokens.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
   /* Put the tokens into the symbol table, so that GDB and other debuggers
      know about them.  */
   enum yytokentype {
     SQL_ALLOCATE = 258,
     SQL_AUTOCOMMIT = 259,
     SQL_BOOL = 260,
     SQL_BREAK = 261,
     SQL_CALL = 262,
     SQL_CARDINALITY = 263,
     SQL_CONNECT = 264,
     SQL_COUNT = 265,
     SQL_DATETIME_INTERVAL_CODE = 266,
     SQL_DATETIME_INTERVAL_PRECISION = 267,
     SQL_DESCRIBE = 268,
     SQL_DESCRIPTOR = 269,
     SQL_DISCONNECT = 270,
     SQL_FOUND = 271,
     SQL_FREE = 272,
     SQL_GET = 273,
     SQL_GO = 274,
     SQL_GOTO = 275,
     SQL_IDENTIFIED = 276,
     SQL_INDICATOR = 277,
     SQL_KEY_MEMBER = 278,
     SQL_LENGTH = 279,
     SQL_LONG = 280,
     SQL_NULLABLE = 281,
     SQL_OCTET_LENGTH = 282,
     SQL_OPEN = 283,
     SQL_OUTPUT = 284,
     SQL_REFERENCE = 285,
     SQL_RETURNED_LENGTH = 286,
     SQL_RETURNED_OCTET_LENGTH = 287,
     SQL_SCALE = 288,
     SQL_SECTION = 289,
     SQL_SHORT = 290,
     SQL_SIGNED = 291,
     SQL_SQL = 292,
     SQL_SQLERROR = 293,
     SQL_SQLPRINT = 294,
     SQL_SQLWARNING = 295,
     SQL_START = 296,
     SQL_STOP = 297,
     SQL_STRUCT = 298,
     SQL_UNSIGNED = 299,
     SQL_VAR = 300,
     SQL_WHENEVER = 301,
     S_ADD = 302,
     S_AND = 303,
     S_ANYTHING = 304,
     S_AUTO = 305,
     S_CONST = 306,
     S_DEC = 307,
     S_DIV = 308,
     S_DOTPOINT = 309,
     S_EQUAL = 310,
     S_EXTERN = 311,
     S_INC = 312,
     S_LSHIFT = 313,
     S_MEMPOINT = 314,
     S_MEMBER = 315,
     S_MOD = 316,
     S_MUL = 317,
     S_NEQUAL = 318,
     S_OR = 319,
     S_REGISTER = 320,
     S_RSHIFT = 321,
     S_STATIC = 322,
     S_SUB = 323,
     S_VOLATILE = 324,
     S_TYPEDEF = 325,
     TYPECAST = 326,
     CSTRING = 327,
     CVARIABLE = 328,
     CPP_LINE = 329,
     IP = 330,
     DOLCONST = 331,
     ECONST = 332,
     NCONST = 333,
     UCONST = 334,
     UIDENT = 335,
     ABORT_P = 336,
     ABSOLUTE_P = 337,
     ACCESS = 338,
     ACTION = 339,
     ADD_P = 340,
     ADMIN = 341,
     AFTER = 342,
     AGGREGATE = 343,
     ALL = 344,
     ALSO = 345,
     ALTER = 346,
     ALWAYS = 347,
     ANALYSE = 348,
     ANALYZE = 349,
     AND = 350,
     ANY = 351,
     ARRAY = 352,
     AS = 353,
     ASC = 354,
     ASSERTION = 355,
     ASSIGNMENT = 356,
     ASYMMETRIC = 357,
     AT = 358,
     AUTHORIZATION = 359,
     BACKWARD = 360,
     BEFORE = 361,
     BEGIN_P = 362,
     BETWEEN = 363,
     BIGINT = 364,
     BINARY = 365,
     BIT = 366,
     BOOLEAN_P = 367,
     BOTH = 368,
     BY = 369,
     CACHE = 370,
     CALLED = 371,
     CASCADE = 372,
     CASCADED = 373,
     CASE = 374,
     CAST = 375,
     CATALOG_P = 376,
     CHAIN = 377,
     CHAR_P = 378,
     CHARACTER = 379,
     CHARACTERISTICS = 380,
     CHECK = 381,
     CHECKPOINT = 382,
     CLASS = 383,
     CLOSE = 384,
     CLUSTER = 385,
     COALESCE = 386,
     COLLATE = 387,
     COLUMN = 388,
     COMMENT = 389,
     COMMIT = 390,
     COMMITTED = 391,
     CONCURRENTLY = 392,
     CONFIGURATION = 393,
     CONNECTION = 394,
     CONSTRAINT = 395,
     CONSTRAINTS = 396,
     CONTENT_P = 397,
     CONTINUE_P = 398,
     CONVERSION_P = 399,
     COPY = 400,
     COST = 401,
     CREATE = 402,
     CREATEDB = 403,
     CREATEROLE = 404,
     CREATEUSER = 405,
     CROSS = 406,
     CSV = 407,
     CURRENT_P = 408,
     CURRENT_CATALOG = 409,
     CURRENT_DATE = 410,
     CURRENT_ROLE = 411,
     CURRENT_SCHEMA = 412,
     CURRENT_TIME = 413,
     CURRENT_TIMESTAMP = 414,
     CURRENT_USER = 415,
     CURSOR = 416,
     CYCLE = 417,
     DATA_P = 418,
     DATABASE = 419,
     DAY_P = 420,
     DEALLOCATE = 421,
     DEC = 422,
     DECIMAL_P = 423,
     DECLARE = 424,
     DEFAULT = 425,
     DEFAULTS = 426,
     DEFERRABLE = 427,
     DEFERRED = 428,
     DEFINER = 429,
     DELETE_P = 430,
     DELIMITER = 431,
     DELIMITERS = 432,
     DESC = 433,
     DICTIONARY = 434,
     DISABLE_P = 435,
     DISCARD = 436,
     DISTINCT = 437,
     DO = 438,
     DOCUMENT_P = 439,
     DOMAIN_P = 440,
     DOUBLE_P = 441,
     DROP = 442,
     EACH = 443,
     ELSE = 444,
     ENABLE_P = 445,
     ENCODING = 446,
     ENCRYPTED = 447,
     END_P = 448,
     ENUM_P = 449,
     ESCAPE = 450,
     EXCEPT = 451,
     EXCLUDING = 452,
     EXCLUSIVE = 453,
     EXECUTE = 454,
     EXISTS = 455,
     EXPLAIN = 456,
     EXTERNAL = 457,
     EXTRACT = 458,
     FALSE_P = 459,
     FAMILY = 460,
     FETCH = 461,
     FIRST_P = 462,
     FLOAT_P = 463,
     FOLLOWING = 464,
     FOR = 465,
     FORCE = 466,
     FOREIGN = 467,
     FORWARD = 468,
     FREEZE = 469,
     FROM = 470,
     FULL = 471,
     FUNCTION = 472,
     GLOBAL = 473,
     GRANT = 474,
     GRANTED = 475,
     GREATEST = 476,
     GROUP_P = 477,
     HANDLER = 478,
     HAVING = 479,
     HEADER_P = 480,
     HOLD = 481,
     HOUR_P = 482,
     IDENTITY_P = 483,
     IF_P = 484,
     ILIKE = 485,
     IMMEDIATE = 486,
     IMMUTABLE = 487,
     IMPLICIT_P = 488,
     IN_P = 489,
     INCLUDING = 490,
     INCREMENT = 491,
     INDEX = 492,
     INDEXES = 493,
     INHERIT = 494,
     INHERITS = 495,
     INITIALLY = 496,
     INNER_P = 497,
     INOUT = 498,
     INPUT_P = 499,
     INSENSITIVE = 500,
     INSERT = 501,
     INSTEAD = 502,
     INT_P = 503,
     INTEGER = 504,
     INTERSECT = 505,
     INTERVAL = 506,
     INTO = 507,
     INVOKER = 508,
     IS = 509,
     ISNULL = 510,
     ISOLATION = 511,
     JOIN = 512,
     KEY = 513,
     LANCOMPILER = 514,
     LANGUAGE = 515,
     LARGE_P = 516,
     LAST_P = 517,
     LC_COLLATE_P = 518,
     LC_CTYPE_P = 519,
     LEADING = 520,
     LEAST = 521,
     LEFT = 522,
     LEVEL = 523,
     LIKE = 524,
     LIMIT = 525,
     LISTEN = 526,
     LOAD = 527,
     LOCAL = 528,
     LOCALTIME = 529,
     LOCALTIMESTAMP = 530,
     LOCATION = 531,
     LOCK_P = 532,
     LOGIN_P = 533,
     MAPPING = 534,
     MATCH = 535,
     MAXVALUE = 536,
     MINUTE_P = 537,
     MINVALUE = 538,
     MODE = 539,
     MONTH_P = 540,
     MOVE = 541,
     NAME_P = 542,
     NAMES = 543,
     NATIONAL = 544,
     NATURAL = 545,
     NCHAR = 546,
     NEW = 547,
     NEXT = 548,
     NO = 549,
     NOCREATEDB = 550,
     NOCREATEROLE = 551,
     NOCREATEUSER = 552,
     NOINHERIT = 553,
     NOLOGIN_P = 554,
     NONE = 555,
     NOSUPERUSER = 556,
     NOT = 557,
     NOTHING = 558,
     NOTIFY = 559,
     NOTNULL = 560,
     NOWAIT = 561,
     NULL_P = 562,
     NULLIF = 563,
     NULLS_P = 564,
     NUMERIC = 565,
     OBJECT_P = 566,
     OF = 567,
     OFF = 568,
     OFFSET = 569,
     OIDS = 570,
     OLD = 571,
     ON = 572,
     ONLY = 573,
     OPERATOR = 574,
     OPTION = 575,
     OPTIONS = 576,
     OR = 577,
     ORDER = 578,
     OUT_P = 579,
     OUTER_P = 580,
     OVER = 581,
     OVERLAPS = 582,
     OVERLAY = 583,
     OWNED = 584,
     OWNER = 585,
     PARSER = 586,
     PARTIAL = 587,
     PARTITION = 588,
     PASSWORD = 589,
     PLACING = 590,
     PLANS = 591,
     POSITION = 592,
     PRECEDING = 593,
     PRECISION = 594,
     PRESERVE = 595,
     PREPARE = 596,
     PREPARED = 597,
     PRIMARY = 598,
     PRIOR = 599,
     PRIVILEGES = 600,
     PROCEDURAL = 601,
     PROCEDURE = 602,
     QUOTE = 603,
     RANGE = 604,
     READ = 605,
     REAL = 606,
     REASSIGN = 607,
     RECHECK = 608,
     RECURSIVE = 609,
     REFERENCES = 610,
     REINDEX = 611,
     RELATIVE_P = 612,
     RELEASE = 613,
     RENAME = 614,
     REPEATABLE = 615,
     REPLACE = 616,
     REPLICA = 617,
     RESET = 618,
     RESTART = 619,
     RESTRICT = 620,
     RETURNING = 621,
     RETURNS = 622,
     REVOKE = 623,
     RIGHT = 624,
     ROLE = 625,
     ROLLBACK = 626,
     ROW = 627,
     ROWS = 628,
     RULE = 629,
     SAVEPOINT = 630,
     SCHEMA = 631,
     SCROLL = 632,
     SEARCH = 633,
     SECOND_P = 634,
     SECURITY = 635,
     SELECT = 636,
     SEQUENCE = 637,
     SERIALIZABLE = 638,
     SERVER = 639,
     SESSION = 640,
     SESSION_USER = 641,
     SET = 642,
     SETOF = 643,
     SHARE = 644,
     SHOW = 645,
     SIMILAR = 646,
     SIMPLE = 647,
     SMALLINT = 648,
     SOME = 649,
     STABLE = 650,
     STANDALONE_P = 651,
     START = 652,
     STATEMENT = 653,
     STATISTICS = 654,
     STDIN = 655,
     STDOUT = 656,
     STORAGE = 657,
     STRICT_P = 658,
     STRIP_P = 659,
     SUBSTRING = 660,
     SUPERUSER_P = 661,
     SYMMETRIC = 662,
     SYSID = 663,
     SYSTEM_P = 664,
     TABLE = 665,
     TABLESPACE = 666,
     TEMP = 667,
     TEMPLATE = 668,
     TEMPORARY = 669,
     TEXT_P = 670,
     THEN = 671,
     TIME = 672,
     TIMESTAMP = 673,
     TO = 674,
     TRAILING = 675,
     TRANSACTION = 676,
     TREAT = 677,
     TRIGGER = 678,
     TRIM = 679,
     TRUE_P = 680,
     TRUNCATE = 681,
     TRUSTED = 682,
     TYPE_P = 683,
     UNBOUNDED = 684,
     UNCOMMITTED = 685,
     UNENCRYPTED = 686,
     UNION = 687,
     UNIQUE = 688,
     UNKNOWN = 689,
     UNLISTEN = 690,
     UNTIL = 691,
     UPDATE = 692,
     USER = 693,
     USING = 694,
     VACUUM = 695,
     VALID = 696,
     VALIDATOR = 697,
     VALUE_P = 698,
     VALUES = 699,
     VARCHAR = 700,
     VARIADIC = 701,
     VARYING = 702,
     VERBOSE = 703,
     VERSION_P = 704,
     VIEW = 705,
     VOLATILE = 706,
     WHEN = 707,
     WHERE = 708,
     WHITESPACE_P = 709,
     WINDOW = 710,
     WITH = 711,
     WITHOUT = 712,
     WORK = 713,
     WRAPPER = 714,
     WRITE = 715,
     XML_P = 716,
     XMLATTRIBUTES = 717,
     XMLCONCAT = 718,
     XMLELEMENT = 719,
     XMLFOREST = 720,
     XMLPARSE = 721,
     XMLPI = 722,
     XMLROOT = 723,
     XMLSERIALIZE = 724,
     YEAR_P = 725,
     YES_P = 726,
     ZONE = 727,
     NULLS_FIRST = 728,
     NULLS_LAST = 729,
     WITH_TIME = 730,
     IDENT = 731,
     FCONST = 732,
     SCONST = 733,
     BCONST = 734,
     XCONST = 735,
     Op = 736,
     ICONST = 737,
     PARAM = 738,
     POSTFIXOP = 739,
     UMINUS = 740
   };
#endif
#define SQL_ALLOCATE 258
#define SQL_AUTOCOMMIT 259
#define SQL_BOOL 260
#define SQL_BREAK 261
#define SQL_CALL 262
#define SQL_CARDINALITY 263
#define SQL_CONNECT 264
#define SQL_COUNT 265
#define SQL_DATETIME_INTERVAL_CODE 266
#define SQL_DATETIME_INTERVAL_PRECISION 267
#define SQL_DESCRIBE 268
#define SQL_DESCRIPTOR 269
#define SQL_DISCONNECT 270
#define SQL_FOUND 271
#define SQL_FREE 272
#define SQL_GET 273
#define SQL_GO 274
#define SQL_GOTO 275
#define SQL_IDENTIFIED 276
#define SQL_INDICATOR 277
#define SQL_KEY_MEMBER 278
#define SQL_LENGTH 279
#define SQL_LONG 280
#define SQL_NULLABLE 281
#define SQL_OCTET_LENGTH 282
#define SQL_OPEN 283
#define SQL_OUTPUT 284
#define SQL_REFERENCE 285
#define SQL_RETURNED_LENGTH 286
#define SQL_RETURNED_OCTET_LENGTH 287
#define SQL_SCALE 288
#define SQL_SECTION 289
#define SQL_SHORT 290
#define SQL_SIGNED 291
#define SQL_SQL 292
#define SQL_SQLERROR 293
#define SQL_SQLPRINT 294
#define SQL_SQLWARNING 295
#define SQL_START 296
#define SQL_STOP 297
#define SQL_STRUCT 298
#define SQL_UNSIGNED 299
#define SQL_VAR 300
#define SQL_WHENEVER 301
#define S_ADD 302
#define S_AND 303
#define S_ANYTHING 304
#define S_AUTO 305
#define S_CONST 306
#define S_DEC 307
#define S_DIV 308
#define S_DOTPOINT 309
#define S_EQUAL 310
#define S_EXTERN 311
#define S_INC 312
#define S_LSHIFT 313
#define S_MEMPOINT 314
#define S_MEMBER 315
#define S_MOD 316
#define S_MUL 317
#define S_NEQUAL 318
#define S_OR 319
#define S_REGISTER 320
#define S_RSHIFT 321
#define S_STATIC 322
#define S_SUB 323
#define S_VOLATILE 324
#define S_TYPEDEF 325
#define TYPECAST 326
#define CSTRING 327
#define CVARIABLE 328
#define CPP_LINE 329
#define IP 330
#define DOLCONST 331
#define ECONST 332
#define NCONST 333
#define UCONST 334
#define UIDENT 335
#define ABORT_P 336
#define ABSOLUTE_P 337
#define ACCESS 338
#define ACTION 339
#define ADD_P 340
#define ADMIN 341
#define AFTER 342
#define AGGREGATE 343
#define ALL 344
#define ALSO 345
#define ALTER 346
#define ALWAYS 347
#define ANALYSE 348
#define ANALYZE 349
#define AND 350
#define ANY 351
#define ARRAY 352
#define AS 353
#define ASC 354
#define ASSERTION 355
#define ASSIGNMENT 356
#define ASYMMETRIC 357
#define AT 358
#define AUTHORIZATION 359
#define BACKWARD 360
#define BEFORE 361
#define BEGIN_P 362
#define BETWEEN 363
#define BIGINT 364
#define BINARY 365
#define BIT 366
#define BOOLEAN_P 367
#define BOTH 368
#define BY 369
#define CACHE 370
#define CALLED 371
#define CASCADE 372
#define CASCADED 373
#define CASE 374
#define CAST 375
#define CATALOG_P 376
#define CHAIN 377
#define CHAR_P 378
#define CHARACTER 379
#define CHARACTERISTICS 380
#define CHECK 381
#define CHECKPOINT 382
#define CLASS 383
#define CLOSE 384
#define CLUSTER 385
#define COALESCE 386
#define COLLATE 387
#define COLUMN 388
#define COMMENT 389
#define COMMIT 390
#define COMMITTED 391
#define CONCURRENTLY 392
#define CONFIGURATION 393
#define CONNECTION 394
#define CONSTRAINT 395
#define CONSTRAINTS 396
#define CONTENT_P 397
#define CONTINUE_P 398
#define CONVERSION_P 399
#define COPY 400
#define COST 401
#define CREATE 402
#define CREATEDB 403
#define CREATEROLE 404
#define CREATEUSER 405
#define CROSS 406
#define CSV 407
#define CURRENT_P 408
#define CURRENT_CATALOG 409
#define CURRENT_DATE 410
#define CURRENT_ROLE 411
#define CURRENT_SCHEMA 412
#define CURRENT_TIME 413
#define CURRENT_TIMESTAMP 414
#define CURRENT_USER 415
#define CURSOR 416
#define CYCLE 417
#define DATA_P 418
#define DATABASE 419
#define DAY_P 420
#define DEALLOCATE 421
#define DEC 422
#define DECIMAL_P 423
#define DECLARE 424
#define DEFAULT 425
#define DEFAULTS 426
#define DEFERRABLE 427
#define DEFERRED 428
#define DEFINER 429
#define DELETE_P 430
#define DELIMITER 431
#define DELIMITERS 432
#define DESC 433
#define DICTIONARY 434
#define DISABLE_P 435
#define DISCARD 436
#define DISTINCT 437
#define DO 438
#define DOCUMENT_P 439
#define DOMAIN_P 440
#define DOUBLE_P 441
#define DROP 442
#define EACH 443
#define ELSE 444
#define ENABLE_P 445
#define ENCODING 446
#define ENCRYPTED 447
#define END_P 448
#define ENUM_P 449
#define ESCAPE 450
#define EXCEPT 451
#define EXCLUDING 452
#define EXCLUSIVE 453
#define EXECUTE 454
#define EXISTS 455
#define EXPLAIN 456
#define EXTERNAL 457
#define EXTRACT 458
#define FALSE_P 459
#define FAMILY 460
#define FETCH 461
#define FIRST_P 462
#define FLOAT_P 463
#define FOLLOWING 464
#define FOR 465
#define FORCE 466
#define FOREIGN 467
#define FORWARD 468
#define FREEZE 469
#define FROM 470
#define FULL 471
#define FUNCTION 472
#define GLOBAL 473
#define GRANT 474
#define GRANTED 475
#define GREATEST 476
#define GROUP_P 477
#define HANDLER 478
#define HAVING 479
#define HEADER_P 480
#define HOLD 481
#define HOUR_P 482
#define IDENTITY_P 483
#define IF_P 484
#define ILIKE 485
#define IMMEDIATE 486
#define IMMUTABLE 487
#define IMPLICIT_P 488
#define IN_P 489
#define INCLUDING 490
#define INCREMENT 491
#define INDEX 492
#define INDEXES 493
#define INHERIT 494
#define INHERITS 495
#define INITIALLY 496
#define INNER_P 497
#define INOUT 498
#define INPUT_P 499
#define INSENSITIVE 500
#define INSERT 501
#define INSTEAD 502
#define INT_P 503
#define INTEGER 504
#define INTERSECT 505
#define INTERVAL 506
#define INTO 507
#define INVOKER 508
#define IS 509
#define ISNULL 510
#define ISOLATION 511
#define JOIN 512
#define KEY 513
#define LANCOMPILER 514
#define LANGUAGE 515
#define LARGE_P 516
#define LAST_P 517
#define LC_COLLATE_P 518
#define LC_CTYPE_P 519
#define LEADING 520
#define LEAST 521
#define LEFT 522
#define LEVEL 523
#define LIKE 524
#define LIMIT 525
#define LISTEN 526
#define LOAD 527
#define LOCAL 528
#define LOCALTIME 529
#define LOCALTIMESTAMP 530
#define LOCATION 531
#define LOCK_P 532
#define LOGIN_P 533
#define MAPPING 534
#define MATCH 535
#define MAXVALUE 536
#define MINUTE_P 537
#define MINVALUE 538
#define MODE 539
#define MONTH_P 540
#define MOVE 541
#define NAME_P 542
#define NAMES 543
#define NATIONAL 544
#define NATURAL 545
#define NCHAR 546
#define NEW 547
#define NEXT 548
#define NO 549
#define NOCREATEDB 550
#define NOCREATEROLE 551
#define NOCREATEUSER 552
#define NOINHERIT 553
#define NOLOGIN_P 554
#define NONE 555
#define NOSUPERUSER 556
#define NOT 557
#define NOTHING 558
#define NOTIFY 559
#define NOTNULL 560
#define NOWAIT 561
#define NULL_P 562
#define NULLIF 563
#define NULLS_P 564
#define NUMERIC 565
#define OBJECT_P 566
#define OF 567
#define OFF 568
#define OFFSET 569
#define OIDS 570
#define OLD 571
#define ON 572
#define ONLY 573
#define OPERATOR 574
#define OPTION 575
#define OPTIONS 576
#define OR 577
#define ORDER 578
#define OUT_P 579
#define OUTER_P 580
#define OVER 581
#define OVERLAPS 582
#define OVERLAY 583
#define OWNED 584
#define OWNER 585
#define PARSER 586
#define PARTIAL 587
#define PARTITION 588
#define PASSWORD 589
#define PLACING 590
#define PLANS 591
#define POSITION 592
#define PRECEDING 593
#define PRECISION 594
#define PRESERVE 595
#define PREPARE 596
#define PREPARED 597
#define PRIMARY 598
#define PRIOR 599
#define PRIVILEGES 600
#define PROCEDURAL 601
#define PROCEDURE 602
#define QUOTE 603
#define RANGE 604
#define READ 605
#define REAL 606
#define REASSIGN 607
#define RECHECK 608
#define RECURSIVE 609
#define REFERENCES 610
#define REINDEX 611
#define RELATIVE_P 612
#define RELEASE 613
#define RENAME 614
#define REPEATABLE 615
#define REPLACE 616
#define REPLICA 617
#define RESET 618
#define RESTART 619
#define RESTRICT 620
#define RETURNING 621
#define RETURNS 622
#define REVOKE 623
#define RIGHT 624
#define ROLE 625
#define ROLLBACK 626
#define ROW 627
#define ROWS 628
#define RULE 629
#define SAVEPOINT 630
#define SCHEMA 631
#define SCROLL 632
#define SEARCH 633
#define SECOND_P 634
#define SECURITY 635
#define SELECT 636
#define SEQUENCE 637
#define SERIALIZABLE 638
#define SERVER 639
#define SESSION 640
#define SESSION_USER 641
#define SET 642
#define SETOF 643
#define SHARE 644
#define SHOW 645
#define SIMILAR 646
#define SIMPLE 647
#define SMALLINT 648
#define SOME 649
#define STABLE 650
#define STANDALONE_P 651
#define START 652
#define STATEMENT 653
#define STATISTICS 654
#define STDIN 655
#define STDOUT 656
#define STORAGE 657
#define STRICT_P 658
#define STRIP_P 659
#define SUBSTRING 660
#define SUPERUSER_P 661
#define SYMMETRIC 662
#define SYSID 663
#define SYSTEM_P 664
#define TABLE 665
#define TABLESPACE 666
#define TEMP 667
#define TEMPLATE 668
#define TEMPORARY 669
#define TEXT_P 670
#define THEN 671
#define TIME 672
#define TIMESTAMP 673
#define TO 674
#define TRAILING 675
#define TRANSACTION 676
#define TREAT 677
#define TRIGGER 678
#define TRIM 679
#define TRUE_P 680
#define TRUNCATE 681
#define TRUSTED 682
#define TYPE_P 683
#define UNBOUNDED 684
#define UNCOMMITTED 685
#define UNENCRYPTED 686
#define UNION 687
#define UNIQUE 688
#define UNKNOWN 689
#define UNLISTEN 690
#define UNTIL 691
#define UPDATE 692
#define USER 693
#define USING 694
#define VACUUM 695
#define VALID 696
#define VALIDATOR 697
#define VALUE_P 698
#define VALUES 699
#define VARCHAR 700
#define VARIADIC 701
#define VARYING 702
#define VERBOSE 703
#define VERSION_P 704
#define VIEW 705
#define VOLATILE 706
#define WHEN 707
#define WHERE 708
#define WHITESPACE_P 709
#define WINDOW 710
#define WITH 711
#define WITHOUT 712
#define WORK 713
#define WRAPPER 714
#define WRITE 715
#define XML_P 716
#define XMLATTRIBUTES 717
#define XMLCONCAT 718
#define XMLELEMENT 719
#define XMLFOREST 720
#define XMLPARSE 721
#define XMLPI 722
#define XMLROOT 723
#define XMLSERIALIZE 724
#define YEAR_P 725
#define YES_P 726
#define ZONE 727
#define NULLS_FIRST 728
#define NULLS_LAST 729
#define WITH_TIME 730
#define IDENT 731
#define FCONST 732
#define SCONST 733
#define BCONST 734
#define XCONST 735
#define Op 736
#define ICONST 737
#define PARAM 738
#define POSTFIXOP 739
#define UMINUS 740




/* Copy the first part of user declarations.  */
#line 5 "preproc.y"

#include "postgres_fe.h"

#include "extern.h"
#include <unistd.h>

/* Location tracking support --- simpler than bison's default */
#define YYLLOC_DEFAULT(Current, Rhs, N) \
	do { \
                if (N) \
			(Current) = (Rhs)[1]; \
		else \
		        (Current) = (Rhs)[0]; \
	} while (0)

/*
 * The %name-prefix option below will make bison call base_yylex, but we
 * really want it to call filtered_base_yylex (see parser.c).
 */
#define base_yylex filtered_base_yylex

/*
 * This is only here so the string gets into the POT.  Bison uses it
 * internally.
 */
#define bison_gettext_dummy gettext_noop("syntax error")

/*
 * Variables containing simple states.
 */
int struct_level = 0;
int braces_open; /* brace level counter */
int ecpg_informix_var = 0;
char	*connection = NULL;
char	*input_filename = NULL;

static int	QueryIsRule = 0, FoundInto = 0;
static int	initializer = 0;
static int	pacounter = 1;
static char     pacounter_buffer[sizeof(int) * CHAR_BIT * 10 / 3]; /* a rough guess at the size we need */
static struct this_type actual_type[STRUCT_DEPTH];
static char *actual_startline[STRUCT_DEPTH];

/* temporarily store struct members while creating the data structure */
struct ECPGstruct_member *struct_member_list[STRUCT_DEPTH] = { NULL };

/* also store struct type so we can do a sizeof() later */
static char *ECPGstruct_sizeof = NULL;

/* for forward declarations we have to store some data as well */
static char *forward_name = NULL;

struct ECPGtype ecpg_no_indicator = {ECPGt_NO_INDICATOR, NULL, NULL, {NULL}, 0};
struct variable no_indicator = {"no_indicator", &ecpg_no_indicator, 0, NULL};

struct ECPGtype ecpg_query = {ECPGt_char_variable, NULL, NULL, {NULL}, 0};

/*
 * Handle parsing errors and warnings
 */
void
mmerror(int error_code, enum errortype type, const char *error, ...)
{
	va_list ap;

	/* internationalize the error message string */
	error = _(error);

	fprintf(stderr, "%s:%d: ", input_filename, yylineno);

	switch(type)
	{
		case ET_WARNING:
			fprintf(stderr, _("WARNING: "));
			break;
		case ET_ERROR:
		case ET_FATAL:
			fprintf(stderr, _("ERROR: "));
			break;
	}

	va_start(ap, error);
	vfprintf(stderr, error, ap);
	va_end(ap);

	fprintf(stderr, "\n");

	switch(type)
	{
		case ET_WARNING:
			break;
		case ET_ERROR:
			ret_value = error_code;
			break;
		case ET_FATAL:
			if (yyin)
				fclose(yyin);
			if (yyout)
				fclose(yyout);
			
			if (strcmp(output_filename, "-") != 0 && unlink(output_filename) != 0)
			        fprintf(stderr, _("could not remove output file \"%s\"\n"), output_filename);
			exit(error_code);
	}
}

/*
 * string concatenation
 */

static char *
cat2_str(char *str1, char *str2)
{
	char * res_str	= (char *)mm_alloc(strlen(str1) + strlen(str2) + 2);

	strcpy(res_str, str1);
	if (strlen(str1) != 0 && strlen(str2) != 0)
		strcat(res_str, " ");
	strcat(res_str, str2);
	free(str1);
	free(str2);
	return(res_str);
}

static char *
cat_str(int count, ...)
{
	va_list		args;
	int			i;
	char		*res_str;

	va_start(args, count);

	res_str = va_arg(args, char *);

	/* now add all other strings */
	for (i = 1; i < count; i++)
		res_str = cat2_str(res_str, va_arg(args, char *));

	va_end(args);

	return(res_str);
}

char *
make_str(const char *str)
{
	char * res_str = (char *)mm_alloc(strlen(str) + 1);

	strcpy(res_str, str);
	return res_str;
}

static char *
make2_str(char *str1, char *str2)
{
	char * res_str	= (char *)mm_alloc(strlen(str1) + strlen(str2) + 1);

	strcpy(res_str, str1);
	strcat(res_str, str2);
	free(str1);
	free(str2);
	return(res_str);
}

static char *
make3_str(char *str1, char *str2, char *str3)
{
	char * res_str	= (char *)mm_alloc(strlen(str1) + strlen(str2) +strlen(str3) + 1);

	strcpy(res_str, str1);
	strcat(res_str, str2);
	strcat(res_str, str3);
	free(str1);
	free(str2);
	free(str3);
	return(res_str);
}

/* and the rest */
static char *
make_name(void)
{
	return mm_strdup(yytext);
}

static char *
create_questionmarks(char *name, bool array)
{
	struct variable *p = find_variable(name);
	int count;
	char *result = EMPTY;

	/* In case we have a struct, we have to print as many "?" as there are attributes in the struct
	 * An array is only allowed together with an element argument
	 * This is essantially only used for inserts, but using a struct as input parameter is an error anywhere else
	 * so we don't have to worry here. */

	if (p->type->type == ECPGt_struct || (array && p->type->type == ECPGt_array && p->type->u.element->type == ECPGt_struct))
	{
		struct ECPGstruct_member *m;

		if (p->type->type == ECPGt_struct)
			m = p->type->u.members;
		else
			m = p->type->u.element->u.members;

		for (count = 0; m != NULL; m=m->next, count++);
	}
	else
		count = 1;

	for (; count > 0; count --)
	{
		sprintf(pacounter_buffer, "$%d", pacounter++);
		result = cat_str(3, result, mm_strdup(pacounter_buffer), make_str(" , "));
	}

	/* removed the trailing " ," */

	result[strlen(result)-3] = '\0';
	return(result);
}

static char *
adjust_informix(struct arguments *list)
{
	/* Informix accepts DECLARE with variables that are out of scope when OPEN is called.
 	 * for instance you can declare variables in a function, and then subsequently use them
	 * {
	 *      declare_vars();
	 *      exec sql ... which uses vars declared in the above function
	 *
	 * This breaks standard and leads to some very dangerous programming.
	 * Since they do, we have to work around and accept their syntax as well.
	 * But we will do so ONLY in Informix mode.
	 * We have to change the variables to our own struct and just store the pointer instead of the variable
	 */

	 struct arguments *ptr;
	 char *result = make_str("");

	 for (ptr = list; ptr != NULL; ptr = ptr->next)
	 {
	 	char temp[20]; /* this should be sufficient unless you have 8 byte integers */
		char *original_var;

	 	/* change variable name to "ECPG_informix_get_var(<counter>)" */
		original_var = ptr->variable->name;
		sprintf(temp, "%d))", ecpg_informix_var);

		if ((ptr->variable->type->type != ECPGt_varchar && ptr->variable->type->type != ECPGt_char && ptr->variable->type->type != ECPGt_unsigned_char) && atoi(ptr->variable->type->size) > 1)
		{
			ptr->variable = new_variable(cat_str(4, make_str("("), mm_strdup(ecpg_type_name(ptr->variable->type->u.element->type)), make_str(" *)(ECPG_informix_get_var("), mm_strdup(temp)), ECPGmake_array_type(ECPGmake_simple_type(ptr->variable->type->u.element->type, make_str("1"), ptr->variable->type->u.element->lineno), ptr->variable->type->size), 0);
			sprintf(temp, "%d, (", ecpg_informix_var++);
		}
		else if ((ptr->variable->type->type == ECPGt_varchar || ptr->variable->type->type == ECPGt_char || ptr->variable->type->type == ECPGt_unsigned_char) && atoi(ptr->variable->type->size) > 1)
		{
			ptr->variable = new_variable(cat_str(4, make_str("("), mm_strdup(ecpg_type_name(ptr->variable->type->type)), make_str(" *)(ECPG_informix_get_var("), mm_strdup(temp)), ECPGmake_simple_type(ptr->variable->type->type, ptr->variable->type->size, ptr->variable->type->lineno), 0);
			sprintf(temp, "%d, (", ecpg_informix_var++);
		}
		else
		{
			ptr->variable = new_variable(cat_str(4, make_str("*("), mm_strdup(ecpg_type_name(ptr->variable->type->type)), make_str(" *)(ECPG_informix_get_var("), mm_strdup(temp)), ECPGmake_simple_type(ptr->variable->type->type, ptr->variable->type->size, ptr->variable->type->lineno), 0);
			sprintf(temp, "%d, &(", ecpg_informix_var++);
		}

		/* create call to "ECPG_informix_set_var(<counter>, <pointer>. <linen number>)" */
		result = cat_str(5, result, make_str("ECPG_informix_set_var("), mm_strdup(temp), mm_strdup(original_var), make_str("), __LINE__);\n"));

		/* now the indicator if there is one */
		if (ptr->indicator->type->type != ECPGt_NO_INDICATOR)
		{
			/* change variable name to "ECPG_informix_get_var(<counter>)" */
			original_var = ptr->indicator->name;
			sprintf(temp, "%d))", ecpg_informix_var);

			/* create call to "ECPG_informix_set_var(<counter>, <pointer>. <linen number>)" */
			if (atoi(ptr->indicator->type->size) > 1)
			{
				ptr->indicator = new_variable(cat_str(4, make_str("("), mm_strdup(ecpg_type_name(ptr->indicator->type->type)), make_str(" *)(ECPG_informix_get_var("), mm_strdup(temp)), ECPGmake_simple_type(ptr->indicator->type->type, ptr->indicator->type->size, ptr->variable->type->lineno), 0);
				sprintf(temp, "%d, (", ecpg_informix_var++);
			}
			else
			{
				ptr->indicator = new_variable(cat_str(4, make_str("*("), mm_strdup(ecpg_type_name(ptr->indicator->type->type)), make_str(" *)(ECPG_informix_get_var("), mm_strdup(temp)), ECPGmake_simple_type(ptr->indicator->type->type, ptr->indicator->type->size, ptr->variable->type->lineno), 0);
				sprintf(temp, "%d, &(", ecpg_informix_var++);
			}
			result = cat_str(5, result, make_str("ECPG_informix_set_var("), mm_strdup(temp), mm_strdup(original_var), make_str("), __LINE__);\n"));
		}
	 }

	 return result;
}

static struct cursor *
add_additional_variables(char *name, bool insert)
{
	struct cursor *ptr;
	struct arguments *p;

	for (ptr = cur; ptr != NULL; ptr=ptr->next)
	{
		if (strcmp(ptr->name, name) == 0)
			break;
	}

	if (ptr == NULL)
	{
		mmerror(PARSE_ERROR, ET_ERROR, "cursor \"%s\" does not exist", name);
		return NULL;
	}

	if (insert)
	{
		/* add all those input variables that were given earlier
		 * note that we have to append here but have to keep the existing order */
		for (p = ptr->argsinsert; p; p = p->next)
			add_variable_to_tail(&argsinsert, p->variable, p->indicator);
	}

	/* add all those output variables that were given earlier */
	for (p = ptr->argsresult; p; p = p->next)
		add_variable_to_tail(&argsresult, p->variable, p->indicator);

	return ptr;
}

static void
add_typedef(char *name, char * dimension, char * length, enum ECPGttype type_enum, char *type_dimension, char *type_index, int initializer, int array)
{
	/* add entry to list */
	struct typedefs *ptr, *this;

	if ((type_enum == ECPGt_struct ||
	     type_enum == ECPGt_union) &&
	    initializer == 1)
		mmerror(PARSE_ERROR, ET_ERROR, "initializer not allowed in type definition");
	else
	{
		for (ptr = types; ptr != NULL; ptr = ptr->next)
		{
			if (strcmp(name, ptr->name) == 0)
				/* re-definition is a bug */
				mmerror(PARSE_ERROR, ET_ERROR, "type \"%s\" is already defined", name);
		}
		adjust_array(type_enum, &dimension, &length, type_dimension, type_index, array, true);

		this = (struct typedefs *) mm_alloc(sizeof(struct typedefs));

		/* initial definition */
		this->next = types;
		this->name = name;
		this->brace_level = braces_open;
		this->type = (struct this_type *) mm_alloc(sizeof(struct this_type));
		this->type->type_enum = type_enum;
		this->type->type_str = mm_strdup(name);
		this->type->type_dimension = dimension; /* dimension of array */
		this->type->type_index = length;	/* length of string */
		this->type->type_sizeof = ECPGstruct_sizeof;
		this->struct_member_list = (type_enum == ECPGt_struct || type_enum == ECPGt_union) ?
		ECPGstruct_member_dup(struct_member_list[struct_level]) : NULL;

		if (type_enum != ECPGt_varchar &&
			type_enum != ECPGt_char &&
			type_enum != ECPGt_unsigned_char &&
			atoi(this->type->type_index) >= 0)
			mmerror(PARSE_ERROR, ET_ERROR, "multidimensional arrays for simple data types are not supported");

		types = this;
	}
}


/* Enabling traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

#if ! defined (YYSTYPE) && ! defined (YYSTYPE_IS_DECLARED)
#line 383 "preproc.y"
typedef union YYSTYPE {
	double	dval;
	char	*str;
	int     ival;
	struct	when		action;
	struct	index		index;
	int		tagname;
	struct	this_type	type;
	enum	ECPGttype	type_enum;
	enum	ECPGdtype	dtype_enum;
	struct	fetch_desc	descriptor;
	struct  su_symbol	struct_union;
	struct	prep		prep;
} YYSTYPE;
/* Line 186 of yacc.c.  */
#line 1443 "preproc.c"
# define yystype YYSTYPE /* obsolescent; will be withdrawn */
# define YYSTYPE_IS_DECLARED 1
# define YYSTYPE_IS_TRIVIAL 1
#endif

#if ! defined (YYLTYPE) && ! defined (YYLTYPE_IS_DECLARED)
typedef struct YYLTYPE
{
  int first_line;
  int first_column;
  int last_line;
  int last_column;
} YYLTYPE;
# define yyltype YYLTYPE /* obsolescent; will be withdrawn */
# define YYLTYPE_IS_DECLARED 1
# define YYLTYPE_IS_TRIVIAL 1
#endif


/* Copy the second part of user declarations.  */


/* Line 214 of yacc.c.  */
#line 1467 "preproc.c"

#if ! defined (yyoverflow) || YYERROR_VERBOSE

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# if YYSTACK_USE_ALLOCA
#  define YYSTACK_ALLOC alloca
# else
#  ifndef YYSTACK_USE_ALLOCA
#   if defined (alloca) || defined (_ALLOCA_H)
#    define YYSTACK_ALLOC alloca
#   else
#    ifdef __GNUC__
#     define YYSTACK_ALLOC __builtin_alloca
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning. */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
# else
#  if defined (__STDC__) || defined (__cplusplus)
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   define YYSIZE_T size_t
#  endif
#  define YYSTACK_ALLOC malloc
#  define YYSTACK_FREE free
# endif
#endif /* ! defined (yyoverflow) || YYERROR_VERBOSE */


#if (! defined (yyoverflow) \
     && (! defined (__cplusplus) \
	 || (YYLTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  short yyss;
  YYSTYPE yyvs;
    YYLTYPE yyls;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (short) + sizeof (YYSTYPE) + sizeof (YYLTYPE))	\
      + 2 * YYSTACK_GAP_MAXIMUM)

/* Copy COUNT objects from FROM to TO.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if 1 < __GNUC__
#   define YYCOPY(To, From, Count) \
      __builtin_memcpy (To, From, (Count) * sizeof (*(From)))
#  else
#   define YYCOPY(To, From, Count)		\
      do					\
	{					\
	  register YYSIZE_T yyi;		\
	  for (yyi = 0; yyi < (Count); yyi++)	\
	    (To)[yyi] = (From)[yyi];		\
	}					\
      while (0)
#  endif
# endif

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack)					\
    do									\
      {									\
	YYSIZE_T yynewbytes;						\
	YYCOPY (&yyptr->Stack, Stack, yysize);				\
	Stack = &yyptr->Stack;						\
	yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
	yyptr += yynewbytes / sizeof (*yyptr);				\
      }									\
    while (0)

#endif

#if defined (__STDC__) || defined (__cplusplus)
   typedef signed char yysigned_char;
#else
   typedef short yysigned_char;
#endif

/* YYFINAL -- State number of the termination state. */
#define YYFINAL  3
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   85041

/* YYNTOKENS -- Number of terminals. */
#define YYNTOKENS  505
/* YYNNTS -- Number of nonterminals. */
#define YYNNTS  616
/* YYNRULES -- Number of rules. */
#define YYNRULES  2451
/* YYNRULES -- Number of states. */
#define YYNSTATES  4251

/* YYTRANSLATE(YYLEX) -- Bison symbol number corresponding to YYLEX.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   740

#define YYTRANSLATE(YYX) 						\
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[YYLEX] -- Bison symbol number corresponding to YYLEX.  */
static const unsigned short yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,   492,     2,     2,
     497,   498,   490,   488,   500,   489,   499,   491,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,   502,   501,
     485,   484,   486,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,   495,     2,   496,   493,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   503,     2,   504,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148,   149,   150,   151,   152,   153,   154,
     155,   156,   157,   158,   159,   160,   161,   162,   163,   164,
     165,   166,   167,   168,   169,   170,   171,   172,   173,   174,
     175,   176,   177,   178,   179,   180,   181,   182,   183,   184,
     185,   186,   187,   188,   189,   190,   191,   192,   193,   194,
     195,   196,   197,   198,   199,   200,   201,   202,   203,   204,
     205,   206,   207,   208,   209,   210,   211,   212,   213,   214,
     215,   216,   217,   218,   219,   220,   221,   222,   223,   224,
     225,   226,   227,   228,   229,   230,   231,   232,   233,   234,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,   249,   250,   251,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   487,
     494
};

#if YYDEBUG
/* YYPRHS[YYN] -- Index of the first RHS symbol of rule number YYN in
   YYRHS.  */
static const unsigned short yyprhs[] =
{
       0,     0,     3,     5,     7,     9,    11,    13,    15,    17,
      19,    21,    23,    25,    27,    29,    31,    33,    35,    37,
      39,    41,    43,    45,    47,    49,    51,    53,    55,    57,
      59,    61,    63,    65,    67,    69,    71,    73,    75,    77,
      79,    81,    83,    85,    87,    89,    91,    93,    95,    97,
      99,   101,   103,   105,   107,   109,   111,   113,   115,   117,
     119,   121,   123,   125,   127,   129,   131,   133,   135,   137,
     139,   141,   143,   145,   147,   149,   151,   153,   155,   157,
     159,   161,   163,   165,   167,   169,   171,   173,   175,   177,
     179,   181,   183,   185,   187,   189,   191,   193,   195,   197,
     199,   201,   203,   205,   207,   209,   211,   213,   215,   217,
     219,   221,   223,   225,   227,   229,   231,   233,   235,   237,
     239,   241,   243,   244,   250,   252,   253,   256,   257,   260,
     263,   267,   271,   273,   275,   277,   279,   281,   283,   285,
     287,   289,   291,   293,   295,   299,   303,   306,   309,   312,
     315,   319,   323,   329,   335,   340,   346,   351,   355,   361,
     365,   371,   377,   384,   386,   388,   392,   398,   405,   410,
     412,   413,   416,   417,   419,   421,   423,   425,   427,   429,
     432,   436,   440,   444,   448,   452,   456,   460,   464,   467,
     473,   476,   479,   482,   485,   489,   493,   497,   499,   503,
     505,   509,   511,   513,   515,   518,   521,   524,   526,   528,
     530,   532,   534,   536,   538,   542,   549,   551,   553,   555,
     557,   559,   560,   562,   564,   567,   571,   576,   580,   583,
     586,   588,   592,   597,   603,   608,   611,   616,   618,   620,
     622,   624,   626,   629,   632,   635,   638,   643,   648,   653,
     658,   660,   664,   668,   673,   680,   687,   694,   701,   706,
     714,   717,   722,   726,   730,   734,   738,   742,   747,   752,
     756,   760,   764,   768,   772,   776,   781,   786,   790,   793,
     797,   801,   805,   808,   811,   815,   818,   820,   822,   823,
     826,   827,   831,   834,   835,   837,   841,   845,   847,   853,
     857,   860,   863,   874,   881,   883,   885,   887,   889,   891,
     894,   895,   897,   899,   903,   907,   909,   911,   915,   919,
     923,   928,   930,   931,   934,   935,   939,   940,   942,   943,
     955,   968,   970,   972,   975,   978,   981,   984,   985,   987,
     988,   990,   994,   996,   998,  1000,  1004,  1007,  1008,  1012,
    1014,  1016,  1019,  1021,  1025,  1030,  1035,  1038,  1044,  1046,
    1049,  1052,  1055,  1059,  1062,  1063,  1066,  1069,  1072,  1075,
    1078,  1081,  1085,  1087,  1092,  1099,  1107,  1119,  1123,  1124,
    1126,  1130,  1132,  1135,  1138,  1141,  1142,  1144,  1146,  1149,
    1152,  1153,  1157,  1161,  1164,  1166,  1168,  1171,  1174,  1179,
    1180,  1183,  1186,  1189,  1190,  1194,  1199,  1204,  1205,  1208,
    1209,  1214,  1215,  1221,  1225,  1226,  1228,  1232,  1234,  1237,
    1241,  1242,  1248,  1253,  1255,  1256,  1258,  1261,  1264,  1266,
    1269,  1273,  1276,  1279,  1282,  1285,  1289,  1293,  1295,  1299,
    1301,  1302,  1304,  1307,  1309,  1315,  1325,  1327,  1328,  1330,
    1333,  1336,  1339,  1341,  1342,  1345,  1346,  1352,  1360,  1362,
    1363,  1370,  1373,  1374,  1378,  1384,  1392,  1399,  1408,  1416,
    1423,  1430,  1435,  1436,  1438,  1442,  1447,  1449,  1453,  1455,
    1458,  1461,  1464,  1467,  1469,  1471,  1482,  1485,  1486,  1489,
    1492,  1494,  1495,  1500,  1507,  1513,  1518,  1523,  1532,  1534,
    1536,  1538,  1546,  1556,  1565,  1580,  1600,  1602,  1604,  1606,
    1610,  1612,  1614,  1616,  1618,  1622,  1623,  1625,  1626,  1628,
    1630,  1632,  1636,  1637,  1639,  1641,  1643,  1645,  1647,  1649,
    1652,  1653,  1655,  1658,  1660,  1663,  1664,  1667,  1669,  1672,
    1675,  1682,  1691,  1700,  1705,  1711,  1716,  1721,  1726,  1730,
    1738,  1747,  1754,  1761,  1768,  1775,  1779,  1781,  1785,  1789,
    1791,  1793,  1795,  1797,  1799,  1801,  1805,  1809,  1813,  1815,
    1819,  1823,  1825,  1829,  1843,  1845,  1849,  1854,  1860,  1865,
    1873,  1876,  1878,  1879,  1882,  1883,  1885,  1886,  1893,  1902,
    1911,  1913,  1917,  1923,  1929,  1937,  1947,  1955,  1965,  1971,
    1978,  1985,  1990,  1992,  1994,  1996,  1998,  2000,  2002,  2004,
    2006,  2010,  2014,  2018,  2022,  2024,  2028,  2030,  2033,  2036,
    2040,  2046,  2049,  2052,  2053,  2060,  2068,  2076,  2084,  2093,
    2102,  2109,  2118,  2128,  2138,  2146,  2157,  2165,  2174,  2183,
    2192,  2201,  2203,  2205,  2207,  2209,  2211,  2213,  2215,  2217,
    2219,  2221,  2223,  2225,  2227,  2229,  2234,  2237,  2242,  2245,
    2251,  2256,  2261,  2265,  2269,  2273,  2275,  2277,  2279,  2281,
    2284,  2287,  2289,  2291,  2293,  2296,  2299,  2301,  2304,  2307,
    2309,  2311,  2319,  2327,  2338,  2340,  2342,  2345,  2350,  2356,
    2358,  2362,  2365,  2368,  2371,  2374,  2376,  2379,  2382,  2387,
    2391,  2394,  2397,  2400,  2403,  2406,  2408,  2412,  2414,  2417,
    2421,  2422,  2424,  2428,  2431,  2438,  2445,  2455,  2459,  2460,
    2464,  2465,  2479,  2494,  2496,  2497,  2500,  2501,  2503,  2507,
    2512,  2517,  2524,  2526,  2529,  2530,  2532,  2534,  2535,  2537,
    2539,  2540,  2550,  2563,  2571,  2574,  2575,  2579,  2582,  2584,
    2588,  2592,  2595,  2597,  2601,  2605,  2609,  2612,  2615,  2617,
    2619,  2621,  2623,  2626,  2628,  2630,  2632,  2634,  2639,  2645,
    2647,  2651,  2655,  2657,  2660,  2665,  2671,  2673,  2675,  2677,
    2679,  2683,  2687,  2690,  2693,  2696,  2699,  2701,  2704,  2707,
    2709,  2711,  2713,  2717,  2720,  2721,  2724,  2726,  2730,  2736,
    2738,  2741,  2743,  2744,  2750,  2758,  2764,  2772,  2778,  2786,
    2790,  2796,  2802,  2808,  2810,  2814,  2826,  2837,  2848,  2851,
    2854,  2855,  2865,  2868,  2869,  2874,  2879,  2884,  2886,  2888,
    2890,  2891,  2899,  2906,  2913,  2920,  2927,  2935,  2945,  2955,
    2962,  2969,  2976,  2983,  2990,  2999,  3008,  3015,  3022,  3029,
    3038,  3047,  3056,  3065,  3072,  3074,  3075,  3078,  3079,  3087,
    3094,  3101,  3108,  3115,  3122,  3129,  3137,  3144,  3151,  3158,
    3165,  3173,  3181,  3191,  3201,  3208,  3215,  3222,  3231,  3240,
    3249,  3256,  3258,  3260,  3264,  3268,  3270,  3272,  3274,  3276,
    3278,  3280,  3282,  3283,  3285,  3287,  3289,  3291,  3293,  3295,
    3296,  3303,  3312,  3315,  3318,  3321,  3324,  3327,  3331,  3335,
    3338,  3341,  3344,  3347,  3351,  3354,  3360,  3365,  3369,  3373,
    3377,  3379,  3381,  3382,  3386,  3389,  3392,  3394,  3398,  3401,
    3403,  3404,  3413,  3424,  3428,  3433,  3438,  3439,  3442,  3448,
    3451,  3452,  3456,  3460,  3464,  3468,  3472,  3476,  3480,  3484,
    3488,  3492,  3496,  3500,  3504,  3509,  3513,  3517,  3519,  3520,
    3526,  3533,  3538,  3541,  3542,  3547,  3551,  3557,  3564,  3569,
    3576,  3583,  3589,  3597,  3599,  3600,  3607,  3619,  3631,  3643,
    3657,  3667,  3679,  3690,  3695,  3698,  3704,  3707,  3708,  3713,
    3719,  3725,  3728,  3733,  3735,  3737,  3739,  3740,  3742,  3743,
    3745,  3746,  3750,  3751,  3756,  3758,  3760,  3762,  3764,  3766,
    3768,  3770,  3772,  3773,  3779,  3784,  3788,  3789,  3791,  3793,
    3795,  3797,  3802,  3811,  3815,  3816,  3822,  3824,  3829,  3832,
    3834,  3838,  3841,  3845,  3846,  3853,  3856,  3857,  3863,  3867,
    3868,  3871,  3874,  3877,  3881,  3883,  3887,  3889,  3892,  3894,
    3895,  3903,  3905,  3909,  3911,  3913,  3917,  3923,  3926,  3928,
    3932,  3940,  3941,  3945,  3948,  3951,  3954,  3955,  3958,  3961,
    3963,  3965,  3969,  3973,  3975,  3978,  3983,  3988,  3991,  3995,
    4001,  4007,  4009,  4011,  4021,  4023,  4026,  4031,  4036,  4041,
    4044,  4048,  4050,  4054,  4059,  4062,  4064,  4065,  4069,  4073,
    4078,  4083,  4088,  4093,  4096,  4098,  4100,  4101,  4103,  4105,
    4106,  4108,  4114,  4116,  4117,  4119,  4120,  4124,  4126,  4130,
    4135,  4139,  4144,  4149,  4152,  4155,  4160,  4164,  4170,  4179,
    4181,  4182,  4184,  4186,  4188,  4192,  4193,  4195,  4197,  4199,
    4201,  4203,  4205,  4209,  4210,  4213,  4214,  4216,  4220,  4222,
    4223,  4225,  4228,  4233,  4238,  4241,  4242,  4245,  4249,  4252,
    4253,  4255,  4259,  4261,  4264,  4266,  4269,  4275,  4282,  4288,
    4290,  4293,  4295,  4300,  4304,  4309,  4315,  4320,  4326,  4331,
    4337,  4340,  4345,  4347,  4350,  4353,  4356,  4358,  4360,  4361,
    4366,  4369,  4371,  4374,  4377,  4382,  4384,  4388,  4390,  4393,
    4397,  4399,  4402,  4403,  4406,  4411,  4416,  4417,  4419,  4423,
    4426,  4429,  4433,  4439,  4446,  4449,  4453,  4457,  4462,  4463,
    4465,  4467,  4469,  4471,  4473,  4476,  4482,  4484,  4486,  4488,
    4490,  4493,  4497,  4501,  4502,  4504,  4506,  4508,  4510,  4512,
    4515,  4518,  4521,  4524,  4527,  4529,  4533,  4534,  4536,  4538,
    4540,  4542,  4548,  4551,  4553,  4555,  4557,  4559,  4565,  4568,
    4571,  4574,  4576,  4580,  4584,  4587,  4589,  4590,  4594,  4595,
    4601,  4604,  4610,  4613,  4615,  4618,  4622,  4623,  4625,  4627,
    4629,  4631,  4633,  4635,  4639,  4643,  4647,  4651,  4655,  4659,
    4663,  4664,  4666,  4671,  4673,  4677,  4683,  4686,  4689,  4693,
    4697,  4701,  4705,  4709,  4713,  4717,  4721,  4725,  4729,  4732,
    4735,  4739,  4743,  4746,  4750,  4756,  4761,  4768,  4772,  4778,
    4783,  4790,  4795,  4802,  4808,  4816,  4820,  4823,  4828,  4831,
    4835,  4839,  4844,  4848,  4853,  4857,  4862,  4868,  4875,  4882,
    4890,  4897,  4905,  4912,  4920,  4924,  4929,  4934,  4941,  4944,
    4948,  4953,  4955,  4959,  4962,  4965,  4969,  4973,  4977,  4981,
    4985,  4989,  4993,  4997,  5001,  5005,  5008,  5011,  5017,  5024,
    5031,  5039,  5043,  5048,  5050,  5052,  5055,  5060,  5062,  5064,
    5066,  5069,  5072,  5075,  5077,  5082,  5088,  5095,  5104,  5111,
    5118,  5124,  5126,  5128,  5133,  5135,  5140,  5142,  5147,  5149,
    5154,  5156,  5158,  5160,  5162,  5164,  5166,  5173,  5178,  5183,
    5188,  5193,  5200,  5206,  5212,  5218,  5223,  5230,  5235,  5240,
    5245,  5250,  5256,  5264,  5272,  5282,  5287,  5294,  5300,  5308,
    5316,  5324,  5327,  5331,  5335,  5339,  5344,  5345,  5350,  5352,
    5356,  5360,  5362,  5364,  5366,  5369,  5372,  5373,  5376,  5377,
    5379,  5383,  5387,  5390,  5393,  5394,  5401,  5403,  5404,  5408,
    5409,  5412,  5415,  5416,  5418,  5423,  5426,  5429,  5432,  5437,
    5441,  5447,  5449,  5451,  5453,  5455,  5457,  5459,  5461,  5463,
    5465,  5467,  5469,  5471,  5473,  5475,  5477,  5482,  5484,  5489,
    5491,  5496,  5498,  5501,  5503,  5506,  5508,  5512,  5514,  5518,
    5522,  5526,  5529,  5531,  5535,  5539,  5540,  5542,  5544,  5546,
    5548,  5550,  5552,  5554,  5556,  5561,  5565,  5568,  5572,  5573,
    5577,  5581,  5584,  5587,  5589,  5590,  5593,  5596,  5600,  5603,
    5605,  5607,  5611,  5617,  5619,  5622,  5627,  5630,  5631,  5633,
    5634,  5636,  5639,  5642,  5645,  5649,  5655,  5657,  5660,  5661,
    5664,  5666,  5667,  5669,  5671,  5673,  5677,  5681,  5683,  5687,
    5691,  5694,  5696,  5698,  5700,  5702,  5704,  5708,  5710,  5713,
    5715,  5719,  5721,  5723,  5725,  5727,  5729,  5731,  5733,  5736,
    5738,  5740,  5742,  5744,  5746,  5749,  5755,  5758,  5762,  5769,
    5771,  5773,  5775,  5777,  5779,  5781,  5783,  5785,  5787,  5790,
    5793,  5795,  5797,  5799,  5801,  5803,  5805,  5807,  5809,  5811,
    5813,  5815,  5817,  5819,  5821,  5823,  5825,  5827,  5829,  5831,
    5833,  5835,  5837,  5839,  5841,  5843,  5845,  5847,  5849,  5851,
    5853,  5855,  5857,  5859,  5861,  5863,  5865,  5867,  5869,  5871,
    5873,  5875,  5877,  5879,  5881,  5883,  5885,  5887,  5889,  5891,
    5893,  5895,  5897,  5899,  5901,  5903,  5905,  5907,  5909,  5911,
    5913,  5915,  5917,  5919,  5921,  5923,  5925,  5927,  5929,  5931,
    5933,  5935,  5937,  5939,  5941,  5943,  5945,  5947,  5949,  5951,
    5953,  5955,  5957,  5959,  5961,  5963,  5965,  5967,  5969,  5971,
    5973,  5975,  5977,  5979,  5981,  5983,  5985,  5987,  5989,  5991,
    5993,  5995,  5997,  5999,  6001,  6003,  6005,  6007,  6009,  6011,
    6013,  6015,  6017,  6019,  6021,  6023,  6025,  6027,  6029,  6031,
    6033,  6035,  6037,  6039,  6041,  6043,  6045,  6047,  6049,  6051,
    6053,  6055,  6057,  6059,  6061,  6063,  6065,  6067,  6069,  6071,
    6073,  6075,  6077,  6079,  6081,  6083,  6085,  6087,  6089,  6091,
    6093,  6095,  6097,  6099,  6101,  6103,  6105,  6107,  6109,  6111,
    6113,  6115,  6117,  6119,  6121,  6123,  6125,  6127,  6129,  6131,
    6133,  6135,  6137,  6139,  6141,  6143,  6145,  6147,  6149,  6151,
    6153,  6155,  6157,  6159,  6161,  6163,  6165,  6167,  6169,  6171,
    6173,  6175,  6177,  6179,  6181,  6183,  6185,  6187,  6189,  6191,
    6193,  6195,  6197,  6199,  6201,  6203,  6205,  6207,  6209,  6211,
    6213,  6215,  6217,  6219,  6221,  6223,  6225,  6227,  6229,  6231,
    6233,  6235,  6237,  6239,  6241,  6243,  6245,  6247,  6249,  6251,
    6253,  6255,  6257,  6259,  6261,  6263,  6265,  6267,  6269,  6271,
    6273,  6275,  6277,  6279,  6281,  6283,  6285,  6287,  6289,  6291,
    6293,  6295,  6297,  6299,  6301,  6303,  6305,  6307,  6309,  6311,
    6313,  6315,  6317,  6319,  6321,  6323,  6325,  6327,  6329,  6331,
    6333,  6335,  6337,  6339,  6341,  6343,  6345,  6347,  6349,  6351,
    6353,  6355,  6357,  6359,  6361,  6363,  6365,  6367,  6369,  6371,
    6373,  6375,  6377,  6379,  6381,  6383,  6385,  6387,  6389,  6391,
    6393,  6395,  6397,  6399,  6401,  6403,  6405,  6407,  6409,  6411,
    6413,  6415,  6417,  6419,  6421,  6423,  6425,  6427,  6429,  6431,
    6433,  6435,  6437,  6439,  6441,  6443,  6445,  6447,  6449,  6451,
    6453,  6455,  6457,  6459,  6461,  6463,  6465,  6467,  6469,  6471,
    6473,  6475,  6477,  6479,  6481,  6483,  6485,  6487,  6489,  6491,
    6493,  6495,  6497,  6499,  6501,  6503,  6505,  6507,  6509,  6511,
    6513,  6515,  6517,  6519,  6521,  6523,  6525,  6527,  6529,  6531,
    6533,  6535,  6537,  6539,  6541,  6543,  6545,  6547,  6549,  6551,
    6553,  6554,  6557,  6562,  6566,  6569,  6571,  6573,  6575,  6577,
    6579,  6580,  6589,  6590,  6605,  6608,  6614,  6618,  6621,  6624,
    6628,  6636,  6638,  6640,  6642,  6643,  6646,  6649,  6651,  6652,
    6654,  6658,  6660,  6663,  6664,  6667,  6668,  6671,  6672,  6674,
    6678,  6683,  6687,  6689,  6691,  6693,  6695,  6698,  6699,  6702,
    6707,  6708,  6711,  6714,  6717,  6719,  6721,  6729,  6733,  6735,
    6737,  6739,  6741,  6744,  6745,  6747,  6751,  6755,  6759,  6763,
    6764,  6769,  6775,  6781,  6782,  6784,  6786,  6788,  6790,  6793,
    6796,  6799,  6801,  6804,  6805,  6813,  6814,  6820,  6821,  6826,
    6829,  6832,  6833,  6836,  6838,  6840,  6842,  6844,  6846,  6848,
    6850,  6852,  6854,  6856,  6858,  6864,  6867,  6869,  6873,  6876,
    6879,  6883,  6884,  6890,  6892,  6893,  6899,  6902,  6905,  6907,
    6909,  6911,  6914,  6917,  6921,  6923,  6926,  6929,  6933,  6937,
    6942,  6945,  6947,  6950,  6952,  6954,  6957,  6960,  6964,  6966,
    6968,  6970,  6972,  6973,  6975,  6979,  6985,  6986,  6989,  6990,
    6992,  6995,  6999,  7002,  7004,  7006,  7008,  7009,  7011,  7013,
    7015,  7017,  7019,  7022,  7025,  7029,  7030,  7032,  7035,  7037,
    7042,  7047,  7048,  7050,  7052,  7056,  7058,  7060,  7062,  7064,
    7067,  7070,  7072,  7075,  7078,  7080,  7082,  7084,  7089,  7094,
    7099,  7101,  7102,  7106,  7110,  7115,  7117,  7121,  7125,  7130,
    7132,  7136,  7140,  7142,  7144,  7146,  7153,  7155,  7159,  7163,
    7170,  7172,  7176,  7180,  7182,  7184,  7187,  7190,  7192,  7194,
    7196,  7198,  7200,  7202,  7204,  7206,  7208,  7210,  7212,  7214,
    7216,  7218,  7220,  7222,  7227,  7232,  7234,  7236,  7241,  7246,
    7250,  7251,  7259,  7261,  7262,  7263,  7271,  7275,  7280,  7284,
    7286,  7288,  7290,  7293,  7297,  7303,  7306,  7312,  7315,  7317,
    7319,  7321,  7323,  7325,  7327,  7329,  7331,  7333,  7335,  7337,
    7339,  7341,  7343,  7345,  7347,  7349,  7351,  7353,  7355,  7357,
    7359,  7361,  7363,  7365,  7367,  7369,  7371,  7373,  7375,  7377,
    7379,  7381,  7383,  7385,  7387,  7389,  7391,  7393,  7395,  7397,
    7399,  7401,  7403,  7405,  7407,  7409,  7411,  7413,  7415,  7417,
    7419,  7421,  7423,  7425,  7427,  7429,  7431,  7433,  7435,  7437,
    7439,  7441,  7443,  7445,  7447,  7449,  7451,  7453,  7455,  7457,
    7459,  7461,  7463,  7465,  7467,  7469,  7471,  7473,  7475,  7477,
    7479,  7481,  7483,  7485,  7487,  7489,  7491,  7493,  7495,  7497,
    7499,  7501,  7503,  7505,  7507,  7509,  7511,  7515,  7517,  7518,
    7520,  7523,  7525,  7528,  7530,  7532,  7535,  7538,  7540,  7542,
    7544,  7546,  7548,  7550,  7552,  7554,  7556,  7558,  7560,  7562,
    7564,  7566,  7568,  7570,  7573,  7577,  7579,  7582,  7584,  7588,
    7590,  7594,  7596,  7598,  7600,  7602,  7604,  7606,  7608,  7610,
    7612,  7614,  7616,  7618,  7620,  7622,  7624,  7626,  7628,  7630,
    7632,  7634,  7636,  7638,  7640,  7642,  7644,  7646,  7648,  7650,
    7652,  7654,  7656,  7658,  7660,  7662,  7664,  7666,  7668,  7670,
    7672,  7674,  7676,  7678,  7680,  7682,  7684,  7686,  7688,  7690,
    7692,  7694,  7696,  7698,  7700,  7702,  7704,  7706,  7708,  7710,
    7712,  7714,  7716,  7719,  7723,  7726,  7730,  7732,  7736,  7740,
    7744,  7748,  7752,  7756,  7758,  7760,  7761,  7764,  7767,  7769,
    7771,  7774
};

/* YYRHS -- A `-1'-separated list of the rules' RHS. */
static const short yyrhs[] =
{
     506,     0,    -1,   973,    -1,   774,    -1,   775,    -1,   780,
      -1,   618,    -1,   632,    -1,   732,    -1,   520,    -1,   750,
      -1,   751,    -1,   599,    -1,   545,    -1,   514,    -1,   513,
      -1,   783,    -1,   782,    -1,   636,    -1,   516,    -1,   515,
      -1,   788,    -1,   543,    -1,   555,    -1,   785,    -1,   684,
      -1,   540,    -1,   556,    -1,   975,    -1,   651,    -1,   740,
      -1,   784,    -1,   779,    -1,   616,    -1,   627,    -1,   713,
      -1,   519,    -1,   663,    -1,   669,    -1,   670,    -1,   605,
      -1,   523,    -1,   598,    -1,   565,    -1,   613,    -1,   637,
      -1,   508,    -1,   512,    -1,   633,    -1,   770,    -1,  1117,
      -1,   820,    -1,   653,    -1,   807,    -1,   544,    -1,   652,
      -1,   742,    -1,   617,    -1,   631,    -1,   522,    -1,   673,
      -1,   674,    -1,   675,    -1,   611,    -1,   758,    -1,   677,
      -1,   615,    -1,   650,    -1,   517,    -1,   518,    -1,   635,
      -1,   778,    -1,   800,    -1,   794,    -1,   687,    -1,   690,
      -1,   701,    -1,   705,    -1,   802,    -1,   760,    -1,   769,
      -1,   809,    -1,   759,    -1,   797,    -1,   676,    -1,   744,
      -1,   736,    -1,   735,    -1,   737,    -1,   747,    -1,   691,
      -1,   702,    -1,   977,    -1,   823,    -1,   762,    -1,   682,
      -1,   761,    -1,   813,    -1,   787,    -1,   537,    -1,   527,
      -1,   539,    -1,   767,    -1,  1054,    -1,   980,    -1,   997,
      -1,  1055,    -1,  1037,    -1,  1052,    -1,  1038,    -1,   998,
      -1,  1042,    -1,  1064,    -1,  1056,    -1,  1043,    -1,  1072,
      -1,  1074,    -1,  1067,    -1,  1059,    -1,  1075,    -1,  1078,
      -1,  1080,    -1,    -1,   147,   370,   966,   509,   510,    -1,
     456,    -1,    -1,   510,   511,    -1,    -1,   334,  1107,    -1,
     334,   307,    -1,   192,   334,  1107,    -1,   431,   334,  1107,
      -1,   406,    -1,   301,    -1,   239,    -1,   298,    -1,   148,
      -1,   295,    -1,   149,    -1,   296,    -1,   150,    -1,   297,
      -1,   278,    -1,   299,    -1,   139,   270,   967,    -1,   441,
     436,  1107,    -1,   438,   956,    -1,   408,   965,    -1,    86,
     956,    -1,   370,   956,    -1,   234,   370,   956,    -1,   234,
     222,   956,    -1,   147,   438,   966,   509,   510,    -1,    91,
     370,   966,   509,   510,    -1,    91,   370,   966,   538,    -1,
      91,   438,   966,   509,   510,    -1,    91,   438,   966,   538,
      -1,   187,   370,   956,    -1,   187,   370,   229,   200,   956,
      -1,   187,   438,   956,    -1,   187,   438,   229,   200,   956,
      -1,   147,   222,   966,   509,   510,    -1,    91,   222,   966,
     521,   438,   956,    -1,    85,    -1,   187,    -1,   187,   222,
     956,    -1,   187,   222,   229,   200,   956,    -1,   147,   376,
     524,   104,   966,   525,    -1,   147,   376,  1088,   525,    -1,
    1088,    -1,    -1,   525,   526,    -1,    -1,   565,    -1,   705,
      -1,   598,    -1,   637,    -1,   690,    -1,   767,    -1,   387,
     528,    -1,   387,   273,   528,    -1,   387,   385,   528,    -1,
     529,   419,   530,    -1,   529,   484,   530,    -1,   529,   419,
     170,    -1,   529,   484,   170,    -1,   529,   215,   153,    -1,
     417,   472,   534,    -1,   421,   765,    -1,   385,   125,    98,
     421,   765,    -1,   121,  1107,    -1,   376,  1107,    -1,   288,
     535,    -1,   370,   536,    -1,   385,   104,   536,    -1,   385,
     104,   170,    -1,   461,   320,   905,    -1,  1087,    -1,   529,
     499,  1088,    -1,   531,    -1,   530,   500,   531,    -1,   533,
      -1,   536,    -1,   604,    -1,   350,   430,    -1,   350,   136,
      -1,   360,   350,    -1,   383,    -1,   425,    -1,   204,    -1,
     317,    -1,   313,    -1,  1107,    -1,  1109,    -1,   892,  1107,
     894,    -1,   892,   497,   965,   498,  1107,   894,    -1,   604,
      -1,   170,    -1,   273,    -1,  1107,    -1,   170,    -1,    -1,
    1088,    -1,  1107,    -1,   363,   529,    -1,   363,   417,   472,
      -1,   363,   421,   256,   268,    -1,   363,   385,   104,    -1,
     363,    89,    -1,   387,   528,    -1,   537,    -1,   390,   529,
    1120,    -1,   390,   417,   472,  1120,    -1,   390,   421,   256,
     268,  1120,    -1,   390,   385,   104,  1120,    -1,   390,    89,
      -1,   387,   141,   541,   542,    -1,    89,    -1,   954,    -1,
     173,    -1,   231,    -1,   127,    -1,   181,    89,    -1,   181,
     412,    -1,   181,   414,    -1,   181,   336,    -1,    91,   410,
     864,   546,    -1,    91,   237,   955,   546,    -1,    91,   382,
     955,   546,    -1,    91,   450,   955,   546,    -1,   547,    -1,
     546,   500,   547,    -1,    85,   748,   570,    -1,    91,   748,
    1088,   548,    -1,    91,   748,  1088,   187,   302,   307,    -1,
      91,   748,  1088,   387,   302,   307,    -1,    91,   748,  1088,
     387,   399,   967,    -1,    91,   748,  1088,   387,   402,  1088,
      -1,   187,   748,  1088,   549,    -1,    91,   748,  1088,   749,
     428,   872,   550,    -1,    85,   578,    -1,   187,   140,   957,
     549,    -1,   387,   456,   315,    -1,   387,   457,   315,    -1,
     130,   317,   957,    -1,   387,   457,   130,    -1,   190,   423,
     957,    -1,   190,    92,   423,   957,    -1,   190,   362,   423,
     957,    -1,   190,   423,    89,    -1,   190,   423,   438,    -1,
     180,   423,   957,    -1,   180,   423,    89,    -1,   180,   423,
     438,    -1,   190,   374,   957,    -1,   190,    92,   374,   957,
      -1,   190,   362,   374,   957,    -1,   180,   374,   957,    -1,
     239,   955,    -1,   294,   239,   955,    -1,   330,   419,   966,
      -1,   387,   411,   957,    -1,   387,   551,    -1,   363,   551,
      -1,   387,   170,   896,    -1,   187,   170,    -1,   117,    -1,
     365,    -1,    -1,   439,   896,    -1,    -1,   497,   553,   498,
      -1,   456,   551,    -1,    -1,   554,    -1,   553,   500,   554,
      -1,  1090,   484,   657,    -1,  1090,    -1,  1090,   499,  1090,
     484,   657,    -1,  1090,   499,  1090,    -1,   129,   957,    -1,
     129,    89,    -1,   145,   561,   955,   580,   562,   557,   558,
     563,   509,   559,    -1,   145,   824,   419,   558,   509,   559,
      -1,   215,    -1,   419,    -1,  1107,    -1,   400,    -1,   401,
      -1,   559,   560,    -1,    -1,   110,    -1,   315,    -1,   176,
     781,  1107,    -1,   307,   781,  1107,    -1,   152,    -1,   225,
      -1,   348,   781,  1107,    -1,   195,   781,  1107,    -1,   211,
     348,   581,    -1,   211,   302,   307,   581,    -1,   110,    -1,
      -1,   456,   315,    -1,    -1,   564,   177,  1107,    -1,    -1,
     439,    -1,    -1,   147,   566,   410,   955,   497,   567,   498,
     588,   589,   590,   591,    -1,   147,   566,   410,   955,   312,
     955,   497,   567,   498,   589,   590,   591,    -1,   414,    -1,
     412,    -1,   273,   414,    -1,   273,   412,    -1,   218,   414,
      -1,   218,   412,    -1,    -1,   568,    -1,    -1,   569,    -1,
     568,   500,   569,    -1,   570,    -1,   575,    -1,   578,    -1,
    1088,   872,   571,    -1,   571,   572,    -1,    -1,   140,   957,
     573,    -1,   573,    -1,   574,    -1,   302,   307,    -1,   307,
      -1,   433,   729,   592,    -1,   343,   258,   729,   592,    -1,
     126,   497,   896,   498,    -1,   170,   897,    -1,   355,   955,
     580,   583,   584,    -1,   172,    -1,   302,   172,    -1,   241,
     173,    -1,   241,   231,    -1,   269,   955,   576,    -1,   576,
     577,    -1,    -1,   235,   171,    -1,   197,   171,    -1,   235,
     141,    -1,   197,   141,    -1,   235,   238,    -1,   197,   238,
      -1,   140,   957,   579,    -1,   579,    -1,   126,   497,   896,
     498,    -1,   433,   497,   581,   498,   729,   592,    -1,   343,
     258,   497,   581,   498,   729,   592,    -1,   212,   258,   497,
     581,   498,   355,   955,   580,   583,   584,   647,    -1,   497,
     581,   498,    -1,    -1,   582,    -1,   581,   500,   582,    -1,
    1088,    -1,   280,   216,    -1,   280,   332,    -1,   280,   392,
      -1,    -1,   585,    -1,   586,    -1,   585,   586,    -1,   586,
     585,    -1,    -1,   317,   437,   587,    -1,   317,   175,   587,
      -1,   294,    84,    -1,   365,    -1,   117,    -1,   387,   307,
      -1,   387,   170,    -1,   240,   497,   954,   498,    -1,    -1,
     456,   551,    -1,   456,   315,    -1,   457,   315,    -1,    -1,
     317,   135,   187,    -1,   317,   135,   175,   373,    -1,   317,
     135,   340,   373,    -1,    -1,   411,   957,    -1,    -1,   439,
     237,   411,   957,    -1,    -1,   955,   594,   589,   590,   591,
      -1,   497,   595,   498,    -1,    -1,   596,    -1,   595,   500,
     596,    -1,  1088,    -1,   456,   163,    -1,   456,   294,   163,
      -1,    -1,   147,   566,   382,   955,   600,    -1,    91,   382,
     955,   601,    -1,   601,    -1,    -1,   602,    -1,   601,   602,
      -1,   115,   604,    -1,   162,    -1,   294,   162,    -1,   236,
     603,   604,    -1,   281,   604,    -1,   283,   604,    -1,   294,
     281,    -1,   294,   283,    -1,   329,   114,   680,    -1,   397,
     509,   604,    -1,   364,    -1,   364,   509,   604,    -1,   114,
      -1,    -1,  1106,    -1,   489,  1106,    -1,   967,    -1,   147,
     606,   612,   260,   536,    -1,   147,   606,   612,   260,   536,
     223,   607,   609,   610,    -1,   427,    -1,    -1,   957,    -1,
     957,   681,    -1,   442,   607,    -1,   294,   442,    -1,   608,
      -1,    -1,   259,  1107,    -1,    -1,   187,   612,   260,   536,
     549,    -1,   187,   612,   260,   229,   200,   536,   549,    -1,
     346,    -1,    -1,   147,   411,   957,   614,   276,  1107,    -1,
     330,   957,    -1,    -1,   187,   411,   957,    -1,   187,   411,
     229,   200,   957,    -1,   147,   212,   163,   459,   957,   609,
     619,    -1,   187,   212,   163,   459,   957,   549,    -1,   187,
     212,   163,   459,   229,   200,   957,   549,    -1,    91,   212,
     163,   459,   957,   608,   621,    -1,    91,   212,   163,   459,
     957,   608,    -1,    91,   212,   163,   459,   957,   621,    -1,
     321,   497,   620,   498,    -1,    -1,   624,    -1,   620,   500,
     624,    -1,   321,   497,   622,   498,    -1,   623,    -1,   622,
     500,   623,    -1,   624,    -1,   387,   624,    -1,    85,   624,
      -1,   187,   625,    -1,   625,   626,    -1,  1090,    -1,  1107,
      -1,   147,   384,   957,   628,   630,   212,   163,   459,   957,
     619,    -1,   428,  1107,    -1,    -1,   449,  1107,    -1,   449,
     307,    -1,   629,    -1,    -1,   187,   384,   957,   549,    -1,
     187,   384,   229,   200,   957,   549,    -1,    91,   384,   957,
     629,   621,    -1,    91,   384,   957,   629,    -1,    91,   384,
     957,   621,    -1,   147,   438,   279,   210,   634,   384,   957,
     619,    -1,   160,    -1,   438,    -1,   966,    -1,   187,   438,
     279,   210,   634,   384,   957,    -1,   187,   438,   279,   229,
     200,   210,   634,   384,   957,    -1,    91,   438,   279,   210,
     634,   384,   957,   621,    -1,   147,   423,   957,   638,   639,
     317,   955,   641,   199,   347,   963,   497,   644,   498,    -1,
     147,   140,   423,   957,    87,   639,   317,   955,   646,   647,
     210,   188,   372,   199,   347,   963,   497,   644,   498,    -1,
     106,    -1,    87,    -1,   640,    -1,   639,   322,   640,    -1,
     246,    -1,   175,    -1,   437,    -1,   426,    -1,   210,   642,
     643,    -1,    -1,   188,    -1,    -1,   372,    -1,   398,    -1,
     645,    -1,   644,   500,   645,    -1,    -1,   965,    -1,  1106,
      -1,  1107,    -1,  1105,    -1,   480,    -1,  1088,    -1,   215,
     955,    -1,    -1,   648,    -1,   648,   649,    -1,   649,    -1,
     649,   648,    -1,    -1,   302,   172,    -1,   172,    -1,   241,
     231,    -1,   241,   173,    -1,   187,   423,   957,   317,   955,
     549,    -1,   187,   423,   229,   200,   957,   317,   955,   549,
      -1,   147,   100,   957,   126,   497,   896,   498,   647,    -1,
     187,   100,   957,   549,    -1,   147,    88,   963,   658,   654,
      -1,   147,    88,   963,   659,    -1,   147,   319,   739,   654,
      -1,   147,   428,   680,   654,    -1,   147,   428,   680,    -1,
     147,   428,   680,    98,   497,   870,   498,    -1,   147,   428,
     680,    98,   194,   497,   662,   498,    -1,   147,   415,   378,
     331,   680,   654,    -1,   147,   415,   378,   179,   680,   654,
      -1,   147,   415,   378,   413,   680,   654,    -1,   147,   415,
     378,   138,   680,   654,    -1,   497,   655,   498,    -1,   656,
      -1,   655,   500,   656,    -1,  1090,   484,   657,    -1,  1090,
      -1,   723,    -1,   971,    -1,   922,    -1,   604,    -1,  1107,
      -1,   497,   925,   498,    -1,   497,   490,   498,    -1,   497,
     660,   498,    -1,   661,    -1,   660,   500,   661,    -1,  1109,
     484,   657,    -1,  1107,    -1,   662,   500,  1107,    -1,   147,
     319,   128,   680,   666,   210,   428,   872,   439,   959,   667,
      98,   664,    -1,   665,    -1,   664,   500,   665,    -1,   319,
     965,   739,   668,    -1,   319,   965,   739,   738,   668,    -1,
     217,   965,   963,   715,    -1,   217,   965,   497,   925,   498,
     963,   715,    -1,   402,   872,    -1,   170,    -1,    -1,   205,
     680,    -1,    -1,   353,    -1,    -1,   147,   319,   205,   680,
     439,   959,    -1,    91,   319,   205,   680,   439,   959,    85,
     664,    -1,    91,   319,   205,   680,   439,   959,   187,   671,
      -1,   672,    -1,   671,   500,   672,    -1,   319,   965,   497,
     925,   498,    -1,   217,   965,   497,   925,   498,    -1,   187,
     319,   128,   680,   439,   959,   549,    -1,   187,   319,   128,
     229,   200,   680,   439,   959,   549,    -1,   187,   319,   205,
     680,   439,   959,   549,    -1,   187,   319,   205,   229,   200,
     680,   439,   959,   549,    -1,   187,   329,   114,   956,   549,
      -1,   352,   329,   114,   956,   419,   957,    -1,   187,   678,
     229,   200,   679,   549,    -1,   187,   678,   679,   549,    -1,
     410,    -1,   382,    -1,   450,    -1,   237,    -1,   428,    -1,
     185,    -1,   144,    -1,   376,    -1,   415,   378,   331,    -1,
     415,   378,   179,    -1,   415,   378,   413,    -1,   415,   378,
     138,    -1,   680,    -1,   679,   500,   680,    -1,  1088,    -1,
    1088,   681,    -1,   499,   960,    -1,   681,   499,   960,    -1,
     426,   833,   865,   683,   549,    -1,   143,   228,    -1,   364,
     228,    -1,    -1,   134,   317,   685,   680,   254,   686,    -1,
     134,   317,    88,   963,   658,   254,   686,    -1,   134,   317,
     217,   963,   715,   254,   686,    -1,   134,   317,   319,   739,
     738,   254,   686,    -1,   134,   317,   140,   957,   317,   680,
     254,   686,    -1,   134,   317,   374,   957,   317,   680,   254,
     686,    -1,   134,   317,   374,   957,   254,   686,    -1,   134,
     317,   423,   957,   317,   680,   254,   686,    -1,   134,   317,
     319,   128,   680,   439,   959,   254,   686,    -1,   134,   317,
     319,   205,   680,   439,   959,   254,   686,    -1,   134,   317,
     261,   311,   604,   254,   686,    -1,   134,   317,   120,   497,
     872,    98,   872,   498,   254,   686,    -1,   134,   317,   612,
     260,   680,   254,   686,    -1,   134,   317,   415,   378,   331,
     680,   254,   686,    -1,   134,   317,   415,   378,   179,   680,
     254,   686,    -1,   134,   317,   415,   378,   413,   680,   254,
     686,    -1,   134,   317,   415,   378,   138,   680,   254,   686,
      -1,   133,    -1,   164,    -1,   376,    -1,   237,    -1,   382,
      -1,   410,    -1,   185,    -1,   428,    -1,   450,    -1,   144,
      -1,   411,    -1,   370,    -1,  1107,    -1,   307,    -1,   206,
     688,   689,   957,    -1,   206,   957,    -1,   286,   688,   689,
     957,    -1,   286,   957,    -1,   206,   688,   689,   957,  1120,
      -1,   206,   688,   957,  1120,    -1,   206,   689,   957,  1120,
      -1,   206,   957,  1120,    -1,   206,   688,   957,    -1,   206,
     689,   957,    -1,   293,    -1,   344,    -1,   207,    -1,   262,
      -1,    82,   967,    -1,   357,   967,    -1,   967,    -1,    89,
      -1,   213,    -1,   213,   967,    -1,   213,    89,    -1,   105,
      -1,   105,   967,    -1,   105,    89,    -1,   215,    -1,   234,
      -1,   219,   692,   317,   695,   419,   696,   698,    -1,   368,
     692,   317,   695,   215,   696,   549,    -1,   368,   219,   320,
     210,   692,   317,   695,   215,   696,   549,    -1,   693,    -1,
      89,    -1,    89,   345,    -1,    89,   497,   581,   498,    -1,
      89,   345,   497,   581,   498,    -1,   694,    -1,   693,   500,
     694,    -1,   381,   580,    -1,   355,   580,    -1,   147,   580,
      -1,  1088,   580,    -1,   954,    -1,   410,   954,    -1,   382,
     954,    -1,   212,   163,   459,   956,    -1,   212,   384,   956,
      -1,   217,   699,    -1,   164,   956,    -1,   260,   956,    -1,
     376,   956,    -1,   411,   956,    -1,   697,    -1,   696,   500,
     697,    -1,   966,    -1,   222,   966,    -1,   456,   219,   320,
      -1,    -1,   700,    -1,   699,   500,   700,    -1,   963,   715,
      -1,   219,   693,   419,   956,   703,   704,    -1,   368,   693,
     215,   956,   704,   549,    -1,   368,    86,   320,   210,   693,
     215,   956,   704,   549,    -1,   456,    86,   320,    -1,    -1,
     220,   114,   966,    -1,    -1,   147,   706,   237,   961,   317,
     955,   707,   497,   708,   498,   552,   591,   868,    -1,   147,
     706,   237,   137,   961,   317,   955,   707,   497,   708,   498,
     552,   591,   868,    -1,   433,    -1,    -1,   439,   959,    -1,
      -1,   709,    -1,   708,   500,   709,    -1,  1088,   710,   711,
     712,    -1,   899,   710,   711,   712,    -1,   497,   896,   498,
     710,   711,   712,    -1,   680,    -1,   439,   680,    -1,    -1,
      99,    -1,   178,    -1,    -1,   473,    -1,   474,    -1,    -1,
     147,   714,   217,   963,   717,   367,   722,   725,   729,    -1,
     147,   714,   217,   963,   717,   367,   410,   497,   731,   498,
     725,   729,    -1,   147,   714,   217,   963,   717,   725,   729,
      -1,   322,   361,    -1,    -1,   497,   716,   498,    -1,   497,
     498,    -1,   719,    -1,   716,   500,   719,    -1,   497,   718,
     498,    -1,   497,   498,    -1,   724,    -1,   718,   500,   724,
      -1,   720,   721,   723,    -1,   721,   720,   723,    -1,   721,
     723,    -1,   720,   723,    -1,   723,    -1,   234,    -1,   324,
      -1,   243,    -1,   234,   324,    -1,   446,    -1,  1089,    -1,
     723,    -1,   872,    -1,  1089,   681,   492,   428,    -1,   388,
    1089,   681,   492,   428,    -1,   719,    -1,   719,   170,   896,
      -1,   719,   484,   896,    -1,   727,    -1,   725,   727,    -1,
     116,   317,   307,   244,    -1,   367,   307,   317,   307,   244,
      -1,   403,    -1,   232,    -1,   395,    -1,   451,    -1,   202,
     380,   174,    -1,   202,   380,   253,    -1,   380,   174,    -1,
     380,   253,    -1,   146,   604,    -1,   373,   604,    -1,   538,
      -1,    98,   728,    -1,   260,   536,    -1,   455,    -1,   726,
      -1,  1107,    -1,  1107,   500,  1107,    -1,   456,   654,    -1,
      -1,   721,   723,    -1,   730,    -1,   731,   500,   730,    -1,
      91,   217,   700,   733,   734,    -1,   726,    -1,   733,   726,
      -1,   365,    -1,    -1,   187,   217,   963,   715,   549,    -1,
     187,   217,   229,   200,   963,   715,   549,    -1,   187,    88,
     963,   658,   549,    -1,   187,    88,   229,   200,   963,   658,
     549,    -1,   187,   319,   739,   738,   549,    -1,   187,   319,
     229,   200,   739,   738,   549,    -1,   497,   872,   498,    -1,
     497,   872,   500,   872,   498,    -1,   497,   300,   500,   872,
     498,    -1,   497,   872,   500,   300,   498,    -1,   919,    -1,
    1088,   499,   739,    -1,   147,   120,   497,   872,    98,   872,
     498,   456,   217,   700,   741,    -1,   147,   120,   497,   872,
      98,   872,   498,   457,   217,   741,    -1,   147,   120,   497,
     872,    98,   872,   498,   456,   243,   741,    -1,    98,   233,
      -1,    98,   101,    -1,    -1,   187,   120,   743,   497,   872,
      98,   872,   498,   549,    -1,   229,   200,    -1,    -1,   356,
     745,   955,   746,    -1,   356,   409,   957,   746,    -1,   356,
     164,   957,   746,    -1,   237,    -1,   410,    -1,   211,    -1,
      -1,    91,    88,   963,   658,   359,   419,   957,    -1,    91,
     144,   680,   359,   419,   957,    -1,    91,   164,   958,   359,
     419,   958,    -1,    91,   217,   700,   359,   419,   957,    -1,
      91,   222,   966,   359,   419,   966,    -1,    91,   612,   260,
     957,   359,   419,   957,    -1,    91,   319,   128,   680,   439,
     959,   359,   419,   957,    -1,    91,   319,   205,   680,   439,
     959,   359,   419,   957,    -1,    91,   376,   957,   359,   419,
     957,    -1,    91,   410,   864,   359,   419,   957,    -1,    91,
     382,   955,   359,   419,   957,    -1,    91,   450,   955,   359,
     419,   957,    -1,    91,   237,   955,   359,   419,   957,    -1,
      91,   410,   864,   359,   748,   957,   419,   957,    -1,    91,
     423,   957,   317,   955,   359,   419,   957,    -1,    91,   370,
     966,   359,   419,   966,    -1,    91,   438,   966,   359,   419,
     966,    -1,    91,   411,   957,   359,   419,   957,    -1,    91,
     415,   378,   331,   680,   359,   419,   957,    -1,    91,   415,
     378,   179,   680,   359,   419,   957,    -1,    91,   415,   378,
     413,   680,   359,   419,   957,    -1,    91,   415,   378,   138,
     680,   359,   419,   957,    -1,    91,   428,   680,   359,   419,
     957,    -1,   133,    -1,    -1,   387,   163,    -1,    -1,    91,
      88,   963,   658,   387,   376,   957,    -1,    91,   185,   680,
     387,   376,   957,    -1,    91,   217,   700,   387,   376,   957,
      -1,    91,   410,   864,   387,   376,   957,    -1,    91,   382,
     955,   387,   376,   957,    -1,    91,   450,   955,   387,   376,
     957,    -1,    91,   428,   680,   387,   376,   957,    -1,    91,
      88,   963,   658,   330,   419,   966,    -1,    91,   144,   680,
     330,   419,   966,    -1,    91,   164,   958,   330,   419,   966,
      -1,    91,   185,   680,   330,   419,   966,    -1,    91,   217,
     700,   330,   419,   966,    -1,    91,   612,   260,   957,   330,
     419,   966,    -1,    91,   319,   739,   738,   330,   419,   966,
      -1,    91,   319,   128,   680,   439,   959,   330,   419,   966,
      -1,    91,   319,   205,   680,   439,   959,   330,   419,   966,
      -1,    91,   376,   957,   330,   419,   966,    -1,    91,   428,
     680,   330,   419,   966,    -1,    91,   411,   957,   330,   419,
     966,    -1,    91,   415,   378,   179,   680,   330,   419,   966,
      -1,    91,   415,   378,   138,   680,   330,   419,   966,    -1,
      91,   212,   163,   459,   957,   330,   419,   966,    -1,    91,
     384,   957,   330,   419,   966,    -1,   303,    -1,   754,    -1,
     497,   753,   498,    -1,   753,   501,   755,    -1,   755,    -1,
     823,    -1,   802,    -1,   813,    -1,   807,    -1,   759,    -1,
     754,    -1,    -1,   381,    -1,   437,    -1,   175,    -1,   246,
      -1,   247,    -1,    90,    -1,    -1,   187,   374,   957,   317,
     955,   549,    -1,   187,   374,   229,   200,   957,   317,   955,
     549,    -1,   304,  1088,    -1,   271,  1088,    -1,   435,  1088,
      -1,   435,   490,    -1,    81,   763,    -1,   107,   763,   766,
      -1,   397,   421,   766,    -1,   135,   763,    -1,   193,   763,
      -1,   371,   763,    -1,   375,  1088,    -1,   358,   375,  1088,
      -1,   358,  1088,    -1,   371,   763,   419,   375,  1088,    -1,
     371,   763,   419,  1088,    -1,   341,   421,  1107,    -1,   135,
     342,  1107,    -1,   371,   342,  1107,    -1,   458,    -1,   421,
      -1,    -1,   256,   268,   532,    -1,   350,   318,    -1,   350,
     460,    -1,   764,    -1,   765,   500,   764,    -1,   765,   764,
      -1,   765,    -1,    -1,   147,   566,   450,   955,   580,    98,
     823,   768,    -1,   147,   322,   361,   566,   450,   955,   580,
      98,   823,   768,    -1,   456,   126,   320,    -1,   456,   118,
     126,   320,    -1,   456,   273,   126,   320,    -1,    -1,   272,
     962,    -1,   147,   164,   958,   509,   771,    -1,   771,   772,
      -1,    -1,   411,   773,   957,    -1,   411,   773,   170,    -1,
     276,   773,  1107,    -1,   276,   773,   170,    -1,   413,   773,
     957,    -1,   413,   773,   170,    -1,   191,   773,  1107,    -1,
     191,   773,   965,    -1,   191,   773,   170,    -1,   263,   773,
    1107,    -1,   263,   773,   170,    -1,   264,   773,  1107,    -1,
     264,   773,   170,    -1,   139,   270,   773,   967,    -1,   330,
     773,   957,    -1,   330,   773,   170,    -1,   484,    -1,    -1,
      91,   164,   958,   509,   776,    -1,    91,   164,   958,   387,
     411,   957,    -1,    91,   164,   958,   538,    -1,   776,   777,
      -1,    -1,   139,   270,   773,   967,    -1,   187,   164,   958,
      -1,   187,   164,   229,   200,   958,    -1,   147,   185,   680,
     781,   872,   571,    -1,    91,   185,   680,   548,    -1,    91,
     185,   680,   187,   302,   307,    -1,    91,   185,   680,   387,
     302,   307,    -1,    91,   185,   680,    85,   578,    -1,    91,
     185,   680,   187,   140,   957,   549,    -1,    98,    -1,    -1,
      91,   415,   378,   179,   680,   654,    -1,    91,   415,   378,
     138,   680,    85,   279,   210,   956,   456,   679,    -1,    91,
     415,   378,   138,   680,    91,   279,   210,   956,   456,   679,
      -1,    91,   415,   378,   138,   680,    91,   279,   361,   680,
     456,   680,    -1,    91,   415,   378,   138,   680,    91,   279,
     210,   956,   361,   680,   456,   680,    -1,    91,   415,   378,
     138,   680,   187,   279,   210,   956,    -1,    91,   415,   378,
     138,   680,   187,   279,   229,   200,   210,   956,    -1,   147,
     666,   144,   680,   210,  1107,   419,  1107,   215,   680,    -1,
     130,   790,   955,   786,    -1,   130,   790,    -1,   130,   790,
     961,   317,   955,    -1,   439,   961,    -1,    -1,   440,   791,
     792,   790,    -1,   440,   791,   792,   790,   955,    -1,   440,
     791,   792,   790,   788,    -1,   789,   790,    -1,   789,   790,
     955,   793,    -1,    94,    -1,    93,    -1,   448,    -1,    -1,
     216,    -1,    -1,   214,    -1,    -1,   497,   956,   498,    -1,
      -1,   201,   796,   790,   795,    -1,   823,    -1,   802,    -1,
     813,    -1,   807,    -1,   820,    -1,   975,    -1,   800,    -1,
     789,    -1,    -1,   341,   996,   798,    98,   799,    -1,   341,
     996,   215,  1041,    -1,   497,   925,   498,    -1,    -1,   823,
      -1,   802,    -1,   813,    -1,   807,    -1,   199,   996,   801,
    1119,    -1,   147,   566,   410,   593,    98,   199,   996,   801,
      -1,   497,   924,   498,    -1,    -1,   246,   252,   955,   803,
     806,    -1,   823,    -1,   497,   804,   498,   823,    -1,   170,
     444,    -1,   805,    -1,   804,   500,   805,    -1,  1088,   946,
      -1,   366,   951,  1120,    -1,    -1,   175,   215,   866,   808,
     869,   806,    -1,   439,   857,    -1,    -1,   277,   833,   865,
     810,   812,    -1,   234,   811,   284,    -1,    -1,    83,   389,
      -1,   372,   389,    -1,   372,   198,    -1,   389,   437,   198,
      -1,   389,    -1,   389,   372,   198,    -1,   198,    -1,    83,
     198,    -1,   306,    -1,    -1,   437,   866,   387,   814,   856,
     869,   806,    -1,   815,    -1,   814,   500,   815,    -1,   816,
      -1,   817,    -1,   818,   484,   948,    -1,   497,   819,   498,
     484,   950,    -1,  1088,   946,    -1,   818,    -1,   819,   500,
     818,    -1,   169,   957,   821,   161,   822,   210,   823,    -1,
      -1,   821,   294,   377,    -1,   821,   377,    -1,   821,   110,
      -1,   821,   245,    -1,    -1,   456,   226,    -1,   457,   226,
      -1,   825,    -1,   824,    -1,   497,   825,   498,    -1,   497,
     824,   498,    -1,   827,    -1,   826,   837,    -1,   826,   836,
     850,   841,    -1,   826,   836,   840,   851,    -1,   828,   826,
      -1,   828,   826,   837,    -1,   828,   826,   836,   850,   841,
      -1,   828,   826,   836,   840,   851,    -1,   827,    -1,   824,
      -1,   381,   835,   951,   831,   856,   868,   848,   849,   907,
      -1,   855,    -1,   410,   864,    -1,   826,   432,   834,   826,
      -1,   826,   250,   834,   826,    -1,   826,   196,   834,   826,
      -1,   456,   829,    -1,   456,   354,   829,    -1,   830,    -1,
     829,   500,   830,    -1,   957,   793,    98,   824,    -1,   252,
     832,    -1,  1120,    -1,    -1,   414,   833,   955,    -1,   412,
     833,   955,    -1,   273,   414,   833,   955,    -1,   273,   412,
     833,   955,    -1,   218,   414,   833,   955,    -1,   218,   412,
     833,   955,    -1,   410,   955,    -1,   955,    -1,   410,    -1,
      -1,    89,    -1,   182,    -1,    -1,   182,    -1,   182,   317,
     497,   924,   498,    -1,    89,    -1,    -1,   837,    -1,    -1,
     323,   114,   838,    -1,   839,    -1,   838,   500,   839,    -1,
     896,   439,   922,   712,    -1,   896,   711,   712,    -1,   270,
     842,   314,   844,    -1,   314,   844,   270,   842,    -1,   270,
     842,    -1,   314,   844,    -1,   270,   842,   500,   844,    -1,
     314,   845,   846,    -1,   206,   847,   843,   846,   318,    -1,
     314,   845,   846,   206,   847,   843,   846,   318,    -1,   840,
      -1,    -1,   896,    -1,    89,    -1,   967,    -1,   497,   896,
     498,    -1,    -1,   896,    -1,   898,    -1,   372,    -1,   373,
      -1,   207,    -1,   293,    -1,   222,   114,   924,    -1,    -1,
     224,   896,    -1,    -1,   852,    -1,   210,   350,   318,    -1,
     850,    -1,    -1,   853,    -1,   852,   853,    -1,   210,   437,
     854,   812,    -1,   210,   389,   854,   812,    -1,   312,   954,
      -1,    -1,   444,   950,    -1,   855,   500,   950,    -1,   215,
     857,    -1,    -1,   858,    -1,   857,   500,   858,    -1,   864,
      -1,   864,   860,    -1,   867,    -1,   867,   860,    -1,   867,
      98,   497,   870,   498,    -1,   867,    98,  1088,   497,   870,
     498,    -1,   867,  1088,   497,   870,   498,    -1,   824,    -1,
     824,   860,    -1,   859,    -1,   497,   859,   498,   860,    -1,
     497,   859,   498,    -1,   858,   151,   257,   858,    -1,   858,
     861,   257,   858,   863,    -1,   858,   257,   858,   863,    -1,
     858,   290,   861,   257,   858,    -1,   858,   290,   257,   858,
      -1,    98,  1088,   497,   956,   498,    -1,    98,  1088,    -1,
    1088,   497,   956,   498,    -1,  1088,    -1,   216,   862,    -1,
     267,   862,    -1,   369,   862,    -1,   242,    -1,   325,    -1,
      -1,   439,   497,   956,   498,    -1,   317,   896,    -1,   955,
      -1,   955,   490,    -1,   318,   955,    -1,   318,   497,   955,
     498,    -1,   864,    -1,   865,   500,   864,    -1,   864,    -1,
     864,  1088,    -1,   864,    98,  1088,    -1,   899,    -1,   453,
     896,    -1,    -1,   453,   896,    -1,   453,   153,   312,   957,
      -1,   453,   153,   312,  1104,    -1,    -1,   871,    -1,   870,
     500,   871,    -1,  1088,   872,    -1,   874,   873,    -1,   388,
     874,   873,    -1,   874,    97,   495,   965,   496,    -1,   388,
     874,    97,   495,   965,   496,    -1,   874,    97,    -1,   388,
     874,    97,    -1,   873,   495,   496,    -1,   873,   495,  1118,
     496,    -1,    -1,   876,    -1,   878,    -1,   880,    -1,   884,
      -1,   891,    -1,   892,   894,    -1,   892,   497,   965,   498,
     894,    -1,   878,    -1,   881,    -1,   885,    -1,   891,    -1,
    1089,   877,    -1,  1089,   681,   877,    -1,   497,   924,   498,
      -1,    -1,   248,    -1,   249,    -1,   393,    -1,   109,    -1,
     351,    -1,   208,   879,    -1,   186,   339,    -1,   168,   877,
      -1,   167,   877,    -1,   310,   877,    -1,   112,    -1,   497,
     965,   498,    -1,    -1,   882,    -1,   883,    -1,   882,    -1,
     883,    -1,   111,   889,   497,   924,   498,    -1,   111,   889,
      -1,   886,    -1,   887,    -1,   886,    -1,   887,    -1,   888,
     497,   965,   498,   890,    -1,   888,   890,    -1,   124,   889,
      -1,   123,   889,    -1,   445,    -1,   289,   124,   889,    -1,
     289,   123,   889,    -1,   291,   889,    -1,   447,    -1,    -1,
     124,   387,  1088,    -1,    -1,   418,   497,   965,   498,   893,
      -1,   418,   893,    -1,   417,   497,   965,   498,   893,    -1,
     417,   893,    -1,   251,    -1,   475,   472,    -1,   457,   417,
     472,    -1,    -1,   470,    -1,   285,    -1,   165,    -1,   227,
      -1,   282,    -1,   895,    -1,   470,   419,   285,    -1,   165,
     419,   227,    -1,   165,   419,   282,    -1,   165,   419,   895,
      -1,   227,   419,   282,    -1,   227,   419,   895,    -1,   282,
     419,   895,    -1,    -1,   379,    -1,   379,   497,   965,   498,
      -1,   898,    -1,   896,    71,   872,    -1,   896,   103,   417,
     472,   896,    -1,   488,   896,    -1,   489,   896,    -1,   896,
     488,   896,    -1,   896,   489,   896,    -1,   896,   490,   896,
      -1,   896,   491,   896,    -1,   896,   492,   896,    -1,   896,
     493,   896,    -1,   896,   485,   896,    -1,   896,   486,   896,
      -1,   896,   484,   896,    -1,   896,   921,   896,    -1,   921,
     896,    -1,   896,   921,    -1,   896,    95,   896,    -1,   896,
     322,   896,    -1,   302,   896,    -1,   896,   269,   896,    -1,
     896,   269,   896,   195,   896,    -1,   896,   302,   269,   896,
      -1,   896,   302,   269,   896,   195,   896,    -1,   896,   230,
     896,    -1,   896,   230,   896,   195,   896,    -1,   896,   302,
     230,   896,    -1,   896,   302,   230,   896,   195,   896,    -1,
     896,   391,   419,   896,    -1,   896,   391,   419,   896,   195,
     896,    -1,   896,   302,   391,   419,   896,    -1,   896,   302,
     391,   419,   896,   195,   896,    -1,   896,   254,   307,    -1,
     896,   255,    -1,   896,   254,   302,   307,    -1,   896,   305,
      -1,   917,   327,   917,    -1,   896,   254,   425,    -1,   896,
     254,   302,   425,    -1,   896,   254,   204,    -1,   896,   254,
     302,   204,    -1,   896,   254,   434,    -1,   896,   254,   302,
     434,    -1,   896,   254,   182,   215,   896,    -1,   896,   254,
     302,   182,   215,   896,    -1,   896,   254,   312,   497,   925,
     498,    -1,   896,   254,   302,   312,   497,   925,   498,    -1,
     896,   108,   947,   897,    95,   897,    -1,   896,   302,   108,
     947,   897,    95,   897,    -1,   896,   108,   407,   897,    95,
     897,    -1,   896,   302,   108,   407,   897,    95,   897,    -1,
     896,   234,   937,    -1,   896,   302,   234,   937,    -1,   896,
     923,   918,   824,    -1,   896,   923,   918,   497,   896,   498,
      -1,   433,   824,    -1,   896,   254,   184,    -1,   896,   254,
     302,   184,    -1,   898,    -1,   897,    71,   872,    -1,   488,
     897,    -1,   489,   897,    -1,   897,   488,   897,    -1,   897,
     489,   897,    -1,   897,   490,   897,    -1,   897,   491,   897,
      -1,   897,   492,   897,    -1,   897,   493,   897,    -1,   897,
     485,   897,    -1,   897,   486,   897,    -1,   897,   484,   897,
      -1,   897,   921,   897,    -1,   921,   897,    -1,   897,   921,
      -1,   897,   254,   182,   215,   897,    -1,   897,   254,   302,
     182,   215,   897,    -1,   897,   254,   312,   497,   925,   498,
      -1,   897,   254,   302,   312,   497,   925,   498,    -1,   897,
     254,   184,    -1,   897,   254,   302,   184,    -1,   943,    -1,
     964,    -1,  1104,   946,    -1,   497,   896,   498,   946,    -1,
     938,    -1,   899,    -1,   824,    -1,   200,   824,    -1,    97,
     824,    -1,    97,   926,    -1,   917,    -1,   963,   497,   498,
     910,    -1,   963,   497,   924,   498,   910,    -1,   963,   497,
     446,   896,   498,   910,    -1,   963,   497,   924,   500,   446,
     896,   498,   910,    -1,   963,   497,    89,   924,   498,   910,
      -1,   963,   497,   182,   924,   498,   910,    -1,   963,   497,
     490,   498,   910,    -1,   155,    -1,   158,    -1,   158,   497,
     965,   498,    -1,   159,    -1,   159,   497,   965,   498,    -1,
     274,    -1,   274,   497,   965,   498,    -1,   275,    -1,   275,
     497,   965,   498,    -1,   156,    -1,   160,    -1,   386,    -1,
     438,    -1,   154,    -1,   157,    -1,   120,   497,   896,    98,
     872,   498,    -1,   203,   497,   928,   498,    -1,   328,   497,
     930,   498,    -1,   337,   497,   932,   498,    -1,   405,   497,
     933,   498,    -1,   422,   497,   896,    98,   872,   498,    -1,
     424,   497,   113,   936,   498,    -1,   424,   497,   265,   936,
     498,    -1,   424,   497,   420,   936,   498,    -1,   424,   497,
     936,   498,    -1,   308,   497,   896,   500,   896,   498,    -1,
     131,   497,   924,   498,    -1,   221,   497,   924,   498,    -1,
     266,   497,   924,   498,    -1,   463,   497,   924,   498,    -1,
     464,   497,   287,  1090,   498,    -1,   464,   497,   287,  1090,
     500,   902,   498,    -1,   464,   497,   287,  1090,   500,   924,
     498,    -1,   464,   497,   287,  1090,   500,   902,   500,   924,
     498,    -1,   465,   497,   903,   498,    -1,   466,   497,   905,
     896,   906,   498,    -1,   467,   497,   287,  1090,   498,    -1,
     467,   497,   287,  1090,   500,   896,   498,    -1,   468,   497,
     896,   500,   900,   901,   498,    -1,   469,   497,   905,   896,
      98,   874,   498,    -1,   449,   896,    -1,   449,   294,   443,
      -1,   500,   396,   471,    -1,   500,   396,   294,    -1,   500,
     396,   294,   443,    -1,    -1,   462,   497,   903,   498,    -1,
     904,    -1,   903,   500,   904,    -1,   896,    98,  1090,    -1,
     896,    -1,   184,    -1,   142,    -1,   340,   454,    -1,   404,
     454,    -1,    -1,   455,   908,    -1,    -1,   909,    -1,   908,
     500,   909,    -1,  1088,    98,   911,    -1,   326,   911,    -1,
     326,  1088,    -1,    -1,   497,   912,   913,   836,   914,   498,
      -1,  1088,    -1,    -1,   333,   114,   924,    -1,    -1,   349,
     915,    -1,   373,   915,    -1,    -1,   916,    -1,   108,   916,
      95,   916,    -1,   429,   338,    -1,   429,   209,    -1,   153,
     372,    -1,   372,   497,   924,   498,    -1,   372,   497,   498,
      -1,   497,   924,   500,   896,   498,    -1,    96,    -1,   394,
      -1,    89,    -1,   481,    -1,   920,    -1,   488,    -1,   489,
      -1,   490,    -1,   491,    -1,   492,    -1,   493,    -1,   485,
      -1,   486,    -1,   484,    -1,   481,    -1,   319,   497,   739,
     498,    -1,   919,    -1,   319,   497,   739,   498,    -1,   919,
      -1,   319,   497,   739,   498,    -1,   269,    -1,   302,   269,
      -1,   230,    -1,   302,   230,    -1,   896,    -1,   924,   500,
     896,    -1,   872,    -1,   925,   500,   872,    -1,   495,   924,
     496,    -1,   495,   927,   496,    -1,   495,   496,    -1,   926,
      -1,   927,   500,   926,    -1,   929,   215,   896,    -1,    -1,
    1109,    -1,   470,    -1,   285,    -1,   165,    -1,   227,    -1,
     282,    -1,   379,    -1,  1107,    -1,   896,   931,   934,   935,
      -1,   896,   931,   934,    -1,   335,   896,    -1,   897,   234,
     897,    -1,    -1,   896,   934,   935,    -1,   896,   935,   934,
      -1,   896,   934,    -1,   896,   935,    -1,   924,    -1,    -1,
     215,   896,    -1,   210,   896,    -1,   896,   215,   924,    -1,
     215,   924,    -1,   924,    -1,   824,    -1,   497,   924,   498,
      -1,   119,   942,   939,   941,   193,    -1,   940,    -1,   939,
     940,    -1,   452,   896,   416,   896,    -1,   189,   896,    -1,
      -1,   896,    -1,    -1,   953,    -1,   953,   945,    -1,   499,
     960,    -1,   499,   490,    -1,   495,   896,   496,    -1,   495,
     896,   502,   896,   496,    -1,   944,    -1,   945,   944,    -1,
      -1,   946,   944,    -1,   102,    -1,    -1,   896,    -1,   170,
      -1,   948,    -1,   949,   500,   948,    -1,   497,   949,   498,
      -1,   952,    -1,   951,   500,   952,    -1,   896,    98,  1090,
      -1,   896,  1109,    -1,   896,    -1,   490,    -1,   972,    -1,
    1088,    -1,   955,    -1,   954,   500,   955,    -1,   953,    -1,
     953,   945,    -1,   957,    -1,   956,   500,   957,    -1,  1088,
      -1,  1088,    -1,  1088,    -1,  1090,    -1,  1088,    -1,  1107,
      -1,  1089,    -1,   953,   945,    -1,   965,    -1,  1106,    -1,
    1107,    -1,  1105,    -1,   480,    -1,   963,  1107,    -1,   963,
     497,   924,   498,  1107,    -1,   875,  1107,    -1,   892,  1107,
     894,    -1,   892,   497,   965,   498,  1107,   894,    -1,   425,
      -1,   204,    -1,   307,    -1,  1101,    -1,  1100,    -1,   482,
      -1,  1088,    -1,   965,    -1,  1101,    -1,   488,   965,    -1,
     489,   965,    -1,    81,    -1,    82,    -1,    83,    -1,    84,
      -1,    85,    -1,    86,    -1,    87,    -1,    88,    -1,    90,
      -1,    91,    -1,    92,    -1,   100,    -1,   101,    -1,   103,
      -1,   105,    -1,   106,    -1,   107,    -1,   114,    -1,   115,
      -1,   116,    -1,   117,    -1,   118,    -1,   121,    -1,   122,
      -1,   125,    -1,   127,    -1,   128,    -1,   129,    -1,   130,
      -1,   134,    -1,   135,    -1,   136,    -1,   137,    -1,   138,
      -1,   141,    -1,   142,    -1,   143,    -1,   144,    -1,   145,
      -1,   146,    -1,   148,    -1,   149,    -1,   150,    -1,   152,
      -1,   161,    -1,   162,    -1,   163,    -1,   164,    -1,   166,
      -1,   169,    -1,   171,    -1,   173,    -1,   174,    -1,   175,
      -1,   176,    -1,   177,    -1,   179,    -1,   180,    -1,   181,
      -1,   184,    -1,   185,    -1,   186,    -1,   187,    -1,   188,
      -1,   190,    -1,   191,    -1,   192,    -1,   194,    -1,   195,
      -1,   197,    -1,   198,    -1,   199,    -1,   201,    -1,   202,
      -1,   205,    -1,   207,    -1,   209,    -1,   211,    -1,   213,
      -1,   217,    -1,   218,    -1,   220,    -1,   223,    -1,   225,
      -1,   226,    -1,   228,    -1,   229,    -1,   231,    -1,   232,
      -1,   233,    -1,   235,    -1,   236,    -1,   237,    -1,   238,
      -1,   239,    -1,   240,    -1,   245,    -1,   246,    -1,   247,
      -1,   253,    -1,   256,    -1,   258,    -1,   259,    -1,   260,
      -1,   261,    -1,   262,    -1,   263,    -1,   264,    -1,   268,
      -1,   271,    -1,   272,    -1,   273,    -1,   276,    -1,   277,
      -1,   278,    -1,   279,    -1,   280,    -1,   281,    -1,   283,
      -1,   284,    -1,   286,    -1,   287,    -1,   288,    -1,   293,
      -1,   294,    -1,   295,    -1,   296,    -1,   297,    -1,   298,
      -1,   299,    -1,   301,    -1,   303,    -1,   304,    -1,   306,
      -1,   309,    -1,   311,    -1,   312,    -1,   315,    -1,   319,
      -1,   320,    -1,   321,    -1,   329,    -1,   330,    -1,   331,
      -1,   332,    -1,   333,    -1,   334,    -1,   336,    -1,   338,
      -1,   341,    -1,   342,    -1,   340,    -1,   344,    -1,   345,
      -1,   346,    -1,   347,    -1,   348,    -1,   349,    -1,   350,
      -1,   352,    -1,   353,    -1,   354,    -1,   356,    -1,   357,
      -1,   358,    -1,   359,    -1,   360,    -1,   361,    -1,   362,
      -1,   363,    -1,   364,    -1,   365,    -1,   367,    -1,   368,
      -1,   370,    -1,   371,    -1,   373,    -1,   374,    -1,   375,
      -1,   376,    -1,   377,    -1,   378,    -1,   380,    -1,   382,
      -1,   383,    -1,   384,    -1,   385,    -1,   387,    -1,   389,
      -1,   390,    -1,   392,    -1,   395,    -1,   396,    -1,   397,
      -1,   398,    -1,   399,    -1,   400,    -1,   401,    -1,   402,
      -1,   403,    -1,   404,    -1,   406,    -1,   408,    -1,   409,
      -1,   411,    -1,   412,    -1,   413,    -1,   414,    -1,   415,
      -1,   421,    -1,   423,    -1,   426,    -1,   427,    -1,   428,
      -1,   429,    -1,   430,    -1,   431,    -1,   434,    -1,   435,
      -1,   436,    -1,   437,    -1,   440,    -1,   441,    -1,   442,
      -1,   443,    -1,   447,    -1,   449,    -1,   450,    -1,   451,
      -1,   454,    -1,   457,    -1,   458,    -1,   459,    -1,   460,
      -1,   461,    -1,   471,    -1,   472,    -1,   109,    -1,   111,
      -1,   112,    -1,   124,    -1,   131,    -1,   167,    -1,   168,
      -1,   200,    -1,   203,    -1,   208,    -1,   221,    -1,   243,
      -1,   249,    -1,   251,    -1,   266,    -1,   289,    -1,   291,
      -1,   300,    -1,   308,    -1,   310,    -1,   324,    -1,   328,
      -1,   337,    -1,   339,    -1,   351,    -1,   372,    -1,   388,
      -1,   393,    -1,   405,    -1,   417,    -1,   418,    -1,   422,
      -1,   424,    -1,   445,    -1,   462,    -1,   463,    -1,   464,
      -1,   465,    -1,   466,    -1,   467,    -1,   468,    -1,   469,
      -1,   104,    -1,   108,    -1,   110,    -1,   151,    -1,   157,
      -1,   214,    -1,   216,    -1,   230,    -1,   242,    -1,   254,
      -1,   255,    -1,   257,    -1,   267,    -1,   269,    -1,   290,
      -1,   305,    -1,   325,    -1,   326,    -1,   327,    -1,   369,
      -1,   391,    -1,   448,    -1,    89,    -1,    93,    -1,    94,
      -1,    95,    -1,    96,    -1,    97,    -1,    98,    -1,    99,
      -1,   102,    -1,   113,    -1,   119,    -1,   120,    -1,   126,
      -1,   132,    -1,   133,    -1,   140,    -1,   147,    -1,   154,
      -1,   155,    -1,   156,    -1,   158,    -1,   159,    -1,   160,
      -1,   170,    -1,   172,    -1,   178,    -1,   182,    -1,   183,
      -1,   189,    -1,   193,    -1,   196,    -1,   204,    -1,   206,
      -1,   210,    -1,   212,    -1,   215,    -1,   219,    -1,   222,
      -1,   224,    -1,   234,    -1,   241,    -1,   250,    -1,   252,
      -1,   265,    -1,   270,    -1,   274,    -1,   275,    -1,   292,
      -1,   302,    -1,   307,    -1,   313,    -1,   314,    -1,   316,
      -1,   317,    -1,   318,    -1,   322,    -1,   323,    -1,   335,
      -1,   343,    -1,   355,    -1,   366,    -1,   381,    -1,   386,
      -1,   394,    -1,   407,    -1,   410,    -1,   416,    -1,   420,
      -1,   425,    -1,   433,    -1,   438,    -1,   439,    -1,   446,
      -1,   452,    -1,   453,    -1,   455,    -1,   456,    -1,   316,
      -1,   292,    -1,    -1,   973,   974,    -1,  1097,   979,   507,
     501,    -1,  1097,   507,   501,    -1,  1097,   999,    -1,  1004,
      -1,  1115,    -1,    74,    -1,   503,    -1,   504,    -1,    -1,
     147,   566,   410,   593,    98,   976,   823,   597,    -1,    -1,
     147,   714,   374,   957,    98,   978,   317,   756,   419,   955,
     868,   183,   757,   752,    -1,   103,  1040,    -1,     9,   419,
     981,   988,   989,    -1,     9,   419,   170,    -1,     9,   990,
      -1,   164,   981,    -1,   982,   985,   987,    -1,   983,   502,
     984,   987,   491,   982,   993,    -1,   992,    -1,  1107,    -1,
     958,    -1,    -1,  1109,  1103,    -1,   481,   986,    -1,   984,
      -1,    -1,  1088,    -1,  1088,   499,   986,    -1,    75,    -1,
     502,   965,    -1,    -1,    98,  1040,    -1,    -1,   438,   990,
      -1,    -1,   991,    -1,   991,   491,   991,    -1,   991,    21,
     114,   991,    -1,   991,   439,   991,    -1,   966,    -1,  1107,
      -1,  1101,    -1,  1103,    -1,   481,   994,    -1,    -1,  1088,
     995,    -1,  1088,   995,   481,   994,    -1,    -1,   484,   965,
      -1,   484,  1109,    -1,   484,  1101,    -1,   957,    -1,   992,
      -1,   169,   957,   821,   161,   822,   210,   996,    -1,   199,
     231,  1041,    -1,  1000,    -1,  1011,    -1,  1013,    -1,   604,
      -1,   500,   604,    -1,    -1,   894,    -1,   470,   419,   282,
      -1,   470,   419,   379,    -1,   165,   419,   165,    -1,   285,
     419,   285,    -1,    -1,  1006,  1005,  1008,  1007,    -1,  1097,
     107,   169,    34,   501,    -1,  1097,   193,   169,    34,   501,
      -1,    -1,  1009,    -1,    74,    -1,  1013,    -1,  1011,    -1,
    1009,  1013,    -1,  1009,  1011,    -1,  1009,    74,    -1,  1013,
      -1,  1010,  1013,    -1,    -1,    70,  1012,  1020,  1036,  1092,
     873,   501,    -1,    -1,  1017,  1020,  1014,  1033,   501,    -1,
      -1,  1020,  1015,  1033,   501,    -1,  1023,   501,    -1,   502,
     965,    -1,    -1,  1018,  1019,    -1,  1018,    -1,  1019,    -1,
      56,    -1,    67,    -1,    65,    -1,    50,    -1,    51,    -1,
      69,    -1,  1029,    -1,  1025,    -1,  1021,    -1,  1092,   497,
    1001,  1002,   498,    -1,  1092,  1003,    -1,  1027,    -1,   194,
    1086,  1022,    -1,   194,  1022,    -1,   194,  1086,    -1,   503,
    1113,   504,    -1,    -1,  1027,  1024,   503,  1010,   504,    -1,
    1023,    -1,    -1,  1028,  1026,   503,  1010,   504,    -1,    43,
    1086,    -1,   432,  1086,    -1,    43,    -1,   432,    -1,  1030,
      -1,  1032,  1031,    -1,    44,    35,    -1,    44,    35,   248,
      -1,    44,    -1,    44,   248,    -1,    44,    25,    -1,    44,
      25,   248,    -1,    44,    25,    25,    -1,    44,    25,    25,
     248,    -1,    44,   123,    -1,    35,    -1,    35,   248,    -1,
     248,    -1,    25,    -1,    25,   248,    -1,    25,    25,    -1,
      25,    25,   248,    -1,     5,    -1,   123,    -1,   186,    -1,
      36,    -1,    -1,  1034,    -1,  1033,   500,  1034,    -1,  1036,
    1091,   873,  1016,  1035,    -1,    -1,   484,  1114,    -1,    -1,
     490,    -1,   490,   490,    -1,   169,   398,  1109,    -1,    15,
    1039,    -1,  1040,    -1,   153,    -1,    89,    -1,    -1,   958,
      -1,   170,    -1,   992,    -1,   992,    -1,    72,    -1,    17,
     957,    -1,    17,    89,    -1,    28,   957,  1044,    -1,    -1,
    1045,    -1,   439,  1049,    -1,  1046,    -1,   439,  1048,    14,
    1110,    -1,   252,  1048,    14,  1110,    -1,    -1,    37,    -1,
    1050,    -1,  1050,   500,  1049,    -1,  1051,    -1,  1101,    -1,
    1100,    -1,   965,    -1,   488,   965,    -1,   489,   965,    -1,
    1106,    -1,   488,  1106,    -1,   489,  1106,    -1,  1107,    -1,
    1105,    -1,  1108,    -1,    13,   244,   957,  1046,    -1,    13,
    1053,   957,  1046,    -1,    13,  1053,   957,  1047,    -1,    29,
      -1,    -1,     3,    14,  1110,    -1,   166,    14,  1110,    -1,
      18,    14,  1110,  1057,    -1,  1058,    -1,  1057,   500,  1058,
      -1,  1103,   484,  1063,    -1,   387,    14,  1110,  1060,    -1,
    1061,    -1,  1060,   500,  1061,    -1,  1063,   484,  1062,    -1,
     965,    -1,  1103,    -1,    10,    -1,    18,    14,  1110,   443,
    1062,  1065,    -1,  1066,    -1,  1065,   500,  1066,    -1,  1103,
     484,  1071,    -1,   387,    14,  1110,   443,  1062,  1068,    -1,
    1069,    -1,  1068,   500,  1069,    -1,  1071,   484,  1070,    -1,
    1106,    -1,  1062,    -1,   489,  1106,    -1,   489,   965,    -1,
    1107,    -1,     8,    -1,   163,    -1,    11,    -1,    12,    -1,
      22,    -1,    23,    -1,    24,    -1,   287,    -1,    26,    -1,
      27,    -1,   339,    -1,    31,    -1,    32,    -1,    33,    -1,
     428,    -1,   387,     4,   484,  1073,    -1,   387,     4,   419,
    1073,    -1,   317,    -1,   313,    -1,   387,   139,   419,  1040,
      -1,   387,   139,   484,  1040,    -1,   387,   139,  1040,    -1,
      -1,   428,  1076,  1092,   254,  1020,   873,  1077,    -1,    30,
      -1,    -1,    -1,    45,  1079,  1090,   254,  1020,   873,  1077,
      -1,    46,    38,  1081,    -1,    46,   302,    16,  1081,    -1,
      46,    40,  1081,    -1,   143,    -1,    39,    -1,    42,    -1,
      20,   957,    -1,    19,   419,   957,    -1,   183,   957,   497,
    1098,   498,    -1,   183,     6,    -1,     7,   957,   497,  1098,
     498,    -1,     7,   957,    -1,  1083,    -1,  1084,    -1,     6,
      -1,     7,    -1,     8,    -1,    10,    -1,    11,    -1,    12,
      -1,    16,    -1,    19,    -1,    20,    -1,    21,    -1,    22,
      -1,    23,    -1,    24,    -1,    26,    -1,    27,    -1,    31,
      -1,    32,    -1,    33,    -1,    34,    -1,    37,    -1,    38,
      -1,    39,    -1,    40,    -1,    42,    -1,     9,    -1,    13,
      -1,    15,    -1,    28,    -1,    45,    -1,    46,    -1,     5,
      -1,    25,    -1,    29,    -1,    35,    -1,    43,    -1,    36,
      -1,    44,    -1,  1090,    -1,  1109,    -1,   968,    -1,   969,
      -1,  1095,    -1,  1082,    -1,  1093,    -1,   123,    -1,   444,
      -1,  1109,    -1,  1094,    -1,   969,    -1,  1082,    -1,  1093,
      -1,   123,    -1,   444,    -1,  1109,    -1,  1094,    -1,   970,
      -1,  1082,    -1,  1093,    -1,  1085,    -1,  1091,    -1,  1085,
      -1,   123,    -1,   153,    -1,   244,    -1,   248,    -1,   419,
      -1,   432,    -1,   444,    -1,  1093,    -1,  1095,    -1,  1092,
      -1,   968,    -1,   971,    -1,  1084,    -1,   139,    -1,  1109,
      -1,   969,    -1,   970,    -1,  1083,    -1,    50,    -1,    51,
      -1,    56,    -1,    65,    -1,    67,    -1,    70,    -1,    69,
      -1,   968,    -1,  1095,    -1,   139,    -1,   165,    -1,   227,
      -1,   282,    -1,   285,    -1,   379,    -1,   470,    -1,  1099,
      -1,  1096,   500,  1099,    -1,    41,    -1,    -1,  1113,    -1,
    1103,  1102,    -1,  1103,    -1,  1103,  1102,    -1,  1103,    -1,
    1103,    -1,    22,  1103,    -1,    22,   957,    -1,    73,    -1,
     483,    -1,   479,    -1,   477,    -1,   478,    -1,    77,    -1,
      78,    -1,    79,    -1,    76,    -1,   480,    -1,   476,    -1,
      72,    -1,    80,    -1,   957,    -1,   992,    -1,  1116,    -1,
     497,   498,    -1,   497,  1112,   498,    -1,  1111,    -1,  1112,
    1111,    -1,  1114,    -1,  1113,   500,  1114,    -1,  1112,    -1,
     503,  1113,   504,    -1,  1116,    -1,   497,    -1,   498,    -1,
     500,    -1,   501,    -1,  1109,    -1,   965,    -1,  1106,    -1,
    1107,    -1,   490,    -1,   488,    -1,   489,    -1,   491,    -1,
     492,    -1,   307,    -1,    47,    -1,    48,    -1,    49,    -1,
      50,    -1,    51,    -1,    52,    -1,    53,    -1,    54,    -1,
      55,    -1,    56,    -1,    57,    -1,    58,    -1,    60,    -1,
      59,    -1,    61,    -1,    62,    -1,    63,    -1,    64,    -1,
      65,    -1,    66,    -1,    67,    -1,    68,    -1,    70,    -1,
      69,    -1,     5,    -1,   194,    -1,   227,    -1,   248,    -1,
      25,    -1,   282,    -1,   285,    -1,   379,    -1,    35,    -1,
      36,    -1,    43,    -1,    44,    -1,   470,    -1,   123,    -1,
     208,    -1,   419,    -1,   432,    -1,   445,    -1,   495,    -1,
     496,    -1,   484,    -1,   502,    -1,   166,   996,    -1,   166,
     341,   996,    -1,   166,    89,    -1,   166,   341,    89,    -1,
     965,    -1,   497,  1118,   498,    -1,  1118,   488,  1118,    -1,
    1118,   489,  1118,    -1,  1118,   490,  1118,    -1,  1118,   491,
    1118,    -1,  1118,   492,  1118,    -1,  1107,    -1,  1088,    -1,
      -1,  1045,  1120,    -1,  1120,  1045,    -1,  1045,    -1,  1120,
      -1,   252,  1096,    -1,  1047,    -1
};

/* YYRLINE[YYN] -- source line where rule number YYN was defined.  */
static const unsigned short yyrline[] =
{
       0,  1188,  1188,  1191,  1193,  1195,  1197,  1199,  1201,  1203,
    1205,  1207,  1209,  1211,  1213,  1215,  1217,  1219,  1221,  1223,
    1225,  1227,  1229,  1231,  1249,  1251,  1253,  1255,  1257,  1259,
    1261,  1263,  1265,  1267,  1269,  1271,  1273,  1275,  1277,  1279,
    1281,  1283,  1285,  1287,  1289,  1291,  1293,  1295,  1297,  1299,
    1301,  1308,  1310,  1312,  1314,  1316,  1318,  1320,  1322,  1324,
    1326,  1328,  1330,  1332,  1334,  1336,  1338,  1340,  1342,  1344,
    1346,  1348,  1350,  1352,  1354,  1356,  1358,  1360,  1362,  1364,
    1366,  1368,  1370,  1372,  1379,  1381,  1383,  1385,  1387,  1389,
    1391,  1393,  1395,  1397,  1399,  1405,  1407,  1409,  1411,  1413,
    1415,  1417,  1419,  1421,  1427,  1437,  1441,  1449,  1453,  1463,
    1473,  1474,  1485,  1492,  1498,  1509,  1515,  1524,  1531,  1537,
    1546,  1553,  1561,  1566,  1574,  1579,  1585,  1590,  1596,  1600,
    1604,  1608,  1612,  1616,  1620,  1624,  1628,  1632,  1636,  1640,
    1644,  1648,  1652,  1656,  1660,  1664,  1668,  1672,  1676,  1680,
    1684,  1688,  1696,  1704,  1712,  1720,  1728,  1736,  1740,  1748,
    1752,  1760,  1768,  1776,  1780,  1788,  1792,  1800,  1804,  1812,
    1817,  1823,  1828,  1834,  1838,  1842,  1846,  1850,  1854,  1862,
    1866,  1870,  1878,  1882,  1886,  1890,  1894,  1898,  1902,  1906,
    1910,  1915,  1919,  1923,  1927,  1931,  1935,  1943,  1947,  1955,
    1959,  1967,  1971,  1975,  1989,  1993,  1997,  2001,  2009,  2013,
    2017,  2021,  2029,  2033,  2037,  2041,  2045,  2049,  2053,  2061,
    2065,  2070,  2076,  2080,  2088,  2092,  2096,  2100,  2104,  2112,
    2116,  2124,  2128,  2132,  2136,  2140,  2149,  2157,  2161,  2169,
    2173,  2181,  2189,  2193,  2197,  2201,  2209,  2213,  2217,  2221,
    2229,  2233,  2241,  2245,  2249,  2253,  2257,  2261,  2265,  2269,
    2273,  2277,  2281,  2285,  2289,  2293,  2297,  2301,  2305,  2309,
    2313,  2317,  2321,  2325,  2329,  2333,  2337,  2341,  2345,  2349,
    2353,  2357,  2361,  2365,  2373,  2377,  2385,  2389,  2394,  2400,
    2405,  2411,  2419,  2424,  2430,  2434,  2442,  2446,  2450,  2454,
    2462,  2466,  2474,  2485,  2496,  2500,  2508,  2512,  2516,  2524,
    2529,  2535,  2539,  2543,  2547,  2551,  2555,  2559,  2563,  2567,
    2571,  2579,  2584,  2590,  2595,  2601,  2606,  2612,  2617,  2623,
    2627,  2635,  2639,  2643,  2647,  2651,  2655,  2660,  2666,  2671,
    2677,  2681,  2689,  2693,  2697,  2705,  2713,  2718,  2724,  2728,
    2732,  2740,  2744,  2748,  2752,  2756,  2760,  2764,  2772,  2776,
    2780,  2784,  2792,  2800,  2805,  2811,  2815,  2819,  2823,  2827,
    2831,  2839,  2843,  2851,  2855,  2859,  2863,  2871,  2876,  2882,
    2886,  2894,  2902,  2906,  2911,  2916,  2922,  2926,  2930,  2934,
    2939,  2945,  2953,  2961,  2965,  2969,  2973,  2977,  2985,  2990,
    2996,  3000,  3004,  3009,  3015,  3019,  3023,  3028,  3034,  3039,
    3045,  3050,  3056,  3064,  3069,  3075,  3079,  3087,  3095,  3099,
    3104,  3110,  3118,  3126,  3131,  3137,  3141,  3149,  3153,  3157,
    3161,  3165,  3169,  3173,  3177,  3181,  3185,  3189,  3193,  3201,
    3206,  3212,  3216,  3220,  3231,  3235,  3243,  3248,  3254,  3258,
    3266,  3270,  3278,  3283,  3289,  3294,  3300,  3304,  3312,  3317,
    3323,  3331,  3336,  3342,  3346,  3354,  3362,  3366,  3374,  3378,
    3382,  3390,  3395,  3401,  3405,  3413,  3421,  3425,  3433,  3437,
    3441,  3445,  3453,  3461,  3469,  3477,  3485,  3490,  3496,  3500,
    3508,  3513,  3519,  3523,  3531,  3535,  3539,  3547,  3555,  3559,
    3563,  3571,  3575,  3583,  3591,  3595,  3603,  3607,  3615,  3619,
    3627,  3631,  3635,  3639,  3647,  3652,  3658,  3663,  3669,  3673,
    3681,  3685,  3690,  3696,  3700,  3704,  3708,  3712,  3716,  3724,
    3729,  3735,  3739,  3746,  3750,  3758,  3764,  3768,  3776,  3780,
    3788,  3792,  3800,  3809,  3818,  3822,  3826,  3830,  3834,  3838,
    3842,  3846,  3850,  3854,  3858,  3866,  3874,  3878,  3886,  3890,
    3898,  3902,  3906,  3910,  3914,  3922,  3926,  3934,  3942,  3946,
    3954,  3962,  3966,  3974,  3982,  3986,  3994,  3998,  4002,  4006,
    4010,  4018,  4023,  4029,  4034,  4040,  4046,  4052,  4060,  4064,
    4072,  4076,  4084,  4088,  4096,  4100,  4108,  4112,  4120,  4128,
    4136,  4140,  4148,  4152,  4156,  4160,  4164,  4168,  4172,  4176,
    4180,  4184,  4188,  4192,  4200,  4204,  4212,  4216,  4224,  4228,
    4236,  4244,  4248,  4253,  4259,  4263,  4267,  4271,  4275,  4279,
    4283,  4287,  4291,  4295,  4299,  4303,  4307,  4311,  4315,  4319,
    4323,  4331,  4335,  4339,  4343,  4347,  4351,  4355,  4359,  4363,
    4367,  4371,  4375,  4383,  4387,  4395,  4400,  4405,  4409,  4413,
    4418,  4423,  4428,  4433,  4438,  4447,  4451,  4455,  4459,  4463,
    4473,  4483,  4493,  4497,  4501,  4511,  4515,  4519,  4529,  4537,
    4541,  4549,  4557,  4561,  4569,  4573,  4577,  4581,  4585,  4593,
    4597,  4605,  4609,  4613,  4617,  4625,  4629,  4633,  4637,  4641,
    4645,  4649,  4653,  4657,  4661,  4669,  4673,  4681,  4685,  4693,
    4698,  4704,  4708,  4716,  4724,  4732,  4736,  4744,  4749,  4755,
    4760,  4766,  4770,  4778,  4783,  4789,  4794,  4800,  4804,  4812,
    4816,  4820,  4828,  4832,  4837,  4843,  4847,  4852,  4858,  4862,
    4867,  4873,  4877,  4881,  4889,  4894,  4900,  4904,  4912,  4916,
    4924,  4928,  4936,  4940,  4948,  4952,  4956,  4960,  4964,  4972,
    4976,  4980,  4984,  4988,  4996,  5004,  5012,  5016,  5020,  5028,
    5032,  5036,  5044,  5048,  5056,  5060,  5064,  5068,  5072,  5076,
    5080,  5084,  5088,  5092,  5096,  5100,  5104,  5112,  5116,  5120,
    5124,  5132,  5136,  5144,  5149,  5155,  5163,  5167,  5175,  5183,
    5187,  5195,  5200,  5206,  5210,  5218,  5222,  5230,  5234,  5242,
    5246,  5250,  5254,  5262,  5266,  5274,  5278,  5282,  5290,  5294,
    5299,  5305,  5313,  5318,  5324,  5328,  5332,  5340,  5344,  5352,
    5357,  5363,  5367,  5371,  5375,  5379,  5383,  5387,  5391,  5395,
    5399,  5403,  5407,  5411,  5415,  5419,  5423,  5427,  5431,  5435,
    5439,  5443,  5447,  5451,  5459,  5464,  5470,  5475,  5481,  5485,
    5489,  5493,  5497,  5501,  5505,  5513,  5517,  5521,  5525,  5529,
    5533,  5537,  5541,  5545,  5549,  5553,  5557,  5561,  5565,  5569,
    5573,  5581,  5585,  5589,  5597,  5601,  5609,  5613,  5617,  5621,
    5625,  5633,  5638,  5644,  5648,  5652,  5656,  5664,  5668,  5673,
    5679,  5683,  5691,  5699,  5707,  5711,  5719,  5723,  5727,  5731,
    5735,  5739,  5743,  5747,  5751,  5755,  5759,  5763,  5767,  5771,
    5779,  5783,  5788,  5794,  5798,  5802,  5810,  5814,  5818,  5826,
    5831,  5837,  5841,  5849,  5854,  5859,  5865,  5871,  5879,  5887,
    5892,  5898,  5902,  5906,  5910,  5914,  5918,  5922,  5926,  5930,
    5934,  5938,  5942,  5946,  5950,  5954,  5958,  5966,  5971,  5977,
    5981,  5989,  5997,  6002,  6008,  6016,  6020,  6028,  6036,  6040,
    6044,  6048,  6052,  6060,  6065,  6071,  6079,  6083,  6087,  6091,
    6095,  6099,  6107,  6115,  6119,  6123,  6131,  6136,  6142,  6146,
    6150,  6158,  6162,  6170,  6174,  6182,  6187,  6193,  6198,  6204,
    6209,  6215,  6220,  6226,  6234,  6238,  6242,  6246,  6250,  6254,
    6258,  6266,  6271,  6277,  6283,  6293,  6298,  6304,  6308,  6312,
    6316,  6324,  6326,  6334,  6339,  6345,  6353,  6357,  6361,  6369,
    6373,  6381,  6389,  6394,  6400,  6408,  6413,  6419,  6427,  6432,
    6438,  6442,  6446,  6450,  6454,  6458,  6462,  6466,  6474,  6479,
    6485,  6493,  6497,  6505,  6509,  6517,  6525,  6533,  6541,  6545,
    6553,  6594,  6596,  6600,  6604,  6608,  6617,  6623,  6627,  6635,
    6639,  6647,  6651,  6659,  6663,  6667,  6671,  6675,  6679,  6683,
    6687,  6695,  6699,  6707,  6711,  6715,  6719,  6723,  6727,  6735,
    6739,  6747,  6751,  6759,  6767,  6772,  6774,  6780,  6784,  6788,
    6792,  6796,  6800,  6804,  6808,  6816,  6821,  6827,  6831,  6836,
    6842,  6846,  6850,  6855,  6861,  6866,  6872,  6880,  6884,  6892,
    6896,  6904,  6908,  6912,  6916,  6920,  6925,  6929,  6933,  6941,
    6946,  6952,  6956,  6964,  6968,  6973,  6979,  6987,  6995,  6999,
    7007,  7011,  7019,  7024,  7030,  7035,  7041,  7045,  7053,  7058,
    7064,  7068,  7076,  7080,  7088,  7093,  7099,  7103,  7111,  7116,
    7122,  7126,  7134,  7138,  7142,  7146,  7150,  7154,  7158,  7162,
    7168,  7172,  7176,  7184,  7188,  7192,  7196,  7200,  7204,  7212,
    7216,  7220,  7224,  7232,  7236,  7240,  7244,  7252,  7257,  7263,
    7267,  7275,  7279,  7283,  7287,  7295,  7299,  7307,  7311,  7315,
    7323,  7331,  7336,  7342,  7346,  7350,  7355,  7361,  7365,  7373,
    7381,  7383,  7385,  7389,  7393,  7397,  7405,  7415,  7426,  7435,
    7439,  7443,  7447,  7451,  7455,  7459,  7467,  7471,  7475,  7479,
    7487,  7491,  7499,  7504,  7510,  7514,  7518,  7522,  7526,  7530,
    7534,  7538,  7542,  7546,  7550,  7558,  7563,  7569,  7573,  7581,
    7585,  7593,  7601,  7609,  7613,  7621,  7625,  7633,  7641,  7649,
    7653,  7657,  7661,  7665,  7669,  7677,  7682,  7688,  7693,  7699,
    7703,  7707,  7711,  7719,  7727,  7731,  7736,  7742,  7746,  7750,
    7754,  7758,  7762,  7766,  7770,  7774,  7778,  7782,  7786,  7790,
    7795,  7801,  7805,  7813,  7817,  7821,  7825,  7829,  7833,  7837,
    7841,  7845,  7849,  7853,  7857,  7861,  7865,  7869,  7873,  7877,
    7881,  7885,  7889,  7893,  7897,  7901,  7905,  7909,  7913,  7917,
    7921,  7925,  7929,  7933,  7937,  7941,  7945,  7949,  7953,  7957,
    7961,  7965,  7969,  7973,  7977,  7981,  7985,  7989,  7993,  7997,
    8001,  8005,  8009,  8013,  8017,  8021,  8025,  8029,  8033,  8038,
    8042,  8050,  8054,  8058,  8062,  8066,  8070,  8074,  8078,  8082,
    8086,  8090,  8094,  8098,  8102,  8106,  8110,  8114,  8118,  8122,
    8126,  8130,  8134,  8142,  8146,  8150,  8154,  8158,  8162,  8166,
    8170,  8174,  8178,  8182,  8190,  8194,  8198,  8202,  8206,  8210,
    8214,  8218,  8222,  8226,  8230,  8234,  8238,  8242,  8246,  8250,
    8254,  8258,  8262,  8266,  8270,  8274,  8278,  8282,  8286,  8290,
    8294,  8298,  8302,  8306,  8310,  8314,  8318,  8322,  8326,  8330,
    8334,  8338,  8342,  8346,  8350,  8354,  8358,  8362,  8366,  8370,
    8374,  8382,  8386,  8394,  8398,  8402,  8407,  8413,  8421,  8425,
    8433,  8437,  8445,  8449,  8457,  8461,  8466,  8472,  8477,  8483,
    8487,  8495,  8503,  8507,  8512,  8518,  8526,  8530,  8537,  8542,
    8548,  8552,  8557,  8563,  8568,  8577,  8581,  8585,  8593,  8597,
    8601,  8609,  8613,  8617,  8625,  8629,  8637,  8641,  8645,  8649,
    8653,  8657,  8661,  8665,  8669,  8677,  8681,  8689,  8693,  8701,
    8705,  8709,  8713,  8717,  8721,  8729,  8733,  8741,  8745,  8753,
    8757,  8761,  8769,  8773,  8781,  8786,  8792,  8796,  8800,  8804,
    8808,  8812,  8816,  8820,  8828,  8832,  8840,  8848,  8853,  8859,
    8863,  8867,  8871,  8875,  8880,  8886,  8894,  8902,  8906,  8910,
    8918,  8922,  8930,  8938,  8942,  8950,  8958,  8963,  8969,  8974,
    8980,  8984,  8992,  8996,  9000,  9004,  9012,  9016,  9025,  9027,
    9035,  9040,  9046,  9050,  9058,  9062,  9070,  9078,  9082,  9090,
    9094,  9098,  9102,  9110,  9114,  9122,  9126,  9134,  9138,  9146,
    9150,  9158,  9166,  9174,  9182,  9190,  9198,  9206,  9210,  9218,
    9222,  9226,  9230,  9234,  9238,  9242,  9246,  9250,  9254,  9258,
    9262,  9266,  9270,  9271,  9276,  9282,  9290,  9294,  9295,  9299,
    9307,  9311,  9315,  9319,  9323,  9327,  9331,  9335,  9339,  9343,
    9347,  9351,  9355,  9359,  9363,  9367,  9371,  9375,  9379,  9383,
    9387,  9391,  9395,  9399,  9403,  9407,  9411,  9415,  9419,  9423,
    9427,  9431,  9435,  9439,  9443,  9447,  9451,  9455,  9459,  9463,
    9467,  9471,  9475,  9479,  9483,  9487,  9491,  9495,  9499,  9503,
    9507,  9511,  9515,  9519,  9523,  9527,  9531,  9535,  9539,  9543,
    9547,  9551,  9555,  9559,  9563,  9567,  9571,  9575,  9579,  9583,
    9587,  9591,  9595,  9599,  9603,  9607,  9611,  9615,  9619,  9623,
    9627,  9631,  9635,  9639,  9643,  9647,  9651,  9655,  9659,  9663,
    9667,  9671,  9675,  9679,  9683,  9687,  9691,  9695,  9699,  9703,
    9707,  9711,  9715,  9719,  9723,  9727,  9731,  9735,  9739,  9743,
    9747,  9751,  9755,  9759,  9763,  9767,  9771,  9775,  9779,  9783,
    9787,  9791,  9795,  9799,  9803,  9807,  9811,  9815,  9819,  9823,
    9827,  9831,  9835,  9839,  9843,  9847,  9851,  9855,  9859,  9863,
    9867,  9871,  9875,  9879,  9883,  9887,  9891,  9895,  9899,  9903,
    9907,  9911,  9915,  9919,  9923,  9927,  9931,  9935,  9939,  9943,
    9947,  9951,  9955,  9959,  9963,  9967,  9971,  9975,  9979,  9983,
    9987,  9991,  9995,  9999, 10003, 10007, 10011, 10015, 10019, 10023,
   10027, 10031, 10035, 10039, 10043, 10047, 10051, 10055, 10059, 10063,
   10067, 10071, 10075, 10079, 10083, 10087, 10091, 10095, 10099, 10103,
   10107, 10111, 10115, 10119, 10123, 10127, 10131, 10135, 10139, 10143,
   10147, 10151, 10155, 10159, 10163, 10167, 10171, 10175, 10179, 10183,
   10187, 10191, 10195, 10199, 10203, 10207, 10211, 10215, 10219, 10223,
   10227, 10231, 10235, 10239, 10243, 10247, 10251, 10259, 10263, 10267,
   10271, 10275, 10279, 10283, 10287, 10291, 10295, 10299, 10303, 10307,
   10311, 10315, 10319, 10323, 10327, 10331, 10335, 10339, 10343, 10347,
   10351, 10355, 10359, 10363, 10367, 10371, 10375, 10379, 10383, 10387,
   10391, 10395, 10399, 10403, 10407, 10411, 10415, 10419, 10423, 10431,
   10435, 10439, 10443, 10447, 10451, 10455, 10459, 10463, 10467, 10471,
   10475, 10479, 10483, 10487, 10491, 10495, 10499, 10503, 10507, 10511,
   10515, 10523, 10527, 10531, 10535, 10539, 10543, 10547, 10551, 10555,
   10559, 10563, 10567, 10571, 10575, 10579, 10583, 10587, 10591, 10595,
   10599, 10603, 10607, 10611, 10615, 10619, 10623, 10627, 10631, 10635,
   10639, 10643, 10647, 10651, 10655, 10659, 10663, 10667, 10671, 10675,
   10679, 10683, 10687, 10691, 10695, 10699, 10703, 10707, 10711, 10715,
   10719, 10723, 10727, 10731, 10735, 10739, 10743, 10747, 10751, 10755,
   10759, 10763, 10767, 10771, 10775, 10779, 10783, 10787, 10791, 10795,
   10799, 10803, 10807, 10811, 10815, 10819, 10823, 10827, 10835, 10842,
   10855, 10856, 10859, 10860, 10861, 10867, 10868, 10869, 10870, 10871,
   10874, 10874, 10884, 10883, 10893, 10909, 10911, 10914, 10916, 10920,
   10932, 10948, 10952, 10963, 10964, 10967, 10979, 10988, 10989, 10992,
   10993, 10994, 10997, 10998, 11001, 11002, 11005, 11006, 11009, 11011,
   11013, 11015, 11019, 11026, 11033, 11049, 11082, 11092, 11095, 11097,
   11110, 11111, 11113, 11115, 11119, 11132, 11139, 11176, 11185, 11187,
   11188, 11191, 11193, 11194, 11197, 11198, 11199, 11200, 11201, 11208,
   11207, 11217, 11219, 11221, 11222, 11223, 11226, 11227, 11228, 11229,
   11230, 11233, 11234, 11238, 11237, 11254, 11252, 11267, 11266, 11279,
   11285, 11286, 11289, 11291, 11292, 11295, 11296, 11297, 11298, 11301,
   11302, 11305, 11313, 11330, 11338, 11361, 11459, 11493, 11495, 11497,
   11501, 11505, 11504, 11555, 11557, 11556, 11571, 11577, 11584, 11589,
   11592, 11593, 11596, 11597, 11598, 11599, 11600, 11601, 11602, 11610,
   11618, 11621, 11622, 11623, 11624, 11625, 11626, 11634, 11642, 11643,
   11644, 11647, 11648, 11651, 11653, 11657, 11743, 11744, 11751, 11752,
   11753, 11759, 11768, 11771, 11772, 11773, 11774, 11777, 11778, 11779,
   11782, 11784, 11792, 11793, 11799, 11801, 11802, 11805, 11806, 11809,
   11816, 11823, 11823, 11825, 11825, 11827, 11834, 11835, 11838, 11839,
   11840, 11841, 11842, 11843, 11844, 11845, 11846, 11852, 11859, 11866,
   11875, 11876, 11888, 11899, 11910, 11914, 11915, 11918, 11923, 11927,
   11928, 11931, 11937, 11945, 11948, 11955, 11959, 11960, 11963, 11966,
   11970, 11971, 11974, 11980, 11988, 11989, 11998, 12007, 12019, 12020,
   12021, 12022, 12023, 12024, 12025, 12026, 12027, 12028, 12029, 12030,
   12031, 12032, 12033, 12040, 12041, 12044, 12045, 12052, 12053, 12054,
   12061, 12060, 12077, 12078, 12085, 12084, 12153, 12159, 12165, 12173,
   12179, 12185, 12191, 12197, 12203, 12209, 12215, 12221, 12232, 12233,
   12236, 12237, 12238, 12239, 12240, 12241, 12242, 12243, 12244, 12245,
   12246, 12247, 12248, 12249, 12250, 12251, 12252, 12253, 12254, 12255,
   12256, 12257, 12258, 12259, 12262, 12263, 12264, 12265, 12266, 12267,
   12271, 12272, 12273, 12274, 12275, 12276, 12277, 12280, 12283, 12284,
   12285, 12286, 12287, 12288, 12289, 12290, 12303, 12304, 12305, 12306,
   12307, 12308, 12309, 12314, 12315, 12316, 12317, 12318, 12319, 12325,
   12326, 12327, 12328, 12329, 12330, 12331, 12332, 12333, 12334, 12335,
   12338, 12339, 12340, 12341, 12342, 12345, 12346, 12347, 12348, 12351,
   12352, 12353, 12354, 12355, 12356, 12357, 12374, 12375, 12376, 12379,
   12380, 12381, 12382, 12383, 12384, 12388, 12388, 12391, 12397, 12398,
   12401, 12403, 12408, 12418, 12425, 12426, 12427, 12430, 12463, 12465,
   12467, 12470, 12480, 12490, 12500, 12501, 12504, 12506, 12507, 12508,
   12511, 12513, 12521, 12522, 12523, 12527, 12528, 12532, 12533, 12536,
   12537, 12540, 12541, 12542, 12543, 12544, 12547, 12548, 12549, 12550,
   12551, 12552, 12553, 12554, 12555, 12556, 12557, 12558, 12559, 12560,
   12561, 12562, 12563, 12564, 12565, 12566, 12567, 12568, 12569, 12570,
   12571, 12572, 12573, 12574, 12575, 12576, 12577, 12578, 12579, 12580,
   12581, 12582, 12583, 12584, 12585, 12586, 12587, 12588, 12589, 12590,
   12591, 12592, 12593, 12594, 12595, 12596, 12597, 12598, 12599, 12600,
   12601, 12602, 12605, 12606, 12607, 12608, 12611, 12612, 12613, 12614,
   12615, 12616, 12617, 12618, 12619, 12622, 12623, 12624, 12625, 12626,
   12629, 12630
};
#endif

#if YYDEBUG || YYERROR_VERBOSE
/* YYTNME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals. */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "SQL_ALLOCATE", "SQL_AUTOCOMMIT", 
  "SQL_BOOL", "SQL_BREAK", "SQL_CALL", "SQL_CARDINALITY", "SQL_CONNECT", 
  "SQL_COUNT", "SQL_DATETIME_INTERVAL_CODE", 
  "SQL_DATETIME_INTERVAL_PRECISION", "SQL_DESCRIBE", "SQL_DESCRIPTOR", 
  "SQL_DISCONNECT", "SQL_FOUND", "SQL_FREE", "SQL_GET", "SQL_GO", 
  "SQL_GOTO", "SQL_IDENTIFIED", "SQL_INDICATOR", "SQL_KEY_MEMBER", 
  "SQL_LENGTH", "SQL_LONG", "SQL_NULLABLE", "SQL_OCTET_LENGTH", 
  "SQL_OPEN", "SQL_OUTPUT", "SQL_REFERENCE", "SQL_RETURNED_LENGTH", 
  "SQL_RETURNED_OCTET_LENGTH", "SQL_SCALE", "SQL_SECTION", "SQL_SHORT", 
  "SQL_SIGNED", "SQL_SQL", "SQL_SQLERROR", "SQL_SQLPRINT", 
  "SQL_SQLWARNING", "SQL_START", "SQL_STOP", "SQL_STRUCT", "SQL_UNSIGNED", 
  "SQL_VAR", "SQL_WHENEVER", "S_ADD", "S_AND", "S_ANYTHING", "S_AUTO", 
  "S_CONST", "S_DEC", "S_DIV", "S_DOTPOINT", "S_EQUAL", "S_EXTERN", 
  "S_INC", "S_LSHIFT", "S_MEMPOINT", "S_MEMBER", "S_MOD", "S_MUL", 
  "S_NEQUAL", "S_OR", "S_REGISTER", "S_RSHIFT", "S_STATIC", "S_SUB", 
  "S_VOLATILE", "S_TYPEDEF", "TYPECAST", "CSTRING", "CVARIABLE", 
  "CPP_LINE", "IP", "DOLCONST", "ECONST", "NCONST", "UCONST", "UIDENT", 
  "ABORT_P", "ABSOLUTE_P", "ACCESS", "ACTION", "ADD_P", "ADMIN", "AFTER", 
  "AGGREGATE", "ALL", "ALSO", "ALTER", "ALWAYS", "ANALYSE", "ANALYZE", 
  "AND", "ANY", "ARRAY", "AS", "ASC", "ASSERTION", "ASSIGNMENT", 
  "ASYMMETRIC", "AT", "AUTHORIZATION", "BACKWARD", "BEFORE", "BEGIN_P", 
  "BETWEEN", "BIGINT", "BINARY", "BIT", "BOOLEAN_P", "BOTH", "BY", 
  "CACHE", "CALLED", "CASCADE", "CASCADED", "CASE", "CAST", "CATALOG_P", 
  "CHAIN", "CHAR_P", "CHARACTER", "CHARACTERISTICS", "CHECK", 
  "CHECKPOINT", "CLASS", "CLOSE", "CLUSTER", "COALESCE", "COLLATE", 
  "COLUMN", "COMMENT", "COMMIT", "COMMITTED", "CONCURRENTLY", 
  "CONFIGURATION", "CONNECTION", "CONSTRAINT", "CONSTRAINTS", "CONTENT_P", 
  "CONTINUE_P", "CONVERSION_P", "COPY", "COST", "CREATE", "CREATEDB", 
  "CREATEROLE", "CREATEUSER", "CROSS", "CSV", "CURRENT_P", 
  "CURRENT_CATALOG", "CURRENT_DATE", "CURRENT_ROLE", "CURRENT_SCHEMA", 
  "CURRENT_TIME", "CURRENT_TIMESTAMP", "CURRENT_USER", "CURSOR", "CYCLE", 
  "DATA_P", "DATABASE", "DAY_P", "DEALLOCATE", "DEC", "DECIMAL_P", 
  "DECLARE", "DEFAULT", "DEFAULTS", "DEFERRABLE", "DEFERRED", "DEFINER", 
  "DELETE_P", "DELIMITER", "DELIMITERS", "DESC", "DICTIONARY", 
  "DISABLE_P", "DISCARD", "DISTINCT", "DO", "DOCUMENT_P", "DOMAIN_P", 
  "DOUBLE_P", "DROP", "EACH", "ELSE", "ENABLE_P", "ENCODING", "ENCRYPTED", 
  "END_P", "ENUM_P", "ESCAPE", "EXCEPT", "EXCLUDING", "EXCLUSIVE", 
  "EXECUTE", "EXISTS", "EXPLAIN", "EXTERNAL", "EXTRACT", "FALSE_P", 
  "FAMILY", "FETCH", "FIRST_P", "FLOAT_P", "FOLLOWING", "FOR", "FORCE", 
  "FOREIGN", "FORWARD", "FREEZE", "FROM", "FULL", "FUNCTION", "GLOBAL", 
  "GRANT", "GRANTED", "GREATEST", "GROUP_P", "HANDLER", "HAVING", 
  "HEADER_P", "HOLD", "HOUR_P", "IDENTITY_P", "IF_P", "ILIKE", 
  "IMMEDIATE", "IMMUTABLE", "IMPLICIT_P", "IN_P", "INCLUDING", 
  "INCREMENT", "INDEX", "INDEXES", "INHERIT", "INHERITS", "INITIALLY", 
  "INNER_P", "INOUT", "INPUT_P", "INSENSITIVE", "INSERT", "INSTEAD", 
  "INT_P", "INTEGER", "INTERSECT", "INTERVAL", "INTO", "INVOKER", "IS", 
  "ISNULL", "ISOLATION", "JOIN", "KEY", "LANCOMPILER", "LANGUAGE", 
  "LARGE_P", "LAST_P", "LC_COLLATE_P", "LC_CTYPE_P", "LEADING", "LEAST", 
  "LEFT", "LEVEL", "LIKE", "LIMIT", "LISTEN", "LOAD", "LOCAL", 
  "LOCALTIME", "LOCALTIMESTAMP", "LOCATION", "LOCK_P", "LOGIN_P", 
  "MAPPING", "MATCH", "MAXVALUE", "MINUTE_P", "MINVALUE", "MODE", 
  "MONTH_P", "MOVE", "NAME_P", "NAMES", "NATIONAL", "NATURAL", "NCHAR", 
  "NEW", "NEXT", "NO", "NOCREATEDB", "NOCREATEROLE", "NOCREATEUSER", 
  "NOINHERIT", "NOLOGIN_P", "NONE", "NOSUPERUSER", "NOT", "NOTHING", 
  "NOTIFY", "NOTNULL", "NOWAIT", "NULL_P", "NULLIF", "NULLS_P", "NUMERIC", 
  "OBJECT_P", "OF", "OFF", "OFFSET", "OIDS", "OLD", "ON", "ONLY", 
  "OPERATOR", "OPTION", "OPTIONS", "OR", "ORDER", "OUT_P", "OUTER_P", 
  "OVER", "OVERLAPS", "OVERLAY", "OWNED", "OWNER", "PARSER", "PARTIAL", 
  "PARTITION", "PASSWORD", "PLACING", "PLANS", "POSITION", "PRECEDING", 
  "PRECISION", "PRESERVE", "PREPARE", "PREPARED", "PRIMARY", "PRIOR", 
  "PRIVILEGES", "PROCEDURAL", "PROCEDURE", "QUOTE", "RANGE", "READ", 
  "REAL", "REASSIGN", "RECHECK", "RECURSIVE", "REFERENCES", "REINDEX", 
  "RELATIVE_P", "RELEASE", "RENAME", "REPEATABLE", "REPLACE", "REPLICA", 
  "RESET", "RESTART", "RESTRICT", "RETURNING", "RETURNS", "REVOKE", 
  "RIGHT", "ROLE", "ROLLBACK", "ROW", "ROWS", "RULE", "SAVEPOINT", 
  "SCHEMA", "SCROLL", "SEARCH", "SECOND_P", "SECURITY", "SELECT", 
  "SEQUENCE", "SERIALIZABLE", "SERVER", "SESSION", "SESSION_USER", "SET", 
  "SETOF", "SHARE", "SHOW", "SIMILAR", "SIMPLE", "SMALLINT", "SOME", 
  "STABLE", "STANDALONE_P", "START", "STATEMENT", "STATISTICS", "STDIN", 
  "STDOUT", "STORAGE", "STRICT_P", "STRIP_P", "SUBSTRING", "SUPERUSER_P", 
  "SYMMETRIC", "SYSID", "SYSTEM_P", "TABLE", "TABLESPACE", "TEMP", 
  "TEMPLATE", "TEMPORARY", "TEXT_P", "THEN", "TIME", "TIMESTAMP", "TO", 
  "TRAILING", "TRANSACTION", "TREAT", "TRIGGER", "TRIM", "TRUE_P", 
  "TRUNCATE", "TRUSTED", "TYPE_P", "UNBOUNDED", "UNCOMMITTED", 
  "UNENCRYPTED", "UNION", "UNIQUE", "UNKNOWN", "UNLISTEN", "UNTIL", 
  "UPDATE", "USER", "USING", "VACUUM", "VALID", "VALIDATOR", "VALUE_P", 
  "VALUES", "VARCHAR", "VARIADIC", "VARYING", "VERBOSE", "VERSION_P", 
  "VIEW", "VOLATILE", "WHEN", "WHERE", "WHITESPACE_P", "WINDOW", "WITH", 
  "WITHOUT", "WORK", "WRAPPER", "WRITE", "XML_P", "XMLATTRIBUTES", 
  "XMLCONCAT", "XMLELEMENT", "XMLFOREST", "XMLPARSE", "XMLPI", "XMLROOT", 
  "XMLSERIALIZE", "YEAR_P", "YES_P", "ZONE", "NULLS_FIRST", "NULLS_LAST", 
  "WITH_TIME", "IDENT", "FCONST", "SCONST", "BCONST", "XCONST", "Op", 
  "ICONST", "PARAM", "'='", "'<'", "'>'", "POSTFIXOP", "'+'", "'-'", 
  "'*'", "'/'", "'%'", "'^'", "UMINUS", "'['", "']'", "'('", "')'", "'.'", 
  "','", "';'", "':'", "'{'", "'}'", "$accept", "prog", "stmt", 
  "CreateRoleStmt", "opt_with", "OptRoleList", "OptRoleElem", 
  "CreateUserStmt", "AlterRoleStmt", "AlterRoleSetStmt", "AlterUserStmt", 
  "AlterUserSetStmt", "DropRoleStmt", "DropUserStmt", "CreateGroupStmt", 
  "AlterGroupStmt", "add_drop", "DropGroupStmt", "CreateSchemaStmt", 
  "OptSchemaName", "OptSchemaEltList", "schema_stmt", "VariableSetStmt", 
  "set_rest", "var_name", "var_list", "var_value", "iso_level", 
  "opt_boolean", "zone_value", "opt_encoding", "ColId_or_Sconst", 
  "VariableResetStmt", "SetResetClause", "VariableShowStmt", 
  "ConstraintsSetStmt", "constraints_set_list", "constraints_set_mode", 
  "CheckPointStmt", "DiscardStmt", "AlterTableStmt", "alter_table_cmds", 
  "alter_table_cmd", "alter_column_default", "opt_drop_behavior", 
  "alter_using", "reloptions", "opt_reloptions", "reloption_list", 
  "reloption_elem", "ClosePortalStmt", "CopyStmt", "copy_from", 
  "copy_file_name", "copy_opt_list", "copy_opt_item", "opt_binary", 
  "opt_oids", "copy_delimiter", "opt_using", "CreateStmt", "OptTemp", 
  "OptTableElementList", "TableElementList", "TableElement", "columnDef", 
  "ColQualList", "ColConstraint", "ColConstraintElem", "ConstraintAttr", 
  "TableLikeClause", "TableLikeOptionList", "TableLikeOption", 
  "TableConstraint", "ConstraintElem", "opt_column_list", "columnList", 
  "columnElem", "key_match", "key_actions", "key_update", "key_delete", 
  "key_action", "OptInherit", "OptWith", "OnCommitOption", 
  "OptTableSpace", "OptConsTableSpace", "create_as_target", "OptCreateAs", 
  "CreateAsList", "CreateAsElement", "opt_with_data", "CreateSeqStmt", 
  "AlterSeqStmt", "OptSeqOptList", "SeqOptList", "SeqOptElem", "opt_by", 
  "NumericOnly", "CreatePLangStmt", "opt_trusted", "handler_name", 
  "validator_clause", "opt_validator", "opt_lancompiler", "DropPLangStmt", 
  "opt_procedural", "CreateTableSpaceStmt", "OptTableSpaceOwner", 
  "DropTableSpaceStmt", "CreateFdwStmt", "DropFdwStmt", "AlterFdwStmt", 
  "create_generic_options", "generic_option_list", 
  "alter_generic_options", "alter_generic_option_list", 
  "alter_generic_option_elem", "generic_option_elem", 
  "generic_option_name", "generic_option_arg", "CreateForeignServerStmt", 
  "opt_type", "foreign_server_version", "opt_foreign_server_version", 
  "DropForeignServerStmt", "AlterForeignServerStmt", 
  "CreateUserMappingStmt", "auth_ident", "DropUserMappingStmt", 
  "AlterUserMappingStmt", "CreateTrigStmt", "TriggerActionTime", 
  "TriggerEvents", "TriggerOneEvent", "TriggerForSpec", "TriggerForOpt", 
  "TriggerForType", "TriggerFuncArgs", "TriggerFuncArg", 
  "OptConstrFromTable", "ConstraintAttributeSpec", 
  "ConstraintDeferrabilitySpec", "ConstraintTimeSpec", "DropTrigStmt", 
  "CreateAssertStmt", "DropAssertStmt", "DefineStmt", "definition", 
  "def_list", "def_elem", "def_arg", "aggr_args", "old_aggr_definition", 
  "old_aggr_list", "old_aggr_elem", "enum_val_list", "CreateOpClassStmt", 
  "opclass_item_list", "opclass_item", "opt_default", "opt_opfamily", 
  "opt_recheck", "CreateOpFamilyStmt", "AlterOpFamilyStmt", 
  "opclass_drop_list", "opclass_drop", "DropOpClassStmt", 
  "DropOpFamilyStmt", "DropOwnedStmt", "ReassignOwnedStmt", "DropStmt", 
  "drop_type", "any_name_list", "any_name", "attrs", "TruncateStmt", 
  "opt_restart_seqs", "CommentStmt", "comment_type", "comment_text", 
  "FetchStmt", "fetch_direction", "from_in", "GrantStmt", "RevokeStmt", 
  "privileges", "privilege_list", "privilege", "privilege_target", 
  "grantee_list", "grantee", "opt_grant_grant_option", 
  "function_with_argtypes_list", "function_with_argtypes", 
  "GrantRoleStmt", "RevokeRoleStmt", "opt_grant_admin_option", 
  "opt_granted_by", "IndexStmt", "index_opt_unique", 
  "access_method_clause", "index_params", "index_elem", "opt_class", 
  "opt_asc_desc", "opt_nulls_order", "CreateFunctionStmt", 
  "opt_or_replace", "func_args", "func_args_list", 
  "func_args_with_defaults", "func_args_with_defaults_list", "func_arg", 
  "arg_class", "param_name", "func_return", "func_type", 
  "func_arg_with_default", "createfunc_opt_list", "common_func_opt_item", 
  "createfunc_opt_item", "func_as", "opt_definition", "table_func_column", 
  "table_func_column_list", "AlterFunctionStmt", "alterfunc_opt_list", 
  "opt_restrict", "RemoveFuncStmt", "RemoveAggrStmt", "RemoveOperStmt", 
  "oper_argtypes", "any_operator", "CreateCastStmt", "cast_context", 
  "DropCastStmt", "opt_if_exists", "ReindexStmt", "reindex_type", 
  "opt_force", "RenameStmt", "opt_column", "opt_set_data", 
  "AlterObjectSchemaStmt", "AlterOwnerStmt", "RuleActionList", 
  "RuleActionMulti", "RuleActionStmt", "RuleActionStmtOrEmpty", "event", 
  "opt_instead", "DropRuleStmt", "NotifyStmt", "ListenStmt", 
  "UnlistenStmt", "TransactionStmt", "opt_transaction", 
  "transaction_mode_item", "transaction_mode_list", 
  "transaction_mode_list_or_empty", "ViewStmt", "opt_check_option", 
  "LoadStmt", "CreatedbStmt", "createdb_opt_list", "createdb_opt_item", 
  "opt_equal", "AlterDatabaseStmt", "AlterDatabaseSetStmt", 
  "alterdb_opt_list", "alterdb_opt_item", "DropdbStmt", 
  "CreateDomainStmt", "AlterDomainStmt", "opt_as", 
  "AlterTSDictionaryStmt", "AlterTSConfigurationStmt", 
  "CreateConversionStmt", "ClusterStmt", "cluster_index_specification", 
  "VacuumStmt", "AnalyzeStmt", "analyze_keyword", "opt_verbose", 
  "opt_full", "opt_freeze", "opt_name_list", "ExplainStmt", 
  "ExplainableStmt", "opt_analyze", "PrepareStmt", "prep_type_clause", 
  "PreparableStmt", "ExecuteStmt", "execute_param_clause", "InsertStmt", 
  "insert_rest", "insert_column_list", "insert_column_item", 
  "returning_clause", "DeleteStmt", "using_clause", "LockStmt", 
  "opt_lock", "lock_type", "opt_nowait", "UpdateStmt", "set_clause_list", 
  "set_clause", "single_set_clause", "multiple_set_clause", "set_target", 
  "set_target_list", "DeclareCursorStmt", "cursor_options", "opt_hold", 
  "SelectStmt", "select_with_parens", "select_no_parens", "select_clause", 
  "simple_select", "with_clause", "cte_list", "common_table_expr", 
  "into_clause", "OptTempTableName", "opt_table", "opt_all", 
  "opt_distinct", "opt_sort_clause", "sort_clause", "sortby_list", 
  "sortby", "select_limit", "opt_select_limit", "select_limit_value", 
  "opt_select_fetch_first_value", "select_offset_value", 
  "select_offset_value2", "row_or_rows", "first_or_next", "group_clause", 
  "having_clause", "for_locking_clause", "opt_for_locking_clause", 
  "for_locking_items", "for_locking_item", "locked_rels_list", 
  "values_clause", "from_clause", "from_list", "table_ref", 
  "joined_table", "alias_clause", "join_type", "join_outer", "join_qual", 
  "relation_expr", "relation_expr_list", "relation_expr_opt_alias", 
  "func_table", "where_clause", "where_or_current_clause", 
  "TableFuncElementList", "TableFuncElement", "Typename", 
  "opt_array_bounds", "SimpleTypename", "ConstTypename", "GenericType", 
  "opt_type_modifiers", "Numeric", "opt_float", "Bit", "ConstBit", 
  "BitWithLength", "BitWithoutLength", "Character", "ConstCharacter", 
  "CharacterWithLength", "CharacterWithoutLength", "character", 
  "opt_varying", "opt_charset", "ConstDatetime", "ConstInterval", 
  "opt_timezone", "opt_interval", "interval_second", "a_expr", "b_expr", 
  "c_expr", "func_expr", "xml_root_version", "opt_xml_root_standalone", 
  "xml_attributes", "xml_attribute_list", "xml_attribute_el", 
  "document_or_content", "xml_whitespace_option", "window_clause", 
  "window_definition_list", "window_definition", "over_clause", 
  "window_specification", "opt_existing_window_name", 
  "opt_partition_clause", "opt_frame_clause", "frame_extent", 
  "frame_bound", "row", "sub_type", "all_Op", "MathOp", "qual_Op", 
  "qual_all_Op", "subquery_Op", "expr_list", "type_list", "array_expr", 
  "array_expr_list", "extract_list", "extract_arg", "overlay_list", 
  "overlay_placing", "position_list", "substr_list", "substr_from", 
  "substr_for", "trim_list", "in_expr", "case_expr", "when_clause_list", 
  "when_clause", "case_default", "case_arg", "columnref", 
  "indirection_el", "indirection", "opt_indirection", "opt_asymmetric", 
  "ctext_expr", "ctext_expr_list", "ctext_row", "target_list", 
  "target_el", "relation_name", "qualified_name_list", "qualified_name", 
  "name_list", "name", "database_name", "access_method", "attr_name", 
  "index_name", "file_name", "func_name", "AexprConst", "Iconst", 
  "RoleId", "SignedIconst", "unreserved_keyword", "col_name_keyword", 
  "type_func_name_keyword", "reserved_keyword", "SpecialRuleRelation", 
  "statements", "statement", "CreateAsStmt", "@1", "RuleStmt", "@2", "at", 
  "ECPGConnect", "connection_target", "opt_database_name", "db_prefix", 
  "server", "opt_server", "server_name", "opt_port", 
  "opt_connection_name", "opt_user", "ora_user", "user_name", 
  "char_variable", "opt_options", "connect_options", "opt_opt_value", 
  "prepared_name", "ECPGCursorStmt", "ECPGExecuteImmediateStmt", 
  "ECPGVarDeclaration", "single_vt_declaration", "precision", "opt_scale", 
  "ecpg_interval", "ECPGDeclaration", "@3", "sql_startdeclare", 
  "sql_enddeclare", "var_type_declarations", "vt_declarations", 
  "variable_declarations", "type_declaration", "@4", "var_declaration", 
  "@5", "@6", "opt_bit_field", "storage_declaration", "storage_clause", 
  "storage_modifier", "var_type", "enum_type", "enum_definition", 
  "struct_union_type_with_symbol", "@7", "struct_union_type", "@8", 
  "s_struct_union_symbol", "s_struct_union", "simple_type", 
  "unsigned_type", "signed_type", "opt_signed", "variable_list", 
  "variable", "opt_initializer", "opt_pointer", "ECPGDeclare", 
  "ECPGDisconnect", "dis_name", "connection_object", "execstring", 
  "ECPGFree", "ECPGOpen", "opt_ecpg_using", "ecpg_using", 
  "using_descriptor", "into_descriptor", "opt_sql", "using_list", 
  "UsingValue", "UsingConst", "ECPGDescribe", "opt_output", 
  "ECPGAllocateDescr", "ECPGDeallocateDescr", "ECPGGetDescriptorHeader", 
  "ECPGGetDescHeaderItems", "ECPGGetDescHeaderItem", 
  "ECPGSetDescriptorHeader", "ECPGSetDescHeaderItems", 
  "ECPGSetDescHeaderItem", "IntConstVar", "desc_header_item", 
  "ECPGGetDescriptor", "ECPGGetDescItems", "ECPGGetDescItem", 
  "ECPGSetDescriptor", "ECPGSetDescItems", "ECPGSetDescItem", 
  "AllConstVar", "descriptor_item", "ECPGSetAutocommit", "on_off", 
  "ECPGSetConnection", "ECPGTypedef", "@9", "opt_reference", "ECPGVar", 
  "@10", "ECPGWhenever", "action", "ECPGKeywords", "ECPGKeywords_vanames", 
  "ECPGKeywords_rest", "ECPGTypeName", "symbol", "ECPGColId", "ColId", 
  "type_function_name", "ColLabel", "ECPGColLabel", "ECPGColLabelCommon", 
  "ECPGCKeywords", "all_unreserved_keyword", "ECPGunreserved_interval", 
  "into_list", "ecpgstart", "c_args", "coutputvariable", "civarind", 
  "civar", "indicator", "cvariable", "ecpg_param", "ecpg_bconst", 
  "ecpg_fconst", "ecpg_sconst", "ecpg_xconst", "ecpg_ident", 
  "quoted_ident_stringvar", "c_stuff_item", "c_stuff", "c_list", "c_term", 
  "c_thing", "c_anything", "DeallocateStmt", "Iresult", "execute_rest", 
  "ecpg_into", 0
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[YYLEX-NUM] -- Internal token number corresponding to
   token YYLEX-NUM.  */
static const unsigned short yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   497,   498,   499,   500,   501,   502,   503,   504,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,   522,   523,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   543,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   572,   573,   574,
     575,   576,   577,   578,   579,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,   598,   599,   600,   601,   602,   603,   604,
     605,   606,   607,   608,   609,   610,   611,   612,   613,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,   624,
     625,   626,   627,   628,   629,   630,   631,   632,   633,   634,
     635,   636,   637,   638,   639,   640,   641,   642,   643,   644,
     645,   646,   647,   648,   649,   650,   651,   652,   653,   654,
     655,   656,   657,   658,   659,   660,   661,   662,   663,   664,
     665,   666,   667,   668,   669,   670,   671,   672,   673,   674,
     675,   676,   677,   678,   679,   680,   681,   682,   683,   684,
     685,   686,   687,   688,   689,   690,   691,   692,   693,   694,
     695,   696,   697,   698,   699,   700,   701,   702,   703,   704,
     705,   706,   707,   708,   709,   710,   711,   712,   713,   714,
     715,   716,   717,   718,   719,   720,   721,   722,   723,   724,
     725,   726,   727,   728,   729,   730,   731,   732,   733,   734,
     735,   736,   737,   738,    61,    60,    62,   739,    43,    45,
      42,    47,    37,    94,   740,    91,    93,    40,    41,    46,
      44,    59,    58,   123,   125
};
# endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const unsigned short yyr1[] =
{
       0,   505,   506,   507,   507,   507,   507,   507,   507,   507,
     507,   507,   507,   507,   507,   507,   507,   507,   507,   507,
     507,   507,   507,   507,   507,   507,   507,   507,   507,   507,
     507,   507,   507,   507,   507,   507,   507,   507,   507,   507,
     507,   507,   507,   507,   507,   507,   507,   507,   507,   507,
     507,   507,   507,   507,   507,   507,   507,   507,   507,   507,
     507,   507,   507,   507,   507,   507,   507,   507,   507,   507,
     507,   507,   507,   507,   507,   507,   507,   507,   507,   507,
     507,   507,   507,   507,   507,   507,   507,   507,   507,   507,
     507,   507,   507,   507,   507,   507,   507,   507,   507,   507,
     507,   507,   507,   507,   507,   507,   507,   507,   507,   507,
     507,   507,   507,   507,   507,   507,   507,   507,   507,   507,
     507,   507,   507,   508,   509,   509,   510,   510,   511,   511,
     511,   511,   511,   511,   511,   511,   511,   511,   511,   511,
     511,   511,   511,   511,   511,   511,   511,   511,   511,   511,
     511,   511,   512,   513,   514,   515,   516,   517,   517,   518,
     518,   519,   520,   521,   521,   522,   522,   523,   523,   524,
     524,   525,   525,   526,   526,   526,   526,   526,   526,   527,
     527,   527,   528,   528,   528,   528,   528,   528,   528,   528,
     528,   528,   528,   528,   528,   528,   528,   529,   529,   530,
     530,   531,   531,   531,   532,   532,   532,   532,   533,   533,
     533,   533,   534,   534,   534,   534,   534,   534,   534,   535,
     535,   535,   536,   536,   537,   537,   537,   537,   537,   538,
     538,   539,   539,   539,   539,   539,   540,   541,   541,   542,
     542,   543,   544,   544,   544,   544,   545,   545,   545,   545,
     546,   546,   547,   547,   547,   547,   547,   547,   547,   547,
     547,   547,   547,   547,   547,   547,   547,   547,   547,   547,
     547,   547,   547,   547,   547,   547,   547,   547,   547,   547,
     547,   547,   547,   547,   548,   548,   549,   549,   549,   550,
     550,   551,   552,   552,   553,   553,   554,   554,   554,   554,
     555,   555,   556,   556,   557,   557,   558,   558,   558,   559,
     559,   560,   560,   560,   560,   560,   560,   560,   560,   560,
     560,   561,   561,   562,   562,   563,   563,   564,   564,   565,
     565,   566,   566,   566,   566,   566,   566,   566,   567,   567,
     568,   568,   569,   569,   569,   570,   571,   571,   572,   572,
     572,   573,   573,   573,   573,   573,   573,   573,   574,   574,
     574,   574,   575,   576,   576,   577,   577,   577,   577,   577,
     577,   578,   578,   579,   579,   579,   579,   580,   580,   581,
     581,   582,   583,   583,   583,   583,   584,   584,   584,   584,
     584,   585,   586,   587,   587,   587,   587,   587,   588,   588,
     589,   589,   589,   589,   590,   590,   590,   590,   591,   591,
     592,   592,   593,   594,   594,   595,   595,   596,   597,   597,
     597,   598,   599,   600,   600,   601,   601,   602,   602,   602,
     602,   602,   602,   602,   602,   602,   602,   602,   602,   603,
     603,   604,   604,   604,   605,   605,   606,   606,   607,   607,
     608,   608,   609,   609,   610,   610,   611,   611,   612,   612,
     613,   614,   614,   615,   615,   616,   617,   617,   618,   618,
     618,   619,   619,   620,   620,   621,   622,   622,   623,   623,
     623,   623,   624,   625,   626,   627,   628,   628,   629,   629,
     630,   630,   631,   631,   632,   632,   632,   633,   634,   634,
     634,   635,   635,   636,   637,   637,   638,   638,   639,   639,
     640,   640,   640,   640,   641,   641,   642,   642,   643,   643,
     644,   644,   644,   645,   645,   645,   645,   645,   645,   646,
     646,   647,   647,   647,   647,   647,   648,   648,   649,   649,
     650,   650,   651,   652,   653,   653,   653,   653,   653,   653,
     653,   653,   653,   653,   653,   654,   655,   655,   656,   656,
     657,   657,   657,   657,   657,   658,   658,   659,   660,   660,
     661,   662,   662,   663,   664,   664,   665,   665,   665,   665,
     665,   666,   666,   667,   667,   668,   668,   669,   670,   670,
     671,   671,   672,   672,   673,   673,   674,   674,   675,   676,
     677,   677,   678,   678,   678,   678,   678,   678,   678,   678,
     678,   678,   678,   678,   679,   679,   680,   680,   681,   681,
     682,   683,   683,   683,   684,   684,   684,   684,   684,   684,
     684,   684,   684,   684,   684,   684,   684,   684,   684,   684,
     684,   685,   685,   685,   685,   685,   685,   685,   685,   685,
     685,   685,   685,   686,   686,   687,   687,   687,   687,   687,
     687,   687,   687,   687,   687,   688,   688,   688,   688,   688,
     688,   688,   688,   688,   688,   688,   688,   688,   688,   689,
     689,   690,   691,   691,   692,   692,   692,   692,   692,   693,
     693,   694,   694,   694,   694,   695,   695,   695,   695,   695,
     695,   695,   695,   695,   695,   696,   696,   697,   697,   698,
     698,   699,   699,   700,   701,   702,   702,   703,   703,   704,
     704,   705,   705,   706,   706,   707,   707,   708,   708,   709,
     709,   709,   710,   710,   710,   711,   711,   711,   712,   712,
     712,   713,   713,   713,   714,   714,   715,   715,   716,   716,
     717,   717,   718,   718,   719,   719,   719,   719,   719,   720,
     720,   720,   720,   720,   721,   722,   723,   723,   723,   724,
     724,   724,   725,   725,   726,   726,   726,   726,   726,   726,
     726,   726,   726,   726,   726,   726,   726,   727,   727,   727,
     727,   728,   728,   729,   729,   730,   731,   731,   732,   733,
     733,   734,   734,   735,   735,   736,   736,   737,   737,   738,
     738,   738,   738,   739,   739,   740,   740,   740,   741,   741,
     741,   742,   743,   743,   744,   744,   744,   745,   745,   746,
     746,   747,   747,   747,   747,   747,   747,   747,   747,   747,
     747,   747,   747,   747,   747,   747,   747,   747,   747,   747,
     747,   747,   747,   747,   748,   748,   749,   749,   750,   750,
     750,   750,   750,   750,   750,   751,   751,   751,   751,   751,
     751,   751,   751,   751,   751,   751,   751,   751,   751,   751,
     751,   752,   752,   752,   753,   753,   754,   754,   754,   754,
     754,   755,   755,   756,   756,   756,   756,   757,   757,   757,
     758,   758,   759,   760,   761,   761,   762,   762,   762,   762,
     762,   762,   762,   762,   762,   762,   762,   762,   762,   762,
     763,   763,   763,   764,   764,   764,   765,   765,   765,   766,
     766,   767,   767,   768,   768,   768,   768,   769,   770,   771,
     771,   772,   772,   772,   772,   772,   772,   772,   772,   772,
     772,   772,   772,   772,   772,   772,   772,   773,   773,   774,
     774,   775,   776,   776,   777,   778,   778,   779,   780,   780,
     780,   780,   780,   781,   781,   782,   783,   783,   783,   783,
     783,   783,   784,   785,   785,   785,   786,   786,   787,   787,
     787,   788,   788,   789,   789,   790,   790,   791,   791,   792,
     792,   793,   793,   794,   795,   795,   795,   795,   795,   795,
     795,   796,   796,   797,   797,   798,   798,   799,   799,   799,
     799,   800,   800,   801,   801,   802,   803,   803,   803,   804,
     804,   805,   806,   806,   807,   808,   808,   809,   810,   810,
     811,   811,   811,   811,   811,   811,   811,   811,   812,   812,
     813,   814,   814,   815,   815,   816,   817,   818,   819,   819,
     820,   821,   821,   821,   821,   821,   822,   822,   822,   823,
     823,   824,   824,   825,   825,   825,   825,   825,   825,   825,
     825,   826,   826,   827,   827,   827,   827,   827,   827,   828,
     828,   829,   829,   830,   831,   831,   831,   832,   832,   832,
     832,   832,   832,   832,   832,   833,   833,   834,   834,   834,
     835,   835,   835,   835,   836,   836,   837,   838,   838,   839,
     839,   840,   840,   840,   840,   840,   840,   840,   840,   841,
     841,   842,   842,   843,   843,   843,   844,   845,   846,   846,
     847,   847,   848,   848,   849,   849,   850,   850,   851,   851,
     852,   852,   853,   853,   854,   854,   855,   855,   856,   856,
     857,   857,   858,   858,   858,   858,   858,   858,   858,   858,
     858,   858,   858,   859,   859,   859,   859,   859,   859,   860,
     860,   860,   860,   861,   861,   861,   861,   862,   862,   863,
     863,   864,   864,   864,   864,   865,   865,   866,   866,   866,
     867,   868,   868,   869,   869,   869,   869,   870,   870,   871,
     872,   872,   872,   872,   872,   872,   873,   873,   873,   874,
     874,   874,   874,   874,   874,   874,   875,   875,   875,   875,
     876,   876,   877,   877,   878,   878,   878,   878,   878,   878,
     878,   878,   878,   878,   878,   879,   879,   880,   880,   881,
     881,   882,   883,   884,   884,   885,   885,   886,   887,   888,
     888,   888,   888,   888,   888,   889,   889,   890,   890,   891,
     891,   891,   891,   892,   893,   893,   893,   894,   894,   894,
     894,   894,   894,   894,   894,   894,   894,   894,   894,   894,
     894,   895,   895,   896,   896,   896,   896,   896,   896,   896,
     896,   896,   896,   896,   896,   896,   896,   896,   896,   896,
     896,   896,   896,   896,   896,   896,   896,   896,   896,   896,
     896,   896,   896,   896,   896,   896,   896,   896,   896,   896,
     896,   896,   896,   896,   896,   896,   896,   896,   896,   896,
     896,   896,   896,   896,   896,   896,   896,   896,   896,   896,
     896,   897,   897,   897,   897,   897,   897,   897,   897,   897,
     897,   897,   897,   897,   897,   897,   897,   897,   897,   897,
     897,   897,   897,   898,   898,   898,   898,   898,   898,   898,
     898,   898,   898,   898,   899,   899,   899,   899,   899,   899,
     899,   899,   899,   899,   899,   899,   899,   899,   899,   899,
     899,   899,   899,   899,   899,   899,   899,   899,   899,   899,
     899,   899,   899,   899,   899,   899,   899,   899,   899,   899,
     899,   899,   899,   899,   899,   899,   899,   899,   899,   899,
     899,   900,   900,   901,   901,   901,   901,   902,   903,   903,
     904,   904,   905,   905,   906,   906,   906,   907,   907,   908,
     908,   909,   910,   910,   910,   911,   912,   912,   913,   913,
     914,   914,   914,   915,   915,   916,   916,   916,   917,   917,
     917,   918,   918,   918,   919,   919,   920,   920,   920,   920,
     920,   920,   920,   920,   920,   921,   921,   922,   922,   923,
     923,   923,   923,   923,   923,   924,   924,   925,   925,   926,
     926,   926,   927,   927,   928,   928,   929,   929,   929,   929,
     929,   929,   929,   929,   930,   930,   931,   932,   932,   933,
     933,   933,   933,   933,   933,   934,   935,   936,   936,   936,
     937,   937,   938,   939,   939,   940,   941,   941,   942,   942,
     943,   943,   944,   944,   944,   944,   945,   945,   946,   946,
     947,   947,   948,   948,   949,   949,   950,   951,   951,   952,
     952,   952,   952,   953,   953,   954,   954,   955,   955,   956,
     956,   957,   958,   959,   960,   961,   962,   963,   963,   964,
     964,   964,   964,   964,   964,   964,   964,   964,   964,   964,
     964,   964,   964,   964,   965,   966,   967,   967,   967,   967,
     968,   968,   968,   968,   968,   968,   968,   968,   968,   968,
     968,   968,   968,   968,   968,   968,   968,   968,   968,   968,
     968,   968,   968,   968,   968,   968,   968,   968,   968,   968,
     968,   968,   968,   968,   968,   968,   968,   968,   968,   968,
     968,   968,   968,   968,   968,   968,   968,   968,   968,   968,
     968,   968,   968,   968,   968,   968,   968,   968,   968,   968,
     968,   968,   968,   968,   968,   968,   968,   968,   968,   968,
     968,   968,   968,   968,   968,   968,   968,   968,   968,   968,
     968,   968,   968,   968,   968,   968,   968,   968,   968,   968,
     968,   968,   968,   968,   968,   968,   968,   968,   968,   968,
     968,   968,   968,   968,   968,   968,   968,   968,   968,   968,
     968,   968,   968,   968,   968,   968,   968,   968,   968,   968,
     968,   968,   968,   968,   968,   968,   968,   968,   968,   968,
     968,   968,   968,   968,   968,   968,   968,   968,   968,   968,
     968,   968,   968,   968,   968,   968,   968,   968,   968,   968,
     968,   968,   968,   968,   968,   968,   968,   968,   968,   968,
     968,   968,   968,   968,   968,   968,   968,   968,   968,   968,
     968,   968,   968,   968,   968,   968,   968,   968,   968,   968,
     968,   968,   968,   968,   968,   968,   968,   968,   968,   968,
     968,   968,   968,   968,   968,   968,   968,   968,   968,   968,
     968,   968,   968,   968,   968,   968,   968,   968,   968,   968,
     968,   968,   968,   968,   968,   968,   968,   968,   968,   968,
     968,   968,   968,   968,   968,   968,   968,   968,   968,   968,
     968,   968,   968,   968,   968,   968,   968,   969,   969,   969,
     969,   969,   969,   969,   969,   969,   969,   969,   969,   969,
     969,   969,   969,   969,   969,   969,   969,   969,   969,   969,
     969,   969,   969,   969,   969,   969,   969,   969,   969,   969,
     969,   969,   969,   969,   969,   969,   969,   969,   969,   970,
     970,   970,   970,   970,   970,   970,   970,   970,   970,   970,
     970,   970,   970,   970,   970,   970,   970,   970,   970,   970,
     970,   971,   971,   971,   971,   971,   971,   971,   971,   971,
     971,   971,   971,   971,   971,   971,   971,   971,   971,   971,
     971,   971,   971,   971,   971,   971,   971,   971,   971,   971,
     971,   971,   971,   971,   971,   971,   971,   971,   971,   971,
     971,   971,   971,   971,   971,   971,   971,   971,   971,   971,
     971,   971,   971,   971,   971,   971,   971,   971,   971,   971,
     971,   971,   971,   971,   971,   971,   971,   971,   971,   971,
     971,   971,   971,   971,   971,   971,   971,   971,   972,   972,
     973,   973,   974,   974,   974,   974,   974,   974,   974,   974,
     976,   975,   978,   977,   979,   980,   980,   980,   980,   981,
     981,   981,   981,   982,   982,   983,   984,   985,   985,   986,
     986,   986,   987,   987,   988,   988,   989,   989,   990,   990,
     990,   990,   991,   991,   991,   992,   993,   993,   994,   994,
     995,   995,   995,   995,   996,   996,   997,   998,   999,  1000,
    1000,  1001,  1002,  1002,  1003,  1003,  1003,  1003,  1003,  1005,
    1004,  1006,  1007,  1008,  1008,  1008,  1009,  1009,  1009,  1009,
    1009,  1010,  1010,  1012,  1011,  1014,  1013,  1015,  1013,  1013,
    1016,  1016,  1017,  1017,  1017,  1018,  1018,  1018,  1018,  1019,
    1019,  1020,  1020,  1020,  1020,  1020,  1020,  1021,  1021,  1021,
    1022,  1024,  1023,  1025,  1026,  1025,  1027,  1027,  1028,  1028,
    1029,  1029,  1030,  1030,  1030,  1030,  1030,  1030,  1030,  1030,
    1030,  1031,  1031,  1031,  1031,  1031,  1031,  1031,  1031,  1031,
    1031,  1032,  1032,  1033,  1033,  1034,  1035,  1035,  1036,  1036,
    1036,  1037,  1038,  1039,  1039,  1039,  1039,  1040,  1040,  1040,
    1041,  1041,  1042,  1042,  1043,  1044,  1044,  1045,  1045,  1046,
    1047,  1048,  1048,  1049,  1049,  1050,  1050,  1050,  1051,  1051,
    1051,  1051,  1051,  1051,  1051,  1051,  1051,  1052,  1052,  1052,
    1053,  1053,  1054,  1055,  1056,  1057,  1057,  1058,  1059,  1060,
    1060,  1061,  1062,  1062,  1063,  1064,  1065,  1065,  1066,  1067,
    1068,  1068,  1069,  1070,  1070,  1070,  1070,  1070,  1071,  1071,
    1071,  1071,  1071,  1071,  1071,  1071,  1071,  1071,  1071,  1071,
    1071,  1071,  1071,  1072,  1072,  1073,  1073,  1074,  1074,  1074,
    1076,  1075,  1077,  1077,  1079,  1078,  1080,  1080,  1080,  1081,
    1081,  1081,  1081,  1081,  1081,  1081,  1081,  1081,  1082,  1082,
    1083,  1083,  1083,  1083,  1083,  1083,  1083,  1083,  1083,  1083,
    1083,  1083,  1083,  1083,  1083,  1083,  1083,  1083,  1083,  1083,
    1083,  1083,  1083,  1083,  1084,  1084,  1084,  1084,  1084,  1084,
    1085,  1085,  1085,  1085,  1085,  1085,  1085,  1086,  1087,  1087,
    1087,  1087,  1087,  1087,  1087,  1087,  1088,  1088,  1088,  1088,
    1088,  1088,  1088,  1089,  1089,  1089,  1089,  1089,  1089,  1090,
    1090,  1090,  1090,  1090,  1090,  1090,  1090,  1090,  1090,  1090,
    1091,  1091,  1091,  1091,  1091,  1092,  1092,  1092,  1092,  1093,
    1093,  1093,  1093,  1093,  1093,  1093,  1094,  1094,  1094,  1095,
    1095,  1095,  1095,  1095,  1095,  1096,  1096,  1097,  1098,  1098,
    1099,  1099,  1100,  1101,  1102,  1102,  1102,  1103,  1104,  1105,
    1106,  1107,  1107,  1107,  1107,  1107,  1108,  1109,  1109,  1109,
    1110,  1110,  1111,  1111,  1111,  1112,  1112,  1113,  1113,  1114,
    1114,  1115,  1115,  1115,  1115,  1115,  1116,  1116,  1116,  1116,
    1116,  1116,  1116,  1116,  1116,  1116,  1116,  1116,  1116,  1116,
    1116,  1116,  1116,  1116,  1116,  1116,  1116,  1116,  1116,  1116,
    1116,  1116,  1116,  1116,  1116,  1116,  1116,  1116,  1116,  1116,
    1116,  1116,  1116,  1116,  1116,  1116,  1116,  1116,  1116,  1116,
    1116,  1116,  1116,  1116,  1116,  1116,  1116,  1116,  1116,  1116,
    1116,  1116,  1117,  1117,  1117,  1117,  1118,  1118,  1118,  1118,
    1118,  1118,  1118,  1118,  1118,  1119,  1119,  1119,  1119,  1119,
    1120,  1120
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN.  */
static const unsigned char yyr2[] =
{
       0,     2,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     0,     5,     1,     0,     2,     0,     2,     2,
       3,     3,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     3,     3,     2,     2,     2,     2,
       3,     3,     5,     5,     4,     5,     4,     3,     5,     3,
       5,     5,     6,     1,     1,     3,     5,     6,     4,     1,
       0,     2,     0,     1,     1,     1,     1,     1,     1,     2,
       3,     3,     3,     3,     3,     3,     3,     3,     2,     5,
       2,     2,     2,     2,     3,     3,     3,     1,     3,     1,
       3,     1,     1,     1,     2,     2,     2,     1,     1,     1,
       1,     1,     1,     1,     3,     6,     1,     1,     1,     1,
       1,     0,     1,     1,     2,     3,     4,     3,     2,     2,
       1,     3,     4,     5,     4,     2,     4,     1,     1,     1,
       1,     1,     2,     2,     2,     2,     4,     4,     4,     4,
       1,     3,     3,     4,     6,     6,     6,     6,     4,     7,
       2,     4,     3,     3,     3,     3,     3,     4,     4,     3,
       3,     3,     3,     3,     3,     4,     4,     3,     2,     3,
       3,     3,     2,     2,     3,     2,     1,     1,     0,     2,
       0,     3,     2,     0,     1,     3,     3,     1,     5,     3,
       2,     2,    10,     6,     1,     1,     1,     1,     1,     2,
       0,     1,     1,     3,     3,     1,     1,     3,     3,     3,
       4,     1,     0,     2,     0,     3,     0,     1,     0,    11,
      12,     1,     1,     2,     2,     2,     2,     0,     1,     0,
       1,     3,     1,     1,     1,     3,     2,     0,     3,     1,
       1,     2,     1,     3,     4,     4,     2,     5,     1,     2,
       2,     2,     3,     2,     0,     2,     2,     2,     2,     2,
       2,     3,     1,     4,     6,     7,    11,     3,     0,     1,
       3,     1,     2,     2,     2,     0,     1,     1,     2,     2,
       0,     3,     3,     2,     1,     1,     2,     2,     4,     0,
       2,     2,     2,     0,     3,     4,     4,     0,     2,     0,
       4,     0,     5,     3,     0,     1,     3,     1,     2,     3,
       0,     5,     4,     1,     0,     1,     2,     2,     1,     2,
       3,     2,     2,     2,     2,     3,     3,     1,     3,     1,
       0,     1,     2,     1,     5,     9,     1,     0,     1,     2,
       2,     2,     1,     0,     2,     0,     5,     7,     1,     0,
       6,     2,     0,     3,     5,     7,     6,     8,     7,     6,
       6,     4,     0,     1,     3,     4,     1,     3,     1,     2,
       2,     2,     2,     1,     1,    10,     2,     0,     2,     2,
       1,     0,     4,     6,     5,     4,     4,     8,     1,     1,
       1,     7,     9,     8,    14,    19,     1,     1,     1,     3,
       1,     1,     1,     1,     3,     0,     1,     0,     1,     1,
       1,     3,     0,     1,     1,     1,     1,     1,     1,     2,
       0,     1,     2,     1,     2,     0,     2,     1,     2,     2,
       6,     8,     8,     4,     5,     4,     4,     4,     3,     7,
       8,     6,     6,     6,     6,     3,     1,     3,     3,     1,
       1,     1,     1,     1,     1,     3,     3,     3,     1,     3,
       3,     1,     3,    13,     1,     3,     4,     5,     4,     7,
       2,     1,     0,     2,     0,     1,     0,     6,     8,     8,
       1,     3,     5,     5,     7,     9,     7,     9,     5,     6,
       6,     4,     1,     1,     1,     1,     1,     1,     1,     1,
       3,     3,     3,     3,     1,     3,     1,     2,     2,     3,
       5,     2,     2,     0,     6,     7,     7,     7,     8,     8,
       6,     8,     9,     9,     7,    10,     7,     8,     8,     8,
       8,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     4,     2,     4,     2,     5,
       4,     4,     3,     3,     3,     1,     1,     1,     1,     2,
       2,     1,     1,     1,     2,     2,     1,     2,     2,     1,
       1,     7,     7,    10,     1,     1,     2,     4,     5,     1,
       3,     2,     2,     2,     2,     1,     2,     2,     4,     3,
       2,     2,     2,     2,     2,     1,     3,     1,     2,     3,
       0,     1,     3,     2,     6,     6,     9,     3,     0,     3,
       0,    13,    14,     1,     0,     2,     0,     1,     3,     4,
       4,     6,     1,     2,     0,     1,     1,     0,     1,     1,
       0,     9,    12,     7,     2,     0,     3,     2,     1,     3,
       3,     2,     1,     3,     3,     3,     2,     2,     1,     1,
       1,     1,     2,     1,     1,     1,     1,     4,     5,     1,
       3,     3,     1,     2,     4,     5,     1,     1,     1,     1,
       3,     3,     2,     2,     2,     2,     1,     2,     2,     1,
       1,     1,     3,     2,     0,     2,     1,     3,     5,     1,
       2,     1,     0,     5,     7,     5,     7,     5,     7,     3,
       5,     5,     5,     1,     3,    11,    10,    10,     2,     2,
       0,     9,     2,     0,     4,     4,     4,     1,     1,     1,
       0,     7,     6,     6,     6,     6,     7,     9,     9,     6,
       6,     6,     6,     6,     8,     8,     6,     6,     6,     8,
       8,     8,     8,     6,     1,     0,     2,     0,     7,     6,
       6,     6,     6,     6,     6,     7,     6,     6,     6,     6,
       7,     7,     9,     9,     6,     6,     6,     8,     8,     8,
       6,     1,     1,     3,     3,     1,     1,     1,     1,     1,
       1,     1,     0,     1,     1,     1,     1,     1,     1,     0,
       6,     8,     2,     2,     2,     2,     2,     3,     3,     2,
       2,     2,     2,     3,     2,     5,     4,     3,     3,     3,
       1,     1,     0,     3,     2,     2,     1,     3,     2,     1,
       0,     8,    10,     3,     4,     4,     0,     2,     5,     2,
       0,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     4,     3,     3,     1,     0,     5,
       6,     4,     2,     0,     4,     3,     5,     6,     4,     6,
       6,     5,     7,     1,     0,     6,    11,    11,    11,    13,
       9,    11,    10,     4,     2,     5,     2,     0,     4,     5,
       5,     2,     4,     1,     1,     1,     0,     1,     0,     1,
       0,     3,     0,     4,     1,     1,     1,     1,     1,     1,
       1,     1,     0,     5,     4,     3,     0,     1,     1,     1,
       1,     4,     8,     3,     0,     5,     1,     4,     2,     1,
       3,     2,     3,     0,     6,     2,     0,     5,     3,     0,
       2,     2,     2,     3,     1,     3,     1,     2,     1,     0,
       7,     1,     3,     1,     1,     3,     5,     2,     1,     3,
       7,     0,     3,     2,     2,     2,     0,     2,     2,     1,
       1,     3,     3,     1,     2,     4,     4,     2,     3,     5,
       5,     1,     1,     9,     1,     2,     4,     4,     4,     2,
       3,     1,     3,     4,     2,     1,     0,     3,     3,     4,
       4,     4,     4,     2,     1,     1,     0,     1,     1,     0,
       1,     5,     1,     0,     1,     0,     3,     1,     3,     4,
       3,     4,     4,     2,     2,     4,     3,     5,     8,     1,
       0,     1,     1,     1,     3,     0,     1,     1,     1,     1,
       1,     1,     3,     0,     2,     0,     1,     3,     1,     0,
       1,     2,     4,     4,     2,     0,     2,     3,     2,     0,
       1,     3,     1,     2,     1,     2,     5,     6,     5,     1,
       2,     1,     4,     3,     4,     5,     4,     5,     4,     5,
       2,     4,     1,     2,     2,     2,     1,     1,     0,     4,
       2,     1,     2,     2,     4,     1,     3,     1,     2,     3,
       1,     2,     0,     2,     4,     4,     0,     1,     3,     2,
       2,     3,     5,     6,     2,     3,     3,     4,     0,     1,
       1,     1,     1,     1,     2,     5,     1,     1,     1,     1,
       2,     3,     3,     0,     1,     1,     1,     1,     1,     2,
       2,     2,     2,     2,     1,     3,     0,     1,     1,     1,
       1,     5,     2,     1,     1,     1,     1,     5,     2,     2,
       2,     1,     3,     3,     2,     1,     0,     3,     0,     5,
       2,     5,     2,     1,     2,     3,     0,     1,     1,     1,
       1,     1,     1,     3,     3,     3,     3,     3,     3,     3,
       0,     1,     4,     1,     3,     5,     2,     2,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     2,     2,
       3,     3,     2,     3,     5,     4,     6,     3,     5,     4,
       6,     4,     6,     5,     7,     3,     2,     4,     2,     3,
       3,     4,     3,     4,     3,     4,     5,     6,     6,     7,
       6,     7,     6,     7,     3,     4,     4,     6,     2,     3,
       4,     1,     3,     2,     2,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     2,     2,     5,     6,     6,
       7,     3,     4,     1,     1,     2,     4,     1,     1,     1,
       2,     2,     2,     1,     4,     5,     6,     8,     6,     6,
       5,     1,     1,     4,     1,     4,     1,     4,     1,     4,
       1,     1,     1,     1,     1,     1,     6,     4,     4,     4,
       4,     6,     5,     5,     5,     4,     6,     4,     4,     4,
       4,     5,     7,     7,     9,     4,     6,     5,     7,     7,
       7,     2,     3,     3,     3,     4,     0,     4,     1,     3,
       3,     1,     1,     1,     2,     2,     0,     2,     0,     1,
       3,     3,     2,     2,     0,     6,     1,     0,     3,     0,
       2,     2,     0,     1,     4,     2,     2,     2,     4,     3,
       5,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     4,     1,     4,     1,
       4,     1,     2,     1,     2,     1,     3,     1,     3,     3,
       3,     2,     1,     3,     3,     0,     1,     1,     1,     1,
       1,     1,     1,     1,     4,     3,     2,     3,     0,     3,
       3,     2,     2,     1,     0,     2,     2,     3,     2,     1,
       1,     3,     5,     1,     2,     4,     2,     0,     1,     0,
       1,     2,     2,     2,     3,     5,     1,     2,     0,     2,
       1,     0,     1,     1,     1,     3,     3,     1,     3,     3,
       2,     1,     1,     1,     1,     1,     3,     1,     2,     1,
       3,     1,     1,     1,     1,     1,     1,     1,     2,     1,
       1,     1,     1,     1,     2,     5,     2,     3,     6,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     2,     2,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       0,     2,     4,     3,     2,     1,     1,     1,     1,     1,
       0,     8,     0,    14,     2,     5,     3,     2,     2,     3,
       7,     1,     1,     1,     0,     2,     2,     1,     0,     1,
       3,     1,     2,     0,     2,     0,     2,     0,     1,     3,
       4,     3,     1,     1,     1,     1,     2,     0,     2,     4,
       0,     2,     2,     2,     1,     1,     7,     3,     1,     1,
       1,     1,     2,     0,     1,     3,     3,     3,     3,     0,
       4,     5,     5,     0,     1,     1,     1,     1,     2,     2,
       2,     1,     2,     0,     7,     0,     5,     0,     4,     2,
       2,     0,     2,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     5,     2,     1,     3,     2,     2,
       3,     0,     5,     1,     0,     5,     2,     2,     1,     1,
       1,     2,     2,     3,     1,     2,     2,     3,     3,     4,
       2,     1,     2,     1,     1,     2,     2,     3,     1,     1,
       1,     1,     0,     1,     3,     5,     0,     2,     0,     1,
       2,     3,     2,     1,     1,     1,     0,     1,     1,     1,
       1,     1,     2,     2,     3,     0,     1,     2,     1,     4,
       4,     0,     1,     1,     3,     1,     1,     1,     1,     2,
       2,     1,     2,     2,     1,     1,     1,     4,     4,     4,
       1,     0,     3,     3,     4,     1,     3,     3,     4,     1,
       3,     3,     1,     1,     1,     6,     1,     3,     3,     6,
       1,     3,     3,     1,     1,     2,     2,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     4,     4,     1,     1,     4,     4,     3,
       0,     7,     1,     0,     0,     7,     3,     4,     3,     1,
       1,     1,     2,     3,     5,     2,     5,     2,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     3,     1,     0,     1,
       2,     1,     2,     1,     1,     2,     2,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     2,     3,     1,     2,     1,     3,     1,
       3,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     2,     3,     2,     3,     1,     3,     3,     3,
       3,     3,     3,     1,     1,     0,     2,     2,     1,     1,
       2,     1
};

/* YYDEFACT[STATE-NAME] -- Default rule to reduce with in state
   STATE-NUM when YYTABLE doesn't specify something else to do.  Zero
   means the default is an error.  */
static const unsigned short yydefact[] =
{
    1980,     0,     2,     1,  2410,  2414,  2418,  2419,  2337,  2420,
    2421,  2386,  2387,  2388,  2389,  2390,  2391,  2392,  2393,  2394,
    2395,  2396,  2397,  2399,  2398,  2400,  2401,  2402,  2403,  2404,
    2405,  2406,  2407,  2409,  2408,  2358,  1987,  2355,  2352,  2353,
    2354,  2359,  2423,  2411,  2424,  2412,  2413,  2415,  2416,  2385,
    2417,  2425,  2426,  2427,  2422,  2357,  2350,  2351,  1594,  2430,
    2381,  2382,  2380,  2383,  2384,  2428,  2429,  2372,  2373,  2374,
    2375,  2431,  1988,  1989,  2377,  1981,  1985,  2049,  2122,  2378,
    2379,  2376,  1986,  2371,  2122,     0,  2240,  2241,  2242,     0,
    2243,  2244,  2245,  2171,  2136,  2246,     0,     0,  2247,  2248,
    2249,  2250,  2251,  2252,  2253,  2254,     0,  2255,  2256,  2257,
    2258,  2121,  2259,  2260,  2261,  2262,  2263,  2098,  2104,  2224,
       0,  2078,  2079,  2075,  2077,  2076,  2080,  2063,   922,   459,
     994,   993,     0,  1879,   922,  1880,  1837,  1881,  1838,  1839,
    1840,   241,     0,   996,  1841,     0,   922,   322,   337,  1882,
    1883,  2004,     0,  1842,  1843,     0,     0,     0,   459,   922,
       0,     0,  1844,  1012,  1845,     0,  1846,  1884,  1885,     0,
    1847,  1886,  1887,  1848,     0,  1849,  1850,  1888,  1889,  1890,
    1851,  1891,  1892,     0,     0,  1106,     0,  1852,  1893,  1853,
    1854,     0,  1894,  1855,  1856,  1857,  1895,  1896,  1897,  1858,
    1859,  1860,     0,  1861,     0,     0,     0,     0,     0,  1898,
     922,  1862,     0,  1113,     0,  1863,     0,  1899,  1864,     0,
    1865,     0,  1866,  1867,  1868,  1869,  1106,  2220,  2099,     0,
       0,   998,     0,  1870,  1900,     0,  1871,  1872,  1873,  1874,
    1875,  1876,  1877,  1878,     0,     0,    46,    47,    15,    14,
      20,    19,    68,    69,    36,     9,    59,    41,   100,    99,
     101,    26,    22,    54,    13,    23,    27,    43,    42,    12,
      40,    63,    44,    66,    33,    57,     6,    34,    58,     7,
      48,    70,    18,    45,    67,    29,    55,    52,    37,    38,
      39,    60,    61,    62,    84,    65,    95,    25,    74,    75,
      90,    76,    91,    77,    35,     8,    87,    86,    88,    30,
      56,    85,    89,    10,    11,    64,    82,    79,    96,    94,
     102,    80,    49,     3,     4,    71,    32,     5,    17,    16,
      31,    24,    98,    21,   996,    73,    83,    72,    78,    53,
      81,    97,    51,    93,  1082,  1069,  1115,  1081,     0,  1084,
    2316,  2317,    28,    92,   122,   104,   105,   110,  1984,  2038,
    2039,  2040,  2122,  2073,  2074,  2067,  2083,  2093,  2082,  2086,
    2094,  2081,  2100,     0,   107,   109,   111,   114,   108,   103,
     106,   113,   118,   112,   117,   115,   116,   119,   120,   121,
    2318,  1290,  2315,    50,  2055,     0,  2122,  2057,  2056,     0,
    2264,  2265,  2266,  2267,  2268,  2269,  2319,  2320,  2321,  2322,
    2323,  2325,  2324,  2347,  1600,  1601,  1602,  1603,  1604,  1605,
    1606,  1607,  1608,  1609,  1610,  1611,  1612,  1613,  1614,  1615,
    1616,  1617,  1618,  1619,  1620,  1621,  1622,  1623,  2291,  1624,
    1625,  1626,  1627,  1628,  1629,  1630,  1631,  1632,  1633,  2328,
    1634,  1635,  1636,  1637,  1638,  1639,  1640,  1641,  1642,  1643,
    1644,  1645,  1646,  1647,  2329,  1648,  1649,  1650,  1651,  1652,
    1653,  1654,  1655,  1656,  1657,  1658,  1659,  1660,  1661,  1662,
    1663,  1664,  1665,  1666,  1667,  1668,  1669,  1670,  1671,  1672,
    1673,  1674,  1675,  1676,  1677,  1678,  1679,  1680,  1681,  1682,
    1683,  1684,  2330,  1685,  1686,  1687,  1688,  1689,  1690,  1691,
    1692,  1693,  1694,  1695,  1696,  1697,  1698,  1699,  1700,  1701,
    1702,  1703,  1704,  1705,  1706,  1707,  1708,  1709,  1710,  1711,
    1712,  1713,  1714,  1715,  1716,  1717,  2331,  1718,  1719,  2332,
    1720,  1721,  1722,  1723,  1724,  1725,  1726,  1727,  1728,  1729,
    1730,  1731,  1732,  1733,  1734,  1735,  1736,  1737,  1738,  1739,
    1740,  1741,  1742,  1743,  1744,  1745,  1746,  1747,  1748,  1751,
    1749,  1750,  1752,  1753,  1754,  1755,  1756,  1757,  1758,  1759,
    1760,  1761,  1762,  1763,  1764,  1765,  1766,  1767,  1768,  1769,
    1770,  1771,  1772,  1773,  1774,  1775,  1776,  1777,  1778,  1779,
    1780,  1781,  2333,  1782,  1783,  1784,  1785,  1786,  1787,  1788,
    1789,  1790,  1791,  1792,  1793,  1794,  1795,  1796,  1797,  1798,
    1799,  1800,  1801,  1802,  1803,  1804,  1805,  1806,  1807,  1808,
    2004,  1809,  1810,  1811,  1812,  1813,  1814,  1815,  1816,  1817,
    1818,  1819,  1820,  1821,  1822,  1823,  1824,  2292,  1825,  1826,
    1827,  1828,  1829,  1830,  1831,  1832,  1833,  1834,  2334,  1835,
    1836,  2022,  2326,  2288,  1997,  2018,  2289,  2238,  2239,  1595,
    2290,  2287,  2327,  2024,  2343,  2023,  2286,  2170,     0,     0,
    2135,  2134,  2138,  2137,  2139,  2132,  2133,  1572,  2025,  2143,
    2142,  1571,     0,  2145,  2270,  2271,  2272,  2273,  2275,  2274,
    2276,  1901,  1902,  1903,  1904,  1905,  1906,  1907,  1908,  1909,
    1910,  1911,  1912,  2301,  1913,  1914,  1915,  2314,  1916,  1917,
    2302,  1918,  1919,  1920,  1921,  1922,  1923,  1924,  1925,  1926,
    1927,  1928,  1929,  1930,  1931,  1932,  1933,  1934,  1935,  1936,
    1937,  1938,  1939,  1940,  1941,  2303,  2304,  1942,  1943,  1944,
    1945,  1946,  1947,  1948,  1949,  1950,  1951,  1952,  1953,  1954,
    1955,  1956,  1957,  1958,  1959,  1960,  1961,  1962,  1963,  1964,
    1965,  1966,  1967,  2305,  1968,  1969,  2306,  1970,  1971,  1972,
    2307,  1973,  1974,  1975,  1976,  1977,  2311,  2312,  2313,  2300,
    2096,  2277,  2299,  2310,  2308,  2309,  2106,  2102,  2110,  2105,
       0,     0,     0,     0,  2122,   921,   920,   906,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   458,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1994,     0,   930,   301,   300,   995,   984,   459,     0,   909,
     321,     0,     0,     0,     0,     0,     0,     0,   581,     0,
       0,     0,     0,     0,     0,     0,     0,   170,     0,     0,
     332,   331,     0,     0,   446,     0,   723,     0,     0,   459,
       0,     0,     0,  2003,  1998,  2008,     0,  2001,  2002,  2286,
       0,  2434,  1749,  2034,  2035,  2432,  1794,  1061,     0,   242,
     245,   243,   244,     0,     0,   823,   608,     0,   607,     0,
       0,     0,   605,     0,     0,     0,     0,   609,   603,     0,
     602,     0,     0,     0,   606,     0,   604,     0,     0,   910,
       0,  2088,  2089,  1687,  1024,  1011,   996,  1601,   672,   676,
     667,   673,   679,   680,   668,   665,   666,  1763,     0,     0,
       0,     0,   656,  1596,   671,  1597,   685,   378,   378,   378,
       0,   684,   689,   378,     0,   903,   937,  1576,  1105,     0,
       0,   658,   902,  1809,  1016,     0,     0,   827,     0,   828,
       0,  1778,   914,   228,  2284,  1786,  1866,  1809,  2285,   224,
    2279,  2280,  2282,   197,  2283,  2281,  2278,  1605,     0,     0,
     684,     0,   911,   912,  1112,  1110,     0,     0,     0,  1622,
       0,  1634,  1711,   221,  1774,  1779,  1786,  1866,  1809,  1834,
     179,     0,   235,  1786,  1866,  1809,     0,   930,  1979,  1978,
       0,  1085,  1567,  1191,  1563,  1564,     0,     0,  2097,   905,
     904,  1197,     0,   997,  1000,     0,  1156,  1761,  1089,  1091,
    1002,  1082,     0,  1983,   991,  1109,  1109,     0,  1109,     0,
    1074,  1082,  1077,  1081,     0,   922,     0,  2065,  2093,  2072,
    2128,  2069,     0,     0,  2118,  2114,  2111,  2119,  2120,  2113,
    2101,  1279,  1280,  1281,  1278,  1291,  1277,     0,  2044,  1282,
    2085,  2050,     0,  2060,  2059,  2058,  2360,  2361,  2172,  1996,
    2015,     0,     0,     0,     0,     0,     0,  2151,  2144,  2146,
    2148,  2108,  2107,  2103,     0,     0,     0,     0,  2230,  2231,
    2229,     0,  2226,  2228,     0,  2128,     0,     0,  2295,  2289,
    2298,  1577,  2290,  2287,  2286,     0,   616,   125,     0,     0,
       0,     0,     0,     0,  1626,  1674,  1474,  1484,  1482,  1483,
    1476,  1477,  1478,  1479,  1480,  1481,     0,   813,  1475,     0,
     125,     0,     0,     0,     0,     0,     0,     0,     0,  1715,
     125,     0,     0,     0,     0,     0,   926,   929,   907,   987,
       0,  1564,     0,     0,   641,     0,   650,   642,   647,     0,
     644,     0,     0,   652,     0,   643,   645,   646,   651,     0,
       0,   648,   649,     0,     0,   918,   378,     0,     0,     0,
       0,     0,   125,   974,     0,   336,   335,   125,   334,   333,
    1626,  1674,     0,   744,   125,     0,   172,   487,   462,     0,
       0,   548,  1715,   125,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2007,  2013,     0,  2005,  2173,  2435,  2433,
    2131,     0,  1036,  1686,     0,   288,     0,     0,  1686,   965,
       0,  1686,     0,  1686,   165,  1569,  1626,  1674,  1686,     0,
       0,  1686,   157,  1686,     0,  1686,   288,  1686,   463,     0,
    1686,     0,  1686,  1715,   159,     0,  1686,   288,   614,     0,
       0,  2365,  2369,     0,  2367,  2362,  2087,  2141,  2140,  2037,
       0,  2445,     0,   669,   678,   677,   675,   674,   670,  1598,
    1599,     0,   663,   664,  2151,  2451,   662,   686,     0,     0,
     693,   692,   691,     0,     0,     0,   694,     0,  1195,  1039,
       0,   917,     0,     0,     0,     0,   830,   830,   830,   913,
     227,   225,     0,     0,     0,     0,     0,     0,   919,     0,
       0,     0,  1837,  1838,  1839,  1539,     0,  2291,  1840,  1841,
    1404,  1391,  1400,  1405,  1392,  1394,  1401,  1842,  1843,  1661,
    1844,  1845,  1590,  1846,  1847,  1234,  1849,  1850,  1851,  1396,
    1398,  1852,  1853,     0,  1591,  1855,  1856,  1738,  1858,  1859,
    1861,  1862,  1402,  1864,  1865,  1866,  1867,  1868,  1869,  1589,
       0,  1403,  1870,  1872,  1873,  1874,  1875,  1876,  1877,  1878,
    2349,  1583,  1485,  2348,     0,     0,  1562,     0,  1379,     0,
    1226,  1227,  1249,  1250,  1228,  1255,  1256,  1268,  1229,     0,
    1561,  1293,  1378,  1383,     0,  1377,  1373,  1096,  1557,  1540,
       0,  1374,  1579,  1593,  1592,  2343,  1548,  1582,  1580,  1581,
       0,     0,     0,   190,     0,     0,  2219,   237,     0,   238,
    1565,  1786,   180,   220,   192,   219,   193,   222,   223,   191,
       0,  1624,   181,     0,   188,     0,     0,     0,     0,     0,
       0,     0,   231,   908,     0,  1193,     0,     0,  1546,  1568,
    1192,   623,     0,     0,  1198,     0,   999,   996,  1553,  1552,
    1554,     0,  1090,     0,     0,     0,  1072,  1071,  1002,  1107,
    1108,     0,     0,     0,     0,     0,     0,     0,     0,  1149,
    1130,  1146,  1150,     0,  1078,  1157,  1982,  2128,  2129,     0,
    2123,     0,  2122,  2122,  2116,  2115,  2112,     0,     0,     0,
       0,     0,     0,     0,  2041,   443,  2043,   441,     0,     0,
    2017,     0,  2021,  2019,  2151,  2167,  2151,  2168,  2169,     0,
    2174,  2175,     0,  2152,  2356,     0,     0,  2158,     0,  2147,
    2153,  2155,  2157,  2156,  2165,  2161,  2164,  2166,  2109,  2122,
    2237,     0,  2232,  2235,     0,  2227,     0,  1578,     0,     0,
       0,     0,     0,   617,     0,     0,     0,   124,   963,   230,
     961,     0,     0,     0,     0,   968,     0,     0,     0,     0,
     777,     0,     0,     0,     0,     0,     0,   778,   776,   779,
     786,   799,   802,     0,   713,   163,   164,     0,     0,   855,
     855,     0,     0,   855,     0,     0,     0,     0,     0,     0,
       0,   247,   250,     0,     0,     0,     0,     0,     0,     0,
     127,   154,     0,     0,     0,   428,   440,     0,     0,     0,
       0,     0,   437,     0,   125,   248,   422,   425,     0,     0,
       0,   496,   495,   855,     0,   246,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   127,   156,
       0,     0,   249,     0,  2051,     0,   924,   925,     0,   928,
       0,   983,     0,     0,     0,     0,     0,     0,  1626,  1674,
       0,     0,     0,     0,     0,     0,   324,   307,   308,   125,
     306,     0,     0,   545,     0,  1237,  1266,  1244,  1266,  1266,
    1233,  1233,  1246,  1235,  1273,     0,  1266,  1233,  1238,     0,
    1236,  1276,  1276,  1261,     0,  1218,  1219,  1220,  1221,  1247,
    1248,  1222,  1253,  1254,  1223,  1290,  2296,  1233,  2297,  2294,
    2293,     0,   940,   973,     0,     0,   127,   582,     0,     0,
     546,     0,   127,     0,   168,     0,   491,     0,     0,     0,
       0,     0,     0,   507,   506,     0,     0,   547,     0,   127,
     424,     0,   414,   378,     0,     0,  1632,     0,  1575,     0,
       0,  2011,  2006,  2009,     0,  1999,  2013,  1064,  1066,  1065,
       0,  1063,     0,  1206,     0,   288,   286,   287,   543,   822,
       0,     0,     0,     0,   288,     0,     0,  1686,     0,  1686,
       0,     0,   288,   288,     0,     0,     0,     0,   492,     0,
     613,   611,   610,   612,     0,     0,     0,     0,     0,  1686,
     288,     0,     0,   601,  2363,     0,     0,  2366,     0,  2090,
    1495,     0,  2448,  1021,  2449,   337,     0,     0,  1003,  1010,
    1005,  1007,  1006,  1008,  1004,  1009,   655,   660,   661,     0,
    2450,  2335,  2341,     0,     0,   379,   381,     0,  1647,     0,
    1679,  1703,  1779,  1783,     0,  1804,     0,   695,   718,   690,
       0,     0,  1033,  1026,     0,     0,  1049,   657,  1014,  1497,
       0,     0,     0,   829,   826,   825,   824,   226,   198,     0,
       0,     0,   720,  1778,   916,     0,     0,  1381,  1382,  1265,
    1252,  1538,     0,     0,  1260,  1259,     0,     0,     0,     0,
    1242,  1241,  1240,  1380,  1505,     0,  1239,     0,     0,     0,
       0,  1266,  1266,  1264,  1312,     0,  1243,     0,     0,  1518,
       0,  1524,     0,     0,     0,  1272,     0,  1270,     0,     0,
    1348,     0,     0,     0,     0,     0,     0,     0,  1296,  1297,
    2292,  1379,  1495,     0,  1586,     0,     0,  1258,     0,  1290,
       0,     0,     0,     0,  1551,  1493,     0,     0,  1326,  1491,
       0,  1328,     0,     0,     0,  1485,  1484,  1482,  1483,  1476,
    1477,  1478,  1479,  1480,  1481,  1489,  1309,     0,  1560,     0,
    1308,  2151,     0,  1159,  1095,  1541,     0,  1584,     0,  2342,
    2344,  1375,  2216,  2215,  2214,  2213,  2184,     0,  2178,  2179,
       0,  2217,  2218,   239,   240,   236,     0,     0,   195,   194,
       0,   217,   218,   187,   216,     0,   212,   213,  1443,  1442,
     196,   186,   184,   209,   211,   210,   208,   182,   199,   201,
     202,   203,   185,   183,   234,   232,     0,     0,     0,  1543,
    1542,  1574,  1547,     0,     0,   288,  2122,  1199,     0,  1159,
    1051,  1053,  1054,     0,  1548,   988,  1556,     0,  1092,     0,
       0,   992,  1088,  1087,  1116,  1117,   737,  1086,  1140,  1141,
    1135,     0,  1155,  1155,  1132,  1123,  1131,  1124,     0,  1136,
    1293,  1148,  1076,  1129,  1075,     0,  1151,  1149,  1130,     0,
    2130,  2128,  2068,  1218,  2122,  2061,  2122,  2117,  2047,  1284,
    1285,  1286,  1287,  1288,  1289,  2048,     0,  2045,  1283,  2046,
     442,     0,     0,     0,  2014,     0,  1995,  2020,  2182,     0,
    2183,     0,     0,  2159,  2162,  2160,  2163,     0,     0,  1218,
    2338,  2233,  2338,  1218,     0,     0,     0,     0,     0,     0,
       0,   618,     0,     0,     0,  1804,   229,   959,     0,     0,
       0,     0,     0,   971,   372,     0,   285,     0,     0,     0,
       0,     0,     0,     0,   784,     0,     0,     0,     0,   785,
     782,   783,  1779,   801,   800,   798,   759,   761,   760,     0,
     763,   747,     0,   748,     0,     0,   758,   766,   764,     0,
       0,   854,   260,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   278,     0,     0,     0,     0,   283,
       0,     0,     0,   282,     0,     0,     0,     0,     0,     0,
     814,     0,   153,     0,     0,   427,   439,     0,   431,   432,
     429,   433,   434,     0,     0,     0,     0,     0,     0,   426,
       0,     0,   489,   488,   494,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   498,   499,
       0,   500,     0,   155,     0,     0,     0,     0,     0,     0,
     207,   923,   927,   986,   985,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   310,     0,   568,  2293,   544,     0,
    1218,     0,  1214,  1210,  1279,  1278,  1277,     0,  1224,  1233,
    1230,     0,   938,   347,   453,   161,     0,     0,     0,   556,
     559,     0,   123,   172,   337,     0,   171,   173,   175,   176,
     177,   174,   178,   486,   490,     0,   461,     0,     0,     0,
       0,     0,   511,   510,   513,   512,     0,   508,     0,     0,
       0,   152,   421,   423,  1990,     0,   339,   403,     0,   444,
       0,     0,     0,     0,     0,  1992,     0,  2012,     0,     0,
       0,     0,  1062,     0,  1169,  1035,  1160,  1171,  1162,  1164,
    1200,  1567,     0,     0,  1033,     0,   805,     0,   966,  1686,
     288,     0,   803,   166,  1570,     0,     0,     0,     0,     0,
     807,   598,   158,     0,   288,   288,   464,     0,   288,   160,
       0,     0,     0,   456,   288,   615,  2364,  2370,  2368,  1023,
       0,  2446,  2447,     0,  1061,   659,     0,     0,  2340,     0,
     687,     0,   377,   701,     0,     0,   700,   711,   702,   703,
     697,   696,   704,     0,     0,   720,  1028,     0,  1029,  1548,
       0,  1025,     0,  1046,     0,  1044,     0,  1196,  1048,  1037,
    1015,     0,  1013,  1018,  1020,  1019,  1017,     0,     0,     0,
     684,     0,     0,   288,   915,     0,  1501,     0,  1502,     0,
       0,     0,  1537,  1533,     0,     0,     0,     0,     0,  1509,
    1510,  1511,  1508,  1512,  1507,     0,     0,  1513,  1506,     0,
       0,     0,     0,     0,  1263,  1262,     0,     0,     0,     0,
       0,     0,     0,  1351,  1383,     0,     0,  1469,     0,  1495,
    1523,     0,     0,  1274,     0,     0,     0,     0,     0,     0,
       0,  1495,  1529,     0,     0,     0,  1441,     0,  1438,     0,
       0,     0,     0,  1548,     0,     0,     0,     0,  1587,  1294,
    1310,  1559,     0,  1550,     0,     0,  1317,     0,  1530,  1344,
       0,  1349,  1332,     0,  1325,     0,  1330,  1334,  1313,  1551,
    1494,     0,  1492,     0,     0,  1311,     0,  1306,  1304,  1305,
    1298,  1299,  1300,  1301,  1302,  1303,  1307,  1473,  1471,  1472,
       0,     0,     0,  1329,  2259,  1680,  1711,     0,  1106,  1106,
    1094,  1104,  1558,     0,  1202,     0,     0,     0,     0,  1454,
       0,  2346,  2345,  1549,     0,     0,     0,  1566,     0,     0,
    1290,     0,   233,  1194,  1544,     0,   621,   622,   620,  1218,
    1058,     0,     0,  1206,     0,  1057,   990,   989,  1555,  1001,
    1093,     0,   735,   736,     0,   740,     0,     0,  1133,  1147,
       0,  1049,  1049,     0,     0,     0,  1138,  1139,  1126,  1080,
    1079,  2066,  2124,  2071,  2092,  2062,  2095,  1292,  2042,  2084,
       0,  2016,  2185,  2186,     0,  2176,  2177,  2149,  2154,  2223,
       0,  2339,     0,     0,   566,   565,     0,     0,     0,   866,
     832,   619,   867,   833,   960,     0,   962,     0,     0,     0,
       0,     0,   288,   969,   868,   284,   970,   859,     0,     0,
       0,   469,   470,     0,   780,   781,   869,   834,     0,   860,
     762,  1233,   746,     0,     0,   757,     0,   756,  1233,  1233,
     835,   162,   252,     0,   857,   264,   277,   272,   273,   271,
     288,   288,     0,     0,     0,     0,   274,   269,   270,   266,
     279,   280,   843,     0,   294,   297,   281,   262,   265,   263,
     251,     0,  1573,     0,     0,   809,     0,     0,   846,     0,
       0,   136,   138,   140,     0,     0,   134,   142,   137,   139,
     141,   135,   143,   133,     0,     0,   132,     0,     0,     0,
       0,   126,   874,   839,   430,   435,   841,   438,   862,   436,
    1604,  1662,  1787,     0,   476,   478,     0,   483,   880,   840,
       0,   861,   876,   848,     0,     0,     0,     0,     0,     0,
       0,   975,     0,     0,     0,   875,   853,   864,     0,   847,
     842,   863,     0,     0,   205,   204,   206,     0,     0,     0,
       0,     0,     0,     0,     0,   654,   630,   653,     0,     0,
       0,     0,     0,     0,     0,   624,   323,   304,   305,     0,
     303,   567,     0,     0,     0,  1215,  1211,     0,     0,     0,
       0,     0,     0,  1231,     0,     0,   958,   958,   958,   958,
     958,   958,   958,   939,   967,   452,   472,     0,   587,   555,
       0,     0,   378,   167,     0,     0,     0,   460,   554,   552,
     551,   553,     0,     0,     0,     0,  1207,     0,     0,     0,
       0,     0,     0,     0,   338,   340,   342,   343,   344,     0,
     415,   417,     0,     0,   407,     0,     0,     0,     0,   726,
     751,     0,   769,   752,     0,     0,     0,   789,   794,   790,
     772,     0,  2010,  2004,  1067,  1068,     0,  1082,     0,  1171,
       0,  1170,  1182,     0,     0,  1188,  1186,     0,  1188,     0,
    1188,     0,  1163,     0,  1165,  1182,  1568,     0,     0,  1203,
    1034,   288,     0,     0,   466,   288,     0,   288,     0,   288,
     288,     0,   900,   493,     0,   540,     0,     0,   288,   600,
    1496,     0,     0,  2150,  2336,   688,   380,     0,   699,     0,
       0,   710,   705,   707,     0,   714,     0,     0,  1031,     0,
    1047,  1040,  1042,  1041,     0,     0,  1038,  1498,   599,     0,
       0,   288,     0,   715,  1111,  1499,  1500,     0,     0,     0,
       0,  1534,     0,     0,  1417,  1393,  1395,  1232,  1407,     0,
    1245,  1418,  1419,  1397,  1399,     0,  1486,     0,     0,  1408,
    1353,  1354,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1366,  1365,  1409,  1468,     0,
       0,  1521,  1522,  1410,  1275,  1276,  1276,     0,     0,  1528,
       0,     0,     0,  1415,  1420,     0,     0,  1425,     0,  1446,
       0,     0,     0,  1376,  1496,  1267,  1268,     0,     0,     0,
       0,     0,     0,     0,     0,  1350,  1333,  1327,     0,  1331,
    1335,     0,     0,     0,     0,  1319,  1345,  1315,     0,     0,
    1321,     0,  1346,  1106,  1106,  1106,  1106,  1103,     0,     0,
    1158,     0,  1143,     0,     0,     0,  1454,     0,  1384,  1454,
       0,  2198,  2200,  2201,  2202,  2203,  2204,  2206,  2207,  2209,
    2210,  2211,  2199,  2205,  2208,  2212,  2189,  2190,     0,  2180,
    2181,   189,     0,   214,   200,     0,  2223,     0,     0,  1052,
    1033,  1055,  1118,     0,  1487,   740,   738,   739,  1120,     0,
       0,  1154,  1153,  1152,  1121,  1125,  1122,     0,     0,  2126,
    2052,     0,     0,  2222,  2225,  2236,  2234,  2064,   865,   831,
     858,   958,     0,   371,     0,     0,     0,   972,   451,     0,
     450,   448,   468,   774,     0,  1233,   749,   754,   755,     0,
     347,     0,     0,   253,     0,   261,   258,   275,   267,   276,
     268,   291,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   871,   148,     0,     0,     0,     0,
     129,   128,   149,   147,     0,   146,     0,   480,   481,   479,
     475,     0,   482,   484,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   870,   836,   625,     0,
       0,   626,   634,     0,     0,   627,     0,     0,     0,     0,
       0,     0,   636,   326,   311,   315,   974,   974,     0,   316,
     974,   312,   974,   309,   569,     0,  1738,  1476,  1477,   563,
     570,   560,   562,   561,   564,   535,     0,     0,     0,  1216,
       0,  2436,  2444,  2443,     0,  1290,     0,   958,   957,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   358,
       0,     0,   352,     0,     0,   794,   346,   349,   350,     0,
     465,     0,   557,   558,     0,   337,     0,     0,   515,   509,
       0,   571,   549,     0,  1209,   472,  1024,   420,   339,   364,
     399,     0,   413,     0,   401,   400,   402,     0,   409,   936,
     453,     0,   726,     0,     0,   750,     0,     0,     0,   787,
     791,   788,     0,     0,   765,     0,   773,   743,     0,  2027,
    1060,  2036,  1173,  1180,     0,  1161,     0,  1187,  1183,     0,
    1184,     0,     0,  1185,     0,     0,  1180,     0,     0,     0,
     806,     0,   288,   804,     0,   594,     0,   596,   808,   288,
     288,   501,     0,   457,   414,  1066,   698,   712,   708,     0,
       0,   681,   717,  1027,  1030,  1032,  1045,  1043,   720,     0,
     682,   719,  1503,  1251,     0,  1536,  1532,     0,  1504,     0,
    1516,  1515,  1352,  1517,     0,  1371,     0,     0,  1363,  1361,
    1362,  1355,  1356,  1357,  1358,  1359,  1360,  1364,  1526,  1525,
    1519,  1520,  1271,  1269,     0,  1412,  1413,  1414,  1527,  1421,
       0,  1440,  1439,     0,     0,     0,  1427,     0,     0,  1436,
       0,  1470,  1257,  1290,  1295,     0,     0,  1318,  1531,  1336,
       0,     0,     0,  1314,     0,     0,     0,     0,  1323,  1486,
       0,     0,     0,     0,     0,     0,  1098,  1097,  1201,     0,
    1145,  1454,  1454,  1454,  1390,  1457,  1452,  1453,  1385,  1585,
       0,     0,     0,     0,  1545,  2221,     0,  1059,  1050,     0,
    1119,  1134,  1127,  1135,  2070,     0,  2125,  2187,  2188,     0,
     373,     0,     0,   794,   879,   449,   775,     0,   767,   345,
       0,   856,     0,     0,     0,     0,   295,   296,   299,     0,
       0,     0,     0,     0,   588,   574,     0,     0,   589,   590,
       0,     0,   811,   812,   810,   144,   130,   151,   150,   131,
     145,   477,   844,     0,     0,     0,     0,     0,   878,   852,
     877,   850,   849,   851,   845,   503,     0,   628,     0,     0,
     629,   640,   638,   637,   639,   631,   327,   125,     0,     0,
       0,     0,     0,     0,     0,   537,     0,     0,   542,   531,
     533,     0,     0,     0,  1212,     0,     0,     0,     0,     0,
       0,  1217,  1225,   530,     0,   949,   948,   947,   951,   950,
     953,   952,   944,   943,   956,   955,   942,   941,   946,   945,
       0,     0,   356,   360,   361,   359,   351,   794,   378,   411,
       0,     0,     0,     0,     0,   517,     0,   550,     0,  1208,
     497,  1022,     0,  1991,     0,   362,     0,   403,   341,   416,
     417,     0,     0,   412,     0,   931,   455,     0,     0,   725,
       0,   753,   770,   771,     0,     0,   794,   793,   895,   896,
     893,   894,     0,     0,  2000,  1172,     0,     0,  1174,     0,
       0,  1176,  1178,     0,     0,     0,     0,     0,  1571,  1454,
    1204,  1205,   288,   467,   288,   288,   901,   541,     0,     0,
       0,     0,   706,   288,     0,  1535,  1406,  1416,  1514,     0,
       0,  1372,     0,     0,  1411,  1871,     0,     0,  1444,  1445,
    1426,     0,  1724,  1431,     0,     0,     0,  1588,  1342,  1340,
    1337,     0,  1338,     0,     0,  1320,  1316,     0,  1322,  1347,
    1102,  1101,  1100,  1099,     0,     0,  1448,  1388,  1389,  1386,
    1459,  1456,     0,  2191,     0,  2194,  2192,  2193,  2197,  1290,
    1056,     0,     0,  2127,   964,     0,   794,   411,   768,   254,
     255,   256,   257,   290,     0,   872,   837,     0,     0,   580,
       0,     0,     0,     0,   873,   838,     0,     0,     0,   980,
       0,     0,   632,   633,   310,     0,   313,   318,     0,   319,
     314,   317,   539,   538,   536,   532,   534,  1213,     0,   820,
     820,  2437,  2438,  2439,  2440,  2441,  2442,     0,   535,   954,
       0,     0,   348,   411,   385,     0,   353,     0,   473,     0,
     936,   339,   472,   516,     0,     0,   572,   418,     0,   403,
       0,     0,   363,     0,   407,     0,   404,     0,   408,     0,
       0,     0,     0,   445,     0,     0,     0,     0,   727,   734,
     734,   792,     0,   796,     0,   764,   741,     0,  2026,  2030,
       0,  1181,  1190,     0,  1177,  1175,  1166,     0,  1168,   821,
     595,   597,   502,     0,   709,   716,   288,  1367,     0,     0,
       0,     0,  1422,     0,  1423,  1428,  1432,     0,  1429,  1430,
    1339,  1343,  1341,  1324,  1142,  1144,     0,  1083,     0,  1115,
    1454,  2196,  2195,   215,  1488,     0,     0,   411,   374,     0,
     259,   298,     0,     0,   586,   575,     0,     0,   591,     0,
       0,     0,     0,     0,   635,   302,   325,   320,   820,     0,
     817,   816,   529,     0,   355,   354,     0,   390,     0,   471,
       0,   584,   932,   485,   518,   519,   514,     0,   419,   407,
     368,   366,   370,   367,   365,   369,     0,   409,   405,   406,
       0,   933,     0,   454,   982,     0,     0,   293,     0,     0,
     732,   737,   737,   795,     0,     0,  1202,     0,  2028,  1179,
       0,  1167,   683,  1368,     0,  1369,     0,     0,  1434,  1433,
    1447,  1449,     0,     0,  1462,  1114,  1387,  1128,   378,   375,
     289,     0,   578,   585,   576,   586,     0,     0,   976,     0,
     977,   978,   981,   815,   819,   818,     0,   382,   383,   384,
       0,   357,   386,   387,     0,   474,     0,     0,     0,   409,
     398,   329,   934,   935,   293,   734,     0,   409,   728,   733,
     740,   740,   794,   797,     0,  2031,  2033,  2032,     0,  1189,
    1370,  1437,  1424,  1435,     0,     0,  1458,     0,     0,     0,
     385,     0,   577,   593,   592,     0,     0,     0,     0,     0,
     388,     0,   389,   410,   583,     0,   522,   330,   409,   737,
     292,  1202,   730,   729,   742,   899,  2029,  1450,  1451,     0,
       0,     0,  1460,  1463,  1461,  1455,   390,     0,   979,     0,
     395,     0,   394,     0,   392,   391,   573,   527,     0,   520,
     523,   528,   526,   524,   525,  1202,   740,   721,   898,   897,
       0,     0,  1467,  1466,  1465,   535,   579,     0,   393,   397,
     396,   504,     0,   722,   731,   881,   892,  1993,   882,   890,
     887,   889,   888,   886,     0,   376,     0,   521,     0,   891,
     885,  1082,  1069,  1464,     0,   883,   892,   522,   884,     0,
     505
};

/* YYDEFGOTO[NTERM-NUM]. */
static const short yydefgoto[] =
{
      -1,     1,   245,   246,  1588,  2252,  2821,   247,   248,   249,
     250,   251,   252,   253,   254,   255,  1618,   256,   257,  1215,
    1764,  2356,   258,  2176,  1011,  2057,  2058,  2301,  2059,  2043,
    1454,  2060,  1589,  1610,   260,   261,  1448,  2035,   262,   263,
     264,  1631,  1632,  1595,  1808,  4000,  2243,  4127,  2783,  2784,
     265,   266,  2889,  1709,  2890,  3333,   841,  2323,  3657,  3658,
     267,  1761,  2943,  2944,  2945,  2946,  2914,  3376,  3377,  3378,
    2947,  3725,  3922,  2948,  2184,  1310,  1874,  1875,  4027,  4111,
    4112,  4113,  4194,  3727,  2954,  3408,  3733,  3906,  1781,  2387,
    2949,  2950,  3723,   268,   269,  2382,  1656,  1657,  2257,  3339,
     270,   869,  3240,  2915,  2916,  3933,   271,   829,   272,  1768,
     273,   274,   275,   276,  3380,  3907,  1661,  2833,  2834,  2835,
    2836,  3292,   277,  1766,  1662,  2365,   278,   279,   280,  2290,
     281,   282,   283,  1775,  2376,  2377,  3716,  3914,  4036,  4198,
    4199,  3898,  3668,  3669,  3670,   284,   285,   286,   287,  1760,
    2348,  2349,  3340,  1579,  1713,  2325,  2326,  3390,   288,  3614,
    3615,   870,  4117,  4094,   289,   290,  3618,  3619,   291,   292,
     293,   294,   295,   918,  1277,  1278,  2759,   296,  2075,   297,
    1194,  2876,   298,   940,   941,   299,   300,   950,  2500,   952,
    1886,  3031,  3032,  3471,  2466,  1130,   301,   302,  2475,  2503,
     303,   871,  3414,  3937,  3938,  4061,  2675,  3208,   304,   872,
    1614,  2212,  2394,  2961,  2962,  2214,  2215,  3423,  2216,  2963,
    2968,  2969,  2970,  3419,  3427,  3943,  3944,   305,  1612,  2205,
     306,   307,   308,  1636,  1146,   309,  4020,   310,  1247,   311,
     970,  1904,   312,  2223,  3254,   313,   314,  4227,  4238,  4239,
    4240,  3752,  4210,   315,  4229,   317,   318,   319,   832,  1166,
    1167,  1168,   320,  3735,   321,   322,  2342,  2913,  3359,   323,
     324,  2177,  2726,   325,   326,   327,  1754,   328,   329,   330,
     331,  1691,   332,   333,   334,   836,  1034,  1487,  1495,   335,
    1858,   926,   336,  1324,  2492,   337,  1291,  4230,  1892,  2477,
    2478,  2481,  4231,  1803,   340,  1896,  2486,  2489,  4232,  2079,
    2080,  2081,  2082,  2083,  2661,   342,  1241,  2401,  4233,  1408,
     345,   346,   347,   348,  1038,  1039,  2013,  2630,   959,  1501,
     996,  1049,  1050,  2094,  2095,  2113,  2114,  2105,  2677,  2107,
    2108,  2688,  2100,  3560,  3826,  2111,  2112,  1511,  1512,  2681,
     349,  2634,  2405,  2406,  2407,  2981,  2991,  3438,  3761,  2408,
    1319,  1032,  2409,  3162,  2414,  2935,  2936,  2217,  2333,  1735,
    1409,  1736,  2340,  1410,  1936,  1738,  1411,  1412,  1413,  1741,
    1414,  1415,  1416,  1417,  1920,  1977,  1418,  1419,  1955,  1078,
    1079,  1850,  2542,  1421,  1422,  3529,  3805,  3796,  2567,  2568,
    2050,  3525,  3987,  4080,  4081,  3568,  3566,  3830,  3989,  4149,
    4182,  4183,  1423,  2620,  2005,  1148,  1424,  3342,  2007,  2562,
    2165,  1918,  2509,  2525,  2526,  2539,  3078,  2546,  2551,  3101,
    3102,  2563,  2589,  1425,  2512,  2513,  3062,  1922,  1426,  1478,
    1479,  2021,  2585,  1490,  1491,  1036,  1427,  1428,  1429,  1887,
    1023,  3757,  1255,   683,  2791,  2070,  1170,   956,  1430,  1431,
    1432,   661,  1535,   662,   663,  1118,   787,  1024,     2,    75,
     352,  2940,   353,  2971,   354,   355,   874,   875,   876,  1233,
    1234,  1792,  1795,  1540,  2146,   664,   665,   884,  3754,  3948,
    4068,   924,   356,   357,   358,   359,  1536,  2142,  1080,    76,
      84,    77,  1081,   395,   396,  2124,   360,   804,  2125,  1517,
    1060,  3219,   362,   363,   364,   365,   366,   921,   367,  1062,
     368,  1063,   369,   370,   371,   372,  1070,   373,  1519,  1520,
    3586,  1521,   374,   375,   685,   686,  1289,   376,   377,  1098,
    1099,  1100,  1305,  1869,  1559,  1560,  1561,   378,   679,   379,
     380,   381,  1550,  1551,   382,  2028,  2029,  2149,  2030,   383,
    2702,  2703,   384,  3186,  3187,  3836,  3188,   385,  2024,   386,
     387,  1027,  3224,   388,   800,   389,  1112,   666,   667,   668,
    1120,   790,   983,  1025,  1121,  2837,   792,   793,   670,   671,
     672,  1870,    78,  2710,  1871,  1433,  1434,  2019,  1435,  1436,
    1437,  1438,  1439,  1567,   676,  1088,  1281,  1282,  2711,  1284,
      82,  1285,   393,  3354,  1853,  1306
};

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
#define YYPACT_NINF -3712
static const int yypact[] =
{
   -3712,   343,  4637, -3712, -3712, -3712, -3712, -3712, -3712, -3712,
   -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712,
   -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712,
   -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712,
   -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712,
   -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712,
   -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712,
   -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712, 18421, -3712,
   -3712, -3712, -3712, -3712, 82697,   344, -3712, -3712, -3712, 44525,
   -3712, -3712, -3712,   219, 55383, -3712, 62919,   736, -3712, -3712,
   -3712, -3712, -3712, -3712, -3712, -3712, 69042, -3712, -3712, -3712,
   -3712, -3712, -3712, -3712, -3712, -3712, -3712, 47835,  1296, -3712,
     178, -3712, -3712, -3712, -3712, -3712, -3712, -3712,  1033,  6107,
   -3712, -3712, 59622, -3712,   407, -3712, -3712, -3712, -3712, -3712,
   -3712, -3712, 63390,   335, -3712,   689,  1027,    75, 11715, -3712,
   -3712, 45471, 57738, -3712, -3712, 69513,   868,   280,  7031,  1033,
   17947, 63861, -3712,  1532, -3712, 42123, -3712, -3712, -3712, 55854,
   -3712, -3712, -3712, -3712,   895, -3712, -3712, -3712, -3712, -3712,
   -3712, -3712, -3712, 69042,   297,   771, 42607, -3712, -3712, -3712,
   -3712, 69042, -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712,
   -3712, -3712, 64332, -3712,  1009,   534, 69984, 70455, 54912, -3712,
    1078, -3712, 69042,   602, 47363, -3712, 70926, -3712, -3712,   795,
   -3712, 58209, -3712, -3712, -3712, -3712,   771, -3712, 47835, 40199,
   58209,  1045,   864, -3712, -3712, 71397, -3712, -3712, -3712, -3712,
   -3712, -3712, -3712, -3712,  1507,   876, -3712, -3712, -3712, -3712,
   -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712,
   -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712,
   -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712,
   -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712,
   -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712,
   -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712,
   -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712,
   -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712,
   -3712, -3712, -3712, -3712,   335, -3712, -3712, -3712, -3712, -3712,
   -3712, -3712, -3712, -3712,   638, -3712,  1116,   866,  1512,   963,
   -3712, -3712, -3712, -3712,  6914, -3712, -3712, -3712, -3712, -3712,
   -3712, -3712, 84098,  1698, -3712, -3712, -3712,   972, -3712,  1058,
   -3712, -3712, -3712,  1572, -3712, -3712, -3712, -3712, -3712, -3712,
   -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712,
   -3712,  1361, -3712, -3712, -3712,  1460, 83164, -3712, -3712, 64803,
   -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712,
   -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712,
   -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712,
   -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712,
   -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712,
   -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712,
   -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712,
   -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712,
   -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712,
   -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712,
   -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712,
   -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712,
   -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712,
   -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712,
   -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712,
   -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712,
   -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712,
   -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712,
   -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712,
   -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712,
   -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712,
   -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712,
   -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712,
   44998, -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712,
   -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712,
   -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712,
   -3712, -3712, -3712, -3712, -3712,   132, -3712, -3712, -3712, -3712,
   -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712, 69042, 69042,
   -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712,
   -3712, -3712, 64803,  1110, -3712, -3712, -3712, -3712, -3712, -3712,
   -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712,
   -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712,
   -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712,
   -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712,
   -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712,
   -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712,
   -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712,
   -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712,
   -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712,
   -3712, -3712, -3712, -3712, -3712, -3712,   226,  1324, -3712, -3712,
   47835,  1844,  1844,  1588, 84098, -3712, -3712, -3712, 48779, 69042,
   69042, 69042,  1569, 48779, 69042, 60093, 36814, -3712, 69042, 69042,
   60093, 69042, 58209, 69042,  1279, 69042, 69042, 71868, 60093,  1418,
   -3712,  1735,    33, -3712, -3712, -3712, 60093,  8645,   297, -3712,
   -3712, 60093,  1380, 48779, 69042,  1293,  1404, 69042, -3712, 69042,
    1670,  1304, 69042,  1514, 37302,  1481, 69042, 69042, 69042, 69042,
   -3712, -3712,  1478, 69042, -3712, 69042, -3712, 72339,   758,  1501,
    1723,  1686,    45, -3712, -3712,  1452,  1440, -3712, -3712,  1877,
   64803, -3712, 60564, -3712, -3712, -3712,   101, -3712, 58209, -3712,
   -3712, -3712, -3712, 49251, 69042,  1732, -3712, 72810, -3712,  1817,
   49723, 73281, -3712, 37790,  1869, 73752, 74223, -3712, -3712, 74694,
   -3712, 75165,  1608, 75636, -3712, 76107, -3712,  1752, 76578, -3712,
   16204, -3712,  1486,  1935,  1502, -3712,   335,   105, -3712,   142,
     -15,   156, -3712, -3712,   -14,   225,   484,   105,  1553,  1553,
   61035, 69042,  1797, -3712, -3712, -3712,   358,  1574,  1574,  1574,
    1750,  -129, -3712,  1574, 60093, -3712, -3712, -3712, -3712, 58209,
     131, -3712, -3712,   297,    19,  1965, 69042, -3712, 69042, -3712,
   60093, 69042, -3712, -3712, -3712,  1978,  1617,  1864, -3712,  1598,
   -3712, -3712, -3712, -3712, -3712, -3712, -3712,  1803,  1807,  1856,
      -5,   297,  1715, -3712, -3712,  1863, 24231,   719, 64803,   297,
   43091, 58680, 80817,   127, 46417,   297, 77049,  1696,    33,  1868,
   -3712,   418, -3712,  2080,  1720,  1942,   -44,    33, -3712, -3712,
   34431, -3712,   499,  1719, -3712, -3712, 58209, 84565, -3712, -3712,
   -3712, 77520,  1855, -3712,  2037, 24724, -3712, 69042,  1762, -3712,
    1773,  1768,  1783, -3712, 60093,   997,   997,  2171,   997,  1515,
    1730, -3712,  2657, -3712,   864,  1033,  1787, -3712, -3712, -3712,
    1804, -3712,  1798,  1802, -3712,   228,  2084, -3712, -3712, -3712,
   -3712,  1916,  1925,  1951,  1988,  1893,  2010,   386, -3712, -3712,
   -3712, -3712,  2206, -3712, -3712, -3712, -3712, -3712, -3712, -3712,
    2326,  2330, 45471, 45471,  2015,   160,   125,   193, -3712, -3712,
   -3712,  2209, -3712, -3712,  2221, 69042,  2044, 69042, -3712, -3712,
   -3712, 77991, -3712, -3712,  1844,  1804,   499,  1983, -3712,   349,
   -3712, -3712,   369,   391,   414,   869,  1990,  1438,   112,  2034,
    3151,  2021,   823,  2881, 69042, 69042, -3712, -3712, -3712, -3712,
   -3712, -3712, -3712, -3712, -3712, -3712,  2022, -3712, -3712,  2013,
     -55,  1043,  4916,  1103,  3414,  1259,   517,  2212,  1425,  2322,
     991,  3660, 69042,  2039,  2275,   462, -3712,   841, -3712,  2117,
    2240,  2252, 48779,  2082, -3712, 69042, -3712, -3712, -3712, 48779,
   -3712,  2269, 38278, -3712, 69042, -3712, -3712, -3712, -3712,  2211,
   69042, -3712, -3712,  2333, 69042, -3712,  1574,   990,  2112,  2484,
   52083, 69042,  2158,  2522,  2165, -3712, -3712,  2158, -3712, -3712,
   69042, 69042,  2128,   951,  2158,  2523,  2524,  2198,  2301,   620,
    1164,    81,  2423,  2158, 60093, 60093, 60093,  2374, 69042, 78462,
   48779, 69042, 65274, -3712,  2134,  1452, -3712, -3712, -3712, -3712,
   -3712,  1015,  2199,  2440,  1983,   143,  2441,  2147,  2447, -3712,
    2191,  2448,  2021,  2451,  2152, -3712, 78933, 79404,  2453,  2022,
   69042,  2454,  2152,  2455,  2339,  2459,   143,  2460, -3712,   652,
    2461,  2346,  2462,  1469,  2152, 46890,  2465,   135, -3712, 16847,
   16204, -3712, 19832,  1391, -3712, -3712, -3712, -3712, -3712, -3712,
   27189,   482,  1685, -3712, -3712, -3712, -3712, -3712, -3712, -3712,
   -3712, 69042,  1797,  1797,   293, -3712, -3712,  2169, 69042, 69042,
   -3712, -3712, -3712, 56325, 69042, 59151, -3712,   352, -3712,   -12,
   69042, -3712,  1935, 52083,  2570, 69042,  2464,  2464,  2464, -3712,
   -3712, -3712,  2404, 69042,  2463,  2467, 56325, 69042, -3712, 79875,
    2182,  1497,  1003,   260,  1128, 27189,  2183,   217,   217,  2184,
   -3712, -3712, -3712,   434,  2186,  2190, -3712,   456,   456,  2347,
    2192,  2193, -3712,   460,  2194, -3712,  1159,   471,  2195,  2197,
    2202,  1980,   217, 27189, -3712,  2207,   456,  2208,  2210,  2213,
    1258,  2214, -3712,  1267,  2215,   285,   354,  2216,  2217, -3712,
    2192, -3712,   319,  2219,  2220,  2222,  2223,  2225,  2226,  2227,
   -3712, -3712, -3712, -3712, 27189, 27189, -3712, 23245, -3712,   297,
   -3712, -3712, -3712, -3712, -3712, -3712, -3712,    44, -3712,   477,
    9085, -3712, -3712,  2369, 27189, -3712, -3712,   136, -3712,   499,
     943, -3712, -3712, -3712, -3712,  1403, -3712, -3712, -3712, -3712,
    1632,  1632,   155, -3712, 59622, 59622, -3712, -3712,  1025,  2203,
   -3712,  1256, -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712,
   45944,  2608, -3712,  2771,   841,   198,  2555, 40671, 41155,  1797,
    1797,  2450, -3712, -3712, 60093, -3712, 27189, 39255, -3712,   499,
   -3712,    43,  2472, 69042, -3712, 34903, -3712,   335, -3712, 10992,
   -3712,  1570,  1762, 69042, 69042,  2629, -3712, -3712,  1773, -3712,
   -3712,  1512,  1512, 27189,  1512,   805,   968, 25217, 27189,  2518,
     939,  2519, -3712,  1515,  1730, -3712, -3712,  1804,  2242,  1651,
   -3712, 53970, 83631, 83631,  2489, -3712, -3712,  1222,   651,  2363,
    2458,  1553,  1282,  1224, -3712, -3712,  2244, -3712,  2576, 59622,
    2311, 45471, -3712, -3712,  2716, -3712,  2716, -3712, -3712,    91,
    2255, -3712,  2273, -3712, -3712,  1224,  1224, -3712,  2747, -3712,
    2262, -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712, 84098,
    2266, 69042, -3712,  2267,  2268, -3712, 84565,   499, 39727,  1557,
    2349,  2350, 47835,  2271,  2352,  2355, 81288, -3712, -3712, -3712,
   -3712,   444,   859,  2356,    89, -3712, 69042,  2468,   386,  2396,
   -3712,  2360,  2361,  2475,   386,   124, 81759, -3712, -3712, -3712,
   -3712, -3712,  1450, 21318, -3712, -3712, -3712,  2368,  2351,   780,
    2655,  2473,   820,  1728,   255, 60093,  2556,  2375,  2379,  2300,
    1253,  2313, -3712,  2362,  2376, 51139,  2490, 38766,  2400, 80817,
   -3712, -3712,  2402,  2403,   386, -3712,  2709,   386,   386,   838,
    2711,  2407,   447,  1257,  2158,  2313,  1676, -3712,  2332,  2408,
     481, -3712,  2509,    86,  1351,  2313,  2412,  2414, 69042, 69042,
   69042, 69042, 60093,  2416,  2419,  2469, 61506,  2420, -3712, -3712,
    2421,  1498,  2313,  1364, -3712,   394, -3712, -3712,    33, -3712,
   69042, -3712, 60093,  1983, 52083,  2520,  2021,   386, 69042, 69042,
    2022,    51,   802,  2529, 69042,  2598,  2398, -3712, -3712,  2158,
   -3712, 39727,  2128, -3712,  2359, -3712,  2410, -3712,  2410,  2410,
    2365,  2365,  2367, -3712, -3712,  1980,  2410,  2365, -3712, 53027,
   -3712,  1242,  1414, -3712,  2760,  2762, -3712, -3712, -3712, -3712,
   -3712, -3712, -3712, -3712, -3712,  1395, -3712,  1539, -3712, -3712,
   -3712,  2773, -3712, -3712, 52083, 69042, -3712,  2696,  2432, 47835,
   -3712,  2424, -3712, 69042,   170,   297,  2426, 69042,  2600, 69042,
   69042, 69042, 69042, -3712, -3712,  1101,     6, -3712, 61506, -3712,
    1676,  2779,   541,  1574, 46417,  2669, 69042,  2563, -3712,  2387,
    2787, -3712, -3712,  2393,  1553, -3712,  2134, -3712,  1707, -3712,
    2512, -3712, 30626,  2433, 48779,   143, -3712, -3712, -3712, -3712,
   52083, 69042, 80346, 48779,   143, 69042, 69042,  2690,  2456,  2694,
    2457, 38766,   143,   137, 69042, 69042, 60093, 69042, -3712, 69042,
   -3712, -3712, -3712, -3712, 69042, 60093, 69042, 61506,  2698,  2699,
     143, 69042, 69042, -3712, -3712, 17325,  1458, -3712, 16204, -3712,
   10992,  1578,  1797, -3712,  1110,   828, 69042, 64803, -3712, -3712,
   -3712, -3712, -3712, -3712, -3712, -3712,  1797, -3712, -3712,  2887,
    2405, -3712,  1403, 69042,  1602, -3712, -3712,  1610, 69042,   241,
   48779, 69042, 69042, 60093, 60093, 69042,  2483,  2203,   714, -3712,
    2471, 33959,  2537, -3712,   224, 58209,  2602, -3712, -3712, -3712,
    1619,  1384,   324, -3712, -3712, -3712, -3712, -3712, -3712, 59151,
   55854,  2689,   -40, 69042, -3712, 27189, 23738, -3712, -3712, -3712,
    2409, 10992,  2470, 27189, -3712, -3712, 27189,  1553,  1553, 27189,
   -3712, -3712, -3712, -3712,  2060,  1553, -3712, 27189, 27189,  1553,
    1553,  2410,  2410, -3712,  4947, 27189, -3712, 38766, 27189, 28668,
   20824, 27189,  2494,  2445,  1553, -3712,  1553, -3712, 27189, 22752,
   -3712, 27189,  2625, 27189,   198,  2626, 27189,   198,  2850,  2850,
     864,  1836,  5548,  2429, -3712,  2543,  1553, -3712,  1553,  1215,
   52083, 27189, 47835,  2514,   119, 27189,  2436,  2089, -3712, 27189,
    1141, -3712,  2439, 27189,  2532,   169, 27189, 27189, 27189, 27189,
   27189, 27189, 27189, 27189, 27189, -3712, 29161,   361, -3712,   463,
     161, 56796, 24231,  2722, -3712,   233, 20330, -3712, 64803, -3712,
   -3712,   499, -3712, -3712, -3712, -3712, -3712,    91,  2443, -3712,
    2474, -3712, -3712, -3712, -3712, -3712, 60093,  2608, -3712, -3712,
    2531, -3712, -3712, -3712, -3712,   948, -3712, -3712, -3712, -3712,
   -3712, -3712, -3712, -3712, -3712, -3712, -3712,  2476, -3712, -3712,
   -3712, -3712, -3712,  2476, -3712, -3712,  1797,  2466,  3234, -3712,
   -3712, -3712, -3712,  2728,  2729,   143, 84098, -3712, 69042,   107,
   -3712, -3712, -3712,  2477, -3712, 57267, -3712, 24724, -3712,  1628,
    2192, -3712,  2710, -3712,  2479, -3712,  9545,  2710, -3712, -3712,
      93,  2621,  2647,  2647, -3712,   432, 10992,  2695,  1829, 10992,
    1860, -3712, -3712, -3712, -3712,   -83, -3712,  2518,   939,  1758,
   -3712,  1804, -3712, -3712, 18893, -3712, 19367, -3712, -3712, -3712,
   -3712, -3712, -3712, -3712, -3712, -3712,  2493, -3712, -3712, -3712,
   -3712,   386,  2495,  2933, -3712, 45471, -3712, -3712, -3712,  1877,
   -3712,  1877,  2958, -3712, -3712, -3712, -3712, 64803,  1537, -3712,
   16204, -3712, 16204, -3712,  2496,  1644,  2554,  2558,  2599, 69042,
   69042, -3712, 47835, 69042, 69042, 69042, -3712,  2853,  2501, 69042,
    2741,  2742,  2510, -3712, -3712, 69042, -3712,  2701, 69042, 27189,
    2705, 69042,  1156,  2707, -3712,  1202, 69042, 69042,  2700, -3712,
   -3712, -3712, 46417, -3712, -3712, -3712,  2691, -3712, -3712, 53027,
   -3712, -3712,  1657, -3712, 52555, 50195, -3712, -3712,  1023, 69042,
   69042, -3712, -3712, 69042, 69042, 69042, 69042, 61977, 69042, 69042,
    1122,  1172, 69042, 62448, -3712, 60093, 69042, 69042, 47835, -3712,
   69042,  2703,   812, -3712,  2391, 69042, 69042,  2521,  1681,  2604,
   -3712, 69042, 10114, 69042, 69042, -3712, -3712,   386, -3712, -3712,
   -3712, -3712, -3712, 69042, 69042,   386, 69042,   386,  1170, -3712,
   48307, 69042, -3712, -3712, -3712, 69042, 69042, 69042, 69042, 69042,
    1315,   -80,  2660,  2667,  2668, 69042, 69042, 69042, -3712, -3712,
    2644, -3712, 69042, 10114, 69042, 69042,  2610,  2611,    77,  2681,
   -3712, -3712, -3712, -3712, -3712,  2780,  2935, 69042,  2781,  2782,
    2601,  2612,  2793,  1075, 69042, 69042, 69042, 69042, 69042, 69042,
    2804,  1075,  2726,    21, -3712,  1693, -3712,  2575, -3712, 27189,
    2963, 52083,  2567,  2568,  2646, -3712,  2648,  1553, -3712,  1711,
   -3712,  1101,  1092, -3712,   -31, 10114,  2856, 69042,  1697, -3712,
    2589, 60093, 10114, -3712,  1269, 55854, -3712, -3712, -3712, -3712,
   -3712, -3712, -3712, -3712, -3712,  2862, -3712,   297,  2128,  2128,
    2128,  2128, -3712, -3712, -3712, -3712,  1483, -3712,  2579, 69042,
    2697, 10114, -3712,  1676,  2879, 60093, 54441,  1861,  2981,  2857,
     297,  2765, 60093, 21798,  4077, -3712, 65274, -3712,  2592,  2860,
    2861,  2878, -3712, 30147, 65745,  2590,  2189, -3712, 65745, 66216,
   -3712,   499,  2595, 25710,  2537,  1983, -3712,  2996, -3712,  2895,
     143,  2021, -3712,  2152, -3712, 69042, 69042, 69042, 69042,  2022,
   -3712, -3712,  2152,  2794,   143,   143, -3712,  2795,   143,  2152,
    2712,  2889, 46417, -3712,   135, -3712, -3712, -3712, -3712, -3712,
   27189, -3712, -3712,  2704, -3712, -3712, 64803,  1877, -3712,  1713,
   -3712, 69042, -3712,  2152,  2651, 69042,  2615, -3712,  2152,  2152,
    2203,  2203,  2152, 66687,  3031,  2898, -3712,  1729, -3712, -3712,
   24231, -3712,    35, -3712,    63,   855,  2835, -3712, -3712, -3712,
   -3712, 52083, -3712, -3712, -3712, -3712, -3712, 69042,   120,  2806,
    2624, 66687,  3007,   143, -3712,  1739, -3712,  1506, -3712,  1524,
   27189, 27189,   213, -3712, 10252,  1740,  2630,  2631,  1765, -3712,
   -3712, -3712, -3712, -3712, -3712,  2632,  2916, -3712, -3712,  2634,
    1769,  1777,  2635,  2636, -3712, -3712,  3807,  2637,  9749,  2638,
   28668, 28668,   622, -3712, -3712, 28668,  2639, -3712,  1786,  9658,
    2640,  2643,  2666, -3712,  2650,  2652, 10684, 26203, 27189, 26203,
   26203,  6407,  2640,  2654,  1815, 47835, 11289,  1823, -3712, 27189,
   47835,  5520, 27189, -3712, 27189, 69042,  2656,  2658, -3712, -3712,
    4947, -3712,  2670, -3712, 28668, 28668,  2318, 23245, -3712, -3712,
    2929, -3712, -3712,  1809, -3712,  2649, -3712, -3712,  4254,   145,
   27189,  2436, 27189,  2734, 38766,  4334, 27189,  3589,  3927,  3927,
     230,   230,    98,    98,    98,   249,   161, -3712, -3712, -3712,
    2663,  2214, 27189, -3712,  3131,  1814,  1912, 60093,  6524,  9518,
   -3712, -3712, -3712, 30626,  2713, 27189, 27189, 27189,  2664,  2837,
    1830, -3712, -3712, -3712,  2345,  2958,    91, -3712,    33,  1553,
    1215, 41639, -3712, -3712, -3712, 27189, -3712, -3712, -3712, -3712,
   -3712,  1841, 34903,  2433, 24724,   499, -3712, -3712, -3712, -3712,
   -3712, 27189, -3712, -3712,  2909,  1835, 27189,  1829, -3712, -3712,
   60093,  2602,  2602, 27189, 27189, 25217, -3712, -3712,  2959, -3712,
   -3712, -3712, -3712,  1412, -3712, -3712, -3712, -3712, -3712, -3712,
    2672, -3712,  2671, -3712,  2680, -3712, -3712, -3712, -3712,   126,
    2676,  2677,  2683,  1271, -3712, -3712, 69042, 69042, 69042, -3712,
   -3712, -3712, -3712, -3712, -3712,  2913, -3712, 27189,   141,  2682,
    2687, 69042,   143, -3712, -3712, 10992, -3712, -3712,  2744,  2749,
   69042,  2509, -3712,  2944, -3712, -3712, -3712, -3712,  2882, -3712,
   -3712,  1539, -3712, 50195, 52555, -3712, 52555, -3712,  1539,  1411,
   -3712,  2152, -3712, 52083,   492, -3712, -3712, -3712, -3712, -3712,
     143,   143, 69042, 69042, 69042, 69042, -3712, -3712, -3712, -3712,
   -3712, -3712, -3712,  1851, -3712,   932, -3712, -3712, -3712, -3712,
   -3712,  1422, -3712,   887, 52083, -3712, 51611, 69042, -3712, 69042,
    2921, -3712, -3712, -3712,  2859,    53, -3712, -3712, -3712, -3712,
   -3712, -3712, -3712, -3712,  1079, 69042, -3712,  1553,  2863, 69042,
    2759, -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712,
   47835, 47835, 47835,  1852, -3712, -3712,   297, -3712, -3712, -3712,
    2783, -3712, -3712, -3712,  2922,  2925,  2927,  2789,  2790,  2791,
    2796, -3712,  2797,  2799,  2800, -3712, -3712, -3712, 69042, -3712,
   -3712, -3712, 69042, 69042, -3712, -3712, -3712,  1075, 52083,  2946,
    1075,  1075, 69042, 69042,  1075, -3712, -3712, -3712,  2960,  2966,
    2967,  2968,  2970,  2972,  1075, -3712, -3712, -3712, -3712,   990,
    2418, -3712,   101, 36326,  5590,  2717,  2568,  2715,  1553, 32529,
     890,  2942,  2731, -3712,  1494,  2961,  2748,  2748,  2748,  2748,
    2748,  2748,  2748, -3712,  2005, -3712,  2914,  2808, -3712, -3712,
   47835, 36326,  1574,   170,  2876,  1226,  3075, -3712, -3712, -3712,
   -3712, -3712, 60093,  1101,   297,  1882, -3712, 52083, 69042, 64803,
    1507,  2745, 60093,  2743,  2746, -3712, -3712, -3712, -3712,  1883,
   -3712, 52083,   -59,  2936,  2939,  1507, 69042,  2831, 60093,  2818,
   -3712,  1886,    39, -3712,   297, 46417, 50667, -3712,  3071, -3712,
   -3712,  2941, -3712, 69042, -3712, -3712, 33487, 32056,  2189,  2764,
   69042, -3712,  2767, 30626,  3009,  2947, -3712, 30626,  2947,   944,
    2947,  3012, -3712, 35375, -3712,  2774,  1472, 20330,  2962, 10992,
   -3712,   143, 52083, 69042, -3712,   143,  2838,   143,  2839,   143,
     143, 60093, -3712, -3712, 60093, -3712, 69042, 61506,   143, -3712,
   10992, 60093,  1201, -3712, -3712, -3712, -3712, 69042,  2152, 48779,
   69042,   923, -3712, -3712,  2965, -3712,  1507, 69042,   499,   185,
   -3712, -3712, -3712, -3712,  3081,  3082, -3712, -3712, -3712, 69042,
   56325,   201, 69042, -3712, -3712, -3712, -3712,  2798,  1887, 10961,
   27189, -3712,  3093, 52083, -3712, -3712, -3712, -3712, -3712, 27189,
   -3712, -3712, -3712, -3712, -3712, 27189, -3712, 27189,  3074, -3712,
    3220,  3220, 52083, 28668,  1347,  2208, 28668, 28668, 28668, 28668,
   28668, 28668, 28668, 28668, 28668, 29654,   313, -3712, -3712, 27189,
   27189,  3084,  3074, -3712, -3712,  1339,  1339, 52083,  2801,  2640,
    2802,  2809, 27189, -3712, -3712,  1897, 47835, -3712, 27189,  9950,
    1900,  2843, 11579,   499,  5862, -3712,  3171,   297, 27189,  1731,
    1764, 27189,  1904, 27189,  3083, -3712, -3712, -3712,  2805, -3712,
   -3712, 52083, 27189, 28668, 28668,  5920, -3712,  6521, 27189,  2811,
    7321, 23245, -3712,   771,   771,   771,   771, -3712, 60093, 60093,
    2590, 27189,  3089,  1910,  1914,  6547,  2837, 35847, -3712,   149,
   26696, -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712,
   -3712, -3712, -3712, -3712, -3712, -3712,  2813, -3712,  2812, -3712,
   -3712,   841,  2822, -3712, -3712,  5891,   126,  2820, 69042, -3712,
    2537, -3712, -3712,  2824, -3712,  1835, -3712, -3712, -3712,  6845,
    2988,  2203, -3712, -3712, -3712, -3712, -3712,   805,  1553,  2840,
   -3712,  1877,  2345, -3712, -3712, -3712, -3712, -3712, -3712, -3712,
   -3712,  2748,  7744, -3712, 69042, 69042,  1915, -3712, -3712, 69042,
   -3712,  1990, -3712, -3712,  3078,  1442, -3712, -3712, -3712,  2899,
   -3712,   656,  1233, -3712,  2900, -3712, -3712, -3712, -3712, -3712,
   -3712, -3712, 47835, 36326, 47835,  2907,  2911,   514,   966,  2915,
    2917,  2834,  2841,  2842, -3712,  2152,   105,   297, 69042, 69042,
   -3712, -3712,  2152, -3712,   297,  2152,   297, -3712, -3712, -3712,
   -3712, 48307, -3712, -3712, 69042,  3123,   111,  1593, 69042, 69042,
   69042, 69042, 69042, 69042, 69042,  2509, -3712, -3712, -3712,  2845,
    1075, -3712, -3712,  3087,  3090, -3712,  1075,  1075,  1075,  1075,
    1075,  1075, -3712,   173, -3712, -3712,  2522,  2522,    11, -3712,
    2522, -3712,  2522, -3712, -3712,  2575,  2824,  1553,  1224, -3712,
   -3712, -3712, -3712, -3712, -3712,   104,  1553,  1902,  2851, -3712,
   33008, -3712, -3712, -3712,  1808,  1215, 60093,  2748, -3712,   611,
     958,   994,  1248, 67158, 67629, 68100,  2849, 69042, 28668, -3712,
    1037,   144, -3712,  3080, 60093,  2893, -3712, -3712, -3712,  2854,
   -3712, 52083, -3712, -3712,  3252,   828, 60093,  2896,  3142, -3712,
    1919, -3712, -3712, 69042, -3712,  2914,  1502,  2905, 54441, -3712,
    3114, 54441, -3712, 69042, -3712, -3712, -3712,  3221,  2953,  2910,
     -31,   297,  2818, 69042,  2868, -3712, 50195, 27189, 27189, -3712,
    2867, -3712,  2873,  4800, -3712,  2128, -3712, -3712,   491,  2891,
   -3712, -3712, 65745,  2883, 69042,  2189, 30626, -3712, -3712,  2243,
   -3712, 30626,  3116, -3712, 30626, 69042,  2884, 69042,  1920, 43570,
   -3712,  2880,   143, -3712, 69042, -3712, 69042, -3712, -3712,   143,
     143, -3712,  2992, -3712,  2892,  1707,  2152, -3712, -3712,  3160,
   66687, -3712, -3712, -3712, -3712, -3712, -3712, -3712,   -40,  3173,
   -3712, -3712, -3712, -3712, 27189, 10992, -3712,  2906, 10992,  7785,
   10992,  3084, -3712,  2564,  3188, -3712,   793,  2918,  2564,   329,
     329,   168,   168,    96,    96,    96,  3220,   313, 10992, 10992,
   -3712, -3712, -3712, -3712,  2908, -3712, -3712, -3712,  2640, -3712,
   27682, -3712, -3712,  2954,  2956,  2920, -3712, 27189, 28175,  2912,
   53027, -3712, -3712,  1215,  2850, 28668, 28668,  1094, -3712,   350,
   27189, 52083,  1927,  1094,  2006,  2497, 27189, 27189,  7416,   365,
   27189,  7993, 60093, 60093, 60093, 60093, -3712, -3712, 10992,  3293,
    3187,  2837,  2837,  2837, -3712, 82230, -3712, -3712, -3712, -3712,
   27189,  2345,   982,   297, -3712, -3712,   864, -3712, -3712, 38766,
   -3712, -3712, -3712,    93, -3712, 16204, -3712, -3712, -3712,   105,
   -3712,  1930,  1934,  2893, -3712,  2271, -3712,  2985, -3712,  2005,
    3109, -3712,  3112,   105, 69042, 52083, -3712, -3712,  2937, 69042,
   69042,  1553,  1553, 52083,  2923, -3712,  1553,  1553,  2924, -3712,
   69042, 69042, -3712, -3712, -3712, -3712, -3712,  2152,  2152, -3712,
   -3712, -3712, -3712, 69042, 69042, 69042, 69042,  3222, -3712, -3712,
   -3712, -3712, -3712, -3712, -3712, -3712,  3174, -3712,  1075,  1075,
   -3712, -3712, -3712, -3712, -3712, -3712, -3712,  2158,  3253,   297,
     297,  3124, 69042,   297,   297, -3712,  1180,  3260, -3712,  3195,
     794,  2943,  1356,  3224, -3712,  1484, 33008, 33008, 33008, 33008,
   33008, -3712, -3712,  3227,   105, -3712, -3712, -3712, -3712, -3712,
   -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712,
   27189,  2109,  2564, -3712, -3712, -3712, -3712,  2893,  1574,  2998,
   47835,  3004,  1507,   634, 69042,  3257,  3247, -3712,   297, -3712,
   -3712, -3712,   556, -3712,  2949,  1173,  2951,  1861, -3712, -3712,
   -3712,   792, 69042, -3712,  1115, -3712,  3190,  3235,  2964, -3712,
   31105, -3712, 10992, 10992,   297, 53499,  3071, -3712, -3712, -3712,
   -3712, -3712,  3034, 69042, -3712, -3712, 69042,  1955, -3712, 27189,
    2973, -3712, -3712, 30626,  2243,  1960, 69042,  1971, 52083,  2837,
   -3712, -3712,   143, -3712,   143,   143, -3712, -3712, 69042, 69042,
    3249,  3137, -3712,   143, 66687, 10992, -3712, -3712, -3712, 28668,
    3245, -3712,  2976, 52083, -3712,  2978,  1972,  2003, -3712, -3712,
   -3712,  8108,  3020, 10992,  3069,  2969,  2979, -3712,   408,   408,
     350,  2004, -3712, 28668, 28668,  1094,  1094, 27189,  1094, -3712,
   -3712, -3712, -3712, -3712, 27189, 27189,  3021, -3712, -3712, -3712,
    3145, -3712,  8348, -3712,  1224, -3712, -3712, -3712, -3712,  1215,
   -3712,  2982,  1829, -3712, -3712,  3127,  2893,  2998, -3712, -3712,
   -3712, -3712, -3712,  3040, 36326, -3712, -3712, 31584, 38766, -3712,
     514,  2986,  2987,   966, -3712, -3712,  1013,   437,  3030,  2152,
    3277,  1075, -3712, -3712, -3712,   297, -3712, -3712, 69042,  2990,
   -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712, 48779,  3393,
    3393, -3712,  1538,  1538, -3712, -3712, -3712, 60093,   104, -3712,
    8482,  3185, -3712,  2998,  3213,  3259, -3712,  2011, -3712, 69042,
    2910, 54441,  2914, -3712,  1221,  3147, -3712, -3712,  3334,  1861,
    1007,  1286, -3712, 60093,  2939,  3128, -3712,  3129, -3712,  3374,
    3184,  3380,   297, -3712, 69042, 31105, 27189,  2017, -3712, 68571,
   22271, -3712, 52555, -3712,  2024, -3712, -3712, 60093, -3712,  3023,
    2027, -3712, 10992, 69042, -3712, -3712, -3712,  2046, -3712, -3712,
   -3712, -3712, -3712,  1507, -3712, -3712,   201,   393, 28668, 52083,
    2051, 27189, -3712, 27189, -3712, -3712, -3712,   -37, -3712, -3712,
   -3712,   408,   408,  1094,  2640, 10992, 69042, -3712,  3394,  3186,
    2837, -3712, -3712, -3712, -3712,  3193, 60093,  2998, -3712, 27189,
   -3712, -3712, 52083,  2021,   -79, -3712, 52083, 52083, -3712, 69042,
   69042, 69042, 69042, 69042, -3712,  2418, -3712,  2990,  3393,   176,
   -3712, -3712, -3712,  3302, -3712, -3712,   664,  3196,  3104, -3712,
   47835,  3312, -3712, -3712, -3712, -3712, -3712, 48779, -3712,  2939,
   -3712, -3712, -3712, -3712, -3712, -3712,  2063,  2953, -3712, -3712,
    3199, -3712,  3200, -3712, -3712,  2064,  8815,  3067, 31105, 69042,
   -3712,  1363,  1363, -3712,  4800, 53499,  2713,   103,  3044, -3712,
    2067, -3712, -3712,   393,  2076, -3712,  2077,  2085,  3085, -3712,
    3029, -3712,  3432, 27189,  1230, -3712, -3712, -3712,  1574, -3712,
   10992,  2086, -3712, -3712, -3712,  3179,  2090,  2103,  3033,  3079,
    3033, -3712,  2152, -3712, -3712, -3712,  3346, -3712, -3712, -3712,
     151, -3712,  3223,  3225, 69042, -3712, 69042,  3439,  3046,  2953,
   -3712, -3712, -3712, -3712,  3067, 68571,  2300,  2953, -3712, -3712,
    1835,  1835,  3071, -3712,  3358, -3712, -3712, -3712, 69042, -3712,
   -3712, -3712, -3712, -3712, 69042,  3048,  2640,   133,   133,  3049,
    3213, 48779, -3712, -3712, -3712, 69042,  3176,   560,   560,  3376,
   -3712,  3115, -3712, -3712, -3712,   514, 44048, -3712,  2953,  1363,
   -3712,  2713, -3712, -3712, -3712,   623, -3712, -3712, -3712,    67,
    3183,   653, -3712, -3712, -3712, -3712,  3196,  2021, -3712,  3359,
   -3712,  3473, -3712,   600, -3712, -3712,  2923, -3712,  2107, -3712,
   -3712, -3712, -3712, -3712, -3712,  2713,  1835, -3712, -3712, -3712,
    1674,  3464, -3712, -3712, -3712,   104, -3712,  3214, -3712, -3712,
   -3712, -3712, 44048, -3712, -3712, -3712,  1866, -3712, -3712, -3712,
   -3712, -3712, -3712, -3712,    67, -3712, 48779, -3712,  1343, -3712,
   -3712,  1371,  1783, -3712,  3063, -3712,  1866, 44048, -3712,  2119,
   -3712
};

/* YYPGOTO[NTERM-NUM].  */
static const short yypgoto[] =
{
   -3712, -3712,  3210, -3712, -1112, -1376, -3712, -3712, -3712, -3712,
   -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712,
    1212, -3712, -3712,   -97,  1526,  2098,   916, -3712, -3712, -3712,
   -3712,  -975,   190,   442, -3712, -3712, -3712, -3712, -3712, -3712,
   -3712,   745,  1328,   804, -1105, -3712, -1610,  -551, -3712,   312,
   -3712, -3712, -3712,   686,  -298, -3712, -3712, -3712, -3712, -3712,
   -1675,  -124,   179, -3712,   177,  1357,   331, -3712,  -119, -3712,
   -3712, -3712, -3712,  -596,   856,  -912, -1287,  1124,  -564,  -599,
    -525,  -523,  -567, -3712, -3028, -3057, -2408, -2488, -3712, -3712,
   -3712,   192, -3712, -1671, -3712, -3712,  1813, -1523, -3712,  -853,
   -3712, -3712,   640,  1406,   189, -3712, -3712,   -24, -3712, -3712,
   -3712, -3712, -3712, -3712, -3244, -3712, -1597, -3712,   309, -2720,
     772, -3712, -3712, -3712,  1839, -3712, -3712, -3712, -3712, -1697,
   -3712, -3712, -1664, -3712,  1266,   676, -3712, -3712, -3712,  -636,
    -610, -3712, -3711,   -57,   -53, -3712, -3712, -3712, -3712, -1181,
   -3712,   697, -2790, -1101, -3712, -3712,   727, -3712, -3712,  -544,
    -238,  1867, -3712,  -472, -3712, -3712, -3712,  -236, -3712, -3712,
   -3712, -3712, -3712, -3712, -1806,  3627, -1080, -3712, -3712, -3712,
   -3712, -2098, -3712,  3443,   680, -1661, -3712,  -146,  -122,  2315,
   -1270, -2426,   163, -3712, -3712, -1849, -3712, -3712, -3712, -2362,
   -1659, -3712,   222,  -304,  -423, -3667, -2528, -3082, -3712, -3712,
   -1247, -3712, -3712, -3712, -1514,  1424, -2180, -3712, -2154,   227,
   -3286,  -978, -2885, -3712, -3245,  -425, -3712, -3712, -3712, -3712,
   -3712, -3712, -3712, -1244,  -848, -3712, -3031, -3712, -3712, -3712,
   -3712,  1046, -3712,   -95, -3712, -3712, -3712, -3712, -3712,  -562,
    -592, -3712, -3712, -3712,   278, -3712, -3712, -3712,  1647, -1137,
    -945,  2642, -1648,  -259, -3712, -3712, -3712, -3712, -2716, -3712,
   -3712, -3712, -3712, -3712, -3712, -3712, -1234, -3712, -3712, -3712,
   -3712, -3712, -3712,  1571,  3492,  -216, -3712, -3712,  2168, -3712,
   -3712, -3712, -3712, -3712, -3712,  2381,   271,   -35, -3712, -3712,
     631, -2285,   -26, -3712, -3712, -3712, -3712,  -245,   -25, -3712,
    1017, -3712, -3712, -1972, -3712,  2389,  1228,   218,   -62,   -67,
    -241,  -220,  -185, -3712,  2653,  2196, -3712, -3712,  -206,  1232,
   -3712, -1045, -1044, -3712,  1014,  -895,  1566,  1002,   108,  -234,
   -3712, -2598,   476, -3712, -3712,  -891,  1577, -3712,  2177,  1592,
   -3712,  1620,  1065, -2307,  1297, -2289,   717,  -624,   -54,  -136,
    2685,  2819, -3712, -3009,  1049, -3201,   321,  1004, -1975, -1680,
   -3712, -3712, -1307,  8975, -3712, -3712, -3712,  9775, 11295, -3712,
   -3712, 12808, 13038, -3712, -1201,   591, 13215,  6746, -1327, -1724,
   -1420, 12115,    14, -1030, -1729, -3712, -3712, -3712,  -250,   610,
     -49, -3712, -3712, -3712,  -415, -2547,  -414, -3712, -3712, -3712,
    -416, -3400, -1792, -3712,  -812, -3712, 13932,  1060, -3712,  -898,
   -1305, -1828, -3712, -3712, -3712, -3712, -3712, -3712, -3712, -1440,
   -2927,  -512,  1136, -3712, -3712,  1227, -3712, -3712, -3712, -1375,
   -1039, -1934,  1139, -1952, -3712, -1041,  1260,  1734, 10197,  -989,
    1780,  -831,  4406,  -141, -2148, -1443, -1084, -3712,  -372, -3712,
      25,  2378,  -163,   -92,   165,   -39, -2766, -3712, -3712, -3712,
    2449, -3712, -3712, -3712, -3712, -3712,  3113,   774, -3712,  2513,
   -3712,  1353,  1954, -3712, -3712,  1607,  -933,   -50, -3712,  -385,
   -3712,  -135, -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712,
   -3712, -3712, -3712, -3712, -3712,  2231,   128, -3712,   -52, -3712,
   -3712, -3712, -3712, -3712,  3392,  -306, -3712,  2836,  -290, -3712,
   -3712, -3712, -3712, -3712, -3712, -3712, -3712, -3712,  2239,  1636,
   -3712,  2645, -3712, -3712, -3712,   -61,  2437, -3712, -3712, -3712,
   -1150,  1389,  2673,  -935,  1603, -3712, -3712, -3712, -3712, -3712,
   -3712, -3712, -3712,  1611, -3712, -3712,  1119, -1963,  1613, -3712,
   -3712,   545, -3712, -3712,   199, -3712,   547, -3712,  2331, -3712,
   -3712, -3712,   575, -3712, -3712, -3712,  -595,  9704,   207,   123,
     -84,   848, -3712,  5649,  5817,  -103,  2253,    48,  7532, 11914,
     171, -3712,  3381,  1616,  1318,  -983,    49,  1908,   998,   332,
   -1096,     7,    -2, -3712,  2390,  -638, -1140,  2503,  -750, -1790,
   -3712,  3781, -3712, -2635, -3712,  -988
};

/* YYTABLE[YYPACT[STATE-NUM]].  What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule which
   number is the opposite.  If zero, do what YYDEFACT says.
   If YYTABLE_NINF, syntax error.  */
#define YYTABLE_NINF -2298
static const short yytable[] =
{
      80,  1564,   944,  1042,  1147,  1814,  1212,  1513,  1514,    79,
     873,   344,  1449,  1515,   791,  1822,   343,   885,  1900,  2239,
    1026,  2338,  1877,   944,   868,   786,   361,    74,  1472,  1456,
    1689,  2467,   398,   789,  2754,  2444,  1311,  1312,  1640,   351,
    1777,  1316,  1147,   338,   684,   351,  1583,   951,  1678,  2330,
    1930,  1931,   339,   341,  1096,  1259,  1057,   791,  2448,  1957,
    2755,  2757,   989,  1464,  2644,  2274,  1911,   964,   786,  1946,
    1254,   830,  1058,  2410,  1262,  3051,   789,  1577,   351,  3210,
     842,  2380,   684,  3426,  1274,  1021,   990,   675,  2508,  2357,
    1752,  1147,  3168,  2358,  1031,  1756,  2978,  1712,  2793,  2213,
    2359,   877,  1762,  2360,  2072,  2361,  2660,  2131,  2133,  2134,
    3287,  1779,  3289,  3035,  1562,   980,  2362,  1010,  1044,  2992,
    2994,   351,   980,  3580,   980,   791,   391,  3343,  1052,  3000,
    3709,  3383,   391,  2269,   917,  2668,   786,  3746,   673,  2171,
    2440,  1852,  1847,  1805,   789,  1787,  1924,  1925,  2693,   878,
    2665,  3720,  1611,  1091,  1509,  3343,  3223,  2544,  1510,  1542,
    1543,  1828,  1558,  1053,   413,  2026,   413,  3082,  1975,  1980,
    1283,  1943,  1843,    35,  3510,    35,   413,  1041,   413,  1776,
    2502,    41,   957,    41,  2709,   840,  2073,  4023,  2713,   351,
     943,  3360,  3361,  3362,  3363,  3364,  3365,  1591,   413,  2918,
    2378,  1983,  2072,    37,    38,    39,    40,  1113,  1304,  3417,
    1337,   943,   397,  2864,   945,   413,   801,  2623,   802,  2221,
    4180,  2583,  1894,  2885,  1534,    37,    38,    39,    40,   413,
    1553,  1294,  1980,  3040,  1322,   945,  2887, -1675, -1705,  3082,
     788,  4179,  1237,   350,  3765,  1296,  3767,  2583,   677,   350,
    2849,  1101,  1806,  1524,  1806,  2578,  3404,  4078, -1474,  2189,
    1806,  3042,  1230,  2738,  1983, -1474,   413,  2178,   259,    37,
      38,    39,    40,  4062,  4093,  3278,  3665,  4104,  3007,  2850,
    3009,  1051,   350,   788,  1706,   390,  4180,   344,   795,  1164,
    1314,   390,   343, -1266, -1266, -1266, -1266,  1453,  2200,  1592,
    1840,  1980,  2293,  1854,  1638,  2313,  2102,  2482,   207, -1578,
   -1578, -1578, -1578,  3661,  1867,  1868,  3705,  2354,  1806,   338,
    1980,  3634,  2633,   351,   390,   350,  4157,  1689,   339,   341,
    1553,   795,  1639,  1983,  1700,  3049, -1266, -1266, -1266, -1266,
    2048, -1266, -1722,     3,  1085,  3666,   932,  2230,  3847,  1087,
    -328,   788,  1983,  2180,  2103,  2896,   316,   351,   399,  3662,
    1442, -1276, -1276, -1276, -1276,   933,   413,   390,  2314,   889,
    1147,  1315,   981,    37,    38,    39,    40,  2201,   985,   981,
    2345,   981,  2049,  1165,  3082,   985,  2352,   985,  2011,  2355,
    2015,  2190,  1851,   350, -1614, -1261, -1261, -1261, -1261,   795,
    3082,  1587,  3060,  2381,  2464,  1957,  3667,  2074, -1678,  4105,
     391,  2740,  1546,  1930,  1931,  1987,  1988,  1759,  1635,  1231,
    1946,  1980,  2483,  3279,  3041, -2296, -2296, -2296, -2296,  1823,
   -1276, -1276, -1276, -1276,  4079,   390,  1117,  1304,  2238,  2014,
    2888,  1131,  1593, -1261,   391, -2297, -2297, -2297, -2297,  2308,
    2617,  3706,  3043,  1983, -1490,  1333,  2312,  2618,  4169,   413,
    1816, -1490,  3903,   678,  3082,  2191,  1991, -2294, -2294, -2294,
   -2294,  1198,  3635,  3607,  1102,  3167,  1525, -1723,  2110,  3082,
     803,  2064,  2065,  1888,  2181,  2039, -1675, -1705,  1895,   873,
   -2293, -2293, -2293, -2293,  1902,  1315,  4181,  3343,  1115,  1594,
    1807,  3946,  1807,  2379,  4235,  2275,  1912,  2865,  1807,  1973,
   -1883, -1883, -1883, -1883,  1058,  3589,  1323,  1924,  1925,  1575,
    -125,  1244,  1890,  3418,  1084,  1943,  2584,   350,  1252,  2330,
    1846,  2328, -1233, -1233, -1233, -1233, -1246, -1246, -1246, -1246,
    2265,  1976,  2267,  1895,   259,  3038, -1722, -1273, -1273, -1273,
   -1273,  2302,  3143,    37,    38,    39,    40,    37,    38,    39,
      40,   350,  4181, -1474,  3788,  3957,  1807,  3084,  1549,   390,
    2178,  1092,   244,    58,  2182,    58,   831,    55,  1759,    55,
     877,   938,   939,  3084,  2179,    58,  2459,    58,  4158,  3094,
    2676,  2004,  2305,   938,   939,  2742,  2484,  2324,  2027,  1544,
    3247,  3997,  3248,   390, -2298,    57,  2303,  2662,  2147,  1558,
    2044, -1722,  3656,  2485,  2061,  2061,   890,  2231,  2117,  3564,
    1315,  2899,  2118,  1093,    58,  2465, -1722,    57,   878,  2232,
     938,   939,   316,  1466,  2204,  1842,  2012,  1816,    58,  3123,
    2072,  3684,  1087, -1614,   938,   939,  2643, -2298,  3085,  1999,
    2000,  2001,  2002,  2003,  2004,  1668,  2180, -1678,  3091,  3092,
    3093,  3094,  3084,  2089,  1919,  2511,  3748,  2339,  4033,  1127,
      56,    57,  1400,  1554,  2410,    58,  3435,  4190,  2233,  3251,
    3439,  1555,  1556,  3190,  3196,  2012,  1154,    37,    38,    39,
      40,   994,   891,  3082,   892, -1266,  1669,  1104,   966,  3924,
    2416,  3470,  2391,  1307,  2452,  1847,  1202,  1919,   786,  2422,
    1292, -1578,  3201,  4208, -1266,  3675,   789,  2430,  2431,  3917,
    2001,  2002,  2003,  2004,  3313,  3314, -1723,  3085,  1476,  2721,
   -1578,  3611,  1477,   213,  1304,  2443, -1752,  3749, -1266,  3341,
    2534,  2535,  1952,  2497,  2298,  2194,  2683,  1239,  2544,  2544,
     692,  2199,  1031,  2544,  2299,  2619,  1249, -1266,  1769, -1490,
    1953,   351,   221, -1276,  1293,   351,  1295,  3341,  1297,  3308,
    4219,   967,  3311,  3312,  1298,    57,  3315,  2300,  4132,  4211,
    1686,  3685,  1954,   835,   995, -1070,  3322,  2181,  2272,  2250,
    1830,  2255,  2544,  2544,  2258,  2259,   232, -1261,  4010,  1770,
    1693,  3089,  3090,  3091,  3092,  3093,  3094,  1696,   235,  2389,
    1402,  1952,  3424,  1193, -2298, -2298, -1261,  3089,  3090,  3091,
    3092,  3093,  3094,  1318,  1816,  1147,  2186, -2296,   805,  1953,
    1087,  1831, -1276,  3612,  4243,  2621,  1195,  1467,  1999,  2000,
    2001,  2002,  2003,  2004,  2309,  1227, -2296, -2297,  1670,  1891,
    3918,  1956,   391,  2385,  4191,  1308,  3083, -1070,  1789,  4021,
    2269,  3426,  4213,    56,  2451,   806, -2297,  4047,    58, -2294,
    4209,  2388,  3750,  1288,   938,  1533,  3084,  2182,  2455,  3252,
    4107,  3089,  3090,  3091,  3092,  3093,  3094,  4174, -2294,  1402,
    1318,  4039, -2293,  4011,  2470,  2471,  3089,  3090,  3091,  3092,
    3093,  3094,  1468,  1587,  2410,  1452,  2178,  4220,  1615,  1462,
     980, -2293, -1883,  2221,   980,  3578,  3613,  1333,    80,  2543,
    2179,  1097,  1687,   788,  -125,  4192,  3193,    79,  3751,  -125,
    1671, -1883,  2684,  2132, -1233,  -125,  -125,  1816, -1246,  1446,
    2315,  3085,  2788,   968,   969,    74,  2385,  4193,  1087, -1273,
     684,  1771,   943,  1929,   943,    57,   943,  1935,  3600,    57,
    2622,  1321,   943,  1299,  1300,   350,  3665,  3925, -1273,   350,
    2658,   795,  3267,  2429,  1978,  3790,   945,  3791,   945,  3926,
     945,  2316,  4119,  1832,  2423, -1752,   945,  4103,   351,  1338,
    3908,  4214,  2180,  2432,  1476,  2183,  4108,  1443,  1477,  2185,
    2260,  1455,  1458,  1459, -1070,  2439,   837,   390,   922,  1147,
    1616,   390,  2098, -1073,  3827,  3828,  3829,  2505,  2507,    37,
      38,    39,    40,  2222,    37,    38,    39,    40,  2515,  2186,
    1075,  2518,  2903,  1772,    37,    38,    39,    40,  2386,  2530,
    2531,  3892,  3893,  3894,  3895,  3896,   851,  2463,  4172,  4173,
    2468,  2469,  2548,  2550,  2472,   413,  4109,  4134,    37,    38,
      39,    40,  1564,  2564,  4001,  1833,    37,    38,    39,    40,
      37,    38,    39,    40,  3268,  1482,  1028,  2235,  2652, -1237,
   -1237, -1237, -1237,   888,  1537, -1073,  1499,   674,  3343,    57,
     675,   675,   688,    58, -1070,  1566,  3667,  1164,  2099,  2537,
    2851,   853,   943,  1402,  1565,  3792,  3086,  3087,  3088,  3341,
    3089,  3090,  3091,  3092,  3093,  3094,  3783,  2129,  2640,  2261,
   -1233,  2262,  1557,  2181,  4224,  1797,   945,  2789,  3688,  3758,
     688,  3911,  3927,  2317,  3762,  1147, -1070,  3764,  1440, -1070,
    1224,   673,   673,  3755,  3242,  1505,  1563,   954,  4040,   688,
     688,    37,    38,    39,    40,    37,    38,    39,    40,   688,
    2985,  2187,  4207,   674,  3690,  1980,  1042,   981,  1225,   851,
    2474,   981,  2130,   985,  3005,  1562,  1798,   985,  4041,  1500,
    3467,   958,  1617,  3616,   674,  3010,  2986,  2928,  2929,  2930,
    2931,  1165,   350, -1233,  2226,  1710,  4223,  1983,  2033,  1580,
     688,  3441,  1984,  1441, -1244, -1244, -1244, -1244,  1226,  1507,
    3703,  2988,  3647,  2182,  1816,  2318,  1017,  3269,  3650,  3651,
    3652,  3653,  3654,  3655,   853,   344,  3577,  3044,  1581,  3482,
    1864,  2905, -1073,  3929,   390, -1235, -1235, -1235, -1235,  3246,
     860,  3930,   861,  2227,  3995,  4042,  3270,  3426,  2357,  2599,
     344,  1773,  2358,  1508,  2410,  1893,  2034,  1860,  2410,  2359,
    1799,  1033,  2360,  2159,  2361,  3739,  1861,  1862,  3704,  1075,
    1774,  2085,  1288,  1458,  1917,  2362,  2372,    80,    80,  1058,
      80,  2092,  2093,  2906,  2097,  3617,    79,    79,  2698,    79,
    2643,  2544,  3045,  1933,  2544,  2544,  2544,  2544,  2544,  2544,
    2544,  2544,  2544,  2544,    74,    74,  3774,    74,  3775,  1800,
    4115,  1797,  1045,  2990,  3001,  3004,  1053,  1053,  2101,  1053,
    3462,   796, -1073,  1960,    37,    38,    39,    40,  1986,  3012,
    3013,   797,  2260,  3015, -1238, -1238, -1238, -1238,   965,  3019,
    1971,  1688,  3405, -1236, -1236, -1236, -1236,  2373,  1987,  1988,
    1677,  2544,  2544,  3882,   207,  2907,  2908,  2102,  3966,  3998,
    1460,  1035,  3465,   860, -1073,   861,  1046, -1073,  2909,   838,
    3920,  2600,  2996,  1642,  2071,  2601,  2744,  1043,  1639,  3469,
    2334,  2037,  2875,  2031,  2032,   786,  3280,  2128,  3931,  2761,
    1707,  1708,  1801,   789,   684,   684,  3601,   688,  3053,  1991,
    2844,  -337,  1643,  2189,  2824,  2103,  2845,  1974,  3921,   846,
    2602,  3883,  2827,  1992,  2829,  4025,  3263,  1979,  3692,   798,
     991,    57,  2910,  3470,  1658,  2018,    57,  4043,  2017,   786,
    2412,  3264,  2415,  1659,  1051,  1051,    57,  1051,   351,  1047,
    2016,  2421,  1072,  4086,  3236,  2649,  1799,  1587,   805,  2129,
    2738,  2261,  2903,  2262,   805,  2745,  3954,  4044,  1458,    56,
      57,  2046,  2672,  1054,    58,  1458,  1458,  3018,    57,  4009,
    1537,  3834,    57,  1061,  1537,  1537,   413,  1658,  2144,  2071,
    2131, -1237,   351,   351,   351,   806,  2739,   851,   943,   684,
     786,   806,   943,   943,   980,  1800,  2772,  1073,   789,   805,
    2335,     8,  2846,  2911,  2130,  2912,  -724, -1233,  1131,  4089,
    2543,  2543,   945,  1816,   980,  2543,   945,   945, -1233,  2707,
    1929, -1233,  1582, -1233,  4045,  2224,  1071,  2374,  2229,  3494,
     351,  3495,  2603,  4130,  4131,  3602,   806,   351,  2375,   675,
    2140,  2673,   853,   351,   799,  2773,  2774,   980,  1048,  1097,
    3872,  3873,  1660,    57,  2543,  2543,  2136,    57,  1300,   156,
    2334, -2091,  2154,  2156,  2137,  3942,  1597,  2138,  2276,  1590,
     391,   391,  1103,  3888,  2148,  1995,  2544,  1064,  1801,  4147,
    2153,  2155,  1999,  2000,  2001,  2002,  2003,  2004,  1072,  1666,
     673,  2924,  1641,  4034,  1075,  2775,  1598,  1065,  2740,  3889,
     788,  1075,  1679,  4148,  1114,  1537, -1244,  1066,  1224,  3835,
     413,  1537,  3058,    37,    38,    39,    40,   391,  1667,  4035,
    1301,  2072,  1072,   943,  2163,   130,   131,  3237,   688,   943,
     174,  3682,  3603,  2266,  3028,  3604,  3386, -1235,  3491,  4121,
    1320,  4206,   350,  1073,   788,  2847,  1074,   945,   795,  3496,
    1042,  1537,  1599,   945,  1537,  1537,  2350,  1156,  2273,  3497,
    3109,  2139,  3511,  2643,  2240,  3255,  3256,   786,  2240,   943,
    2418,  3245,   943,   943,  2848,   789,  1226,  1073,  1162,  1837,
    2335,   860,  1600,   861,   390,  2336,   350,   350,   350,  3132,
     688,  3211,   863,   945,  2296,  1067,   945,   945,  1838,  1952,
    3341,    56,   866,  3191,  1537,   788,    58,  2410,  3645,  2241,
    2242,  4167,  2410,  2241,  2242,  2410,  1205,  1953,  1206,  4171,
     351,  1505,   943,  2297,  1973,  1506,    57,  2277,   390,   390,
     390,  2453,  1129,   979,   350,  2404, -1238,  3163,  3164,  1954,
    1075,   350,  1016,  2544,  2544, -1236,   945,   350,  2643,   122,
    2238,   981,  3265,   795,  2238,  1673,  3149,   985,  1068,  2487,
    4205,  4031,  2240,  2363,  2499,   213,  2899,   126,  1584,  1163,
    2659,   981,  3227,  4014,  1075,   807,   390,   985,  3512,  3513,
    3479,  3266,  1458,   390,  1674,  1507,  1058,  2498,  4063,   390,
    1200,  1644,  1147,   839,   221,  3843,  1952,  1585,  2061,  1197,
    2932,   207,  3082,  3636,   981,  2933,   919,  2241,  2242,  3807,
     985,  3356,  1675,   207,  1953,  2203,  2933,  1603,  3023,  2397,
    1069,   230,  3637,  1604,  1041,  1586,  3535,  1201,   232,  1508,
    1605,  1076,  1855,  1204,   344,  3082,  3542,  1639,  1645,  2496,
     235,  4245,  1213,    80,  4246,  1607,    80,   817,  2238,   156,
    3806,  1105,    79,  1608,  1856,    79,  1219,   992,  1077,  3536,
     156,  2221,  3204,  1106,  1107,  2336,  2493,  1228,  2228,  1496,
      74,  1952, -1070,    74,  2295,  2494,  2495,  1236,   688,  2581,
     688,   244,   788,  1108,  1857,  3942,  1109,  2166,   213,  1953,
     786,  1848,  2337,   213,  1587,  1849,  3450,  1655,   789,  1665,
    3453,  1609,  3455,  3249,  3457,  3458,  1682,  2899,  1929,  2240,
    2172,  1956,  1646,  3463,  3218,  2569,  2167,   221,  2572,  2588,
     174,   688,   221,  1229,   350,   674,  1208,   674,  1209,   674,
     795,   174,  2527,  1232,  3597,   674, -1114,  2678,  2903,  1929,
   -1114,  2172,  1235,   351,  2168,  2022,  3480,  3591,  3592,  2023,
     413,   232,  2516,  2517,  2241,  2242,   232,  1647,  1848,  1648,
    2529,  1246,  2447,   235,  2532,  2533,   390,  1476,  3275, -1578,
    2268,  1477,  3676,  3677,  3678,  3679,  3680,  4225,   191,  2554,
    1250,  2555,  3891,  1260,  3282,  3084,  1269,  1110,  3285,   920,
    3421,  3134,  1916,  3135,   244,  2238,   688,  2544,   688,  1290,
   -1114,  2576,  3055,  2577,   244,  1650,  2450,  1287,   413,   244,
    3384,  3939,  1275,  3136,    56,    57,  1400,  1554,  3084,    58,
    3056,  2544,  2544,  2670,  3057,  1555,  1556,  1111,  3678,  3679,
    3680,  2412, -1082,  2723,  2410,    58,  1929,   351,  1582,  4018,
    1652,   156, -1082,  2650, -1114,  3108, -1082,  3110,  3111,  1304,
    3085,  3475,  2148,  2543,  1689,   213,  2543,  2543,  2543,  2543,
    2543,  2543,  2543,  2543,  2543,  2543,   213,  1313,  2086,  2071,
    2087,  1309,  2695,  1654,  2695,   674,  2449,  3082,  2450,  1325,
     786,  3204,  1330,  3085,   221,   351, -1082,   351,   789,  1331,
     674,   674,  3659,  3660,  1552,   221,  3663,  1333,  3664,  3448,
    2460,  3813,  2461,  1941,  1942,   788, -1082,  1087,  2462,  3204,
    2461,   230,   174,  2543,  2543,  3993,  3137,  2490,   232,  2491,
    1332,  3138,   230,  1334,   391,   943,  2669,  1335,  1816,   232,
     235,  3366,    35,   351,  1339,  2785,    37,    38,    39,    40,
      41,   235,  2715,   675,  2491,  3367,   786,   350,  1537,   945,
   -1082,  2121,  2122,   795,   789,  2752,  1566,  2753,    80, -1082,
      80,  3595,  1042,  2399,  2400,  1565,   943,    79,  1463,    79,
     191,  4226,   391,  1336,   391,  3368,  2544,  3369,   786,  2795,
    1340,  2796,   244,  1557,  1469,    74,   789,    74,  1465,   390,
     945,  2891,  1470,  2892,   673,  2919,  3466,  2920,  1471,   351,
    1459,  2686,  2687,  4098,  1734,  4100,  3939,  1563,  1929,  1480,
    2172,  3025,  1402,  2461,  3518,  3086,  3087,  3088,  3478,  3089,
    3090,  3091,  3092,  3093,  3094,  2519,  3153,  3036,  3154,  3037,
    2925,   351, -1137, -1137,  3139,  3366,  3811,  3054,  3064,  2450,
    2450,   350,  1485,  3140,  3747,  1402,  3370,   213,  3086,  3087,
    3088,  1486,  3089,  3090,  3091,  3092,  3093,  3094,  2121,  2691,
    3084,  2412,  1493,  3067,  1537,  2450,  1496,  3071, -1082,  2450,
    1494,  2590,  1537,  2591,  1537,  3072,   221,  2450,  1502,  3368,
    1504,  1497,   943,   390,  3098,  1503,  2450,  2520,  1516,   350,
     943,   350,   943,  2592,  1518,   788,  3676,  3677,  3678,  3679,
    3680,  1522,  1872,   230,  3681,  1523,   945,  3371,  3206,  3207,
     232,  2877,  3372,  3114,   945,  2450,   945,  2952,  2953,  2877,
     688,  3117,   235,  3118,  3155,  3085,  3156,  1899,  3169,  3939,
    3170,   390,  1526,   390,  1496,  1527,  2977,   350,  2543,  3197,
    2984,  3198,  2521,   795,  1528,  2522,  1042,  3773,  3373,  3261,
    3290,  3262,  3291,  3171,  3776,  3777,  3172,  3173,  3672,  3673,
    3374,   788,  2902,   244,  3440,  2927,  3443,  3174,  3175,  3176,
    1529,  3177,  3178,  1905,  1906,  3879,  3179,  3180,  3181,   390,
    3392,  3402,  3393,  3403,  3415,  3483,  3416,  2450,  2957,  1980,
    1531,  2593,    81,   788,  2984,  3519,  2594,  3520,  3526,  1538,
    3527,  2595,  3538,   350,  2450,  2985,  1087,  1530,  3561,   795,
    2450,  3901,  3562,  3593,  2450,  2461,  3372,  3717,  3769,  3718,
    3170,  1983,  3158,  3159,  1539,  3812,  1984,  2491,  3845,  1532,
    2461,  2986,  3846,  2020,  2461,   350,  3212,  3213,  3375,  2523,
    1458,   795,   688,   688,  1541,   390,  2987,  3627,  3628,  3214,
    3215,  3204,  3373,  3951,  1544,  1816,  2988,  1568,  3956,  2985,
    3393,   674,  3115,  1571,  3374,   674,   674,  3120,   392,  3958,
    3972,  3393,  3973,   786,   392,  1569,  1619,   390,   786,  2989,
    1578,   789,  1620,  1545,  1547,  2986,   789,  1402,  3970,  1582,
    3086,  3087,  3088,  1596,  3089,  3090,  3091,  3092,  3093,  3094,
    2987,  3974,  3980,  2450,  2491,  2543,  2543,   392,  3182,  4029,
    2988,  4030,  1637,  3131,  2596,  4057,  4170,  4058,  1613,  1635,
    1971,  1621,  4064,  2597,  4065,  4069,   351,  1816,  3324,  1672,
    2524,   351,  1676,  2989,  2588,  3840,    55,   688,    57,   674,
    1684,   879,  3375,  1685,  4071,  3874,  3393,  2150, -2298,  4075,
     392,  2491,  1986,  3152,  3080,  3081,  1690,  1692,  2990,  3096,
    3759,  4120,  4124,  2036,  4058,  4139,  2404,  1816,  3082, -1575,
    3325,  1622,  1987,  1988,  4140,  4141,  2491,  3118,  1623,  1694,
    1697,  1624,  1899,  4142,  4151,  2450,  2491, -2298,  4153,  1702,
    2491,  4017,  3814,  1704,  3326,  1133,   674,   986,  3129,  3130,
    1152,  4154,   674,  2491,   986,  4221,   986,  4222,  1161,  1711,
    1714,  2412,  2990,  3327,  1587,  2412,  1169,  4250,   392,  4222,
    1753,  1196,  3797,  1991,  1755,  1759,  1765,  1763,  -169,  3328,
    1625,  1767,  3183,  1778,  1784,  3082,  1794,  1992,  1802,  2248,
    1804,  1809,   674,  3329,  1810,   674,   674,  1811,  1813,  1458,
    1812,  1815,  1816,  1821,  1824,  1825,  1826,  1131,  1537,  1827,
    1829,  1834,  1836,  1835,  4074,  1841,  1873,  3959,  1901,  3960,
    3961,  2148,  1907,  1909,  3192,  1903,   943,  1910,  3965,  1915,
    1923,  1926,  3760,  1927,  3184,  1626,  1932,  1928,   788,   244,
    1934,  1937,  1938,   788,  1939,   674,  2009,  4091,  2306,  1940,
     945,  4096,  4097,  2036,  1945,  1947,  2040,  1948,  2051, -2298,
    1949,  1950,  1951,  1958,  1959,  1899,  1961,  1962,  2066,  1963,
    1964,  1627,  1965,  1966,  1967,  3330,  2076,  2090,  1506,  2115,
     350,  3841,  2120,  3331,  1317,   350,   795,  2127,   786,   786,
     786,   795,  1075,  2135,  2141,  2143,   789,   789,   789,  2145,
    1328,  3084,   392,  1553,  1629,  2151,  4092,  2152,  2343,  2543,
    4095,  2157,  2158,  2160, -2240,  2162,  3332,  1147,  2169,  2170,
    2172,  2173,   390,  3185,  2174,  2188,  2195,   390,  1630,  2196,
    2197,  1450,  2198,  2543,  2543,  2193,   392,  2219,  2221,  2220,
    2225,   351,   351,   351,  2236,  2235,  3904,  2238,  2237,  1995,
    1475,  2245,  3866,  3867,  3396,  3869,  1999,  2000,  2001,  2002,
    2003,  2004,  3281,  2244,  2417,  2246,  3085,  2350,  3084,  2251,
    2249,  2253,  2254,  2256,  1498,  2263,  2264,  2271,   786,  2270,
    1658,  2278,   873,  2279,  3293,  2285,   789,  2307,  2286,  2292,
    2294,  3431,  3283,    35,   413,  2287,  2319,    37,    38,    39,
      40,    41,  2321,  1045,  2322,   688,  2329,  1919,  2331,  2332,
    2341,  4072,  1929, -1115,  1935,  2877,   848, -1115,  2877,  2877,
    2020,  2347,  2877,   344,  2351,  1660,  2367,  2384,  3397,  2390,
    2392,   351,  2877,  3085,  2393,  2395,  2413,  1710,   344,  2402,
    2425,  3344,  2396,  3409,  2427,  2426,  2428,  3353,  2441,  2442,
    1537,  2456,  2473,  2480,  2501,  2457,  2510,  1046,  2488,   344,
    1042,  2552,  2565,  2570,  3430,  2476,  2404,  2553,   943,  3344,
    2404,  1980,  2511,  3348,  3351,  3950,  3984, -1115,  1537,  2574,
    2575,  2582,  3391,  2587,  4046,  3950,  2604,  2633,  2543,  2679,
    4216,  2041,   945,  2645,  4084,  4085,   943,  3552,  3553,  3554,
    3555,  2606,  2648,   788,   788,   788,  2656,  2657,  2646,  2680,
    1046,  2664,  3420,  1458,  2653,  2685,  1619,  2700,  2026,   344,
     945, -1115,  1620,  2716,  3473,  2718,  2651,  2717,  1402,  2671,
    1047,  3086,  3087,  3088,  2579,  3089,  3090,  3091,  3092,  3093,
    3094,  2697,  2725,  2699,  2714,   350,   350,   350,  2727,  2729,
    2730,   795,   795,   795,  1780,  1782,  1783,  2731,  2733,  1872,
    4004,  1621,  2736,  3521,  2743,  2750,  2642,  2748,  2787,  2852,
     879,  2794,  1724,  2797,   786,  2150,  2853,  2854,  2858,  2862,
    2863,  2866,   789,  2868,  2867,  2870,  2871,   390,   390,   390,
    2872,  2886,  3204,   788,  2042,  1402,  1147,  2874,  3086,  3087,
    3088,  2873,  3089,  3090,  3091,  3092,  3093,  3094,  2884,  2893,
    2895,  1622,  2898,  2899,  2412,  2900,  2917,  2901,  1623,  2412,
    4202,  1624,  2412,  2921,  2926,  4077,  2934,   351,  2939,  2955,
    2956,  2938,  2958,  2973,  1971,   350,  2974,  2975,  2976,  1048,
    2983,   795,  2997,  1450,  3002,  3003,  3016,  3493,   674,  3017,
    3498,  3499,  3500,  3501,  3502,  3503,  3504,  3505,  3506,  3507,
    3027,  3011,  3014,  3625,  3021,  3029,  1450,  3034,  2502,  3046,
    1625,  3052,  4070,  3050,  1315,  3533,  4202,   390,  3065,  3066,
    3068,  3069,  3070,  3073,  3074,  3076,  3079,  3097,  3104,   674,
    2450,  3103,  3128,   674,  3133, -2152,  3141,  2704,  3105,  1552,
    3106,  4202,  3113,  3148,  3126,   688,  3127,  3544,  3545,  2785,
    3151,  3608,  3166,  3167,  3222,  3217,  3161,  3569,  3239,  2964,
     786,  3221,   786,  3220,  3225,  1626,  4150,  1848,   789,  3234,
     789,  3226,  4102,  3231,  3235,  4146,  3238,  1597,  3243,  3244,
     392,  3276,  1132,  3277,   392,  3286,  1150,  3284,  1124,   786,
    3310,  3295,  3294,  1124,  3296,  1160,  3297,   789,  3298,  3299,
    3300,  1627,  3346,  3347,  3316,  3301,  3302,  1598,  3303,  3304,
    3317,  3318,  3319,   351,  3320,   351,  3321,  2138,  3203,  3355,
    1207,  3357,  3358,  1124,  1214,  3379,  3381,  3385,  3387,   788,
    1628,  3400,  3398,  3584,  1629,  1223,  3401,    55,    56,    57,
    3411,  3406,   351,    58,  2067,   674,  3407,  3413,  3428,   938,
    1533,  3344,  3432,   674,  3434,   674,  3436,  1597,  1630,  3444,
    1537,  3447,  3437,  1599,  3449,  3626,  1240,  3454,  3456,  3476,
    3477,   350,  3629,  1124,  3630,  3472,  3486,   795,   943,  3100,
    1124,  3082,  3528,  1916,  3099,  1975,  3572,  1598,  3540,  3515,
    3516,   943,  3541,  1600,  3576,  1980,  3582,  3517,  2877,  3549,
      81,  3559,   945,  3571,  2877,  2877,  2877,  2877,  2877,  2877,
    3573,  3579,  3596,   390,  3585,   945,  3609,  3598,  3605,  1981,
    3610,  2965,  3622,  3633,  3620,  2897,  3621,  1983,  3707,  3623,
    3624,  3648,  1984,  3646,  3649,  2140,  3700,  3674,  3353,  3425,
    3712,  3710,  3715,  1599,  3726,  3714,  3731,  3687,  3689,  3691,
    3693,  3722,  1299,  1300,  3732,  3740,  3734,  3744,  2412,  2404,
    3745,  3671,  3753,  3763,  2404,  3351,  3778,  2404,  3772,  3781,
    3756,  3766,  3702,  1600,  3686,   788,  1124,   788,  3784,  3779,
    1136,  2412,   986,  1137,  1138,  1139,   986,  1140,  1141,  1142,
    1143,  1144,  1145,  3789,  3786,  2234,  3794,  3824,  3798,  3737,
    3799,  3825,  3804,  3848,   788,  3793,  3849,   392,  3800,  3850,
    2678,  3854,  3870,  3860,  3863,  1124,  3844,   350,  3871,   350,
    3875,  3878,  3884,   795,   207,   795,  3666,  3905,  1603,  3887,
    3851,  3890,  3897,  3909,  1604,  3913,  3915,  3919,  3923,  3932,
    3934,  1605,  2284,  3947,   688,  1872,   350,  3964,  1639,  3963,
    3968,  3935,   795,  3976,  1985,  3977,  1607,  3978,  1986,   390,
    3953,   390,  2304,  3969,  1608,  3971,  3986,  3979,  3988,  3999,
    3994,  1601,  3996,  4006,  4007,  4003,  4012,  4013,  1987,  1988,
    2461,  4019,  3706,  4026,  4037,  3047,  4028,  4038,   390,  1619,
    4050,  4048,  4049,  1989,  4051,  1620,  4052,  4067,  4083,  1047,
    1602,  4087,  4106,  4110,   207,  4114,  1131,  4116,  1603,  4122,
    4123,  3899,  1609,  4126,  1604,  4138,  2967,  3425,  4143,  4144,
    4145,  1605,  4093,  1842,  4156,  4155,  1990,  4165,  1606,  1991,
    4159,  4175,  4161,  4166,  1621,  3565,  1607,  4185,  4189,  3808,
    3809,  4157,  4158,  1992,  1608,  4212,  1993,  4218,  4217,  4234,
    4247,  4236,  1124,  2412,  1056,  2923,  2063,  3194,  3253,  1124,
    3838,  3839,  2790,  4168,  3606,  3323,  4015,  3724,  3728,  3837,
    2762,  3599,  3902,    80,  3233,  3026,  4186,  4215,  4162,  4160,
    1750,  4195,    79,  2383,  1622,  3729,  3410,  2148,  2741,  3736,
    3631,  1623,  1609,  3288,  1624,  2364,  2434,  2904,   943,  3389,
      74,  4249,  4237,  3886,   943,  2438,  3885,  3382,   786,  3334,
    1124,  4196,  4005,  4152,  2346,  1994,   789,  4008,   943,   960,
    1889,  4055,   945,  3782,  3738,  4128,  3857,  3858,   945,  2756,
    4133,  3861,  3862,  3741,  2150,   344,  2877,  2877,  4228,   674,
    3910,  4032,   945,  1625,  4248,   925,  2666,  3876,  3877,  1473,
    1980,  3880,  3881,  1450,  1450,  4118,  2091,  3721,  3474,    81,
      81,   351,    81,  1859,  3353,  3353,  3353,  3353,  3353,  3199,
    1124,  1863,  3022,  3780,  2690,  3202,  2412,  3216,  2116,  2088,
    1492,  3842,  1983,  3583,  2689,  2682,  2404,  1984,  3160,  2663,
    2979,  3351,  3351,  3351,  3351,  3351,  3442,  1242,  1626,   943,
    3955,  1481,  3200,  1750,  3719,  1995,  3916,  3532,  1996,  1997,
    1998,  4076,  1999,  2000,  2001,  2002,  2003,  2004,  3522,  4177,
    2654,  4178,  4184,   945,  3205,  1124,  2655,  3146,  3144,  3061,
    3039,  1865,  3941,  1090,  1627,  1619,  2632,  3429,  1796,  2972,
    2398,  1620,  2701,  4176,  2126,  1059,  2119,  2692,  1286,  1898,
    1576,  2708,  2705,  1124,  3189,  2706,  3587,  3250,  1548,  3588,
    3833,  3575,  2025,  1663,  2123,  3024,  1082,  1629,  2712,  4187,
    2458,  3771,  1845,    83,     0,     0,     0,     0,     0,     0,
    1621,  2631,     0,     0,  1124,  1124,     0,  1124,  3271,     0,
    3273,  1664,     0,  3967,     0,     0,     0,     0,     0,     0,
    2008,     0,     0,     0,  1124,     0,  2647,     0,     0,  1985,
       0,     0,     0,  1986,     0,     0,     0,  3981,  3982,     0,
       0,     0,     0,   788,     0,     0,     0,     0,     0,     0,
    1622,  3992,     0,  1987,  1988,     0,     0,  1623,     0,     0,
    1624,     0,  3344,  2047,     0,     0,     0,     0,  1989,  3991,
       0,  1537,     0,     0,  4244,  2667,  1124,   392,     0,  2877,
       0,     0,  3309,  4016,     0,   350,     0,     0,  1980,   943,
       0,   795,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   674,     0,  1124,  1991,     0,   344,  1124,  1124,  1625,
       0,  3430,  1981,   945,     0,     0,     0,     0,  1992,     0,
    1983,   392,   392,   392,     0,  1984,     0,   390,     0,   674,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    4053,     0,     0,     0,     0,     0,     0,   688,   786,     0,
       0,  3394,     0,     0,     0,     0,   789,     0,     0,     0,
       0,     0,     0,     0,  1626,  3250,     0,     0,     0,   392,
       0,     0,     0,     0,     0,     0,   392,     0,  1750,     0,
       0,     0,   392,     0,   688,     0,   986,     0,     0,     0,
    1994,     0,  4073,     0,     0,  4242,     0,     0,     0,     0,
    1627,   351,     0,     0,     0,     0,   986,     0,  1980,     0,
       0,     0,     0,  1750,     0,     0,  3451,     0,     0,     0,
       0,     0,     0,     0,     0,  2780,     0,     0,     0,  1680,
       0,     0,     0,  1629,     0,  1750,     0,     0,     0,   986,
    1983,     0,     0,     0,     0,  1984,     0,  1985,     0,     0,
       0,  1986,     0,     0,     0,     0,     0,  1681,     0,     0,
       0,     0,     0,     0,  2291,     0,     0,     0,     0,     0,
       0,  1987,  1988,     0,     0,     0,     0,  3487,     0,     0,
    1995,     0,     0,  1996,  1997,  1998,  1989,  1999,  2000,  2001,
    2002,  2003,  2004,     0,  1750,     0,  3492,     0,     0,     0,
       0,     0,  4135,     0,     0,     0,     0,     0,     0,     0,
       0,  2327,     0,     0,     0,     0,     0,     0,     0,  1990,
       0,  3514,  1991,     0,     0,     0,  4136,     0,     0,  1750,
       0,     0,     0,     0,     0,     0,  1992,     0,     0,  1993,
       0,  2922,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2353,     0,   344,  1750,  1899,     0,     0,     0,   392,
       0,     0,     0,   788,     0,     0,  2291,  1985,     0,  4241,
       0,  1986,     0,     0,  4204,  2941,     0,     0,     0,     0,
       0,     0,  2959,  4203,     0,  2964,     0,     0,     0,   344,
       0,  1987,  1988,     0,     0,     0,     0,     0,     0,     0,
       0,  4200,  1124,  1597,  1124,   350,  1989,     0,  1994,     0,
    1750,   795,     0,  1124,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2291,     0,     0,     0,  2704,
    4204,     0,     0,  1598,     0,     0,     0,     0,     0,  4203,
       0,     0,  1991,     0,     0,    81,     0,   390,    81,     0,
       0,     0,     0,     0,     0,  4204,  1992,  4200,     0,     0,
       0,     0,     0,     0,  4203,     0,     0,     0,     0,     0,
       0,   674,     0,     0,     0,     0,     0,     0,     0,     0,
    1124,     0,  4200,     0,   674,     0,     0,     0,     0,  1599,
       0,     0,     0,     0,     0,     0,     0,     0,  1995,     0,
       0,  1996,  1997,  1998,     0,  1999,  2000,  2001,  2002,  2003,
    2004,     0,     0,     0,     0,  1124,  1124,  3075,     0,  1600,
       0,     0,     0,  1124,     0,     0,  1124,     0,  1994,  1124,
       0,     0,     0,     0,  2528,  1980,     0,  1124,  1124,     0,
       0,     0,     0,     0,     0,  1124,     0,  2965,  1124,  1124,
    1124,  1124,     0,     0,     0,     0,     0,     0,  1124,  1124,
       0,  1124,     0,  1124,     0,     0,  1124,  1983,     0,     0,
       0,     0,  1984,     0,     0,     0,     0,     0,     0,     0,
    1750,  1124,   392,     0,     0,  1124,     0,     0,     0,  1124,
       0,     0,     0,  1124,     0,  3711,  1124,  1124,  1124,  1124,
    1124,  1124,  1124,  1124,  1124,     0,  1124,     0,     0,     0,
       0,     0,  1124,     0,     0,  1980,  1124,  3157,  1995,     0,
       0,     0, -2298, -2298,     0,  1999,  2000,  2001,  2002,  2003,
    2004,     0,     0,     0,     0,     0,     0,     0,     0,  1981,
       0,     0,     0,     0,     0,     0,  1125,  1983,  1128,     0,
     207,     0,  1984,     0,  2966,     0,     0,     0,     0,  3142,
    1604,     0,     0,  1158,     0,     0,     0,  1605,     0,     0,
    1450,     0,     0,     0,  1639,     0,   392,     0,     0,     0,
       0,     0,  1607,     0,     0,     0,  1203,  1124,     0,     0,
    1608,     0,     0,     0, -2298,     0,     0,     0,  1986,     0,
       0,     0,  1221,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   690,     0,     0,     0,     0,     0,  1987,  1988,
       0,     0,   693,     0,   392,     0,   392,     0,     0,     0,
       0,     0,     0, -2298,     0,     0,     0,     0,  1609,     0,
       0,     0,  2967,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1899,     0,  2719,   834,     0,
      81,  2722,    81,     0,     0,     0,     0,     0,   883,  1991,
       0,   887,   392,     0,  1985,     0,  2734,   883,  1986,     0,
    2150,   942,     0,  1992,  2746,     0,     0,     0,     0,  1124,
       0,   674,     0,     0,     0,     0,     0,   674,  1987,  1988,
       0,     0,   961,     0,     0,     0,     0,  2760,     0,  1750,
       0,   674,     0,  1989,  1750,  1750,     0,     0,   883,  3853,
       0,     0,     0,     0,  2781,     0,     0,  3859,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   392,  2798,
       0,  2822,     0,     0,     0,     0,  1990,     0,     0,  1991,
       0,  1040,     4,     0,     0, -2298,     0,     0,     0,  2838,
       0,     0,     0,  1992,     0,     0,  2842,     0,     0,     0,
     392,     0,     5,  2855,     0,     0,     0,     0,     0,     0,
    2859,     0,     6,     7,     0,     0,     0,     0,     8,     0,
       9,    10,   674,     0,    11,    12,    13,    14,    15,    16,
      17,    18,    19,    20,    21,    22,    23,    24,    25,    26,
      27,    28,    29,    30,    31,    32,    33,    34,     0,    35,
       0,    36,  3388,    37,    38,    39,    40,    41,     0,  1124,
       0,  1750,  3399,     0,     0,  1994,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1995,     0,     0,  3412,     0,
       0,     0,  1999,  2000,  2001,  2002,  2003,  2004,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      42,  1633,  1634,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3394,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1750,     0,     0,     0,     0,     0,     0,
       0,  3459,     0,  1124,  3460,     0,     0,  1899,     0,     0,
       0,  3464,     0,  1124,     0,  1086,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1995,     0,     0,  1996,  1997,
    1998,  1705,  1999,  2000,  2001,  2002,  2003,  2004,     0,     0,
    1450,    43,     0,     0,     0,     0,     0,  1757,  1758,     0,
    1124,     0,     0,     0,     0,    44,     0,     0,     0,     0,
       0,  3033,   674,     0,     0,  1785,     0,     0,     0,     0,
       0,     0,     0,     0,    45,     0,     0,     0,     0,     0,
    1124,     0,     0,     0,     0,     0,     0,     0,     0,  3033,
       0,  1750,     0,  1818,  1820,    46,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2964,     0,
    1124,  1124,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1597,     0,     0,    47,
       0,     0,    48,     0,     0,     0,     0,     0,     0,     0,
    1124,  1124,     0,     0,     0,  1124,     0,     0,  3556,  3557,
       0,     0,     0,     0,    49,     0,  1598,  1124,  1124,  1124,
    1124,     0,     0,     0,     0,   392,     0,     0,     0,  1124,
     392,     0,  1124,     0,  1124,     0,     0,     0,     0,     0,
       0,     0,     0,  1899,  1124,  1124,     0,  1124,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1124,     0,  1124,     0,     0,     0,  1124,     0,     0,     0,
       0,  1619,  1599,     0,     0,     0,  1899,  1620,     0,     0,
    1899,  1899,  1124,     0,     0,     0,    50,     0,  1980,     0,
       0,     0,     0,  1124,     0,  1124,  1124,  1124,     0,     0,
       0,  1644,  1600,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1124,  1621,     0,     0,     0,
    1983,     0,     0,     0,  1124,  1984,    51,     0,     0,     0,
    2965,  1124,     0,     0,     0,   674,  1124,     0,     0,    52,
       0,     0,     0,  1124,  1124,  1124,     0,     0,  1645,     0,
       0,     0,    53,     0,  1094,  1095,     0,     0,     0,     0,
       0,     0,     0,     0,  3228,     0,  1622,     0,  1086,     0,
       0,     0,     0,  1623,     0,     0,  1624,    54,     0,     0,
       0,     0,     0,    55,    56,    57,     0,  1124,     0,    58,
       0,    59,     0,     0,     0,    60,    61,    62,    63,    64,
       0,     0,    65,    66,    67,    68,  3683,    69,    70,    71,
      72,    73,     0,  1750,  1750,     0,  1750,     0,     0,     0,
       0,     0,  1646,  1750,  3708,  1625,     0,     0,     0,     0,
       0,     0,     0,   207,     0,     0,  3713,  1603,     0,     0,
       0,     0,     0,  1604,     0,  3274,     0,  1985,     0,     0,
    1605,  1986,     0,     0,  1750,     0,  1750,  1639,     0,     0,
       0,     0,     0,     0,     0,  1607,     0,  1647,     0,  1648,
       0,  1987,  1988,  1608,     0,     0,     0,     0,     0,     0,
    1649,     0,     0,     0,     0,     0,  1989,     0,     0,     0,
     392,   392,   392,     0,     0,  1151,     0,  1153,     0,  1155,
       0,  1157,     0,     0,     0,     0,     0,     0,     0,     0,
    3306,     0,     0,     0,     0,  1650,  1627,     0,     0,  1990,
    1199,  1609,  1991,     0,     0,  2967,     0,     0,  1750,     0,
       0,     0,     0,     0,  1217,  1218,  1992,     0,     0,  1220,
       0,     0,     0,     0,     0,  1651,     0,     0,     0,  1629,
    1652,     0,  3335,  1750,     0,     0,  1086,     0,   883,     0,
       0,     0,     0,     0,     0,  2280,  2281,  2282,  2283,     0,
    1245,     0,     0,  1653,     0,     0,     0,     0,     0,     0,
     392,  1750,  1264,  1654,     0,  1266,     0,  1268,     0,  1271,
       0,     0,     0,     0,     0,  2310,  2311,  1750,     0,     0,
       0,  2320,  3820,  3821,  3822,  3823,     0,     0,  1994,     0,
       0,  1750,     0,     0,     0,     0,  1302,  1303,     0,     0,
       0,     0,     0,     0,     0,     0,  1750,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1326,  1124,  1327,     0,     0,  1124,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1124,     0,     0,
       0,     0,  1750,     0,     0,  2291,  2368,  2369,  2370,  2371,
       0,     0,     0,     0,  1086,     0,     0,     0,  3468,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1124,
       0,     0,     0,     0,     0,     0,     0,     0,  1995,     0,
    3481,  1996,  1997,  1998,     0,  1999,  2000,  2001,  2002,  2003,
    2004,     0,     0,  1040,     0,     0,     0,     0,     0,     0,
    1124,     0,     0,  1750,     0,     0,     0,     0,     0,  1124,
       0,     0,     0,     0,     0,  1124,     0,  1124,     0,  2445,
       0,     0,  1750,  1124,     0,     0,  1124,  1124,  1124,  1124,
    1124,  1124,  1124,  1124,  1124,  1124,     0,     0,     0,  1124,
    1124,     0,     0,     0,     0,     0,     0,  1750,     0,     0,
       0,     0,  1124,     0,     0,     0,   392,     0,  1124,     0,
       0,  1570,     0,  1572,     0,     0,     0,  1574,  1124,     0,
       0,  1124,     0,  1124,     0,     0,     0,     0,     0,     0,
       0,  1750,  1124,  1124,  1124,     0,     0,     0,  1124,     0,
       0,  1124,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1124,     0,     0,     0,     0,     0,     0,     0,     0,
    1124,     0,     0,     0,     0,     0,     0,     0,  1683,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1695,     0,     0,     0,     0,     0,     0,     0,     0,
    1701,  1980,     0,     0,     0,     0,  1703,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1751,     0,     0,
       0,     0,     0,     0,     0,  1981,     0,  3594,     0,  1980,
       0,     0,     0,  1983,     0,     0,     0,     0,  1984,     0,
       0,     0,     0,     0,     0,     0,     0,  1790,     0,     0,
       0,     0,     0,  1981,     0,     0,     0,     0,     0,     0,
       0,  1983,   392,  1750,   392,     0,  1984,     0,     0,     0,
       0,  1980,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3638,  4022,  3640,     0,
       0,   392,     0,     0,     0,  1981,     0,     0,     0,     0,
       0,     0,     0,  1983,     0,     0,     0,     0,  1984,     0,
       0,     0,     0,  1450,     0,     0,     0,  1866,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1897,  4066,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   669,     0,
       0,     0,     0,   687,     0,   691,     0,     0,     0,     0,
    1985,     0,     0,     0,  1986,   691,     0,     0,  1124,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1750,     0,     0,  1987,  1988,  4088,     0,  1985,     0,
       0,   687,  1986,     0,     0,     0,     0,     0,     0,  1989,
       0,   691,     0,     0,     0,     0,     0,     0,     0,     0,
     687,   691,  1987,  1988,   691,     0,  1750,  1124,  1124,     0,
     691,     0,     0,     0,   691,     0,     0,  1989,   953,     0,
    1985,     0,  1990,     0,  1986,  1991,  1124,     0,     0,     0,
       0,  1124,   955,     0,  1124,   691,     0,     0,     0,  1992,
     962,     0,  1993,     0,  1987,  1988,     0,     0,  3033,     0,
    1990,   691,     0,  1991,     0,   972,     0,   953,     0,  1989,
       0,   993,     0,     0,     0,     0,     0,  1992,     0,     0,
    1993,     0,     0,     0,  1124,     0,     0,     0,  1030,     0,
       0,     0,     0,     0,   691,     0,     0,     0,     0,     0,
    2825,     0,  1990,     0,     0,  1991,     0,     0,     0,  1040,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1992,
    1124,  1994,  1993,     0,     0,     0,     0,  1124,  1124,     0,
    1750,     0,     0,     0,     0,  1124,  1124,     0,     0,     0,
    1124,  1750,     0,  1980,  2869,     0,  1124,  1124,     0,  1994,
    1124,  2878,  2879,  2880,  2881,  2882,  2883,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1981,     0,     0,
    1124,     0,  1980,     0,     0,  1983,     0,     0,     0,     0,
    1984,     0,     0,     0,     0,    81,     0,  2161,     0,     0,
       0,  1994,     0,     0,     0,     0,  1981,  3855,     0,     0,
       0,  1980,     0,     0,  1983,  1750,     0,     0,  3864,  1984,
       0,  1995,  2192,  1750,  1996,  1997,  1998,     0,  1999,  2000,
    2001,  2002,  2003,  2004,     0,     0,     0,     0,     0,     0,
    3121,     0,     0,  1983,     0,     0,     0,     0,  1984,  1995,
       0,     0,  1996,  1997,  1998,     0,  1999,  2000,  2001,  2002,
    2003,  2004,     0,     0,     0,     0,  2573,     0,   691,     0,
       0,     0,  3006,     0,  3008,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1995,     0,     0,  1996,  1997,  1998,     0,  1999,  2000,
    2001,  2002,  2003,  2004,     0,     0,     0,     0,  3345,     0,
    1124,     0,  1985,     0,     0,     0,  1986,     0,     0,     0,
     392,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  3546,  1987,  1988,     0,     0,
       0,  1985,     0,     0,     0,  1986,     0,     0,     0,     0,
    1124,  1989,     0,     0,     0,  1750,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1987,  1988,     0,     0,  1124,
   -2298,     0,     0,  1124,  1986,     0,     0,     0,  1750,     0,
    1989,  2344,  3033,     0,  1990,     0,     0,  1991,     0,     0,
       0,     0,     0,  2366,  1987,  1988,     0,     0,     0,  1124,
       0,  1992,     0,  1750,  1993,     0,     0,     0,     0, -2298,
       0,     0,     0,  1990,     0,   808,  1991,     0,     0,     0,
       0,     0,     0,  1124,  1124,     0,     0,  1124,     0,     0,
    1992,     0,     0,  1993,  1124,  1124,     0,     0,  2420,     0,
       0,     0,  2424,     0,     0,  1991,     0,     0,     0,     0,
       0,  2433,     0,  2435,     0,  2436,     0,     0,     0,  1992,
    2437,     0,     0,     0,  1750,     0,     0,  1124,     0,     0,
       0,   809,     0,  1994,     0,     0,     0,     0,     0,     0,
       0,     0,  2454,   883,     0,     0,     0,     0,     0,     0,
       0,   810,     0,     0,     0,     0,     0,     0,  1124,   687,
       0,     0,  1994,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   811,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0, -2298,     0,     0,     0,     0,     0,     0,     0,   812,
       0,     0,     0,     0,   813,  1124,  1124,   691,   691,   814,
       0,     0,  1750,     0,     0,     0,     0,     0,     0,     0,
       0,   691,     0,  1995,   815,     0,  1996,  1997,  1998,     0,
    1999,  2000,  2001,  2002,  2003,  2004,     0,     0,  1124,  1750,
    3531,  1124,     0,  1124,     0,     0,     0,     0,     0,     0,
       0,     0,  1995,     0,     0,  1996,  1997,  1998,     0,  1999,
    2000,  2001,  2002,  2003,  2004,     0,     0,  3574,     0,  1124,
       0,     0,  1750,     0,     0,     0,  1750,  1750,     0,     0,
       0,  1995,     0,     0,     0,     0,     0,     0,  1999,  2000,
    2001,  2002,  2003,  2004,     0,     0,     0,     0,     0,     0,
     392,     0,     0,     0,  2641,     0,   816,  1124,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1124,     0,
       0,     0,     0,   817,     0,  1750,     0,  4137,  1126,   687,
    1126,     0,     0,   669,     0,  1149,     0,   669,   691,     0,
     691,     0,   691,  1124,   691,  1126,   669,   818,  1980,     0,
       0,     0,     0,   819,     0,  1171,     0,     0,     0,   820,
       0,   821,     0,   691,     0,     0,   687,     0,  1126,     0,
       0,   669,  1981,  1149,     0,   669,  1216,   691,   691,     0,
    1983,     0,   691,     0,  1126,  1984,   669,   822,   823,     0,
       0,     0,   824,     0,     0,     0,     0,     0,     0,   691,
     825,   691,     0,     0,     0,   826,     0,     0,     0,     0,
       0,  1124,     0,   691,     0,   827,   687,     0,     0,     0,
     691,     0,  1149,     0,   691,   691,     0,   828,   691,     0,
     691,     0,   691,  1086,   691,     0,     0,  1126,     0,     0,
       0,     0,     0,     0,     0,     0,  2720,     0,     0,     0,
       0,  2724,     0,     0,     0,  2728,     0,     0,     0,   691,
     691,  2732,  1980,     0,     0,     0,     0,  2737,     0,     0,
       0,     0,     0,  2747,     0,     0,     0,     0,  2749,     0,
       0,     0,     0,     0,     0,   691,     0,   691,  1980,     0,
    1329,     0,  3112,     0,  1983,     0,  1124,     0,     0,  1984,
       0,  2765,  2766,  2769,  2770,     0,     0,  1985,  2776,  2779,
       0,  1986,  1981,  2782,     0,     0,  2786,   691,     0,   687,
    1983,     0,     0,  1457,     0,  1984,     0,     0,     0,     0,
    2823,  1987,  1988,     0,     0,     0,     0,     0,     0,     0,
    2826, -1805,  2828,     0,     0,     0,  1989,     0,     0,     0,
    1484,  2839,  2840,  2841,     0,  2843,   691,     0,     0,     0,
       0,     0,  2856,  2857,     0,     0,     0,     0,     0,     0,
    2860,  2861,     0,     0,     0,     0,     0,     0,     0,  1990,
       0,     0,  1991,     0,     0,     0,  3547,     0,     0,     0,
   -1805,     0,     0,     0,     0,     0,  1992,     0,     0,  1993,
   -1805,     0,     0,     0, -1805,     0,     0,     0,     0, -1805,
       0,   669,   669, -1805,     0,     0, -1805,     0, -1805,     0,
       0, -2298,     0,     0,   691,  1986,   691,     0,     0,     0,
     691,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0, -1805,  1987,  1988,  1985,     0,     0,
       0,  1986,     0,  1126,  1126,     0,     0,     0,     0,     0,
   -2298,     0,     0,     0, -1805,     0,     0,     0,  1994,     0,
       0,  1987,  1988,     0,     0,     0,     0,     0,     0,     0,
       0,   691,     0,     0,     0,     0,  1989,     0,     0,     0,
       0,     0,     0,     0,   691,     0,  1991,     0,     0,     0,
       0,  1149,     0,   691,     0,     0,     0,     0, -1805,   691,
    1992,     0,     0,  1126,     0,     0,     0, -1805,     0,  1990,
     691,     0,  1991,     0,     0,     0,     0,     0,     0,  1126,
    1126,     0,  1086,     0,     0,     0,  1992,     0,     0,  1993,
       0,     0,     0,     0,     0,     0,     0,  1126,  1788,     0,
     691,  1793,     0,     0,     0,     0,     0,     0,  1995,     0,
   -1805,  1996,  1997,  1998,     0,  1999,  2000,  2001,  2002,  2003,
    2004,     0,     0,  3048,     0,  1126,  1126,     0,     0,   691,
       0,     0, -2298,     0,     0,     0,  1980,    85,     0,     0,
       0,     0,     0,    89,  1457,     0,     0,    93,     0,    94,
       0,    96,    97,     0,   958,     0,     0,     0,  1994,     0,
    1981,     0,   106,     0,     0,     0,     0,     0,  1983,     0,
     691,     0,     0,  1984,     0,     0, -1805,  1876,  1876,   119,
     120,     0,     0,   691,   953,     0,     0,     0,     0,   691,
       0,     0,     0,     0,   691,     0,     0, -1805,     0, -1805,
   -1805,     0,  1908,     0,     0,     0,   691,     0,  1914,     0,
       0,     0,     0,     0,     0,   128,     0,     0,     0,     0,
       0,     0,  1995,     0,     0,   129,     0,   130,   131,  1999,
    2000,  2001,  2002,  2003,  2004,     0,     0,  1747,     0, -1805,
       0,  1055, -1805, -1805,     0, -1805,     0,     0,  1995,     0,
       0,  1996,  1997,  1998,     0,  1999,  2000,  2001,  2002,  2003,
    2004,   141,     0,   142,   143,  3563,     0,     0,   145,   146,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   147,
       0,   148,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1985,     0,     0,   151,  1986,
     152,     0,     0,   155,     0,     0,     0,     0,     0,   156,
       0,     0,     0,   687,   687,   157,     0,     0,     0,  1987,
    1988,   158,     0,     0,     0,     0,     0,   159,     0,  1457,
       0,     0,     0,   161,  1989,   163,  1457,  1457,     0,   893,
     165,     0,     0,  3229,  3230,     0,     0,     0,     0,     0,
       0,   894,  2077,   169,  2084,     0,     0,     0,     0,     0,
    1747,     0,   691,   691,     0,     0,  3241,  1990,     0,     0,
    1991,   895,     0,     0,     0,     0,     0,     0,     0,     0,
     174,     0,     0,     0,  1992,     0,     0,  1993,     0,     0,
       0,     0,     0,     0,     0,   896,     0,     0,  3257,  3258,
    3259,  3260,     0,     0,     0,   183,   184,     0,   687,     0,
     669,   185,     0,     0,     0,   897,     0,     0,     0,     0,
     186,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   898,     0,   191,     0,
     691,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1994,     0,     0,     0,
       0,     0,     0,   899,     0,   691,     0,     0,   900,     0,
       0,     0,     0,   901,     0,   202,     0,     0,     0,     0,
       0,     0,  3868,     0,  3305,     0,   204,     0,   902,  3307,
     205,     0,   206,     0,     0,     0,     0,   207,     0,     0,
       0,     0,   208,     0,     0,   210,  1149,     0,     0,   212,
       0,     0,     0,     0,     0,   213,     0,     0,     0,     0,
       0,   214,     0,     0,   216,     0,     0,     0,     0,     0,
       0,   219,     0,     0,     0,     0,     0,  1126,  1126,  1126,
    1126,     0,     0,     0,   221,   669,  1995,     0,     0,  1996,
    1997,  1998,     0,  1999,  2000,  2001,  2002,  2003,  2004,  1788,
     226,     0,   227,  3581,  3395,   883,     0,  1126,  1126,   229,
     903,   230,     0,  1126,   231,     0,     0,     0,   232,     0,
     904,     0,  3241,     0,     0,     0,     0,     0,     0,     0,
     235,     0,     0,     0,     0,     0,     0,   817,     0,     0,
       0,     0,   883,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1980,     0,     0,  1747,     0,     0,     0,     0,
       0,   905,     0,     0,   691,   906,     0,   907,     0,  3452,
       0,   244,   669,   908,     0,   909,   691,     0,  1126,  1126,
    1126,  1126,  3461,     0,  1983,     0,     0,   669,     0,  1984,
    2218,     0,     0,  1457,     0,  1788,     0,     0,     0,     0,
       0,   910,   911,     0,     0,     0,   912,     0,     0,     0,
       0,     0,  1747,     0,   913,     0,     0,     0,     0,   914,
     687,   691,     0,     0,   691,   691,     0,     0,     0,   915,
    1149,     0,     0,   691,   691,     0,   691,     0,   691,     0,
       0,   916,     0,   691,     0,   691,   669,  1980,     0,     0,
    1126,  1126,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   691,   691,     0,     0,     0,
       0,  1747,     0,     0,     0,     0,  3550,     0,     0,  1983,
       0,     0,  1876,     0,  1984,     0,     0,   691,  1747,     0,
     691,   691,     0,     0,   691,     0,     0,     0,     0,     0,
    2479,     0,     0,     0,     0,     0,  1747,     0,     0,     0,
       0, -2298,     0,     0,     0,  1986,     0,     0,   953,   953,
       0,  4054,  2504,     0,     0,     0,  4060,  4060,     0,     0,
       0,  1747,     0,     0,     0,  1987,  1988,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
   -2298,     0,     0,     0,     0,     0,  1149,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  3817,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1991,  1747,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  4099,     0,  4101,
    1992,     0,     0,     0,     0,     0, -2298,     0,     0,   794,
    1986,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   691,     0,     0,
    1987,  1988,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0, -2298,  4129,     0,     0,     0,
       0,     0,   794,     0,     0,     0,     0,     0,     0,     0,
    3632,     0,     0,     0,     0,  3639,     0,  3641,  3642,  3643,
    3644,     0, -2298,     0,     0,     0,     0,     0,     0,     0,
       0,  1991,     0,     0,     0,     0,     0,  2084,     0,     0,
       0,     0,     0,     0,     0,  1992,     0,     0,     0,   984,
       0,     0,     0,  4164,     0,     0,   984,     0,   984,     0,
       0,     0,  4060,     0,     0,     0,     0,     0,     0,     0,
     794,     0,     0,     0,     0,     0,     0,     0,     0,  3695,
    3697,  3699,     0,  3701,     0,     0,     0,     0,     0,     0,
       0,     0,  4188,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   669,     0,     0,  1747,     0,     0,
       0,     0,  1995,     0,     0,     0,   691, -2298,     0,  1999,
    2000,  2001,  2002,  2003,  2004,  1980,     0,     0,   669,   691,
       0,     0,   669,   687,   691,     0,     0,     0,   691,     0,
       0,     0,     0,     0,   691,     0,     0,   669,     0,  1981,
     691,     0,     0,     0,     0,   669,   691,  1983,     0,     0,
       0,   691,  1984,     0,     0,  3770,  1980,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   669,   691,
       0,     0,  2763,  2764,   691,   691,   691,   691,  2771,     0,
    1981,   691,   691,     0,     0,   669,   691,     0,  1983,   691,
       0,     0,     0,  1984,  2792,  2792,     0,  1995,     0,     0,
     669,     0,   669,   691,  1999,  2000,  2001,  2002,  2003,  2004,
       0,     0,  1126,   691,     0,   691,     0,     0,     0,     0,
     669,     0,     0,     0,   691,   691,   691,   669,   691,     0,
       0,     0,     0,     0,   669,   691,   691,     0,     0,     0,
       0,   669,     0,   691,   691,     0,  1745,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1126,     0,     0,     0,
       0,     0,     0,  1126,  1126,  1126,  1126,  1126,  1126,     0,
       0,     0,     0,     0,  1985,     0,     0,     0,  1986,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2792,     0,  1987,  1988,
       0,     0,     0,     0,   953,     0,     0,     0,     0,     0,
       0,     0,     0,  1989,     0,  1985,  3856,     0,     0,  1986,
       0,     0,     0,     0,     0,     0,  2751,  3865,  2937,     0,
       0,  2218,  2758,     0,     0,  2951,     0,     0,     0,  1987,
    1988,     0,     0,     0,     0,  1793,  1990,     0,     0,  1991,
       0,     0,     0,  2982,  1989,     0,     0,  2982,  2995,     0,
       0,     0,     0,  1992,  1980,     0,  1993,     0,     0,  1745,
       0,     0,     0,     0,  1126,  2792,  1126,  2792,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1990,  1981,     0,
    1991,  1457,     0,     0,     0,     0,  1983,     0,     0,     0,
       0,  1984,     0,     0,  1992,   691,     0,  1993,     0,     0,
    1876,     0,     0,     0,   691,     0,     0,     0,     0,     0,
    3912,     0,   669,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1994,     0,     0,  3928,     0,
       0,     0,     0,     0,     0,     0,   691,     0,  1747,     0,
     669,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1994,     0,     0,  1980,
       0,     0,     0,     0,  3962,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1981,     0,     0,     0,     0,     0,  2045,
    2218,  1983,     0,     0,     0,     0,  1984,     0,     0,     0,
       0,     0,     0,  1985,  3125,  1995,     0,  1986,  1996,  1997,
    1998,     0,  1999,  2000,  2001,  2002,  2003,  2004,     0,     0,
       0,     0,  3590,     0,     0,     0,     0,  1987,  1988,     0,
       0,     0,     0,  1149,     0,     0,     0,     0,     0,     0,
       0,     0,  1989,     0,     0,     0,  1995,     0,     0,  1996,
    1997,  1998,     0,  1999,  2000,  2001,  2002,  2003,  2004,     0,
       0,     0,     0,  3787,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1990,     0,     0,  1991,     0,
    1457,     0,     0,     0,     0,     0,     0,     0,  1747,     0,
       0,  2084,  1992,     0,     0,  1993,     0,     0,     0,     0,
       0,     0,     0,     0,  1745,     0,     0,     0,     0,     0,
       0,     0,   794,     0,     0,     0,     0,     0,  1985,     0,
    1122,     0,  1986,     0,     0,  1122,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1745,
       0,     0,  1987,  1988,     0,   669,   691,   691,     0,     0,
       0,     0,     0,     0,     0,  1122,     0,  1989,     0,     0,
    1876,  1745,     0,     0,  1994,     0,     0,     0,     0,   691,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1990,     0,     0,  1991,     0,     0,     0,     0,     0,  1980,
       0,   691,   691,   691,   691,  1122,     0,  1992,     0,     0,
    1993,     0,  1122,     0,     0,     0,     0,     0,     0,     0,
    1745,     0,     0,  1981,     0,     0,   669,     0,   691,     0,
       0,  1983,     0,     0,     0,     0,  1984,  1745,     0,     0,
       0,     0,     0,     0,   691,     0,     0,     0,   691,     0,
       0,     0,     0,     0,  1995,  1745,     0,  1996,  1997,  1998,
       0,  1999,  2000,  2001,  2002,  2003,  2004,     0,     0,     0,
       0,  3819,     0,     0,     0,     0,     0,     0,     0,  1994,
    1745,     0,     0,     0,     0,     0,     0,   691,     0,     0,
       0,   669,   691,     0,     0,     0,     0,     0,     0,     0,
    4163,  2792,  2792,     0,     0,     0,     0,     0,  1122,     0,
       0,     0,     0,     0,   984,     0,     0,     0,   984,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3352,     0,
       0,     0,     0,  1980,     0,     0,  1745,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1122,     0,     0,
    2218,  2758,     0,  2758,     0,     0,     0,  1981,  1985,     0,
    1747,     0,  1986,     0,     0,  1983,     0,   691,   691,  1995,
    1984,     0,  1996,  1997,  1998,     0,  1999,  2000,  2001,  2002,
    2003,  2004,  1987,  1988,     0,   691,  3975,     0,     0,     0,
       0,  1747,     0,  1747,  1457,     0,     0,  1989,     0,     0,
       0,     0,   687,     0,     0,   691,  2982,     0,     0,  3433,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3446,     0,     0,     0,     0,     0,     0,     0,
    1990,     0,   691,  1991,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   691,   669,  1992,     0,     0,
    1993,     0,     0,     0,     0,     0,   691,     0,     0,   669,
       0,     0,     0,     0,     0,  1747,  2479,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   691,     0,
       0,   669,     0,     0,  1122,     0,     0,     0,     0,     0,
    2758,  1122,  1985,     0,     0,     0,  1986,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1745,     0,     0,     0,
       0,     0,  1748,  1172,     0,     0,  1987,  1988,  2758,  1994,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1989,     0,     0,  1747,     0,     0,     0,     0,     0,
       0,     0,  1122,     0,     0,  1173,     0,     0,  1747,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1174,     0,
       0,     0,     0,  2758,  1990,  1175,     0,  1991,     0,  1176,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1992,     0,     0,  1993,     0,     0,     0,     0,  1177,
       0,     0,     0,     0,     0,     0,  3567,     0,     0,  1747,
       0,     0,  1122,     0,     0,     0,     0,     0,     0,  1995,
    1178,     0,  1996,  1997,  1998,     0,  1999,  2000,  2001,  2002,
    2003,  2004,     0,     0,     0,     0,  3990,  2084,     0,     0,
       0,     0,     0,     0,     0,  1748,     0,     0,     0,     0,
       0,     0,  1179,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1994,     0,     0,     0,  1122,     0,     0,
    1747,     0,  1180,  1876,  1876,     0,  1980,     0,   669,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1747,
       0,     0,     0,     0,     0,  1122,  1181,     0,     0,     0,
    1981,     0,     0,     0,     0,     0,     0,     0,  1983,     0,
       0,     0,     0,  1984,  1747,     0,     0,   691,   691,     0,
       0,     0,     0,     0,     0,     0,  1122,  1122,     0,  1122,
       0,     0,     0,   691,     0,     0,     0,   669,   691,   669,
     691,   691,   691,   691,     0,  1745,  1122,     0,  1747,     0,
    1745,  1745,     0,  1995,  1182,     0,  1996,  1997,  1998,     0,
    1999,  2000,  2001,  2002,  2003,  2004,     0,     0,     0,     0,
    4024,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   817,     0,     0,     0,     0,     0,     0,     0,  3352,
       0,     0,     0,     0,     0,     0,     0,     0,  1122,   794,
       0,     0,   691,   691,   691,  1183,   691,     0,     0,  1184,
       0,  1185,     0,     0,     0,     0,     0,  1186,     0,     0,
       0,     0,     0,     0,     0,  1122,     0,     0,     0,  1122,
    1122,     0,  2937,     0,     0,  1985,     0,  2763,     0,  1986,
    2763,     0,  3730,     0,     0,  1187,  1188,     0,     0,     0,
    1189,     0,  2792,     0,     0,     0,     0,     0,  1190,  1987,
    1988,     0,     0,  1191,     0,     0,     0,  1745,     0,     0,
    2758,  2982,     0,   691,  1989,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2937,  1192,  3768,     0,   691,     0,
       0,     0,     0,  2792,     0,  2792,     0,     0,     0,     0,
    1748,     0,     0,     0,   794,     0,     0,  1990,   984,   669,
    1991,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1992,     0,     0,  1993,   984,  1745,
       0,     0,     0,     0,     0,  1748,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1980,    35,     0,     0,
       0,     0,     0,     0,     0,    41,     0,  1748,     0,     0,
       0,   984,     0,     0,     0,     0,     0,     0,     0,     0,
    1981,     0,     0,  1982,     0,     0,     0,     0,  1983,     0,
       0,     0,     0,  1984,     0,     0,     0,     0,  1747,     0,
       0,     0,     0,     0,     0,     0,  1994,     0,     0,     0,
       0,     0,     0,     0,  3831,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1748,     0,  1149,     0,
       0,     0,     0,  2218,     0,     0,     0,  1745,     0,     0,
       0,     0,     0,  1748,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  3852,     0,     0,     0,     0,   669,   691,
       0,  1748,     0,     0,     0,     0,     0,     0,     0,   669,
     691,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   691,   691,  1126,   691,  1748,     0,     0,     0,
       0,   794,     0,     0,     0,     0,  1995,     0,     0,  1996,
    1997,  1998,     0,  1999,  2000,  2001,  2002,  2003,  2004,     0,
       0,  1876,     0,  4125,     0,  1985,     0,     0,     0,  1986,
       0,     0,     0,     0,     0,  3352,  3352,  3352,  3352,  3352,
       0,     0,     0,     0,  1122,     0,  1122,     0,     0,  1987,
    1988,     0,  1748,     0,     0,  1122,     0,  1747,     0,     0,
       0,     0,     0,     0,  1989,     0,     0,     0,  1747,     0,
       0,     0,     0,   691,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   691,     0,     0,     0,     0,     0,  1990,     0,  3940,
    1991,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3949,     0,  1992,   691,     0,  1993,     0,     0,
       0,     0,  1122,     0,     0,  3768,     0,     0,     0,     0,
       0,     0,  1747,     0,     0,     0,     0,   691,  3730,     0,
    1747,     0,     0,   669,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1122,  1122,     0,
       0,     0,     0,     0,     0,  1122,     0,     0,  1122,     0,
       0,  1122,     0,     0,     0,     0,     0,     0,     0,  1122,
    1122,     0,     0,     0,     0,     0,  1994,  1122,     0,     0,
    1122,  1122,  1122,  1122,     0,     0,     0,     0,     0,     0,
    1122,  1122,     0,  1122,     0,  1122,     0,     0,  1122,  1745,
    1745,     0,  1745,     0,     0,     0,     0,  1149,     0,  1745,
       0,     0,  1748,  1122,   794,     0,     0,  1122,     0,     0,
       0,  1122,     0,     0,     0,  1122,     0,  1876,  1122,  1122,
    1122,  1122,  1122,  1122,  1122,  1122,  1122,     0,  1122,     0,
    1745,     0,  1745,     0,  1122,     0,     0,     0,  1122,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2792,     0,
    2763,    55,  3945,     0,     0,     0,  1995,     0,     0,  1996,
    1997,  1998,     0,  1999,  2000,  2001,  2002,  2003,  2004,     0,
       0,     0,     0,  1126,  3940,  1747,     0,     0,  1126,  1126,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   691,     0,     0,     0,     0,     0,     0,     0,
    1747,     0,     0,     0,  1745,     0,  1980,     0,     0,  1122,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  4082,     0,     0,     0,  1745,
    1981,     0,     0,     0,  2672,     0,     0,     0,  1983,     0,
       0,     0,     0,  1984,     0,     0,     0,     0,  1126,  1126,
    1126,  1126,   691,     0,     0, -1807,     0,  1745,     0,     0,
       0,  2758,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1745,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1745,     0,     0,
       0,     0,     0,     0,   794,     0,     0,  3940,  1126,     0,
       0,     0,  1745,     0, -1807,     0,     0,     0,     0,     0,
       0,  1122,     0,  2673, -1807,     0,     0,     0, -1807,  1980,
       0,     0,     0, -1807,     0,     0,     0, -1807,     0,     0,
   -1807,  1748, -1807,     0,     0,     0,  1748,  1748,  1745,     0,
       0,     0,     0,  1981,     0,     0,     0,     0,     0,  2758,
       0,  1983,     0,   691,     0,  1126,  1984,     0, -1807,     0,
     794,     0,     0,     0,  1126,  1985,     0,     0,     0,  1986,
       0,     0,     0,     0,     0,     0,  1747,  3949, -1807,     0,
       0,     0,     0,  4082,     0,     0,     0,     0,     0,  1987,
    1988,     0,   794,     0,  1126,     0,     0,     0,     0,  1745,
       0,     0,     0,     0,  1989,  4201,     0,     0,     0,  1747,
    1980,     0,     0,  1747,  1747,     0,     0,     0,  1745,     0,
       0,     0, -1807,     0,     0,     0,     0,     0,     0,     0,
       0, -1807,     0,     0,  1981,     0,     0,  1990,     0,     0,
    1991,     0,  1983,  1745,     0,     0,     0,  1984,     0,     0,
       0,  1122,     0,  1748,  1992,     0,     0,  1993,  3099,     0,
       0,  4201,     0,  3100,     0,     0,     0,     0,     0,     0,
       0,     0,  3945,     0, -1807,     0,     0,  1745,  1985,     0,
       0,     0,  1986,     0,     0,     0,  4201,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   982,  1987,  1988,     0,     0,     0,     0,   982,     0,
     982,     0,     0,     0,     0,  1748,     0,  1989,   958,     0,
       0,     0,     0,     0,     0,  1122,  1994,     0,     0,     0,
       0,     0,     0,     0,     0,  1122,     0,     0,     0,     0,
   -1807,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1990,     0,     0,  1991,     0,     0,     0,     0,     0,     0,
       0, -1807,     0, -1807, -1807,     0,     0,  1992,     0,  1985,
    1993,     0,  1122,  1986,  2674,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1987,  1988,     0,     0,     0,     0,  1745,
       0,     0,  1122, -1807,     0,     0, -1807, -1807,  1989, -1807,
       0,  1980,     0,  1748,     0,     0,  1995,     0,     0,  1996,
    1997,  1998,     0,  1999,  2000,  2001,  2002,  2003,  2004,     0,
       0,     0,  1122,  1122,     0,  1981,     0,     0,     0,  1994,
       0,  1990,     0,  1983,  1991,     0,     0,     0,  1984,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1992,     0,
       0,  1993,  1122,  1122,     0,     0,     0,  1122,     0,     0,
       0,     0,     0,     0,  3077,     0,     0,     0,     0,  1122,
    1122,  1122,  1122,     0,     0,     0,     0,   794,     0,     0,
       0,  1122,   794,     0,  1122,     0,  1122,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1122,  1122,     0,  1122,
       0,     0,     0,     0,     0,     0,     0,  1745,     0,     0,
       0,     0,  1122,     0,  1122,     0,     0,     0,  1122,  1995,
    1994,     0,  1996,  1997,  1998,     0,  1999,  2000,  2001,  2002,
    2003,  2004,     0,     0,  1122,     0,     0,     0,     0,     0,
       0,     0,  1745,     0,     0,  1122,     0,  1122,  1122,  1122,
       0,     0,     0,     0,     0,  1737,     0,     0,     0,     0,
    1985,     0,     0,     0,  1986,     0,     0,  1122,     0,     0,
       0,     0,     0,     0,     0,     0,  1122,     0,     0,     0,
    2799,     0,     0,  1122,  1987,  1988,     0,     0,  1122,     0,
       0,     0,     0,     0,     0,  1122,  1122,  1122,     0,  1989,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1995,     0,     0,  1996,  1997,  1998,     0,  1999,  2000,  2001,
    2002,  2003,  2004,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1990,  2800,     0,  1991,     0,     0,     0,  1122,
       0,     0,  2801,  2802,  2803,     0,     0,     0,     0,  1992,
       0,     0,  1993,     0,     0,     0,  1745,     0,     0,     0,
       0,     0,     0,     0,     0,  1748,  1748,  1745,  1748,     0,
    3523,     0,     0,     0,     0,  1748,     0,     0,  1737,     0,
       0,     0,     0,     0,     0,     0,  2804,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1980,     0,     0,  1748,     0,  1748,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1994,     0,     0,     0,     0,     0,  1981,  2805,     0,
    3063,  1745,     0,  2806,  3524,  1983,     0,     0,     0,  1745,
    1984,     0,   794,   794,   794,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2807,     0,     0,     0,     0,     0,     0,     0,
    1748,     0,     0,     0,     0,     0,     0,     0,     0,  2808,
    2809,  2810,  2811,  2812,     0,  2813,     0,     0,  1022,     0,
       0,     0,     0,     0,     0,  1748,     0,  1022,     0,     0,
       0,  1995,     0,     0,  1996,  1997,  1998,     0,  1999,  2000,
    2001,  2002,  2003,  2004,     0,     0,     0,     0,  2814,     0,
       0,     0,   794,  1748,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1748,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1985,  1748,  2815,     0,  1986,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1748,     0,
       0,     0,     0,     0,     0,     0,  1987,  1988,     0,     0,
       0,     0,  1119,     0,  1745,  1122,     0,  1119,     0,  1122,
    2816,  1989,  2817,     0,     0,     0,     0,     0,     0,  1122,
       0,     0,     0,     0,  1748,     0,     0,     0,     0,  1745,
       0,     0,     0,     0,     0,  2818,     0,  1119,     0,     0,
       0,     0,  2819,  1737,  1990,  2820,     0,  1991,     0,     0,
       0,  1122,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1992,     0,     0,  1993,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1737,     0,
       0,     0,  1122,     0,     0,  1748,     0,  1119,     0,     0,
    1745,  1122,     0,     0,  1119,     0,     0,  1122,     0,  1122,
    1737,     0,     0,     0,  1748,  1122,     0,     0,  1122,  1122,
    1122,  1122,  1122,  1122,  1122,  1122,  1122,  1122,     0,     0,
       0,  1122,  1122,     0,     0,     0,     0,     0,     0,  1748,
       0,     0,     0,  1994,  1122,     0,     0,     0,   794,     0,
    1122,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1122,     0,     0,  1122,     0,  1122,     0,     0,     0,  1737,
       0,     0,     0,  1748,  1122,  1122,  1122,     0,     0,     0,
    1122,     0,     0,  1122,     0,     0,  1737,     0,  1745,     0,
       0,     0,     0,  1122,     0,     0,     0,     0,     0,     0,
    1119,     0,  1122,     0,  1737,     0,   982,     0,     0,     0,
     982,     0,     0,     0,     0,  1745,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1737,
       0,     0,     0,  1995,     0,     0,  1996,  1997,  1998,  1119,
    1999,  2000,  2001,  2002,  2003,  2004,     0,     0,  1745,     0,
       0,     0,  1745,  1745,     0,  1980,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1981,
       0,     0,  3107,     0,     0,  1737,     0,  1983,     0,     0,
       0,     0,  1984,     0,   794,  1748,   794,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   794,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1119,     0,     0,     0,
       0,     0,     0,  1119,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1122,     0,     0,     0,  1746,     0,     0,     0,     0,     0,
       0,     0,     0,  1748,  1985,     0,     0,     0,  1986,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1119,     0,     0,     0,  1987,  1988,
       0,     0,     0,     0,     0,     0,     0,     0,  1748,  1122,
    1122,     0,     0,  1989,     0,  1737,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1122,     0,
       0,     0,     0,  1122,     0,  1739,  1122,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1990,     0,     0,  1991,
       0,     0,     0,     0,  1119,     0,     0,     0,     0,     0,
       0,     0,     0,  1992,     0,  1116,  1993,     0,     0,     0,
    1116,     0,  1022,     0,     0,     0,  1122,  1022,     0,  1022,
       0,     0,     0,     0,     0,  1022,     0,  1746,     0,     0,
       0,     0,  1980,  1022,     0,     0,     0,     0,  1022,     0,
    1116,     0,     0,     0,     0,     0,     0,     0,     0,  1119,
       0,     0,  1122,     0,     0,     0,  1981,     0,     0,  1122,
    1122,     0,  1748,  1980,  1983,     0,     0,  1122,  1122,  1984,
       0,     0,  1122,  1748,     0,  1994,     0,  1119,  1122,  1122,
       0,     0,  1122,     0,     0,  1022,     0,  1981,     0,     0,
    1116,     0,     0,     0,     0,  1983,     0,  1116,  1739,     0,
    1984,     0,  1122,     0,     0,     0,     0,     0,  1119,  1119,
       0,  1119,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1119,     0,
       0,     0,     0,     0,     0,     0,     0,  1748,     0,     0,
       0,     0,     0,     0,     0,  1748,     0,     0,     0,     0,
       0,  1022,     0,     0,     0,     0,  1022,     0,     0,     0,
       0,     0,     0,     0,     0,  1995,     0,  1022,  1996,  1997,
    1998,     0,  1999,  2000,  2001,  2002,  2003,  2004,     0,     0,
    1119,     0,     0,     0,  1737,     0,     0,     0,     0,  1737,
    1737,  1985,     0,     0,     0,  1986,     0,     0,  1022,     0,
       0,     0,     0,     0,     0,     0,     0,  1119,     0,     0,
       0,  1119,  1119,     0,     0,  1987,  1988,  1022,     0,     0,
       0,     0,  1985,  1022,     0,     0,  1986,     0,     0,     0,
    1989,     0,  1122,     0,     0,     0,     0,     0,     0,     0,
       0,  1022,   794,     0,     0,     0,  1987,  1988,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1989,     0,  1990,     0,     0,  1991,     0,     0,     0,
       0,     0,  1122,     0,     0,     0,     0,  1748,     0,     0,
    1992,     0,  1746,  1993,     0,     0,     0,     0,     0,     0,
     982,  1122,     0,     0,  1990,  1122,     0,  1991,     0,     0,
    1748,     0,     0,     0,     0,     0,  1737,     0,     0,     0,
     982,  1992,     0,     0,  1993,     0,     0,  1746,     0,     0,
       0,  1122,     0,     0,     0,  1748,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1746,
       0,     0,     0,   982,     0,  1122,  1122,     0,     0,  1122,
       0,     0,  1994,  1739,     0,     0,  1122,  1122,     0,     0,
    1980,     0,     0,     0,     0,     0,     0,     0,  1737,  1116,
       0,     0,     0,     0,     0,     0,  1116,  3484,     0,     0,
       0,     0,     0,  1994,  1981,     0,  1748,  3116,  1739,  1122,
       0,     0,  1983,     0,     0,     0,     0,  1984,  1746,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1739,     0,     0,     0,     0,  1746,     0,     0,     0,     0,
    1122,  1022,  1022,  1022,     0,     0,     0,  1116,     0,     0,
       0,     0,     0,  1746,     0,     0,     0,     0,     0,     0,
       0,     0,  1995,     0,     0,  1996,  1997,  1998,     0,  1999,
    2000,  2001,  2002,  2003,  2004,     0,     0,     0,  1746,     0,
       0,     0,     0,     0,     0,     0,  1737,  1122,  1122,  1739,
       0,     0,     0,  1995,  1748,     0,  1996,  1997,  1998,     0,
    1999,  2000,  2001,  2002,  2003,  2004,  1739,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1122,  1748,     0,  1122,  1739,  1122,  1119,     0,  1119,     0,
    1022,     0,     0,     0,  1746,     0,     0,  1119,     0,  1985,
       0,     0,     0,  1986,     0,     0,     0,     0,     0,  1739,
       0,  1122,     0,  1022,  1748,     0,     0,     0,  1748,  1748,
       0,     0,     0,  1987,  1988,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1989,     0,
       0,     0,   794,     0,     0,     0,     0,     0,     0,  1122,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1119,  1739,     0,     0,     0,     0,
    1122,  1990,     0,     0,  1991,     0,     0,  1748,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1992,     0,
       0,  1993,     0,     0,     0,  1122,     0,     0,     0,  1119,
    1119,     0,     0,     0,     0,     0,     0,  1119,     0,     0,
    1119,     0,     0,  1119,     0,     0,     0,     0,     0,     0,
       0,  1119,  1119,     0,     0,     0,     0,     0,     0,  1119,
    1980,     0,  1119,  1119,  1119,  1119,     0,     0,     0,     0,
       0,     0,  1119,  1119,     0,  1119,     0,  1119,     0,     0,
    1119,  1022,     0,     0,  1981,     0,     0,  3530,     0,     0,
    1994,     0,  1983,  1122,  1746,  1119,     0,  1984,     0,  1119,
       0,     0,     0,  1119,     0,     0,     0,  1119,     0,     0,
    1119,  1119,  1119,  1119,  1119,  1119,  1119,  1119,  1119,     0,
    1119,     0,     0,     0,     0,     0,  1119,     0,     0,     0,
    1119,     0,     0,     0,     0,     0,     0,     0,  1737,  1737,
       0,  1737,     0,     0,     0,     0,     0,     0,  1737,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1739,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1122,  1737,
    1995,  1737,     0,  1996,  1997,  1998,     0,  1999,  2000,  2001,
    2002,  2003,  2004,     0,     0,     0,     0,     0,     0,     0,
       0,  1119,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   843,     0,     0,     0,     0,     0,  1985,
       0,     0,     0,  1986,     0,   844,     0,     0,     0,     0,
       0,     0,  1022,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1987,  1988,   845,     0,     0,     0,     0,
       0,     0,     0,  1737,     0,     0,     0,     0,  1989,     0,
       0,     0,     0,     0,     0,   846,     0,     0,     0,  -582,
       0,     0,     0,     0,     0,     0,     0,     0,  1737,  1022,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   847,
       0,  1990,     0,     0,  1991,   848,     0,     0,     0,  1022,
       0,     0,     0,  1119,     0,     0,  1737,     0,  1992,     0,
     849,  1993,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1737,  1746,     0,     0,     0,     0,  1746,  1746,
       0,     0,     0,     0,     0,     0,  1737,   850,     0,     0,
       0,     0,  -745,   851,     0,     0,     0,   852,     0,     0,
       0,  1737,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  -724,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1994,     0,     0,     0,     0,  -447,     0,  1737,     0,     0,
       0,     0,     0,     0,  1739,     0,     0,     0,   853,  1739,
    1739,     0,     0,     0,     0,     0,     0,     0,     0,  2411,
       0,  1116,     0,     0,     0,     0,     0,     0,     0,     0,
    1116,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1022,     0,     0,     0,     0,     0,     0,
       0,     0,  1022,  1119,   854,  1746,     0,   855,  1737,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1737,     0,     0,
    1995,  -447,     0,  1996,  1997,  1998,     0,  1999,  2000,  2001,
    2002,  2003,  2004,     0,     0,     0,     0,  1116,     0,     0,
    1022,  1022,  1737,     0,     0,   856,     0,     0,     0,  -745,
       0,   857,  1022,     0,     0,     0,     0,  1746,     0,   858,
       0,     0,     0,     0,     0,     0,  1739,  1119,     0,     0,
       0,     0,     0,     0,     0,     0,  1737,  1119,     0,     0,
       0,     0,     0,     0,     0,     0,   859,   860,     0,   861,
     862,     0,     0,     0,     0,     0,     0,     0,   863,     0,
       0,     0,   864,   865,     0,     0,     0,     0,   866,     0,
       0,     0,     0,   867,  1119,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1739,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1119,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1746,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1022,     0,
       0,     0,     0,     0,  1119,  1119,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1022,     0,     0,     0,     0,  1737,     0,
       0,     0,     0,     0,  1119,  1119,     0,     0,     0,  1119,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1119,  1119,  1119,  1119,     0,  1739,     0,     0,     0,
       0,     0,     0,  1119,     0,     0,  1119,     0,  1119,     0,
       0,     0,  1022,     0,     0,     0,     0,     0,  1119,  1119,
       0,  1119,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1119,     0,  1119,     0,     0,     0,
    1119,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1119,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1119,     0,  1119,
    1119,  1119,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1737,     0,     0,  1119,
       0,     0,     0,     0,     0,     0,     0,     0,  1119,     0,
       0,     0,     0,     0,     0,  1119,     0,     0,     0,     0,
    1119,     0,     0,     0,     0,     0,     0,  1119,  1119,  1119,
       0,  1737,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1119,  1022,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1746,  1746,     0,
    1746,     0,     0,     0,     0,     0,     0,  1746,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1740,     0,     0,  1746,     0,
    1746,     0,     0,     0,     0,  1737,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1737,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1739,  1739,
       0,  1739,     0,     0,     0,     0,     0,     0,  1739,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1022,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1739,
       0,  1739,  1746,     0,     0,     0,     0,     0,     0,     0,
    1737,     0,  1022,     0,     0,     0,     0,     0,  1737,  1022,
       0,     0,     0,     0,     0,     0,     0,  1746,     0,     0,
    2411,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1740,     0,
       0,     0,     0,     0,     0,  1746,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1746,     0,  1739,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1746,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1739,     0,
    1746,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1119,     0,     0,
       0,  1119,     0,     0,     0,     0,  1739,     0,     0,     0,
       0,  1119,     0,     0,     0,     0,  1746,     0,     0,     0,
       0,     0,  1739,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1123,     0,     0,     0,  1739,  1123,     0,     0,
       0,     0,     0,  1119,     0,     0,     0,     0,     0,     0,
       0,  1739,     0,  1737,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1123,     0,     0,
       0,     0,     0,     0,  1119,     0,     0,  1746,  1737,     0,
       0,     0,     0,  1119,     0,     0,     0,  1739,     0,  1119,
       0,  1119,     0,     0,     0,     0,  1746,  1119,     0,     0,
    1119,  1119,  1119,  1119,  1119,  1119,  1119,  1119,  1119,  1119,
       0,     0,     0,  1119,  1119,     0,     0,  1123,     0,     0,
       0,  1746,     0,     0,  1123,     0,  1119,     0,     0,     0,
       0,     0,  1119,     0,  1022,     0,     0,     0,     0,  1737,
    2411,     0,  1119,     0,     0,  1119,     0,  1119,  1739,     0,
       0,     0,     0,     0,     0,  1746,  1119,  1119,  1119,     0,
       0,     0,  1119,     0,     0,  1119,     0,  1739,     0,     0,
       0,     0,     0,     0,     0,  1119,     0,     0,     0,     0,
       0,     0,     0,  1740,  1119,     0,     0,  1022,     0,     0,
       0,     0,  1739,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1740,     0,
    1123,     0,     0,     0,     0,     0,  1739,  1737,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1740,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1737,     0,     0,     0,     0,  1123,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1746,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1737,     0,     0,
       0,  1737,  1737,     0,     0,     0,     0,     0,     0,  1740,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1740,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1740,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1739,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1740,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1119,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1746,  1123,     0,     0,     0,
       0,     0,     0,  1123,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1740,     0,     0,     0,     0,
       0,  1420,     0,     0,  1749,     0,     0,     0,     0,     0,
    1746,  1119,  1119,     0,     0,     0,     0,     0,     0,  1022,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1022,
    1119,     0,     0,     0,  1123,  1119,     0,     0,  1119,     0,
    1489,     0,     0,     0,     0,  1022,  1739,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2411,     0,     0,     0,  2411,     0,     0,     0,  1119,     0,
       0,  1739,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1123,     0,     0,     0,  1022,     0,
       0,  1022,     0,     0,     0,     0,     0,     0,  1022,     0,
       0,     0,     0,     0,  1119,     0,  1116,     0,     0,     0,
       0,  1119,  1119,     0,  1746,     0,     0,  1749,     0,  1119,
    1119,     0,     0,     0,  1119,  1746,     0,  1022,     0,     0,
    1119,  1119,     0,     0,  1119,     0,     0,     0,     0,  1123,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1119,  1740,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1123,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1739,     0,     0,     0,  1746,
       0,     0,     0,     0,     0,     0,  1739,  1746,  1123,  1123,
       0,  1123,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1123,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1022,  1022,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1739,     0,     0,     0,     0,     0,     0,     0,  1739,     0,
    1123,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1119,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1123,     0,     0,
       0,  1123,  1123,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1119,     0,     0,     0,     0,  1746,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1921,     0,     0,  1119,     0,     0,     0,  1119,     0,     0,
       0,     0,  1746,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1944,     0,
       0,     0,  1749,  1119,     0,     0,     0,  1746,     0,     0,
       0,     0,     0,     0,  1740,     0,     0,     0,     0,  1740,
    1740,     0,     0,     0,     0,     0,     0,  1119,  1119,  1968,
    1969,  1119,  1972,     0,     0,     0,     0,  1749,  1119,  1119,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2010,
       0,     0,     0,  1739,     0,     0,     0,     0,     0,  1749,
       0,     0,     0,  1022,     0,     0,     0,     0,  1746,     0,
       0,  1119,     0,     0,     0,     0,     0,     0,  1739,     0,
       0,  1022,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1022,     0,     0,     0,     0,     0,     0,
       0,  2068,  1119,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1749,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2096,     0,
       0,     0,  2106,  2109,     0,  1749,  1740,     0,     0,  1739,
       0,     0,     0,  2411,     0,     0,     0,     0,  2411,  1119,
    1119,  2411,     0,  1749,     0,     0,  1746,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1749,     0,
       0,     0,  1119,  1746,     0,  1119,     0,  1119,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1740,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1119,     0,     0,  1746,     0,     0,     0,
    1746,  1746,     0,     0,     0,     0,  1123,  1739,  1123,     0,
       0,     0,     0,     0,  1749,     0,     0,  1123,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1119,     0,     0,  1739,     0,     0,     0,     0,  1022,
    1022,  1022,  1022,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1119,     0,     0,     0,     0,     0,     0,  1746,
       0,     0,     0,     0,     0,     0,     0,  1739,     0,     0,
       0,  1739,  1739,     0,     0,     0,  1740,  1119,     0,     0,
       0,     0,     0,     0,  1123,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1123,
    1123,     0,     0,     0,     0,     0,     0,  1123,     0,     0,
    1123,     0,     0,  1123,     0,     0,     0,     0,     0,     0,
       0,  1123,  1123,     0,     0,  1119,     0,     0,     0,  1123,
       0,     0,  1123,  1123,  1123,  1123,     0,     0,     0,     0,
       0,     0,  1123,  1123,     0,  1123,     0,  1123,     0,     0,
    1123,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1749,  1123,     0,     0,     0,  1123,
       0,     0,     0,  1123,     0,     0,     0,  1123,     0,     0,
    1123,  1123,  1123,  1123,  1123,  1123,  1123,  1123,  1123,     0,
    1123,     0,     0,     0,     0,     0,  1123,     0,     0,     0,
    1123,     0,     0,     0,     0,     0,     0,  1116,     0,     0,
    1119,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2411,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1123,     0,     0,     0,     0,     0,     0,  1742,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2514,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1740,  1740,
       0,  1740,     0,     0,  1116,     0,     0,     0,  1740,     0,
    2536,     0,     0,  2538,     0,     0,  2549,     0,     0,     0,
       0,     0,     0,  2556,  2561,     0,     0,     0,  2566,     0,
       0,  2571,     0,     0,     0,  1116,     0,     0,     0,  1740,
       0,  1740,     0,     0,  1022,     0,  2580,     0,     0,     0,
    2586,     0,     0,  1123,  2598,     0,     0,     0,  2605,     0,
       0,  2607,  2608,  2609,  2610,  2611,  2612,  2613,  2614,  2615,
    1022,  2616,     0,  1749,     0,     0,     0,  1420,  1749,  1749,
       0,  1742,  1116,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1022,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1740,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1740,     0,
       0,     0,     0,  1022,     0,     0,     0,     0,     0,     0,
       0,     0,  1489,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1740,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1740,     0,  1116,     0,     0,     0,  1743,     0,
       0,     0,     0,  1123,     0,  1749,  1740,     0,     0,     0,
       0,     0,     0,     0,     0,  1116,     0,     0,     0,     0,
       0,  1740,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1740,     0,     0,
       0,     0,     0,     0,  2735,     0,     0,  1749,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1123,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1123,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1116,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1740,     0,
       0,  1743,     0,     0,  1123,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1740,     0,     0,
       0,     0,     0,     0,     0,     0,  1742,     0,     0,     0,
       0,     0,     0,     0,  1123,     0,     0,     0,     0,     0,
       0,     0,  1740,     0,     0,  1749,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1744,     0,     0,     0,     0,
       0,  1742,     0,     0,  1123,  1123,     0,     0,     0,     0,
       0,     0,     0,  1116,     0,     0,  1740,     0,     0,     0,
       0,     0,     0,  1742,  2894,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1123,  1123,     0,     0,     0,  1123,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1123,  1123,  1123,  1123,     0,     0,     0,     0,     0,
       0,     0,     0,  1123,     0,     0,  1123,     0,  1123,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1123,  1123,
       0,  1123,  1742,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1123,     0,  1123,     0,     0,  1742,
    1123,     0,     0,     0,     0,     0,     0,     0,  2999,     0,
       0,     0,     0,     0,     0,     0,  1123,  1742,  1744,     0,
       0,     0,     0,     0,     0,     0,     0,  1123,     0,  1123,
    1123,  1123,     0,     0,     0,     0,     0,     0,  1740,     0,
       0,     0,  1742,     0,     0,  3020,     0,     0,     0,  1123,
       0,     0,     0,     0,     0,     0,     0,     0,  1123,     0,
       0,     0,     0,     0,     0,  1123,     0,     0,     0,     0,
    1123,     0,     0,     0,     0,  1420,     0,  1123,  1123,  1123,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1743,     0,  1742,     0,
       0,     0,     0,     0,     0,     0,  3059,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1123,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1743,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1749,  1749,     0,
    1749,     0,  2561,  1743,  2561,  2561,  1740,  1749,     0,     0,
       0,     0,     0,     0,  3119,     0,     0,  3122,     0,  3124,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1749,     0,
    1749,  1740,     0,     0,     0,  3145,     0,  3147,     0,     0,
       0,  3150,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1743,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1743,
       0,     0,  3165,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1743,     0,     0,
    3195,     0,     0,     0,     0,     0,     0,     0,     0,  1489,
       0,     0,  1749,     0,     0,     0,  2096,     0,  1742,     0,
       0,  3209,  1743,  1744,     0,     0,     0,     0,  2109,  2109,
    2106,     0,     0,     0,     0,     0,     0,  1749,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1740,     0,     0,  1744,     0,
       0,     0,     0,     0,     0,  1749,  1740,     0,     0,     0,
       0,     0,  3232,     0,     0,     0,     0,     0,  1743,     0,
    1744,  1749,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1749,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1749,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1123,     0,     0,
    1740,  1123,     0,     0,     0,     0,     0,     0,  1740,  1744,
       0,  1123,     0,     0,     0,     0,  1749,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1744,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1123,  1744,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1744,
       0,     0,     0,     0,  1123,     0,     0,  1749,     0,     0,
       0,     0,     0,  1123,     0,     0,     0,     0,     0,  1123,
       0,  1123,     0,     0,     0,     0,  1749,  1123,     0,     0,
    1123,  1123,  1123,  1123,  1123,  1123,  1123,  1123,  1123,  1123,
       0,     0,     0,  1123,  1123,     0,     0,  1742,  1743,     0,
       0,  1749,  1742,  1742,     0,  1744,  1123,     0,     0,     0,
       0,     0,  1123,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1123,     0,     0,  1123,     0,  1123,     0,     0,
       0,     0,     0,     0,     0,  1749,  1123,  1123,  1123,     0,
       0,     0,  1123,  1740,     0,  1123,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1123,     0,     0,     0,     0,
       0,     0,     0,     0,  1123,     0,     0,     0,  1740,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1742,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1740,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  3485,     0,  1749,     0,     0,
       0,     0,     0,     0,  3488,     0,     0,     0,     0,     0,
    3489,     0,  3490,     0,     0,  1744,     0,     0,     0,     0,
       0,  1742,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3508,  3509,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2566,     0,     0,     0,  1740,     0,     0,
       0,     0,     0,  3534,     0,     0,  3537,  1743,  3539,     0,
       0,     0,  1743,  1743,     0,     0,     0,  3543,     0,     0,
       0,     0,     0,  3548,  1740,     0,  3551,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3558,     0,     0,     0,
       0,     0,  1123,     0,     0,  3020,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1749,     0,  1740,     0,  1742,
       0,  1740,  1740,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1749,  1123,  1123,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1123,     0,  2006,     0,     0,  1123,     0,     0,  1123,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1743,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1123,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2006,     0,     0,  1744,     0,     0,     0,     0,  1744,
    1744,  1743,     0,     0,  1123,     0,     0,     0,     0,     0,
       0,  1123,  1123,     0,  1749,     0,     0,     0,     0,  1123,
    1123,     0,     0,     0,  1123,  1749,     0,     0,     0,     0,
    1123,  1123,     0,     0,  1123,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1123,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1749,
       0,     0,     0,     0,     0,     0,     0,  1749,     0,  1743,
       0,     0,  3742,  3743,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1744,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1742,  1742,     0,  1742,     0,     0,     0,     0,     0,
       0,  1742,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3785,
       0,     0,  1742,     0,  1742,     0,     0,     0,  1744,     0,
       0,     0,     0,     0,  1123,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3801,  3803,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1123,  3810,     0,     0,     0,  1749,
       0,  3815,  3816,     0,     0,  3818,     0,     0,     0,     0,
       0,     0,     0,  1123,     0,     0,  1742,  1123,     0,     0,
       0,     0,  1749,     0,     0,  3832,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1742,     0,  1123,     0,     0,  1744,  1749,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1123,  1123,  1742,
       0,  1123,     0,     0,     0,     0,     0,     0,  1123,  1123,
       0,     0,     0,     0,     0,  1742,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1742,
       0,     0,     0,     0,     0,     0,     0,     0,  1749,     0,
       0,  1123,     0,     0,  1742,     0,     0,     0,     0,     0,
       0,     0,  2006,     0,     0,     0,     0,     0,     0,     0,
       0,  1743,  1743,     0,  1743,     0,     0,     0,     0,     0,
       0,  1743,  1123,     0,     0,     0,     0,     0,     0,     0,
    1742,     0,     0,     0,     0,  3900,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1743,     0,  1743,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1123,
    1123,     0,     0,  2006,     0,     0,  1749,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1742,     0,     0,  3952,     0,  2006,     0,     0,     0,
       0,  2545,  1123,  1749,     0,  1123,     0,  1123,     0,     0,
    1742,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2006,  2006,     0,     0,  2006,     0,  1743,     0,     0,     0,
       0,     0,     0,  1123,     0,  1742,  1749,     0,     0,     0,
    1749,  1749,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1743,  3983,     0,     0,     0,     0,     0,     0,     0,
    3985,     0,  2006,     0,     0,     0,     0,     0,     0,  1742,
       0,  1123,     0,     0,     0,     0,     0,     0,     0,  1743,
       0,     0,     0,     0,     0,     0,     0,     0,  1744,  1744,
       0,  1744,  1123,     0,     0,  1743,     0,     0,  1744,  1749,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1743,
       0,     0,     0,     0,     0,     0,     0,  1123,     0,     0,
    2006,     0,     0,     0,  1743,     0,     0,     0,     0,  1744,
       0,  1744,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2006,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2006,     0,
    1743,  2006,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  4056,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1123,     0,     0,     0,     0,
       0,  1742,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1744,     0,     0,  2566,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1743,     0,     0,     0,     0,     0,     0,  1744,     0,
       0,     0,     0,     0,  4090,     0,     0,     0,     0,     0,
    1743,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1744,     0,     0,     0,
       0,     0,     0,     0,     0,  1743,     0,     0,     0,     0,
    1123,     0,  1744,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1744,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1743,
       0,  1744,     0,     0,     0,     0,     0,     0,     0,  1742,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     4,
       0,     0,     0,     0,     0,     0,     0,  1744,     0,     0,
       0,     0,     0,     0,  1742,     0,     0,     0,     0,     5,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     6,
       7,     0,     0,     0,     0,     0,     0,     9,    10,     0,
       0,    11,    12,    13,    14,    15,    16,    17,    18,    19,
      20,    21,    22,    23,    24,    25,    26,    27,    28,    29,
      30,    31,    32,    33,    34,     0,    35,     0,  1744,     0,
      37,    38,    39,    40,    41,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1744,     0,     0,
       0,  1743,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1744,     0,     0,     0,     0,    42,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1742,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1742,
       0,     0,     0,     0,     0,     0,  1744,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    43,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    44,  1742,     0,     0,     0,     0,     0,  1743,
       0,  1742,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    45,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2006,     0,     0,     0,
       0,     0,    46,     0,  1743,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2006,     0,
    2006,     0,  2545,  2545,  3095,     0,     0,  2545,  1744,     0,
       0,  2006,     0,     0,     0,     0,    47,     0,  2006,    48,
       0,     0,     0,  2006,     0,     0,     0,     0,  2006,     0,
       0,     0,     0,  2006,     0,     0,     0,     0,     0,     0,
       0,    49,  2006,     0,     0,     0,  2545,  2545,  2006,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2006,     0,     0,     0,     0,     0,     0,  2006,     0,  2006,
    2006,  2006,  2006,  2006,  2006,  2006,  2006,  2006,  2006,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1743,     0,
       0,     0,     0,     0,     0,     0,  1742,     0,     0,  1743,
       0,     0,     0,    50,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1744,     0,     0,     0,
       0,  1742,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    51,     0,     0,     0,     0,     0,     0,
       0,  1744,     0,     0,     0,     0,    52,     0,     0,     0,
       0,     0,     0,  1743,     0,     0,     0,     0,     0,    53,
       0,  1743,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1742,     0,     0,     0,     0,  2006,     0,     0,
       0,     0,     0,     0,    54,     0,     0,     0,     0,     0,
      55,    56,    57,     0,     0,     0,    58,     0,    59,     0,
       0,     0,    60,    61,    62,    63,    64,     0,     0,    65,
      66,  1279,     0,     0,     0,     0,    71,  1280,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1744,     0,     0,     0,     0,
    1742,     0,     0,     0,     0,     0,  1744,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1742,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1743,     0,     0,     0,
    1742,     0,     0,     0,  1742,  1742,     0,     0,     0,     0,
    1744,     0,     0,     0,     0,     0,  2006,     0,  1744,     0,
       0,  1743,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     4,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     5,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     6,     7,     0,     0,     0,     0,     0,     0,
       9,    10,  1743,     0,    11,    12,    13,    14,    15,    16,
      17,    18,    19,    20,    21,    22,    23,    24,    25,    26,
      27,    28,    29,    30,    31,    32,    33,    34,     0,    35,
       0,     0,     0,    37,    38,    39,    40,    41,     0,     0,
       0,  2006,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2006,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1743,     0,     0,  1744,     0,     0,     0,     0,     0,     0,
       0,  2006,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1743,  1744,     0,
       0,     0,  3095,  3095,     0,  2545,     0,     0,  2545,  2545,
    2545,  2545,  2545,  2545,  2545,  2545,  2545,  2545,  3095,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1743,    43,     0,     0,  1743,  1743,     0,     0,     0,     0,
       0,  2006,     0,     0,  2006,    44,  2006,     0,     0,     0,
       0,  3095,  3095,     0,     0,     0,     0,     0,     0,  1744,
       0,     0,     0,     0,    45,  2545,  2545,  2006,     0,  2006,
       0,     0,  2006,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    46,     0,  2006,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2006,     0,    47,
       0,     0,    48,     0,     0,     0,     0,     0,     0,     0,
       0,  2006,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    49,     0,     0,  1744,     0,     0,
       0,     0,     0,     0,  2006,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1744,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1744,     0,     0,
       0,  1744,  1744,     0,     0,     0,    50,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    51,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    52,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    53,     0,     0,     0,     0,     0,     0,     0,
    2545,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    54,     0,     0,
       0,     0,     0,    55,    56,    57,     0,     0,     0,    58,
       4,    59,     0,     0,     0,    60,    61,    62,    63,    64,
       0,     0,    65,    66,  1279,  1844,     0,     0,     0,    71,
       5,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       6,     7,     0,     0,     0,     0,     0,     0,     9,    10,
       0,     0,    11,    12,    13,    14,    15,    16,    17,    18,
      19,    20,    21,    22,    23,    24,    25,    26,    27,    28,
      29,    30,    31,    32,    33,    34,     0,    35,     0,     0,
       0,    37,    38,    39,    40,    41,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2006,     0,     0,
    2006,  2006,  2006,     0,     0,  3095,     0,     0,     0,     0,
    3095,  3095,  3095,  3095,  3095,  3095,  3095,  3095,  3095,  3095,
    2006,  2006,     0,     0,     0,     0,     0,     0,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2006,  2545,  2545,  2006,
       0,  2006,     0,     0,     0,  2006,  3095,  3095,     0,     0,
    2006,     0,     0,  2006,     0,     0,     0,     0,     0,     0,
    2006,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    43,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    44,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    45,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    46,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    47,     0,     0,
      48,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    49,     0,  3095,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2006,  2006,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    50,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2006,     0,     0,
       0,  2545,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2006,     0,  2006,     0,     0,     0,     0,
    3095,  3095,  2006,     0,    51,  2545,  2545,  2006,  2006,     0,
    2006,     0,     0,     0,     0,     0,     0,    52,     0,     0,
       0,     0,     0,     0,  2006,     0,     0,     0,     0,     0,
      53,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    54,     0,     0,     0,     0,
       0,    55,    56,    57,     0,     0,     0,    58,     0,    59,
       0,     0,     0,    60,    61,    62,    63,    64,     0,     0,
      65,    66,  1279,  2446,     0,     0,     0,    71,     0,     0,
       0,     0,  2006,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2006,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3095,
    2545,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  3095,  3095,  2006,     0,  2006,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   694,    86,    87,    88,   400,    90,    91,    92,
     401,     0,   402,    95,     0,     0,    98,    99,   100,   101,
     102,   103,   695,   104,   105,   403,   696,     0,   107,   108,
     109,   110,   697,   698,   112,   113,   114,   115,  2006,   116,
     699,   700,   404,   405,     0,     0,     0,   406,   407,     0,
       0,     0,     0,   408,     0,  3095,     0,     0,     0,     0,
       0,     0,   409,     0,   410,     0,   411,   412,     0,    35,
       0,     0,  2006,     0,     0,     0,     0,    41,   414,   415,
     416,   417,   418,   419,   420,   421,   701,   422,   423,   424,
     702,   703,   704,   705,   706,   707,   708,   425,   426,   709,
     427,   133,   428,   429,   430,   135,   136,   137,   138,   139,
     710,   431,   432,   433,   434,   435,   711,   712,   436,   437,
     713,   140,   439,   714,   440,   441,   442,   443,   144,   715,
     716,   444,   445,   446,   447,   448,   717,   718,   450,   451,
     452,   453,   454,   455,   719,   456,   457,   458,   149,   459,
     720,   721,   722,   723,   150,   724,   725,   726,   460,   461,
     462,   463,   464,   465,   153,   154,   466,   727,   467,   728,
     468,   469,   470,   471,   472,   729,   473,   474,   475,   730,
     731,   476,   477,   478,   479,   480,   732,   481,   482,   483,
     733,   484,   485,   734,   486,   487,   488,   162,   489,   490,
     164,   735,   491,   736,   492,   166,   493,   737,   494,   738,
     495,   167,   739,   168,   496,   497,   740,   498,   170,   741,
     499,   742,   500,   501,   502,   503,   504,   171,   505,   506,
     507,   743,   508,   509,   510,   511,   512,   513,   744,   172,
     173,   745,   514,   515,   516,   746,   175,   747,   176,   748,
     517,   177,   178,   518,   179,   519,   520,   521,   522,   523,
     524,   525,   749,   180,   181,   526,   182,   750,   527,   528,
     529,   751,   752,   530,   531,   532,   533,   534,   535,   536,
     537,   538,   539,   540,   541,   542,   187,   188,   189,   753,
     543,   544,   545,   546,   547,   548,   549,   190,   550,   754,
     551,   552,   192,   553,   755,   193,   554,   194,   555,   556,
     756,   757,   557,   758,   759,   760,   558,   559,   560,   761,
     762,   195,   196,   197,   198,   199,   561,   562,   563,   564,
     565,   566,   763,   567,   200,   568,   201,   569,   570,   571,
     764,   572,   573,   574,   575,   576,   577,   578,   203,   579,
     580,   581,   765,   582,   583,   584,   585,   586,   587,   588,
     589,   590,   591,   766,   592,   593,   209,   594,   595,   211,
     596,   597,   598,   599,   600,   601,   602,   603,   767,   604,
     605,   606,   607,   768,   608,   215,   609,   610,   217,   611,
     218,   769,   612,   613,   614,   615,   616,   617,   618,   619,
     620,   621,   220,   622,   770,   623,   624,   771,   625,   626,
     627,   628,   629,   772,   222,   223,   773,   774,   631,   224,
     632,   225,   775,   633,   634,   635,   636,   637,   638,   776,
     777,   639,   640,   641,   642,   778,   779,   643,   644,   645,
     646,   780,   233,   781,   648,   234,   649,   650,   651,   782,
     783,   652,   784,   785,   653,   654,   655,   656,   657,   236,
     237,   238,   239,   240,   241,   242,   243,   658,   659,   660,
       0,     0,     0,    55,    85,     0,     0,    86,    87,    88,
      89,    90,    91,    92,    93,     0,    94,    95,    96,    97,
      98,    99,   100,   101,   102,   103,     0,   104,   105,   106,
     920,     0,   107,   108,   109,   110,     0,   111,   112,   113,
     114,   115,     0,   116,   117,   118,   119,   120,     0,     0,
       0,   121,   122,     0,     0,     0,     0,   123,     0,     0,
       0,     0,     0,     0,     0,     0,   124,     0,   125,     0,
     126,   127,     0,    35,     0,     0,     0,     0,     0,     0,
       0,    41,   128,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   129,     0,   130,   131,     0,     0,     0,     0,
       0,     0,     0,     0,   132,   133,     0,     0,   134,   135,
     136,   137,   138,   139,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   140,     0,     0,   141,     0,
     142,   143,   144,     0,     0,   145,   146,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   147,     0,   148,     0,
       0,     0,   149,     0,     0,     0,     0,     0,   150,     0,
       0,     0,     0,     0,     0,   151,     0,   152,   153,   154,
     155,     0,     0,     0,     0,     0,   156,     0,     0,     0,
       0,     0,   157,     0,     0,     0,     0,     0,   158,     0,
       0,     0,     0,     0,   159,   160,     0,     0,     0,     0,
     161,   162,   163,     0,   164,     0,     0,   165,     0,   166,
       0,     0,     0,     0,     0,   167,     0,   168,     0,     0,
     169,     0,   170,     0,     0,     0,     0,     0,     0,     0,
       0,   171,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   172,   173,     0,     0,   174,     0,     0,
     175,     0,   176,     0,     0,   177,   178,     0,   179,     0,
       0,     0,     0,     0,     0,     0,     0,   180,   181,     0,
     182,     0,   183,   184,     0,     0,     0,     0,   185,     0,
       0,     0,     0,     0,     0,     0,     0,   186,     0,     0,
     187,   188,   189,     0,     0,     0,     0,     0,     0,     0,
       0,   190,     0,     0,     0,   191,   192,     0,     0,   193,
       0,   194,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   195,   196,   197,   198,   199,
       0,     0,     0,     0,     0,     0,     0,     0,   200,     0,
     201,     0,   202,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   203,   204,     0,     0,     0,   205,     0,   206,
       0,     0,     0,     0,   207,     0,     0,     0,     0,   208,
     209,     0,   210,   211,     0,     0,   212,     0,     0,     0,
       0,     0,   213,     0,     0,     0,     0,     0,   214,   215,
       0,   216,   217,     0,   218,     0,     0,     0,   219,     0,
       0,     0,     0,     0,     0,     0,   220,     0,     0,     0,
       0,   221,     0,     0,     0,     0,     0,     0,   222,   223,
       0,     0,     0,   224,     0,   225,     0,   226,     0,   227,
       0,     0,     0,   228,     0,     0,   229,     0,   230,     0,
       0,   231,     0,     0,     0,   232,   233,     0,     0,   234,
       0,     0,     0,     0,     0,     0,     0,   235,     0,     0,
       0,     0,     0,   236,   237,   238,   239,   240,   241,   242,
     243,     0,     0,     0,     0,     0,     0,    55,     0,    86,
      87,    88,     0,    90,    91,    92,     0,     0,     0,    95,
       0,     0,    98,    99,   100,   101,   102,   103,   244,   104,
     105,     0,  -122,     0,   107,   108,   109,   110,     0,   111,
     112,   113,   114,   115,     0,   116,   117,   118,     0,     0,
       0,     0,     0,   121,   122,     0,     0,     0,     0,   123,
       0,     0,     0,     0,     0,     0,     0,     0,   124,     0,
     125,     0,   126,     0,     0,    35,     0,     0,     0,     0,
       0,     0,     0,    41,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   133,     0,     0,
       0,   135,   136,   137,   138,   139,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   140,     0,     0,
       0,     0,     0,     0,   144,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   149,     0,     0,     0,     0,     0,
     150,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     153,   154,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   160,     0,     0,
       0,     0,     0,   162,     0,     0,   164,     0,     0,     0,
       0,   166,     0,     0,     0,     0,     0,   167,     0,   168,
       0,     0,     0,     0,   170,     0,     0,     0,     0,     0,
       0,     0,     0,   171,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   172,   173,     0,     0,     0,
       0,     0,   175,     0,   176,     0,     0,   177,   178,     0,
     179,     0,     0,     0,     0,     0,     0,     0,     0,   180,
     181,     0,   182,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   187,   188,   189,     0,     0,     0,     0,     0,
       0,     0,     0,   190,     0,     0,     0,     0,   192,     0,
       0,   193,     0,   194,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   195,   196,   197,
     198,   199,     0,     0,     0,     0,     0,     0,     0,     0,
     200,     0,   201,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   203,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   209,     0,     0,   211,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   215,     0,     0,   217,     0,   218,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   220,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     222,   223,     0,     0,     0,   224,     0,   225,     0,     0,
       0,     0,     0,     0,     0,   228,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   233,     0,
       0,   234,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   236,   237,   238,   239,   240,
     241,   242,   243,     0,     0,     0,     0,     0,     0,    55,
       0,     0,     0,    86,    87,    88,     0,    90,    91,    92,
       0,     0,     0,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,     0,     0,  2694,   107,   108,
     109,   110,     0,   111,   112,   113,   114,   115,     0,   116,
     117,   118,     0,     0,     0,     0,     0,   121,   122,     0,
       0,     0,     0,   123,     0,     0,     0,     0,     0,     0,
       0,     0,   124,     0,   125,     0,   126,     0,     0,    35,
       0,     0,     0,     0,     0,     0,     0,    41,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   133,     0,     0,     0,   135,   136,   137,   138,   139,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   140,     0,     0,     0,     0,     0,     0,   144,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   149,     0,
       0,     0,     0,     0,   150,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   153,   154,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   160,     0,     0,     0,     0,     0,   162,     0,     0,
     164,     0,     0,     0,     0,   166,     0,     0,     0,     0,
       0,   167,     0,   168,     0,     0,     0,     0,   170,     0,
       0,     0,     0,     0,     0,     0,     0,   171,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   172,
     173,     0,     0,     0,     0,     0,   175,     0,   176,     0,
       0,   177,   178,     0,   179,     0,     0,     0,     0,     0,
       0,     0,     0,   180,   181,     0,   182,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   187,   188,   189,     0,
       0,     0,     0,     0,     0,     0,     0,   190,     0,     0,
       0,     0,   192,     0,     0,   193,     0,   194,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   195,   196,   197,   198,   199,     0,     0,     0,     0,
       0,     0,     0,     0,   200,     0,   201,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   203,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   209,     0,     0,   211,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   215,     0,     0,   217,     0,
     218,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   220,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   222,   223,     0,     0,     0,   224,
       0,   225,     0,     0,     0,     0,     0,     0,     0,   228,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   233,     0,     0,   234,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   236,
     237,   238,   239,   240,   241,   242,   243,     4,     0,     0,
       0,     0,     0,    55,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     5,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     6,     7,     0,
       0,  2696,     0,     0,     0,     9,    10,     0,     0,    11,
      12,    13,    14,    15,    16,    17,    18,    19,    20,    21,
      22,    23,    24,    25,    26,    27,    28,    29,    30,    31,
      32,    33,    34,     0,    35,     0,     0,     0,    37,    38,
      39,    40,    41,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    42,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    43,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      44,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    45,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      46,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    47,     0,     0,    48,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    49,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    50,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    51,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    52,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    53,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    54,     0,     0,     0,     0,     0,    55,    56,
      57,     0,     0,     0,    58,     0,    59,     0,     0,     0,
      60,    61,    62,    63,    64,     0,     0,    65,    66,  1279,
       0,     0,     0,     0,    71,   694,    86,    87,    88,   400,
      90,    91,    92,   401,     0,   402,    95,     0,     0,    98,
      99,   100,   101,   102,   103,   695,   104,   105,   403,   696,
       0,   107,   108,   109,   110,   697,   698,   112,   113,   114,
     115,     0,   116,   699,   700,   404,   405,     0,     0,     0,
     406,   407,     0,     0,     0,     0,   408,     0,     0,     0,
       0,     0,     0,     0,     0,   409,     0,   410,     0,   411,
     412,     0,    35,   413,     0,     0,    37,    38,    39,    40,
      41,   414,   415,   416,   417,   418,   419,   420,   421,  2635,
     422,   423,   424,     0,     0,     0,     0,  1341,     0,     0,
     425,   426,     0,   427,   133,   428,   429,   430,   135,  1342,
     137,  1343,  1344,     0,   431,   432,   433,   434,   435,  1345,
    1346,   436,   437,  1347,  1348,   439,     0,   440,   441,   442,
     443,  1349,     0,     0,   444,   445,   446,   447,   448,   449,
       0,   450,   451,   452,   453,   454,   455,     0,   456,   457,
     458,   149,   459,     0,  1350,  1351,  1352,  1353,  1354,  1355,
    1356,   460,   461,   462,   463,   464,   465,  1357,  1358,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,  2636,     0,   476,   477,  1359,   479,   480,     0,
     481,   482,   483,     0,   484,   485,     0,   486,   487,   488,
    1360,   489,   490,  1361,  1362,   491,     0,   492,  1363,   493,
       0,   494,     0,   495,   167,     0,   168,   496,   497,     0,
     498,  1364,     0,   499,     0,   500,   501,   502,   503,   504,
     171,   505,   506,   507,     0,   508,   509,   510,   511,   512,
     513,     0,   172,   173,     0,   514,   515,   516,  1365,  1366,
       0,  1367,     0,   517,   177,   178,   518,   179,   519,   520,
     521,   522,   523,   524,   525,     0,  1368,   181,   526,   182,
       0,   527,   528,   529,  1369,  1370,   530,   531,   532,   533,
     534,   535,   536,   537,   538,   539,   540,   541,   542,  1371,
     188,  1372,  1018,   543,   544,   545,   546,   547,   548,   549,
     190,   550,  1373,   551,   552,   192,   553,  1374,  1375,   554,
    1376,   555,   556,     0,     0,   557,  1019,     0,     0,  1377,
     559,   560,     0,     0,   195,   196,   197,   198,  1378,   561,
     562,   563,   564,   565,   566,     0,   567,  1379,   568,   201,
     569,   570,   571,     0,   572,   573,   574,   575,   576,   577,
     578,  1380,   579,   580,   581,     0,   582,   583,   584,   585,
     586,   587,   588,   589,   590,   591,     0,   592,   593,   209,
     594,   595,  1381,   596,   597,   598,   599,   600,   601,   602,
     603,     0,   604,   605,   606,   607,  1382,   608,   215,   609,
     610,   217,   611,  1383,     0,   612,   613,   614,   615,   616,
     617,   618,   619,   620,   621,  1384,   622,     0,   623,   624,
       0,   625,   626,   627,   628,   629,     0,  1385,  1386,     0,
       0,   631,  1387,   632,  1388,  1389,   633,   634,   635,   636,
     637,   638,     0,  1390,   639,   640,   641,   642,  1391,     0,
     643,   644,   645,   646,   647,  1392,  2637,   648,   234,   649,
     650,   651,     0,     0,   652,     0,     0,   653,   654,   655,
     656,   657,   236,  1393,  1394,  1395,  1396,  1397,  1398,  1399,
     658,   659,   660,     0,     0,     0,    55,    56,    57,  1400,
    1401,  1402,    58,  1403,     0,     0,     0,     0,  1404,  1405,
    2638,     0,     0,     0,     0,     0,     0,  1407,  2639,   694,
      86,    87,    88,   400,    90,    91,    92,   401,     0,   402,
      95,     0,     0,    98,    99,   100,   101,   102,   103,   695,
     104,   105,   403,   696,     0,   107,   108,   109,   110,   697,
     698,   112,   113,   114,   115,     0,   116,   699,   700,   404,
     405,     0,     0,     0,   406,   407,     0,     0,     0,     0,
     408,     0,     0,     0,     0,     0,     0,     0,     0,   409,
       0,   410,     0,   411,   412,     0,    35,   413,     0,     0,
      37,    38,    39,    40,    41,   414,   415,   416,   417,   418,
     419,   420,   421,     0,   422,   423,   424,     0,     0,     0,
       0,  1341,     0,     0,   425,   426,     0,   427,   133,   428,
     429,   430,   135,  1342,   137,  1343,  1344,     0,   431,   432,
     433,   434,   435,  1345,  1346,   436,   437,  1347,  1348,   439,
       0,   440,   441,   442,   443,  1349,     0,     0,   444,   445,
     446,   447,   448,   449,     0,   450,   451,   452,   453,   454,
     455,     0,   456,   457,   458,   149,   459,     0,  1350,  1351,
    1352,  1353,  1354,  1355,  1356,   460,   461,   462,   463,   464,
     465,  1357,  1358,   466,     0,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
    1359,   479,   480,     0,   481,   482,   483,     0,   484,   485,
       0,   486,   487,   488,  1360,   489,   490,  1361,  1362,   491,
       0,   492,  1363,   493,     0,   494,     0,   495,   167,     0,
     168,   496,   497,     0,   498,  1364,     0,   499,     0,   500,
     501,   502,   503,   504,   171,   505,   506,   507,     0,   508,
     509,   510,   511,   512,   513,     0,   172,   173,     0,   514,
     515,   516,  1365,  1366,     0,  1367,     0,   517,   177,   178,
     518,   179,   519,   520,   521,   522,   523,   524,   525,     0,
    1368,   181,   526,   182,     0,   527,   528,   529,  1369,  1370,
     530,   531,   532,   533,   534,   535,   536,   537,   538,   539,
     540,   541,   542,  1371,   188,  1372,  1018,   543,   544,   545,
     546,   547,   548,   549,   190,   550,  1373,   551,   552,   192,
     553,  1374,  1375,   554,  1376,   555,   556,     0,     0,   557,
    1019,     0,     0,  1377,   559,   560,     0,     0,   195,   196,
     197,   198,  1378,   561,   562,   563,   564,   565,   566,     0,
     567,  1379,   568,   201,   569,   570,   571,     0,   572,   573,
     574,   575,   576,   577,   578,  1380,   579,   580,   581,     0,
     582,   583,   584,   585,   586,   587,   588,   589,   590,   591,
       0,   592,   593,   209,   594,   595,  1381,   596,   597,   598,
     599,   600,   601,   602,   603,     0,   604,   605,   606,   607,
    1382,   608,   215,   609,   610,   217,   611,  1383,     0,   612,
     613,   614,   615,   616,   617,   618,   619,   620,   621,  1384,
     622,     0,   623,   624,     0,   625,   626,   627,   628,   629,
       0,  1385,  1386,     0,     0,   631,  1387,   632,  1388,  1389,
     633,   634,   635,   636,   637,   638,     0,  1390,   639,   640,
     641,   642,  1391,     0,   643,   644,   645,   646,   647,  1392,
       0,   648,   234,   649,   650,   651,     0,     0,   652,     0,
       0,   653,   654,   655,   656,   657,   236,  1393,  1394,  1395,
    1396,  1397,  1398,  1399,   658,   659,   660,     0,     0,     0,
      55,    56,    57,  1400,  1401,  1402,    58,  1403,     0,     0,
       0,     0,  1404,  1405,     0,     0,     0,     0,     0,     0,
       0,  1407,  2547,   694,    86,    87,    88,   400,    90,    91,
      92,   401,     0,   402,    95,     0,     0,    98,    99,   100,
     101,   102,   103,   695,   104,   105,   403,   696,     0,   107,
     108,   109,   110,   697,   698,   112,   113,   114,   115,     0,
     116,   699,   700,   404,   405,     0,     0,     0,   406,   407,
       0,     0,     0,     0,   408,     0,     0,     0,     0,     0,
       0,     0,     0,   409,     0,   410,     0,   411,   412,     0,
      35,     0,     0,     0,     0,     0,     0,     0,    41,   414,
     415,   416,   417,   418,   419,   420,   421,     0,   422,   423,
     424,     0,     0,     0,     0,     0,     0,     0,   425,   426,
       0,   427,   133,   428,   429,   430,   135,  1715,   137,  1716,
    1717,     0,   431,   432,   433,   434,   435,     0,     0,   436,
     437,  1718,  1719,   439,     0,   440,   441,   442,   443,     0,
       0,     0,   444,   445,   446,   447,   448,   449,     0,   450,
     451,   452,   453,   454,   455,     0,   456,   457,   458,   149,
     459,     0,     0,     0,     0,   150,     0,     0,     0,   460,
     461,   462,   463,   464,   465,  1720,  1721,   466,     0,   467,
       0,   468,   469,   470,   471,   472,     0,   473,   474,   475,
       0,     0,   476,   477,  1359,   479,   480,     0,   481,   482,
     483,     0,   484,   485,     0,   486,   487,   488,     0,   489,
     490,     0,     0,   491,     0,   492,  1722,   493,     0,   494,
       0,   495,   167,     0,   168,   496,   497,     0,   498,     0,
       0,   499,     0,   500,   501,   502,   503,   504,   171,   505,
     506,   507,  2206,   508,   509,   510,   511,   512,   513,     0,
     172,  2207,     0,   514,   515,   516,  1365,  1723,     0,  1724,
       0,   517,   177,   178,   518,   179,   519,   520,   521,   522,
     523,   524,   525,     0,     0,   181,   526,   182,     0,   527,
     528,   529,     0,     0,   530,   531,   532,   533,   534,   535,
     536,   537,   538,   539,   540,   541,   542,  1725,   188,  1726,
       0,   543,   544,   545,   546,   547,   548,   549,     0,   550,
       0,   551,   552,   192,   553,     0,     0,   554,  1727,   555,
     556,     0,     0,   557,     0,     0,     0,   558,   559,   560,
       0,     0,  2208,   196,   197,   198,     0,   561,   562,   563,
     564,   565,   566,     0,   567,     0,   568,     0,   569,   570,
     571,     0,   572,   573,   574,   575,   576,   577,   578,  1728,
     579,   580,   581,     0,   582,   583,   584,   585,   586,   587,
     588,   589,   590,   591,     0,   592,   593,   209,   594,   595,
       0,   596,   597,   598,   599,   600,   601,   602,   603,     0,
     604,   605,   606,   607,     0,   608,  2209,   609,   610,   217,
     611,  1730,     0,   612,   613,   614,   615,   616,   617,   618,
     619,   620,   621,     0,   622,     0,   623,   624,     0,   625,
     626,   627,   628,   629,     0,  1731,  1732,     0,     0,   631,
       0,   632,     0,     0,   633,   634,   635,   636,   637,   638,
       0,     0,   639,   640,   641,   642,     0,     0,   643,   644,
     645,   646,     0,  1733,  2210,   648,   234,   649,   650,   651,
       0,     0,   652,     0,     0,   653,   654,   655,   656,   657,
       0,     0,     0,     0,     0,     0,     0,     0,   658,   659,
     660,     0,     0,     0,    55,     0,     0,     0,     0,     0,
       0,     0,     0,   694,    86,    87,    88,   400,    90,    91,
      92,   401,     0,   402,    95,     0,  2211,    98,    99,   100,
     101,   102,   103,   695,   104,   105,   403,   696,     0,   107,
     108,   109,   110,   697,   698,   112,   113,   114,   115,     0,
     116,   699,   700,   404,   405,     0,     0,     0,   406,   407,
       0,     0,     0,     0,   408,     0,     0,     0,     0,     0,
       0,     0,     0,   409,     0,   410,     0,   411,   412,     0,
      35,     0,     0,     0,     0,     0,     0,     0,    41,   414,
     415,   416,   417,   418,   419,   420,   421,     0,   422,   423,
     424,     0,     0,     0,     0,     0,     0,     0,   425,   426,
       0,   427,   133,   428,   429,   430,   135,  1715,   137,  1716,
    1717,     0,   431,   432,   433,   434,   435,     0,     0,   436,
     437,  1718,  1719,   439,     0,   440,   441,   442,   443,     0,
       0,     0,   444,   445,   446,   447,   448,   449,     0,   450,
     451,   452,   453,   454,   455,     0,   456,   457,   458,   149,
     459,     0,     0,     0,     0,   150,     0,     0,     0,   460,
     461,   462,   463,   464,   465,  1720,  1721,   466,     0,   467,
       0,   468,   469,   470,   471,   472,     0,   473,   474,   475,
       0,     0,   476,   477,  1359,   479,   480,     0,   481,   482,
     483,     0,   484,   485,     0,   486,   487,   488,     0,   489,
     490,     0,     0,   491,     0,   492,  1722,   493,     0,   494,
       0,   495,   167,     0,   168,   496,   497,     0,   498,     0,
       0,   499,     0,   500,   501,   502,   503,   504,   171,   505,
     506,   507,  2206,   508,   509,   510,   511,   512,   513,     0,
     172,  2207,     0,   514,   515,   516,  1365,  1723,     0,  1724,
       0,   517,   177,   178,   518,   179,   519,   520,   521,   522,
     523,   524,   525,     0,     0,   181,   526,   182,     0,   527,
     528,   529,     0,     0,   530,   531,   532,   533,   534,   535,
     536,   537,   538,   539,   540,   541,   542,  1725,   188,  1726,
       0,   543,   544,   545,   546,   547,   548,   549,     0,   550,
       0,   551,   552,   192,   553,     0,     0,   554,  1727,   555,
     556,     0,     0,   557,     0,     0,     0,   558,   559,   560,
       0,     0,  2208,   196,   197,   198,     0,   561,   562,   563,
     564,   565,   566,     0,   567,     0,   568,     0,   569,   570,
     571,     0,   572,   573,   574,   575,   576,   577,   578,  1728,
     579,   580,   581,     0,   582,   583,   584,   585,   586,   587,
     588,   589,   590,   591,     0,   592,   593,   209,   594,   595,
       0,   596,   597,   598,   599,   600,   601,   602,   603,     0,
     604,   605,   606,   607,     0,   608,  2209,   609,   610,   217,
     611,  1730,     0,   612,   613,   614,   615,   616,   617,   618,
     619,   620,   621,     0,   622,     0,   623,   624,     0,   625,
     626,   627,   628,   629,     0,  1731,  1732,     0,     0,   631,
       0,   632,     0,     0,   633,   634,   635,   636,   637,   638,
       0,     0,   639,   640,   641,   642,     0,     0,   643,   644,
     645,   646,     0,  1733,  2210,   648,   234,   649,   650,   651,
       0,     0,   652,     0,     0,   653,   654,   655,   656,   657,
       0,     0,     0,     0,     0,     0,     0,     0,   658,   659,
     660,     0,     0,     0,    55,     0,     0,    86,    87,    88,
     400,    90,    91,    92,   401,     0,   402,    95,     0,     0,
      98,    99,   100,   101,   102,   103,  2960,   104,   105,   403,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   404,   405,     0,     0,
       0,   406,   407,     0,     0,     0,     0,   408,     0,     0,
       0,     0,     0,     0,     0,     0,   409,     0,   410,     0,
     411,   412,     0,    35,     0,     0,     0,     0,     0,     0,
       0,    41,   414,   415,   416,   417,   418,   419,   420,   421,
       0,   422,   423,   424,     0,     0,     0,     0,     0,     0,
       0,   425,   426,     0,   427,     0,   428,   429,   430,     0,
     136,     0,   138,   139,     0,   431,   432,   433,   434,   435,
       0,     0,   436,   437,   438,   140,   439,     0,   440,   441,
     442,   443,   144,     0,     0,   444,   445,   446,   447,   448,
     449,     0,   450,   451,   452,   453,   454,   455,     0,   456,
     457,   458,     0,   459,     0,     0,     0,     0,     0,     0,
       0,     0,   460,   461,   462,   463,   464,   465,   153,   154,
     466,     0,   467,     0,   468,   469,   470,   471,   472,     0,
     473,   474,   475,     0,     0,   476,   477,   478,   479,   480,
       0,   481,   482,   483,     0,   484,   485,     0,   486,   487,
     488,   162,   489,   490,   164,     0,   491,     0,   492,   166,
     493,     0,   494,     0,   495,     0,     0,     0,   496,   497,
       0,   498,   170,     0,   499,     0,   500,   501,   502,   503,
     504,     0,   505,   506,   507,     0,   508,   509,   510,   511,
     512,   513,     0,     0,   173,     0,   514,   515,   516,     0,
     175,     0,   176,     0,   517,     0,     0,   518,     0,   519,
     520,   521,   522,   523,   524,   525,     0,   180,     0,   526,
       0,     0,   527,   528,   529,     0,     0,   530,   531,   532,
     533,   534,   535,   536,   537,   538,   539,   540,   541,   542,
     187,     0,   189,     0,   543,   544,   545,   546,   547,   548,
     549,   190,   550,     0,   551,   552,     0,   553,     0,   193,
     554,   194,   555,   556,     0,     0,   557,     0,     0,     0,
     558,   559,   560,     0,     0,   195,     0,     0,     0,   199,
     561,   562,   563,   564,   565,   566,     0,   567,   200,   568,
     201,   569,   570,   571,     0,   572,   573,   574,   575,   576,
     577,   578,   203,   579,   580,   581,     0,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,     0,   592,   593,
       0,   594,   595,   211,   596,   597,   598,   599,   600,   601,
     602,   603,     0,   604,   605,   606,   607,     0,   608,   215,
     609,   610,     0,   611,   218,     0,   612,   613,   614,   615,
     616,   617,   618,   619,   620,   621,   220,   622,     0,   623,
     624,     0,   625,   626,   627,   628,   629,     0,   222,   223,
       0,     0,   631,   224,   632,   225,     0,   633,   634,   635,
     636,   637,   638,     0,     0,   639,   640,   641,   642,     0,
    4059,   643,   644,   645,   646,   647,   233,     0,   648,     0,
     649,   650,   651,     0,     0,   652,     0,     0,   653,   654,
     655,   656,   657,   236,   237,   238,   239,   240,   241,   242,
     243,   658,   659,   660,     0,     0,     0,    55,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   694,    86,    87,
      88,   400,    90,    91,    92,   401, -1564,   402,    95,     0,
   -1564,    98,    99,   100,   101,   102,   103,   695,   104,   105,
     403,   696,     0,   107,   108,   109,   110,   697,   698,   112,
     113,   114,   115,     0,   116,   699,   700,   404,   405,     0,
       0,     0,   406,   407,     0,     0,     0,     0,   408,     0,
       0,     0,     0,     0,     0,     0,     0,   409,     0,   410,
       0,   411,   412,     0,    35,   413,     0,     0,    37,    38,
      39,    40,    41,   414,   415,   416,   417,   418,   419,   420,
     421,     0,   422,   423,   424,     0,     0,     0,     0,  1341,
       0,     0,   425,   426,     0,   427,   133,   428,   429,   430,
     135,  1342,   137,  1343,  1344,  2557,   431,   432,   433,   434,
     435,  1345,  1346,   436,   437,  1347,  1348,   439,     0,   440,
     441,   442,   443,  1349,     0,     0,   444,   445,   446,   447,
     448,   449,     0,   450,   451,   452,   453,   454,   455,     0,
     456,   457,   458,   149,   459,     0,  1350,  1351,  1352,  1353,
    1354,  1355,  1356,   460,   461,   462,   463,   464,   465,  1357,
    1358,   466,     0,   467,     0,   468,   469,   470,   471,   472,
       0,   473,   474,   475,     0,     0,   476,   477,  1359,   479,
     480,     0,   481,   482,   483,     0,   484,   485,     0,   486,
     487,   488,  1360,   489,   490,  1361,  1362,   491,     0,   492,
    1363,   493,     0,   494,     0,   495,   167,  2558,   168,   496,
     497,     0,   498,  1364,     0,   499,     0,   500,   501,   502,
     503,   504,   171,   505,   506,   507,     0,   508,   509,   510,
     511,   512,   513,     0,   172,   173,     0,   514,   515,   516,
    1365,  1366,     0,  1367,     0,   517,   177,   178,   518,   179,
     519,   520,   521,   522,   523,   524,   525,  2559,  1368,   181,
     526,   182,     0,   527,   528,   529,  1369,  1370,   530,   531,
     532,   533,   534,   535,   536,   537,   538,   539,   540,   541,
     542,  1371,   188,  1372,  1018,   543,   544,   545,   546,   547,
     548,   549,   190,   550,  1373,   551,   552,   192,   553,  1374,
    1375,   554,  1376,   555,   556,     0,     0,   557,  1019,     0,
       0,  1377,   559,   560,     0,     0,   195,   196,   197,   198,
    1378,   561,   562,   563,   564,   565,   566,     0,   567,  1379,
     568,   201,   569,   570,   571,     0,   572,   573,   574,   575,
     576,   577,   578,  1380,   579,   580,   581,     0,   582,   583,
     584,   585,   586,   587,   588,   589,   590,   591,     0,   592,
     593,   209,   594,   595,  1381,   596,   597,   598,   599,   600,
     601,   602,   603,     0,   604,   605,   606,   607,  1382,   608,
     215,   609,   610,   217,   611,  1383,     0,   612,   613,   614,
     615,   616,   617,   618,   619,   620,   621,  1384,   622,     0,
     623,   624,     0,   625,   626,   627,   628,   629,     0,  1385,
    1386,     0,  2560,   631,  1387,   632,  1388,  1389,   633,   634,
     635,   636,   637,   638,     0,  1390,   639,   640,   641,   642,
    1391,     0,   643,   644,   645,   646,   647,  1392,     0,   648,
     234,   649,   650,   651,     0,     0,   652,     0,     0,   653,
     654,   655,   656,   657,   236,  1393,  1394,  1395,  1396,  1397,
    1398,  1399,   658,   659,   660,     0,     0,     0,    55,    56,
      57,  1400,  1401,  1402,    58,  1403,     0,     0,     0,     0,
    1404,  1405,     0,     0,     0,     0,     0,     0,     0,  1407,
     694,    86,    87,    88,   400,    90,    91,    92,   401,     0,
     402,    95,     0,     0,    98,    99,   100,   101,   102,   103,
     695,   104,   105,   403,   696,     0,   107,   108,   109,   110,
     697,   698,   112,   113,   114,   115,     0,   116,   699,   700,
     404,   405,     0,     0,     0,   406,   407,     0,     0,     0,
       0,   408,     0,     0,     0,     0,     0,     0,     0,     0,
     409,     0,   410,     0,   411,   412,     0,    35,   413,     0,
       0,    37,    38,    39,    40,    41,   414,   415,   416,   417,
     418,   419,   420,   421,     0,   422,   423,   424,     0,     0,
       0,     0,  1341,     0,     0,   425,   426,     0,   427,   133,
     428,   429,   430,   135,  1342,   137,  1343,  1344,     0,   431,
     432,   433,   434,   435,  1345,  1346,   436,   437,  1347,  1348,
     439,     0,   440,   441,   442,   443,  1349,     0,     0,   444,
     445,   446,   447,   448,   449,     0,   450,   451,   452,   453,
     454,   455,     0,   456,   457,   458,   149,   459,     0,  1350,
    1351,  1352,  1353,  1354,  1355,  1356,   460,   461,   462,   463,
     464,   465,  1357,  1358,   466,     0,   467,     0,   468,   469,
     470,   471,   472,     0,   473,   474,   475,     0,     0,   476,
     477,  1359,   479,   480,     0,   481,   482,   483,     0,   484,
     485,     0,   486,   487,   488,  1360,   489,   490,  1361,  1362,
     491,     0,   492,  1363,   493,     0,   494,     0,   495,   167,
       0,   168,   496,   497,     0,   498,  1364,     0,   499,     0,
     500,   501,   502,   503,   504,   171,   505,   506,   507,     0,
     508,   509,   510,   511,   512,   513,     0,   172,   173,     0,
     514,   515,   516,  1365,  1366,     0,  1367,     0,   517,   177,
     178,   518,   179,   519,   520,   521,   522,   523,   524,   525,
       0,  1368,   181,   526,   182,     0,   527,   528,   529,  1369,
    1370,   530,   531,   532,   533,   534,   535,   536,   537,   538,
     539,   540,   541,   542,  1371,   188,  1372,  1018,   543,   544,
     545,   546,   547,   548,   549,   190,   550,  1373,   551,   552,
     192,   553,  1374,  1375,   554,  1376,   555,   556,     0,     0,
     557,  1019,     0,     0,  1377,   559,   560,     0,     0,   195,
     196,   197,   198,  1378,   561,   562,   563,   564,   565,   566,
       0,   567,  1379,   568,   201,   569,   570,   571,     0,   572,
     573,   574,   575,   576,   577,   578,  1380,   579,   580,   581,
       0,   582,   583,   584,   585,   586,   587,   588,   589,   590,
     591,     0,   592,   593,   209,   594,   595,  1381,   596,   597,
     598,   599,   600,   601,   602,   603,   213,   604,   605,   606,
     607,  1382,   608,   215,   609,   610,   217,   611,  1383,     0,
     612,   613,   614,   615,   616,   617,   618,   619,   620,   621,
    1384,   622,     0,   623,   624,   221,   625,   626,   627,   628,
     629,     0,  1385,  1386,     0,     0,   631,  1387,   632,  1388,
    1389,   633,   634,   635,   636,   637,   638,     0,  1390,   639,
     640,   641,   642,  1391,     0,   643,   644,   645,   646,  1970,
    1392,     0,   648,   234,   649,   650,   651,     0,     0,   652,
       0,   235,   653,   654,   655,   656,   657,   236,  1393,  1394,
    1395,  1396,  1397,  1398,  1399,   658,   659,   660,     0,     0,
       0,    55,    56,    57,  1400,  1401,  1402,    58,  1403,     0,
       0,     0,     0,  1404,  1405,     0,     0,     0,     0,     0,
       0,     0,  1407,   694,    86,    87,    88,   400,    90,    91,
      92,   401,     0,   402,    95,     0,     0,    98,    99,   100,
     101,   102,   103,   695,   104,   105,   403,   696,     0,   107,
     108,   109,   110,   697,   698,   112,   113,   114,   115,     0,
     116,   699,   700,   404,   405,     0,     0,     0,   406,   407,
       0,     0,     0,     0,   408,     0,     0,     0,     0,     0,
       0,     0,     0,   409,     0,   410,     0,   411,   412,     0,
      35,   413,     0,     0,    37,    38,    39,    40,    41,   414,
     415,   416,   417,   418,   419,   420,   421,     0,   422,   423,
     424,     0,     0,     0,     0,  1341,     0,     0,   425,   426,
       0,   427,   133,   428,   429,   430,   135,  1342,   137,  1343,
    1344,     0,   431,   432,   433,   434,   435,  1345,  1346,   436,
     437,  1347,  1348,   439,     0,   440,   441,   442,   443,  1349,
       0,     0,   444,   445,   446,   447,   448,   449,     0,   450,
     451,   452,   453,   454,   455,     0,   456,   457,   458,   149,
     459,     0,  1350,  1351,  1352,  1353,  1354,  1355,  1356,   460,
     461,   462,   463,   464,   465,  1357,  1358,   466,     0,   467,
       0,   468,   469,   470,   471,   472,     0,   473,   474,   475,
       0,     0,   476,   477,  1359,   479,   480,     0,   481,   482,
     483,     0,   484,   485,     0,   486,   487,   488,  1360,   489,
     490,  1361,  1362,   491,     0,   492,  1363,   493,     0,   494,
       0,   495,   167,     0,   168,   496,   497,     0,   498,  1364,
       0,   499,     0,   500,   501,   502,   503,   504,   171,   505,
     506,   507,     0,   508,   509,   510,   511,   512,   513,     0,
     172,   173,     0,   514,   515,   516,  1365,  1366,     0,  1367,
       0,   517,   177,   178,   518,   179,   519,   520,   521,   522,
     523,   524,   525,     0,  1368,   181,   526,   182,     0,   527,
     528,   529,  1369,  1370,   530,   531,   532,   533,   534,   535,
     536,   537,   538,   539,   540,   541,   542,  1371,   188,  1372,
    1018,   543,   544,   545,   546,   547,   548,   549,   190,   550,
    1373,   551,   552,   192,   553,  1374,  1375,   554,  1376,   555,
     556,     0,     0,   557,  1019,     0,     0,  1377,   559,   560,
       0,     0,   195,   196,   197,   198,  1378,   561,   562,   563,
     564,   565,   566,     0,   567,  1379,   568,   201,   569,   570,
     571,     0,   572,   573,   574,   575,   576,   577,   578,  1380,
     579,   580,   581,     0,   582,   583,   584,   585,   586,   587,
     588,   589,   590,   591,     0,   592,   593,   209,   594,   595,
    1381,   596,   597,   598,   599,   600,   601,   602,   603,     0,
     604,   605,   606,   607,  1382,   608,   215,   609,   610,   217,
     611,  1383,     0,   612,   613,   614,   615,   616,   617,   618,
     619,   620,   621,  1384,   622,     0,   623,   624,     0,   625,
     626,   627,   628,   629,     0,  1385,  1386,     0,     0,   631,
    1387,   632,  1388,  1389,   633,   634,   635,   636,   637,   638,
       0,  1390,   639,   640,   641,   642,  1391,     0,   643,   644,
     645,   646,   647,  1392,     0,   648,   234,   649,   650,   651,
       0,     0,   652,     0,     0,   653,   654,   655,   656,   657,
     236,  1393,  1394,  1395,  1396,  1397,  1398,  1399,   658,   659,
     660,     0,     0,     0,    55,    56,    57,  1400,  1401,  1402,
      58,  1403,     0,     0,     0,     0,  1404,  1405,     0,     0,
       0,     0,     0,  1916,  2506,  1407,   694,    86,    87,    88,
     400,    90,    91,    92,   401,     0,   402,    95,     0,     0,
      98,    99,   100,   101,   102,   103,   695,   104,   105,   403,
     696,     0,   107,   108,   109,   110,   697,   698,   112,   113,
     114,   115,     0,   116,   699,   700,   404,   405,     0,     0,
       0,   406,   407,     0,     0,     0,     0,   408,     0,     0,
       0,     0,     0,     0,     0,     0,   409,     0,   410,     0,
     411,   412,     0,    35,   413,     0,     0,    37,    38,    39,
      40,    41,   414,   415,   416,   417,   418,   419,   420,   421,
       0,   422,   423,   424,     0,     0,     0,     0,  1341,     0,
       0,   425,   426,     0,   427,   133,   428,   429,   430,   135,
    1342,   137,  1343,  1344,     0,   431,   432,   433,   434,   435,
    1345,  1346,   436,   437,  1347,  1348,   439,     0,   440,   441,
     442,   443,  1349,     0,     0,   444,   445,   446,   447,   448,
     449,     0,   450,   451,   452,   453,   454,   455,     0,   456,
     457,   458,   149,   459,     0,  1350,  1351,  1352,  1353,  1354,
    1355,  1356,   460,   461,   462,   463,   464,   465,  1357,  1358,
     466,     0,   467,     0,   468,   469,   470,   471,   472,     0,
     473,   474,   475,     0,     0,   476,   477,  1359,   479,   480,
       0,   481,   482,   483,     0,   484,   485,     0,   486,   487,
     488,  1360,   489,   490,  1361,  1362,   491,     0,   492,  1363,
     493,     0,   494,     0,   495,   167,     0,   168,   496,   497,
       0,   498,  1364,     0,   499,     0,   500,   501,   502,   503,
     504,   171,   505,   506,   507,     0,   508,   509,   510,   511,
     512,   513,     0,   172,   173,     0,   514,   515,   516,  1365,
    1366,     0,  1367,     0,   517,   177,   178,   518,   179,   519,
     520,   521,   522,   523,   524,   525,     0,  1368,   181,   526,
     182,     0,   527,   528,   529,  1369,  1370,   530,   531,   532,
     533,   534,   535,   536,   537,   538,   539,   540,   541,   542,
    1371,   188,  1372,  1018,   543,   544,   545,   546,   547,   548,
     549,   190,   550,  1373,   551,   552,   192,   553,  1374,  1375,
     554,  1376,   555,   556,     0,     0,   557,  1019,     0,     0,
    1377,   559,   560,     0,     0,   195,   196,   197,   198,  1378,
     561,   562,   563,   564,   565,   566,     0,   567,  1379,   568,
     201,   569,   570,   571,     0,   572,   573,   574,   575,   576,
     577,   578,  1380,   579,   580,   581,     0,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,     0,   592,   593,
     209,   594,   595,  1381,   596,   597,   598,   599,   600,   601,
     602,   603,     0,   604,   605,   606,   607,  1382,   608,   215,
     609,   610,   217,   611,  1383,     0,   612,   613,   614,   615,
     616,   617,   618,   619,   620,   621,  1384,   622,     0,   623,
     624,     0,   625,   626,   627,   628,   629,     0,  1385,  1386,
       0,     0,   631,  1387,   632,  1388,  1389,   633,   634,   635,
     636,   637,   638,     0,  1390,   639,   640,   641,   642,  1391,
       0,   643,   644,   645,   646,   647,  1392,     0,   648,   234,
     649,   650,   651,     0,     0,   652,     0,     0,   653,   654,
     655,   656,   657,   236,  1393,  1394,  1395,  1396,  1397,  1398,
    1399,   658,   659,   660,     0,     0,     0,    55,    56,    57,
    1400,  1401,  1402,    58,  1403,     0,     0,     0,     0,  1404,
    1405,  1406,     0,     0,     0,     0,     0,     0,  1407,   694,
      86,    87,    88,   400,    90,    91,    92,   401,     0,   402,
      95,     0,     0,    98,    99,   100,   101,   102,   103,   695,
     104,   105,   403,   696,     0,   107,   108,   109,   110,   697,
     698,   112,   113,   114,   115,     0,   116,   699,   700,   404,
     405,     0,     0,     0,   406,   407,     0,     0,     0,     0,
     408,     0,     0,     0,     0,     0,     0,     0,     0,   409,
       0,   410,     0,   411,   412,     0,    35,   413,     0,     0,
      37,    38,    39,    40,    41,   414,   415,   416,   417,   418,
     419,   420,   421,     0,   422,   423,   424,     0,     0,     0,
       0,  1341,     0,     0,   425,   426,     0,   427,   133,   428,
     429,   430,   135,  1342,   137,  1343,  1344,     0,   431,   432,
     433,   434,   435,  1345,  1346,   436,   437,  1347,  1348,   439,
       0,   440,   441,   442,   443,  1349,     0,     0,   444,   445,
     446,   447,   448,   449,     0,   450,   451,   452,   453,   454,
     455,     0,   456,   457,   458,   149,   459,     0,  1350,  1351,
    1352,  1353,  1354,  1355,  1356,   460,   461,   462,   463,   464,
     465,  1357,  1358,   466,  1488,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
    1359,   479,   480,     0,   481,   482,   483,     0,   484,   485,
       0,   486,   487,   488,  1360,   489,   490,  1361,  1362,   491,
       0,   492,  1363,   493,     0,   494,     0,   495,   167,     0,
     168,   496,   497,     0,   498,  1364,     0,   499,     0,   500,
     501,   502,   503,   504,   171,   505,   506,   507,     0,   508,
     509,   510,   511,   512,   513,     0,   172,   173,     0,   514,
     515,   516,  1365,  1366,     0,  1367,     0,   517,   177,   178,
     518,   179,   519,   520,   521,   522,   523,   524,   525,     0,
    1368,   181,   526,   182,     0,   527,   528,   529,  1369,  1370,
     530,   531,   532,   533,   534,   535,   536,   537,   538,   539,
     540,   541,   542,  1371,   188,  1372,  1018,   543,   544,   545,
     546,   547,   548,   549,   190,   550,  1373,   551,   552,   192,
     553,  1374,  1375,   554,  1376,   555,   556,     0,     0,   557,
    1019,     0,     0,  1377,   559,   560,     0,     0,   195,   196,
     197,   198,  1378,   561,   562,   563,   564,   565,   566,     0,
     567,  1379,   568,   201,   569,   570,   571,     0,   572,   573,
     574,   575,   576,   577,   578,  1380,   579,   580,   581,     0,
     582,   583,   584,   585,   586,   587,   588,   589,   590,   591,
       0,   592,   593,   209,   594,   595,  1381,   596,   597,   598,
     599,   600,   601,   602,   603,     0,   604,   605,   606,   607,
    1382,   608,   215,   609,   610,   217,   611,  1383,     0,   612,
     613,   614,   615,   616,   617,   618,   619,   620,   621,  1384,
     622,     0,   623,   624,     0,   625,   626,   627,   628,   629,
       0,  1385,  1386,     0,     0,   631,  1387,   632,  1388,  1389,
     633,   634,   635,   636,   637,   638,     0,  1390,   639,   640,
     641,   642,  1391,     0,   643,   644,   645,   646,   647,  1392,
       0,   648,   234,   649,   650,   651,     0,     0,   652,     0,
       0,   653,   654,   655,   656,   657,   236,  1393,  1394,  1395,
    1396,  1397,  1398,  1399,   658,   659,   660,     0,     0,     0,
      55,    56,    57,  1400,  1401,  1402,    58,  1403,     0,     0,
       0,     0,  1404,  1405,     0,     0,     0,     0,     0,     0,
       0,  1407,   694,    86,    87,    88,   400,    90,    91,    92,
     401,     0,   402,    95,     0,     0,    98,    99,   100,   101,
     102,   103,   695,   104,   105,   403,   696,     0,   107,   108,
     109,   110,   697,   698,   112,   113,   114,   115,     0,   116,
     699,   700,   404,   405,     0,     0,     0,   406,   407,     0,
       0,     0,     0,   408,     0,     0,     0,     0,     0,     0,
       0,     0,   409,     0,   410,     0,   411,   412,     0,    35,
     413,     0,     0,    37,    38,    39,    40,    41,   414,   415,
     416,   417,   418,   419,   420,   421,  2104,   422,   423,   424,
       0,     0,     0,     0,  1341,     0,     0,   425,   426,     0,
     427,   133,   428,   429,   430,   135,  1342,   137,  1343,  1344,
       0,   431,   432,   433,   434,   435,  1345,  1346,   436,   437,
    1347,  1348,   439,     0,   440,   441,   442,   443,  1349,     0,
       0,   444,   445,   446,   447,   448,   449,     0,   450,   451,
     452,   453,   454,   455,     0,   456,   457,   458,   149,   459,
       0,  1350,  1351,  1352,  1353,  1354,  1355,  1356,   460,   461,
     462,   463,   464,   465,  1357,  1358,   466,     0,   467,     0,
     468,   469,   470,   471,   472,     0,   473,   474,   475,     0,
       0,   476,   477,  1359,   479,   480,     0,   481,   482,   483,
       0,   484,   485,     0,   486,   487,   488,  1360,   489,   490,
    1361,  1362,   491,     0,   492,  1363,   493,     0,   494,     0,
     495,   167,     0,   168,   496,   497,     0,   498,  1364,     0,
     499,     0,   500,   501,   502,   503,   504,   171,   505,   506,
     507,     0,   508,   509,   510,   511,   512,   513,     0,   172,
     173,     0,   514,   515,   516,  1365,  1366,     0,  1367,     0,
     517,   177,   178,   518,   179,   519,   520,   521,   522,   523,
     524,   525,     0,  1368,   181,   526,   182,     0,   527,   528,
     529,  1369,  1370,   530,   531,   532,   533,   534,   535,   536,
     537,   538,   539,   540,   541,   542,  1371,   188,  1372,  1018,
     543,   544,   545,   546,   547,   548,   549,   190,   550,  1373,
     551,   552,   192,   553,  1374,  1375,   554,  1376,   555,   556,
       0,     0,   557,  1019,     0,     0,  1377,   559,   560,     0,
       0,   195,   196,   197,   198,  1378,   561,   562,   563,   564,
     565,   566,     0,   567,  1379,   568,   201,   569,   570,   571,
       0,   572,   573,   574,   575,   576,   577,   578,  1380,   579,
     580,   581,     0,   582,   583,   584,   585,   586,   587,   588,
     589,   590,   591,     0,   592,   593,   209,   594,   595,  1381,
     596,   597,   598,   599,   600,   601,   602,   603,     0,   604,
     605,   606,   607,  1382,   608,   215,   609,   610,   217,   611,
    1383,     0,   612,   613,   614,   615,   616,   617,   618,   619,
     620,   621,  1384,   622,     0,   623,   624,     0,   625,   626,
     627,   628,   629,     0,  1385,  1386,     0,     0,   631,  1387,
     632,  1388,  1389,   633,   634,   635,   636,   637,   638,     0,
    1390,   639,   640,   641,   642,  1391,     0,   643,   644,   645,
     646,   647,  1392,     0,   648,   234,   649,   650,   651,     0,
       0,   652,     0,     0,   653,   654,   655,   656,   657,   236,
    1393,  1394,  1395,  1396,  1397,  1398,  1399,   658,   659,   660,
       0,     0,     0,    55,    56,    57,  1400,  1401,  1402,    58,
    1403,     0,     0,     0,     0,  1404,  1405,     0,     0,     0,
       0,     0,     0,     0,  1407,   694,    86,    87,    88,   400,
      90,    91,    92,   401,     0,   402,    95,     0,     0,    98,
      99,   100,   101,   102,   103,   695,   104,   105,   403,   696,
       0,   107,   108,   109,   110,   697,   698,   112,   113,   114,
     115,     0,   116,   699,   700,   404,   405,     0,     0,     0,
     406,   407,     0,     0,     0,     0,   408,     0,     0,     0,
       0,     0,     0,     0,     0,   409,     0,   410,     0,   411,
     412,     0,    35,   413,     0,     0,    37,    38,    39,    40,
      41,   414,   415,   416,   417,   418,   419,   420,   421,     0,
     422,   423,   424,     0,     0,     0,     0,  1341,     0,     0,
     425,   426,     0,   427,   133,   428,   429,   430,   135,  1342,
     137,  1343,  1344,     0,   431,   432,   433,   434,   435,  1345,
    1346,   436,   437,  1347,  1348,   439,     0,   440,   441,   442,
     443,  1349,     0,     0,   444,   445,   446,   447,   448,   449,
       0,   450,   451,   452,   453,   454,   455,     0,   456,   457,
     458,   149,   459,  2998,  1350,  1351,  1352,  1353,  1354,  1355,
    1356,   460,   461,   462,   463,   464,   465,  1357,  1358,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,  1359,   479,   480,     0,
     481,   482,   483,     0,   484,   485,     0,   486,   487,   488,
    1360,   489,   490,  1361,  1362,   491,     0,   492,  1363,   493,
       0,   494,     0,   495,   167,     0,   168,   496,   497,     0,
     498,  1364,     0,   499,     0,   500,   501,   502,   503,   504,
     171,   505,   506,   507,     0,   508,   509,   510,   511,   512,
     513,     0,   172,   173,     0,   514,   515,   516,  1365,  1366,
       0,  1367,     0,   517,   177,   178,   518,   179,   519,   520,
     521,   522,   523,   524,   525,     0,  1368,   181,   526,   182,
       0,   527,   528,   529,  1369,  1370,   530,   531,   532,   533,
     534,   535,   536,   537,   538,   539,   540,   541,   542,  1371,
     188,  1372,  1018,   543,   544,   545,   546,   547,   548,   549,
     190,   550,  1373,   551,   552,   192,   553,  1374,  1375,   554,
    1376,   555,   556,     0,     0,   557,  1019,     0,     0,  1377,
     559,   560,     0,     0,   195,   196,   197,   198,  1378,   561,
     562,   563,   564,   565,   566,     0,   567,  1379,   568,   201,
     569,   570,   571,     0,   572,   573,   574,   575,   576,   577,
     578,  1380,   579,   580,   581,     0,   582,   583,   584,   585,
     586,   587,   588,   589,   590,   591,     0,   592,   593,   209,
     594,   595,  1381,   596,   597,   598,   599,   600,   601,   602,
     603,     0,   604,   605,   606,   607,  1382,   608,   215,   609,
     610,   217,   611,  1383,     0,   612,   613,   614,   615,   616,
     617,   618,   619,   620,   621,  1384,   622,     0,   623,   624,
       0,   625,   626,   627,   628,   629,     0,  1385,  1386,     0,
       0,   631,  1387,   632,  1388,  1389,   633,   634,   635,   636,
     637,   638,     0,  1390,   639,   640,   641,   642,  1391,     0,
     643,   644,   645,   646,   647,  1392,     0,   648,   234,   649,
     650,   651,     0,     0,   652,     0,     0,   653,   654,   655,
     656,   657,   236,  1393,  1394,  1395,  1396,  1397,  1398,  1399,
     658,   659,   660,     0,     0,     0,    55,    56,    57,  1400,
    1401,  1402,    58,  1403,     0,     0,     0,     0,  1404,  1405,
       0,     0,     0,     0,     0,     0,     0,  1407,   694,    86,
      87,    88,   400,    90,    91,    92,   401,     0,   402,    95,
       0,     0,    98,    99,   100,   101,   102,   103,   695,   104,
     105,   403,   696,     0,   107,   108,   109,   110,   697,   698,
     112,   113,   114,   115,     0,   116,   699,   700,   404,   405,
       0,     0,     0,   406,   407,     0,     0,     0,     0,   408,
       0,     0,     0,     0,     0,     0,     0,     0,   409,     0,
     410,     0,   411,   412,     0,    35,   413,     0,     0,    37,
      38,    39,    40,    41,   414,   415,   416,   417,   418,   419,
     420,   421,     0,   422,   423,   424,     0,     0,     0,     0,
    1341,     0,     0,   425,   426,     0,   427,   133,   428,   429,
     430,   135,  1342,   137,  1343,  1344,     0,   431,   432,   433,
     434,   435,  1345,  1346,   436,   437,  1347,  1348,   439,     0,
     440,   441,   442,   443,  1349,     0,     0,   444,   445,   446,
     447,   448,   449,     0,   450,   451,   452,   453,   454,   455,
       0,   456,   457,   458,   149,   459,     0,  1350,  1351,  1352,
    1353,  1354,  1355,  1356,   460,   461,   462,   463,   464,   465,
    1357,  1358,   466,     0,   467,     0,   468,   469,   470,   471,
     472,     0,   473,   474,   475,     0,     0,   476,   477,  1359,
     479,   480,     0,   481,   482,   483,     0,   484,   485,     0,
     486,   487,   488,  1360,   489,   490,  1361,  1362,   491,     0,
     492,  1363,   493,     0,   494,     0,   495,   167,  2558,   168,
     496,   497,     0,   498,  1364,     0,   499,     0,   500,   501,
     502,   503,   504,   171,   505,   506,   507,     0,   508,   509,
     510,   511,   512,   513,     0,   172,   173,     0,   514,   515,
     516,  1365,  1366,     0,  1367,     0,   517,   177,   178,   518,
     179,   519,   520,   521,   522,   523,   524,   525,     0,  1368,
     181,   526,   182,     0,   527,   528,   529,  1369,  1370,   530,
     531,   532,   533,   534,   535,   536,   537,   538,   539,   540,
     541,   542,  1371,   188,  1372,  1018,   543,   544,   545,   546,
     547,   548,   549,   190,   550,  1373,   551,   552,   192,   553,
    1374,  1375,   554,  1376,   555,   556,     0,     0,   557,  1019,
       0,     0,  1377,   559,   560,     0,     0,   195,   196,   197,
     198,  1378,   561,   562,   563,   564,   565,   566,     0,   567,
    1379,   568,   201,   569,   570,   571,     0,   572,   573,   574,
     575,   576,   577,   578,  1380,   579,   580,   581,     0,   582,
     583,   584,   585,   586,   587,   588,   589,   590,   591,     0,
     592,   593,   209,   594,   595,  1381,   596,   597,   598,   599,
     600,   601,   602,   603,     0,   604,   605,   606,   607,  1382,
     608,   215,   609,   610,   217,   611,  1383,     0,   612,   613,
     614,   615,   616,   617,   618,   619,   620,   621,  1384,   622,
       0,   623,   624,     0,   625,   626,   627,   628,   629,     0,
    1385,  1386,     0,     0,   631,  1387,   632,  1388,  1389,   633,
     634,   635,   636,   637,   638,     0,  1390,   639,   640,   641,
     642,  1391,     0,   643,   644,   645,   646,   647,  1392,     0,
     648,   234,   649,   650,   651,     0,     0,   652,     0,     0,
     653,   654,   655,   656,   657,   236,  1393,  1394,  1395,  1396,
    1397,  1398,  1399,   658,   659,   660,     0,     0,     0,    55,
      56,    57,  1400,  1401,  1402,    58,  1403,     0,     0,     0,
       0,  1404,  1405,     0,     0,     0,     0,     0,     0,     0,
    1407,   694,    86,    87,    88,   400,    90,    91,    92,   401,
       0,   402,    95,     0,     0,    98,    99,   100,   101,   102,
     103,   695,   104,   105,   403,   696,     0,   107,   108,   109,
     110,   697,   698,   112,   113,   114,   115,     0,   116,   699,
     700,   404,   405,     0,     0,     0,   406,   407,     0,     0,
       0,     0,   408,     0,     0,     0,     0,     0,     0,     0,
       0,   409,     0,   410,     0,   411,   412,     0,    35,   413,
       0,     0,    37,    38,    39,    40,    41,   414,   415,   416,
     417,   418,   419,   420,   421,     0,   422,   423,   424,     0,
       0,     0,     0,  1341,     0,     0,   425,   426,     0,   427,
     133,   428,   429,   430,   135,  1342,   137,  1343,  1344,     0,
     431,   432,   433,   434,   435,  1345,  1346,   436,   437,  1347,
    1348,   439,     0,   440,   441,   442,   443,  1349,     0,     0,
     444,   445,   446,   447,   448,   449,     0,   450,   451,   452,
     453,   454,   455,     0,   456,   457,   458,   149,   459,     0,
    1350,  1351,  1352,  1353,  1354,  1355,  1356,   460,   461,   462,
     463,   464,   465,  1357,  1358,   466,     0,   467,     0,   468,
     469,   470,   471,   472,     0,   473,   474,   475,     0,     0,
     476,   477,  1359,   479,   480,     0,   481,   482,   483,     0,
     484,   485,     0,   486,   487,   488,  1360,   489,   490,  1361,
    1362,   491,     0,   492,  1363,   493,     0,   494,     0,   495,
     167,     0,   168,   496,   497,     0,   498,  1364,     0,   499,
       0,   500,   501,   502,   503,   504,   171,   505,   506,   507,
       0,   508,   509,   510,   511,   512,   513,     0,   172,   173,
       0,   514,   515,   516,  1365,  1366,     0,  1367,     0,   517,
     177,   178,   518,   179,   519,   520,   521,   522,   523,   524,
     525,     0,  1368,   181,   526,   182,     0,   527,   528,   529,
    1369,  1370,   530,   531,   532,   533,   534,   535,   536,   537,
     538,   539,   540,   541,   542,  1371,   188,  1372,  1018,   543,
     544,   545,   546,   547,   548,   549,   190,   550,  1373,   551,
     552,   192,   553,  1374,  1375,   554,  1376,   555,   556,     0,
       0,   557,  1019,     0,     0,  1377,   559,   560,     0,     0,
     195,   196,   197,   198,  1378,   561,   562,   563,   564,   565,
     566,     0,   567,  1379,   568,   201,   569,   570,   571,     0,
     572,   573,   574,   575,   576,   577,   578,  1380,   579,   580,
     581,     0,   582,   583,   584,   585,   586,   587,   588,   589,
     590,   591,     0,   592,   593,   209,   594,   595,  1381,   596,
     597,   598,   599,   600,   601,   602,   603,     0,   604,   605,
     606,   607,  1382,   608,   215,   609,   610,   217,   611,  1383,
       0,   612,   613,   614,   615,   616,   617,   618,   619,   620,
     621,  1384,   622,     0,   623,   624,     0,   625,   626,   627,
     628,   629,     0,  1385,  1386,     0,     0,   631,  1387,   632,
    1388,  1389,   633,   634,   635,   636,   637,   638,     0,  1390,
     639,   640,   641,   642,  1391,     0,   643,   644,   645,   646,
     647,  1392,  3570,   648,   234,   649,   650,   651,     0,     0,
     652,     0,     0,   653,   654,   655,   656,   657,   236,  1393,
    1394,  1395,  1396,  1397,  1398,  1399,   658,   659,   660,     0,
       0,     0,    55,    56,    57,  1400,  1401,  1402,    58,  1403,
       0,     0,     0,     0,  1404,  1405,     0,     0,     0,     0,
       0,     0,     0,  1407,   694,    86,    87,    88,   400,    90,
      91,    92,   401,     0,   402,    95,     0,     0,    98,    99,
     100,   101,   102,   103,   695,   104,   105,   403,   696,     0,
     107,   108,   109,   110,   697,   698,   112,   113,   114,   115,
       0,   116,   699,   700,   404,   405,     0,     0,     0,   406,
     407,     0,     0,     0,     0,   408,     0,     0,     0,     0,
       0,     0,     0,     0,   409,     0,   410,     0,   411,   412,
       0,    35,   413,     0,     0,    37,    38,    39,    40,    41,
     414,   415,   416,   417,   418,   419,   420,   421,     0,   422,
     423,   424,     0,     0,     0,     0,  1341,     0,     0,   425,
     426,     0,   427,   133,   428,   429,   430,   135,  1342,   137,
    1343,  1344,     0,   431,   432,   433,   434,   435,  1345,  1346,
     436,   437,  1347,  1348,   439,     0,   440,   441,   442,   443,
    1349,     0,     0,   444,   445,   446,   447,   448,   449,     0,
     450,   451,   452,   453,   454,   455,     0,   456,   457,   458,
     149,   459,     0,  1350,  1351,  1352,  1353,  1354,  1355,  1356,
     460,   461,   462,   463,   464,   465,  1357,  1358,   466,     0,
     467,     0,   468,   469,   470,   471,   472,     0,   473,   474,
     475,     0,     0,   476,   477,  1359,   479,   480,     0,   481,
     482,   483,     0,   484,   485,     0,   486,   487,   488,  1360,
     489,   490,  1361,  1362,   491,     0,   492,  1363,   493,     0,
     494,     0,   495,   167,     0,   168,   496,   497,     0,   498,
    1364,     0,   499,     0,   500,   501,   502,   503,   504,   171,
     505,   506,   507,     0,   508,   509,   510,   511,   512,   513,
       0,   172,   173,     0,   514,   515,   516,  1365,  1366,     0,
    1367,     0,   517,   177,   178,   518,   179,   519,   520,   521,
     522,   523,   524,   525,     0,  1368,   181,   526,   182,     0,
     527,   528,   529,  1369,  1370,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,  1371,   188,
    1372,  1018,   543,   544,   545,   546,   547,   548,   549,   190,
     550,  1373,   551,   552,   192,   553,  1374,  1375,   554,  1376,
     555,   556,     0,     0,   557,  1019,     0,     0,  1377,   559,
     560,     0,     0,   195,   196,   197,   198,  1378,   561,   562,
     563,   564,   565,   566,     0,   567,  1379,   568,   201,   569,
     570,   571,     0,   572,   573,   574,   575,   576,   577,   578,
    1380,   579,   580,   581,     0,   582,   583,   584,   585,   586,
     587,   588,   589,   590,   591,     0,   592,   593,   209,   594,
     595,  1381,   596,   597,   598,   599,   600,   601,   602,   603,
       0,   604,   605,   606,   607,  1382,   608,   215,   609,   610,
     217,   611,  1383,     0,   612,   613,   614,   615,   616,   617,
     618,   619,   620,   621,  1384,   622,     0,   623,   624,     0,
     625,   626,   627,   628,   629,     0,  1385,  1386,     0,     0,
     631,  1387,   632,  1388,  1389,   633,   634,   635,   636,   637,
     638,     0,  1390,   639,   640,   641,   642,  1391,     0,   643,
     644,   645,   646,   647,  1392,     0,   648,   234,   649,   650,
     651,     0,     0,   652,     0,     0,   653,   654,   655,   656,
     657,   236,  1393,  1394,  1395,  1396,  1397,  1398,  1399,   658,
     659,   660,     0,     0,     0,    55,    56,    57,  1400,  1401,
    1402,    58,  1403,     0,     0,     0,     0,  1404,  1405,     0,
       0,     0,     0,     0,     0,     0,  1407,   694,    86,    87,
      88,   400,    90,    91,    92,   401,     0,   402,    95,     0,
       0,    98,    99,   100,   101,   102,   103,   695,   104,   105,
     403,   696,     0,   107,   108,   109,   110,   697,   698,   112,
     113,   114,   115,     0,   116,   699,   700,   404,   405,     0,
       0,     0,   406,   407,     0,     0,     0,     0,   408,     0,
       0,     0,     0,     0,     0,     0,     0,   409,     0,   410,
       0,   411,   412,     0,    35,   413,     0,     0,    37,    38,
      39,    40,    41,   414,   415,   416,   417,   418,   419,   420,
     421,     0,   422,   423,   424,     0,     0,     0,     0,  1341,
       0,     0,   425,   426,     0,   427,   133,   428,   429,   430,
     135,  1342,   137,  1343,  1344,     0,   431,   432,   433,   434,
     435,  1345,  1346,   436,   437,  1347,  1348,   439,     0,   440,
     441,   442,   443,  1349,     0,     0,   444,   445,   446,   447,
     448,   449,     0,   450,   451,   452,   453,   454,   455,     0,
     456,   457,   458,   149,   459,     0,  1350,  1351,  1352,  1353,
    1354,  1355,  1356,   460,   461,   462,   463,   464,   465,  1357,
    1358,   466,     0,   467,     0,   468,   469,   470,   471,   472,
       0,   473,   474,   475,     0,     0,   476,   477,  1359,   479,
     480,     0,   481,   482,   483,     0,   484,   485,     0,   486,
     487,   488,  1360,   489,   490,  1361,  1362,   491,     0,   492,
    1363,   493,     0,   494,     0,   495,   167,     0,   168,   496,
     497,     0,   498,  1364,     0,   499,     0,   500,   501,   502,
     503,   504,   171,   505,   506,   507,     0,   508,   509,   510,
     511,   512,   513,     0,   172,   173,     0,   514,   515,   516,
    1365,  1366,     0,  1367,     0,   517,   177,   178,   518,   179,
     519,   520,   521,   522,   523,   524,   525,     0,  1368,   181,
     526,   182,     0,   527,   528,   529,  1369,  1370,   530,   531,
     532,   533,   534,   535,   536,   537,   538,   539,   540,   541,
     542,  1371,   188,  1372,  1018,   543,   544,   545,   546,   547,
     548,   549,   190,   550,  1373,   551,   552,   192,   553,  1374,
    1375,   554,  1376,   555,   556,     0,     0,   557,  1019,     0,
       0,  1377,   559,   560,     0,     0,   195,   196,   197,   198,
    1378,   561,   562,   563,   564,   565,   566,     0,   567,  1379,
     568,   201,   569,   570,   571,     0,   572,   573,   574,   575,
     576,   577,   578,  1380,   579,   580,   581,     0,   582,   583,
     584,   585,   586,   587,   588,   589,   590,   591,     0,   592,
     593,   209,   594,   595,  1381,   596,   597,   598,   599,   600,
     601,   602,   603,     0,   604,   605,   606,   607,  1382,   608,
     215,   609,   610,   217,   611,  1383,     0,   612,   613,   614,
     615,   616,   617,   618,   619,   620,   621,  1384,   622,     0,
     623,   624,     0,   625,   626,   627,   628,   629,     0,  1385,
    1386,     0,     0,   631,  1387,   632,  1388,  1389,   633,   634,
     635,   636,   637,   638,     0,  1390,   639,   640,   641,   642,
    1391,     0,   643,   644,   645,   646,   647,  1392,     0,   648,
     234,   649,   650,   651,     0,     0,   652,     0,     0,   653,
     654,   655,   656,   657,  3795,  1393,  1394,  1395,  1396,  1397,
    1398,  1399,   658,   659,   660,     0,     0,     0,    55,    56,
      57,  1400,  1401,  1402,    58,  1403,     0,     0,     0,     0,
    1404,  1405,     0,     0,     0,     0,     0,     0,     0,  1407,
     694,    86,    87,    88,   400,    90,    91,    92,   401,     0,
     402,    95,     0,     0,    98,    99,   100,   101,   102,   103,
     695,   104,   105,   403,   696,     0,   107,   108,   109,   110,
     697,   698,   112,   113,   114,   115,     0,   116,   699,   700,
     404,   405,     0,     0,     0,   406,   407,     0,     0,     0,
       0,   408,     0,     0,     0,     0,     0,     0,     0,     0,
     409,     0,   410,     0,   411,   412,     0,    35,   413,     0,
       0,    37,    38,    39,    40,    41,   414,   415,   416,   417,
     418,   419,   420,   421,     0,   422,   423,   424,     0,     0,
       0,     0,  1341,     0,     0,   425,   426,     0,   427,   133,
     428,   429,   430,   135,  1342,   137,  1343,  1344,     0,   431,
     432,   433,   434,   435,  1345,  1346,   436,   437,  1347,  1348,
     439,     0,   440,   441,   442,   443,  1349,     0,     0,   444,
     445,   446,   447,   448,   449,     0,   450,   451,   452,   453,
     454,   455,     0,   456,   457,   458,   149,   459,     0,  1350,
    1351,  1352,  1353,  1354,  1355,  1356,   460,   461,   462,   463,
     464,   465,  1357,  1358,   466,     0,   467,     0,   468,   469,
     470,   471,   472,     0,   473,   474,   475,     0,     0,   476,
     477,  1359,   479,   480,     0,   481,   482,   483,     0,   484,
     485,     0,   486,   487,   488,  1360,   489,   490,  1361,  1362,
     491,     0,   492,  1363,   493,     0,   494,     0,   495,   167,
       0,   168,   496,   497,     0,   498,  1364,     0,   499,     0,
     500,   501,   502,   503,   504,   171,   505,   506,   507,     0,
     508,   509,   510,   511,   512,   513,     0,   172,   173,     0,
     514,   515,   516,  1365,  1366,     0,  1367,     0,   517,   177,
     178,   518,   179,   519,   520,   521,   522,   523,   524,   525,
       0,  1368,   181,   526,   182,     0,   527,   528,   529,  1369,
    1370,   530,   531,   532,   533,   534,   535,   536,   537,   538,
     539,   540,   541,   542,  1371,   188,  1372,  1018,   543,  3802,
     545,   546,   547,   548,   549,   190,   550,  1373,   551,   552,
     192,   553,  1374,  1375,   554,  1376,   555,   556,     0,     0,
     557,  1019,     0,     0,  1377,   559,   560,     0,     0,   195,
     196,   197,   198,  1378,   561,   562,   563,   564,   565,   566,
       0,   567,  1379,   568,   201,   569,   570,   571,     0,   572,
     573,   574,   575,   576,   577,   578,  1380,   579,   580,   581,
       0,   582,   583,   584,   585,   586,   587,   588,   589,   590,
     591,     0,   592,   593,   209,   594,   595,  1381,   596,   597,
     598,   599,   600,   601,   602,   603,     0,   604,   605,   606,
     607,  1382,   608,   215,   609,   610,   217,   611,  1383,     0,
     612,   613,   614,   615,   616,   617,   618,   619,   620,   621,
    1384,   622,     0,   623,   624,     0,   625,   626,   627,   628,
     629,     0,  1385,  1386,     0,     0,   631,  1387,   632,  1388,
    1389,   633,   634,   635,   636,   637,   638,     0,  1390,   639,
     640,   641,   642,  1391,     0,   643,   644,   645,   646,   647,
    1392,     0,   648,   234,   649,   650,   651,     0,     0,   652,
       0,     0,   653,   654,   655,   656,   657,   236,  1393,  1394,
    1395,  1396,  1397,  1398,  1399,   658,   659,   660,     0,     0,
       0,    55,    56,    57,  1400,  1401,  1402,    58,  1403,     0,
       0,     0,     0,  1404,  1405,     0,     0,     0,     0,     0,
       0,     0,  1407,   694,    86,    87,    88,   400,    90,    91,
      92,   401,     0,   402,    95,     0,     0,    98,    99,   100,
     101,   102,   103,   695,   104,   105,   403,   696,     0,   107,
     108,   109,   110,   697,   698,   112,   113,   114,   115,     0,
     116,   699,   700,   404,   405,     0,     0,     0,   406,   407,
       0,     0,     0,     0,   408,     0,     0,     0,     0,     0,
       0,     0,     0,   409,     0,   410,     0,   411,   412,     0,
      35,   413,     0,     0,    37,    38,    39,    40,    41,   414,
     415,   416,   417,   418,   419,   420,   421,     0,   422,   423,
     424,     0,     0,     0,     0,  1341,     0,     0,   425,   426,
       0,   427,   133,   428,   429,   430,   135,  1342,   137,  1343,
    1344,     0,   431,   432,   433,   434,   435,  1345,  1346,   436,
     437,  1347,  1348,   439,     0,   440,   441,   442,   443,  1349,
       0,     0,   444,   445,   446,   447,   448,   449,     0,   450,
     451,   452,   453,   454,   455,     0,   456,   457,   458,   149,
     459,     0,  1350,  1351,  1352,  1353,  1354,  1355,  1356,   460,
     461,   462,   463,   464,   465,  1357,  1358,   466,     0,   467,
       0,   468,   469,   470,   471,   472,     0,   473,   474,   475,
       0,     0,   476,   477,  1359,   479,   480,     0,   481,   482,
     483,     0,   484,   485,     0,   486,   487,   488,  1360,   489,
     490,  1361,  1362,   491,     0,   492,  1363,   493,     0,   494,
       0,   495,   167,     0,   168,   496,   497,     0,   498,  1364,
       0,   499,     0,   500,   501,   502,   503,   504,   171,   505,
     506,   507,     0,   508,   509,   510,   511,   512,   513,     0,
     172,   173,     0,   514,   515,   516,  1365,  1366,     0,  1367,
       0,   517,   177,   178,   518,   179,   519,   520,   521,   522,
     523,   524,   525,     0,  1368,   181,   526,   182,     0,   527,
     528,   529,  1369,  1370,   530,   531,   532,   533,   534,   535,
     536,   537,   538,   539,   540,   541,   542,  1371,   188,  1372,
    1018,   543,   544,   545,   546,   547,   548,   549,   190,   550,
       0,   551,   552,   192,   553,  1374,  1375,   554,  1376,   555,
     556,     0,     0,   557,  1019,     0,     0,  1377,   559,   560,
       0,     0,   195,   196,   197,   198,  1378,   561,   562,   563,
     564,   565,   566,     0,   567,  1379,   568,   201,   569,   570,
     571,     0,   572,   573,   574,   575,   576,   577,   578,  1380,
     579,   580,   581,     0,   582,   583,   584,   585,   586,   587,
     588,   589,   590,   591,     0,   592,   593,   209,   594,   595,
    1381,   596,   597,   598,   599,   600,   601,   602,   603,     0,
     604,   605,   606,   607,  1382,   608,   215,   609,   610,   217,
     611,  1383,     0,   612,   613,   614,   615,   616,   617,   618,
     619,   620,   621,  1384,   622,     0,   623,   624,     0,   625,
     626,   627,   628,   629,     0,  1385,  1386,     0,     0,   631,
    1387,   632,  1388,  1389,   633,   634,   635,   636,   637,   638,
       0,     0,   639,   640,   641,   642,  1391,     0,   643,   644,
     645,   646,   647,  1392,     0,   648,   234,   649,   650,   651,
       0,     0,   652,     0,     0,   653,   654,   655,   656,   657,
     236,  1393,  1394,  1395,  1396,  1397,  1398,  1399,   658,   659,
     660,     0,     0,     0,    55,    56,    57,  1400,  1401,  1402,
      58,  1403,     0,     0,     0,     0,  2540,  2541,     0,     0,
       0,     0,     0,     0,     0,  1407,   694,    86,    87,    88,
     400,    90,    91,    92,   401,     0,   402,    95,     0,     0,
      98,    99,   100,   101,   102,   103,   695,   104,   105,   403,
     696,     0,   107,   108,   109,   110,   697,   698,   112,   113,
     114,   115,     0,   116,   699,   700,   404,   405,     0,     0,
       0,   406,   407,     0,     0,     0,     0,   408,     0,     0,
       0,     0,     0,     0,     0,     0,   409,     0,   410,     0,
     411,   412,     0,    35,   413,     0,     0,    37,    38,    39,
      40,    41,   414,   415,   416,   417,   418,   419,   420,   421,
       0,   422,   423,   424,     0,     0,     0,     0,  1341,     0,
       0,   425,   426,     0,   427,   133,   428,   429,   430,     0,
    1342,   137,  1343,  1344,     0,   431,   432,   433,   434,   435,
    1345,  1346,   436,   437,  1347,  1348,   439,     0,   440,   441,
     442,   443,  1349,     0,     0,   444,   445,   446,   447,   448,
     449,     0,   450,   451,   452,   453,   454,   455,     0,   456,
     457,   458,   149,   459,     0,  1350,  1351,  1352,  1353,  1354,
    1355,  1356,   460,   461,   462,   463,   464,   465,  1357,  1358,
     466,     0,   467,     0,   468,   469,   470,   471,   472,     0,
     473,   474,   475,     0,     0,   476,   477,  1359,   479,   480,
       0,   481,   482,   483,     0,   484,     0,     0,   486,   487,
     488,  1360,   489,   490,  1361,  1362,   491,     0,   492,  1363,
     493,     0,   494,     0,   495,   167,     0,   168,   496,   497,
       0,   498,  1364,     0,   499,     0,   500,   501,   502,   503,
     504,     0,   505,   506,   507,     0,   508,   509,   510,   511,
     512,   513,     0,   172,   173,     0,   514,   515,   516,  1365,
    1366,     0,  1367,     0,   517,   177,   178,   518,   179,   519,
     520,   521,   522,   523,   524,   525,     0,  1368,   181,   526,
       0,     0,   527,   528,   529,  1369,  1370,   530,   531,   532,
     533,   534,   535,   536,   537,   538,   539,   540,   541,   542,
    1371,   188,  1372,  1018,   543,   544,   545,   546,   547,   548,
     549,   190,   550,     0,   551,   552,   192,   553,  1374,  1375,
     554,  1376,   555,   556,     0,     0,   557,  1019,     0,     0,
    1377,   559,   560,     0,     0,   195,   196,   197,   198,  1378,
     561,   562,   563,   564,   565,   566,     0,   567,  1379,   568,
     201,   569,   570,   571,     0,   572,   573,   574,   575,   576,
     577,   578,  1380,   579,   580,   581,     0,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,     0,   592,   593,
     209,   594,   595,  1381,   596,   597,   598,   599,   600,   601,
     602,   603,     0,   604,   605,   606,   607,  1382,   608,   215,
     609,   610,     0,   611,  1383,     0,   612,   613,   614,   615,
     616,   617,   618,   619,   620,   621,  1384,   622,     0,   623,
     624,     0,   625,   626,   627,   628,   629,     0,  1385,  1386,
       0,     0,   631,  1387,   632,  1388,  1389,   633,   634,   635,
     636,   637,   638,     0,  1390,   639,   640,   641,   642,  1391,
       0,   643,   644,   645,   646,   647,  1392,     0,   648,   234,
     649,   650,   651,     0,     0,   652,     0,     0,   653,   654,
     655,   656,   657,   236,  1393,  1394,  1395,  1396,  1397,  1398,
    1399,   658,   659,   660,     0,     0,     0,    55,    56,    57,
    1400,  1401,  1402,    58,  1403,     0,     0,     0,     0,  1404,
    1405,     0,     0,     0,     0,     0,     0,     0,  1407,   694,
      86,    87,    88,   400,    90,    91,    92,   401,     0,   402,
      95,     0,     0,    98,    99,   100,   101,   102,   103,   695,
     104,   105,   403,   696,     0,   107,   108,   109,   110,   697,
     698,   112,   113,   114,   115,     0,   116,   699,   700,   404,
     405,     0,     0,     0,   406,   407,     0,     0,     0,     0,
     408,     0,     0,     0,     0,     0,     0,     0,     0,   409,
       0,   410,     0,   411,   412,     0,    35,   413,     0,     0,
      37,    38,    39,    40,    41,   414,   415,   416,   417,   418,
     419,   420,   421,     0,   422,   423,   424,     0,     0,     0,
       0,  1341,     0,     0,   425,   426,     0,   427,   133,   428,
     429,   430,     0,  1342,   137,  1343,  1344,     0,   431,   432,
     433,   434,   435,  1345,  1346,   436,   437,  1347,  1348,   439,
       0,   440,   441,   442,   443,  1349,     0,     0,   444,   445,
     446,   447,   448,   449,     0,   450,   451,   452,   453,   454,
     455,     0,   456,   457,   458,   149,   459,     0,  1350,  1351,
    1352,  1353,  1354,  1355,  1356,   460,   461,   462,   463,   464,
     465,  1357,  1358,   466,     0,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
    1359,   479,   480,     0,   481,   482,   483,     0,   484,     0,
       0,   486,   487,   488,  1360,   489,   490,  1361,  1362,   491,
       0,   492,  1363,   493,     0,   494,     0,   495,   167,     0,
     168,   496,   497,     0,   498,  1364,     0,   499,     0,   500,
     501,   502,   503,   504,     0,   505,   506,   507,     0,   508,
     509,   510,   511,   512,   513,     0,   172,   173,     0,   514,
     515,   516,  1365,  1366,     0,  1367,     0,   517,   177,   178,
     518,   179,   519,   520,   521,   522,   523,   524,   525,     0,
    1368,   181,   526,     0,     0,   527,   528,   529,  1369,  1370,
     530,   531,   532,   533,   534,   535,   536,   537,   538,   539,
     540,   541,   542,  1371,   188,  1372,  1018,   543,   544,   545,
     546,   547,   548,   549,   190,   550,     0,   551,   552,   192,
     553,  1374,  1375,   554,  1376,   555,   556,     0,     0,   557,
    1019,     0,     0,  1377,   559,   560,     0,     0,   195,   196,
     197,   198,  1378,   561,   562,   563,   564,   565,   566,     0,
     567,  1379,   568,   201,   569,   570,   571,     0,   572,   573,
     574,   575,   576,   577,   578,  1380,   579,   580,   581,     0,
     582,   583,   584,   585,   586,   587,   588,   589,   590,   591,
       0,   592,   593,   209,   594,   595,  1381,   596,   597,   598,
     599,   600,   601,   602,   603,     0,   604,   605,   606,   607,
    1382,   608,   215,   609,   610,     0,   611,  1383,     0,   612,
     613,   614,   615,   616,   617,   618,   619,   620,   621,  1384,
     622,     0,   623,   624,     0,   625,   626,   627,   628,   629,
       0,  1385,  1386,     0,     0,   631,  1387,   632,  1388,  1389,
     633,   634,   635,   636,   637,   638,     0,     0,   639,   640,
     641,   642,  1391,     0,   643,   644,   645,   646,   647,  1392,
       0,   648,   234,   649,   650,   651,     0,     0,   652,     0,
       0,   653,   654,   655,   656,   657,   236,  1393,  1394,  1395,
    1396,  1397,  1398,  1399,   658,   659,   660,     0,     0,     0,
      55,    56,    57,  1400,  1401,  1402,    58,  1403,     0,     0,
       0,     0,  2540,  2541,     0,     0,     0,     0,     0,     0,
       0,  1407,   694,    86,    87,    88,   400,    90,    91,    92,
     401,     0,   402,    95,     0,     0,    98,    99,   100,   101,
     102,   103,   695,   104,   105,   403,   696,     0,   107,   108,
     109,   110,   697,   698,   112,   113,   114,   115,     0,   116,
     699,   700,   404,   405,     0,     0,     0,   406,   407,     0,
       0,     0,     0,   408,     0,     0,     0,     0,     0,     0,
       0,     0,   409,     0,   410,     0,   411,   412,     0,    35,
       0,     0,     0,     0,     0,     0,     0,    41,   414,   415,
     416,   417,   418,   419,   420,   421,     0,   422,   423,   424,
       0,     0,     0,     0,     0,     0,     0,   425,   426,     0,
     427,   133,   428,   429,   430,   135,   136,   137,   138,   139,
       0,   431,   432,   433,   434,   435,     0,  1346,   436,   437,
     438,   140,   439,     0,   440,   441,   442,   443,  1349,     0,
       0,   444,   445,   446,   447,   448,   449,     0,   450,   451,
     452,   453,   454,   455,     0,   456,   457,   458,   149,   459,
       0,  1350,  1351,  1352,  1353,  1354,  1355,  1356,   460,   461,
     462,   463,   464,   465,   153,   154,   466,     0,   467,     0,
     468,   469,   470,   471,   472,     0,   473,   474,   475,     0,
       0,   476,   477,   478,   479,   480,     0,   481,   482,   483,
       0,   484,   485,     0,   486,   487,   488,   162,   489,   490,
    1361,     0,   491,     0,   492,   166,   493,     0,   494,     0,
     495,   167,     0,   168,   496,   497,     0,   498,  1364,     0,
     499,     0,   500,   501,   502,   503,   504,   171,   505,   506,
     507,     0,   508,   509,   510,   511,   512,   513,     0,   172,
     173,     0,   514,   515,   516,     0,   175,     0,   176,     0,
     517,   177,   178,   518,   179,   519,   520,   521,   522,   523,
     524,   525,     0,  1368,   181,   526,   182,     0,   527,   528,
     529,  1369,  1370,   530,   531,   532,   533,   534,   535,   536,
     537,   538,   539,   540,   541,   542,   187,   188,   189,  1018,
     543,   544,   545,   546,   547,   548,   549,   190,   550,     0,
     551,   552,   192,   553,     0,  1375,   554,   194,   555,   556,
       0,     0,   557,  1019,     0,  1020,   558,   559,   560,     0,
       0,   195,   196,   197,   198,  1378,   561,   562,   563,   564,
     565,   566,     0,   567,  1379,   568,   201,   569,   570,   571,
       0,   572,   573,   574,   575,   576,   577,   578,   203,   579,
     580,   581,     0,   582,   583,   584,   585,   586,   587,   588,
     589,   590,   591,     0,   592,   593,   209,   594,   595,   211,
     596,   597,   598,   599,   600,   601,   602,   603,   213,   604,
     605,   606,   607,  1382,   608,   215,   609,   610,   217,   611,
     218,     0,   612,   613,   614,   615,   616,   617,   618,   619,
     620,   621,  1384,   622,     0,   623,   624,   221,   625,   626,
     627,   628,   629,     0,   222,   223,     0,     0,   631,  1387,
     632,  1388,     0,   633,   634,   635,   636,   637,   638,     0,
       0,   639,   640,   641,   642,  1391,     0,   643,   644,   645,
     646,  1970,   233,     0,   648,   234,   649,   650,   651,     0,
       0,   652,     0,   235,   653,   654,   655,   656,   657,   236,
    1393,  1394,  1395,  1396,  1397,  1398,  1399,   658,   659,   660,
       0,     0,     0,    55,     0,     0,     0,     0,     0,     0,
       0,   694,    86,    87,    88,   400,    90,    91,    92,   401,
       0,   402,    95,     0,  2403,    98,    99,   100,   101,   102,
     103,   695,   104,   105,   403,   696,     0,   107,   108,   109,
     110,   697,   698,   112,   113,   114,   115,     0,   116,   699,
     700,   404,   405,     0,     0,     0,   406,   407,     0,     0,
       0,     0,   408,     0,     0,     0,     0,     0,     0,     0,
       0,   409,     0,   410,     0,   411,   412,     0,    35,     0,
       0,     0,     0,     0,     0,     0,    41,   414,   415,   416,
     417,   418,   419,   420,   421,     0,   422,   423,   424,     0,
       0,     0,     0,     0,     0,     0,   425,   426,     0,   427,
     133,   428,   429,   430,   135,   136,   137,   138,   139,     0,
     431,   432,   433,   434,   435,     0,  1346,   436,   437,   438,
     140,   439,     0,   440,   441,   442,   443,  1349,     0,     0,
     444,   445,   446,   447,   448,   449,     0,   450,   451,   452,
     453,   454,   455,     0,   456,   457,   458,   149,   459,     0,
    1350,  1351,  1352,  1353,  1354,  1355,  1356,   460,   461,   462,
     463,   464,   465,   153,   154,   466,     0,   467,     0,   468,
     469,   470,   471,   472,     0,   473,   474,   475,     0,     0,
     476,   477,   478,   479,   480,     0,   481,   482,   483,     0,
     484,   485,     0,   486,   487,   488,   162,   489,   490,  1361,
       0,   491,     0,   492,   166,   493,     0,   494,     0,   495,
     167,     0,   168,   496,   497,     0,   498,  1364,     0,   499,
       0,   500,   501,   502,   503,   504,   171,   505,   506,   507,
       0,   508,   509,   510,   511,   512,   513,     0,   172,   173,
       0,   514,   515,   516,     0,   175,     0,   176,     0,   517,
     177,   178,   518,   179,   519,   520,   521,   522,   523,   524,
     525,     0,  1368,   181,   526,   182,     0,   527,   528,   529,
    1369,  1370,   530,   531,   532,   533,   534,   535,   536,   537,
     538,   539,   540,   541,   542,   187,   188,   189,  1018,   543,
     544,   545,   546,   547,   548,   549,   190,   550,     0,   551,
     552,   192,   553,     0,  1375,   554,   194,   555,   556,     0,
       0,   557,  1019,     0,  1020,   558,   559,   560,     0,     0,
     195,   196,   197,   198,  1378,   561,   562,   563,   564,   565,
     566,     0,   567,  1379,   568,   201,   569,   570,   571,     0,
     572,   573,   574,   575,   576,   577,   578,   203,   579,   580,
     581,     0,   582,   583,   584,   585,   586,   587,   588,   589,
     590,   591,     0,   592,   593,   209,   594,   595,   211,   596,
     597,   598,   599,   600,   601,   602,   603,     0,   604,   605,
     606,   607,  1382,   608,   215,   609,   610,   217,   611,   218,
       0,   612,   613,   614,   615,   616,   617,   618,   619,   620,
     621,  1384,   622,     0,   623,   624,     0,   625,   626,   627,
     628,   629,     0,   222,   223,     0,     0,   631,  1387,   632,
    1388,     0,   633,   634,   635,   636,   637,   638,     0,     0,
     639,   640,   641,   642,  1391,     0,   643,   644,   645,   646,
     647,   233,     0,   648,   234,   649,   650,   651,     0,     0,
     652,     0,     0,   653,   654,   655,   656,   657,   236,  1393,
    1394,  1395,  1396,  1397,  1398,  1399,   658,   659,   660,     0,
       0,     0,    55,     0,     0,     0,     0,     0,     0,     0,
     694,    86,    87,    88,   400,    90,    91,    92,   401,     0,
     402,    95,     0,  2403,    98,    99,   100,   101,   102,   103,
     695,   104,   105,   403,   696,     0,   107,   108,   109,   110,
     697,   698,   112,   113,   114,   115,     0,   116,   699,   700,
     404,   405,     0,     0,     0,   406,   407,     0,     0,     0,
       0,   408,     0,     0,     0,     0,     0,     0,     0,     0,
     409,     0,   410,     0,   411,   412,     0,    35,     0,     0,
       0,     0,     0,     0,     0,    41,   414,   415,   416,   417,
     418,   419,   420,   421,     0,   422,   423,   424,     0,     0,
       0,     0,     0,     0,     0,   425,   426,     0,   427,   133,
     428,   429,   430,   135,   136,   137,   138,   139,     0,   431,
     432,   433,   434,   435,     0,  1346,   436,   437,   438,   140,
     439,     0,   440,   441,   442,   443,  1349,     0,     0,   444,
     445,   446,   447,   448,   449,     0,   450,   451,   452,   453,
     454,   455,     0,   456,   457,   458,   149,   459,     0,  1350,
    1351,  1352,  1353,  1354,  1355,  1356,   460,   461,   462,   463,
     464,   465,   153,   154,   466,     0,   467,     0,   468,   469,
     470,   471,   472,     0,   473,   474,   475,     0,     0,   476,
     477,   478,   479,   480,     0,   481,   482,   483,     0,   484,
     485,     0,   486,   487,   488,   162,   489,   490,  1361,     0,
     491,     0,   492,   166,   493,     0,   494,     0,   495,   167,
       0,   168,   496,   497,     0,   498,  1364,     0,   499,     0,
     500,   501,   502,   503,   504,   171,   505,   506,   507,     0,
     508,   509,   510,   511,   512,   513,     0,   172,   173,     0,
     514,   515,   516,     0,   175,     0,   176,     0,   517,   177,
     178,   518,   179,   519,   520,   521,   522,   523,   524,   525,
       0,  1368,   181,   526,   182,     0,   527,   528,   529,  1369,
    1370,   530,   531,   532,   533,   534,   535,   536,   537,   538,
     539,   540,   541,   542,   187,   188,   189,  1018,   543,   544,
     545,   546,   547,   548,   549,   190,   550,     0,   551,   552,
     192,   553,     0,  1375,   554,   194,   555,   556,     0,     0,
     557,  1019,     0,     0,   558,   559,   560,     0,     0,   195,
     196,   197,   198,  1378,   561,   562,   563,   564,   565,   566,
       0,   567,  1379,   568,   201,   569,   570,   571,     0,   572,
     573,   574,   575,   576,   577,   578,   203,   579,   580,   581,
       0,   582,   583,   584,   585,   586,   587,   588,   589,   590,
     591,     0,   592,   593,   209,   594,   595,   211,   596,   597,
     598,   599,   600,   601,   602,   603,     0,   604,   605,   606,
     607,  1382,   608,   215,   609,   610,   217,   611,   218,     0,
     612,   613,   614,   615,   616,   617,   618,   619,   620,   621,
    1384,   622,     0,   623,   624,     0,   625,   626,   627,   628,
     629,     0,   222,   223,     0,     0,   631,  1387,   632,  1388,
       0,   633,   634,   635,   636,   637,   638,     0,     0,   639,
     640,   641,   642,  1391,     0,   643,   644,   645,   646,   647,
     233,     0,   648,   234,   649,   650,   651,     0,     0,   652,
       0,     0,   653,   654,   655,   656,   657,   236,  1393,  1394,
    1395,  1396,  1397,  1398,  1399,   658,   659,   660,     0,     0,
       0,    55,     0,     0,     0,     0,     0,     0,     0,   694,
      86,    87,    88,   400,    90,    91,    92,   401,     0,   402,
      95,     0,  3936,    98,    99,   100,   101,   102,   103,   695,
     104,   105,   403,   696,     0,   107,   108,   109,   110,   697,
     698,   112,   113,   114,   115,     0,   116,   699,   700,   404,
     405,     0,     0,     0,   406,   407,     0,     0,     0,     0,
     408,     0,     0,     0,     0,     0,     0,     0,     0,   409,
       0,   410,     0,   411,   412,     0,    35,     0,     0,     0,
       0,     0,     0,     0,    41,   414,   415,   416,   417,   418,
     419,   420,   421,     0,   422,   423,   424,     0,     0,     0,
       0,     0,     0,     0,   425,   426,     0,   427,   133,   428,
     429,   430,   135,   136,   137,   138,   139,     0,   431,   432,
     433,   434,   435,     0,     0,   436,   437,   438,   140,   439,
       0,   440,   441,   442,   443,   144,     0,     0,   444,   445,
     446,   447,   448,   449,     0,   450,   451,   452,   453,   454,
     455,     0,   456,   457,   458,   149,   459,     0,     0,     0,
       0,   150,     0,     0,     0,   460,   461,   462,   463,   464,
     465,   153,   154,   466,     0,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
     478,   479,   480,     0,   481,   482,   483,     0,   484,   485,
       0,   486,   487,   488,   162,   489,   490,   164,     0,   491,
       0,   492,   166,   493,     0,   494,     0,   495,   167,     0,
     168,   496,   497,     0,   498,   170,     0,   499,     0,   500,
     501,   502,   503,   504,   171,   505,   506,   507,     0,   508,
     509,   510,   511,   512,   513,     0,   172,   173,     0,   514,
     515,   516,     0,   175,     0,   176,     0,   517,   177,   178,
     518,   179,   519,   520,   521,   522,   523,   524,   525,     0,
     180,   181,   526,   182,     0,   527,   528,   529,     0,     0,
     530,   531,   532,   533,   534,   535,   536,   537,   538,   539,
     540,   541,   542,   187,   188,   189,  1018,   543,   544,   545,
     546,   547,   548,   549,   190,   550,     0,   551,   552,   192,
     553,     0,   193,   554,   194,   555,   556,     0,     0,   557,
    1019,     0,     0,   558,   559,   560,     0,     0,   195,   196,
     197,   198,   199,   561,   562,   563,   564,   565,   566,     0,
     567,   200,   568,   201,   569,   570,   571,     0,   572,   573,
     574,   575,   576,   577,   578,   203,   579,   580,   581,     0,
     582,   583,   584,   585,   586,   587,   588,   589,   590,   591,
       0,   592,   593,   209,   594,   595,   211,   596,   597,   598,
     599,   600,   601,   602,   603,     0,   604,   605,   606,   607,
       0,   608,   215,   609,   610,   217,   611,   218,     0,   612,
     613,   614,   615,   616,   617,   618,   619,   620,   621,   220,
     622,     0,   623,   624,     0,   625,   626,   627,   628,   629,
       0,   222,   223,     0,     0,   631,   224,   632,   225,     0,
     633,   634,   635,   636,   637,   638,     0,     0,   639,   640,
     641,   642,     0,     0,   643,   644,   645,   646,   647,   233,
       0,   648,   234,   649,   650,   651,     0,     0,   652,     0,
       0,   653,   654,   655,   656,   657,   236,   237,   238,   239,
     240,   241,   242,   243,   658,   659,   660,     0,     0,     0,
      55,     0,    86,    87,    88,   400,    90,    91,    92,   401,
       0,   402,    95,     0,     0,    98,    99,   100,   101,   102,
     103,  4002,   104,   105,   403,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   404,   405,     0,     0,     0,   406,   407,     0,     0,
       0,     0,   408,     0,     0,     0,     0,     0,     0,     0,
       0,   409,     0,   410,     0,   411,   412,     0,    35,     0,
       0,     0,     0,     0,     0,     0,    41,   414,   415,   416,
     417,   418,   419,   420,   421,     0,   422,   423,   424,     0,
       0,     0,     0,     0,  2980,     0,   425,   426,     0,   427,
       0,   428,   429,   430,     0,   136,     0,   138,   139,     0,
     431,   432,   433,   434,   435,     0,     0,   436,   437,   438,
     140,   439,     0,   440,   441,   442,   443,   144,     0,     0,
     444,   445,   446,   447,   448,   449,     0,   450,   451,   452,
     453,   454,   455,     0,   456,   457,   458, -1169,   459,     0,
       0,     0,     0,     0,     0,     0,     0,   460,   461,   462,
     463,   464,   465,   153,   154,   466,     0,   467,     0,   468,
     469,   470,   471,   472,     0,   473,   474,   475,     0,     0,
     476,   477,   478,   479,   480,     0,   481,   482,   483,     0,
     484,   485,     0,   486,   487,   488,   162,   489,   490,   164,
       0,   491,     0,   492,   166,   493,     0,   494,     0,   495,
       0,     0, -1169,   496,   497,     0,   498,   170,     0,   499,
       0,   500,   501,   502,   503,   504,     0,   505,   506,   507,
       0,   508,   509,   510,   511,   512,   513,     0, -1169,   173,
       0,   514,   515,   516,     0,   175,     0,   176,     0,   517,
       0,     0,   518, -1169,   519,   520,   521,   522,   523,   524,
     525,     0,   180, -1169,   526,     0,     0,   527,   528,   529,
       0,     0,   530,   531,   532,   533,   534,   535,   536,   537,
     538,   539,   540,   541,   542,   187, -1169,   189,     0,   543,
     544,   545,   546,   547,   548,   549,   190,   550,     0,   551,
     552,     0,   553,     0,   193,   554,   194,   555,   556,     0,
       0,   557,     0,     0,     0,   558,   559,   560,     0,     0,
     195,     0,     0,     0,   199,   561,   562,   563,   564,   565,
     566,     0,   567,   200,   568,   201,   569,   570,   571,     0,
     572,   573,   574,   575,   576,   577,   578,   203,   579,   580,
     581,     0,   582,   583,   584,   585,   586,   587,   588,   589,
     590,   591,     0,   592,   593, -1169,   594,   595,   211,   596,
     597,   598,   599,   600,   601,   602,   603,     0,   604,   605,
     606,   607,     0,   608,   215,   609,   610,     0,   611,   218,
       0,   612,   613,   614,   615,   616,   617,   618,   619,   620,
     621,   220,   622,     0,   623,   624,     0,   625,   626,   627,
     628,   629,     0,   222,   223,     0,     0,   631,   224,   632,
     225,     0,   633,   634,   635,   636,   637,   638,     0,     0,
     639,   640,   641,   642,     0,     0,   643,   644,   645,   646,
     647,   233,     0,   648,     0,   649,   650,   651,     0,     0,
     652,     0,     0,   653,   654,   655,   656,   657,   236,   237,
     238,   239,   240,   241,   242,   243,   658,   659,   660,     0,
       0,     0,    55,     0,     0,    86,    87,    88,   400,    90,
      91,    92,   401,     0,   402,    95,     0,     0,    98,    99,
     100,   101,   102,   103,  1496,   104,   105,   403,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   404,   405,     0,     0,     0,   406,
     407,     0,     0,     0,     0,   408,     0,     0,     0,     0,
       0,     0,     0,     0,   409,     0,   410,     0,   411,   412,
       0,    35,     0,     0,     0,    37,    38,    39,    40,    41,
     414,   415,   416,   417,   418,   419,   420,   421,     0,   422,
     423,   424,     0,     0,     0,     0,     0,     0,     0,   425,
     426,     0,   427,     0,   428,   429,   430,     0,   136,     0,
     138,   139,     0,   431,   432,   433,   434,   435,     0,     0,
     436,   437,   438,   140,   439,     0,   440,   441,   442,   443,
     144,     0,     0,   444,   445,   446,   447,   448,   449,     0,
     450,   451,   452,   453,   454,   455,     0,   456,   457,   458,
       0,   459,     0,     0,     0,     0,     0,     0,     0,     0,
     460,   461,   462,   463,   464,   465,   153,   154,   466,     0,
     467,     0,   468,   469,   470,   471,   472,     0,   473,   474,
     475,     0,     0,   476,   477,   478,   479,   480,     0,   481,
     482,   483,     0,   484,   485,     0,   486,   487,   488,   162,
     489,   490,   164,     0,   491,     0,   492,   166,   493,     0,
     494,     0,   495,     0,     0,     0,   496,   497,     0,   498,
     170,     0,   499,     0,   500,   501,   502,   503,   504,     0,
     505,   506,   507,     0,   508,   509,   510,   511,   512,   513,
       0,     0,   173,     0,   514,   515,   516,     0,   175,     0,
     176,     0,   517,     0,     0,   518,     0,   519,   520,   521,
     522,   523,   524,   525,     0,   180,     0,   526,     0,     0,
     527,   528,   529,     0,     0,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   187,     0,
     189,     0,   543,   544,   545,   546,   547,   548,   549,   190,
     550,     0,   551,   552,     0,   553,     0,   193,   554,   194,
     555,   556,     0,     0,   557,     0,     0,     0,   558,   559,
     560,     0,     0,   195,     0,     0,     0,   199,   561,   562,
     563,   564,   565,   566,     0,   567,   200,   568,   201,   569,
     570,   571,     0,   572,   573,   574,   575,   576,   577,   578,
     203,   579,   580,   581,     0,   582,   583,   584,   585,   586,
     587,   588,   589,   590,   591,     0,   592,   593,     0,   594,
     595,   211,   596,   597,   598,   599,   600,   601,   602,   603,
       0,   604,   605,   606,   607,     0,   608,   215,   609,   610,
       0,   611,   218,     0,   612,   613,   614,   615,   616,   617,
     618,   619,   620,   621,   220,   622,     0,   623,   624,     0,
     625,   626,   627,   628,   629,     0,   222,   223,     0,     0,
     631,   224,   632,   225,     0,   633,   634,   635,   636,   637,
     638,     0,     0,   639,   640,   641,   642,     0,     0,   643,
     644,   645,   646,   647,   233,     0,   648,     0,   649,   650,
     651,     0,     0,   652,     0,     0,   653,   654,   655,   656,
     657,   236,   237,   238,   239,   240,   241,   242,   243,   658,
     659,   660,     0,     0,     0,    55,     0,    57,     0,     0,
       0,    58,     0,     0,    86,    87,    88,   400,    90,    91,
      92,   401,     0,   402,    95,  3349,  3350,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   403,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   404,   405,     0,     0,     0,   406,   407,
       0,     0,     0,     0,   408,     0,     0,     0,     0,     0,
       0,     0,     0,   409,     0,   410,     0,   411,   412,     0,
      35,     0,     0,     0,    37,    38,    39,    40,    41,   414,
     415,   416,   417,   418,   419,   420,   421,     0,   422,   423,
     424,     0,     0,     0,     0,     0,     0,     0,   425,   426,
       0,   427,     0,   428,   429,   430,     0,   136,     0,   138,
     139,     0,   431,   432,   433,   434,   435,     0,     0,   436,
     437,   438,   140,   439,     0,   440,   441,   442,   443,   144,
       0,     0,   444,   445,   446,   447,   448,   449,     0,   450,
     451,   452,   453,   454,   455,     0,   456,   457,   458,     0,
     459,     0,     0,     0,     0,     0,     0,     0,     0,   460,
     461,   462,   463,   464,   465,   153,   154,   466,     0,   467,
       0,   468,   469,   470,   471,   472,     0,   473,   474,   475,
       0,     0,   476,   477,   478,   479,   480,     0,   481,   482,
     483,     0,   484,   485,     0,   486,   487,   488,   162,   489,
     490,   164,     0,   491,     0,   492,   166,   493,     0,   494,
       0,   495,     0,     0,     0,   496,   497,     0,   498,   170,
       0,   499,     0,   500,   501,   502,   503,   504,     0,   505,
     506,   507,     0,   508,   509,   510,   511,   512,   513,     0,
       0,   173,     0,   514,   515,   516,     0,   175,     0,   176,
       0,   517,     0,     0,   518,     0,   519,   520,   521,   522,
     523,   524,   525,     0,   180,     0,   526,     0,     0,   527,
     528,   529,     0,     0,   530,   531,   532,   533,   534,   535,
     536,   537,   538,   539,   540,   541,   542,   187,     0,   189,
       0,   543,   544,   545,   546,   547,   548,   549,   190,   550,
       0,   551,   552,     0,   553,     0,   193,   554,   194,   555,
     556,     0,     0,   557,     0,     0,     0,   558,   559,   560,
       0,     0,   195,     0,     0,     0,   199,   561,   562,   563,
     564,   565,   566,     0,   567,   200,   568,   201,   569,   570,
     571,     0,   572,   573,   574,   575,   576,   577,   578,   203,
     579,   580,   581,     0,   582,   583,   584,   585,   586,   587,
     588,   589,   590,   591,     0,   592,   593,     0,   594,   595,
     211,   596,   597,   598,   599,   600,   601,   602,   603,     0,
     604,   605,   606,   607,     0,   608,   215,   609,   610,     0,
     611,   218,     0,   612,   613,   614,   615,   616,   617,   618,
     619,   620,   621,   220,   622,     0,   623,   624,     0,   625,
     626,   627,   628,   629,     0,   222,   223,     0,     0,   631,
     224,   632,   225,     0,   633,   634,   635,   636,   637,   638,
       0,     0,   639,   640,   641,   642,     0,     0,   643,   644,
     645,   646,   647,   233,     0,   648,     0,   649,   650,   651,
       0,     0,   652,     0,     0,   653,   654,   655,   656,   657,
     236,   237,   238,   239,   240,   241,   242,   243,   658,   659,
     660,     0,     0,     0,    55,     0,    57,     0,     0,     0,
      58,     0,     0,    86,    87,    88,   400,    90,    91,    92,
     401,     0,   402,    95,     0,  3350,    98,    99,   100,   101,
     102,   103,     0,   104,   105,   403,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,   404,   405,     0,     0,     0,   406,   407,     0,
       0,     0,     0,   408,     0,     0,     0,     0,     0,     0,
       0,     0,   409,     0,   410,     0,   411,   412,     0,    35,
     413,     0,     0,     0,     0,     0,     0,    41,   414,   415,
     416,   417,   418,   419,   420,   421,     0,   422,   423,   424,
       0,     0,     0,     0,     0,     0,     0,   425,   426,     0,
     427,     0,   428,   429,   430,     0,   136,     0,   138,   139,
       0,   431,   432,   433,   434,   435,     0,     0,   436,   437,
     438,   140,   439,     0,   440,   441,   442,   443,   144,     0,
       0,   444,   445,   446,   447,   448,   449,     0,   450,   451,
     452,   453,   454,   455,     0,   456,   457,   458,     0,   459,
       0,     0,     0,     0,     0,     0,     0,     0,   460,   461,
     462,   463,   464,   465,   153,   154,   466,     0,   467,     0,
     468,   469,   470,   471,   472,     0,   473,   474,   475,     0,
       0,   476,   477,   478,   479,   480,     0,   481,   482,   483,
       0,   484,   485,     0,   486,   487,   488,   162,   489,   490,
     164,     0,   491,     0,   492,   166,   493,     0,   494,     0,
     495,     0,     0,     0,   496,   497,     0,   498,   170,     0,
     499,     0,   500,   501,   502,   503,   504,     0,   505,   506,
     507,     0,   508,   509,   510,   511,   512,   513,     0,     0,
     173,     0,   514,   515,   516,     0,   175,     0,   176,     0,
     517,     0,     0,   518,     0,   519,   520,   521,   522,   523,
     524,   525,     0,   180,     0,   526,     0,     0,   527,   528,
     529,     0,     0,   530,   531,   532,   533,   534,   535,   536,
     537,   538,   539,   540,   541,   542,   187,     0,   189,     0,
     543,   544,   545,   546,   547,   548,   549,   190,   550,     0,
     551,   552,     0,   553,     0,   193,   554,   194,   555,   556,
       0,     0,   557,     0,     0,     0,   558,   559,   560,     0,
       0,   195,     0,     0,     0,   199,   561,   562,   563,   564,
     565,   566,     0,   567,   200,   568,   201,   569,   570,   571,
       0,   572,   573,   574,   575,   576,   577,   578,   203,   579,
     580,   581,     0,   582,   583,   584,   585,   586,   587,   588,
     589,   590,   591,     0,   592,   593,     0,   594,   595,   211,
     596,   597,   598,   599,   600,   601,   602,   603,   213,   604,
     605,   606,   607,     0,   608,   215,   609,   610,     0,   611,
     218,     0,   612,   613,   614,   615,   616,   617,   618,   619,
     620,   621,   220,   622,     0,   623,   624,   221,   625,   626,
     627,   628,   629,     0,   222,   223,     0,     0,   631,   224,
     632,   225,     0,   633,   634,   635,   636,   637,   638,     0,
       0,   639,   640,   641,   642,     0,     0,   643,   644,   645,
     646,  1970,   233,     0,   648,     0,   649,   650,   651,     0,
       0,   652,     0,   235,   653,   654,   655,   656,   657,   236,
     237,   238,   239,   240,   241,   242,   243,   658,   659,   660,
       0,     0,     0,    55,     0,    86,    87,    88,   400,    90,
      91,    92,   401,     0,   402,    95,     0,     0,    98,    99,
     100,   101,   102,   103,   244,   104,   105,   403,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   404,   405,     0,     0,     0,   406,
     407,     0,     0,     0,     0,   408,     0,     0,     0,     0,
       0,     0,     0,     0,   409,     0,   410,     0,   411,   412,
       0,    35,     0,     0,     0,     0,     0,     0,     0,    41,
     414,   415,   416,   417,   418,   419,   420,   421,     0,   422,
     423,   424,     0,     0,     0,     0,     0,     0,     0,   425,
     426,     0,   427,     0,   428,   429,   430,     0,   136,     0,
     138,   139,     0,   431,   432,   433,   434,   435,     0,     0,
     436,   437,   438,   140,   439,     0,   440,   441,   442,   443,
     144,     0,     0,   444,   445,   446,   447,   448,   449,     0,
     450,   451,   452,   453,   454,   455,     0,   456,   457,   458,
       0,   459,     0,     0,     0,     0,     0,     0,     0,     0,
     460,   461,   462,   463,   464,   465,   153,   154,   466,     0,
     467,     0,   468,   469,   470,   471,   472,     0,   473,   474,
     475,     0,     0,   476,   477,   478,   479,   480,     0,   481,
     482,   483,     0,   484,   485,     0,   486,   487,   488,   162,
     489,   490,   164,     0,   491,     0,   492,   166,   493,     0,
     494,     0,   495,     0,     0,     0,   496,   497,     0,   498,
     170,     0,   499,     0,   500,   501,   502,   503,   504,     0,
     505,   506,   507,     0,   508,   509,   510,   511,   512,   513,
       0,     0,   173,     0,   514,   515,   516,     0,   175,     0,
     176,     0,   517,     0,     0,   518,     0,   519,   520,   521,
     522,   523,   524,   525,     0,   180,     0,   526,     0,     0,
     527,   528,   529,     0,     0,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   187,     0,
     189,     0,   543,   544,   545,   546,   547,   548,   549,   190,
     550,     0,   551,   552,     0,   553,     0,   193,   554,   194,
     555,   556,     0,     0,   557,     0,     0,     0,   558,   559,
     560,     0,     0,   195,     0,     0,     0,   199,   561,   562,
     563,   564,   565,   566,     0,   567,   200,   568,   201,   569,
     570,   571,     0,   572,   573,   574,   575,   576,   577,   578,
     203,   579,   580,   581,     0,   582,   583,   584,   585,   586,
     587,   588,   589,   590,   591,     0,   592,   593,     0,   594,
     595,   211,   596,   597,   598,   599,   600,   601,   602,   603,
     213,   604,   605,   606,   607,     0,   608,   215,   609,   610,
       0,   611,   218,     0,   612,   613,   614,   615,   616,   617,
     618,   619,   620,   621,   220,   622,     0,   623,   624,   221,
     625,   626,   627,   628,   629,     0,   222,   223,     0,     0,
     631,   224,   632,   225,     0,   633,   634,   635,   636,   637,
     638,     0,     0,   639,   640,   641,   642,     0,     0,   643,
     644,   645,   646,  1970,   233,     0,   648,     0,   649,   650,
     651,     0,     0,   652,     0,   235,   653,   654,   655,   656,
     657,   236,   237,   238,   239,   240,   241,   242,   243,   658,
     659,   660,     0,     0,     0,    55,     0,    86,    87,    88,
     400,    90,    91,    92,   401,     0,   402,    95,     0,     0,
      98,    99,   100,   101,   102,   103,   244,   104,   105,   403,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   404,   405,     0,     0,
       0,   406,   407,     0,     0,     0,     0,   408,     0,     0,
       0,     0,     0,     0,     0,     0,   409,     0,   410,     0,
     411,   412,     0,    35,     0,     0,     0,     0,     0,     0,
       0,    41,   414,   415,   416,   417,   418,   419,   420,   421,
       0,   422,   423,   424,     0,     0,     0,     0,     0,     0,
       0,   425,   426,     0,   427,     0,   428,   429,   430,     0,
     136,     0,   138,   139,     0,   431,   432,   433,   434,   435,
       0,     0,   436,   437,   438,   140,   439,     0,   440,   441,
     442,   443,   144,     0,     0,   444,   445,   446,   447,   448,
     449,     0,   450,   451,   452,   453,   454,   455,     0,   456,
     457,   458,     0,   459,     0,     0,     0,     0,     0,     0,
       0,     0,   460,   461,   462,   463,   464,   465,   153,   154,
     466,     0,   467,     0,   468,   469,   470,   471,   472,     0,
     473,   474,   475,     0,     0,   476,   477,   478,   479,   480,
       0,   481,   482,   483,     0,   484,   485,     0,   486,   487,
     488,   162,   489,   490,   164,     0,   491,     0,   492,   166,
     493,     0,   494,     0,   495,     0,     0,     0,   496,   497,
       0,   498,   170,     0,   499,     0,   500,   501,   502,   503,
     504,     0,   505,   506,   507,     0,   508,   509,   510,   511,
     512,   513,     0,     0,   173,     0,   514,   515,   516,     0,
     175,     0,   176,     0,   517,     0,     0,   518,     0,   519,
     520,   521,   522,   523,   524,   525,     0,   180,     0,   526,
       0,     0,   527,   528,   529,     0,     0,   530,   531,   532,
     533,   534,   535,   536,   537,   538,   539,   540,   541,   542,
     187,     0,   189,  1018,   543,   544,   545,   546,   547,   548,
     549,   190,   550,     0,   551,   552,     0,   553,     0,   193,
     554,   194,   555,   556,     0,     0,   557,  1019,     0,     0,
     558,   559,   560,     0,     0,   195,     0,     0,     0,   199,
     561,   562,   563,   564,   565,   566,     0,   567,   200,   568,
     201,   569,   570,   571,     0,   572,   573,   574,   575,   576,
     577,   578,   203,   579,   580,   581,     0,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,     0,   592,   593,
       0,   594,   595,   211,   596,   597,   598,   599,   600,   601,
     602,   603,     0,   604,   605,   606,   607,     0,   608,   215,
     609,   610,     0,   611,   218,     0,   612,   613,   614,   615,
     616,   617,   618,   619,   620,   621,   220,   622,     0,   623,
     624,     0,   625,   626,   627,   628,   629,     0,   222,   223,
       0,     0,   631,   224,   632,   225,     0,   633,   634,   635,
     636,   637,   638,     0,     0,   639,   640,   641,   642,     0,
       0,   643,   644,   645,   646,   647,   233,     0,   648,     0,
     649,   650,   651,     0,     0,   652,     0,     0,   653,   654,
     655,   656,   657,   236,   237,   238,   239,   240,   241,   242,
     243,   658,   659,   660,     0,     0,     0,    55,     0,    86,
      87,    88,   400,    90,    91,    92,   401,     0,   402,    95,
       0,     0,    98,    99,   100,   101,   102,   103,  1474,   104,
     105,   403,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   404,   405,
       0,     0,     0,   406,   407,     0,     0,     0,     0,   408,
       0,     0,     0,     0,     0,     0,     0,     0,   409,     0,
     410,     0,   411,   412,     0,    35,     0,     0,     0,     0,
       0,     0,     0,    41,   414,   415,   416,   417,   418,   419,
     420,   421,     0,   422,   423,   424,     0,     0,     0,     0,
       0,     0,     0,   425,   426,     0,   427,     0,   428,   429,
     430,     0,   136,     0,   138,   139,     0,   431,   432,   433,
     434,   435,     0,     0,   436,   437,   438,   140,   439,     0,
     440,   441,   442,   443,   144,     0,     0,   444,   445,   446,
     447,   448,   449,     0,   450,   451,   452,   453,   454,   455,
       0,   456,   457,   458,     0,   459,     0,     0,     0,     0,
       0,     0,     0,     0,   460,   461,   462,   463,   464,   465,
     153,   154,   466,     0,   467,     0,   468,   469,   470,   471,
     472,     0,   473,   474,   475,     0,     0,   476,   477,   478,
     479,   480,     0,   481,   482,   483,     0,   484,   485,     0,
     486,   487,   488,   162,   489,   490,   164,     0,   491,     0,
     492,   166,   493,     0,   494,     0,   495,     0,     0,     0,
     496,   497,     0,   498,   170,     0,   499,     0,   500,   501,
     502,   503,   504,     0,   505,   506,   507,     0,   508,   509,
     510,   511,   512,   513,     0,     0,   173,     0,   514,   515,
     516,     0,   175,     0,   176,     0,   517,     0,     0,   518,
       0,   519,   520,   521,   522,   523,   524,   525,     0,   180,
       0,   526,     0,     0,   527,   528,   529,     0,     0,   530,
     531,   532,   533,   534,   535,   536,   537,   538,   539,   540,
     541,   542,   187,     0,   189,     0,   543,   544,   545,   546,
     547,   548,   549,   190,   550,     0,   551,   552,     0,   553,
       0,   193,   554,   194,   555,   556,     0,     0,   557,     0,
       0,     0,   558,   559,   560,     0,     0,   195,     0,     0,
       0,   199,   561,   562,   563,   564,   565,   566,     0,   567,
     200,   568,   201,   569,   570,   571,     0,   572,   573,   574,
     575,   576,   577,   578,   203,   579,   580,   581,     0,   582,
     583,   584,   585,   586,   587,   588,   589,   590,   591,     0,
     592,   593,     0,   594,   595,   211,   596,   597,   598,   599,
     600,   601,   602,   603,     0,   604,   605,   606,   607,     0,
     608,   215,   609,   610,     0,   611,   218,     0,   612,   613,
     614,   615,   616,   617,   618,   619,   620,   621,   220,   622,
       0,   623,   624,     0,   625,   626,   627,   628,   629,     0,
     222,   223,     0,     0,   631,   224,   632,   225,     0,   633,
     634,   635,   636,   637,   638,     0,     0,   639,   640,   641,
     642,     0,     0,   643,   644,   645,   646,   647,   233,     0,
     648,     0,   649,   650,   651,     0,     0,   652,     0,     0,
     653,   654,   655,   656,   657,   236,   237,   238,   239,   240,
     241,   242,   243,   658,   659,   660,     0,     0,     0,    55,
       0,    86,    87,    88,   400,    90,    91,    92,   401,     0,
     402,    95,     0,     0,    98,    99,   100,   101,   102,   103,
    2078,   104,   105,   403,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     404,   405,     0,     0,     0,   406,   407,     0,     0,     0,
       0,   408,     0,     0,     0,     0,     0,     0,     0,     0,
     409,     0,   410,     0,   411,   412,     0,    35,     0,     0,
       0,     0,     0,     0,     0,    41,   414,   415,   416,   417,
     418,   419,   420,   421,     0,   422,   423,   424,     0,     0,
       0,     0,     0,     0,     0,   425,   426,     0,   427,     0,
     428,   429,   430,     0,   136,     0,   138,   139,     0,   431,
     432,   433,   434,   435,     0,     0,   436,   437,   438,   140,
     439,     0,   440,   441,   442,   443,   144,     0,     0,   444,
     445,   446,   447,   448,   449,     0,   450,   451,   452,   453,
     454,   455,     0,   456,   457,   458,     0,   459,     0,     0,
       0,     0,     0,     0,     0,     0,   460,   461,   462,   463,
     464,   465,   153,   154,   466,     0,   467,     0,   468,   469,
     470,   471,   472,     0,   473,   474,   475,     0,     0,   476,
     477,   478,   479,   480,     0,   481,   482,   483,     0,   484,
     485,     0,   486,   487,   488,   162,   489,   490,   164,     0,
     491,     0,   492,   166,   493,     0,   494,     0,   495,     0,
       0,     0,   496,   497,     0,   498,   170,     0,   499,     0,
     500,   501,   502,   503,   504,     0,   505,   506,   507,     0,
     508,   509,   510,   511,   512,   513,     0,     0,   173,     0,
     514,   515,   516,     0,   175,     0,   176,     0,   517,     0,
       0,   518,     0,   519,   520,   521,   522,   523,   524,   525,
       0,   180,     0,   526,     0,     0,   527,   528,   529,     0,
       0,   530,   531,   532,   533,   534,   535,   536,   537,   538,
     539,   540,   541,   542,   187,     0,   189,     0,   543,   544,
     545,   546,   547,   548,   549,   190,   550,     0,   551,   552,
       0,   553,     0,   193,   554,   194,   555,   556,     0,     0,
     557,     0,     0,     0,   558,   559,   560,     0,     0,   195,
       0,     0,     0,   199,   561,   562,   563,   564,   565,   566,
       0,   567,   200,   568,   201,   569,   570,   571,     0,   572,
     573,   574,   575,   576,   577,   578,   203,   579,   580,   581,
       0,   582,   583,   584,   585,   586,   587,   588,   589,   590,
     591,     0,   592,   593,     0,   594,   595,   211,   596,   597,
     598,   599,   600,   601,   602,   603,     0,   604,   605,   606,
     607,     0,   608,   215,   609,   610,     0,   611,   218,     0,
     612,   613,   614,   615,   616,   617,   618,   619,   620,   621,
     220,   622,     0,   623,   624,     0,   625,   626,   627,   628,
     629,     0,   222,   223,     0,     0,   631,   224,   632,   225,
       0,   633,   634,   635,   636,   637,   638,     0,     0,   639,
     640,   641,   642,     0,     0,   643,   644,   645,   646,   647,
     233,     0,   648,     0,   649,   650,   651,     0,     0,   652,
       0,     0,   653,   654,   655,   656,   657,   236,   237,   238,
     239,   240,   241,   242,   243,   658,   659,   660,     0,     0,
       0,    55,     0,    86,    87,    88,   400,    90,    91,    92,
     401,     0,   402,    95,     0,     0,    98,    99,   100,   101,
     102,   103,  3445,   104,   105,   403,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,   404,   405,     0,     0,     0,   406,   407,     0,
       0,     0,     0,   408,     0,     0,     0,     0,     0,     0,
       0,     0,   409,     0,   410,     0,   411,   412,     0,    35,
       0,     0,     0,     0,     0,     0,     0,    41,   414,   415,
     416,   417,   418,   419,   420,   421,     0,   422,   423,   424,
       0,     0,     0,     0,     0,     0,     0,   425,   426,     0,
     427,     0,   428,   429,   430,     0,   136,     0,   138,   139,
       0,   431,   432,   433,   434,   435,     0,     0,   436,   437,
     438,   140,   439,     0,   440,   441,   442,   443,   144,     0,
       0,   444,   445,   446,   447,   448,   449,     0,   450,   451,
     452,   453,   454,   455,     0,   456,   457,   458,     0,   459,
       0,     0,     0,     0,     0,     0,     0,     0,   460,   461,
     462,   463,   464,   465,   153,   154,   466,     0,   467,     0,
     468,   469,   470,   471,   472,     0,   473,   474,   475,     0,
       0,   476,   477,   478,   479,   480,     0,   481,   482,   483,
       0,   484,   485,     0,   486,   487,   488,   162,   489,   490,
     164,     0,   491,     0,   492,   166,   493,     0,   494,     0,
     495,     0,     0,     0,   496,   497,     0,   498,   170,     0,
     499,     0,   500,   501,   502,   503,   504,     0,   505,   506,
     507,     0,   508,   509,   510,   511,   512,   513,     0,     0,
     173,     0,   514,   515,   516,     0,   175,     0,   176,     0,
     517,     0,     0,   518,     0,   519,   520,   521,   522,   523,
     524,   525,     0,   180,     0,   526,     0,     0,   527,   528,
     529,     0,     0,   530,   531,   532,   533,   534,   535,   536,
     537,   538,   539,   540,   541,   542,   187,     0,   189,     0,
     543,   544,   545,   546,   547,   548,   549,   190,   550,     0,
     551,   552,     0,   553,     0,   193,   554,   194,   555,   556,
       0,     0,   557,     0,     0,     0,   558,   559,   560,     0,
       0,   195,     0,     0,     0,   199,   561,   562,   563,   564,
     565,   566,     0,   567,   200,   568,   201,   569,   570,   571,
       0,   572,   573,   574,   575,   576,   577,   578,   203,   579,
     580,   581,     0,   582,   583,   584,   585,   586,   587,   588,
     589,   590,   591,     0,   592,   593,     0,   594,   595,   211,
     596,   597,   598,   599,   600,   601,   602,   603,     0,   604,
     605,   606,   607,     0,   608,   215,   609,   610,     0,   611,
     218,     0,   612,   613,   614,   615,   616,   617,   618,   619,
     620,   621,   220,   622,     0,   623,   624,     0,   625,   626,
     627,   628,   629,     0,   222,   223,     0,     0,   631,   224,
     632,   225,     0,   633,   634,   635,   636,   637,   638,     0,
       0,   639,   640,   641,   642,     0,     0,   643,   644,   645,
     646,   647,   233,     0,   648,     0,   649,   650,   651,     0,
       0,   652,     0,     0,   653,   654,   655,   656,   657,   236,
     237,   238,   239,   240,   241,   242,   243,   658,   659,   660,
       0,     0,     0,    55,     0,     0,     0,     0,     0,     0,
       0,   694,    86,    87,    88,   400,    90,    91,    92,   401,
       0,   402,    95,     0,  3565,    98,    99,   100,   101,   102,
     103,   695,   104,   105,   403,   696,     0,   107,   108,   109,
     110,   697,   698,   112,   113,   114,   115,     0,   116,   699,
     700,   404,   405,     0,     0,     0,   406,   407,     0,     0,
       0,     0,   408,     0,     0,     0,     0,     0,     0,     0,
       0,   409,     0,   410,     0,   411,   412,     0,    35,   413,
       0,     0,    37,    38,    39,    40,    41,   414,   415,   416,
     417,   418,   419,   420,   421,   701,   422,   423,   424,   702,
     703,   704,   705,   706,   707,   708,   425,   426,   709,   427,
     133,   428,   429,   430,   135,  1715,   137,  1716,  1717,   710,
     431,   432,   433,   434,   435,   711,   712,   436,   437,  1718,
    1719,   439,   714,   440,   441,   442,   443,     0,   715,   716,
     444,   445,   446,   447,   448,   449,   718,   450,   451,   452,
     453,   454,   455,   719,   456,   457,   458,   149,   459,     0,
     721,   722,   723,   150,   724,   725,   726,   460,   461,   462,
     463,   464,   465,  1720,  1721,   466,   727,   467,   728,   468,
     469,   470,   471,   472,   729,   473,   474,   475,   730,   731,
     476,   477,  1359,   479,   480,   732,   481,   482,   483,   733,
     484,   485,   734,   486,   487,   488,     0,   489,   490,     0,
     735,   491,   736,   492,  1722,   493,   737,   494,   738,   495,
     167,   739,   168,   496,   497,   740,   498,     0,   741,   499,
     742,   500,   501,   502,   503,   504,   171,   505,   506,   507,
     743,   508,   509,   510,   511,   512,   513,   744,   172,     0,
       0,   514,   515,   516,  1365,  1723,   747,  1724,   748,   517,
     177,   178,   518,   179,   519,   520,   521,   522,   523,   524,
     525,   749,     0,   181,   526,   182,   750,   527,   528,   529,
     751,   752,   530,   531,   532,   533,   534,   535,   536,   537,
     538,   539,   540,   541,   542,  1725,   188,  1726,   753,   543,
     544,   545,   546,   547,   548,   549,     0,   550,   754,   551,
     552,   192,   553,   755,     0,   554,  1727,   555,   556,   756,
     757,   557,   758,   759,   760,  3336,   559,   560,   761,   762,
       0,   196,   197,   198,     0,   561,   562,   563,   564,   565,
     566,   763,   567,     0,   568,     0,   569,   570,   571,   764,
     572,   573,   574,   575,   576,   577,   578,  1728,   579,   580,
     581,   765,   582,   583,   584,   585,   586,   587,   588,   589,
     590,   591,   766,   592,   593,   209,   594,   595,     0,   596,
     597,   598,   599,   600,   601,   602,   603,   767,   604,   605,
     606,   607,   768,   608,  2209,   609,   610,   217,   611,  1730,
     769,   612,   613,   614,   615,   616,   617,   618,   619,   620,
     621,     0,   622,   770,   623,   624,   771,   625,   626,   627,
     628,   629,   772,  1731,  1732,     0,   774,   631,     0,   632,
       0,   775,   633,   634,   635,   636,   637,   638,     0,   777,
     639,   640,   641,   642,   778,   779,   643,   644,   645,   646,
       0,  1733,   781,   648,   234,   649,   650,   651,   782,   783,
     652,   784,   785,   653,   654,   655,   656,   657,     0,     0,
       0,     0,     0,     0,     0,     0,   658,   659,   660,     0,
       0,     0,    55,    56,    57,     0,     0,  1136,    58,     0,
    1137,  1138,  1139,     0,  3337,  3338,  1142,  1143,  1144,  1145,
      86,    87,    88,   400,    90,    91,    92,   401,     0,   402,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   403,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   404,
     405,     0,     0,     0,   406,   407,     0,     0,     0,     0,
     408,     0,     0,     0,     0,     0,     0,     0,     0,   409,
       0,   410,     0,   411,   412,     0,    35,     0,     0,     0,
       0,     0,     0,     0,    41,   414,   415,   416,   417,   418,
     419,   420,   421,     0,   422,   423,   424,     0,     0,     0,
       0,     0,     0,     0,   425,   426,     0,   427,     0,   428,
     429,   430,     0,   136,     0,   138,   139,     0,   431,   432,
     433,   434,   435,     0,     0,   436,   437,   438,   140,   439,
       0,   440,  1134,   442,   443,   144,     0,     0,   444,   445,
     446,   447,   448,   449,     0,   450,   451,   452,   453,   454,
     455,     0,   456,   457,   458,     0,   459,     0,     0,     0,
       0,     0,     0,     0,     0,   460,   461,   462,   463,   464,
     465,   153,   154,   466,     0,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
     478,   479,   480,     0,   481,   482,   483,     0,   484,   485,
       0,   486,   487,   488,   162,   489,   490,   164,     0,  1135,
       0,   492,   166,   493,     0,   494,     0,   495,     0,     0,
       0,   496,   497,     0,   498,   170,     0,   499,     0,   500,
     501,   502,   503,   504,     0,   505,   506,   507,     0,   508,
     509,   510,   511,   512,   513,     0,     0,   173,     0,   514,
     515,   516,     0,   175,     0,   176,     0,   517,     0,     0,
     518,     0,   519,   520,   521,   522,   523,   524,   525,     0,
     180,     0,   526,     0,     0,   527,   528,   529,     0,     0,
     530,   531,   532,   533,   534,   535,   536,   537,   538,   539,
     540,   541,   542,   187,     0,   189,     0,   543,   544,   545,
     546,   547,   548,   549,   190,   550,     0,   551,   552,     0,
     553,     0,   193,   554,   194,   555,   556,     0,     0,   557,
       0,     0,     0,   558,   559,   560,     0,     0,   195,     0,
       0,     0,   199,   561,   562,   563,   564,   565,   566,     0,
     567,   200,   568,   201,   569,   570,   571,     0,   572,   573,
     574,   575,   576,   577,   578,   203,   579,   580,   581,     0,
     582,   583,   584,   585,   586,   587,   588,   589,   590,   591,
       0,   592,   593,     0,   594,   595,   211,   596,   597,   598,
     599,   600,   601,   602,   603,     0,   604,   605,   606,   607,
       0,   608,   215,   609,   610,     0,   611,   218,     0,   612,
     613,   614,   615,   616,   617,   618,   619,   620,   621,   220,
     622,     0,   623,   624,     0,   625,   626,   627,   628,   629,
       0,   222,   223,     0,     0,   631,   224,   632,   225,     0,
     633,   634,   635,   636,   637,   638,     0,     0,   639,   640,
     641,   642,     0,     0,   643,   644,   645,   646,   647,   233,
       0,   648,     0,   649,   650,   651,     0,     0,   652,     0,
       0,   653,   654,   655,   656,   657,   236,   237,   238,   239,
     240,   241,   242,   243,   658,   659,   660,     0,     0,     0,
      55,     0,     0,     0,     0,  1136,     0,     0,  1137,  1138,
    1139,     0,  1140,  1141,  1142,  1143,  1144,  1145,    86,    87,
      88,   400,    90,    91,    92,   401,     0,   402,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     403,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   404,   405,     0,
       0,     0,   406,   407,     0,     0,     0,     0,   408,     0,
       0,     0,     0,     0,     0,     0,     0,   409,     0,   410,
       0,   411,   412,     0,    35,     0,     0,     0,     0,     0,
       0,     0,    41,   414,   415,   416,   417,   418,   419,   420,
     421,     0,   422,   423,   424,     0,     0,     0,     0,     0,
       0,     0,   425,   426,     0,   427,     0,   428,   429,   430,
       0,   136,     0,   138,   139,     0,   431,   432,   433,   434,
     435,     0,     0,   436,   437,   438,   140,   439,     0,   440,
    1210,   442,   443,   144,     0,     0,   444,   445,   446,   447,
     448,   449,     0,   450,   451,   452,   453,   454,   455,     0,
     456,   457,   458,     0,   459,     0,     0,     0,     0,     0,
       0,     0,     0,   460,   461,   462,   463,   464,   465,   153,
     154,   466,     0,   467,     0,   468,   469,   470,   471,   472,
       0,   473,   474,   475,     0,     0,   476,   477,   478,   479,
     480,     0,   481,   482,   483,     0,   484,   485,     0,   486,
     487,   488,   162,   489,   490,   164,     0,  1211,     0,   492,
     166,   493,     0,   494,     0,   495,     0,     0,     0,   496,
     497,     0,   498,   170,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,   510,
     511,   512,   513,     0,     0,   173,     0,   514,   515,   516,
       0,   175,     0,   176,     0,   517,     0,     0,   518,     0,
     519,   520,   521,   522,   523,   524,   525,     0,   180,     0,
     526,     0,     0,   527,   528,   529,     0,     0,   530,   531,
     532,   533,   534,   535,   536,   537,   538,   539,   540,   541,
     542,   187,     0,   189,     0,   543,   544,   545,   546,   547,
     548,   549,   190,   550,     0,   551,   552,     0,   553,     0,
     193,   554,   194,   555,   556,     0,     0,   557,     0,     0,
       0,   558,   559,   560,     0,     0,   195,     0,     0,     0,
     199,   561,   562,   563,   564,   565,   566,     0,   567,   200,
     568,   201,   569,   570,   571,     0,   572,   573,   574,   575,
     576,   577,   578,   203,   579,   580,   581,     0,   582,   583,
     584,   585,   586,   587,   588,   589,   590,   591,     0,   592,
     593,     0,   594,   595,   211,   596,   597,   598,   599,   600,
     601,   602,   603,     0,   604,   605,   606,   607,     0,   608,
     215,   609,   610,     0,   611,   218,     0,   612,   613,   614,
     615,   616,   617,   618,   619,   620,   621,   220,   622,     0,
     623,   624,     0,   625,   626,   627,   628,   629,     0,   222,
     223,     0,     0,   631,   224,   632,   225,     0,   633,   634,
     635,   636,   637,   638,     0,     0,   639,   640,   641,   642,
       0,     0,   643,   644,   645,   646,   647,   233,     0,   648,
       0,   649,   650,   651,     0,     0,   652,     0,     0,   653,
     654,   655,   656,   657,   236,   237,   238,   239,   240,   241,
     242,   243,   658,   659,   660,     0,     0,     0,    55,     0,
       0,     0,     0,  1136,     0,     0,  1137,  1138,  1139,     0,
    1140,  1141,  1142,  1143,  1144,  1145,    86,    87,    88,   400,
      90,    91,    92,   401,     0,   402,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   403,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   404,   405,     0,     0,     0,
     406,   407,     0,     0,     0,     0,   408,     0,     0,     0,
       0,     0,     0,     0,     0,   409,     0,   410,     0,   411,
     412,     0,    35,     0,     0,     0,     0,     0,     0,     0,
      41,   414,   415,   416,   417,   418,   419,   420,   421,     0,
     422,   423,   424,     0,     0,     0,     0,     0,     0,     0,
     425,   426,     0,   427,     0,   428,   429,   430,     0,   136,
       0,   138,   139,     0,   431,   432,   433,   434,   435,     0,
       0,   436,   437,   438,   140,   439,     0,   440,  1256,   442,
     443,   144,     0,     0,   444,   445,   446,   447,   448,   449,
       0,   450,   451,   452,   453,   454,   455,     0,   456,   457,
     458,     0,   459,     0,     0,     0,     0,     0,     0,     0,
       0,   460,   461,   462,   463,   464,   465,   153,   154,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,     0,   486,   487,   488,
     162,   489,   490,   164,     0,  1257,     0,   492,   166,   493,
       0,   494,     0,   495,     0,     0,     0,   496,   497,     0,
     498,   170,     0,   499,     0,   500,   501,   502,   503,  1258,
       0,   505,   506,   507,     0,   508,   509,   510,   511,   512,
     513,     0,     0,   173,     0,   514,   515,   516,     0,   175,
       0,   176,     0,   517,     0,     0,   518,     0,   519,   520,
     521,   522,   523,   524,   525,     0,   180,     0,   526,     0,
       0,   527,   528,   529,     0,     0,   530,   531,   532,   533,
     534,   535,   536,   537,   538,   539,   540,   541,   542,   187,
       0,   189,     0,   543,   544,   545,   546,   547,   548,   549,
     190,   550,     0,   551,   552,     0,   553,     0,   193,   554,
     194,   555,   556,     0,     0,   557,     0,     0,     0,   558,
     559,   560,     0,     0,   195,     0,     0,     0,   199,   561,
     562,   563,   564,   565,   566,     0,   567,   200,   568,   201,
     569,   570,   571,     0,   572,   573,   574,   575,   576,   577,
     578,   203,   579,   580,   581,     0,   582,   583,   584,   585,
     586,   587,   588,   589,   590,   591,     0,   592,   593,     0,
     594,   595,   211,   596,   597,   598,   599,   600,   601,   602,
     603,     0,   604,   605,   606,   607,     0,   608,   215,   609,
     610,     0,   611,   218,     0,   612,   613,   614,   615,   616,
     617,   618,   619,   620,   621,   220,   622,     0,   623,   624,
       0,   625,   626,   627,   628,   629,     0,   222,   223,     0,
       0,   631,   224,   632,   225,     0,   633,   634,   635,   636,
     637,   638,     0,     0,   639,   640,   641,   642,     0,     0,
     643,   644,   645,   646,   647,   233,     0,   648,     0,   649,
     650,   651,     0,     0,   652,     0,     0,   653,   654,   655,
     656,   657,   236,   237,   238,   239,   240,   241,   242,   243,
     658,   659,   660,     0,     0,     0,    55,     0,     0,     0,
       0,  1136,     0,     0,  1137,  1138,  1139,     0,  1140,  1141,
    1142,  1143,  1144,  1145,    86,    87,    88,   400,    90,    91,
      92,   401,     0,   402,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   403,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   404,   405,     0,     0,     0,   406,   407,
       0,     0,     0,     0,   408,     0,     0,     0,     0,     0,
       0,     0,     0,   409,     0,   410,     0,   411,   412,     0,
      35,     0,     0,     0,     0,     0,     0,     0,    41,   414,
     415,   416,   417,   418,   419,   420,   421,     0,   422,   423,
     424,     0,     0,     0,     0,     0,     0,     0,   425,   426,
       0,   427,     0,   428,   429,   430,     0,   136,     0,   138,
     139,     0,   431,   432,   433,   434,   435,     0,     0,   436,
     437,   438,   140,   439,     0,   440,  1698,   442,   443,   144,
       0,     0,   444,   445,   446,   447,   448,   449,     0,   450,
     451,   452,   453,   454,   455,     0,   456,   457,   458,     0,
     459,     0,     0,     0,     0,     0,     0,     0,     0,   460,
     461,   462,   463,   464,   465,   153,   154,   466,     0,   467,
       0,   468,   469,   470,   471,   472,     0,   473,   474,   475,
       0,     0,   476,   477,   478,   479,   480,     0,   481,   482,
     483,     0,   484,   485,     0,   486,   487,   488,   162,   489,
     490,   164,     0,  1699,     0,   492,   166,   493,     0,   494,
       0,   495,     0,     0,     0,   496,   497,     0,   498,   170,
       0,   499,     0,   500,   501,   502,   503,   504,     0,   505,
     506,   507,     0,   508,   509,   510,   511,   512,   513,     0,
       0,   173,     0,   514,   515,   516,     0,   175,     0,   176,
       0,   517,     0,     0,   518,     0,   519,   520,   521,   522,
     523,   524,   525,     0,   180,     0,   526,     0,     0,   527,
     528,   529,     0,     0,   530,   531,   532,   533,   534,   535,
     536,   537,   538,   539,   540,   541,   542,   187,     0,   189,
       0,   543,   544,   545,   546,   547,   548,   549,   190,   550,
       0,   551,   552,     0,   553,     0,   193,   554,   194,   555,
     556,     0,     0,   557,     0,     0,     0,   558,   559,   560,
       0,     0,   195,     0,     0,     0,   199,   561,   562,   563,
     564,   565,   566,     0,   567,   200,   568,   201,   569,   570,
     571,     0,   572,   573,   574,   575,   576,   577,   578,   203,
     579,   580,   581,     0,   582,   583,   584,   585,   586,   587,
     588,   589,   590,   591,     0,   592,   593,     0,   594,   595,
     211,   596,   597,   598,   599,   600,   601,   602,   603,     0,
     604,   605,   606,   607,     0,   608,   215,   609,   610,     0,
     611,   218,     0,   612,   613,   614,   615,   616,   617,   618,
     619,   620,   621,   220,   622,     0,   623,   624,     0,   625,
     626,   627,   628,   629,     0,   222,   223,     0,     0,   631,
     224,   632,   225,     0,   633,   634,   635,   636,   637,   638,
       0,     0,   639,   640,   641,   642,     0,     0,   643,   644,
     645,   646,   647,   233,     0,   648,     0,   649,   650,   651,
       0,     0,   652,     0,     0,   653,   654,   655,   656,   657,
     236,   237,   238,   239,   240,   241,   242,   243,   658,   659,
     660,     0,     0,     0,    55,     0,     0,     0,     0,  1136,
       0,     0,  1137,  1138,  1139,     0,  1140,  1141,  1142,  1143,
    1144,  1145,    86,    87,    88,   400,    90,    91,    92,   401,
       0,   402,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   403,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   404,   405,     0,     0,     0,   406,   407,     0,     0,
       0,     0,   408,     0,     0,     0,     0,     0,     0,     0,
       0,   409,     0,   410,     0,   411,   412,     0,    35,     0,
       0,     0,     0,     0,     0,     0,    41,   414,   415,   416,
     417,   418,   419,   420,   421,     0,   422,   423,   424,     0,
       0,     0,     0,     0,     0,     0,   425,   426,     0,   427,
       0,   428,   429,   430,     0,   136,     0,   138,   139,     0,
     431,   432,   433,   434,   435,     0,     0,   436,   437,   438,
     140,   439,     0,   440,   441,   442,   443,   144,     0,     0,
     444,   445,   446,   447,   448,   449,     0,   450,   451,   452,
     453,   454,   455,     0,   456,   457,   458,     0,   459,     0,
       0,     0,     0,     0,     0,     0,     0,   460,   461,   462,
     463,   464,   465,   153,   154,   466,     0,   467,     0,   468,
     469,   470,   471,   472,     0,   473,   474,   475,     0,     0,
     476,   477,   478,   479,   480,     0,   481,   482,   483,     0,
     484,   485,     0,   486,   487,   488,   162,   489,   490,   164,
       0,   491,     0,   492,   166,   493,     0,   494,     0,   495,
       0,     0,     0,   496,   497,     0,   498,   170,     0,   499,
       0,   500,   501,   502,   503,   504,     0,   505,   506,   507,
       0,   508,   509,   510,   511,   512,   513,     0,     0,   173,
       0,   514,   515,   516,     0,   175,     0,   176,     0,   517,
       0,     0,   518,     0,   519,   520,   521,   522,   523,   524,
     525,     0,   180,     0,   526,     0,     0,   527,   528,   529,
       0,     0,   530,   531,   532,   533,   534,   535,   536,   537,
     538,   539,   540,   541,   542,   187,     0,   189,     0,   543,
     544,   545,   546,   547,   548,   549,   190,   550,     0,   551,
     552,     0,   553,     0,   193,   554,   194,   555,   556,     0,
       0,   557,     0,     0,     0,   558,   559,   560,     0,     0,
     195,     0,     0,     0,   199,   561,   562,   563,   564,   565,
     566,     0,   567,   200,   568,   201,   569,   570,   571,     0,
     572,   573,   574,   575,   576,   577,   578,   203,   579,   580,
     581,     0,   582,   583,   584,   585,   586,   587,   588,   589,
     590,   591,     0,   592,   593,     0,   594,   595,   211,   596,
     597,   598,   599,   600,   601,   602,   603,     0,   604,   605,
     606,   607,     0,   608,   215,   609,   610,     0,   611,   218,
       0,   612,   613,   614,   615,   616,   617,   618,   619,   620,
     621,   220,   622,     0,   623,   624,     0,   625,   626,   627,
     628,   629,     0,   222,   223,     0,     0,   631,   224,   632,
     225,     0,   633,   634,   635,   636,   637,   638,     0,     0,
     639,   640,   641,   642,     0,     0,   643,   644,   645,   646,
     647,   233,     0,   648,     0,   649,   650,   651,     0,     0,
     652,     0,     0,   653,   654,   655,   656,   657,   236,   237,
     238,   239,   240,   241,   242,   243,   658,   659,   660,     0,
       0,     0,    55,     0,     0,     0,     0,  1136,     0,     0,
    1137,  1138,  1139,     0,  1140,  1141,  1142,  1143,  1144,  1145,
     694,    86,    87,    88,   400,    90,    91,    92,   401,     0,
     402,    95,     0,     0,    98,    99,   100,   101,   102,   103,
     695,   104,   105,   403,   696,     0,   107,   108,   109,   110,
     697,   698,   112,   113,   114,   115,     0,   116,   699,   700,
     404,   405,     0,     0,     0,   406,   407,     0,     0,     0,
       0,   408,     0,     0,     0,     0,     0,     0,     0,     0,
     409,     0,   410,     0,   411,   412,     0,    35,     0,     0,
       0,     0,     0,     0,     0,    41,   414,   415,   416,   417,
     418,   419,   420,   421,   701,   422,   423,   424,   702,   703,
     704,   705,   706,   707,   708,   425,   426,   709,   427,   133,
     428,   429,   430,   135,   136,   137,   138,   139,   710,   431,
     432,   433,   434,   435,   711,   712,   436,   437,   713,   140,
     439,   714,   440,   441,   442,   443,   144,   715,   716,   444,
     445,   446,   447,   448,   717,   718,   450,   451,   452,   453,
     454,   455,   719,   456,   457,   458,   149,   459,   720,   721,
     722,   723,   150,   724,   725,   726,   460,   461,   462,   463,
     464,   465,   153,   154,   466,   727,   467,   728,   468,   469,
     470,   471,   472,   729,   473,   474,   475,   730,   731,   476,
     477,   478,   479,   480,   732,   481,   482,   483,   733,   484,
     485,   734,   486,   487,   488,   162,   489,   490,   164,   735,
     491,   736,   492,   166,   493,   737,   494,   738,   495,   167,
     739,   168,   496,   497,   740,   498,   170,   741,   499,   742,
     500,   501,   502,   503,   504,   171,   505,   506,   507,   743,
     508,   509,   510,   511,   512,   513,   744,   172,   173,   745,
     514,   515,   516,   746,   175,   747,   176,   748,   517,   177,
     178,   518,   179,   519,   520,   521,   522,   523,   524,   525,
     749,   180,   181,   526,   182,   750,   527,   528,   529,   751,
     752,   530,   531,   532,   533,   534,   535,   536,   537,   538,
     539,   540,   541,   542,   187,   188,   189,   753,   543,   544,
     545,   546,   547,   548,   549,   190,   550,   754,   551,   552,
     192,   553,   755,   193,   554,   194,   555,   556,   756,   757,
     557,   758,   759,   760,   558,   559,   560,   761,   762,   195,
     196,   197,   198,   199,   561,   562,   563,   564,   565,   566,
     763,   567,   200,   568,   201,   569,   570,   571,   764,   572,
     573,   574,   575,   576,   577,   578,   203,   579,   580,   581,
     765,   582,   583,   584,   585,   586,   587,   588,   589,   590,
     591,   766,   592,   593,   209,   594,   595,   211,   596,   597,
     598,   599,   600,   601,   602,   603,   767,   604,   605,   606,
     607,   768,   608,   215,   609,   610,   217,   611,   218,   769,
     612,   613,   614,   615,   616,   617,   618,   619,   620,   621,
     220,   622,   770,   623,   624,   771,   625,   626,   627,   628,
     629,   772,   222,   223,   773,   774,   631,   224,   632,   225,
     775,   633,   634,   635,   636,   637,   638,   776,   777,   639,
     640,   641,   642,   778,   779,   643,   644,   645,   646,   780,
     233,   781,   648,   234,   649,   650,   651,   782,   783,   652,
     784,   785,   653,   654,   655,   656,   657,   236,   237,   238,
     239,   240,   241,   242,   243,   658,   659,   660,     0,     0,
       0,    55,   694,    86,    87,    88,   400,    90,    91,    92,
     401,     0,   402,    95,     0,  2069,    98,    99,   100,   101,
     102,   103,   695,   104,   105,   403,   696,     0,   107,   108,
     109,   110,   697,   698,   112,   113,   114,   115,     0,   116,
     699,   700,   404,   405,     0,     0,     0,   406,   407,     0,
       0,     0,     0,   408,     0,     0,     0,     0,     0,     0,
       0,     0,   409,     0,   410,     0,   411,   412,     0,    35,
       0,     0,     0,     0,     0,     0,     0,    41,   414,   415,
     416,   417,   418,   419,   420,   421,     0,   422,   423,   424,
       0,     0,     0,     0,     0,     0,     0,   425,   426,     0,
     427,   133,   428,   429,   430,   135,  1715,   137,  1716,  1717,
       0,   431,   432,   433,   434,   435,     0,     0,   436,   437,
    1718,  1719,   439,     0,   440,   441,   442,   443,     0,     0,
       0,   444,   445,   446,   447,   448,   449,     0,   450,   451,
     452,   453,   454,   455,     0,   456,   457,   458,   149,   459,
       0,     0,     0,     0,   150,     0,     0,     0,   460,   461,
     462,   463,   464,   465,  1720,  1721,   466,     0,   467,     0,
     468,   469,   470,   471,   472,     0,   473,   474,   475,     0,
       0,   476,   477,  1359,   479,   480,     0,   481,   482,   483,
       0,   484,   485,     0,   486,   487,   488,     0,   489,   490,
       0,     0,   491,     0,   492,  1722,   493,     0,   494,     0,
     495,   167,     0,   168,   496,   497,     0,   498,     0,     0,
     499,     0,   500,   501,   502,   503,   504,   171,   505,   506,
     507,     0,   508,   509,   510,   511,   512,   513,     0,   172,
       0,     0,   514,   515,   516,  1365,  1723,     0,  1724,     0,
     517,   177,   178,   518,   179,   519,   520,   521,   522,   523,
     524,   525,     0,     0,   181,   526,   182,     0,   527,   528,
     529,     0,     0,   530,   531,   532,   533,   534,   535,   536,
     537,   538,   539,   540,   541,   542,  1725,   188,  1726,     0,
     543,   544,   545,   546,   547,   548,   549,     0,   550,     0,
     551,   552,   192,   553,     0,     0,   554,  1727,   555,   556,
       0,     0,   557,     0,     0,     0,   558,   559,   560,     0,
       0,     0,   196,   197,   198,     0,   561,   562,   563,   564,
     565,   566,     0,   567,     0,   568,     0,   569,   570,   571,
       0,   572,   573,   574,   575,   576,   577,   578,  1728,   579,
     580,   581,     0,   582,   583,   584,   585,   586,   587,   588,
     589,   590,   591,     0,   592,   593,   209,   594,   595,     0,
     596,   597,   598,   599,   600,   601,   602,   603,     0,   604,
     605,   606,   607,     0,   608,  1729,   609,   610,   217,   611,
    1730,     0,   612,   613,   614,   615,   616,   617,   618,   619,
     620,   621,     0,   622,     0,   623,   624,     0,   625,   626,
     627,   628,   629,     0,  1731,  1732,     0,     0,   631,     0,
     632,     0,     0,   633,   634,   635,   636,   637,   638,     0,
       0,   639,   640,   641,   642,     0,     0,   643,   644,   645,
     646,     0,  1733,     0,   648,   234,   649,   650,   651,     0,
       0,   652,     0,     0,   653,   654,   655,   656,   657,     0,
       0,     0,     0,     0,     0,     0,     0,   658,   659,   660,
       0,     0,     0,    55,     0,    86,    87,    88,   400,    90,
      91,    92,   401,     0,   402,    95,     0,  2164,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   403,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   404,   405,     0,     0,     0,   406,
     407,     0,     0,     0,     0,   408,     0,     0,     0,     0,
       0,     0,     0,     0,   409,     0,   410,     0,   411,   412,
       0,    35,     0,     0,     0,     0,     0,     0,     0,    41,
     414,   415,   416,   417,   418,   419,   420,   421,     0,   422,
     423,   424,     0,     0,     0,     0,     0,     0,     0,   425,
     426,     0,   427,     0,   428,   429,   430,     0,   136,     0,
     138,   139,     0,   431,   432,   433,   434,   435,     0,     0,
     436,   437,   438,   140,   439,     0,   440,   441,   442,   443,
     144,     0,     0,   444,   445,   446,   447,   448,   449,     0,
     450,   451,   452,   453,   454,   455,     0,   456,   457,   458,
       0,   459,     0,     0,     0,     0,     0,     0,     0,     0,
     460,   461,   462,   463,   464,   465,   153,   154,   466,     0,
     467,     0,   468,   469,   470,   471,   472,     0,   473,   474,
     475,     0,     0,   476,   477,   478,   479,   480,     0,   481,
     482,   483,     0,   484,   485,     0,   486,   487,   488,   162,
     489,   490,   164,     0,   491,     0,   492,   166,   493,     0,
     494,     0,   495,     0,     0,     0,   496,   497,     0,   498,
     170,     0,   499,     0,   500,   501,   502,   503,   504,     0,
     505,   506,   507,     0,   508,   509,   510,   511,   512,   513,
       0,     0,   173,     0,   514,   515,   516,     0,   175,     0,
     176,     0,   517,     0,     0,   518,     0,   519,   520,   521,
     522,   523,   524,   525,     0,   180,     0,   526,     0,     0,
     527,   528,   529,     0,     0,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   187,     0,
     189,     0,   543,   544,   545,   546,   547,   548,   549,   190,
     550,     0,   551,   552,     0,   553,     0,   193,   554,   194,
     555,   556,     0,     0,   557,     0,     0,     0,   558,   559,
     560,     0,     0,   195,     0,     0,     0,   199,   561,   562,
     563,   564,   565,   566,     0,   567,   200,   568,   201,   569,
     570,   571,     0,   572,   573,   574,   575,   576,   577,   578,
     203,   579,   580,   581,     0,   582,   583,   584,   585,   586,
     587,   588,   589,   590,   591,     0,   592,   593,     0,   594,
     595,   211,   596,   597,   598,   599,   600,   601,   602,   603,
       0,   604,   605,   606,   607,     0,   608,   215,   609,   610,
       0,   611,   218,     0,   612,   613,   614,   615,   616,   617,
     618,   619,   620,   621,   220,   622,     0,   623,   624,     0,
     625,   626,   627,   628,   629,     0,   222,   223,     0,     0,
     631,   224,   632,   225,     0,   633,   634,   635,   636,   637,
     638,     0,     0,   639,   640,   641,   642,     0,     0,   643,
     644,   645,   646,   647,   233,     0,   648,     0,   649,   650,
     651,     0,     0,   652,     0,     0,   653,   654,   655,   656,
     657,   236,   237,   238,   239,   240,   241,   242,   243,   658,
     659,   660,     0,     0,     0,    55,     0,    86,    87,    88,
     400,    90,    91,    92,   401,     0,   402,    95,     0,  1029,
      98,    99,   100,   101,   102,   103,     0,   104,   105,   403,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   404,   405,     0,     0,
       0,   406,   407,     0,     0,     0,     0,   408,     0,     0,
       0,     0,     0,     0,     0,     0,   409,     0,   410,     0,
     411,   412,     0,    35,   413,     0,     0,    37,    38,    39,
      40,    41,   414,   415,   416,   417,   418,   419,   420,   421,
       0,   422,   423,   424,     0,     0,     0,     0,     0,     0,
       0,   425,   426,     0,   427,     0,   428,   429,   430,     0,
     136,     0,   138,   139,     0,   431,   432,   433,   434,   435,
       0,     0,   436,   437,   438,   140,   439,     0,   440,   441,
     442,   443,   144,     0,     0,   444,   445,   446,   447,   448,
     449,     0,   450,   451,   452,   453,   454,   455,     0,   456,
     457,   458,     0,   459,     0,     0,     0,     0,     0,     0,
       0,     0,   460,   461,   462,   463,   464,   465,   153,   154,
     466,  2052,   467,     0,   468,   469,   470,   471,   472,     0,
     473,   474,   475,     0,     0,   476,   477,   478,   479,   480,
       0,   481,   482,   483,     0,   484,   485,     0,   486,   487,
     488,   162,   489,   490,   164,  2053,   491,     0,   492,   166,
     493,     0,   494,     0,   495,     0,     0,     0,   496,   497,
       0,   498,   170,     0,   499,     0,   500,   501,   502,   503,
     504,     0,   505,   506,   507,     0,   508,   509,   510,   511,
     512,   513,     0,     0,   173,     0,   514,   515,   516,     0,
     175,     0,   176,     0,   517,     0,     0,   518,     0,   519,
     520,   521,   522,   523,   524,   525,     0,   180,     0,   526,
       0,     0,   527,   528,   529,     0,     0,   530,   531,   532,
     533,   534,   535,   536,   537,   538,   539,   540,   541,   542,
     187,     0,   189,     0,   543,   544,   545,   546,   547,   548,
     549,   190,   550,     0,   551,   552,     0,   553,     0,   193,
     554,   194,   555,   556,  2054,     0,   557,     0,  2055,     0,
     558,   559,   560,     0,     0,   195,     0,     0,     0,   199,
     561,   562,   563,   564,   565,   566,     0,   567,   200,   568,
     201,   569,   570,   571,     0,   572,   573,   574,   575,   576,
     577,   578,   203,   579,   580,   581,     0,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,     0,   592,   593,
       0,   594,   595,   211,   596,   597,   598,   599,   600,   601,
     602,   603,     0,   604,   605,   606,   607,     0,   608,   215,
     609,   610,     0,   611,   218,     0,   612,   613,   614,   615,
     616,   617,   618,   619,   620,   621,   220,   622,     0,   623,
     624,     0,   625,   626,   627,   628,   629,     0,   222,   223,
       0,     0,   631,   224,   632,   225,  2056,   633,   634,   635,
     636,   637,   638,     0,     0,   639,   640,   641,   642,     0,
       0,   643,   644,   645,   646,   647,   233,     0,   648,     0,
     649,   650,   651,     0,     0,   652,     0,     0,   653,   654,
     655,   656,   657,   236,   237,   238,   239,   240,   241,   242,
     243,   658,   659,   660,     0,     0,     0,    55,    56,    57,
       0,     0,     0,    58,     0,     0,     0,     0,     0,   938,
    1533,    86,    87,    88,   400,    90,    91,    92,   401,     0,
     402,    95,     0,     0,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   403,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     404,   405,     0,     0,     0,   406,   407,     0,     0,     0,
       0,   408,     0,     0,     0,     0,     0,     0,     0,     0,
     409,     0,   410,     0,   411,   412,     0,    35,   413,     0,
       0,    37,    38,    39,    40,    41,   414,   415,   416,   417,
     418,   419,   420,   421,     0,   422,   423,   424,     0,     0,
       0,     0,     0,     0,     0,   425,   426,     0,   427,     0,
     428,   429,   430,     0,   136,     0,   138,   139,     0,   431,
     432,   433,   434,   435,     0,     0,   436,   437,   438,   140,
     439,     0,   440,   441,   442,   443,   144,     0,     0,   444,
     445,   446,   447,   448,   449,     0,   450,   451,   452,   453,
     454,   455,     0,   456,   457,   458,     0,   459,     0,     0,
       0,     0,     0,     0,     0,     0,   460,   461,   462,   463,
     464,   465,   153,   154,   466,  2062,   467,     0,   468,   469,
     470,   471,   472,     0,   473,   474,   475,     0,     0,   476,
     477,   478,   479,   480,     0,   481,   482,   483,     0,   484,
     485,     0,   486,   487,   488,   162,   489,   490,   164,  2053,
     491,     0,   492,   166,   493,     0,   494,     0,   495,     0,
       0,     0,   496,   497,     0,   498,   170,     0,   499,     0,
     500,   501,   502,   503,   504,     0,   505,   506,   507,     0,
     508,   509,   510,   511,   512,   513,     0,     0,   173,     0,
     514,   515,   516,     0,   175,     0,   176,     0,   517,     0,
       0,   518,     0,   519,   520,   521,   522,   523,   524,   525,
       0,   180,     0,   526,     0,     0,   527,   528,   529,     0,
       0,   530,   531,   532,   533,   534,   535,   536,   537,   538,
     539,   540,   541,   542,   187,     0,   189,     0,   543,   544,
     545,   546,   547,   548,   549,   190,   550,     0,   551,   552,
       0,   553,     0,   193,   554,   194,   555,   556,  2054,     0,
     557,     0,  2055,     0,   558,   559,   560,     0,     0,   195,
       0,     0,     0,   199,   561,   562,   563,   564,   565,   566,
       0,   567,   200,   568,   201,   569,   570,   571,     0,   572,
     573,   574,   575,   576,   577,   578,   203,   579,   580,   581,
       0,   582,   583,   584,   585,   586,   587,   588,   589,   590,
     591,     0,   592,   593,     0,   594,   595,   211,   596,   597,
     598,   599,   600,   601,   602,   603,     0,   604,   605,   606,
     607,     0,   608,   215,   609,   610,     0,   611,   218,     0,
     612,   613,   614,   615,   616,   617,   618,   619,   620,   621,
     220,   622,     0,   623,   624,     0,   625,   626,   627,   628,
     629,     0,   222,   223,     0,     0,   631,   224,   632,   225,
    2056,   633,   634,   635,   636,   637,   638,     0,     0,   639,
     640,   641,   642,     0,     0,   643,   644,   645,   646,   647,
     233,     0,   648,     0,   649,   650,   651,     0,     0,   652,
       0,     0,   653,   654,   655,   656,   657,   236,   237,   238,
     239,   240,   241,   242,   243,   658,   659,   660,     0,     0,
       0,    55,    56,    57,     0,     0,     0,    58,     0,     0,
       0,     0,     0,   938,  1533,    86,    87,    88,   400,    90,
      91,    92,   401,     0,   402,    95,     0,     0,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   403,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   404,   405,     0,     0,     0,   406,
     407,     0,     0,     0,     0,   408,     0,     0,     0,     0,
       0,     0,     0,     0,   409,     0,   410,     0,   411,   412,
       0,    35,   413,     0,     0,    37,    38,    39,    40,    41,
     414,   415,   416,   417,   418,   419,   420,   421,     0,   422,
     423,   424,     0,     0,     0,     0,     0,     0,     0,   425,
     426,     0,   427,     0,   428,   429,   430,     0,   136,     0,
     138,   139,     0,   431,   432,   433,   434,   435,     0,     0,
     436,   437,   438,   140,   439,     0,   440,   441,   442,   443,
     144,     0,     0,   444,   445,   446,   447,   448,   449,     0,
     450,   451,   452,   453,   454,   455,     0,   456,   457,   458,
       0,   459,     0,     0,     0,     0,     0,     0,     0,     0,
     460,   461,   462,   463,   464,   465,   153,   154,   466,     0,
     467,     0,   468,   469,   470,   471,   472,     0,   473,   474,
     475,     0,     0,   476,   477,   478,   479,   480,     0,   481,
     482,   483,     0,   484,   485,     0,   486,   487,   488,   162,
     489,   490,   164,  2053,   491,     0,   492,   166,   493,     0,
     494,     0,   495,     0,     0,     0,   496,   497,     0,   498,
     170,     0,   499,     0,   500,   501,   502,   503,   504,     0,
     505,   506,   507,     0,   508,   509,   510,   511,   512,   513,
       0,     0,   173,     0,   514,   515,   516,     0,   175,     0,
     176,     0,   517,     0,     0,   518,     0,   519,   520,   521,
     522,   523,   524,   525,     0,   180,     0,   526,     0,     0,
     527,   528,   529,     0,     0,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   187,     0,
     189,     0,   543,   544,   545,   546,   547,   548,   549,   190,
     550,     0,   551,   552,     0,   553,     0,   193,   554,   194,
     555,   556,  2054,     0,   557,     0,  2055,     0,   558,   559,
     560,     0,     0,   195,     0,     0,     0,   199,   561,   562,
     563,   564,   565,   566,     0,   567,   200,   568,   201,   569,
     570,   571,     0,   572,   573,   574,   575,   576,   577,   578,
     203,   579,   580,   581,     0,   582,   583,   584,   585,   586,
     587,   588,   589,   590,   591,     0,   592,   593,     0,   594,
     595,   211,   596,   597,   598,   599,   600,   601,   602,   603,
       0,   604,   605,   606,   607,     0,   608,   215,   609,   610,
       0,   611,   218,     0,   612,   613,   614,   615,   616,   617,
     618,   619,   620,   621,   220,   622,     0,   623,   624,     0,
     625,   626,   627,   628,   629,     0,   222,   223,     0,     0,
     631,   224,   632,   225,  2056,   633,   634,   635,   636,   637,
     638,     0,     0,   639,   640,   641,   642,     0,     0,   643,
     644,   645,   646,   647,   233,     0,   648,     0,   649,   650,
     651,     0,     0,   652,     0,     0,   653,   654,   655,   656,
     657,   236,   237,   238,   239,   240,   241,   242,   243,   658,
     659,   660,     0,     0,     0,    55,    56,    57,     0,     0,
       0,    58,     0,     0,     0,     0,     0,   938,  1533,    86,
      87,    88,   400,    90,    91,    92,   401,     0,   402,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   403,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   404,   405,
       0,     0,     0,   406,   407,     0,     0,     0,     0,   408,
       0,     0,     0,     0,     0,     0,     0,     0,   409,     0,
     410,     0,   411,   412,     0,    35,   413,     0,     0,     0,
       0,     0,     0,    41,   414,   927,   416,   417,   418,   419,
     420,   421,   928,   422,   423,   424,     0,     0,     0,     0,
       0,     0,     0,   425,   426,     0,   427,     0,   929,   429,
     430,     0,   136,     0,   138,   139,     0,   431,   432,   433,
     434,   435,     0,     0,   436,   437,   438,   140,   439,     0,
     440,   441,   442,   443,   144,     0,     0,   444,   445,   446,
     447,   448,   449,     0,   450,   451,   452,   453,   454,   455,
       0,   456,   457,   458,     0,   459,     0,     0,     0,     0,
       0,     0,     0,     0,   460,   461,   462,   463,   464,   465,
     153,   154,   466,     0,   467,     0,   468,   469,   470,   471,
     472,     0,   473,   474,   475,     0,     0,   476,   477,   478,
     479,   480,     0,   481,   482,   483,     0,   484,   485,     0,
     486,   487,   488,   162,   489,   490,   164,     0,   491,     0,
     930,   166,   493,     0,   494,     0,   931,     0,   932,     0,
     496,   497,     0,   498,   170,     0,   499,     0,   500,   501,
     502,   503,   504,     0,   505,   506,   507,   933,   508,   509,
     510,   511,   512,   513,     0,     0,   173,     0,   514,   515,
     516,     0,   175,     0,   176,     0,   517,     0,     0,   518,
       0,   519,   520,   521,   522,   934,   524,   525,     0,   180,
       0,   526,     0,     0,   527,   528,   529,     0,     0,   530,
     531,   532,   533,   534,   535,   536,   537,   538,   539,   540,
     541,   542,   187,     0,   189,     0,   935,   544,   545,   546,
     547,   548,   549,   190,   550,     0,   551,   552,     0,   553,
       0,   193,   554,   194,   555,   556,     0,     0,   557,     0,
       0,     0,   558,   559,   560,     0,     0,   195,     0,     0,
       0,   199,   561,   562,   563,   564,   565,   566,     0,   567,
     200,   568,   201,   569,   570,   571,     0,   936,   573,   574,
     575,   576,   577,   578,   203,   579,   580,   581,     0,   582,
     937,   584,   585,   586,   587,   588,   589,   590,   591,     0,
     592,   593,     0,   594,   595,   211,   596,   597,   598,   599,
     600,   601,   602,   603,     0,   604,   605,   606,   607,     0,
     608,   215,   609,   610,     0,   611,   218,     0,   612,   613,
     614,   615,   616,   617,   618,   619,   620,   621,   220,   622,
       0,   623,   624,     0,   625,   626,   627,   628,   629,     0,
     222,   223,     0,     0,   631,   224,   632,   225,     0,   633,
     634,   635,   636,   637,   638,     0,     0,   639,   640,   641,
     642,     0,     0,   643,   644,   645,   646,   647,   233,     0,
     648,     0,   649,   650,   651,     0,     0,   652,     0,     0,
     653,   654,   655,   656,   657,   236,   237,   238,   239,   240,
     241,   242,   243,   658,   659,   660,     0,     0,     0,    55,
       0,     0,     0,     0,     0,    58,     0,     0,     0,     0,
       0,   938,   939,    86,    87,    88,   400,    90,    91,    92,
     401,     0,   402,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,   403,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,   404,   405,     0,     0,     0,   406,   407,     0,
       0,     0,     0,   408,     0,     0,     0,     0,     0,     0,
       0,     0,   409,     0,   410,     0,   411,   412,     0,    35,
     413,     0,     0,     0,     0,     0,     0,    41,   414,   927,
     416,   417,   418,   419,   420,   421,   928,   422,   423,   424,
       0,     0,     0,     0,     0,     0,     0,   425,   426,     0,
     427,     0,   929,   429,   430,     0,   136,     0,   138,   139,
       0,   431,   432,   433,   434,   435,     0,     0,   436,   437,
     438,   140,   439,     0,   440,   441,   442,   443,   144,     0,
       0,   444,   445,   446,   447,   448,   449,     0,   450,   451,
     452,   453,   454,   455,     0,   456,   457,   458,     0,   459,
       0,     0,     0,     0,     0,     0,     0,     0,   460,   461,
     462,   463,   464,   465,   153,   154,   466,     0,   467,     0,
     468,   469,   470,   471,   472,     0,   473,   474,   475,     0,
       0,   476,   477,   478,   479,   480,     0,   481,   482,   483,
       0,   484,   485,     0,   486,   487,   488,   162,   489,   490,
     164,     0,   491,     0,   930,   166,   493,     0,   494,     0,
     931,     0,     0,     0,   496,   497,     0,   498,   170,     0,
     499,     0,   500,   501,   502,   503,   504,     0,   505,   506,
     507,     0,   508,   509,   510,   511,   512,   513,     0,     0,
     173,     0,   514,   515,   516,     0,   175,     0,   176,     0,
     517,     0,     0,   518,     0,   519,   520,   521,   522,   934,
     524,   525,     0,   180,     0,   526,     0,     0,   527,   528,
     529,     0,     0,   530,   531,   532,   533,   534,   535,   536,
     537,   538,   539,   540,   541,   542,   187,     0,   189,     0,
     935,   544,   545,   546,   547,   548,   549,   190,   550,     0,
     551,   552,     0,   553,     0,   193,   554,   194,   555,   556,
       0,     0,   557,     0,     0,     0,   558,   559,   560,     0,
       0,   195,     0,     0,     0,   199,   561,   562,   563,   564,
     565,   566,     0,   567,   200,   568,   201,   569,   570,   571,
       0,   936,   573,   574,   575,   576,   577,   578,   203,   579,
     580,   581,     0,   582,   937,   584,   585,   586,   587,   588,
     589,   590,   591,     0,   592,   593,     0,   594,   595,   211,
     596,   597,   598,   599,   600,   601,   602,   603,     0,   604,
     605,   606,   607,     0,   608,   215,   609,   610,     0,   611,
     218,     0,   612,   613,   614,   615,   616,   617,   618,   619,
     620,   621,   220,   622,     0,   623,   624,     0,   625,   626,
     627,   628,   629,     0,   222,   223,     0,     0,   631,   224,
     632,   225,     0,   633,   634,   635,   636,   637,   638,     0,
       0,   639,   640,   641,   642,     0,     0,   643,   644,   645,
     646,   647,   233,     0,   648,     0,   649,   650,   651,     0,
       0,   652,     0,     0,   653,   654,   655,   656,   657,   236,
     237,   238,   239,   240,   241,   242,   243,   658,   659,   660,
       0,     0,     0,    55,     0,     0,     0,     0,     0,    58,
       0,     0,     0,     0,     0,   938,   939,    86,    87,    88,
     400,    90,    91,    92,   401,     0,   402,    95,     0,     0,
      98,    99,   100,   101,   102,   103,     0,   104,   105,   403,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   404,   405,     0,     0,
       0,   406,   407,     0,     0,     0,     0,   408,     0,     0,
       0,     0,     0,     0,     0,     0,   409,     0,   410,     0,
     411,   412,     0,    35,   413,     0,     0,     0,     0,     0,
       0,    41,   414,   415,   416,   417,   418,   419,   420,   421,
       0,   422,   423,   424,     0,     0,     0,     0,     0,     0,
       0,   425,   426,     0,   427,     0,   428,   429,   430,     0,
     136,     0,   138,   139,     0,   431,   432,   433,   434,   435,
       0,     0,   436,   437,   438,   140,   439,     0,   440,   441,
     442,   443,   144,     0,     0,   444,   445,   446,   447,   448,
     449,     0,   450,   451,   452,   453,   454,   455,     0,   456,
     457,   458,     0,   459,     0,     0,     0,     0,     0,     0,
       0,     0,   460,   461,   462,   463,   464,   465,   153,   154,
     466,   682,   467,     0,   468,   469,   470,   471,   472,     0,
     473,   474,   475,     0,     0,   476,   477,   478,   479,   480,
       0,   481,   482,   483,     0,   484,   485,     0,   486,   487,
     488,   162,   489,   490,   164,     0,   491,     0,   492,   166,
     493,     0,   494,     0,   495,     0,     0,     0,   496,   497,
       0,   498,   170,     0,   499,     0,   500,   501,   502,   503,
     504,     0,   505,   506,   507,     0,   508,   509,   510,   511,
     512,   513,     0,     0,   173,     0,   514,   515,   516,     0,
     175,     0,   176,     0,   517,     0,     0,   518,     0,   519,
     520,   521,   522,   523,   524,   525,     0,   180,     0,   526,
       0,     0,   527,   528,   529,     0,     0,   530,   531,   532,
     533,   534,   535,   536,   537,   538,   539,   540,   541,   542,
     187,     0,   189,     0,   543,   544,   545,   546,   547,   548,
     549,   190,   550,     0,   551,   552,     0,   553,     0,   193,
     554,   194,   555,   556,     0,     0,   557,     0,     0,     0,
     558,   559,   560,     0,     0,   195,     0,     0,     0,   199,
     561,   562,   563,   564,   565,   566,     0,   567,   200,   568,
     201,   569,   570,   571,     0,   572,   573,   574,   575,   576,
     577,   578,   203,   579,   580,   581,     0,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,     0,   592,   593,
       0,   594,   595,   211,   596,   597,   598,   599,   600,   601,
     602,   603,     0,   604,   605,   606,   607,     0,   608,   215,
     609,   610,     0,   611,   218,     0,   612,   613,   614,   615,
     616,   617,   618,   619,   620,   621,   220,   622,     0,   623,
     624,     0,   625,   626,   627,   628,   629,     0,   222,   223,
    1444,     0,   631,   224,   632,   225,     0,   633,   634,   635,
     636,   637,   638,     0,     0,   639,   640,   641,   642,     0,
       0,   643,   644,   645,   646,   647,   233,     0,   648,     0,
     649,   650,   651,     0,     0,   652,     0,     0,   653,   654,
     655,   656,   657,   236,   237,   238,   239,   240,   241,   242,
     243,   658,   659,   660,     0,     0,     0,    55,     0,     0,
       0,     0,     0,     0,     0,  1445,    86,    87,    88,   400,
      90,    91,    92,   401,     0,   402,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   403,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   404,   405,     0,     0,     0,
     406,   407,     0,     0,     0,     0,   408,     0,     0,     0,
       0,     0,     0,     0,     0,   409,     0,   410,     0,   411,
     412,     0,    35,     0,     0,     0,     0,     0,     0,     0,
      41,   414,   415,   416,   417,   418,   419,   420,   421,     0,
     422,   423,   424,     0,     0,     0,     0,     0,     0,     0,
     425,   426,     0,   427,     0,   428,   429,   430,     0,   136,
       0,   138,   139,     0,   431,   432,   433,   434,   435,     0,
       0,   436,   437,   438,   140,   439,     0,   440,   441,   442,
     443,   144,     0,     0,   444,   445,   446,   447,   448,   449,
       0,   450,   451,   452,   453,   454,   455,     0,   456,   457,
     458,     0,   459,     0,     0,     0,     0,     0,     0,     0,
       0,   460,   461,   462,   463,   464,   465,   153,   154,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,     0,   486,   487,   488,
     162,   489,   490,   164,     0,   491,     0,   492,   166,   493,
       0,   494,     0,   495,     0,     0,     0,   496,   497,     0,
     498,   170,     0,   499,     0,   500,   501,   502,   503,   504,
       0,   505,   506,   507,     0,   508,   509,   510,   511,   512,
     513,     0,     0,   173,     0,   514,   515,   516,     0,   175,
       0,   176,     0,   517,     0,     0,   518,     0,   519,   520,
     521,   522,   523,   524,   525,     0,   180,     0,   526,     0,
       0,   527,   528,   529,     0,     0,   530,   531,   532,   533,
     534,   535,   536,   537,   538,   539,   540,   541,   542,   187,
       0,   189,     0,   543,   544,   545,   546,   547,   548,   549,
     190,   550,     0,   551,   552,     0,   553,     0,   193,   554,
     194,   555,   556,     0,     0,   557,     0,     0,     0,   558,
     559,   560,     0,     0,   195,     0,     0,     0,   199,   561,
     562,   563,   564,   565,   566,     0,   567,   200,   568,   201,
     569,   570,   571,     0,   572,   573,   574,   575,   576,   577,
     578,   203,   579,   580,   581,     0,   582,   583,   584,   585,
     586,   587,   588,   589,   590,   591,     0,   592,   593,     0,
     594,   595,   211,   596,   597,   598,   599,   600,   601,   602,
     603,     0,   604,   605,   606,   607,     0,   608,   215,   609,
     610,     0,   611,   218,     0,   612,   613,   614,   615,   616,
     617,   618,   619,   620,   621,   220,   622,     0,   623,   624,
       0,   625,   626,   627,   628,   629,     0,   222,   223,     0,
       0,   631,   224,   632,   225,     0,   633,   634,   635,   636,
     637,   638,     0,     0,   639,   640,   641,   642,     0,     0,
     643,   644,   645,   646,   647,   233,     0,   648,     0,   649,
     650,   651,     0,     0,   652,     0,     0,   653,   654,   655,
     656,   657,   236,   237,   238,   239,   240,   241,   242,   243,
     658,   659,   660,     0,     0,     0,    55,     0,     0,     0,
       0,     0,     0,  1403,    86,    87,    88,   400,    90,    91,
      92,   401,     0,   402,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   403,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   404,   405,     0,     0,     0,   406,   407,
       0,     0,     0,     0,   408,     0,     0,     0,     0,     0,
       0,     0,     0,   409,     0,   410,     0,   411,   412,     0,
      35,     0,     0,     0,    37,    38,    39,    40,    41,   414,
     415,   416,   417,   418,   419,   420,   421,     0,   422,   423,
     424,     0,     0,     0,     0,     0,     0,     0,   425,   426,
       0,   427,     0,   428,   429,   430,     0,   136,     0,   138,
     139,     0,   431,   432,   433,   434,   435,     0,     0,   436,
     437,   438,   140,   439,     0,   440,   441,   442,   443,   144,
       0,     0,   444,   445,   446,   447,   448,   449,     0,   450,
     451,   452,   453,   454,   455,     0,   456,   457,   458,     0,
     459,     0,     0,     0,     0,     0,     0,     0,     0,   460,
     461,   462,   463,   464,   465,   153,   154,   466,     0,   467,
       0,   468,   469,   470,   471,   472,     0,   473,   474,   475,
       0,     0,   476,   477,   478,   479,   480,     0,   481,   482,
     483,     0,   484,   485,     0,   486,   487,   488,   162,   489,
     490,   164,     0,   491,     0,   492,   166,   493,     0,   494,
       0,   495,     0,     0,     0,   496,   497,     0,   498,   170,
       0,   499,     0,   500,   501,   502,   503,   504,     0,   505,
     506,   507,     0,   508,   509,   510,   511,   512,   513,     0,
       0,   173,     0,   514,   515,   516,     0,   175,     0,   176,
       0,   517,     0,     0,   518,     0,   519,   520,   521,   522,
     523,   524,   525,     0,   180,     0,   526,     0,     0,   527,
     528,   529,     0,     0,   530,   531,   532,   533,   534,   535,
     536,   537,   538,   539,   540,   541,   542,   187,     0,   189,
       0,   543,   544,   545,   546,   547,   548,   549,   190,   550,
       0,   551,   552,     0,   553,     0,   193,   554,   194,   555,
     556,     0,     0,   557,     0,     0,     0,   558,   559,   560,
       0,     0,   195,     0,     0,     0,   199,   561,   562,   563,
     564,   565,   566,     0,   567,   200,   568,   201,   569,   570,
     571,     0,   572,   573,   574,   575,   576,   577,   578,   203,
     579,   580,   581,     0,   582,   583,   584,   585,   586,   587,
     588,   589,   590,   591,     0,   592,   593,     0,   594,   595,
     211,   596,   597,   598,   599,   600,   601,   602,   603,     0,
     604,   605,   606,   607,     0,   608,   215,   609,   610,     0,
     611,   218,     0,   612,   613,   614,   615,   616,   617,   618,
     619,   620,   621,   220,   622,     0,   623,   624,     0,   625,
     626,   627,   628,   629,     0,   222,   223,     0,     0,   631,
     224,   632,   225,     0,   633,   634,   635,   636,   637,   638,
       0,     0,   639,   640,   641,   642,     0,     0,   643,   644,
     645,   646,   647,   233,     0,   648,     0,   649,   650,   651,
       0,     0,   652,     0,     0,   653,   654,   655,   656,   657,
     236,   237,   238,   239,   240,   241,   242,   243,   658,   659,
     660,     0,     0,     0,    55,    56,    57,  1400,  4197,     0,
      58,    86,    87,    88,   400,    90,    91,    92,   401,     0,
     402,    95,     0,     0,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   403,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     404,   405,     0,     0,     0,   406,   407,     0,     0,     0,
       0,   408,     0,     0,     0,     0,     0,     0,     0,     0,
     409,     0,   410,     0,   411,   412,     0,    35,   413,     0,
       0,    37,    38,    39,    40,    41,   414,   415,   416,   417,
     418,   419,   420,   421,     0,   422,   423,   424,     0,     0,
       0,     0,     0,     0,     0,   425,   426,     0,   427,     0,
     428,   429,   430,     0,   136,     0,   138,   139,     0,   431,
     432,   433,   434,   435,     0,     0,   436,   437,   438,   140,
     439,     0,   440,   441,   442,   443,   144,     0,     0,   444,
     445,   446,   447,   448,   449,     0,   450,   451,   452,   453,
     454,   455,     0,   456,   457,   458,     0,   459,     0,     0,
       0,     0,     0,     0,     0,     0,   460,   461,   462,   463,
     464,   465,   153,   154,   466,     0,   467,     0,   468,   469,
     470,   471,   472,     0,   473,   474,   475,     0,     0,   476,
     477,   478,   479,   480,     0,   481,   482,   483,     0,   484,
     485,     0,   486,   487,   488,   162,   489,   490,   164,     0,
     491,     0,   492,   166,   493,     0,   494,     0,   495,     0,
       0,     0,   496,   497,     0,   498,   170,     0,   499,     0,
     500,   501,   502,   503,   504,     0,   505,   506,   507,     0,
     508,   509,   510,   511,   512,   513,     0,     0,   173,     0,
     514,   515,   516,     0,   175,     0,   176,     0,   517,     0,
       0,   518,     0,   519,   520,   521,   522,   523,   524,   525,
       0,   180,     0,   526,     0,     0,   527,   528,   529,     0,
       0,   530,   531,   532,   533,   534,   535,   536,   537,   538,
     539,   540,   541,   542,   187,     0,   189,     0,   543,   544,
     545,   546,   547,   548,   549,   190,   550,     0,   551,   552,
       0,   553,     0,   193,   554,   194,   555,   556,     0,     0,
     557,     0,     0,     0,   558,   559,   560,     0,     0,   195,
       0,     0,     0,   199,   561,   562,   563,   564,   565,   566,
       0,   567,   200,   568,   201,   569,   570,   571,     0,   572,
     573,   574,   575,   576,   577,   578,   203,   579,   580,   581,
       0,   582,   583,   584,   585,   586,   587,   588,   589,   590,
     591,     0,   592,   593,     0,   594,   595,   211,   596,   597,
     598,   599,   600,   601,   602,   603,     0,   604,   605,   606,
     607,     0,   608,   215,   609,   610,     0,   611,   218,     0,
     612,   613,   614,   615,   616,   617,   618,   619,   620,   621,
     220,   622,     0,   623,   624,     0,   625,   626,   627,   628,
     629,     0,   222,   223,   630,     0,   631,   224,   632,   225,
       0,   633,   634,   635,   636,   637,   638,     0,     0,   639,
     640,   641,   642,     0,     0,   643,   644,   645,   646,   647,
     233,     0,   648,     0,   649,   650,   651,     0,     0,   652,
       0,     0,   653,   654,   655,   656,   657,   236,   237,   238,
     239,   240,   241,   242,   243,   658,   659,   660,     0,     0,
       0,    55,     0,    57,    86,    87,    88,   400,    90,    91,
      92,   401,     0,   402,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   403,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   404,   405,     0,     0,     0,   406,   407,
       0,     0,     0,     0,   408,     0,     0,     0,     0,     0,
       0,     0,     0,   409,     0,   410,     0,   411,   412,     0,
      35,   413,     0,     0,    37,    38,    39,    40,    41,   414,
     415,   416,   417,   418,   419,   420,   421,     0,   422,   423,
     424,     0,     0,     0,     0,     0,     0,     0,   425,   426,
       0,   427,     0,   428,   429,   430,     0,   136,     0,   138,
     139,     0,   431,   432,   433,   434,   435,     0,     0,   436,
     437,   438,   140,   439,     0,   440,   441,   442,   443,   144,
       0,     0,   444,   445,   446,   447,   448,   449,     0,   450,
     451,   452,   453,   454,   455,     0,   456,   457,   458,     0,
     459,     0,     0,     0,     0,     0,     0,     0,     0,   460,
     461,   462,   463,   464,   465,   153,   154,   466,  1089,   467,
       0,   468,   469,   470,   471,   472,     0,   473,   474,   475,
       0,     0,   476,   477,   478,   479,   480,     0,   481,   482,
     483,     0,   484,   485,     0,   486,   487,   488,   162,   489,
     490,   164,     0,   491,     0,   492,   166,   493,     0,   494,
       0,   495,     0,     0,     0,   496,   497,     0,   498,   170,
       0,   499,     0,   500,   501,   502,   503,   504,     0,   505,
     506,   507,     0,   508,   509,   510,   511,   512,   513,     0,
       0,   173,     0,   514,   515,   516,     0,   175,     0,   176,
       0,   517,     0,     0,   518,     0,   519,   520,   521,   522,
     523,   524,   525,     0,   180,     0,   526,     0,     0,   527,
     528,   529,     0,     0,   530,   531,   532,   533,   534,   535,
     536,   537,   538,   539,   540,   541,   542,   187,     0,   189,
       0,   543,   544,   545,   546,   547,   548,   549,   190,   550,
       0,   551,   552,     0,   553,     0,   193,   554,   194,   555,
     556,     0,     0,   557,     0,     0,     0,   558,   559,   560,
       0,     0,   195,     0,     0,     0,   199,   561,   562,   563,
     564,   565,   566,     0,   567,   200,   568,   201,   569,   570,
     571,     0,   572,   573,   574,   575,   576,   577,   578,   203,
     579,   580,   581,     0,   582,   583,   584,   585,   586,   587,
     588,   589,   590,   591,     0,   592,   593,     0,   594,   595,
     211,   596,   597,   598,   599,   600,   601,   602,   603,     0,
     604,   605,   606,   607,     0,   608,   215,   609,   610,     0,
     611,   218,     0,   612,   613,   614,   615,   616,   617,   618,
     619,   620,   621,   220,   622,     0,   623,   624,     0,   625,
     626,   627,   628,   629,     0,   222,   223,     0,     0,   631,
     224,   632,   225,     0,   633,   634,   635,   636,   637,   638,
       0,     0,   639,   640,   641,   642,     0,     0,   643,   644,
     645,   646,   647,   233,     0,   648,     0,   649,   650,   651,
       0,     0,   652,     0,     0,   653,   654,   655,   656,   657,
     236,   237,   238,   239,   240,   241,   242,   243,   658,   659,
     660,     0,     0,     0,    55,     0,    57,    86,    87,    88,
     400,    90,    91,    92,   401,     0,   402,    95,     0,     0,
      98,    99,   100,   101,   102,   103,     0,   104,   105,   403,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   404,   405,     0,     0,
       0,   406,   407,     0,     0,     0,     0,   408,     0,     0,
       0,     0,     0,     0,     0,     0,   409,     0,   410,     0,
     411,   412,     0,    35,   413,     0,     0,    37,    38,    39,
      40,    41,   414,   415,   416,   417,   418,   419,   420,   421,
       0,   422,   423,   424,     0,     0,     0,     0,     0,     0,
       0,   425,   426,     0,   427,     0,   428,   429,   430,     0,
     136,     0,   138,   139,     0,   431,   432,   433,   434,   435,
       0,     0,   436,   437,   438,   140,   439,     0,   440,   441,
     442,   443,   144,     0,     0,   444,   445,   446,   447,   448,
     449,     0,   450,   451,   452,   453,   454,   455,     0,   456,
     457,   458,     0,   459,     0,     0,     0,     0,     0,     0,
       0,     0,   460,   461,   462,   463,   464,   465,   153,   154,
     466,     0,   467,     0,   468,   469,   470,   471,   472,     0,
     473,   474,   475,     0,     0,   476,   477,   478,   479,   480,
       0,   481,   482,   483,     0,   484,   485,     0,   486,   487,
     488,   162,   489,   490,   164,     0,   491,     0,   492,   166,
     493,     0,   494,     0,   495,     0,     0,     0,   496,   497,
       0,   498,   170,     0,   499,     0,   500,   501,   502,   503,
     504,     0,   505,   506,   507,     0,   508,   509,   510,   511,
     512,   513,     0,     0,   173,     0,   514,   515,   516,     0,
     175,     0,   176,     0,   517,     0,     0,   518,     0,   519,
     520,   521,   522,   523,   524,   525,     0,   180,     0,   526,
       0,     0,   527,   528,   529,     0,     0,   530,   531,   532,
     533,   534,   535,   536,   537,   538,   539,   540,   541,   542,
     187,     0,   189,     0,   543,   544,   545,   546,   547,   548,
     549,   190,   550,     0,   551,   552,     0,   553,     0,   193,
     554,   194,   555,   556,     0,     0,   557,     0,     0,     0,
     558,   559,   560,     0,     0,   195,     0,     0,     0,   199,
     561,   562,   563,   564,   565,   566,     0,   567,   200,   568,
     201,   569,   570,   571,     0,   572,   573,   574,   575,   576,
     577,   578,   203,   579,   580,   581,     0,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,     0,   592,   593,
       0,   594,   595,   211,   596,   597,   598,   599,   600,   601,
     602,   603,     0,   604,   605,   606,   607,     0,   608,   215,
     609,   610,     0,   611,   218,     0,   612,   613,   614,   615,
     616,   617,   618,   619,   620,   621,   220,   622,     0,   623,
     624,     0,   625,   626,   627,   628,   629,     0,   222,   223,
       0,     0,   631,   224,   632,   225,     0,   633,   634,   635,
     636,   637,   638,     0,     0,   639,   640,   641,   642,     0,
       0,   643,   644,   645,   646,   647,   233,     0,   648,     0,
     649,   650,   651,     0,     0,   652,     0,     0,   653,   654,
     655,   656,   657,   236,   237,   238,   239,   240,   241,   242,
     243,   658,   659,   660,     0,     0,     0,    55,     0,    57,
      86,    87,    88,   400,    90,    91,    92,   401,     0,   402,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   403,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   404,
     405,     0,     0,     0,   406,   407,     0,     0,     0,     0,
     408,     0,     0,     0,     0,     0,     0,     0,     0,   409,
       0,   410,     0,   411,   412,     0,    35,     0,     0,     0,
      37,    38,    39,    40,    41,   414,   415,   416,   417,   418,
     419,   420,   421,     0,   422,   423,   424,     0,     0,     0,
       0,     0,     0,     0,   425,   426,     0,   427,     0,   428,
     429,   430,     0,   136,     0,   138,   139,     0,   431,   432,
     433,   434,   435,     0,     0,   436,   437,   438,   140,   439,
       0,   440,   441,   442,   443,   144,     0,     0,   444,   445,
     446,   447,   448,   449,     0,   450,   451,   452,   453,   454,
     455,     0,   456,   457,   458,     0,   459,     0,     0,     0,
       0,     0,     0,     0,     0,   460,   461,   462,   463,   464,
     465,   153,   154,   466,  2038,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
     478,   479,   480,     0,   481,   482,   483,     0,   484,   485,
       0,   486,   487,   488,   162,   489,   490,   164,     0,   491,
       0,   492,   166,   493,     0,   494,     0,   495,     0,     0,
       0,   496,   497,     0,   498,   170,     0,   499,     0,   500,
     501,   502,   503,   504,     0,   505,   506,   507,     0,   508,
     509,   510,   511,   512,   513,     0,     0,   173,     0,   514,
     515,   516,     0,   175,     0,   176,     0,   517,     0,     0,
     518,     0,   519,   520,   521,   522,   523,   524,   525,     0,
     180,     0,   526,     0,     0,   527,   528,   529,     0,     0,
     530,   531,   532,   533,   534,   535,   536,   537,   538,   539,
     540,   541,   542,   187,     0,   189,     0,   543,   544,   545,
     546,   547,   548,   549,   190,   550,     0,   551,   552,     0,
     553,     0,   193,   554,   194,   555,   556,     0,     0,   557,
       0,     0,     0,   558,   559,   560,     0,     0,   195,     0,
       0,     0,   199,   561,   562,   563,   564,   565,   566,     0,
     567,   200,   568,   201,   569,   570,   571,     0,   572,   573,
     574,   575,   576,   577,   578,   203,   579,   580,   581,     0,
     582,   583,   584,   585,   586,   587,   588,   589,   590,   591,
       0,   592,   593,     0,   594,   595,   211,   596,   597,   598,
     599,   600,   601,   602,   603,     0,   604,   605,   606,   607,
       0,   608,   215,   609,   610,     0,   611,   218,     0,   612,
     613,   614,   615,   616,   617,   618,   619,   620,   621,   220,
     622,     0,   623,   624,     0,   625,   626,   627,   628,   629,
       0,   222,   223,     0,     0,   631,   224,   632,   225,     0,
     633,   634,   635,   636,   637,   638,     0,     0,   639,   640,
     641,   642,     0,     0,   643,   644,   645,   646,   647,   233,
       0,   648,     0,   649,   650,   651,     0,     0,   652,     0,
       0,   653,   654,   655,   656,   657,   236,   237,   238,   239,
     240,   241,   242,   243,   658,   659,   660,     0,     0,     0,
      55,     0,    57,    86,    87,    88,   400,    90,    91,    92,
     401,     0,   402,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,   403,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,   404,   405,     0,     0,     0,   406,   407,     0,
       0,     0,     0,   408,     0,     0,     0,     0,     0,     0,
       0,     0,   409,     0,   410,     0,   411,   412,     0,    35,
       0,     0,     0,    37,    38,    39,    40,    41,   414,   415,
     416,   417,   418,   419,   420,   421,     0,   422,   423,   424,
       0,     0,     0,     0,     0,     0,     0,   425,   426,     0,
     427,     0,   428,   429,   430,     0,   136,     0,   138,   139,
       0,   431,   432,   433,   434,   435,     0,     0,   436,   437,
     438,   140,   439,     0,   440,   441,   442,   443,   144,     0,
       0,   444,   445,   446,   447,   448,   449,     0,   450,   451,
     452,   453,   454,   455,     0,   456,   457,   458,     0,   459,
       0,     0,     0,     0,     0,     0,     0,     0,   460,   461,
     462,   463,   464,   465,   153,   154,   466,     0,   467,     0,
     468,   469,   470,   471,   472,     0,   473,   474,   475,     0,
       0,   476,   477,   478,   479,   480,     0,   481,   482,   483,
       0,   484,   485,     0,   486,   487,   488,   162,   489,   490,
     164,     0,   491,     0,   492,   166,   493,     0,   494,     0,
     495,     0,     0,     0,   496,   497,     0,   498,   170,     0,
     499,     0,   500,   501,   502,   503,   504,     0,   505,   506,
     507,     0,   508,   509,   510,   511,   512,   513,     0,     0,
     173,     0,   514,   515,   516,     0,   175,     0,   176,     0,
     517,     0,     0,   518,     0,   519,   520,   521,   522,   523,
     524,   525,     0,   180,     0,   526,     0,     0,   527,   528,
     529,     0,     0,   530,   531,   532,   533,   534,   535,   536,
     537,   538,   539,   540,   541,   542,   187,     0,   189,     0,
     543,   544,   545,   546,   547,   548,   549,   190,   550,     0,
     551,   552,     0,   553,     0,   193,   554,   194,   555,   556,
       0,     0,   557,     0,     0,     0,   558,   559,   560,     0,
       0,   195,     0,     0,     0,   199,   561,   562,   563,   564,
     565,   566,     0,   567,   200,   568,   201,   569,   570,   571,
       0,   572,   573,   574,   575,   576,   577,   578,   203,   579,
     580,   581,     0,   582,   583,   584,   585,   586,   587,   588,
     589,   590,   591,     0,   592,   593,     0,   594,   595,   211,
     596,   597,   598,   599,   600,   601,   602,   603,     0,   604,
     605,   606,   607,     0,   608,   215,   609,   610,     0,   611,
     218,     0,   612,   613,   614,   615,   616,   617,   618,   619,
     620,   621,   220,   622,     0,   623,   624,     0,   625,   626,
     627,   628,   629,     0,   222,   223,     0,     0,   631,   224,
     632,   225,     0,   633,   634,   635,   636,   637,   638,     0,
       0,   639,   640,   641,   642,     0,     0,   643,   644,   645,
     646,   647,   233,     0,   648,     0,   649,   650,   651,     0,
       0,   652,     0,     0,   653,   654,   655,   656,   657,   236,
     237,   238,   239,   240,   241,   242,   243,   658,   659,   660,
       0,     0,     0,    55,     0,    57,    86,    87,    88,   400,
      90,    91,    92,   401,     0,   402,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   403,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   404,   405,     0,     0,     0,
     406,   407,     0,     0,     0,     0,   408,     0,     0,     0,
       0,     0,     0,     0,     0,   409,     0,   410,     0,   411,
     412,     0,    35,     0,     0,     0,    37,    38,    39,    40,
      41,   414,   415,   416,   417,   418,   419,   420,   421,     0,
     422,   423,   424,     0,     0,     0,     0,     0,     0,     0,
     425,   426,     0,   427,     0,   428,   429,   430,     0,   136,
       0,   138,   139,     0,   431,   432,   433,   434,   435,     0,
       0,   436,   437,   438,   140,   439,     0,   440,   441,   442,
     443,   144,     0,     0,   444,   445,   446,   447,   448,   449,
       0,   450,   451,   452,   453,   454,   455,     0,   456,   457,
     458,     0,   459,     0,     0,     0,     0,     0,     0,     0,
       0,   460,   461,   462,   463,   464,   465,   153,   154,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,     0,   486,   487,   488,
     162,   489,   490,   164,     0,   491,     0,   492,   166,   493,
       0,   494,     0,   495,     0,     0,     0,   496,   497,     0,
     498,   170,     0,   499,     0,   500,   501,   502,   503,  1839,
       0,   505,   506,   507,     0,   508,   509,   510,   511,   512,
     513,     0,     0,   173,     0,   514,   515,   516,     0,   175,
       0,   176,     0,   517,     0,     0,   518,     0,   519,   520,
     521,   522,   523,   524,   525,     0,   180,     0,   526,     0,
       0,   527,   528,   529,     0,     0,   530,   531,   532,   533,
     534,   535,   536,   537,   538,   539,   540,   541,   542,   187,
       0,   189,     0,   543,   544,   545,   546,   547,   548,   549,
     190,   550,     0,   551,   552,     0,   553,     0,   193,   554,
     194,   555,   556,     0,     0,   557,     0,     0,     0,   558,
     559,   560,     0,     0,   195,     0,     0,     0,   199,   561,
     562,   563,   564,   565,   566,     0,   567,   200,   568,   201,
     569,   570,   571,     0,   572,   573,   574,   575,   576,   577,
     578,   203,   579,   580,   581,     0,   582,   583,   584,   585,
     586,   587,   588,   589,   590,   591,     0,   592,   593,     0,
     594,   595,   211,   596,   597,   598,   599,   600,   601,   602,
     603,     0,   604,   605,   606,   607,     0,   608,   215,   609,
     610,     0,   611,   218,     0,   612,   613,   614,   615,   616,
     617,   618,   619,   620,   621,   220,   622,     0,   623,   624,
       0,   625,   626,   627,   628,   629,     0,   222,   223,     0,
       0,   631,   224,   632,   225,     0,   633,   634,   635,   636,
     637,   638,     0,     0,   639,   640,   641,   642,     0,     0,
     643,   644,   645,   646,   647,   233,     0,   648,     0,   649,
     650,   651,     0,     0,   652,     0,     0,   653,   654,   655,
     656,   657,   236,   237,   238,   239,   240,   241,   242,   243,
     658,   659,   660,     0,     0,     0,    55,   997,    57,    86,
      87,    88,   400,    90,    91,    92,   401,   998,   402,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   403,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   404,   405,
       0,     0,     0,   406,   407,     0,     0,     0,     0,   408,
       0,     0,     0,     0,     0,     0,     0,     0,   409,     0,
     410,     0,   411,   412,     0,    35,     0,     0,     0,     0,
       0,     0,     0,    41,   414,   415,   416,   417,   418,   419,
     420,   421,     0,   422,   423,   424,     0,     0,     0,     0,
       0,     0,     0,   425,   426,     0,   427,     0,   428,   429,
     430,     0,   136,     0,   138,   139,     0,   431,   432,   433,
     434,   435,     0,     0,   999,   437,   974,   140,   439,     0,
     440,   441,   442,   443,   144,     0,     0,   444,   445,   446,
     447,   448,  1000,     0,  1001,   451,   452,   453,   454,   455,
       0,   456,   457,   458,     0,   459,     0,     0,     0,     0,
       0,     0,     0,     0,   460,   461,   462,   463,   464,   465,
     153,   154,   466,     0,   467,     0,   468,   469,   470,   471,
     472,     0,   473,   474,   475,     0,     0,   476,   477,   478,
     479,   480,     0,   481,   482,   483,     0,   484,   485,     0,
     486,   487,   488,   162,   489,   490,   164,     0,   491,     0,
     492,   166,   493,     0,   494,     0,   495,     0,     0,     0,
     496,   497,     0,   498,   170,     0,   499,     0,   500,   501,
     502,   503,   504,     0,   505,   506,   507,     0,   508,   509,
     510,   511,   512,   513,     0,     0,   173,     0,   514,   515,
     516,     0,   175,     0,   176,     0,   517,     0,     0,   518,
       0,   519,   520,   521,   522,   523,   524,   525,     0,   180,
       0,   526,     0,     0,   527,   528,  1002,     0,     0,   530,
     531,   532,   533,   534,   535,   536,   537,   538,   539,   540,
     541,  1003,   187,     0,   189,     0,   543,   544,   545,   546,
     547,   548,   549,   190,   550,     0,   551,   552,     0,   553,
       0,   193,   554,   194,   555,   556,     0,     0,   557,     0,
       0,     0,   558,   559,   560,     0,     0,   195,     0,     0,
       0,   199,   561,   562,   563,   564,   565,   566,     0,   567,
     200,   568,   201,   569,   570,   571,     0,   572,   573,   574,
     575,   576,   577,   578,   203,   579,   580,   581,     0,   582,
     583,   584,   585,   586,   587,   588,   589,   590,   591,     0,
     592,   593,     0,  1004,   595,   211,   596,   597,   598,  1005,
     600,   601,   602,   603,     0,   604,   605,   606,  1006,     0,
     608,   215,   609,   610,     0,   611,   218,     0,   612,   613,
     614,   615,   616,   617,   618,   619,   620,   621,   220,   622,
       0,   623,   624,     0,   625,   626,   627,   628,   629,     0,
    1007,   223,     0,     0,  1008,   224,   632,   225,     0,   633,
     634,   635,   636,   637,   638,     0,     0,   639,   640,   641,
     642,     0,     0,   643,   644,   645,   646,   978,   233,     0,
     648,     0,   649,   650,   651,     0,     0,   652,     0,     0,
     653,   654,   655,   656,  1009,   236,   237,   238,   239,   240,
     241,   242,   243,   658,   659,   660,     0,     0,     0,    55,
     694,    86,    87,    88,   400,    90,    91,    92,   401,     0,
     402,    95,     0,     0,    98,    99,   100,   101,   102,   103,
     695,   104,   105,   403,   696,     0,   107,   108,   109,   110,
     697,   698,   112,   113,   114,   115,     0,   116,   699,   700,
     404,   405,     0,     0,     0,   406,   407,     0,     0,     0,
       0,   408,     0,     0,     0,     0,     0,     0,     0,     0,
     409,     0,   410,     0,   411,   412,     0,    35,     0,     0,
       0,     0,     0,     0,     0,    41,   414,   415,   416,   417,
     418,   419,   420,   421,   701,   422,   423,   424,   702,   703,
     704,   705,   706,   707,   708,   425,   426,   709,   427,   133,
     428,   429,   430,   135,   136,   137,   138,   139,   710,   431,
     432,   433,   434,   435,   711,   712,   436,   437,   713,   140,
     439,   714,   440,   441,   442,   443,   144,   715,   716,   444,
     445,   446,   447,   448,   717,   718,   450,   451,   452,   453,
     454,   455,   719,   456,   457,   458,   149,   459,   720,   721,
     722,   723,   150,   724,   725,   726,   460,   461,   462,   463,
     464,   465,   153,   154,   466,   727,   467,   728,   468,   469,
     470,   471,   472,   729,   473,   474,   475,   730,   731,   476,
     477,   478,   479,   480,   732,   481,   482,   483,   733,   484,
     485,   734,   486,   487,   488,   162,   489,   490,   164,   735,
     491,   736,   492,   166,   493,   737,   494,   738,   495,   167,
     739,   168,   496,   497,   740,   498,   170,   741,   499,   742,
     500,   501,   502,   503,   504,   171,   505,   506,   507,   743,
     508,   509,   510,   511,   512,   513,   744,   172,   173,   745,
     514,   515,   516,   746,   175,   747,   176,   748,   517,   177,
     178,   518,   179,   519,   520,   521,   522,   523,   524,   525,
     749,   180,   181,   526,   182,   750,   527,   528,   529,   751,
     752,   530,   531,   532,   533,   534,   535,   536,   537,   538,
     539,   540,   541,   542,   187,   188,   189,   753,   543,   544,
     545,   546,   547,   548,   549,   190,   550,   754,   551,   552,
     192,   553,   755,   193,   554,   194,   555,   556,   756,   757,
     557,   758,   759,   760,   558,   559,   560,   761,   762,   195,
     196,   197,   198,   199,   561,   562,   563,   564,   565,   566,
     763,   567,   200,   568,   201,   569,   570,   571,   764,   572,
     573,   574,   575,   576,   577,   578,   203,   579,   580,   581,
     765,   582,   583,   584,   585,   586,   587,   588,   589,   590,
     591,   766,   592,   593,   209,   594,   595,   211,   596,   597,
     598,   599,   600,   601,   602,   603,   767,   604,   605,   606,
     607,   768,   608,   215,   609,   610,   217,   611,   218,   769,
     612,   613,   614,   615,   616,   617,   618,   619,   620,   621,
     220,   622,   770,   623,   624,   771,   625,   626,   627,   628,
     629,   772,   222,   223,   773,   774,   631,   224,   632,   225,
     775,   633,   634,   635,   636,   637,   638,   776,   777,   639,
     640,   641,   642,   778,   779,   643,   644,   645,   646,   780,
     233,   781,   648,   234,   649,   650,   651,   782,   783,   652,
     784,   785,   653,   654,   655,   656,   657,   236,   237,   238,
     239,   240,   241,   242,   243,   658,   659,   660,     0,     0,
       0,    55,   694,    86,    87,    88,   400,    90,    91,    92,
     401,     0,   402,    95,     0,     0,    98,    99,   100,   101,
     102,   103,   695,   104,   105,   403,   696,     0,   107,   108,
     109,   110,   697,   698,   112,   113,   114,   115,     0,   116,
     699,   700,   404,   405,     0,     0,     0,   406,   407,     0,
       0,     0,     0,   408,     0,     0,     0,     0,     0,     0,
       0,     0,   409,     0,   410,     0,   411,   412,     0,    35,
       0,     0,     0,     0,     0,     0,     0,    41,   414,   415,
     416,   417,  2830,   419,   420,   421,   701,   422,   423,   424,
     702,   703,   704,   705,   706,   707,   708,   425,   426,   709,
     427,   133,   428,   429,   430,   135,   136,   137,   138,   139,
     710,   431,   432,   433,   434,   435,   711,   712,   436,   437,
     713,   140,   439,   714,   440,   441,   442,   443,   144,   715,
     716,   444,   445,   446,   447,   448,   717,   718,   450,   451,
     452,   453,   454,   455,   719,   456,   457,   458,   149,   459,
     720,   721,   722,   723,   150,   724,   725,   726,   460,   461,
     462,   463,   464,   465,   153,   154,   466,   727,   467,   728,
     468,   469,   470,   471,   472,   729,   473,   474,   475,   730,
     731,   476,   477,   478,  2831,   480,   732,   481,   482,   483,
     733,   484,   485,   734,   486,   487,   488,   162,   489,   490,
     164,   735,   491,   736,   492,   166,   493,   737,   494,   738,
     495,   167,   739,   168,   496,   497,   740,   498,   170,   741,
     499,   742,   500,   501,   502,   503,   504,   171,   505,   506,
     507,   743,   508,   509,   510,   511,   512,   513,   744,   172,
     173,   745,   514,   515,   516,   746,   175,   747,   176,   748,
     517,   177,   178,   518,   179,   519,   520,   521,   522,   523,
     524,   525,   749,   180,   181,   526,   182,   750,   527,   528,
     529,   751,   752,   530,   531,   532,   533,   534,   535,   536,
     537,   538,   539,   540,   541,   542,   187,   188,   189,   753,
     543,   544,   545,   546,   547,   548,   549,   190,   550,   754,
     551,   552,   192,   553,   755,   193,   554,   194,   555,   556,
     756,   757,   557,   758,   759,   760,   558,   559,   560,   761,
     762,   195,   196,   197,   198,   199,   561,   562,   563,   564,
     565,   566,   763,   567,   200,   568,   201,   569,   570,   571,
     764,   572,   573,   574,   575,   576,   577,   578,   203,   579,
     580,   581,   765,   582,   583,   584,   585,   586,   587,   588,
     589,   590,   591,   766,   592,   593,   209,   594,   595,   211,
     596,   597,   598,   599,   600,   601,   602,   603,   767,   604,
     605,   606,   607,   768,  2832,   215,   609,   610,   217,   611,
     218,   769,   612,   613,   614,   615,   616,   617,   618,   619,
     620,   621,   220,   622,   770,   623,   624,   771,   625,   626,
     627,   628,   629,   772,   222,   223,   773,   774,   631,   224,
     632,   225,   775,   633,   634,   635,   636,   637,   638,   776,
     777,   639,   640,   641,   642,   778,   779,   643,   644,   645,
     646,   780,   233,   781,   648,   234,   649,   650,   651,   782,
     783,   652,   784,   785,   653,   654,   655,   656,   657,   236,
     237,   238,   239,   240,   241,   242,   243,   658,   659,   660,
       0,     0,     0,    55,   694,    86,    87,    88,   400,    90,
      91,    92,   401,     0,   402,    95,     0,     0,    98,    99,
     100,   101,   102,   103,   695,   104,   105,   403,   696,     0,
     107,   108,   109,   110,   697,   698,   112,   113,   114,   115,
       0,   116,   699,   700,   404,   405,     0,     0,     0,   406,
     407,     0,     0,     0,     0,   408,     0,     0,     0,     0,
       0,     0,     0,     0,   409,     0,   410,     0,   411,   412,
       0,    35,     0,     0,     0,     0,     0,     0,     0,    41,
     414,   415,   416,   417,   418,   419,   420,   421,     0,   422,
     423,   424,     0,     0,     0,     0,     0,     0,     0,   425,
     426,     0,   427,   133,   428,   429,   430,   135,   136,   137,
     138,   139,     0,   431,   432,   433,   434,   435,     0,     0,
     436,   437,   438,   140,   439,     0,   440,   441,   442,   443,
     144,     0,     0,   444,   445,   446,   447,   448,   449,     0,
     450,   451,   452,   453,   454,   455,     0,   456,   457,   458,
     149,   459,     0,     0,     0,     0,   150,     0,     0,     0,
     460,   461,   462,   463,   464,   465,   153,   154,   466,     0,
     467,     0,   468,   469,   470,   471,   472,     0,   473,   474,
     475,     0,     0,   476,   477,   478,   479,   480,     0,   481,
     482,   483,     0,   484,   485,     0,   486,   487,   488,   162,
     489,   490,   164,     0,   491,     0,   492,   166,   493,     0,
     494,     0,   495,   167,     0,   168,   496,   497,     0,   498,
     170,     0,   499,     0,   500,   501,   502,   503,   504,   171,
     505,   506,   507,     0,   508,   509,   510,   511,   512,   513,
       0,   172,   173,     0,   514,   515,   516,     0,   175,     0,
     176,     0,   517,   177,   178,   518,   179,   519,   520,   521,
     522,   523,   524,   525,     0,   180,   181,   526,   182,     0,
     527,   528,   529,     0,     0,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   187,   188,
     189,  1018,   543,   544,   545,   546,   547,   548,   549,   190,
     550,     0,   551,   552,   192,   553,     0,   193,   554,   194,
     555,   556,     0,     0,   557,  1019,     0,     0,   558,   559,
     560,     0,     0,   195,   196,   197,   198,   199,   561,   562,
     563,   564,   565,   566,     0,   567,   200,   568,   201,   569,
     570,   571,     0,   572,   573,   574,   575,   576,   577,   578,
     203,   579,   580,   581,     0,   582,   583,   584,   585,   586,
     587,   588,   589,   590,   591,     0,   592,   593,   209,   594,
     595,   211,   596,   597,   598,   599,   600,   601,   602,   603,
       0,   604,   605,   606,   607,     0,   608,   215,   609,   610,
     217,   611,   218,     0,   612,   613,   614,   615,   616,   617,
     618,   619,   620,   621,   220,   622,     0,   623,   624,     0,
     625,   626,   627,   628,   629,     0,   222,   223,     0,     0,
     631,   224,   632,   225,     0,   633,   634,   635,   636,   637,
     638,     0,     0,   639,   640,   641,   642,     0,     0,   643,
     644,   645,   646,   647,   233,     0,   648,   234,   649,   650,
     651,     0,     0,   652,     0,     0,   653,   654,   655,   656,
     657,   236,   237,   238,   239,   240,   241,   242,   243,   658,
     659,   660,     0,     0,     0,    55,   694,    86,    87,    88,
     400,    90,    91,    92,   401,     0,   402,    95,     0,     0,
      98,    99,   100,   101,   102,   103,   695,   104,   105,   403,
     696,     0,   107,   108,   109,   110,   697,   698,   112,   113,
     114,   115,     0,   116,   699,   700,   404,   405,     0,     0,
       0,   406,   407,     0,     0,     0,     0,   408,     0,     0,
       0,     0,     0,     0,     0,     0,   409,     0,   410,     0,
     411,   412,     0,    35,     0,     0,     0,     0,     0,     0,
       0,    41,   414,   415,   416,   417,   418,   419,   420,   421,
       0,   422,   423,   424,     0,     0,     0,     0,     0,     0,
       0,   425,   426,     0,   427,   133,   428,   429,   430,   135,
     136,   137,   138,   139,     0,   431,   432,   433,   434,   435,
       0,     0,   436,   437,   438,   140,   439,     0,   440,   441,
     442,   443,   144,     0,     0,   444,   445,   446,   447,   448,
     449,     0,   450,   451,   452,   453,   454,   455,     0,   456,
     457,   458,   149,   459,     0,     0,     0,     0,   150,     0,
       0,     0,   460,   461,   462,   463,   464,   465,   153,   154,
     466,     0,   467,     0,   468,   469,   470,   471,   472,     0,
     473,   474,   475,     0,     0,   476,   477,   478,   479,   480,
       0,   481,   482,   483,     0,   484,   485,     0,   486,   487,
     488,   162,   489,   490,   164,     0,   491,     0,   492,   166,
     493,     0,   494,     0,   495,   167,     0,   168,   496,   497,
       0,   498,   170,     0,   499,     0,   500,   501,   502,   503,
    1243,   171,   505,   506,   507,     0,   508,   509,   510,   511,
     512,   513,     0,   172,   173,     0,   514,   515,   516,     0,
     175,     0,   176,     0,   517,   177,   178,   518,   179,   519,
     520,   521,   522,   523,   524,   525,     0,   180,   181,   526,
     182,     0,   527,   528,   529,     0,     0,   530,   531,   532,
     533,   534,   535,   536,   537,   538,   539,   540,   541,   542,
     187,   188,   189,  1018,   543,   544,   545,   546,   547,   548,
     549,   190,   550,     0,   551,   552,   192,   553,     0,   193,
     554,   194,   555,   556,     0,     0,   557,  1019,     0,     0,
     558,   559,   560,     0,     0,   195,   196,   197,   198,   199,
     561,   562,   563,   564,   565,   566,     0,   567,   200,   568,
     201,   569,   570,   571,     0,   572,   573,   574,   575,   576,
     577,   578,   203,   579,   580,   581,     0,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,     0,   592,   593,
     209,   594,   595,   211,   596,   597,   598,   599,   600,   601,
     602,   603,     0,   604,   605,   606,   607,     0,   608,   215,
     609,   610,   217,   611,   218,     0,   612,   613,   614,   615,
     616,   617,   618,   619,   620,   621,   220,   622,     0,   623,
     624,     0,   625,   626,   627,   628,   629,     0,   222,   223,
       0,     0,   631,   224,   632,   225,     0,   633,   634,   635,
     636,   637,   638,     0,     0,   639,   640,   641,   642,     0,
       0,   643,   644,   645,   646,   647,   233,     0,   648,   234,
     649,   650,   651,     0,     0,   652,     0,     0,   653,   654,
     655,   656,   657,   236,   237,   238,   239,   240,   241,   242,
     243,   658,   659,   660,     0,     0,     0,    55,   694,    86,
      87,    88,   400,    90,    91,    92,   401,     0,   402,    95,
       0,     0,    98,    99,   100,   101,   102,   103,   695,   104,
     105,   403,   696,     0,   107,   108,   109,   110,   697,   698,
     112,   113,   114,   115,     0,   116,   699,   700,   404,   405,
       0,     0,     0,   406,   407,     0,     0,     0,     0,   408,
       0,     0,     0,     0,     0,     0,     0,     0,   409,     0,
     410,     0,   411,   412,     0,    35,     0,     0,     0,     0,
       0,     0,     0,    41,   414,   415,   416,   417,   418,   419,
     420,   421,     0,   422,   423,   424,     0,     0,     0,     0,
       0,     0,     0,   425,   426,     0,   427,   133,   428,   429,
     430,   135,   136,   137,   138,   139,     0,   431,   432,   433,
     434,   435,     0,     0,   436,   437,   438,   140,   439,     0,
     440,   441,   442,   443,   144,     0,     0,   444,   445,   446,
     447,   448,   449,     0,   450,   451,   452,   453,   454,   455,
       0,   456,   457,   458,   149,   459,     0,     0,     0,     0,
     150,     0,     0,     0,   460,   461,   462,   463,   464,   465,
     153,   154,   466,     0,   467,     0,   468,   469,   470,   471,
     472,     0,   473,   474,   475,     0,     0,   476,   477,   478,
     479,   480,     0,   481,   482,   483,     0,   484,   485,     0,
     486,   487,   488,   162,   489,   490,   164,     0,   491,     0,
     492,   166,   493,     0,   494,     0,   495,   167,     0,   168,
     496,   497,     0,   498,   170,     0,   499,     0,   500,   501,
     502,   503,  1251,   171,   505,   506,   507,     0,   508,   509,
     510,   511,   512,   513,     0,   172,   173,     0,   514,   515,
     516,     0,   175,     0,   176,     0,   517,   177,   178,   518,
     179,   519,   520,   521,   522,   523,   524,   525,     0,   180,
     181,   526,   182,     0,   527,   528,   529,     0,     0,   530,
     531,   532,   533,   534,   535,   536,   537,   538,   539,   540,
     541,   542,   187,   188,   189,  1018,   543,   544,   545,   546,
     547,   548,   549,   190,   550,     0,   551,   552,   192,   553,
       0,   193,   554,   194,   555,   556,     0,     0,   557,  1019,
       0,     0,   558,   559,   560,     0,     0,   195,   196,   197,
     198,   199,   561,   562,   563,   564,   565,   566,     0,   567,
     200,   568,   201,   569,   570,   571,     0,   572,   573,   574,
     575,   576,   577,   578,   203,   579,   580,   581,     0,   582,
     583,   584,   585,   586,   587,   588,   589,   590,   591,     0,
     592,   593,   209,   594,   595,   211,   596,   597,   598,   599,
     600,   601,   602,   603,     0,   604,   605,   606,   607,     0,
     608,   215,   609,   610,   217,   611,   218,     0,   612,   613,
     614,   615,   616,   617,   618,   619,   620,   621,   220,   622,
       0,   623,   624,     0,   625,   626,   627,   628,   629,     0,
     222,   223,     0,     0,   631,   224,   632,   225,     0,   633,
     634,   635,   636,   637,   638,     0,     0,   639,   640,   641,
     642,     0,     0,   643,   644,   645,   646,   647,   233,     0,
     648,   234,   649,   650,   651,     0,     0,   652,     0,     0,
     653,   654,   655,   656,   657,   236,   237,   238,   239,   240,
     241,   242,   243,   658,   659,   660,     0,     0,     0,    55,
     694,    86,    87,    88,   400,    90,    91,    92,   401,     0,
     402,    95,     0,     0,    98,    99,   100,   101,   102,   103,
     695,   104,   105,   403,   696,     0,   107,   108,   109,   110,
     697,   698,   112,   113,   114,   115,     0,   116,   699,   700,
     404,   405,     0,     0,     0,   406,   407,     0,     0,     0,
       0,   408,     0,     0,     0,     0,     0,     0,     0,     0,
     409,     0,   410,     0,   411,   412,     0,    35,     0,     0,
       0,     0,     0,     0,     0,    41,   414,   415,   416,   417,
     418,   419,   420,   421,     0,   422,   423,   424,     0,     0,
       0,     0,     0,     0,     0,   425,   426,     0,   427,   133,
     428,   429,   430,   135,  1715,   137,  1716,  1717,     0,   431,
     432,   433,   434,   435,     0,     0,   436,   437,  1718,  1719,
     439,     0,   440,   441,   442,   443,     0,     0,     0,   444,
     445,   446,   447,   448,   449,     0,   450,   451,   452,   453,
     454,   455,     0,   456,   457,   458,   149,   459,     0,     0,
       0,     0,   150,     0,     0,     0,   460,   461,   462,   463,
     464,   465,  1720,  1721,   466,     0,   467,     0,   468,   469,
     470,   471,   472,     0,   473,   474,   475,     0,     0,   476,
     477,  1359,   479,   480,     0,   481,   482,   483,     0,   484,
     485,     0,   486,   487,   488,     0,   489,   490,     0,     0,
     491,     0,   492,  1722,   493,     0,   494,     0,   495,   167,
       0,   168,   496,   497,     0,   498,     0,     0,   499,     0,
     500,   501,   502,   503,   504,   171,   505,   506,   507,  2206,
     508,   509,   510,   511,   512,   513,     0,   172,  2207,     0,
     514,   515,   516,  1365,  1723,     0,  1724,     0,   517,   177,
     178,   518,   179,   519,   520,   521,   522,   523,   524,   525,
       0,     0,   181,   526,   182,     0,   527,   528,   529,     0,
       0,   530,   531,   532,   533,   534,   535,   536,   537,   538,
     539,   540,   541,   542,  1725,   188,  1726,     0,   543,   544,
     545,   546,   547,   548,   549,     0,   550,     0,   551,   552,
     192,   553,     0,     0,   554,  1727,   555,   556,     0,     0,
     557,     0,     0,     0,   558,   559,   560,     0,     0,  2208,
     196,   197,   198,     0,   561,   562,   563,   564,   565,   566,
       0,   567,     0,   568,     0,   569,   570,   571,     0,   572,
     573,   574,   575,   576,   577,   578,  1728,   579,   580,   581,
       0,   582,   583,   584,   585,   586,   587,   588,   589,   590,
     591,     0,   592,   593,   209,   594,   595,     0,   596,   597,
     598,   599,   600,   601,   602,   603,     0,   604,   605,   606,
     607,     0,   608,  2209,   609,   610,   217,   611,  1730,     0,
     612,   613,   614,   615,   616,   617,   618,   619,   620,   621,
       0,   622,     0,   623,   624,     0,   625,   626,   627,   628,
     629,     0,  1731,  1732,     0,     0,   631,     0,   632,     0,
       0,   633,   634,   635,   636,   637,   638,     0,     0,   639,
     640,   641,   642,     0,     0,   643,   644,   645,   646,     0,
    1733,  2210,   648,   234,   649,   650,   651,     0,     0,   652,
       0,     0,   653,   654,   655,   656,   657,     0,     0,     0,
       0,     0,     0,     0,     0,   658,   659,   660,     0,     0,
       0,    55,   694,    86,    87,    88,   400,    90,    91,    92,
     401,     0,   402,    95,     0,     0,    98,    99,   100,   101,
     102,   103,   695,   104,   105,   403,   696,     0,   107,   108,
     109,   110,   697,   698,   112,   113,   114,   115,     0,   116,
     699,   700,   404,   405,     0,     0,     0,   406,   407,     0,
       0,     0,     0,   408,     0,     0,     0,     0,     0,     0,
       0,     0,   409,     0,   410,     0,   411,   412,     0,    35,
       0,     0,     0,     0,     0,     0,     0,    41,   414,   415,
     416,   417,   418,   419,   420,   421,     0,   422,   423,   424,
       0,     0,     0,     0,     0,     0,     0,   425,   426,     0,
     427,   133,   428,   429,   430,   135,  1715,   137,  1716,  1717,
       0,   431,   432,   433,   434,   435,     0,     0,   436,   437,
    1718,  1719,   439,     0,   440,   441,   442,   443,     0,     0,
       0,   444,   445,   446,   447,   448,   449,     0,   450,   451,
     452,   453,   454,   455,     0,   456,   457,   458,   149,   459,
       0,     0,     0,     0,   150,     0,     0,     0,   460,   461,
     462,   463,   464,   465,  1720,  1721,   466,     0,   467,     0,
     468,   469,   470,   471,   472,     0,   473,   474,   475,     0,
       0,   476,   477,  1359,   479,   480,     0,   481,   482,   483,
       0,   484,   485,     0,   486,   487,   488,     0,   489,   490,
       0,     0,   491,     0,   492,  1722,   493,     0,   494,     0,
     495,   167,     0,   168,   496,   497,     0,   498,     0,     0,
     499,     0,   500,   501,   502,   503,   504,   171,   505,   506,
     507,     0,   508,   509,   510,   511,   512,   513,     0,   172,
       0,     0,   514,   515,   516,  1365,  1723,     0,  1724,     0,
     517,   177,   178,   518,   179,   519,   520,   521,   522,   523,
     524,   525,     0,     0,   181,   526,   182,     0,   527,   528,
     529,     0,     0,   530,   531,   532,   533,   534,   535,   536,
     537,   538,   539,   540,   541,   542,  1725,   188,  1726,     0,
     543,   544,   545,   546,   547,   548,   549,     0,   550,     0,
     551,   552,   192,   553,  2198,     0,   554,  1727,   555,   556,
       0,     0,   557,     0,     0,     0,   558,   559,   560,     0,
       0,     0,   196,   197,   198,     0,   561,   562,   563,   564,
     565,   566,     0,   567,     0,   568,     0,   569,   570,   571,
       0,   572,   573,   574,   575,   576,   577,   578,  1728,   579,
     580,   581,     0,   582,   583,   584,   585,   586,   587,   588,
     589,   590,   591,     0,   592,   593,   209,   594,   595,     0,
     596,   597,   598,   599,   600,   601,   602,   603,     0,   604,
     605,   606,   607,     0,   608,  2209,   609,   610,   217,   611,
    1730,     0,   612,   613,   614,   615,   616,   617,   618,   619,
     620,   621,     0,   622,     0,   623,   624,  3422,   625,   626,
     627,   628,   629,     0,  1731,  1732,     0,     0,   631,     0,
     632,     0,     0,   633,   634,   635,   636,   637,   638,     0,
       0,   639,   640,   641,   642,     0,     0,   643,   644,   645,
     646,     0,  1733,     0,   648,   234,   649,   650,   651,     0,
       0,   652,     0,     0,   653,   654,   655,   656,   657,     0,
       0,     0,     0,     0,     0,     0,     0,   658,   659,   660,
       0,     0,     0,    55,   694,    86,    87,    88,   400,    90,
      91,    92,   401,     0,   402,    95,     0,     0,    98,    99,
     100,   101,   102,   103,   695,   104,   105,   403,   696,     0,
     107,   108,   109,   110,   697,   698,   112,   113,   114,   115,
       0,   116,   699,   700,   404,   405,     0,     0,     0,   406,
     407,     0,     0,     0,     0,   408,     0,     0,     0,     0,
       0,     0,     0,     0,   409,     0,   410,     0,   411,   412,
       0,    35,     0,     0,     0,     0,     0,     0,     0,    41,
     414,   415,   416,   417,   418,   419,   420,   421,     0,   422,
     423,   424,     0,     0,     0,     0,     0,     0,     0,   425,
     426,     0,   427,   133,   428,   429,   430,   135,  1715,   137,
    1716,  1717,     0,   431,   432,   433,   434,   435,     0,     0,
     436,   437,  1718,  1719,   439,     0,   440,   441,   442,   443,
       0,     0,     0,   444,   445,   446,   447,   448,   449,     0,
     450,   451,   452,   453,   454,   455,     0,   456,   457,   458,
     149,   459,     0,     0,     0,     0,   150,     0,     0,     0,
     460,   461,   462,   463,   464,   465,  1720,  1721,   466,     0,
     467,     0,   468,   469,   470,   471,   472,     0,   473,   474,
     475,     0,     0,   476,   477,  1359,   479,   480,     0,   481,
     482,   483,     0,   484,   485,     0,   486,   487,   488,     0,
     489,   490,     0,     0,   491,     0,   492,  1722,   493,     0,
     494,     0,   495,   167,     0,   168,   496,   497,     0,   498,
       0,     0,   499,     0,   500,   501,   502,   503,   504,   171,
     505,   506,   507,     0,   508,   509,   510,   511,   512,   513,
       0,   172,     0,     0,   514,   515,   516,  1365,  1723,     0,
    1724,     0,   517,   177,   178,   518,   179,   519,   520,   521,
     522,   523,   524,   525,     0,     0,   181,   526,   182,     0,
     527,   528,   529,     0,     0,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,  1725,   188,
    1726,     0,   543,   544,   545,   546,   547,   548,   549,  2247,
     550,     0,   551,   552,   192,   553,     0,     0,   554,  1727,
     555,   556,     0,     0,   557,     0,     0,     0,   558,   559,
     560,     0,     0,     0,   196,   197,   198,     0,   561,   562,
     563,   564,   565,   566,     0,   567,     0,   568,     0,   569,
     570,   571,     0,   572,   573,   574,   575,   576,   577,   578,
    1728,   579,   580,   581,     0,   582,   583,   584,   585,   586,
     587,   588,   589,   590,   591,     0,   592,   593,   209,   594,
     595,     0,   596,   597,   598,   599,   600,   601,   602,   603,
       0,   604,   605,   606,   607,     0,   608,  1729,   609,   610,
     217,   611,  1730,     0,   612,   613,   614,   615,   616,   617,
     618,   619,   620,   621,     0,   622,     0,   623,   624,     0,
     625,   626,   627,   628,   629,     0,  1731,  1732,     0,     0,
     631,     0,   632,     0,     0,   633,   634,   635,   636,   637,
     638,     0,     0,   639,   640,   641,   642,     0,     0,   643,
     644,   645,   646,     0,  1733,     0,   648,   234,   649,   650,
     651,     0,     0,   652,     0,     0,   653,   654,   655,   656,
     657,     0,     0,     0,     0,     0,     0,     0,     0,   658,
     659,   660,     0,     0,     0,    55,   694,    86,    87,    88,
     400,    90,    91,    92,   401,     0,   402,    95,     0,     0,
      98,    99,   100,   101,   102,   103,   695,   104,   105,   403,
     696,     0,   107,   108,   109,   110,   697,   698,   112,   113,
     114,   115,     0,   116,   699,   700,   404,   405,     0,     0,
       0,   406,   407,     0,     0,     0,     0,   408,     0,     0,
       0,     0,     0,     0,     0,     0,   409,     0,   410,     0,
     411,   412,     0,    35,     0,     0,     0,     0,     0,     0,
       0,    41,   414,   415,   416,   417,   418,   419,   420,   421,
       0,   422,   423,   424,     0,     0,     0,     0,     0,     0,
       0,   425,   426,     0,   427,   133,   428,   429,   430,   135,
    1715,   137,  1716,  1717,     0,   431,   432,   433,   434,   435,
       0,     0,   436,   437,  1718,  1719,   439,     0,   440,   441,
     442,   443,     0,     0,     0,   444,   445,   446,   447,   448,
     449,     0,   450,   451,   452,   453,   454,   455,     0,   456,
     457,   458,   149,   459,     0,     0,     0,     0,   150,     0,
       0,     0,   460,   461,   462,   463,   464,   465,  1720,  1721,
     466,     0,   467,     0,   468,   469,   470,   471,   472,     0,
     473,   474,   475,     0,     0,   476,   477,  1359,   479,   480,
       0,   481,   482,   483,     0,   484,   485,     0,   486,   487,
     488,     0,   489,   490,     0,     0,   491,     0,   492,  1722,
     493,     0,   494,     0,   495,   167,     0,   168,   496,   497,
       0,   498,     0,     0,   499,     0,   500,   501,   502,   503,
     504,   171,   505,   506,   507,     0,   508,   509,   510,   511,
     512,   513,     0,   172,     0,     0,   514,   515,   516,  1365,
    1723,     0,  1724,     0,   517,   177,   178,   518,   179,   519,
     520,   521,   522,   523,   524,   525,     0,     0,   181,   526,
     182,     0,   527,   528,   529,     0,     0,   530,   531,   532,
     533,   534,   535,   536,   537,   538,   539,   540,   541,   542,
    1725,   188,  1726,     0,   543,   544,   545,   546,   547,   548,
     549,  3272,   550,     0,   551,   552,   192,   553,     0,     0,
     554,  1727,   555,   556,     0,     0,   557,     0,     0,     0,
     558,   559,   560,     0,     0,     0,   196,   197,   198,     0,
     561,   562,   563,   564,   565,   566,     0,   567,     0,   568,
       0,   569,   570,   571,     0,   572,   573,   574,   575,   576,
     577,   578,  1728,   579,   580,   581,     0,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,     0,   592,   593,
     209,   594,   595,     0,   596,   597,   598,   599,   600,   601,
     602,   603,     0,   604,   605,   606,   607,     0,   608,  1729,
     609,   610,   217,   611,  1730,     0,   612,   613,   614,   615,
     616,   617,   618,   619,   620,   621,     0,   622,     0,   623,
     624,     0,   625,   626,   627,   628,   629,     0,  1731,  1732,
       0,     0,   631,     0,   632,     0,     0,   633,   634,   635,
     636,   637,   638,     0,     0,   639,   640,   641,   642,     0,
       0,   643,   644,   645,   646,     0,  1733,     0,   648,   234,
     649,   650,   651,     0,     0,   652,     0,     0,   653,   654,
     655,   656,   657,     0,     0,     0,     0,     0,     0,     0,
       0,   658,   659,   660,     0,     0,     0,    55,   694,    86,
      87,    88,   400,    90,    91,    92,   401,     0,   402,    95,
       0,     0,    98,    99,   100,   101,   102,   103,   695,   104,
     105,   403,   696,     0,   107,   108,   109,   110,   697,   698,
     112,   113,   114,   115,     0,   116,   699,   700,   404,   405,
       0,     0,     0,   406,   407,     0,     0,     0,     0,   408,
       0,     0,     0,     0,     0,     0,     0,     0,   409,     0,
     410,     0,   411,   412,     0,    35,     0,     0,     0,     0,
       0,     0,     0,    41,   414,   415,   416,   417,   418,   419,
     420,   421,     0,   422,   423,   424,     0,     0,     0,     0,
       0,     0,     0,   425,   426,     0,   427,   133,   428,   429,
     430,   135,  1715,   137,  1716,  1717,     0,   431,   432,   433,
     434,   435,     0,     0,   436,   437,  1718,  1719,   439,     0,
     440,   441,   442,   443,     0,     0,     0,   444,   445,   446,
     447,   448,   449,     0,   450,   451,   452,   453,   454,   455,
       0,   456,   457,   458,   149,   459,     0,     0,     0,     0,
     150,     0,     0,     0,   460,   461,   462,   463,   464,   465,
    1720,  1721,   466,     0,   467,     0,   468,   469,   470,   471,
     472,     0,   473,   474,   475,     0,     0,   476,   477,  1359,
     479,   480,     0,   481,   482,   483,     0,   484,   485,     0,
     486,   487,   488,     0,   489,   490,     0,     0,   491,     0,
     492,  1722,   493,     0,   494,     0,   495,   167,     0,   168,
     496,   497,     0,   498,     0,     0,   499,     0,   500,   501,
     502,   503,   504,   171,   505,   506,   507,     0,   508,   509,
     510,   511,   512,   513,     0,   172,     0,     0,   514,   515,
     516,  1365,  1723,     0,  1724,     0,   517,   177,   178,   518,
     179,   519,   520,   521,   522,   523,   524,   525,     0,     0,
     181,   526,   182,     0,   527,   528,   529,     0,     0,   530,
     531,   532,   533,   534,   535,   536,   537,   538,   539,   540,
     541,   542,  1725,   188,  1726,     0,   543,   544,   545,   546,
     547,   548,   549,     0,   550,     0,   551,   552,   192,   553,
       0,     0,   554,  1727,   555,   556,     0,     0,   557,     0,
       0,     0,   558,   559,   560,     0,     0,     0,   196,   197,
     198,     0,   561,   562,   563,   564,   565,   566,     0,   567,
       0,   568,     0,   569,   570,   571,     0,   572,   573,   574,
     575,   576,   577,   578,  1728,   579,   580,   581,     0,   582,
     583,   584,   585,   586,   587,   588,   589,   590,   591,     0,
     592,   593,   209,   594,   595,     0,   596,   597,   598,   599,
     600,   601,   602,   603,     0,   604,   605,   606,   607,     0,
     608,  1729,   609,   610,   217,   611,  1730,     0,   612,   613,
     614,   615,   616,   617,   618,   619,   620,   621,     0,   622,
       0,   623,   624,     0,   625,   626,   627,   628,   629,     0,
    1731,  1732,     0,     0,   631,     0,   632,     0,     0,   633,
     634,   635,   636,   637,   638,     0,     0,   639,   640,   641,
     642,     0,     0,   643,   644,   645,   646,     0,  1733,     0,
     648,   234,   649,   650,   651,     0,     0,   652,     0,     0,
     653,   654,   655,   656,   657,     0,     0,     0,     0,     0,
       0,     0,     0,   658,   659,   660,     0,     0,     0,    55,
     694,    86,    87,    88,   400,    90,    91,    92,   401,     0,
     402,    95,     0,     0,    98,    99,   100,   101,   102,   103,
     695,   104,   105,   403,   696,     0,   107,   108,   109,   110,
     697,   698,   112,   113,   114,   115,     0,   116,   699,   700,
     404,   405,     0,     0,     0,   406,   407,     0,     0,     0,
       0,   408,     0,     0,     0,     0,     0,     0,     0,     0,
     409,     0,   410,     0,   411,   412,     0,    35,     0,     0,
       0,     0,     0,     0,     0,    41,   414,   415,   416,   417,
     418,   419,   420,   421,     0,   422,   423,   424,     0,     0,
       0,     0,     0,     0,     0,   425,   426,     0,   427,   133,
     428,   429,   430,   135,  1715,   137,  1716,  1717,     0,   431,
     432,   433,   434,   435,     0,     0,   436,   437,  1718,  1719,
     439,     0,   440,   441,   442,   443,     0,     0,     0,   444,
     445,   446,   447,   448,   449,     0,   450,   451,   452,   453,
     454,   455,     0,   456,   457,   458,   149,   459,     0,     0,
       0,     0,   150,     0,     0,     0,   460,   461,   462,   463,
     464,   465,  1720,  1721,   466,     0,   467,     0,   468,   469,
     470,   471,   472,     0,   473,   474,   475,     0,     0,   476,
     477,  1359,   479,   480,     0,   481,   482,   483,     0,   484,
     485,     0,   486,   487,   488,     0,   489,   490,     0,     0,
     491,     0,   492,  1722,   493,     0,   494,     0,   495,   167,
       0,   168,   496,   497,     0,   498,     0,     0,   499,     0,
     500,   501,   502,   503,   504,   171,   505,   506,   507,     0,
     508,   509,   510,   511,   512,   513,     0,   172,     0,     0,
     514,   515,   516,  1365,  1723,     0,  1724,     0,   517,   177,
     178,   518,   179,   519,   520,   521,   522,   523,   524,   525,
       0,     0,   181,   526,   182,     0,   527,   528,   529,     0,
       0,   530,   531,   532,   533,   534,   535,   536,   537,   538,
     539,   540,   541,   542,  1725,   188,  1726,     0,   543,   544,
     545,   546,   547,   548,   549,     0,   550,     0,   551,   552,
     192,   553,     0,     0,   554,  1727,   555,   556,     0,     0,
     557,     0,     0,     0,   558,   559,   560,     0,     0,     0,
     196,   197,   198,     0,   561,   562,   563,   564,   565,   566,
       0,   567,     0,   568,     0,   569,   570,   571,     0,   572,
     573,   574,   575,   576,   577,   578,  1728,   579,   580,   581,
       0,   582,   583,   584,   585,   586,   587,   588,   589,   590,
     591,     0,   592,   593,   209,   594,   595,     0,   596,   597,
     598,   599,   600,   601,   602,   603,     0,   604,   605,   606,
     607,     0,   608,  2209,   609,   610,   217,   611,  1730,     0,
     612,   613,   614,   615,   616,   617,   618,   619,   620,   621,
       0,   622,     0,   623,   624,     0,   625,   626,   627,   628,
     629,     0,  1731,  1732,     0,     0,   631,     0,   632,     0,
       0,   633,   634,   635,   636,   637,   638,     0,     0,   639,
     640,   641,   642,     0,     0,   643,   644,   645,   646,     0,
    1733,     0,   648,   234,   649,   650,   651,     0,     0,   652,
       0,     0,   653,   654,   655,   656,   657,     0,     0,     0,
       0,     0,     0,     0,     0,   658,   659,   660,     0,     0,
       0,    55,   694,    86,    87,    88,   400,    90,    91,    92,
     401,     0,   402,    95,     0,     0,    98,    99,   100,   101,
     102,   103,   695,   104,   105,   403,   696,     0,   107,   108,
     109,   110,   697,   698,   112,   113,   114,   115,     0,   116,
     699,   700,   404,   405,     0,     0,     0,   406,   407,     0,
       0,     0,     0,   408,     0,     0,     0,     0,     0,     0,
       0,     0,   409,     0,   410,     0,   411,   412,     0,    35,
       0,     0,     0,     0,     0,     0,     0,    41,   414,   415,
     416,   417,   418,   419,   420,   421,     0,   422,   423,   424,
       0,     0,     0,     0,     0,     0,     0,   425,   426,     0,
     427,   133,   428,   429,   430,   135,  1715,   137,  1716,  1717,
       0,   431,   432,   433,   434,   435,     0,     0,   436,   437,
    1718,  1719,   439,     0,   440,   441,   442,   443,     0,     0,
       0,   444,   445,   446,   447,   448,   449,     0,   450,   451,
     452,   453,   454,   455,     0,   456,   457,   458,   149,   459,
       0,     0,     0,     0,   150,     0,     0,     0,   460,   461,
     462,   463,   464,   465,  1720,  1721,   466,     0,   467,     0,
     468,   469,   470,   471,   472,     0,   473,   474,   475,     0,
       0,   476,   477,  1359,   479,   480,     0,   481,   482,   483,
       0,   484,   485,     0,   486,   487,   488,     0,   489,   490,
       0,     0,   491,     0,   492,  1722,   493,     0,   494,     0,
     495,   167,     0,   168,   496,   497,     0,   498,     0,     0,
     499,     0,   500,   501,   502,   503,   504,   171,   505,   506,
     507,     0,   508,   509,   510,   511,   512,   513,     0,   172,
       0,     0,   514,   515,   516,  1365,  1723,     0,  1724,     0,
     517,   177,   178,   518,   179,   519,   520,   521,   522,   523,
     524,   525,     0,     0,   181,   526,   182,     0,   527,   528,
     529,     0,     0,   530,   531,   532,   533,   534,   535,   536,
     537,   538,   539,   540,   541,   542,  1725,   188,  1726,     0,
     543,   544,   545,   546,   547,   548,   549,     0,   550,     0,
     551,   552,   192,   553,     0,     0,   554,  1727,   555,   556,
       0,     0,   557,     0,     0,     0,   558,   559,   560,     0,
       0,     0,   196,   197,   198,     0,   561,   562,   563,   564,
     565,   566,     0,   567,     0,   568,     0,   569,   570,   571,
       0,   572,   573,   574,   575,   576,   577,   578,  1728,   579,
     580,   581,     0,   582,   583,   584,   585,   586,   587,   588,
     589,   590,   591,     0,   592,   593,   209,   594,   595,     0,
     596,   597,   598,   599,   600,   601,   602,   603,     0,   604,
     605,   606,   607,     0,   608,     0,   609,   610,   217,   611,
    1730,     0,   612,   613,   614,   615,   616,   617,   618,   619,
     620,   621,     0,   622,     0,   623,   624,     0,   625,   626,
     627,   628,   629,     0,  1731,  1732,     0,     0,   631,     0,
     632,     0,     0,   633,   634,   635,   636,   637,   638,     0,
       0,   639,   640,   641,   642,     0,     0,   643,   644,   645,
     646,     0,  1733,     0,   648,   234,   649,   650,   651,     0,
       0,   652,     0,     0,   653,   654,   655,   656,   657,     0,
       0,     0,     0,     0,     0,     0,     0,   658,   659,   660,
       0,     0,     0,    55,   694,    86,    87,    88,   400,    90,
      91,    92,   401,     0,   402,    95,     0,     0,    98,    99,
     100,   101,   102,   103,   695,   104,   105,   403,   696,     0,
     107,   108,   109,   110,   697,   698,   112,   113,   114,   115,
       0,   116,   699,   700,   404,   405,     0,     0,     0,   406,
     407,     0,     0,     0,     0,   408,     0,     0,     0,     0,
       0,     0,     0,     0,   409,     0,   410,     0,   411,   412,
       0,    35,     0,     0,     0,     0,     0,     0,     0,    41,
     414,   415,   416,   417,   418,   419,   420,   421,     0,   422,
     423,   424,     0,     0,     0,     0,     0,     0,     0,   425,
     426,     0,   427,   133,   428,   429,   430,   135,     0,   137,
       0,     0,     0,   431,   432,   433,   434,   435,     0,     0,
     436,   437,     0,     0,   439,     0,   440,   441,   442,   443,
       0,     0,     0,   444,   445,   446,   447,   448,   449,     0,
     450,   451,   452,   453,   454,   455,     0,   456,   457,   458,
     149,   459,     0,     0,     0,     0,   150,     0,     0,     0,
     460,   461,   462,   463,   464,   465,     0,     0,   466,     0,
     467,     0,   468,   469,   470,   471,   472,     0,   473,   474,
     475,     0,     0,   476,   477,   478,   479,   480,     0,   481,
     482,   483,     0,   484,   485,     0,   486,   487,   488,     0,
     489,   490,     0,     0,   491,     0,   492,     0,   493,     0,
     494,     0,   495,   167,     0,   168,   496,   497,     0,   498,
       0,     0,   499,     0,   500,   501,   502,   503,   504,   171,
     505,   506,   507,     0,   508,   509,   510,   511,   512,   513,
       0,   172,     0,     0,   514,   515,   516,     0,     0,     0,
       0,     0,   517,   177,   178,   518,   179,   519,   520,   521,
     522,   523,   524,   525,     0,     0,   181,   526,   182,     0,
     527,   528,   529,     0,     0,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,     0,   188,
       0,     0,   543,   544,   545,   546,   547,   548,   549,     0,
     550,     0,   551,   552,   192,   553,     0,     0,   554,     0,
     555,   556,     0,     0,   557,     0,     0,     0,   558,   559,
     560,     0,     0,     0,   196,   197,   198,     0,   561,   562,
     563,   564,   565,   566,     0,   567,     0,   568,     0,   569,
     570,   571,     0,   572,   573,   574,   575,   576,   577,   578,
       0,   579,   580,   581,     0,   582,   583,   584,   585,   586,
     587,   588,   589,   590,   591,     0,   592,   593,   209,   594,
     595,     0,   596,   597,   598,   599,   600,   601,   602,   603,
       0,   604,   605,   606,   607,     0,   608,     0,   609,   610,
     217,   611,     0,     0,   612,   613,   614,   615,   616,   617,
     618,   619,   620,   621,     0,   622,     0,   623,   624,     0,
     625,   626,   627,   628,   629,     0,     0,     0,     0,     0,
     631,     0,   632,     0,     0,   633,   634,   635,   636,   637,
     638,     0,     0,   639,   640,   641,   642,     0,     0,   643,
     644,   645,   646,     0,     0,     0,   648,   234,   649,   650,
     651,     0,     0,   652,     0,     0,   653,   654,   655,   656,
     657,     0,     0,     0,     0,     0,     0,     0,     0,   658,
     659,   660,     0,     0,     0,    55,    86,    87,    88,   400,
      90,    91,    92,   401,     0,   402,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   403,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   404,   405,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    35,     0,     0,     0,     0,     0,     0,     0,
      41,   414,   415,   416,   417,   418,   419,   420,   421,   701,
     422,   423,   424,   702,   703,   704,   705,   706,   707,   708,
     425,   426,   709,   427,   133,   428,   429,   430,   135,   136,
     137,   138,   139,   710,   431,   432,   433,   434,   435,   711,
     712,   436,   437,     0,   140,   439,   714,   440,   441,   442,
     443,   144,   715,   716,   444,   445,   446,   447,   448,   717,
     718,   450,   451,   452,   453,   454,   455,   719,   456,   457,
     458,   149,   459,     0,   721,   722,   723,   150,   724,   725,
     726,   460,   461,   462,   463,     0,   465,   153,   154,   466,
     727,   467,   728,   468,   469,   470,   471,   472,   729,   473,
     474,   475,   730,   731,   476,   477,   478,   479,   480,   732,
     481,   482,   483,   733,   484,   485,   734,   486,   487,   488,
     162,   489,   490,   164,   735,   491,   736,   492,   166,   493,
     737,   494,   738,   495,   167,   739,   168,   496,   497,   740,
     498,   170,   741,   499,   742,   500,   501,     0,   503,   504,
     171,   505,   506,   507,   743,   508,   509,   510,   511,   512,
     513,   744,   172,   173,     0,   514,   515,   516,     0,   175,
     747,   176,   748,   517,   177,   178,   518,   179,   519,   520,
     521,   522,   523,   524,   525,   749,   180,   181,   526,   182,
     750,   527,   528,   529,   751,   752,   530,   531,   532,   533,
     534,   535,     0,   537,   538,     0,   540,   541,   542,   187,
     188,   189,   753,   543,   544,   545,   546,   547,   548,   549,
     190,   550,   754,   551,   552,   192,   553,   755,   193,   554,
     194,   555,   556,   756,   757,   557,   758,   759,   760,   558,
     559,   560,   761,   762,   195,   196,   197,   198,   199,   561,
     562,   563,   564,   565,   566,   763,   567,   200,   568,   201,
     569,   570,   571,   764,   572,   573,   574,   575,   576,   577,
     578,   203,   579,   580,   581,   765,   582,   583,   584,   585,
     586,   587,   588,   589,   590,   591,   766,   592,   593,   209,
     594,   595,   211,   596,   597,   598,   599,   600,   601,     0,
     603,   767,   604,   605,   606,   607,   768,   608,   215,   609,
     610,   217,   611,   218,   769,   612,   613,   614,   615,   616,
     617,   618,   619,   620,   621,   220,   622,   770,   623,   624,
     771,   625,   626,   627,   628,   629,   772,   222,   223,     0,
     774,   631,   224,   632,   225,   775,   633,   634,   635,   636,
     637,   638,     0,   777,   639,   640,   641,   642,   778,   779,
     643,   644,   645,   646,     0,   233,   781,   648,   234,   649,
     650,   651,   782,   783,   652,   784,   785,   653,   654,   655,
     656,   657,   236,   237,   238,   239,   240,   241,   242,   243,
       0,   659,   660,     0,     0,     0,    55,    86,    87,    88,
     400,    90,    91,    92,   401,     0,   402,    95,     0,     0,
      98,    99,   100,   101,   102,   103,     0,   104,   105,   403,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   404,   405,     0,     0,
       0,   406,   407,     0,     0,     0,     0,   408,     0,     0,
       0,     0,     0,     0,     0,     0,   409,     0,   410,     0,
     411,   412,     0,    35,     0,     0,     0,     0,     0,     0,
       0,    41,   414,   415,   416,   417,   418,   419,   420,   421,
       0,   422,   423,   424,     0,     0,     0,     0,     0,     0,
       0,   425,   426,     0,   427,     0,   428,   429,   430,     0,
     136,     0,   138,   139,     0,   431,   432,   433,   434,   435,
       0,     0,   436,   437,   438,   140,   439,  2178,   440,   441,
     442,   443,   144,     0,     0,   444,   445,   446,   447,   448,
     449,  2179,   450,   451,   452,   453,   454,   455,     0,   456,
     457,   458,     0,   459,     0,     0,     0,     0,     0,     0,
       0,     0,   460,   461,   462,   463,   464,   465,   153,   154,
     466,     0,   467,     0,   468,   469,   470,   471,   472,     0,
     473,   474,   475,     0,     0,   476,   477,   478,   479,   480,
       0,   481,   482,   483,     0,   484,   485,     0,   486,   487,
     488,   162,   489,   490,   164,     0,   491,     0,   492,   166,
     493,     0,   494,  2180,   495,     0,     0,     0,   496,   497,
       0,   498,   170,     0,   499,     0,   500,   501,   502,   503,
     504,     0,   505,   506,   507,     0,   508,   509,   510,   511,
     512,   513,     0,     0,   173,     0,   514,   515,   516,     0,
     175,     0,   176,     0,   517,     0,     0,   518,     0,   519,
     520,   521,   522,   523,   524,   525,     0,   180,     0,   526,
    2942,     0,   527,   528,   529,     0,     0,   530,   531,   532,
     533,   534,   535,   536,   537,   538,   539,   540,   541,   542,
     187,     0,   189,     0,   543,   544,   545,   546,   547,   548,
     549,   190,   550,     0,   551,   552,     0,   553,     0,   193,
     554,   194,   555,   556,     0,     0,   557,     0,     0,     0,
     558,   559,   560,     0,     0,   195,     0,     0,     0,   199,
     561,   562,   563,   564,   565,   566,     0,   567,   200,   568,
     201,   569,   570,   571,  2181,   572,   573,   574,   575,   576,
     577,   578,   203,   579,   580,   581,     0,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,     0,   592,   593,
       0,   594,   595,   211,   596,   597,   598,   599,   600,   601,
     602,   603,     0,   604,   605,   606,   607,     0,   608,   215,
     609,   610,     0,   611,   218,     0,   612,   613,   614,   615,
     616,   617,   618,   619,   620,   621,   220,   622,     0,   623,
     624,     0,   625,   626,   627,   628,   629,     0,   222,   223,
       0,     0,   631,   224,   632,   225,     0,   633,   634,   635,
     636,   637,   638,     0,  2182,   639,   640,   641,   642,     0,
       0,   643,   644,   645,   646,   647,   233,     0,   648,     0,
     649,   650,   651,     0,     0,   652,     0,     0,   653,   654,
     655,   656,   657,   236,   237,   238,   239,   240,   241,   242,
     243,   658,   659,   660,     0,     0,     0,    55,    86,    87,
      88,   400,    90,    91,    92,   401,     0,   402,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     403,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   404,   405,     0,
       0,     0,   406,   407,     0,     0,     0,     0,   408,     0,
       0,     0,     0,     0,     0,     0,     0,   409,     0,   410,
       0,   411,   412,     0,    35,     0,     0,     0,     0,     0,
       0,     0,    41,   414,   415,   416,   417,   418,   987,   420,
     421,   946,   422,   423,   424,     0,     0,     0,     0,     0,
       0,     0,   425,   426,     0,   427,     0,   428,   429,   430,
       0,   136,     0,   138,   139,     0,   431,   432,   433,   434,
     435,     0,     0,   436,   437,   438,   140,   439,     0,   440,
     441,   442,   443,   144,     0,     0,   444,   445,   446,   447,
     448,   449,     0,   450,   451,   452,   453,   454,   455,   947,
     456,   457,   458,     0,   459,     0,     0,     0,     0,     0,
       0,     0,     0,   460,   461,   462,   463,   464,   465,   153,
     154,   466,     0,   467,     0,   468,   469,   470,   471,   472,
       0,   473,   474,   475,     0,     0,   476,   477,   478,   479,
     480,     0,   481,   482,   483,     0,   484,   485,     0,   486,
     487,   488,   162,   489,   490,   164,     0,   491,     0,   492,
     166,   493,     0,   494,     0,   495,     0,     0,     0,   496,
     497,   988,   498,   170,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,   510,
     511,   512,   513,     0,     0,   173,     0,   514,   515,   516,
       0,   175,     0,   176,     0,   517,     0,     0,   518,     0,
     519,   520,   521,   522,   523,   524,   525,     0,   180,     0,
     526,     0,     0,   527,   528,   529,     0,     0,   530,   531,
     532,   533,   534,   535,   536,   537,   538,   539,   540,   541,
     542,   187,     0,   189,     0,   543,   544,   545,   546,   547,
     548,   549,   190,   550,     0,   551,   552,     0,   553,     0,
     193,   554,   194,   555,   556,     0,     0,   557,     0,     0,
       0,   558,   559,   560,     0,     0,   195,     0,     0,     0,
     199,   561,   562,   563,   564,   565,   566,     0,   567,   200,
     568,   201,   569,   570,   571,     0,   572,   573,   574,   575,
     576,   577,   578,   203,   579,   580,   581,   948,   582,   583,
     584,   585,   586,   587,   588,   589,   590,   591,     0,   592,
     593,     0,   594,   595,   211,   596,   597,   598,   599,   600,
     601,   602,   603,   949,   604,   605,   606,   607,     0,   608,
     215,   609,   610,     0,   611,   218,     0,   612,   613,   614,
     615,   616,   617,   618,   619,   620,   621,   220,   622,     0,
     623,   624,     0,   625,   626,   627,   628,   629,     0,   222,
     223,     0,     0,   631,   224,   632,   225,     0,   633,   634,
     635,   636,   637,   638,     0,     0,   639,   640,   641,   642,
       0,     0,   643,   644,   645,   646,   647,   233,     0,   648,
       0,   649,   650,   651,     0,     0,   652,     0,     0,   653,
     654,   655,   656,   657,   236,   237,   238,   239,   240,   241,
     242,   243,   658,   659,   660,     0,     0,     0,    55,    86,
      87,    88,   400,    90,    91,    92,   401,     0,   402,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   403,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   404,   405,
       0,     0,     0,   406,   407,     0,     0,     0,     0,   408,
       0,     0,     0,     0,     0,     0,     0,     0,   409,     0,
     410,     0,   411,   412,     0,    35,   413,     0,     0,     0,
       0,     0,     0,    41,   414,   415,   416,   417,   418,   419,
     420,   421,   680,   422,   423,   424,     0,     0,     0,     0,
       0,     0,     0,   425,   426,     0,   427,     0,   428,   429,
     430,     0,   136,     0,   138,   139,     0,   431,   432,   433,
     434,   435,     0,     0,   436,   437,   438,   140,   439,     0,
     440,   441,   442,   443,   144,     0,     0,   444,   445,   446,
     447,   448,   449,     0,   450,   451,   452,   453,   454,   455,
       0,   456,   457,   458,     0,   459,   681,     0,     0,     0,
       0,     0,     0,     0,   460,   461,   462,   463,   464,   465,
     153,   154,   466,   682,   467,     0,   468,   469,   470,   471,
     472,     0,   473,   474,   475,     0,     0,   476,   477,   478,
     479,   480,     0,   481,   482,   483,     0,   484,   485,     0,
     486,   487,   488,   162,   489,   490,   164,     0,   491,     0,
     492,   166,   493,     0,   494,     0,   495,     0,     0,     0,
     496,   497,     0,   498,   170,     0,   499,     0,   500,   501,
     502,   503,   504,     0,   505,   506,   507,     0,   508,   509,
     510,   511,   512,   513,     0,     0,   173,     0,   514,   515,
     516,     0,   175,     0,   176,     0,   517,     0,     0,   518,
       0,   519,   520,   521,   522,   523,   524,   525,     0,   180,
       0,   526,     0,     0,   527,   528,   529,     0,     0,   530,
     531,   532,   533,   534,   535,   536,   537,   538,   539,   540,
     541,   542,   187,     0,   189,     0,   543,   544,   545,   546,
     547,   548,   549,   190,   550,     0,   551,   552,     0,   553,
       0,   193,   554,   194,   555,   556,     0,     0,   557,     0,
       0,     0,   558,   559,   560,     0,     0,   195,     0,     0,
       0,   199,   561,   562,   563,   564,   565,   566,     0,   567,
     200,   568,   201,   569,   570,   571,     0,   572,   573,   574,
     575,   576,   577,   578,   203,   579,   580,   581,     0,   582,
     583,   584,   585,   586,   587,   588,   589,   590,   591,     0,
     592,   593,     0,   594,   595,   211,   596,   597,   598,   599,
     600,   601,   602,   603,     0,   604,   605,   606,   607,     0,
     608,   215,   609,   610,     0,   611,   218,     0,   612,   613,
     614,   615,   616,   617,   618,   619,   620,   621,   220,   622,
       0,   623,   624,     0,   625,   626,   627,   628,   629,     0,
     222,   223,     0,     0,   631,   224,   632,   225,     0,   633,
     634,   635,   636,   637,   638,     0,     0,   639,   640,   641,
     642,     0,     0,   643,   644,   645,   646,   647,   233,     0,
     648,     0,   649,   650,   651,     0,     0,   652,     0,     0,
     653,   654,   655,   656,   657,   236,   237,   238,   239,   240,
     241,   242,   243,   658,   659,   660,     0,     0,     0,    55,
      86,    87,    88,   400,    90,    91,    92,   401,     0,   402,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   403,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   404,
     405,     0,     0,     0,   406,   407,     0,     0,     0,     0,
     408,     0,     0,     0,     0,     0,     0,     0,     0,   409,
       0,   410,     0,   411,   412,     0,    35,     0,     0,     0,
       0,     0,     0,     0,    41,   414,   415,   416,   417,   418,
     419,   420,   421,   946,   422,   423,   424,     0,     0,     0,
       0,     0,     0,     0,   425,   426,     0,   427,     0,   428,
     429,   430,     0,   136,     0,   138,   139,     0,   431,   432,
     433,   434,   435,     0,     0,   436,   437,   438,   140,   439,
       0,   440,   441,   442,   443,   144,     0,     0,   444,   445,
     446,   447,   448,   449,     0,   450,   451,   452,   453,   454,
     455,   947,   456,   457,   458,     0,   459,     0,     0,     0,
       0,     0,     0,     0,     0,   460,   461,   462,   463,   464,
     465,   153,   154,   466,     0,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
     478,   479,   480,     0,   481,   482,   483,     0,   484,   485,
       0,   486,   487,   488,   162,   489,   490,   164,     0,   491,
       0,   492,   166,   493,     0,   494,     0,   495,     0,     0,
       0,   496,   497,     0,   498,   170,     0,   499,     0,   500,
     501,   502,   503,   504,     0,   505,   506,   507,     0,   508,
     509,   510,   511,   512,   513,     0,     0,   173,     0,   514,
     515,   516,     0,   175,     0,   176,     0,   517,     0,     0,
     518,     0,   519,   520,   521,   522,   523,   524,   525,     0,
     180,     0,   526,     0,     0,   527,   528,   529,     0,     0,
     530,   531,   532,   533,   534,   535,   536,   537,   538,   539,
     540,   541,   542,   187,     0,   189,     0,   543,   544,   545,
     546,   547,   548,   549,   190,   550,     0,   551,   552,     0,
     553,     0,   193,   554,   194,   555,   556,     0,     0,   557,
       0,     0,     0,   558,   559,   560,     0,     0,   195,     0,
       0,     0,   199,   561,   562,   563,   564,   565,   566,     0,
     567,   200,   568,   201,   569,   570,   571,     0,   572,   573,
     574,   575,   576,   577,   578,   203,   579,   580,   581,   948,
     582,   583,   584,   585,   586,   587,   588,   589,   590,   591,
       0,   592,   593,     0,   594,   595,   211,   596,   597,   598,
     599,   600,   601,   602,   603,   949,   604,   605,   606,   607,
       0,   608,   215,   609,   610,     0,   611,   218,     0,   612,
     613,   614,   615,   616,   617,   618,   619,   620,   621,   220,
     622,     0,   623,   624,     0,   625,   626,   627,   628,   629,
       0,   222,   223,     0,     0,   631,   224,   632,   225,     0,
     633,   634,   635,   636,   637,   638,     0,     0,   639,   640,
     641,   642,     0,     0,   643,   644,   645,   646,   647,   233,
       0,   648,     0,   649,   650,   651,     0,     0,   652,     0,
       0,   653,   654,   655,   656,   657,   236,   237,   238,   239,
     240,   241,   242,   243,   658,   659,   660,     0,     0,     0,
      55,    86,    87,    88,   400,    90,    91,    92,   401,     0,
     402,    95,     0,     0,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   403,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     404,   405,     0,     0,     0,   406,   407,     0,     0,     0,
       0,   408,     0,     0,     0,     0,     0,     0,     0,     0,
     409,     0,   410,     0,   411,   412,     0,    35,     0,     0,
       0,     0,     0,     0,     0,    41,   414,   415,   416,   417,
     418,   419,   420,   421,     0,   422,   423,   424,     0,     0,
       0,     0,     0,     0,     0,   425,   426,     0,   427,     0,
     428,   429,   430,     0,   136,     0,   138,   139,     0,   431,
     432,   433,   434,   435,     0,     0,   436,   437,   438,   140,
     439,     0,   440,   441,   442,   443,   144,     0,     0,   444,
     445,   446,   447,   448,   449,     0,   450,   451,   452,   453,
     454,   455,     0,   456,   457,   458,     0,   459,     0,     0,
       0,     0,     0,     0,     0,     0,   460,   461,   462,  1878,
     464,   465,   153,   154,   466,     0,   467,     0,   468,   469,
     470,   471,   472,     0,   473,   474,   475,     0,     0,   476,
     477,   478,   479,   480,     0,   481,   482,   483,     0,   484,
     485,     0,   486,   487,   488,   162,   489,   490,   164,     0,
     491,     0,   492,   166,   493,     0,   494,  1879,   495,     0,
       0,     0,  1880,   497,     0,   498,   170,     0,   499,     0,
     500,   501,   502,   503,   504,     0,   505,   506,   507,     0,
     508,   509,   510,   511,   512,   513,     0,     0,   173,     0,
     514,   515,   516,     0,   175,     0,   176,     0,   517,     0,
       0,   518,     0,   519,   520,  1881,   522,   523,   524,   525,
       0,   180,     0,   526,     0,     0,   527,   528,   529,     0,
       0,   530,   531,   532,   533,   534,   535,   536,   537,   538,
     539,   540,   541,   542,   187,     0,   189,  1018,   543,   544,
     545,   546,   547,   548,   549,   190,   550,     0,   551,   552,
       0,   553,     0,   193,   554,   194,   555,   556,     0,     0,
     557,  1019,     0,     0,   558,   559,   560,     0,     0,   195,
       0,     0,     0,   199,   561,   562,   563,   564,   565,   566,
       0,   567,   200,   568,   201,   569,   570,   571,     0,   572,
     573,   574,   575,   576,   577,   578,   203,   579,   580,   581,
       0,   582,   583,   584,   585,   586,   587,   588,   589,   590,
     591,     0,   592,   593,     0,   594,   595,   211,   596,   597,
     598,  1882,   600,   601,   602,   603,     0,  1883,   605,   606,
     607,     0,   608,   215,   609,   610,     0,   611,   218,     0,
     612,   613,   614,   615,   616,   617,   618,   619,   620,   621,
     220,   622,     0,   623,   624,  1884,  1885,   626,   627,   628,
     629,     0,   222,   223,     0,     0,   631,   224,   632,   225,
       0,   633,   634,   635,   636,   637,   638,     0,     0,   639,
     640,   641,   642,     0,     0,   643,   644,   645,   646,   647,
     233,     0,   648,     0,   649,   650,   651,     0,     0,   652,
       0,     0,   653,   654,   655,   656,   657,   236,   237,   238,
     239,   240,   241,   242,   243,   658,   659,   660,     0,     0,
       0,    55,    86,    87,    88,   400,    90,    91,    92,   401,
       0,   402,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   403,     0,     0,   107,   108,   109,
     110,     0,     0,  2624,   113,   114,   115,     0,   116,     0,
       0,   404,   405,     0,     0,     0,   406,   407,     0,     0,
       0,     0,   408,     0,     0,     0,     0,     0,     0,     0,
       0,   409,     0,   410,     0,   411,   412,     0,    35,   413,
       0,     0,     0,     0,     0,     0,    41,   414,   415,   416,
     417,   418,   419,   420,   421,     0,   422,   423,   424,     0,
       0,     0,     0,     0,     0,     0,   425,   426,     0,   427,
       0,   428,   429,   430,     0,   136,     0,   138,   139,     0,
     431,   432,   433,   434,   435,     0,     0,   436,   437,   438,
     140,   439,     0,   440,   441,   442,   443,   144,     0,     0,
     444,   445,   446,   447,   448,   449,     0,   450,   451,   452,
     453,   454,   455,     0,   456,   457,   458,     0,   459,     0,
       0,     0,     0,     0,     0,     0,     0,   460,   461,   462,
     463,   464,   465,   153,   154,   466,     0,   467,     0,   468,
     469,   470,   471,   472,     0,   473,   474,   475,     0,     0,
     476,   477,   478,   479,   480,     0,   481,   482,   483,     0,
     484,   485,     0,   486,   487,   488,   162,   489,   490,   164,
       0,   491,     0,   492,   166,   493,     0,   494,     0,   495,
       0,     0,     0,   496,  2625,     0,   498,   170,     0,   499,
       0,   500,   501,   502,   503,   504,     0,   505,   506,   507,
       0,   508,   509,   510,   511,   512,   513,     0,     0,   173,
       0,   514,   515,   516,     0,   175,     0,   176,     0,   517,
       0,     0,   518,     0,   519,   520,   521,   522,   523,   524,
     525,     0,   180,     0,   526,     0,     0,   527,   528,  2626,
       0,     0,   530,   531,   532,   533,   534,   535,   536,   537,
     538,   539,   540,   541,   542,   187,     0,   189,  1018,   543,
     544,   545,   546,   547,   548,   549,   190,   550,     0,   551,
     552,     0,   553,     0,   193,   554,   194,   555,   556,     0,
       0,   557,  1019,     0,     0,   558,   559,   560,     0,     0,
     195,     0,     0,     0,   199,   561,   562,   563,   564,   565,
     566,     0,   567,   200,   568,   201,   569,   570,   571,     0,
     572,   573,   574,   575,   576,   577,   578,   203,   579,   580,
     581,     0,   582,   583,   584,   585,   586,   587,   588,   589,
     590,   591,     0,   592,   593,     0,   594,   595,   211,   596,
     597,   598,   599,   600,   601,   602,   603,     0,   604,   605,
     606,   607,     0,   608,   215,   609,   610,     0,   611,   218,
       0,   612,   613,   614,   615,   616,   617,   618,   619,   620,
     621,   220,   622,     0,   623,   624,  2627,   625,  2628,   627,
    2629,   629,     0,   222,   223,     0,     0,   631,   224,   632,
     225,     0,   633,   634,   635,   636,   637,   638,     0,     0,
     639,   640,   641,   642,     0,     0,   643,   644,   645,   646,
     647,   233,     0,   648,     0,   649,   650,   651,     0,     0,
     652,     0,     0,   653,   654,   655,   656,   657,   236,   237,
     238,   239,   240,   241,   242,   243,   658,   659,   660,     0,
       0,     0,    55,    86,    87,    88,   400,    90,    91,    92,
     401,     0,   402,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,   403,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,   404,   405,     0,     0,     0,   406,   407,     0,
       0,     0,     0,   408,     0,     0,     0,     0,     0,     0,
       0,     0,   409,     0,   410,     0,   411,   412,     0,    35,
       0,     0,     0,     0,     0,     0,     0,    41,   414,   415,
     416,   417,   418,   419,   420,   421,     0,   422,   423,   424,
     130,   131,     0,     0,     0,     0,     0,   425,   426,     0,
     427,     0,   428,   429,   430,     0,   136,     0,   138,   139,
       0,   431,   432,   433,   434,   435,     0,     0,   436,   437,
     438,   140,   439,     0,   440,   441,   442,   443,   144,     0,
       0,   444,   445,   446,   447,   448,   449,     0,   450,   451,
     452,   453,   454,   455,     0,   456,   457,   458,     0,   459,
       0,     0,     0,     0,     0,     0,     0,     0,   460,   461,
     462,   463,   464,   465,   153,   154,   466,     0,   467,     0,
     468,   469,   470,   471,   472,     0,   473,   474,   475,     0,
       0,   476,   477,   478,   479,   480,     0,   481,   482,   483,
       0,   484,   485,     0,   486,   487,   488,   162,   489,   490,
     164,     0,   491,     0,   492,   166,   493,     0,   494,     0,
     495,     0,     0,     0,   496,   497,     0,   498,   170,     0,
     499,     0,   500,   501,   502,   503,   504,     0,   505,   506,
     507,     0,   508,   509,   510,   511,   512,   513,     0,     0,
     173,     0,   514,   515,   516,     0,   175,     0,   176,     0,
     517,     0,     0,   518,     0,   519,   520,   521,   522,   523,
     524,   525,     0,   180,     0,   526,     0,     0,   527,   528,
     529,     0,     0,   530,   531,   532,   533,   534,   535,   536,
     537,   538,   539,   540,   541,   542,   187,     0,   189,  1018,
     543,   544,   545,   546,   547,   548,   549,   190,   550,     0,
     551,   552,     0,   553,     0,   193,   554,   194,   555,   556,
       0,     0,   557,  1019,     0,     0,   558,   559,   560,     0,
       0,   195,     0,     0,     0,   199,   561,   562,   563,   564,
     565,   566,     0,   567,   200,   568,   201,   569,   570,   571,
       0,   572,   573,   574,   575,   576,   577,   578,   203,   579,
     580,   581,     0,   582,   583,   584,   585,   586,   587,   588,
     589,   590,   591,     0,   592,   593,     0,   594,   595,   211,
     596,   597,   598,   599,   600,   601,   602,   603,     0,   604,
     605,   606,   607,     0,   608,   215,   609,   610,     0,   611,
     218,     0,   612,   613,   614,   615,   616,   617,   618,   619,
     620,   621,   220,   622,     0,   623,   624,     0,   625,   626,
     627,   628,   629,     0,   222,   223,     0,     0,   631,   224,
     632,   225,     0,   633,   634,   635,   636,   637,   638,     0,
       0,   639,   640,   641,   642,     0,     0,   643,   644,   645,
     646,   647,   233,     0,   648,     0,   649,   650,   651,     0,
       0,   652,     0,     0,   653,   654,   655,   656,   657,   236,
     237,   238,   239,   240,   241,   242,   243,   658,   659,   660,
       0,     0,     0,    55,    86,    87,    88,   400,    90,    91,
      92,   401,   880,   402,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   403,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   404,   405,     0,     0,     0,   406,   407,
       0,     0,     0,     0,   408,     0,     0,     0,     0,     0,
       0,     0,     0,   409,     0,   410,     0,   411,   412,     0,
      35,   413,     0,     0,     0,     0,     0,     0,    41,   414,
     415,   416,   417,   418,   419,   420,   421,   881,   422,   423,
     424,     0,     0,     0,     0,     0,     0,     0,   425,   426,
       0,   427,     0,   428,   429,   430,     0,   136,     0,   138,
     139,     0,   431,   432,   433,   434,   435,     0,     0,   436,
     437,   438,   140,   439,     0,   440,   441,   442,   443,   144,
       0,     0,   444,   445,   446,   447,   448,   449,     0,   450,
     451,   452,   453,   454,   455,     0,   456,   457,   458,     0,
     459,     0,     0,     0,     0,     0,     0,     0,     0,   460,
     461,   462,   463,   464,   465,   153,   154,   466,     0,   467,
       0,   468,   469,   470,   471,   472,     0,   473,   474,   475,
       0,     0,   476,   477,   478,   479,   480,     0,   481,   482,
     483,     0,   484,   485,     0,   486,   487,   488,   162,   489,
     490,   164,     0,   491,     0,   492,   166,   493,     0,   494,
       0,   495,     0,     0,     0,   496,   497,     0,   498,   170,
       0,   499,     0,   500,   501,   502,   503,   504,     0,   505,
     506,   507,     0,   508,   509,   510,   511,   512,   513,     0,
       0,   173,     0,   514,   515,   516,     0,   175,     0,   176,
       0,   517,     0,     0,   518,     0,   519,   520,   521,   522,
     523,   524,   525,     0,   180,     0,   526,     0,     0,   527,
     528,   529,     0,     0,   530,   531,   532,   533,   534,   535,
     536,   537,   538,   539,   540,   541,   542,   187,     0,   189,
       0,   543,   544,   545,   546,   547,   548,   549,   190,   550,
       0,   551,   552,     0,   553,     0,   193,   554,   194,   555,
     556,     0,     0,   557,     0,     0,     0,   558,   559,   560,
       0,     0,   195,     0,     0,     0,   199,   561,   562,   563,
     564,   565,   566,     0,   567,   200,   568,   201,   569,   882,
     571,     0,   572,   573,   574,   575,   576,   577,   578,   203,
     579,   580,   581,     0,   582,   583,   584,   585,   586,   587,
     588,   589,   590,   591,     0,   592,   593,     0,   594,   595,
     211,   596,   597,   598,   599,   600,   601,   602,   603,     0,
     604,   605,   606,   607,     0,   608,   215,   609,   610,     0,
     611,   218,     0,   612,   613,   614,   615,   616,   617,   618,
     619,   620,   621,   220,   622,     0,   623,   624,     0,   625,
     626,   627,   628,   629,     0,   222,   223,     0,     0,   631,
     224,   632,   225,     0,   633,   634,   635,   636,   637,   638,
       0,     0,   639,   640,   641,   642,     0,     0,   643,   644,
     645,   646,   647,   233,     0,   648,     0,   649,   650,   651,
       0,     0,   652,     0,     0,   653,   654,   655,   656,   657,
     236,   237,   238,   239,   240,   241,   242,   243,   658,   659,
     660,     0,     0,     0,    55,    86,    87,    88,   400,    90,
      91,    92,   401,     0,   402,    95,     0,     0,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   403,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   404,   405,     0,     0,     0,   406,
     407,     0,     0,     0,     0,   408,     0,     0,     0,     0,
       0,     0,     0,     0,   409,     0,   410,     0,   411,   412,
       0,    35,     0,     0,     0,     0,     0,     0,     0,    41,
     414,   415,   416,   417,   418,   419,   420,   421,     0,   422,
     423,   424,     0,     0,     0,     0,     0,     0,     0,   425,
     426,     0,   427,     0,   428,   429,   430,     0,   136,     0,
     138,   139,     0,   431,   432,   433,   434,   435,     0,     0,
     436,   437,   438,   140,   439,     0,   440,   441,   442,   443,
     144,     0,     0,   444,   445,   446,   447,   448,   449,     0,
     450,   451,   452,   453,   454,   455,     0,   456,   457,   458,
       0,   459,     0,     0,     0,     0,     0,     0,     0,     0,
     460,   461,   462,   463,   464,   465,   153,   154,   466,     0,
     467,     0,   468,   469,   470,   471,   472,     0,   473,   474,
     475,     0,     0,   476,   477,   478,   479,   480,     0,   481,
     482,   483,     0,   484,   485,     0,   486,   487,   488,   162,
     489,   490,   164,     0,   491,     0,   492,   166,   493,     0,
     494,     0,   495,     0,     0,     0,   496,   497,     0,   498,
     170,     0,   499,     0,   500,   501,   502,   503,   504,     0,
     505,   506,   507,     0,   508,   509,   510,   511,   512,   513,
       0,     0,   173,     0,   514,   515,   516,     0,   175,     0,
     176,     0,   517,     0,     0,   518,     0,   519,   520,   521,
     522,   523,   524,   525,     0,   180,     0,   526,     0,     0,
     527,   528,   529,     0,     0,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   187,     0,
     189,  1018,   543,   544,   545,   546,   547,   548,   549,   190,
     550,     0,   551,   552,     0,   553,     0,   193,   554,   194,
     555,   556,     0,     0,   557,  1019,     0,  1020,   558,   559,
     560,     0,     0,   195,     0,     0,     0,   199,   561,   562,
     563,   564,   565,   566,     0,   567,   200,   568,   201,   569,
     570,   571,     0,   572,   573,   574,   575,   576,   577,   578,
     203,   579,   580,   581,     0,   582,   583,   584,   585,   586,
     587,   588,   589,   590,   591,     0,   592,   593,     0,   594,
     595,   211,   596,   597,   598,   599,   600,   601,   602,   603,
       0,   604,   605,   606,   607,     0,   608,   215,   609,   610,
       0,   611,   218,     0,   612,   613,   614,   615,   616,   617,
     618,   619,   620,   621,   220,   622,     0,   623,   624,     0,
     625,   626,   627,   628,   629,     0,   222,   223,     0,     0,
     631,   224,   632,   225,     0,   633,   634,   635,   636,   637,
     638,     0,     0,   639,   640,   641,   642,     0,     0,   643,
     644,   645,   646,   647,   233,     0,   648,     0,   649,   650,
     651,     0,     0,   652,     0,     0,   653,   654,   655,   656,
     657,   236,   237,   238,   239,   240,   241,   242,   243,   658,
     659,   660,     0,     0,     0,    55,    86,    87,    88,   400,
      90,    91,    92,   401,     0,   402,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   403,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   404,   405,     0,     0,     0,
     406,   407,     0,     0,     0,     0,   408,     0,     0,     0,
       0,     0,     0,     0,     0,   409,     0,   410,     0,   411,
     412,     0,    35,     0,     0,     0,     0,     0,     0,     0,
      41,   414,   415,   416,   417,   418,   419,   420,   421,  1447,
     422,   423,   424,     0,     0,     0,     0,     0,     0,     0,
     425,   426,     0,   427,     0,   428,   429,   430,     0,   136,
       0,   138,   139,     0,   431,   432,   433,   434,   435,     0,
       0,   436,   437,   438,   140,   439,     0,   440,   441,   442,
     443,   144,     0,     0,   444,   445,   446,   447,   448,   449,
       0,   450,   451,   452,   453,   454,   455,     0,   456,   457,
     458,     0,   459,     0,     0,     0,     0,     0,     0,     0,
       0,   460,   461,   462,   463,   464,   465,   153,   154,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,     0,   486,   487,   488,
     162,   489,   490,   164,     0,   491,     0,   492,   166,   493,
       0,   494,     0,   495,     0,     0,     0,   496,   497,     0,
     498,   170,     0,   499,     0,   500,   501,   502,   503,   504,
       0,   505,   506,   507,     0,   508,   509,   510,   511,   512,
     513,     0,     0,   173,     0,   514,   515,   516,     0,   175,
       0,   176,     0,   517,     0,     0,   518,     0,   519,   520,
     521,   522,   523,   524,   525,     0,   180,     0,   526,     0,
       0,   527,   528,   529,     0,     0,   530,   531,   532,   533,
     534,   535,   536,   537,   538,   539,   540,   541,   542,   187,
       0,   189,  1018,   543,   544,   545,   546,   547,   548,   549,
     190,   550,     0,   551,   552,     0,   553,     0,   193,   554,
     194,   555,   556,     0,     0,   557,  1019,     0,     0,   558,
     559,   560,     0,     0,   195,     0,     0,     0,   199,   561,
     562,   563,   564,   565,   566,     0,   567,   200,   568,   201,
     569,   570,   571,     0,   572,   573,   574,   575,   576,   577,
     578,   203,   579,   580,   581,     0,   582,   583,   584,   585,
     586,   587,   588,   589,   590,   591,     0,   592,   593,     0,
     594,   595,   211,   596,   597,   598,   599,   600,   601,   602,
     603,     0,   604,   605,   606,   607,     0,   608,   215,   609,
     610,     0,   611,   218,     0,   612,   613,   614,   615,   616,
     617,   618,   619,   620,   621,   220,   622,     0,   623,   624,
       0,   625,   626,   627,   628,   629,     0,   222,   223,     0,
       0,   631,   224,   632,   225,     0,   633,   634,   635,   636,
     637,   638,     0,     0,   639,   640,   641,   642,     0,     0,
     643,   644,   645,   646,   647,   233,     0,   648,     0,   649,
     650,   651,     0,     0,   652,     0,     0,   653,   654,   655,
     656,   657,   236,   237,   238,   239,   240,   241,   242,   243,
     658,   659,   660,     0,     0,     0,    55,    86,    87,    88,
     400,    90,    91,    92,   401,     0,   402,    95,     0,     0,
      98,    99,   100,   101,   102,   103,     0,   104,   105,   403,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   404,   405,     0,     0,
       0,   406,   407,     0,     0,     0,     0,   408,     0,     0,
       0,     0,     0,     0,     0,     0,   409,     0,   410,     0,
     411,   412,     0,    35,     0,     0,     0,     0,     0,     0,
       0,    41,   414,   415,   416,   417,   418,   419,   420,   421,
       0,   422,   423,   424,     0,     0,     0,     0,     0,     0,
       0,   425,   426,     0,   427,     0,   428,   429,   430,     0,
     136,     0,   138,   139,     0,   431,   432,   433,   434,   435,
       0,     0,   436,   437,   438,   140,   439,     0,   440,   441,
     442,   443,   144,     0,     0,   444,   445,   446,   447,   448,
     449,     0,   450,   451,   452,   453,   454,   455,   947,   456,
     457,   458,     0,   459,     0,     0,     0,     0,     0,     0,
       0,     0,   460,   461,   462,   463,   464,   465,   153,   154,
     466,     0,   467,     0,   468,   469,   470,   471,   472,     0,
     473,   474,   475,     0,     0,   476,   477,   478,   479,   480,
       0,   481,   482,   483,     0,   484,   485,     0,   486,   487,
     488,   162,   489,   490,   164,     0,   491,     0,   492,   166,
     493,     0,   494,     0,   495,     0,     0,     0,   496,   497,
       0,   498,   170,     0,   499,     0,   500,   501,   502,   503,
     504,     0,   505,   506,   507,     0,   508,   509,   510,   511,
     512,   513,     0,     0,   173,     0,   514,   515,   516,     0,
     175,     0,   176,     0,   517,     0,     0,   518,     0,   519,
     520,   521,   522,   523,   524,   525,     0,   180,     0,   526,
       0,     0,   527,   528,   529,     0,     0,   530,   531,   532,
     533,   534,   535,   536,   537,   538,   539,   540,   541,   542,
     187,     0,   189,     0,   543,   544,   545,   546,   547,   548,
     549,   190,   550,     0,   551,   552,     0,   553,     0,   193,
     554,   194,   555,   556,     0,     0,   557,     0,     0,     0,
     558,   559,   560,     0,     0,   195,     0,     0,     0,   199,
     561,   562,   563,   564,   565,   566,     0,   567,   200,   568,
     201,   569,   570,   571,     0,   572,   573,   574,   575,   576,
     577,   578,   203,   579,   580,   581,   948,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,     0,   592,   593,
       0,   594,   595,   211,   596,   597,   598,   599,   600,   601,
     602,   603,   949,   604,   605,   606,   607,     0,   608,   215,
     609,   610,     0,   611,   218,     0,   612,   613,   614,   615,
     616,   617,   618,   619,   620,   621,   220,   622,     0,   623,
     624,     0,   625,   626,   627,   628,   629,     0,   222,   223,
       0,     0,   631,   224,   632,   225,     0,   633,   634,   635,
     636,   637,   638,     0,     0,   639,   640,   641,   642,     0,
       0,   643,   644,   645,   646,   647,   233,     0,   648,     0,
     649,   650,   651,     0,     0,   652,     0,     0,   653,   654,
     655,   656,   657,   236,   237,   238,   239,   240,   241,   242,
     243,   658,   659,   660,     0,     0,     0,    55,    86,    87,
      88,   400,    90,    91,    92,   401,     0,   402,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     403,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   404,   405,     0,
       0,     0,   406,   407,     0,     0,     0,     0,   408,     0,
       0,     0,     0,     0,     0,     0,     0,   409,     0,   410,
       0,   411,   412,     0,    35,   413,     0,     0,     0,     0,
       0,     0,    41,   414,   415,   416,   417,   418,   419,   420,
     421,     0,   422,   423,   424,     0,     0,     0,     0,     0,
       0,     0,   425,   426,     0,   427,     0,   428,   429,   430,
       0,   136,     0,   138,   139,     0,   431,   432,   433,   434,
     435,     0,     0,   436,   437,   438,   140,   439,     0,   440,
     441,   442,   443,   144,     0,     0,   444,   445,   446,   447,
     448,   449,     0,   450,   451,   452,   453,   454,   455,     0,
     456,   457,   458,     0,   459,     0,     0,     0,     0,     0,
       0,     0,     0,   460,   461,   462,   463,   464,   465,   153,
     154,   466,   682,   467,     0,   468,   469,   470,   471,   472,
       0,   473,   474,   475,     0,     0,   476,   477,   478,   479,
     480,     0,   481,   482,   483,     0,   484,   485,     0,   486,
     487,   488,   162,   489,   490,   164,     0,   491,     0,   492,
     166,   493,     0,   494,     0,   495,     0,     0,     0,   496,
     497,     0,   498,   170,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,   510,
     511,   512,   513,     0,     0,   173,     0,   514,   515,   516,
       0,   175,     0,   176,     0,   517,     0,     0,   518,     0,
     519,   520,   521,   522,   523,   524,   525,     0,   180,     0,
     526,     0,     0,   527,   528,   529,     0,     0,   530,   531,
     532,   533,   534,   535,   536,   537,   538,   539,   540,   541,
     542,   187,     0,   189,     0,   543,   544,   545,   546,   547,
     548,   549,   190,   550,     0,   551,   552,     0,   553,     0,
     193,   554,   194,   555,   556,     0,     0,   557,     0,     0,
       0,   558,   559,   560,     0,     0,   195,     0,     0,     0,
     199,   561,   562,   563,   564,   565,   566,     0,   567,   200,
     568,   201,   569,   570,   571,     0,   572,   573,   574,   575,
     576,   577,   578,   203,   579,   580,   581,     0,   582,   583,
     584,   585,   586,   587,   588,   589,   590,   591,     0,   592,
     593,     0,   594,   595,   211,   596,   597,   598,   599,   600,
     601,   602,   603,     0,   604,   605,   606,   607,     0,   608,
     215,   609,   610,     0,   611,   218,     0,   612,   613,   614,
     615,   616,   617,   618,   619,   620,   621,   220,   622,     0,
     623,   624,     0,   625,   626,   627,   628,   629,     0,   222,
     223,     0,     0,   631,   224,   632,   225,     0,   633,   634,
     635,   636,   637,   638,     0,     0,   639,   640,   641,   642,
       0,     0,   643,   644,   645,   646,   647,   233,     0,   648,
       0,   649,   650,   651,     0,     0,   652,     0,     0,   653,
     654,   655,   656,   657,   236,   237,   238,   239,   240,   241,
     242,   243,   658,   659,   660,     0,     0,     0,    55,    86,
      87,    88,   400,    90,    91,    92,   401,     0,   402,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   403,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   404,   405,
       0,     0,     0,   406,   407,     0,     0,     0,     0,   408,
       0,     0,     0,     0,     0,     0,     0,     0,   409,     0,
     410,     0,   411,   412,     0,    35,     0,     0,     0,     0,
       0,     0,     0,    41,   414,   415,   416,   417,   418,   419,
     420,   421,     0,   422,   423,   424,     0,     0,     0,     0,
       0,     0,     0,   425,   426,     0,   427,     0,   428,   429,
     430,     0,   136,     0,   138,   139,     0,   431,   432,   433,
     434,   435,     0,     0,   436,   437,   438,   140,   439,     0,
     440,   441,   442,   443,   144,     0,     0,   444,   445,   446,
     447,   448,   449,     0,   450,   451,   452,   453,   454,   455,
       0,   456,   457,   458,     0,   459,     0,     0,     0,     0,
       0,     0,     0,     0,   460,   461,   462,   463,   464,   465,
     153,   154,   466,     0,   467,     0,   468,   469,   470,   471,
     472,     0,   473,   474,   475,     0,     0,   476,   477,   478,
     479,   480,     0,   481,   482,   483,     0,   484,   485,     0,
     486,   487,   488,   162,   489,   490,   164,     0,   491,     0,
     492,   166,   493,     0,   494,     0,   495,     0,     0,     0,
     496,   497,     0,   498,   170,     0,   499,     0,   500,   501,
     502,   503,   504,     0,   505,   506,   507,     0,   508,   509,
     510,   511,   512,   513,     0,     0,   173,     0,   514,   515,
     516,     0,   175,     0,   176,     0,   517,     0,     0,   518,
       0,   519,   520,   521,   522,   523,   524,   525,     0,   180,
       0,   526,     0,     0,   527,   528,   529,     0,     0,   530,
     531,   532,   533,   534,   535,   536,   537,   538,   539,   540,
     541,   542,   187,     0,   189,  1018,   543,   544,   545,   546,
     547,   548,   549,   190,   550,     0,   551,   552,     0,   553,
       0,   193,   554,   194,   555,   556,     0,     0,   557,  1019,
       0,     0,   558,   559,   560,     0,     0,   195,     0,     0,
       0,   199,   561,   562,   563,   564,   565,   566,     0,   567,
     200,   568,   201,   569,   570,   571,     0,   572,   573,   574,
     575,   576,   577,   578,   203,   579,   580,   581,     0,   582,
     583,   584,   585,   586,   587,   588,   589,   590,   591,     0,
     592,   593,     0,   594,   595,   211,   596,   597,   598,   599,
     600,   601,   602,   603,     0,   604,   605,   606,   607,     0,
     608,   215,   609,   610,     0,   611,   218,     0,   612,   613,
     614,   615,   616,   617,   618,   619,   620,   621,   220,   622,
       0,   623,   624,     0,   625,   626,   627,   628,   629,     0,
     222,   223,     0,     0,   631,   224,   632,   225,     0,   633,
     634,   635,   636,   637,   638,     0,     0,   639,   640,   641,
     642,     0,     0,   643,   644,   645,   646,   647,   233,     0,
     648,     0,   649,   650,   651,     0,     0,   652,     0,     0,
     653,   654,   655,   656,   657,   236,   237,   238,   239,   240,
     241,   242,   243,   658,   659,   660,     0,     0,     0,    55,
      86,    87,    88,   400,    90,    91,    92,   401,     0,   402,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   403,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   404,
     405,     0,     0,     0,   406,   407,     0,     0,     0,     0,
     408,     0,     0,     0,     0,     0,     0,     0,     0,   409,
       0,   410,     0,   411,   412,     0,    35,   413,     0,     0,
       0,     0,     0,     0,    41,   414,   415,   416,   417,   418,
     419,   420,   421,  1238,   422,   423,   424,     0,     0,     0,
       0,     0,     0,     0,   425,   426,     0,   427,     0,   428,
     429,   430,     0,   136,     0,   138,   139,     0,   431,   432,
     433,   434,   435,     0,     0,   436,   437,   438,   140,   439,
       0,   440,   441,   442,   443,   144,     0,     0,   444,   445,
     446,   447,   448,   449,     0,   450,   451,   452,   453,   454,
     455,     0,   456,   457,   458,     0,   459,     0,     0,     0,
       0,     0,     0,     0,     0,   460,   461,   462,   463,   464,
     465,   153,   154,   466,     0,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
     478,   479,   480,     0,   481,   482,   483,     0,   484,   485,
       0,   486,   487,   488,   162,   489,   490,   164,     0,   491,
       0,   492,   166,   493,     0,   494,     0,   495,     0,     0,
       0,   496,   497,     0,   498,   170,     0,   499,     0,   500,
     501,   502,   503,   504,     0,   505,   506,   507,     0,   508,
     509,   510,   511,   512,   513,     0,     0,   173,     0,   514,
     515,   516,     0,   175,     0,   176,     0,   517,     0,     0,
     518,     0,   519,   520,   521,   522,   523,   524,   525,     0,
     180,     0,   526,     0,     0,   527,   528,   529,     0,     0,
     530,   531,   532,   533,   534,   535,   536,   537,   538,   539,
     540,   541,   542,   187,     0,   189,     0,   543,   544,   545,
     546,   547,   548,   549,   190,   550,     0,   551,   552,     0,
     553,     0,   193,   554,   194,   555,   556,     0,     0,   557,
       0,     0,     0,   558,   559,   560,     0,     0,   195,     0,
       0,     0,   199,   561,   562,   563,   564,   565,   566,     0,
     567,   200,   568,   201,   569,   570,   571,     0,   572,   573,
     574,   575,   576,   577,   578,   203,   579,   580,   581,     0,
     582,   583,   584,   585,   586,   587,   588,   589,   590,   591,
       0,   592,   593,     0,   594,   595,   211,   596,   597,   598,
     599,   600,   601,   602,   603,     0,   604,   605,   606,   607,
       0,   608,   215,   609,   610,     0,   611,   218,     0,   612,
     613,   614,   615,   616,   617,   618,   619,   620,   621,   220,
     622,     0,   623,   624,     0,   625,   626,   627,   628,   629,
       0,   222,   223,     0,     0,   631,   224,   632,   225,     0,
     633,   634,   635,   636,   637,   638,     0,     0,   639,   640,
     641,   642,     0,     0,   643,   644,   645,   646,   647,   233,
       0,   648,     0,   649,   650,   651,     0,     0,   652,     0,
       0,   653,   654,   655,   656,   657,   236,   237,   238,   239,
     240,   241,   242,   243,   658,   659,   660,     0,     0,     0,
      55,    86,    87,    88,   400,    90,    91,    92,   401,     0,
     402,    95,     0,     0,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   403,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     404,   405,     0,     0,     0,   406,   407,     0,     0,     0,
       0,   408,     0,     0,     0,     0,     0,     0,     0,     0,
     409,     0,   410,     0,   411,   412,     0,    35,     0,     0,
       0,     0,     0,     0,     0,    41,   414,   415,   416,   417,
     418,   419,   420,   421,     0,   422,   423,   424,     0,     0,
       0,     0,     0,     0,     0,   425,   426,     0,   427,     0,
     428,   429,   430,     0,   136,     0,   138,   139,     0,   431,
     432,   433,   434,   435,     0,     0,   436,   437,   438,   140,
     439,     0,   440,   441,   442,   443,   144,     0,     0,   444,
     445,   446,   447,   448,   449,     0,   450,   451,   452,   453,
     454,   455,     0,   456,   457,   458,     0,   459,     0,     0,
       0,     0,     0,     0,     0,     0,   460,   461,   462,   463,
     464,   465,   153,   154,   466,     0,   467,     0,   468,   469,
     470,   471,   472,     0,   473,   474,   475,     0,     0,   476,
     477,   478,   479,   480,     0,   481,   482,   483,     0,   484,
     485,     0,   486,   487,   488,   162,   489,   490,   164,     0,
     491,     0,   492,   166,   493,     0,   494,     0,   495,     0,
     932,     0,   496,   497,     0,   498,   170,     0,   499,     0,
     500,   501,   502,   503,   504,     0,   505,   506,   507,   933,
     508,   509,   510,   511,   512,   513,     0,     0,   173,     0,
     514,   515,   516,     0,   175,     0,   176,     0,   517,     0,
       0,   518,     0,   519,   520,   521,   522,   523,   524,   525,
       0,   180,     0,   526,     0,     0,   527,   528,   529,     0,
       0,   530,   531,   532,   533,   534,   535,   536,   537,   538,
     539,   540,   541,   542,   187,     0,   189,     0,   543,   544,
     545,   546,   547,   548,   549,   190,   550,     0,   551,   552,
       0,   553,     0,   193,   554,   194,   555,   556,     0,     0,
     557,     0,     0,     0,   558,   559,   560,     0,     0,   195,
       0,     0,     0,   199,   561,   562,   563,   564,   565,   566,
       0,   567,   200,   568,   201,   569,   570,   571,     0,   572,
     573,   574,   575,   576,   577,   578,   203,   579,   580,   581,
       0,   582,   583,   584,   585,   586,   587,   588,   589,   590,
     591,     0,   592,   593,     0,   594,   595,   211,   596,   597,
     598,   599,   600,   601,   602,   603,     0,   604,   605,   606,
     607,     0,   608,   215,   609,   610,     0,   611,   218,     0,
     612,   613,   614,   615,   616,   617,   618,   619,   620,   621,
     220,   622,     0,   623,   624,     0,   625,   626,   627,   628,
     629,     0,   222,   223,     0,     0,   631,   224,   632,   225,
       0,   633,   634,   635,   636,   637,   638,     0,     0,   639,
     640,   641,   642,     0,     0,   643,   644,   645,   646,   647,
     233,     0,   648,     0,   649,   650,   651,     0,     0,   652,
       0,     0,   653,   654,   655,   656,   657,   236,   237,   238,
     239,   240,   241,   242,   243,   658,   659,   660,     0,     0,
       0,    55,    86,    87,    88,   400,    90,    91,    92,   401,
       0,   402,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   403,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   404,   405,     0,     0,     0,   406,   407,     0,     0,
       0,     0,   408,     0,     0,     0,     0,     0,     0,     0,
       0,   409,     0,   410,     0,   411,   412,     0,    35,     0,
       0,     0,     0,     0,     0,     0,    41,   414,   415,   416,
     417,   418,   419,   420,   421,     0,   422,   423,   424,     0,
       0,     0,     0,     0,     0,     0,   425,   426,     0,   427,
       0,   428,   429,   430,     0,   136,     0,   138,   139,     0,
     431,   432,   433,   434,   435,     0,     0,   436,   437,   438,
     140,   439,     0,   440,   441,   442,   443,   144,     0,     0,
     444,   445,   446,   447,   448,   449,     0,   450,   451,   452,
     453,   454,   455,     0,   456,   457,   458,     0,   459,     0,
       0,     0,     0,     0,     0,     0,  2288,   460,   461,   462,
     463,   464,   465,   153,   154,   466,     0,   467,     0,   468,
     469,   470,   471,   472,     0,   473,   474,   475,     0,     0,
     476,   477,   478,   479,   480,     0,   481,   482,   483,     0,
     484,   485,     0,   486,   487,   488,   162,   489,   490,   164,
       0,   491,     0,   492,   166,   493,     0,   494,     0,   495,
       0,     0,     0,   496,   497,     0,   498,   170,     0,   499,
       0,   500,   501,   502,   503,   504,     0,   505,   506,   507,
       0,   508,   509,   510,   511,   512,   513,     0,     0,   173,
       0,   514,   515,   516,     0,   175,     0,   176,     0,   517,
       0,     0,   518,     0,   519,   520,   521,   522,   523,   524,
     525,     0,   180,     0,   526,     0,     0,   527,   528,   529,
       0,     0,   530,   531,   532,   533,   534,   535,   536,   537,
     538,   539,   540,   541,   542,   187,     0,   189,     0,   543,
     544,   545,   546,   547,   548,   549,   190,   550,     0,   551,
     552,     0,   553,     0,   193,   554,   194,   555,   556,     0,
       0,   557,     0,     0,     0,   558,   559,   560,     0,     0,
     195,     0,     0,     0,   199,   561,   562,   563,   564,   565,
     566,     0,   567,   200,   568,   201,   569,   570,   571,     0,
     572,   573,   574,   575,   576,   577,   578,   203,   579,   580,
     581,     0,   582,   583,   584,   585,   586,   587,   588,   589,
     590,   591,     0,   592,   593,     0,   594,   595,   211,   596,
     597,   598,   599,   600,   601,   602,   603,     0,   604,   605,
     606,   607,     0,   608,   215,   609,   610,     0,   611,   218,
       0,   612,   613,   614,   615,   616,   617,   618,   619,   620,
     621,   220,   622,     0,   623,   624,     0,   625,   626,   627,
     628,   629,     0,   222,   223,     0,     0,   631,   224,   632,
     225,     0,   633,   634,   635,   636,   637,   638,     0,     0,
     639,   640,   641,   642,  2289,     0,   643,   644,   645,   646,
     647,   233,     0,   648,     0,   649,   650,   651,     0,     0,
     652,     0,     0,   653,   654,   655,   656,   657,   236,   237,
     238,   239,   240,   241,   242,   243,   658,   659,   660,     0,
       0,     0,    55,    86,    87,    88,   400,    90,    91,    92,
     401,     0,   402,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,   403,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,   404,   405,     0,     0,     0,   406,   407,     0,
       0,     0,     0,   408,     0,     0,     0,     0,     0,     0,
       0,     0,   409,     0,   410,     0,   411,   412,     0,    35,
       0,     0,     0,     0,     0,     0,     0,    41,   414,   415,
     416,   417,   418,   419,   420,   421,  2767,   422,   423,   424,
       0,     0,     0,     0,     0,     0,     0,   425,   426,     0,
     427,     0,   428,   429,   430,     0,   136,     0,   138,   139,
       0,   431,   432,   433,   434,   435,     0,     0,   436,   437,
     438,   140,   439,     0,   440,   441,   442,   443,   144,     0,
       0,   444,   445,   446,   447,   448,   449,     0,   450,   451,
     452,   453,   454,   455,     0,   456,   457,   458,     0,   459,
       0,     0,     0,     0,     0,     0,     0,     0,   460,   461,
     462,   463,   464,   465,   153,   154,   466,     0,   467,     0,
     468,   469,   470,   471,   472,     0,   473,   474,   475,     0,
       0,   476,   477,   478,   479,   480,     0,   481,   482,   483,
       0,   484,   485,     0,   486,   487,   488,   162,   489,   490,
     164,     0,   491,     0,   492,   166,   493,     0,   494,     0,
     495,     0,     0,     0,   496,   497,     0,   498,   170,     0,
     499,     0,   500,   501,   502,   503,   504,     0,   505,   506,
     507,     0,   508,   509,   510,   511,   512,   513,     0,     0,
     173,     0,   514,   515,   516,     0,   175,     0,   176,     0,
     517,     0,     0,   518,     0,   519,   520,   521,   522,   523,
     524,   525,     0,   180,     0,   526,     0,     0,   527,   528,
     529,     0,     0,   530,   531,   532,   533,   534,   535,   536,
     537,   538,   539,   540,   541,   542,   187,     0,   189,     0,
     543,   544,   545,   546,   547,   548,   549,   190,   550,     0,
     551,   552,     0,   553,     0,   193,   554,   194,   555,   556,
       0,     0,   557,     0,     0,     0,   558,   559,   560,     0,
       0,   195,     0,     0,     0,   199,   561,   562,   563,   564,
     565,   566,     0,   567,   200,   568,   201,   569,   570,   571,
       0,   572,   573,   574,   575,   576,   577,   578,   203,   579,
     580,   581,     0,   582,   583,   584,   585,   586,   587,   588,
     589,   590,   591,     0,   592,   593,     0,   594,   595,   211,
     596,   597,   598,   599,   600,   601,   602,   603,     0,   604,
     605,   606,   607,     0,   608,   215,   609,   610,     0,   611,
     218,     0,   612,   613,   614,   615,   616,   617,   618,   619,
     620,   621,   220,   622,     0,   623,   624,     0,   625,   626,
     627,   628,   629,     0,   222,   223,     0,     0,   631,   224,
     632,   225,     0,   633,   634,   635,   636,   637,   638,     0,
       0,   639,   640,   641,   642,  2768,     0,   643,   644,   645,
     646,   647,   233,     0,   648,     0,   649,   650,   651,     0,
       0,   652,     0,     0,   653,   654,   655,   656,   657,   236,
     237,   238,   239,   240,   241,   242,   243,   658,   659,   660,
       0,     0,     0,    55,    86,    87,    88,   400,    90,    91,
      92,   401,     0,   402,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   403,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   404,   405,     0,     0,     0,   406,   407,
       0,     0,     0,     0,   408,     0,     0,     0,     0,     0,
       0,     0,     0,   409,     0,   410,     0,   411,   412,     0,
      35,     0,     0,     0,     0,     0,     0,     0,    41,   414,
     415,   416,   417,   418,   419,   420,   421,  2777,   422,   423,
     424,     0,     0,     0,     0,     0,     0,     0,   425,   426,
       0,   427,     0,   428,   429,   430,     0,   136,     0,   138,
     139,     0,   431,   432,   433,   434,   435,     0,     0,   436,
     437,   438,   140,   439,     0,   440,   441,   442,   443,   144,
       0,     0,   444,   445,   446,   447,   448,   449,     0,   450,
     451,   452,   453,   454,   455,     0,   456,   457,   458,     0,
     459,     0,     0,     0,     0,     0,     0,     0,     0,   460,
     461,   462,   463,   464,   465,   153,   154,   466,     0,   467,
       0,   468,   469,   470,   471,   472,     0,   473,   474,   475,
       0,     0,   476,   477,   478,   479,   480,     0,   481,   482,
     483,     0,   484,   485,     0,   486,   487,   488,   162,   489,
     490,   164,     0,   491,     0,   492,   166,   493,     0,   494,
       0,   495,     0,     0,     0,   496,   497,     0,   498,   170,
       0,   499,     0,   500,   501,   502,   503,   504,     0,   505,
     506,   507,     0,   508,   509,   510,   511,   512,   513,     0,
       0,   173,     0,   514,   515,   516,     0,   175,     0,   176,
       0,   517,     0,     0,   518,     0,   519,   520,   521,   522,
     523,   524,   525,     0,   180,     0,   526,     0,     0,   527,
     528,   529,     0,     0,   530,   531,   532,   533,   534,   535,
     536,   537,   538,   539,   540,   541,   542,   187,     0,   189,
       0,   543,   544,   545,   546,   547,   548,   549,   190,   550,
       0,   551,   552,     0,   553,     0,   193,   554,   194,   555,
     556,     0,     0,   557,     0,     0,     0,   558,   559,   560,
       0,     0,   195,     0,     0,     0,   199,   561,   562,   563,
     564,   565,   566,     0,   567,   200,   568,   201,   569,   570,
     571,     0,   572,   573,   574,   575,   576,   577,   578,   203,
     579,   580,   581,     0,   582,   583,   584,   585,   586,   587,
     588,   589,   590,   591,     0,   592,   593,     0,   594,   595,
     211,   596,   597,   598,   599,   600,   601,   602,   603,     0,
     604,   605,   606,   607,     0,   608,   215,   609,   610,     0,
     611,   218,     0,   612,   613,   614,   615,   616,   617,   618,
     619,   620,   621,   220,   622,     0,   623,   624,     0,   625,
     626,   627,   628,   629,     0,   222,   223,     0,     0,   631,
     224,   632,   225,     0,   633,   634,   635,   636,   637,   638,
       0,     0,   639,   640,   641,   642,  2778,     0,   643,   644,
     645,   646,   647,   233,     0,   648,     0,   649,   650,   651,
       0,     0,   652,     0,     0,   653,   654,   655,   656,   657,
     236,   237,   238,   239,   240,   241,   242,   243,   658,   659,
     660,     0,     0,     0,    55,    86,    87,    88,   400,    90,
      91,    92,   401,     0,   402,    95,     0,     0,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   403,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   404,   405,     0,     0,     0,   406,
     407,     0,     0,     0,     0,   408,     0,     0,     0,     0,
       0,     0,     0,     0,   409,     0,   410,     0,   411,   412,
       0,    35,     0,     0,     0,     0,     0,     0,     0,    41,
     414,   415,   416,   417,   418,   419,   420,   421,   689,   422,
     423,   424,     0,     0,     0,     0,     0,     0,     0,   425,
     426,     0,   427,     0,   428,   429,   430,     0,   136,     0,
     138,   139,     0,   431,   432,   433,   434,   435,     0,     0,
     436,   437,   438,   140,   439,     0,   440,   441,   442,   443,
     144,     0,     0,   444,   445,   446,   447,   448,   449,     0,
     450,   451,   452,   453,   454,   455,     0,   456,   457,   458,
       0,   459,     0,     0,     0,     0,     0,     0,     0,     0,
     460,   461,   462,   463,   464,   465,   153,   154,   466,     0,
     467,     0,   468,   469,   470,   471,   472,     0,   473,   474,
     475,     0,     0,   476,   477,   478,   479,   480,     0,   481,
     482,   483,     0,   484,   485,     0,   486,   487,   488,   162,
     489,   490,   164,     0,   491,     0,   492,   166,   493,     0,
     494,     0,   495,     0,     0,     0,   496,   497,     0,   498,
     170,     0,   499,     0,   500,   501,   502,   503,   504,     0,
     505,   506,   507,     0,   508,   509,   510,   511,   512,   513,
       0,     0,   173,     0,   514,   515,   516,     0,   175,     0,
     176,     0,   517,     0,     0,   518,     0,   519,   520,   521,
     522,   523,   524,   525,     0,   180,     0,   526,     0,     0,
     527,   528,   529,     0,     0,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   187,     0,
     189,     0,   543,   544,   545,   546,   547,   548,   549,   190,
     550,     0,   551,   552,     0,   553,     0,   193,   554,   194,
     555,   556,     0,     0,   557,     0,     0,     0,   558,   559,
     560,     0,     0,   195,     0,     0,     0,   199,   561,   562,
     563,   564,   565,   566,     0,   567,   200,   568,   201,   569,
     570,   571,     0,   572,   573,   574,   575,   576,   577,   578,
     203,   579,   580,   581,     0,   582,   583,   584,   585,   586,
     587,   588,   589,   590,   591,     0,   592,   593,     0,   594,
     595,   211,   596,   597,   598,   599,   600,   601,   602,   603,
       0,   604,   605,   606,   607,     0,   608,   215,   609,   610,
       0,   611,   218,     0,   612,   613,   614,   615,   616,   617,
     618,   619,   620,   621,   220,   622,     0,   623,   624,     0,
     625,   626,   627,   628,   629,     0,   222,   223,     0,     0,
     631,   224,   632,   225,     0,   633,   634,   635,   636,   637,
     638,     0,     0,   639,   640,   641,   642,     0,     0,   643,
     644,   645,   646,   647,   233,     0,   648,     0,   649,   650,
     651,     0,     0,   652,     0,     0,   653,   654,   655,   656,
     657,   236,   237,   238,   239,   240,   241,   242,   243,   658,
     659,   660,     0,     0,     0,    55,    86,    87,    88,   400,
      90,    91,    92,   401,     0,   402,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   403,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   404,   405,     0,     0,     0,
     406,   407,     0,     0,     0,     0,   408,     0,     0,     0,
       0,     0,     0,     0,     0,   409,     0,   410,     0,   411,
     412,     0,    35,     0,     0,     0,     0,     0,     0,     0,
      41,   414,   415,   416,   417,   418,   419,   420,   421,   833,
     422,   423,   424,     0,     0,     0,     0,     0,     0,     0,
     425,   426,     0,   427,     0,   428,   429,   430,     0,   136,
       0,   138,   139,     0,   431,   432,   433,   434,   435,     0,
       0,   436,   437,   438,   140,   439,     0,   440,   441,   442,
     443,   144,     0,     0,   444,   445,   446,   447,   448,   449,
       0,   450,   451,   452,   453,   454,   455,     0,   456,   457,
     458,     0,   459,     0,     0,     0,     0,     0,     0,     0,
       0,   460,   461,   462,   463,   464,   465,   153,   154,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,     0,   486,   487,   488,
     162,   489,   490,   164,     0,   491,     0,   492,   166,   493,
       0,   494,     0,   495,     0,     0,     0,   496,   497,     0,
     498,   170,     0,   499,     0,   500,   501,   502,   503,   504,
       0,   505,   506,   507,     0,   508,   509,   510,   511,   512,
     513,     0,     0,   173,     0,   514,   515,   516,     0,   175,
       0,   176,     0,   517,     0,     0,   518,     0,   519,   520,
     521,   522,   523,   524,   525,     0,   180,     0,   526,     0,
       0,   527,   528,   529,     0,     0,   530,   531,   532,   533,
     534,   535,   536,   537,   538,   539,   540,   541,   542,   187,
       0,   189,     0,   543,   544,   545,   546,   547,   548,   549,
     190,   550,     0,   551,   552,     0,   553,     0,   193,   554,
     194,   555,   556,     0,     0,   557,     0,     0,     0,   558,
     559,   560,     0,     0,   195,     0,     0,     0,   199,   561,
     562,   563,   564,   565,   566,     0,   567,   200,   568,   201,
     569,   570,   571,     0,   572,   573,   574,   575,   576,   577,
     578,   203,   579,   580,   581,     0,   582,   583,   584,   585,
     586,   587,   588,   589,   590,   591,     0,   592,   593,     0,
     594,   595,   211,   596,   597,   598,   599,   600,   601,   602,
     603,     0,   604,   605,   606,   607,     0,   608,   215,   609,
     610,     0,   611,   218,     0,   612,   613,   614,   615,   616,
     617,   618,   619,   620,   621,   220,   622,     0,   623,   624,
       0,   625,   626,   627,   628,   629,     0,   222,   223,     0,
       0,   631,   224,   632,   225,     0,   633,   634,   635,   636,
     637,   638,     0,     0,   639,   640,   641,   642,     0,     0,
     643,   644,   645,   646,   647,   233,     0,   648,     0,   649,
     650,   651,     0,     0,   652,     0,     0,   653,   654,   655,
     656,   657,   236,   237,   238,   239,   240,   241,   242,   243,
     658,   659,   660,     0,     0,     0,    55,    86,    87,    88,
     400,    90,    91,    92,   401,     0,   402,    95,     0,     0,
      98,    99,   100,   101,   102,   103,     0,   104,   105,   403,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   404,   405,     0,     0,
       0,   406,   407,     0,     0,     0,     0,   408,     0,     0,
       0,     0,     0,     0,     0,     0,   409,     0,   410,     0,
     411,   412,     0,    35,   413,     0,     0,     0,     0,     0,
       0,    41,   414,   415,   416,   417,   418,   419,   420,   421,
       0,   422,   423,   424,     0,     0,     0,     0,     0,     0,
       0,   425,   426,     0,   427,     0,   428,   429,   430,     0,
     136,     0,   138,   139,     0,   431,   432,   433,   434,   435,
       0,     0,   436,   437,   438,   140,   439,     0,   440,   441,
     442,   443,   144,     0,     0,   444,   445,   446,   447,   448,
     449,     0,   450,   451,   452,   453,   454,   455,     0,   456,
     457,   458,     0,   459,     0,     0,     0,     0,     0,     0,
       0,     0,   460,   461,   462,   463,   464,   465,   153,   154,
     466,     0,   467,     0,   468,   469,   470,   471,   472,     0,
     473,   474,   475,     0,     0,   476,   477,   478,   479,   480,
       0,   481,   482,   483,     0,   484,   485,     0,   486,   487,
     488,   162,   489,   490,   164,     0,   491,     0,   492,   166,
     493,     0,   494,     0,   495,     0,     0,     0,   496,   497,
       0,   498,   170,     0,   499,     0,   500,   501,   502,   503,
     504,     0,   923,   506,   507,     0,   508,   509,   510,   511,
     512,   513,     0,     0,   173,     0,   514,   515,   516,     0,
     175,     0,   176,     0,   517,     0,     0,   518,     0,   519,
     520,   521,   522,   523,   524,   525,     0,   180,     0,   526,
       0,     0,   527,   528,   529,     0,     0,   530,   531,   532,
     533,   534,   535,   536,   537,   538,   539,   540,   541,   542,
     187,     0,   189,     0,   543,   544,   545,   546,   547,   548,
     549,   190,   550,     0,   551,   552,     0,   553,     0,   193,
     554,   194,   555,   556,     0,     0,   557,     0,     0,     0,
     558,   559,   560,     0,     0,   195,     0,     0,     0,   199,
     561,   562,   563,   564,   565,   566,     0,   567,   200,   568,
     201,   569,   570,   571,     0,   572,   573,   574,   575,   576,
     577,   578,   203,   579,   580,   581,     0,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,     0,   592,   593,
       0,   594,   595,   211,   596,   597,   598,   599,   600,   601,
     602,   603,     0,   604,   605,   606,   607,     0,   608,   215,
     609,   610,     0,   611,   218,     0,   612,   613,   614,   615,
     616,   617,   618,   619,   620,   621,   220,   622,     0,   623,
     624,     0,   625,   626,   627,   628,   629,     0,   222,   223,
       0,     0,   631,   224,   632,   225,     0,   633,   634,   635,
     636,   637,   638,     0,     0,   639,   640,   641,   642,     0,
       0,   643,   644,   645,   646,   647,   233,     0,   648,     0,
     649,   650,   651,     0,     0,   652,     0,     0,   653,   654,
     655,   656,   657,   236,   237,   238,   239,   240,   241,   242,
     243,   658,   659,   660,     0,     0,     0,    55,    86,    87,
      88,   400,    90,    91,    92,   401,     0,   402,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     403,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   404,   405,     0,
       0,     0,   406,   407,     0,     0,     0,     0,   408,     0,
       0,     0,     0,     0,     0,     0,     0,   409,     0,   410,
       0,   411,   412,     0,    35,   413,     0,     0,     0,     0,
       0,     0,    41,   414,   415,   416,   417,   418,   419,   420,
     421,     0,   422,   423,   424,     0,     0,     0,     0,     0,
       0,     0,   425,   426,     0,   427,     0,   428,   429,   430,
       0,   136,     0,   138,   139,     0,   431,   432,   433,   434,
     435,     0,     0,   436,   437,   438,   140,   439,     0,   440,
     441,   442,   443,   144,     0,     0,   444,   445,   446,   447,
     448,   449,     0,   450,   451,   452,   453,   454,   455,     0,
     456,   457,   458,     0,   459,     0,     0,     0,     0,     0,
       0,     0,     0,   460,   461,   462,   463,   464,   465,   153,
     154,   466,     0,   467,     0,   468,   469,   470,   471,   472,
       0,   473,   474,   475,     0,     0,   476,   477,   478,   479,
     480,     0,   481,   482,   483,     0,   484,   485,     0,   486,
     487,   488,   162,   489,   490,   164,     0,   491,     0,   492,
     166,   493,     0,   494,     0,   495,     0,     0,     0,   496,
     497,     0,   498,   170,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,   510,
     511,   512,   513,     0,     0,   173,     0,   514,   515,   516,
       0,   175,     0,   176,     0,   517,     0,     0,   518,     0,
     519,   520,   521,   522,   523,   524,   525,     0,   180,     0,
     526,     0,     0,   527,   528,   529,     0,     0,   530,   531,
     532,   533,   534,   535,   536,   537,   538,   539,   540,   541,
     542,   187,     0,   189,     0,   543,   544,   545,   546,   547,
     548,   549,   190,   550,     0,   551,   552,     0,   553,     0,
     193,   554,   194,   555,   556,     0,     0,   557,     0,     0,
       0,   558,   559,   560,     0,     0,   195,     0,     0,     0,
     199,   561,   562,   563,   564,   565,   566,     0,   567,   200,
     568,   201,   569,   570,   571,     0,   572,   573,   574,   575,
     576,   577,   578,   203,   579,   580,   581,     0,   582,   583,
     584,   585,   586,   587,   588,   589,   590,   591,     0,   592,
     593,     0,   594,   595,   211,   596,   597,   598,   599,   600,
     601,   602,   603,     0,   604,   605,   606,   607,     0,   608,
     215,   609,   610,     0,   611,   218,     0,   612,   613,   614,
     615,   616,   617,   618,   619,   620,   621,   220,   622,     0,
     623,   624,     0,   625,   626,   627,   628,   629,     0,   222,
     223,     0,     0,   963,   224,   632,   225,     0,   633,   634,
     635,   636,   637,   638,     0,     0,   639,   640,   641,   642,
       0,     0,   643,   644,   645,   646,   647,   233,     0,   648,
       0,   649,   650,   651,     0,     0,   652,     0,     0,   653,
     654,   655,   656,   657,   236,   237,   238,   239,   240,   241,
     242,   243,   658,   659,   660,     0,     0,     0,    55,    86,
      87,    88,   400,    90,    91,    92,   401,     0,   402,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   403,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   404,   405,
       0,     0,     0,   406,   407,     0,     0,     0,     0,   408,
       0,     0,     0,     0,     0,     0,     0,     0,   409,     0,
     410,     0,   411,   412,     0,    35,   413,     0,     0,     0,
       0,     0,     0,    41,   414,   415,   416,   417,   418,   419,
     420,   421,     0,   422,   423,   424,     0,     0,     0,     0,
       0,     0,     0,   425,   426,     0,   427,     0,   428,   429,
     430,     0,   136,     0,   138,   139,     0,   431,   432,   433,
     434,   435,     0,     0,   436,   437,   438,   140,   439,     0,
     440,   441,   442,   443,   144,     0,     0,   444,   445,   446,
     447,   448,   449,     0,   450,   451,   452,   453,   454,   455,
       0,   456,   457,   458,     0,   459,     0,     0,     0,     0,
       0,     0,     0,     0,   460,   461,   462,   463,   464,   465,
     153,   154,   466,     0,   467,     0,   468,   469,   470,   471,
     472,     0,   473,   474,   475,     0,     0,   476,   477,   478,
     479,   480,     0,   481,   482,   483,     0,   484,   485,     0,
     486,   487,   488,   162,   489,   490,   164,     0,   491,     0,
     492,   166,   493,     0,   494,     0,   495,     0,     0,     0,
     496,   497,     0,   498,   170,     0,   499,     0,   500,   501,
     502,   503,   504,     0,   505,   506,   507,     0,   508,   509,
     510,   511,   512,   513,     0,     0,   173,     0,   514,   515,
     516,     0,   175,     0,   176,     0,   517,     0,     0,   518,
       0,   519,   520,   521,   522,   523,   524,   525,     0,   180,
       0,   526,     0,     0,   527,   528,   529,     0,     0,   530,
     531,   532,   533,   534,   535,   536,   537,   538,   539,   540,
     541,   542,   187,     0,   189,     0,   543,   544,   545,   546,
     547,   548,   549,   190,   550,     0,   551,   552,     0,   553,
       0,   193,   554,   194,   555,   556,     0,     0,   557,     0,
       0,     0,   558,   559,   560,     0,     0,   195,     0,     0,
       0,   199,   561,   562,   563,   564,   565,   566,     0,   567,
     200,   568,   201,   569,   570,   571,     0,   572,   573,   574,
     575,   576,   577,   578,   203,   579,   580,   581,     0,   582,
     583,   584,   585,   586,   587,   588,   589,   590,   591,     0,
     592,   593,     0,   594,   595,   211,   596,   597,   598,   599,
     600,   601,   602,   603,     0,   604,   605,   606,   607,     0,
     608,   215,   609,   610,     0,   611,   218,     0,   612,   613,
     614,   615,   616,   617,   618,   619,   620,   621,   220,   622,
       0,   623,   624,     0,   625,   626,   627,   628,   629,     0,
     222,   223,     0,     0,   631,   224,   632,   225,     0,   633,
     634,   635,   636,   637,   638,     0,     0,   639,   640,   641,
     642,     0,     0,   643,   644,   645,   646,   647,   233,     0,
     648,     0,   649,   650,   651,     0,     0,   652,     0,     0,
     653,   654,   655,   656,   657,   236,   237,   238,   239,   240,
     241,   242,   243,   658,   659,   660,     0,     0,     0,    55,
      86,    87,    88,   400,    90,    91,    92,   401,     0,   402,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   403,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   404,
     405,     0,     0,     0,   406,   407,     0,     0,     0,     0,
     408,     0,     0,     0,     0,     0,     0,     0,     0,   409,
       0,   410,     0,   411,   412,     0,    35,     0,     0,  1791,
       0,     0,     0,     0,    41,   414,   415,   416,   417,   418,
     419,   420,   421,     0,   422,   423,   424,     0,     0,     0,
       0,     0,     0,     0,   425,   426,     0,   427,     0,   428,
     429,   430,     0,   136,     0,   138,   139,     0,   431,   432,
     433,   434,   435,     0,     0,   436,   437,   438,   140,   439,
       0,   440,   441,   442,   443,   144,     0,     0,   444,   445,
     446,   447,   448,   449,     0,   450,   451,   452,   453,   454,
     455,     0,   456,   457,   458,     0,   459,     0,     0,     0,
       0,     0,     0,     0,     0,   460,   461,   462,   463,   464,
     465,   153,   154,   466,     0,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
     478,   479,   480,     0,   481,   482,   483,     0,   484,   485,
       0,   486,   487,   488,   162,   489,   490,   164,     0,   491,
       0,   492,   166,   493,     0,   494,     0,   495,     0,     0,
       0,   496,   497,     0,   498,   170,     0,   499,     0,   500,
     501,   502,   503,   504,     0,   505,   506,   507,     0,   508,
     509,   510,   511,   512,   513,     0,     0,   173,     0,   514,
     515,   516,     0,   175,     0,   176,     0,   517,     0,     0,
     518,     0,   519,   520,   521,   522,   523,   524,   525,     0,
     180,     0,   526,     0,     0,   527,   528,   529,     0,     0,
     530,   531,   532,   533,   534,   535,   536,   537,   538,   539,
     540,   541,   542,   187,     0,   189,     0,   543,   544,   545,
     546,   547,   548,   549,   190,   550,     0,   551,   552,     0,
     553,     0,   193,   554,   194,   555,   556,     0,     0,   557,
       0,     0,     0,   558,   559,   560,     0,     0,   195,     0,
       0,     0,   199,   561,   562,   563,   564,   565,   566,     0,
     567,   200,   568,   201,   569,   570,   571,     0,   572,   573,
     574,   575,   576,   577,   578,   203,   579,   580,   581,     0,
     582,   583,   584,   585,   586,   587,   588,   589,   590,   591,
       0,   592,   593,     0,   594,   595,   211,   596,   597,   598,
     599,   600,   601,   602,   603,     0,   604,   605,   606,   607,
       0,   608,   215,   609,   610,     0,   611,   218,     0,   612,
     613,   614,   615,   616,   617,   618,   619,   620,   621,   220,
     622,     0,   623,   624,     0,   625,   626,   627,   628,   629,
       0,   222,   223,     0,     0,   631,   224,   632,   225,     0,
     633,   634,   635,   636,   637,   638,     0,     0,   639,   640,
     641,   642,     0,     0,   643,   644,   645,   646,   647,   233,
       0,   648,     0,   649,   650,   651,     0,     0,   652,     0,
       0,   653,   654,   655,   656,   657,   236,   237,   238,   239,
     240,   241,   242,   243,   658,   659,   660,     0,     0,     0,
      55,    86,    87,    88,   400,    90,    91,    92,   401,     0,
     402,    95,     0,     0,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   403,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     404,   405,     0,     0,     0,   406,   407,     0,     0,     0,
       0,   408,     0,     0,     0,     0,     0,     0,     0,     0,
     409,     0,   410,     0,   411,   412,     0,    35,     0,     0,
       0,     0,     0,     0,     0,    41,   414,   415,   416,   417,
     418,   419,   420,   421,     0,   422,   423,   424,     0,     0,
       0,     0,     0,  2980,     0,   425,   426,     0,   427,     0,
     428,   429,   430,     0,   136,     0,   138,   139,     0,   431,
     432,   433,   434,   435,     0,     0,   436,   437,   438,   140,
     439,     0,   440,   441,   442,   443,   144,     0,     0,   444,
     445,   446,   447,   448,   449,     0,   450,   451,   452,   453,
     454,   455,     0,   456,   457,   458,     0,   459,     0,     0,
       0,     0,     0,     0,     0,     0,   460,   461,   462,   463,
     464,   465,   153,   154,   466,     0,   467,     0,   468,   469,
     470,   471,   472,     0,   473,   474,   475,     0,     0,   476,
     477,   478,   479,   480,     0,   481,   482,   483,     0,   484,
     485,     0,   486,   487,   488,   162,   489,   490,   164,     0,
     491,     0,   492,   166,   493,     0,   494,     0,   495,     0,
       0,     0,   496,   497,     0,   498,   170,     0,   499,     0,
     500,   501,   502,   503,   504,     0,   505,   506,   507,     0,
     508,   509,   510,   511,   512,   513,     0,     0,   173,     0,
     514,   515,   516,     0,   175,     0,   176,     0,   517,     0,
       0,   518,     0,   519,   520,   521,   522,   523,   524,   525,
       0,   180,     0,   526,     0,     0,   527,   528,   529,     0,
       0,   530,   531,   532,   533,   534,   535,   536,   537,   538,
     539,   540,   541,   542,   187,     0,   189,     0,   543,   544,
     545,   546,   547,   548,   549,   190,   550,     0,   551,   552,
       0,   553,     0,   193,   554,   194,   555,   556,     0,     0,
     557,     0,     0,     0,   558,   559,   560,     0,     0,   195,
       0,     0,     0,   199,   561,   562,   563,   564,   565,   566,
       0,   567,   200,   568,   201,   569,   570,   571,     0,   572,
     573,   574,   575,   576,   577,   578,   203,   579,   580,   581,
       0,   582,   583,   584,   585,   586,   587,   588,   589,   590,
     591,     0,   592,   593,     0,   594,   595,   211,   596,   597,
     598,   599,   600,   601,   602,   603,     0,   604,   605,   606,
     607,     0,   608,   215,   609,   610,     0,   611,   218,     0,
     612,   613,   614,   615,   616,   617,   618,   619,   620,   621,
     220,   622,     0,   623,   624,     0,   625,   626,   627,   628,
     629,     0,   222,   223,     0,     0,   631,   224,   632,   225,
       0,   633,   634,   635,   636,   637,   638,     0,     0,   639,
     640,   641,   642,     0,     0,   643,   644,   645,   646,   647,
     233,     0,   648,     0,   649,   650,   651,     0,     0,   652,
       0,     0,   653,   654,   655,   656,   657,   236,   237,   238,
     239,   240,   241,   242,   243,   658,   659,   660,     0,     0,
       0,    55,    86,    87,    88,   400,    90,    91,    92,   401,
       0,   402,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   403,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   404,   405,     0,     0,     0,   406,   407,     0,     0,
       0,     0,   408,     0,     0,     0,     0,     0,     0,     0,
       0,   409,     0,   410,     0,   411,   412,     0,    35,     0,
       0,     0,     0,     0,     0,     0,    41,   414,   415,   416,
     417,   418,   419,   420,   421,     0,   422,   423,   424,     0,
       0,     0,     0,     0,  2993,     0,   425,   426,     0,   427,
       0,   428,   429,   430,     0,   136,     0,   138,   139,     0,
     431,   432,   433,   434,   435,     0,     0,   436,   437,   438,
     140,   439,     0,   440,   441,   442,   443,   144,     0,     0,
     444,   445,   446,   447,   448,   449,     0,   450,   451,   452,
     453,   454,   455,     0,   456,   457,   458,     0,   459,     0,
       0,     0,     0,     0,     0,     0,     0,   460,   461,   462,
     463,   464,   465,   153,   154,   466,     0,   467,     0,   468,
     469,   470,   471,   472,     0,   473,   474,   475,     0,     0,
     476,   477,   478,   479,   480,     0,   481,   482,   483,     0,
     484,   485,     0,   486,   487,   488,   162,   489,   490,   164,
       0,   491,     0,   492,   166,   493,     0,   494,     0,   495,
       0,     0,     0,   496,   497,     0,   498,   170,     0,   499,
       0,   500,   501,   502,   503,   504,     0,   505,   506,   507,
       0,   508,   509,   510,   511,   512,   513,     0,     0,   173,
       0,   514,   515,   516,     0,   175,     0,   176,     0,   517,
       0,     0,   518,     0,   519,   520,   521,   522,   523,   524,
     525,     0,   180,     0,   526,     0,     0,   527,   528,   529,
       0,     0,   530,   531,   532,   533,   534,   535,   536,   537,
     538,   539,   540,   541,   542,   187,     0,   189,     0,   543,
     544,   545,   546,   547,   548,   549,   190,   550,     0,   551,
     552,     0,   553,     0,   193,   554,   194,   555,   556,     0,
       0,   557,     0,     0,     0,   558,   559,   560,     0,     0,
     195,     0,     0,     0,   199,   561,   562,   563,   564,   565,
     566,     0,   567,   200,   568,   201,   569,   570,   571,     0,
     572,   573,   574,   575,   576,   577,   578,   203,   579,   580,
     581,     0,   582,   583,   584,   585,   586,   587,   588,   589,
     590,   591,     0,   592,   593,     0,   594,   595,   211,   596,
     597,   598,   599,   600,   601,   602,   603,     0,   604,   605,
     606,   607,     0,   608,   215,   609,   610,     0,   611,   218,
       0,   612,   613,   614,   615,   616,   617,   618,   619,   620,
     621,   220,   622,     0,   623,   624,     0,   625,   626,   627,
     628,   629,     0,   222,   223,     0,     0,   631,   224,   632,
     225,     0,   633,   634,   635,   636,   637,   638,     0,     0,
     639,   640,   641,   642,     0,     0,   643,   644,   645,   646,
     647,   233,     0,   648,     0,   649,   650,   651,     0,     0,
     652,     0,     0,   653,   654,   655,   656,   657,   236,   237,
     238,   239,   240,   241,   242,   243,   658,   659,   660,     0,
       0,     0,    55,    86,    87,    88,   400,    90,    91,    92,
     401,     0,   402,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,   403,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,   404,   405,     0,     0,     0,   406,   407,     0,
       0,     0,     0,   408,     0,     0,     0,     0,     0,     0,
       0,     0,   409,     0,   410,     0,   411,   412,     0,    35,
       0,     0,     0,     0,     0,     0,     0,    41,   414,   415,
     416,   417,   418,   419,   420,   421,     0,   422,   423,   424,
       0,     0,     0,     0,     0,     0,     0,   425,   426,     0,
     427,     0,   428,   429,   430,     0,   136,     0,   138,   139,
       0,   431,   432,   433,   434,   435,     0,     0,   436,   437,
     438,   140,   439,     0,   440,   441,   442,   443,   144,     0,
       0,   444,   445,   446,   447,   448,   449,     0,   450,   451,
     452,   453,   454,   455,     0,   456,   457,   458,     0,   459,
       0,     0,     0,     0,     0,     0,     0,     0,   460,   461,
     462,   463,   464,   465,   153,   154,   466,     0,   467,     0,
     468,   469,   470,   471,   472,     0,   473,   474,   475,     0,
       0,   476,   477,   478,   479,   480,     0,   481,   482,   483,
       0,   484,   485,     0,   486,   487,   488,   162,   489,   490,
     164,     0,   491,     0,   492,   166,   493,     0,   494,     0,
     495,     0,     0,     0,   496,   497,     0,   498,   170,  3030,
     499,     0,   500,   501,   502,   503,   504,     0,   505,   506,
     507,     0,   508,   509,   510,   511,   512,   513,     0,     0,
     173,     0,   514,   515,   516,     0,   175,     0,   176,     0,
     517,     0,     0,   518,     0,   519,   520,   521,   522,   523,
     524,   525,     0,   180,     0,   526,     0,     0,   527,   528,
     529,     0,     0,   530,   531,   532,   533,   534,   535,   536,
     537,   538,   539,   540,   541,   542,   187,     0,   189,     0,
     543,   544,   545,   546,   547,   548,   549,   190,   550,     0,
     551,   552,     0,   553,     0,   193,   554,   194,   555,   556,
       0,     0,   557,     0,     0,     0,   558,   559,   560,     0,
       0,   195,     0,     0,     0,   199,   561,   562,   563,   564,
     565,   566,     0,   567,   200,   568,   201,   569,   570,   571,
       0,   572,   573,   574,   575,   576,   577,   578,   203,   579,
     580,   581,     0,   582,   583,   584,   585,   586,   587,   588,
     589,   590,   591,     0,   592,   593,     0,   594,   595,   211,
     596,   597,   598,   599,   600,   601,   602,   603,     0,   604,
     605,   606,   607,     0,   608,   215,   609,   610,     0,   611,
     218,     0,   612,   613,   614,   615,   616,   617,   618,   619,
     620,   621,   220,   622,     0,   623,   624,     0,   625,   626,
     627,   628,   629,     0,   222,   223,     0,     0,   631,   224,
     632,   225,     0,   633,   634,   635,   636,   637,   638,     0,
       0,   639,   640,   641,   642,     0,     0,   643,   644,   645,
     646,   647,   233,     0,   648,     0,   649,   650,   651,     0,
       0,   652,     0,     0,   653,   654,   655,   656,   657,   236,
     237,   238,   239,   240,   241,   242,   243,   658,   659,   660,
       0,     0,     0,    55,    86,    87,    88,   400,    90,    91,
      92,   401,     0,   402,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   403,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   404,   405,     0,     0,     0,   406,   407,
       0,     0,     0,     0,   408,     0,     0,     0,     0,     0,
       0,     0,     0,   409,     0,   410,     0,   411,   412,     0,
      35,     0,     0,     0,     0,     0,     0,     0,    41,   414,
     415,   416,   417,   418,   419,   420,   421,     0,   422,   423,
     424,     0,     0,     0,     0,     0,     0,     0,   425,   426,
       0,   427,     0,   428,   429,   430,     0,   136,     0,   138,
     139,     0,   431,   432,   433,   434,   435,     0,     0,   436,
     437,   438,   140,   439,     0,   440,   441,   442,   443,   144,
       0,     0,   444,   445,   446,   447,   448,   449,     0,   450,
     451,   452,   453,   454,   455,     0,   456,   457,   458,     0,
     459,     0,     0,     0,     0,     0,     0,     0,     0,   460,
     461,   462,   463,   464,   465,   153,   154,   466,  3694,   467,
       0,   468,   469,   470,   471,   472,     0,   473,   474,   475,
       0,     0,   476,   477,   478,   479,   480,     0,   481,   482,
     483,     0,   484,   485,     0,   486,   487,   488,   162,   489,
     490,   164,     0,   491,     0,   492,   166,   493,     0,   494,
       0,   495,     0,     0,     0,   496,   497,     0,   498,   170,
       0,   499,     0,   500,   501,   502,   503,   504,     0,   505,
     506,   507,     0,   508,   509,   510,   511,   512,   513,     0,
       0,   173,     0,   514,   515,   516,     0,   175,     0,   176,
       0,   517,     0,     0,   518,     0,   519,   520,   521,   522,
     523,   524,   525,     0,   180,     0,   526,     0,     0,   527,
     528,   529,     0,     0,   530,   531,   532,   533,   534,   535,
     536,   537,   538,   539,   540,   541,   542,   187,     0,   189,
       0,   543,   544,   545,   546,   547,   548,   549,   190,   550,
       0,   551,   552,     0,   553,     0,   193,   554,   194,   555,
     556,     0,     0,   557,     0,     0,     0,   558,   559,   560,
       0,     0,   195,     0,     0,     0,   199,   561,   562,   563,
     564,   565,   566,     0,   567,   200,   568,   201,   569,   570,
     571,     0,   572,   573,   574,   575,   576,   577,   578,   203,
     579,   580,   581,     0,   582,   583,   584,   585,   586,   587,
     588,   589,   590,   591,     0,   592,   593,     0,   594,   595,
     211,   596,   597,   598,   599,   600,   601,   602,   603,     0,
     604,   605,   606,   607,     0,   608,   215,   609,   610,     0,
     611,   218,     0,   612,   613,   614,   615,   616,   617,   618,
     619,   620,   621,   220,   622,     0,   623,   624,     0,   625,
     626,   627,   628,   629,     0,   222,   223,     0,     0,   631,
     224,   632,   225,     0,   633,   634,   635,   636,   637,   638,
       0,     0,   639,   640,   641,   642,     0,     0,   643,   644,
     645,   646,   647,   233,     0,   648,     0,   649,   650,   651,
       0,     0,   652,     0,     0,   653,   654,   655,   656,   657,
     236,   237,   238,   239,   240,   241,   242,   243,   658,   659,
     660,     0,     0,     0,    55,    86,    87,    88,   400,    90,
      91,    92,   401,     0,   402,    95,     0,     0,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   403,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   404,   405,     0,     0,     0,   406,
     407,     0,     0,     0,     0,   408,     0,     0,     0,     0,
       0,     0,     0,     0,   409,     0,   410,     0,   411,   412,
       0,    35,     0,     0,     0,     0,     0,     0,     0,    41,
     414,   415,   416,   417,   418,   419,   420,   421,     0,   422,
     423,   424,     0,     0,     0,     0,     0,     0,     0,   425,
     426,     0,   427,     0,   428,   429,   430,     0,   136,     0,
     138,   139,     0,   431,   432,   433,   434,   435,     0,     0,
     436,   437,   438,   140,   439,     0,   440,   441,   442,   443,
     144,     0,     0,   444,   445,   446,   447,   448,   449,     0,
     450,   451,   452,   453,   454,   455,     0,   456,   457,   458,
       0,   459,     0,     0,     0,     0,     0,     0,     0,     0,
     460,   461,   462,   463,   464,   465,   153,   154,   466,  3696,
     467,     0,   468,   469,   470,   471,   472,     0,   473,   474,
     475,     0,     0,   476,   477,   478,   479,   480,     0,   481,
     482,   483,     0,   484,   485,     0,   486,   487,   488,   162,
     489,   490,   164,     0,   491,     0,   492,   166,   493,     0,
     494,     0,   495,     0,     0,     0,   496,   497,     0,   498,
     170,     0,   499,     0,   500,   501,   502,   503,   504,     0,
     505,   506,   507,     0,   508,   509,   510,   511,   512,   513,
       0,     0,   173,     0,   514,   515,   516,     0,   175,     0,
     176,     0,   517,     0,     0,   518,     0,   519,   520,   521,
     522,   523,   524,   525,     0,   180,     0,   526,     0,     0,
     527,   528,   529,     0,     0,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   187,     0,
     189,     0,   543,   544,   545,   546,   547,   548,   549,   190,
     550,     0,   551,   552,     0,   553,     0,   193,   554,   194,
     555,   556,     0,     0,   557,     0,     0,     0,   558,   559,
     560,     0,     0,   195,     0,     0,     0,   199,   561,   562,
     563,   564,   565,   566,     0,   567,   200,   568,   201,   569,
     570,   571,     0,   572,   573,   574,   575,   576,   577,   578,
     203,   579,   580,   581,     0,   582,   583,   584,   585,   586,
     587,   588,   589,   590,   591,     0,   592,   593,     0,   594,
     595,   211,   596,   597,   598,   599,   600,   601,   602,   603,
       0,   604,   605,   606,   607,     0,   608,   215,   609,   610,
       0,   611,   218,     0,   612,   613,   614,   615,   616,   617,
     618,   619,   620,   621,   220,   622,     0,   623,   624,     0,
     625,   626,   627,   628,   629,     0,   222,   223,     0,     0,
     631,   224,   632,   225,     0,   633,   634,   635,   636,   637,
     638,     0,     0,   639,   640,   641,   642,     0,     0,   643,
     644,   645,   646,   647,   233,     0,   648,     0,   649,   650,
     651,     0,     0,   652,     0,     0,   653,   654,   655,   656,
     657,   236,   237,   238,   239,   240,   241,   242,   243,   658,
     659,   660,     0,     0,     0,    55,    86,    87,    88,   400,
      90,    91,    92,   401,     0,   402,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   403,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   404,   405,     0,     0,     0,
     406,   407,     0,     0,     0,     0,   408,     0,     0,     0,
       0,     0,     0,     0,     0,   409,     0,   410,     0,   411,
     412,     0,    35,     0,     0,     0,     0,     0,     0,     0,
      41,   414,   415,   416,   417,   418,   419,   420,   421,     0,
     422,   423,   424,     0,     0,     0,     0,     0,     0,     0,
     425,   426,     0,   427,     0,   428,   429,   430,     0,   136,
       0,   138,   139,     0,   431,   432,   433,   434,   435,     0,
       0,   436,   437,   438,   140,   439,     0,   440,   441,   442,
     443,   144,     0,     0,   444,   445,   446,   447,   448,   449,
       0,   450,   451,   452,   453,   454,   455,     0,   456,   457,
     458,     0,   459,     0,     0,     0,     0,     0,     0,     0,
       0,   460,   461,   462,   463,   464,   465,   153,   154,   466,
    3698,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,     0,   486,   487,   488,
     162,   489,   490,   164,     0,   491,     0,   492,   166,   493,
       0,   494,     0,   495,     0,     0,     0,   496,   497,     0,
     498,   170,     0,   499,     0,   500,   501,   502,   503,   504,
       0,   505,   506,   507,     0,   508,   509,   510,   511,   512,
     513,     0,     0,   173,     0,   514,   515,   516,     0,   175,
       0,   176,     0,   517,     0,     0,   518,     0,   519,   520,
     521,   522,   523,   524,   525,     0,   180,     0,   526,     0,
       0,   527,   528,   529,     0,     0,   530,   531,   532,   533,
     534,   535,   536,   537,   538,   539,   540,   541,   542,   187,
       0,   189,     0,   543,   544,   545,   546,   547,   548,   549,
     190,   550,     0,   551,   552,     0,   553,     0,   193,   554,
     194,   555,   556,     0,     0,   557,     0,     0,     0,   558,
     559,   560,     0,     0,   195,     0,     0,     0,   199,   561,
     562,   563,   564,   565,   566,     0,   567,   200,   568,   201,
     569,   570,   571,     0,   572,   573,   574,   575,   576,   577,
     578,   203,   579,   580,   581,     0,   582,   583,   584,   585,
     586,   587,   588,   589,   590,   591,     0,   592,   593,     0,
     594,   595,   211,   596,   597,   598,   599,   600,   601,   602,
     603,     0,   604,   605,   606,   607,     0,   608,   215,   609,
     610,     0,   611,   218,     0,   612,   613,   614,   615,   616,
     617,   618,   619,   620,   621,   220,   622,     0,   623,   624,
       0,   625,   626,   627,   628,   629,     0,   222,   223,     0,
       0,   631,   224,   632,   225,     0,   633,   634,   635,   636,
     637,   638,     0,     0,   639,   640,   641,   642,     0,     0,
     643,   644,   645,   646,   647,   233,     0,   648,     0,   649,
     650,   651,     0,     0,   652,     0,     0,   653,   654,   655,
     656,   657,   236,   237,   238,   239,   240,   241,   242,   243,
     658,   659,   660,     0,     0,     0,    55,    86,    87,    88,
     400,    90,    91,    92,   401,     0,   402,    95,     0,     0,
      98,    99,   100,   101,   102,   103,     0,   104,   105,   403,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   404,   405,     0,     0,
       0,   406,   407,     0,     0,     0,     0,   408,     0,     0,
       0,     0,     0,     0,     0,     0,   409,     0,   410,     0,
     411,   412,     0,    35,     0,     0,     0,     0,     0,     0,
       0,    41,   414,   415,   416,   417,   418,   419,   420,   421,
       0,   422,   423,   424,     0,     0,     0,     0,     0,     0,
       0,   425,   426,     0,   427,     0,   428,   429,   430,     0,
     136,     0,   138,   139,     0,   431,   432,   433,   434,   435,
       0,     0,   436,   437,   438,   140,   439,     0,   440,   441,
     442,   443,   144,     0,     0,   444,   445,   446,   447,   448,
     449,     0,   450,   451,   452,   453,   454,   455,     0,   456,
     457,   458,     0,   459,     0,     0,     0,     0,     0,     0,
       0,     0,   460,   461,   462,   463,   464,   465,   153,   154,
     466,     0,   467,     0,   468,   469,   470,   471,   472,     0,
     473,   474,   475,     0,     0,   476,   477,   478,   479,   480,
       0,   481,   482,   483,     0,   484,   485,     0,   486,   487,
     488,   162,   489,   490,   164,     0,   491,     0,   492,   166,
     493,     0,   494,     0,   495,     0,     0,     0,   496,   497,
       0,   498,   170,     0,   499,     0,   500,   501,   502,   503,
     504,     0,   505,   506,   507,     0,   508,   509,   510,   511,
     512,   513,     0,     0,   173,     0,   514,   515,   516,     0,
     175,     0,   176,     0,   517,     0,     0,   518,     0,   519,
     520,   521,   522,   523,   524,   525,     0,   180,     0,   526,
       0,     0,   527,   528,   529,     0,     0,   530,   531,   532,
     533,   534,   535,   536,   537,   538,   539,   540,   541,   542,
     187,     0,   189,     0,   543,   544,   545,   546,   547,   548,
     549,   190,   550,     0,   551,   552,     0,   553,     0,   193,
     554,   194,   555,   556,     0,     0,   557,     0,     0,     0,
     558,   559,   560,     0,     0,   195,     0,     0,     0,   199,
     561,   562,   563,   564,   565,   566,     0,   567,   200,   568,
     201,   569,   570,   571,     0,   572,   573,   574,   575,   576,
     577,   578,   203,   579,   580,   581,     0,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,     0,   592,   593,
       0,   594,   595,   211,   596,   597,   598,   599,   600,   601,
     602,   603,     0,   604,   605,   606,   607,     0,   608,   215,
     609,   610,     0,   611,   218,     0,   612,   613,   614,   615,
     616,   617,   618,   619,   620,   621,   220,   622,     0,   623,
     624,     0,   625,   626,   627,   628,   629,     0,   222,   223,
       0,     0,   631,   224,   632,   225,     0,   633,   634,   635,
     636,   637,   638,     0,     0,   639,   640,   641,   642,     0,
    4059,   643,   644,   645,   646,   647,   233,     0,   648,     0,
     649,   650,   651,     0,     0,   652,     0,     0,   653,   654,
     655,   656,   657,   236,   237,   238,   239,   240,   241,   242,
     243,   658,   659,   660,     0,     0,     0,    55,    86,    87,
      88,   400,    90,    91,    92,   401,     0,   402,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     403,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   404,   405,     0,
       0,     0,   406,   407,     0,     0,     0,     0,   408,     0,
       0,     0,     0,     0,     0,     0,     0,   409,     0,   410,
       0,   411,   412,     0,    35,     0,     0,     0,     0,     0,
       0,     0,    41,   414,   415,   416,   417,   418,   419,   420,
     421,     0,   422,   423,   424,     0,     0,     0,     0,     0,
       0,     0,   425,   426,     0,   427,     0,   428,   429,   430,
       0,   136,     0,   138,   139,     0,   431,   432,   433,   434,
     435,     0,     0,   436,   437,   438,   140,   439,     0,   440,
     441,   442,   443,   144,     0,     0,   444,   445,   446,   447,
     448,   449,     0,   450,   451,   452,   453,   454,   455,     0,
     456,   457,   458,     0,   459,     0,     0,     0,     0,     0,
       0,     0,     0,   460,   461,   462,   463,   464,   465,   153,
     154,   466,     0,   467,     0,   468,   469,   470,   471,   472,
       0,   473,   474,   475,     0,     0,   476,   477,   478,   479,
     480,     0,   481,   482,   483,     0,   484,   485,     0,   486,
     487,   488,   162,   489,   490,   164,     0,   491,     0,   492,
     166,   493,     0,   494,     0,   495,     0,     0,     0,   496,
     497,     0,   498,   170,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,   510,
     511,   512,   513,     0,     0,   173,     0,   514,   515,   516,
       0,   175,     0,   176,     0,   517,     0,     0,   518,     0,
     519,   520,   521,   522,   523,   524,   525,     0,   180,     0,
     526,     0,     0,   527,   528,   529,     0,     0,   530,   531,
     532,   533,   534,   535,   536,   537,   538,   539,   540,   541,
     542,   187,     0,   189,     0,   543,   544,   545,   546,   547,
     548,   549,   190,   550,     0,   551,   552,     0,   553,     0,
     193,   554,   194,   555,   556,     0,     0,   557,     0,     0,
       0,   558,   559,   560,     0,     0,   195,     0,     0,     0,
     199,   561,   562,   563,   564,   565,   566,     0,   567,   200,
     568,   201,   569,   570,   571,     0,   572,   573,   574,   575,
     576,   577,   578,   203,   579,   580,   581,     0,   582,   583,
     584,   585,   586,   587,   588,   589,   590,   591,     0,   592,
     593,     0,   594,   595,   211,   596,   597,   598,   599,   600,
     601,   602,   603,     0,   604,   605,   606,   607,     0,   608,
     215,   609,   610,     0,   611,   218,     0,   612,   613,   614,
     615,   616,   617,   618,   619,   620,   621,   220,   622,     0,
     623,   624,     0,   625,   626,   627,   628,   629,     0,   222,
     223,     0,     0,   631,   224,   632,   225,     0,   633,   634,
     635,   636,   637,   638,     0,     0,   639,   640,   641,   642,
       0,     0,   643,   644,   645,   646,   647,   233,     0,   648,
       0,   649,   650,   651,     0,     0,   652,     0,     0,   653,
     654,   655,   656,   657,   236,   237,   238,   239,   240,   241,
     242,   243,   658,   659,   660,     0,     0,     0,    55,    86,
      87,    88,   400,    90,    91,    92,   401,     0,   402,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   403,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   404,   405,
       0,     0,     0,   406,   407,     0,     0,     0,     0,   408,
       0,     0,     0,     0,     0,     0,     0,     0,   409,     0,
     410,     0,   411,   412,     0,    35,     0,     0,     0,     0,
       0,     0,     0,    41,   414,   415,   416,   417,   418,   419,
     420,   421,     0,   422,   423,   424,     0,     0,     0,     0,
       0,     0,     0,   425,   426,     0,   427,     0,   428,   429,
     430,     0,   136,     0,   138,   139,     0,   431,   432,   433,
     434,   435,     0,     0,   436,   437,   438,   140,   439,     0,
     440,   441,   442,   443,   144,     0,     0,   444,   445,   446,
     447,   448,   449,     0,   450,   451,   452,   453,   454,   455,
       0,   456,   457,   458,     0,   459,     0,     0,     0,     0,
       0,     0,     0,     0,   460,   461,   462,   463,   464,   465,
     153,   154,   466,     0,   467,     0,   468,   469,   470,   471,
     472,     0,   473,   474,   475,     0,     0,   476,   477,   478,
     479,   480,     0,   481,   482,   483,     0,   484,   485,     0,
     486,   487,   488,   162,   489,   490,   164,     0,   491,     0,
     492,   166,   493,     0,   494,     0,   495,     0,     0,     0,
     496,   497,     0,   498,   170,     0,   499,     0,   500,   501,
     502,   503,   504,     0,   505,   506,   507,     0,   508,   509,
     510,   511,   512,   513,     0,     0,   173,     0,   514,   515,
     516,     0,   175,     0,   176,     0,   517,     0,     0,   518,
       0,   519,   520,   521,   522,   523,   524,   525,     0,   180,
       0,   526,     0,     0,   527,   528,   529,     0,     0,   530,
     531,   532,   533,   534,   535,   536,   537,   538,   539,   540,
     541,   542,   187,     0,   189,     0,   543,   544,   545,   546,
     547,   548,   549,   190,   550,     0,   551,   552,     0,   553,
       0,   193,   554,   194,   555,   556,     0,     0,   557,     0,
       0,     0,   558,   559,   560,     0,     0,   195,     0,     0,
       0,   199,   561,   562,   563,   564,   565,   566,     0,   567,
     200,   568,   201,   569,   570,   571,     0,   572,   573,   574,
     575,   576,   577,   578,   203,   579,   580,   581,     0,   582,
     583,   584,   585,   586,   587,   588,   589,   590,   591,     0,
     592,   593,     0,   594,   595,   211,   596,   597,   598,   599,
     600,   601,   602,   603,     0,   604,   605,   606,   607,     0,
     608,   215,   609,   610,     0,   611,   218,     0,   612,   613,
     614,   886,   616,   617,   618,   619,   620,   621,   220,   622,
       0,   623,   624,     0,   625,   626,   627,   628,   629,     0,
     222,   223,     0,     0,   631,   224,   632,   225,     0,   633,
     634,   635,   636,   637,   638,     0,     0,   639,   640,   641,
     642,     0,     0,   643,   644,   645,   646,   647,   233,     0,
     648,     0,   649,   650,   651,     0,     0,   652,     0,     0,
     653,   654,   655,   656,   657,   236,   237,   238,   239,   240,
     241,   242,   243,   658,   659,   660,     0,     0,     0,    55,
      86,    87,    88,   400,    90,    91,    92,   401,     0,   402,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   403,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   404,
     405,     0,     0,     0,   406,   407,     0,     0,     0,     0,
     408,     0,     0,     0,     0,     0,     0,     0,     0,   409,
       0,   410,     0,   411,   412,     0,    35,     0,     0,     0,
       0,     0,     0,     0,    41,   414,   415,   416,   417,   418,
     419,   420,   421,     0,   422,   423,   424,     0,     0,     0,
       0,     0,     0,     0,   425,   426,     0,   427,     0,   428,
     429,   430,     0,   136,     0,   138,   139,     0,   431,   432,
     433,   434,   435,     0,     0,   436,   437,   438,   140,   439,
       0,   440,   441,   442,   443,   144,     0,     0,   444,   445,
     446,   447,   448,   449,     0,   450,   451,   452,   453,   454,
     455,     0,   456,   457,   458,     0,   459,     0,     0,     0,
       0,     0,     0,     0,     0,   460,   461,   462,   463,   464,
     465,   153,   154,   466,     0,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
     478,   479,   480,     0,   481,   482,   483,     0,   484,   485,
       0,   486,   487,   488,   162,   489,   490,   164,     0,   491,
       0,   492,   166,   493,     0,   494,     0,   495,     0,     0,
       0,   496,   497,     0,   498,   170,     0,   499,     0,   500,
     501,   502,   503,   504,     0,   505,   506,   507,     0,   508,
     509,   510,   511,   512,   513,     0,     0,   173,     0,   514,
     515,   516,     0,   175,     0,   176,     0,   517,     0,     0,
     518,     0,   519,   520,   521,   522,   523,   524,   525,     0,
     180,     0,   526,     0,     0,   527,   528,   529,     0,     0,
     530,   531,   532,   533,   534,   535,   536,   537,   538,   539,
     540,   541,   542,   187,     0,   189,     0,   543,   544,   545,
     546,   547,   548,   549,   190,   550,     0,   551,   552,     0,
     553,     0,   193,   554,   194,   555,   556,     0,     0,   557,
       0,     0,     0,   558,   559,   560,     0,     0,   195,     0,
       0,     0,   199,   561,   562,   563,   564,   565,   566,     0,
     567,   200,   568,   201,   569,   570,   571,     0,   572,   573,
     574,   575,   576,   577,   578,   203,   579,   580,   581,     0,
     582,   583,   584,   585,   586,   587,   588,   589,   590,   591,
       0,   592,   593,     0,   594,   595,   211,   596,   597,   971,
     599,   600,   601,   602,   603,     0,   604,   605,   606,   607,
       0,   608,   215,   609,   610,     0,   611,   218,     0,   612,
     613,   614,   615,   616,   617,   618,   619,   620,   621,   220,
     622,     0,   623,   624,     0,   625,   626,   627,   628,   629,
       0,   222,   223,     0,     0,   631,   224,   632,   225,     0,
     633,   634,   635,   636,   637,   638,     0,     0,   639,   640,
     641,   642,     0,     0,   643,   644,   645,   646,   647,   233,
       0,   648,     0,   649,   650,   651,     0,     0,   652,     0,
       0,   653,   654,   655,   656,   657,   236,   237,   238,   239,
     240,   241,   242,   243,   658,   659,   660,     0,     0,     0,
      55,    86,    87,    88,   400,    90,    91,    92,   401,     0,
     402,    95,     0,     0,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   403,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     404,   405,     0,     0,     0,   406,   407,     0,     0,     0,
       0,   408,     0,     0,     0,     0,     0,     0,     0,     0,
     409,     0,   410,     0,   411,   412,     0,    35,     0,     0,
       0,     0,     0,     0,     0,    41,   414,   415,   416,   417,
     418,   419,   420,   421,   973,   422,   423,   424,     0,     0,
       0,     0,     0,     0,     0,   425,   426,     0,   427,     0,
     428,   429,   430,     0,   136,     0,   138,   139,     0,   431,
     432,   433,   434,   435,     0,     0,   436,   437,   974,   140,
     439,     0,   440,   441,   442,   443,   144,     0,     0,   444,
     445,   446,   447,   448,     0,     0,   450,   451,   452,   453,
     454,   455,     0,   456,   457,   458,     0,   459,     0,     0,
       0,     0,     0,     0,     0,     0,   460,   461,   462,   463,
     464,   465,   153,   154,   466,     0,   467,     0,   468,   469,
     470,   471,   472,     0,   473,   474,   475,     0,     0,   476,
     477,   478,   479,   480,     0,   481,   482,   483,     0,   484,
     485,     0,   486,   487,   488,   162,   489,   490,   164,     0,
     491,     0,   492,   166,   493,     0,   494,     0,   495,     0,
       0,     0,   496,   497,     0,   498,   170,     0,   499,     0,
     500,   501,   502,   503,   504,     0,   505,   506,   507,     0,
     508,   509,   510,   511,   512,   513,     0,     0,   173,     0,
     514,   515,   516,     0,   175,     0,   176,     0,   517,     0,
       0,   518,     0,   519,   520,   521,   522,   523,   524,   525,
       0,   180,     0,   526,     0,     0,   527,   528,   529,     0,
       0,   530,   531,   532,   533,   534,   535,   536,   537,   538,
     539,   540,   541,   542,   187,     0,   189,     0,   543,   544,
     545,   546,   547,   548,   549,   190,   550,     0,   551,   552,
       0,   553,     0,   193,   554,   194,   555,   556,     0,     0,
     557,     0,     0,     0,   558,   559,   560,     0,     0,   195,
       0,     0,     0,   199,   561,   562,   563,   564,   565,   566,
       0,   567,   200,   568,   201,   569,   570,   571,     0,   572,
     573,   574,   575,   576,   577,   578,   203,   579,   580,   581,
       0,   582,   583,   584,   585,   586,   587,   588,   589,   590,
     591,     0,   592,   593,     0,   594,   595,   211,   596,   597,
     598,   599,   600,   601,   602,   603,     0,   604,   605,   606,
     975,     0,   608,   215,   609,   610,     0,   611,   218,     0,
     612,   613,   614,   615,   616,   617,   618,   619,   620,   621,
     220,   622,     0,   623,   624,     0,   625,   626,   627,   628,
     629,     0,   976,   223,     0,     0,   977,   224,   632,   225,
       0,   633,   634,   635,   636,   637,   638,     0,     0,   639,
     640,   641,   642,     0,     0,   643,   644,   645,   646,   978,
     233,     0,   648,     0,   649,   650,   651,     0,     0,   652,
       0,     0,   653,   654,   655,   656,   657,   236,   237,   238,
     239,   240,   241,   242,   243,   658,   659,   660,     0,     0,
       0,    55,    86,    87,    88,   400,    90,    91,    92,   401,
       0,   402,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   403,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   404,   405,     0,     0,     0,   406,   407,     0,     0,
       0,     0,   408,     0,     0,     0,     0,     0,     0,     0,
       0,   409,     0,   410,     0,   411,   412,     0,    35,     0,
       0,     0,     0,     0,     0,     0,    41,   414,   415,   416,
     417,   418,   419,   420,   421,  1012,   422,   423,   424,     0,
       0,     0,     0,     0,     0,     0,   425,   426,     0,   427,
       0,   428,   429,   430,     0,   136,     0,   138,   139,     0,
     431,   432,   433,   434,   435,     0,     0,   436,   437,   974,
     140,   439,     0,   440,   441,   442,   443,   144,     0,     0,
     444,   445,   446,   447,   448,     0,     0,   450,   451,   452,
     453,   454,   455,     0,   456,   457,   458,     0,   459,     0,
       0,     0,     0,     0,     0,     0,     0,   460,   461,   462,
     463,   464,   465,   153,   154,   466,     0,   467,     0,   468,
     469,   470,   471,   472,     0,   473,   474,   475,     0,     0,
     476,   477,   478,   479,   480,     0,   481,   482,   483,     0,
     484,   485,     0,   486,   487,   488,   162,   489,   490,   164,
       0,   491,     0,   492,   166,   493,     0,   494,     0,   495,
       0,     0,     0,   496,   497,     0,   498,   170,     0,   499,
       0,   500,   501,   502,   503,   504,     0,   505,   506,   507,
       0,   508,   509,   510,   511,   512,   513,     0,     0,   173,
       0,   514,   515,   516,     0,   175,     0,   176,     0,   517,
       0,     0,   518,     0,   519,   520,   521,   522,   523,   524,
     525,     0,   180,     0,   526,     0,     0,   527,   528,   529,
       0,     0,   530,   531,   532,   533,   534,   535,   536,   537,
     538,   539,   540,   541,   542,   187,     0,   189,     0,   543,
     544,   545,   546,   547,   548,   549,   190,   550,     0,   551,
     552,     0,   553,     0,   193,   554,   194,   555,   556,     0,
       0,   557,     0,     0,     0,   558,   559,   560,     0,     0,
     195,     0,     0,     0,   199,   561,   562,   563,   564,   565,
     566,     0,   567,   200,   568,   201,   569,   570,   571,     0,
     572,   573,   574,   575,   576,   577,   578,   203,   579,   580,
     581,     0,   582,   583,   584,   585,   586,   587,   588,   589,
     590,   591,     0,   592,   593,     0,   594,   595,   211,   596,
     597,   598,   599,   600,   601,   602,   603,     0,   604,   605,
     606,  1013,     0,   608,   215,   609,   610,     0,   611,   218,
       0,   612,   613,   614,   615,   616,   617,   618,   619,   620,
     621,   220,   622,     0,   623,   624,     0,   625,   626,   627,
     628,   629,     0,  1014,   223,     0,     0,  1015,   224,   632,
     225,     0,   633,   634,   635,   636,   637,   638,     0,     0,
     639,   640,   641,   642,     0,     0,   643,   644,   645,   646,
     978,   233,     0,   648,     0,   649,   650,   651,     0,     0,
     652,     0,     0,   653,   654,   655,   656,   657,   236,   237,
     238,   239,   240,   241,   242,   243,   658,   659,   660,     0,
       0,     0,    55,    86,    87,    88,   400,    90,    91,    92,
     401,     0,   402,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,   403,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,   404,   405,     0,     0,     0,   406,   407,     0,
       0,     0,     0,   408,     0,     0,     0,     0,     0,     0,
       0,     0,   409,     0,   410,     0,   411,   412,     0,    35,
       0,     0,     0,     0,     0,     0,     0,    41,   414,   415,
     416,   417,   418,   419,   420,   421,     0,   422,   423,   424,
       0,     0,     0,     0,     0,     0,     0,   425,   426,     0,
     427,     0,   428,   429,   430,     0,   136,     0,   138,   139,
       0,   431,   432,   433,   434,   435,     0,     0,   436,   437,
     438,   140,   439,     0,   440,   441,   442,   443,   144,     0,
       0,   444,   445,   446,   447,   448,   449,     0,   450,   451,
     452,   453,   454,   455,     0,   456,   457,   458,     0,   459,
       0,     0,     0,     0,     0,     0,     0,     0,   460,   461,
     462,   463,   464,   465,   153,   154,   466,     0,   467,     0,
     468,   469,   470,   471,   472,     0,   473,   474,   475,     0,
       0,   476,   477,   478,   479,   480,     0,   481,   482,   483,
       0,   484,   485,     0,   486,   487,   488,   162,   489,   490,
     164,     0,   491,     0,   492,   166,   493,     0,   494,     0,
     495,     0,     0,     0,   496,   497,     0,   498,   170,     0,
     499,     0,   500,   501,   502,   503,   504,     0,   505,   506,
     507,     0,   508,   509,   510,   511,   512,   513,     0,     0,
     173,     0,   514,   515,   516,     0,   175,     0,   176,     0,
     517,     0,     0,   518,     0,   519,   520,   521,   522,   523,
     524,   525,     0,   180,     0,   526,     0,     0,   527,   528,
     529,     0,     0,   530,   531,   532,   533,   534,   535,   536,
     537,   538,   539,   540,   541,   542,   187,     0,   189,     0,
     543,   544,   545,   546,   547,   548,   549,   190,   550,     0,
     551,   552,     0,   553,     0,   193,   554,   194,   555,   556,
       0,     0,   557,     0,     0,     0,   558,   559,   560,     0,
       0,   195,     0,     0,     0,   199,   561,   562,   563,   564,
     565,   566,     0,   567,   200,   568,   201,   569,   570,   571,
       0,   572,   573,   574,   575,   576,   577,   578,   203,   579,
     580,  1037,     0,   582,   583,   584,   585,   586,   587,   588,
     589,   590,   591,     0,   592,   593,     0,   594,   595,   211,
     596,   597,   598,   599,   600,   601,   602,   603,     0,   604,
     605,   606,   607,     0,   608,   215,   609,   610,     0,   611,
     218,     0,   612,   613,   614,   615,   616,   617,   618,   619,
     620,   621,   220,   622,     0,   623,   624,     0,   625,   626,
     627,   628,   629,     0,   222,   223,     0,     0,   631,   224,
     632,   225,     0,   633,   634,   635,   636,   637,   638,     0,
       0,   639,   640,   641,   642,     0,     0,   643,   644,   645,
     646,   647,   233,     0,   648,     0,   649,   650,   651,     0,
       0,   652,     0,     0,   653,   654,   655,   656,   657,   236,
     237,   238,   239,   240,   241,   242,   243,   658,   659,   660,
       0,     0,     0,    55,    86,    87,    88,   400,    90,    91,
      92,   401,     0,   402,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   403,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   404,   405,     0,     0,     0,   406,   407,
       0,     0,     0,     0,   408,     0,     0,     0,     0,     0,
       0,     0,     0,   409,     0,   410,     0,   411,   412,     0,
      35,     0,     0,     0,     0,     0,     0,     0,    41,   414,
     415,   416,   417,   418,   419,   420,   421,     0,   422,   423,
     424,     0,     0,     0,     0,     0,     0,     0,   425,   426,
       0,   427,     0,   428,   429,   430,     0,   136,     0,   138,
     139,     0,   431,   432,   433,   434,   435,     0,     0,   436,
     437,   438,   140,   439,     0,   440,   441,   442,   443,   144,
       0,     0,   444,   445,   446,   447,   448,   449,     0,   450,
     451,   452,   453,   454,   455,     0,   456,   457,   458,     0,
     459,     0,     0,     0,     0,     0,     0,     0,     0,   460,
     461,   462,   463,   464,   465,   153,   154,   466,     0,   467,
       0,   468,   469,   470,   471,   472,     0,   473,   474,   475,
       0,     0,   476,   477,   478,   479,   480,     0,   481,   482,
     483,     0,   484,   485,     0,   486,   487,   488,   162,   489,
     490,   164,     0,   491,     0,   492,   166,   493,     0,   494,
       0,   495,     0,     0,     0,   496,   497,     0,   498,   170,
       0,   499,     0,   500,   501,   502,   503,   504,     0,   505,
     506,   507,     0,   508,   509,   510,   511,   512,   513,     0,
       0,   173,     0,   514,   515,   516,     0,   175,     0,   176,
       0,   517,     0,     0,   518,     0,   519,   520,   521,   522,
     523,   524,   525,     0,   180,     0,   526,     0,     0,   527,
     528,   529,     0,     0,   530,   531,   532,  1159,   534,   535,
     536,   537,   538,   539,   540,   541,   542,   187,     0,   189,
       0,   543,   544,   545,   546,   547,   548,   549,   190,   550,
       0,   551,   552,     0,   553,     0,   193,   554,   194,   555,
     556,     0,     0,   557,     0,     0,     0,   558,   559,   560,
       0,     0,   195,     0,     0,     0,   199,   561,   562,   563,
     564,   565,   566,     0,   567,   200,   568,   201,   569,   570,
     571,     0,   572,   573,   574,   575,   576,   577,   578,   203,
     579,   580,   581,     0,   582,   583,   584,   585,   586,   587,
     588,   589,   590,   591,     0,   592,   593,     0,   594,   595,
     211,   596,   597,   598,   599,   600,   601,   602,   603,     0,
     604,   605,   606,   607,     0,   608,   215,   609,   610,     0,
     611,   218,     0,   612,   613,   614,   615,   616,   617,   618,
     619,   620,   621,   220,   622,     0,   623,   624,     0,   625,
     626,   627,   628,   629,     0,   222,   223,     0,     0,   631,
     224,   632,   225,     0,   633,   634,   635,   636,   637,   638,
       0,     0,   639,   640,   641,   642,     0,     0,   643,   644,
     645,   646,   647,   233,     0,   648,     0,   649,   650,   651,
       0,     0,   652,     0,     0,   653,   654,   655,   656,   657,
     236,   237,   238,   239,   240,   241,   242,   243,   658,   659,
     660,     0,     0,     0,    55,    86,    87,    88,   400,    90,
      91,    92,   401,     0,   402,    95,     0,     0,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   403,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   404,   405,     0,     0,     0,   406,
     407,     0,     0,     0,     0,   408,     0,     0,     0,     0,
       0,     0,     0,     0,   409,     0,   410,     0,   411,   412,
       0,    35,     0,     0,     0,     0,     0,     0,     0,    41,
     414,   415,   416,   417,   418,   419,   420,   421,     0,   422,
     423,   424,     0,     0,     0,     0,     0,     0,     0,   425,
     426,     0,   427,     0,   428,   429,   430,     0,   136,     0,
     138,   139,     0,   431,   432,   433,   434,   435,     0,     0,
     436,   437,   438,   140,   439,     0,   440,   441,   442,   443,
     144,     0,     0,   444,   445,   446,   447,   448,   449,     0,
     450,   451,   452,   453,   454,   455,     0,   456,   457,   458,
       0,   459,     0,     0,     0,     0,     0,     0,     0,     0,
     460,   461,   462,   463,   464,   465,   153,   154,   466,     0,
     467,     0,   468,   469,   470,   471,   472,     0,   473,   474,
     475,     0,     0,   476,   477,   478,   479,   480,     0,   481,
     482,   483,     0,   484,   485,     0,   486,   487,   488,   162,
     489,   490,   164,     0,   491,     0,   492,   166,   493,     0,
     494,     0,   495,     0,     0,     0,   496,   497,     0,   498,
     170,     0,   499,     0,   500,   501,   502,   503,   504,     0,
     505,   506,   507,     0,   508,   509,   510,   511,   512,   513,
       0,     0,   173,     0,   514,   515,   516,     0,   175,     0,
     176,     0,   517,     0,     0,   518,     0,   519,   520,   521,
     522,   523,   524,   525,     0,   180,     0,   526,     0,     0,
     527,   528,   529,     0,     0,   530,   531,   532,  1222,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   187,     0,
     189,     0,   543,   544,   545,   546,   547,   548,   549,   190,
     550,     0,   551,   552,     0,   553,     0,   193,   554,   194,
     555,   556,     0,     0,   557,     0,     0,     0,   558,   559,
     560,     0,     0,   195,     0,     0,     0,   199,   561,   562,
     563,   564,   565,   566,     0,   567,   200,   568,   201,   569,
     570,   571,     0,   572,   573,   574,   575,   576,   577,   578,
     203,   579,   580,   581,     0,   582,   583,   584,   585,   586,
     587,   588,   589,   590,   591,     0,   592,   593,     0,   594,
     595,   211,   596,   597,   598,   599,   600,   601,   602,   603,
       0,   604,   605,   606,   607,     0,   608,   215,   609,   610,
       0,   611,   218,     0,   612,   613,   614,   615,   616,   617,
     618,   619,   620,   621,   220,   622,     0,   623,   624,     0,
     625,   626,   627,   628,   629,     0,   222,   223,     0,     0,
     631,   224,   632,   225,     0,   633,   634,   635,   636,   637,
     638,     0,     0,   639,   640,   641,   642,     0,     0,   643,
     644,   645,   646,   647,   233,     0,   648,     0,   649,   650,
     651,     0,     0,   652,     0,     0,   653,   654,   655,   656,
     657,   236,   237,   238,   239,   240,   241,   242,   243,   658,
     659,   660,     0,     0,     0,    55,    86,    87,    88,   400,
      90,    91,    92,   401,     0,   402,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   403,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   404,   405,     0,     0,     0,
     406,   407,     0,     0,     0,     0,   408,     0,     0,     0,
       0,     0,     0,     0,     0,   409,     0,   410,     0,   411,
     412,     0,    35,     0,     0,     0,     0,     0,     0,     0,
      41,   414,   415,   416,   417,   418,   419,   420,   421,     0,
     422,   423,   424,     0,     0,     0,     0,     0,     0,     0,
     425,   426,     0,   427,     0,   428,   429,   430,     0,   136,
       0,   138,   139,     0,   431,   432,   433,   434,   435,     0,
       0,   436,   437,   438,   140,   439,     0,   440,   441,   442,
     443,   144,     0,     0,   444,   445,   446,   447,   448,   449,
       0,   450,   451,   452,   453,   454,   455,     0,   456,   457,
     458,     0,   459,     0,     0,     0,     0,     0,     0,     0,
       0,   460,   461,   462,   463,   464,   465,   153,   154,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,     0,   486,   487,   488,
     162,   489,   490,   164,     0,   491,     0,   492,   166,   493,
       0,   494,     0,   495,     0,     0,     0,   496,   497,     0,
     498,   170,     0,   499,     0,   500,   501,   502,   503,  1248,
       0,   505,   506,   507,     0,   508,   509,   510,   511,   512,
     513,     0,     0,   173,     0,   514,   515,   516,     0,   175,
       0,   176,     0,   517,     0,     0,   518,     0,   519,   520,
     521,   522,   523,   524,   525,     0,   180,     0,   526,     0,
       0,   527,   528,   529,     0,     0,   530,   531,   532,   533,
     534,   535,   536,   537,   538,   539,   540,   541,   542,   187,
       0,   189,     0,   543,   544,   545,   546,   547,   548,   549,
     190,   550,     0,   551,   552,     0,   553,     0,   193,   554,
     194,   555,   556,     0,     0,   557,     0,     0,     0,   558,
     559,   560,     0,     0,   195,     0,     0,     0,   199,   561,
     562,   563,   564,   565,   566,     0,   567,   200,   568,   201,
     569,   570,   571,     0,   572,   573,   574,   575,   576,   577,
     578,   203,   579,   580,   581,     0,   582,   583,   584,   585,
     586,   587,   588,   589,   590,   591,     0,   592,   593,     0,
     594,   595,   211,   596,   597,   598,   599,   600,   601,   602,
     603,     0,   604,   605,   606,   607,     0,   608,   215,   609,
     610,     0,   611,   218,     0,   612,   613,   614,   615,   616,
     617,   618,   619,   620,   621,   220,   622,     0,   623,   624,
       0,   625,   626,   627,   628,   629,     0,   222,   223,     0,
       0,   631,   224,   632,   225,     0,   633,   634,   635,   636,
     637,   638,     0,     0,   639,   640,   641,   642,     0,     0,
     643,   644,   645,   646,   647,   233,     0,   648,     0,   649,
     650,   651,     0,     0,   652,     0,     0,   653,   654,   655,
     656,   657,   236,   237,   238,   239,   240,   241,   242,   243,
     658,   659,   660,     0,     0,     0,    55,    86,    87,    88,
     400,    90,    91,    92,   401,     0,   402,    95,     0,     0,
      98,    99,   100,   101,   102,   103,     0,   104,   105,   403,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   404,   405,     0,     0,
       0,   406,   407,     0,     0,     0,     0,   408,     0,     0,
       0,     0,     0,     0,     0,     0,   409,     0,   410,     0,
     411,   412,     0,    35,     0,     0,     0,     0,     0,     0,
       0,    41,   414,   415,   416,   417,   418,   419,   420,   421,
       0,   422,   423,   424,     0,     0,     0,     0,     0,     0,
       0,   425,   426,     0,   427,     0,   428,   429,   430,     0,
     136,     0,   138,   139,     0,   431,   432,   433,   434,   435,
       0,     0,   436,   437,   438,   140,   439,     0,   440,   441,
     442,   443,   144,     0,     0,   444,   445,   446,   447,   448,
     449,     0,   450,   451,   452,   453,   454,   455,     0,   456,
     457,   458,     0,   459,     0,     0,     0,     0,     0,     0,
       0,     0,   460,   461,   462,   463,   464,   465,   153,   154,
     466,     0,   467,     0,   468,   469,   470,   471,   472,     0,
     473,   474,   475,     0,     0,   476,   477,   478,   479,   480,
       0,   481,   482,   483,     0,   484,   485,     0,   486,   487,
     488,   162,   489,   490,   164,     0,   491,     0,   492,   166,
     493,     0,   494,     0,   495,     0,     0,     0,   496,   497,
       0,   498,   170,     0,   499,     0,   500,   501,   502,   503,
    1253,     0,   505,   506,   507,     0,   508,   509,   510,   511,
     512,   513,     0,     0,   173,     0,   514,   515,   516,     0,
     175,     0,   176,     0,   517,     0,     0,   518,     0,   519,
     520,   521,   522,   523,   524,   525,     0,   180,     0,   526,
       0,     0,   527,   528,   529,     0,     0,   530,   531,   532,
     533,   534,   535,   536,   537,   538,   539,   540,   541,   542,
     187,     0,   189,     0,   543,   544,   545,   546,   547,   548,
     549,   190,   550,     0,   551,   552,     0,   553,     0,   193,
     554,   194,   555,   556,     0,     0,   557,     0,     0,     0,
     558,   559,   560,     0,     0,   195,     0,     0,     0,   199,
     561,   562,   563,   564,   565,   566,     0,   567,   200,   568,
     201,   569,   570,   571,     0,   572,   573,   574,   575,   576,
     577,   578,   203,   579,   580,   581,     0,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,     0,   592,   593,
       0,   594,   595,   211,   596,   597,   598,   599,   600,   601,
     602,   603,     0,   604,   605,   606,   607,     0,   608,   215,
     609,   610,     0,   611,   218,     0,   612,   613,   614,   615,
     616,   617,   618,   619,   620,   621,   220,   622,     0,   623,
     624,     0,   625,   626,   627,   628,   629,     0,   222,   223,
       0,     0,   631,   224,   632,   225,     0,   633,   634,   635,
     636,   637,   638,     0,     0,   639,   640,   641,   642,     0,
       0,   643,   644,   645,   646,   647,   233,     0,   648,     0,
     649,   650,   651,     0,     0,   652,     0,     0,   653,   654,
     655,   656,   657,   236,   237,   238,   239,   240,   241,   242,
     243,   658,   659,   660,     0,     0,     0,    55,    86,    87,
      88,   400,    90,    91,    92,   401,     0,   402,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     403,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   404,   405,     0,
       0,     0,   406,   407,     0,     0,     0,     0,   408,     0,
       0,     0,     0,     0,     0,     0,     0,   409,     0,   410,
       0,   411,   412,     0,    35,     0,     0,     0,     0,     0,
       0,     0,    41,   414,   415,   416,   417,   418,   419,   420,
     421,     0,   422,   423,   424,     0,     0,     0,     0,     0,
       0,     0,   425,   426,     0,   427,     0,   428,   429,   430,
       0,   136,     0,   138,   139,     0,   431,   432,   433,   434,
     435,     0,     0,   436,   437,   438,   140,   439,     0,   440,
     441,   442,   443,   144,     0,     0,   444,   445,   446,   447,
     448,   449,     0,   450,   451,   452,   453,   454,   455,     0,
     456,   457,   458,     0,   459,     0,     0,     0,     0,     0,
       0,     0,     0,   460,   461,   462,   463,   464,   465,   153,
     154,   466,     0,   467,     0,   468,   469,   470,   471,   472,
       0,   473,   474,   475,     0,     0,   476,   477,   478,   479,
     480,     0,   481,   482,   483,     0,   484,   485,     0,   486,
     487,   488,   162,   489,   490,   164,     0,   491,     0,   492,
     166,   493,     0,   494,     0,   495,     0,     0,     0,   496,
     497,     0,   498,   170,     0,   499,     0,   500,   501,   502,
     503,  1261,     0,   505,   506,   507,     0,   508,   509,   510,
     511,   512,   513,     0,     0,   173,     0,   514,   515,   516,
       0,   175,     0,   176,     0,   517,     0,     0,   518,     0,
     519,   520,   521,   522,   523,   524,   525,     0,   180,     0,
     526,     0,     0,   527,   528,   529,     0,     0,   530,   531,
     532,   533,   534,   535,   536,   537,   538,   539,   540,   541,
     542,   187,     0,   189,     0,   543,   544,   545,   546,   547,
     548,   549,   190,   550,     0,   551,   552,     0,   553,     0,
     193,   554,   194,   555,   556,     0,     0,   557,     0,     0,
       0,   558,   559,   560,     0,     0,   195,     0,     0,     0,
     199,   561,   562,   563,   564,   565,   566,     0,   567,   200,
     568,   201,   569,   570,   571,     0,   572,   573,   574,   575,
     576,   577,   578,   203,   579,   580,   581,     0,   582,   583,
     584,   585,   586,   587,   588,   589,   590,   591,     0,   592,
     593,     0,   594,   595,   211,   596,   597,   598,   599,   600,
     601,   602,   603,     0,   604,   605,   606,   607,     0,   608,
     215,   609,   610,     0,   611,   218,     0,   612,   613,   614,
     615,   616,   617,   618,   619,   620,   621,   220,   622,     0,
     623,   624,     0,   625,   626,   627,   628,   629,     0,   222,
     223,     0,     0,   631,   224,   632,   225,     0,   633,   634,
     635,   636,   637,   638,     0,     0,   639,   640,   641,   642,
       0,     0,   643,   644,   645,   646,   647,   233,     0,   648,
       0,   649,   650,   651,     0,     0,   652,     0,     0,   653,
     654,   655,   656,   657,   236,   237,   238,   239,   240,   241,
     242,   243,   658,   659,   660,     0,     0,     0,    55,    86,
      87,    88,   400,    90,    91,    92,   401,     0,   402,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   403,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   404,   405,
       0,     0,     0,   406,   407,     0,     0,     0,     0,   408,
       0,     0,     0,     0,     0,     0,     0,     0,   409,     0,
     410,     0,   411,   412,     0,    35,     0,     0,     0,     0,
       0,     0,     0,    41,   414,   415,   416,   417,   418,   419,
     420,   421,     0,   422,   423,   424,     0,     0,     0,     0,
       0,     0,     0,   425,   426,     0,   427,     0,   428,   429,
     430,     0,   136,     0,   138,   139,     0,   431,   432,   433,
     434,   435,     0,     0,   436,   437,   438,   140,   439,     0,
     440,   441,   442,   443,   144,     0,     0,   444,   445,   446,
     447,   448,   449,     0,   450,   451,   452,   453,   454,   455,
       0,   456,   457,   458,     0,   459,     0,     0,     0,     0,
       0,     0,     0,     0,   460,   461,   462,   463,   464,   465,
     153,   154,   466,     0,   467,     0,   468,   469,   470,   471,
     472,     0,   473,   474,   475,     0,     0,   476,   477,   478,
     479,   480,     0,   481,   482,   483,     0,   484,   485,     0,
     486,   487,   488,   162,   489,   490,   164,     0,   491,     0,
     492,   166,   493,     0,   494,     0,   495,     0,     0,     0,
     496,   497,     0,   498,   170,     0,   499,     0,   500,   501,
     502,   503,  1263,     0,   505,   506,   507,     0,   508,   509,
     510,   511,   512,   513,     0,     0,   173,     0,   514,   515,
     516,     0,   175,     0,   176,     0,   517,     0,     0,   518,
       0,   519,   520,   521,   522,   523,   524,   525,     0,   180,
       0,   526,     0,     0,   527,   528,   529,     0,     0,   530,
     531,   532,   533,   534,   535,   536,   537,   538,   539,   540,
     541,   542,   187,     0,   189,     0,   543,   544,   545,   546,
     547,   548,   549,   190,   550,     0,   551,   552,     0,   553,
       0,   193,   554,   194,   555,   556,     0,     0,   557,     0,
       0,     0,   558,   559,   560,     0,     0,   195,     0,     0,
       0,   199,   561,   562,   563,   564,   565,   566,     0,   567,
     200,   568,   201,   569,   570,   571,     0,   572,   573,   574,
     575,   576,   577,   578,   203,   579,   580,   581,     0,   582,
     583,   584,   585,   586,   587,   588,   589,   590,   591,     0,
     592,   593,     0,   594,   595,   211,   596,   597,   598,   599,
     600,   601,   602,   603,     0,   604,   605,   606,   607,     0,
     608,   215,   609,   610,     0,   611,   218,     0,   612,   613,
     614,   615,   616,   617,   618,   619,   620,   621,   220,   622,
       0,   623,   624,     0,   625,   626,   627,   628,   629,     0,
     222,   223,     0,     0,   631,   224,   632,   225,     0,   633,
     634,   635,   636,   637,   638,     0,     0,   639,   640,   641,
     642,     0,     0,   643,   644,   645,   646,   647,   233,     0,
     648,     0,   649,   650,   651,     0,     0,   652,     0,     0,
     653,   654,   655,   656,   657,   236,   237,   238,   239,   240,
     241,   242,   243,   658,   659,   660,     0,     0,     0,    55,
      86,    87,    88,   400,    90,    91,    92,   401,     0,   402,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   403,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   404,
     405,     0,     0,     0,   406,   407,     0,     0,     0,     0,
     408,     0,     0,     0,     0,     0,     0,     0,     0,   409,
       0,   410,     0,   411,   412,     0,    35,     0,     0,     0,
       0,     0,     0,     0,    41,   414,   415,   416,   417,   418,
     419,   420,   421,     0,   422,   423,   424,     0,     0,     0,
       0,     0,     0,     0,   425,   426,     0,   427,     0,   428,
     429,   430,     0,   136,     0,   138,   139,     0,   431,   432,
     433,   434,   435,     0,     0,   436,   437,   438,   140,   439,
       0,   440,   441,   442,   443,   144,     0,     0,   444,   445,
     446,   447,   448,   449,     0,   450,   451,   452,   453,   454,
     455,     0,   456,   457,   458,     0,   459,     0,     0,     0,
       0,     0,     0,     0,     0,   460,   461,   462,   463,   464,
     465,   153,   154,   466,     0,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
     478,   479,   480,     0,   481,   482,   483,     0,   484,   485,
       0,   486,   487,   488,   162,   489,   490,   164,     0,   491,
       0,   492,   166,   493,     0,   494,     0,   495,     0,     0,
       0,   496,   497,     0,   498,   170,     0,   499,     0,   500,
     501,   502,   503,  1265,     0,   505,   506,   507,     0,   508,
     509,   510,   511,   512,   513,     0,     0,   173,     0,   514,
     515,   516,     0,   175,     0,   176,     0,   517,     0,     0,
     518,     0,   519,   520,   521,   522,   523,   524,   525,     0,
     180,     0,   526,     0,     0,   527,   528,   529,     0,     0,
     530,   531,   532,   533,   534,   535,   536,   537,   538,   539,
     540,   541,   542,   187,     0,   189,     0,   543,   544,   545,
     546,   547,   548,   549,   190,   550,     0,   551,   552,     0,
     553,     0,   193,   554,   194,   555,   556,     0,     0,   557,
       0,     0,     0,   558,   559,   560,     0,     0,   195,     0,
       0,     0,   199,   561,   562,   563,   564,   565,   566,     0,
     567,   200,   568,   201,   569,   570,   571,     0,   572,   573,
     574,   575,   576,   577,   578,   203,   579,   580,   581,     0,
     582,   583,   584,   585,   586,   587,   588,   589,   590,   591,
       0,   592,   593,     0,   594,   595,   211,   596,   597,   598,
     599,   600,   601,   602,   603,     0,   604,   605,   606,   607,
       0,   608,   215,   609,   610,     0,   611,   218,     0,   612,
     613,   614,   615,   616,   617,   618,   619,   620,   621,   220,
     622,     0,   623,   624,     0,   625,   626,   627,   628,   629,
       0,   222,   223,     0,     0,   631,   224,   632,   225,     0,
     633,   634,   635,   636,   637,   638,     0,     0,   639,   640,
     641,   642,     0,     0,   643,   644,   645,   646,   647,   233,
       0,   648,     0,   649,   650,   651,     0,     0,   652,     0,
       0,   653,   654,   655,   656,   657,   236,   237,   238,   239,
     240,   241,   242,   243,   658,   659,   660,     0,     0,     0,
      55,    86,    87,    88,   400,    90,    91,    92,   401,     0,
     402,    95,     0,     0,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   403,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     404,   405,     0,     0,     0,   406,   407,     0,     0,     0,
       0,   408,     0,     0,     0,     0,     0,     0,     0,     0,
     409,     0,   410,     0,   411,   412,     0,    35,     0,     0,
       0,     0,     0,     0,     0,    41,   414,   415,   416,   417,
     418,   419,   420,   421,     0,   422,   423,   424,     0,     0,
       0,     0,     0,     0,     0,   425,   426,     0,   427,     0,
     428,   429,   430,     0,   136,     0,   138,   139,     0,   431,
     432,   433,   434,   435,     0,     0,   436,   437,   438,   140,
     439,     0,   440,   441,   442,   443,   144,     0,     0,   444,
     445,   446,   447,   448,   449,     0,   450,   451,   452,   453,
     454,   455,     0,   456,   457,   458,     0,   459,     0,     0,
       0,     0,     0,     0,     0,     0,   460,   461,   462,   463,
     464,   465,   153,   154,   466,     0,   467,     0,   468,   469,
     470,   471,   472,     0,   473,   474,   475,     0,     0,   476,
     477,   478,   479,   480,     0,   481,   482,   483,     0,   484,
     485,     0,   486,   487,   488,   162,   489,   490,   164,     0,
     491,     0,   492,   166,   493,     0,   494,     0,   495,     0,
       0,     0,   496,   497,     0,   498,   170,     0,   499,     0,
     500,   501,   502,   503,  1267,     0,   505,   506,   507,     0,
     508,   509,   510,   511,   512,   513,     0,     0,   173,     0,
     514,   515,   516,     0,   175,     0,   176,     0,   517,     0,
       0,   518,     0,   519,   520,   521,   522,   523,   524,   525,
       0,   180,     0,   526,     0,     0,   527,   528,   529,     0,
       0,   530,   531,   532,   533,   534,   535,   536,   537,   538,
     539,   540,   541,   542,   187,     0,   189,     0,   543,   544,
     545,   546,   547,   548,   549,   190,   550,     0,   551,   552,
       0,   553,     0,   193,   554,   194,   555,   556,     0,     0,
     557,     0,     0,     0,   558,   559,   560,     0,     0,   195,
       0,     0,     0,   199,   561,   562,   563,   564,   565,   566,
       0,   567,   200,   568,   201,   569,   570,   571,     0,   572,
     573,   574,   575,   576,   577,   578,   203,   579,   580,   581,
       0,   582,   583,   584,   585,   586,   587,   588,   589,   590,
     591,     0,   592,   593,     0,   594,   595,   211,   596,   597,
     598,   599,   600,   601,   602,   603,     0,   604,   605,   606,
     607,     0,   608,   215,   609,   610,     0,   611,   218,     0,
     612,   613,   614,   615,   616,   617,   618,   619,   620,   621,
     220,   622,     0,   623,   624,     0,   625,   626,   627,   628,
     629,     0,   222,   223,     0,     0,   631,   224,   632,   225,
       0,   633,   634,   635,   636,   637,   638,     0,     0,   639,
     640,   641,   642,     0,     0,   643,   644,   645,   646,   647,
     233,     0,   648,     0,   649,   650,   651,     0,     0,   652,
       0,     0,   653,   654,   655,   656,   657,   236,   237,   238,
     239,   240,   241,   242,   243,   658,   659,   660,     0,     0,
       0,    55,    86,    87,    88,   400,    90,    91,    92,   401,
       0,   402,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   403,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   404,   405,     0,     0,     0,   406,   407,     0,     0,
       0,     0,   408,     0,     0,     0,     0,     0,     0,     0,
       0,   409,     0,   410,     0,   411,   412,     0,    35,     0,
       0,     0,     0,     0,     0,     0,    41,   414,   415,   416,
     417,   418,   419,   420,   421,     0,   422,   423,   424,     0,
       0,     0,     0,     0,     0,     0,   425,   426,     0,   427,
       0,   428,   429,   430,     0,   136,     0,   138,   139,     0,
     431,   432,   433,   434,   435,     0,     0,   436,   437,   438,
     140,   439,     0,   440,   441,   442,   443,   144,     0,     0,
     444,   445,   446,   447,   448,   449,     0,   450,   451,   452,
     453,   454,   455,     0,   456,   457,   458,     0,   459,     0,
       0,     0,     0,     0,     0,     0,     0,   460,   461,   462,
     463,   464,   465,   153,   154,   466,     0,   467,     0,   468,
     469,   470,   471,   472,     0,   473,   474,   475,     0,     0,
     476,   477,   478,   479,   480,     0,   481,   482,   483,     0,
     484,   485,     0,   486,   487,   488,   162,   489,   490,   164,
       0,   491,     0,   492,   166,   493,     0,   494,     0,   495,
       0,     0,     0,   496,   497,     0,   498,   170,     0,   499,
       0,   500,   501,   502,   503,  1270,     0,   505,   506,   507,
       0,   508,   509,   510,   511,   512,   513,     0,     0,   173,
       0,   514,   515,   516,     0,   175,     0,   176,     0,   517,
       0,     0,   518,     0,   519,   520,   521,   522,   523,   524,
     525,     0,   180,     0,   526,     0,     0,   527,   528,   529,
       0,     0,   530,   531,   532,   533,   534,   535,   536,   537,
     538,   539,   540,   541,   542,   187,     0,   189,     0,   543,
     544,   545,   546,   547,   548,   549,   190,   550,     0,   551,
     552,     0,   553,     0,   193,   554,   194,   555,   556,     0,
       0,   557,     0,     0,     0,   558,   559,   560,     0,     0,
     195,     0,     0,     0,   199,   561,   562,   563,   564,   565,
     566,     0,   567,   200,   568,   201,   569,   570,   571,     0,
     572,   573,   574,   575,   576,   577,   578,   203,   579,   580,
     581,     0,   582,   583,   584,   585,   586,   587,   588,   589,
     590,   591,     0,   592,   593,     0,   594,   595,   211,   596,
     597,   598,   599,   600,   601,   602,   603,     0,   604,   605,
     606,   607,     0,   608,   215,   609,   610,     0,   611,   218,
       0,   612,   613,   614,   615,   616,   617,   618,   619,   620,
     621,   220,   622,     0,   623,   624,     0,   625,   626,   627,
     628,   629,     0,   222,   223,     0,     0,   631,   224,   632,
     225,     0,   633,   634,   635,   636,   637,   638,     0,     0,
     639,   640,   641,   642,     0,     0,   643,   644,   645,   646,
     647,   233,     0,   648,     0,   649,   650,   651,     0,     0,
     652,     0,     0,   653,   654,   655,   656,   657,   236,   237,
     238,   239,   240,   241,   242,   243,   658,   659,   660,     0,
       0,     0,    55,    86,    87,    88,   400,    90,    91,    92,
     401,     0,   402,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,   403,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,   404,   405,     0,     0,     0,   406,   407,     0,
       0,     0,     0,   408,     0,     0,     0,     0,     0,     0,
       0,     0,   409,     0,   410,     0,   411,   412,     0,    35,
       0,     0,     0,     0,     0,     0,     0,    41,   414,   415,
     416,   417,   418,   419,   420,   421,     0,   422,   423,   424,
       0,     0,     0,     0,     0,     0,     0,   425,   426,     0,
     427,     0,   428,   429,   430,     0,   136,     0,   138,   139,
       0,   431,   432,   433,   434,   435,     0,     0,   436,   437,
     438,   140,   439,     0,   440,   441,   442,   443,   144,     0,
       0,   444,   445,   446,   447,   448,   449,     0,   450,   451,
     452,   453,   454,   455,     0,   456,   457,   458,     0,   459,
       0,     0,     0,     0,     0,     0,     0,     0,   460,   461,
     462,   463,   464,   465,   153,   154,   466,     0,   467,     0,
     468,   469,   470,   471,   472,     0,   473,   474,   475,     0,
       0,   476,   477,   478,   479,   480,     0,   481,   482,   483,
       0,   484,   485,     0,   486,   487,   488,   162,   489,   490,
     164,     0,   491,     0,   492,   166,   493,     0,   494,     0,
     495,     0,     0,     0,   496,   497,     0,   498,   170,     0,
     499,     0,   500,   501,   502,   503,  1272,     0,   505,   506,
     507,     0,   508,   509,   510,   511,   512,   513,     0,     0,
     173,     0,   514,   515,   516,     0,   175,     0,   176,     0,
     517,     0,     0,   518,     0,   519,   520,   521,   522,   523,
     524,   525,     0,   180,     0,   526,     0,     0,   527,   528,
     529,     0,     0,   530,   531,   532,  1273,   534,   535,   536,
     537,   538,   539,   540,   541,   542,   187,     0,   189,     0,
     543,   544,   545,   546,   547,   548,   549,   190,   550,     0,
     551,   552,     0,   553,     0,   193,   554,   194,   555,   556,
       0,     0,   557,     0,     0,     0,   558,   559,   560,     0,
       0,   195,     0,     0,     0,   199,   561,   562,   563,   564,
     565,   566,     0,   567,   200,   568,   201,   569,   570,   571,
       0,   572,   573,   574,   575,   576,   577,   578,   203,   579,
     580,   581,     0,   582,   583,   584,   585,   586,   587,   588,
     589,   590,   591,     0,   592,   593,     0,   594,   595,   211,
     596,   597,   598,   599,   600,   601,   602,   603,     0,   604,
     605,   606,   607,     0,   608,   215,   609,   610,     0,   611,
     218,     0,   612,   613,   614,   615,   616,   617,   618,   619,
     620,   621,   220,   622,     0,   623,   624,     0,   625,   626,
     627,   628,   629,     0,   222,   223,     0,     0,   631,   224,
     632,   225,     0,   633,   634,   635,   636,   637,   638,     0,
       0,   639,   640,   641,   642,     0,     0,   643,   644,   645,
     646,   647,   233,     0,   648,     0,   649,   650,   651,     0,
       0,   652,     0,     0,   653,   654,   655,   656,   657,   236,
     237,   238,   239,   240,   241,   242,   243,   658,   659,   660,
       0,     0,     0,    55,    86,    87,    88,   400,    90,    91,
      92,   401,     0,   402,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   403,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   404,   405,     0,     0,     0,   406,   407,
       0,     0,     0,     0,   408,     0,     0,     0,     0,     0,
       0,     0,     0,   409,     0,   410,     0,   411,   412,     0,
      35,     0,     0,     0,     0,     0,     0,     0,    41,   414,
     415,   416,   417,   418,   419,   420,   421,     0,   422,   423,
     424,     0,     0,     0,     0,     0,     0,     0,   425,   426,
       0,   427,     0,   428,   429,   430,     0,   136,     0,   138,
     139,     0,   431,   432,   433,   434,   435,     0,     0,   436,
     437,   438,   140,   439,     0,   440,   441,   442,   443,   144,
       0,     0,   444,   445,   446,   447,   448,   449,     0,   450,
     451,   452,   453,   454,   455,     0,   456,   457,   458,     0,
     459,     0,     0,     0,     0,     0,     0,     0,     0,   460,
     461,   462,   463,   464,   465,   153,   154,   466,     0,   467,
       0,   468,   469,   470,   471,   472,     0,   473,   474,   475,
       0,     0,   476,   477,   478,   479,   480,     0,   481,   482,
     483,     0,   484,   485,     0,   486,   487,   488,   162,   489,
     490,   164,     0,   491,     0,   492,   166,   493,     0,   494,
       0,   495,     0,     0,     0,   496,   497,     0,   498,   170,
       0,   499,     0,   500,   501,   502,   503,  1276,     0,   505,
     506,   507,     0,   508,   509,   510,   511,   512,   513,     0,
       0,   173,     0,   514,   515,   516,     0,   175,     0,   176,
       0,   517,     0,     0,   518,     0,   519,   520,   521,   522,
     523,   524,   525,     0,   180,     0,   526,     0,     0,   527,
     528,   529,     0,     0,   530,   531,   532,   533,   534,   535,
     536,   537,   538,   539,   540,   541,   542,   187,     0,   189,
       0,   543,   544,   545,   546,   547,   548,   549,   190,   550,
       0,   551,   552,     0,   553,     0,   193,   554,   194,   555,
     556,     0,     0,   557,     0,     0,     0,   558,   559,   560,
       0,     0,   195,     0,     0,     0,   199,   561,   562,   563,
     564,   565,   566,     0,   567,   200,   568,   201,   569,   570,
     571,     0,   572,   573,   574,   575,   576,   577,   578,   203,
     579,   580,   581,     0,   582,   583,   584,   585,   586,   587,
     588,   589,   590,   591,     0,   592,   593,     0,   594,   595,
     211,   596,   597,   598,   599,   600,   601,   602,   603,     0,
     604,   605,   606,   607,     0,   608,   215,   609,   610,     0,
     611,   218,     0,   612,   613,   614,   615,   616,   617,   618,
     619,   620,   621,   220,   622,     0,   623,   624,     0,   625,
     626,   627,   628,   629,     0,   222,   223,     0,     0,   631,
     224,   632,   225,     0,   633,   634,   635,   636,   637,   638,
       0,     0,   639,   640,   641,   642,     0,     0,   643,   644,
     645,   646,   647,   233,     0,   648,     0,   649,   650,   651,
       0,     0,   652,     0,     0,   653,   654,   655,   656,   657,
     236,   237,   238,   239,   240,   241,   242,   243,   658,   659,
     660,     0,     0,     0,    55,    86,    87,    88,   400,    90,
      91,    92,   401,     0,   402,    95,     0,     0,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   403,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   404,   405,     0,     0,     0,   406,
     407,     0,     0,     0,     0,   408,     0,     0,     0,     0,
       0,     0,     0,     0,   409,     0,   410,     0,   411,   412,
       0,    35,     0,     0,     0,     0,     0,     0,     0,    41,
     414,   415,   416,   417,   418,   419,   420,   421,     0,   422,
     423,   424,     0,     0,     0,     0,     0,     0,     0,   425,
     426,     0,   427,  1460,   428,   429,   430,     0,   136,     0,
     138,   139,     0,   431,   432,   433,   434,   435,     0,     0,
     999,   437,   974,   140,  1461,     0,   440,   441,   442,   443,
     144,     0,     0,   444,   445,   446,   447,   448,     0,     0,
     450,   451,   452,   453,   454,   455,     0,   456,   457,   458,
       0,   459,     0,     0,     0,     0,     0,     0,     0,     0,
     460,   461,   462,   463,   464,   465,   153,   154,   466,     0,
     467,     0,   468,   469,   470,   471,   472,     0,   473,   474,
     475,     0,     0,   476,   477,   478,   479,   480,     0,   481,
     482,   483,     0,   484,   485,     0,   486,   487,   488,   162,
     489,   490,   164,     0,   491,     0,   492,   166,   493,     0,
     494,     0,   495,     0,     0,     0,   496,   497,     0,   498,
     170,     0,   499,     0,   500,   501,   502,   503,   504,     0,
     505,   506,   507,     0,   508,   509,   510,   511,   512,   513,
       0,     0,   173,     0,   514,   515,   516,     0,   175,     0,
     176,     0,   517,     0,     0,   518,     0,   519,   520,   521,
     522,   523,   524,   525,     0,   180,     0,   526,     0,     0,
     527,   528,   529,     0,     0,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,  1003,   187,     0,
     189,     0,   543,   544,   545,   546,   547,   548,   549,   190,
     550,     0,   551,   552,     0,   553,     0,   193,   554,   194,
     555,   556,     0,     0,   557,     0,     0,     0,   558,   559,
     560,     0,     0,   195,     0,     0,     0,   199,   561,   562,
     563,   564,   565,   566,     0,   567,   200,   568,   201,   569,
     570,   571,     0,   572,   573,   574,   575,   576,   577,   578,
     203,   579,   580,   581,     0,   582,   583,   584,   585,   586,
     587,   588,   589,   590,   591,     0,   592,   593,     0,  1004,
     595,   211,   596,   597,   598,  1005,   600,   601,   602,   603,
       0,   604,   605,   606,  1451,     0,   608,   215,   609,   610,
       0,   611,   218,     0,   612,   613,   614,   615,   616,   617,
     618,   619,   620,   621,   220,   622,     0,   623,   624,     0,
     625,   626,   627,   628,   629,     0,  1007,   223,     0,     0,
    1008,   224,   632,   225,     0,   633,   634,   635,   636,   637,
     638,     0,     0,   639,   640,   641,   642,     0,     0,   643,
     644,   645,   646,   978,   233,     0,   648,     0,   649,   650,
     651,     0,     0,   652,     0,     0,   653,   654,   655,   656,
    1009,   236,   237,   238,   239,   240,   241,   242,   243,   658,
     659,   660,     0,     0,     0,    55,    86,    87,    88,   400,
      90,    91,    92,   401,     0,   402,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   403,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   404,   405,     0,     0,     0,
     406,   407,     0,     0,     0,     0,   408,     0,     0,     0,
       0,     0,     0,     0,     0,   409,     0,   410,     0,   411,
     412,     0,    35,     0,     0,     0,     0,     0,     0,     0,
      41,   414,   415,   416,   417,   418,   419,   420,   421,     0,
     422,   423,   424,     0,     0,     0,     0,     0,  1483,     0,
     425,   426,     0,   427,     0,   428,   429,   430,     0,   136,
       0,   138,   139,     0,   431,   432,   433,   434,   435,     0,
       0,   436,   437,   438,   140,   439,     0,   440,   441,   442,
     443,   144,     0,     0,   444,   445,   446,   447,   448,   449,
       0,   450,   451,   452,   453,   454,   455,     0,   456,   457,
     458,     0,   459,     0,     0,     0,     0,     0,     0,     0,
       0,   460,   461,   462,   463,   464,   465,   153,   154,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,     0,   486,   487,   488,
     162,   489,   490,   164,     0,   491,     0,   492,   166,   493,
       0,   494,     0,   495,     0,     0,     0,   496,   497,     0,
     498,   170,     0,   499,     0,   500,   501,   502,   503,   504,
       0,   505,   506,   507,     0,   508,   509,   510,   511,   512,
     513,     0,     0,   173,     0,   514,   515,   516,     0,   175,
       0,   176,     0,   517,     0,     0,   518,     0,   519,   520,
     521,   522,   523,   524,   525,     0,   180,     0,   526,     0,
       0,   527,   528,   529,     0,     0,   530,   531,   532,   533,
     534,   535,   536,   537,   538,   539,   540,   541,   542,   187,
       0,   189,     0,   543,   544,   545,   546,   547,   548,   549,
     190,   550,     0,   551,   552,     0,   553,     0,   193,   554,
     194,   555,   556,     0,     0,   557,     0,     0,     0,   558,
     559,   560,     0,     0,   195,     0,     0,     0,   199,   561,
     562,   563,   564,   565,   566,     0,   567,   200,   568,   201,
     569,   570,   571,     0,   572,   573,   574,   575,   576,   577,
     578,   203,   579,   580,   581,     0,   582,   583,   584,   585,
     586,   587,   588,   589,   590,   591,     0,   592,   593,     0,
     594,   595,   211,   596,   597,   598,   599,   600,   601,   602,
     603,     0,   604,   605,   606,   607,     0,     0,   215,   609,
     610,     0,   611,   218,     0,   612,   613,   614,   615,   616,
     617,   618,   619,   620,   621,   220,   622,     0,   623,   624,
       0,   625,   626,   627,   628,   629,     0,   222,   223,     0,
       0,   631,   224,   632,   225,     0,   633,   634,   635,   636,
     637,   638,     0,     0,   639,   640,   641,   642,     0,     0,
     643,   644,   645,   646,   647,   233,     0,   648,     0,   649,
     650,   651,     0,     0,   652,     0,     0,   653,   654,   655,
     656,   657,   236,   237,   238,   239,   240,   241,   242,   243,
     658,   659,   660,     0,     0,     0,    55,  1573,    87,    88,
     400,    90,    91,    92,   401,     0,   402,    95,     0,     0,
      98,    99,   100,   101,   102,   103,     0,   104,   105,   403,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   404,   405,     0,     0,
       0,   406,   407,     0,     0,     0,     0,   408,     0,     0,
       0,     0,     0,     0,     0,     0,   409,     0,   410,     0,
     411,   412,     0,    35,     0,     0,     0,     0,     0,     0,
       0,    41,   414,   415,   416,   417,   418,   419,   420,   421,
       0,   422,   423,   424,     0,     0,     0,     0,     0,     0,
       0,   425,   426,     0,   427,     0,   428,   429,   430,     0,
     136,     0,   138,   139,     0,   431,   432,   433,   434,   435,
       0,     0,   436,   437,   438,   140,   439,     0,   440,   441,
     442,   443,   144,     0,     0,   444,   445,   446,   447,   448,
     449,     0,   450,   451,   452,   453,   454,   455,     0,   456,
     457,   458,     0,   459,     0,     0,     0,     0,     0,     0,
       0,     0,   460,   461,   462,   463,   464,   465,   153,   154,
     466,     0,   467,     0,   468,   469,   470,   471,   472,     0,
     473,   474,   475,     0,     0,   476,   477,   478,   479,   480,
       0,   481,   482,   483,     0,   484,   485,     0,   486,   487,
     488,   162,   489,   490,   164,     0,   491,     0,   492,   166,
     493,     0,   494,     0,   495,     0,     0,     0,   496,   497,
       0,   498,   170,     0,   499,     0,   500,   501,   502,   503,
     504,     0,   505,   506,   507,     0,   508,   509,   510,   511,
     512,   513,     0,     0,   173,     0,   514,   515,   516,     0,
     175,     0,   176,     0,   517,     0,     0,   518,     0,   519,
     520,   521,   522,   523,   524,   525,     0,   180,     0,   526,
       0,     0,   527,   528,   529,     0,     0,   530,   531,   532,
     533,   534,   535,   536,   537,   538,   539,   540,   541,   542,
     187,     0,   189,     0,   543,   544,   545,   546,   547,   548,
     549,   190,   550,     0,   551,   552,     0,   553,     0,   193,
     554,   194,   555,   556,     0,     0,   557,     0,     0,     0,
     558,   559,   560,     0,     0,   195,     0,     0,     0,   199,
     561,   562,   563,   564,   565,   566,     0,   567,   200,   568,
     201,   569,   570,   571,     0,   572,   573,   574,   575,   576,
     577,   578,   203,   579,   580,   581,     0,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,     0,   592,   593,
       0,   594,   595,   211,   596,   597,   598,   599,   600,   601,
     602,   603,     0,   604,   605,   606,   607,     0,   608,   215,
     609,   610,     0,   611,   218,     0,   612,   613,   614,   615,
     616,   617,   618,   619,   620,   621,   220,   622,     0,   623,
     624,     0,   625,   626,   627,   628,   629,     0,   222,   223,
       0,     0,   631,   224,   632,   225,     0,   633,   634,   635,
     636,   637,   638,     0,     0,   639,   640,   641,   642,     0,
       0,   643,   644,   645,   646,   647,   233,     0,   648,     0,
     649,   650,   651,     0,     0,   652,     0,     0,   653,   654,
     655,   656,   657,   236,   237,   238,   239,   240,   241,   242,
     243,   658,   659,   660,     0,     0,     0,    55,    86,    87,
      88,   400,    90,    91,    92,   401,     0,   402,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     403,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   404,   405,     0,
       0,     0,   406,   407,     0,     0,     0,     0,   408,     0,
       0,     0,     0,     0,     0,     0,     0,   409,     0,   410,
       0,   411,   412,     0,    35,     0,     0,     0,     0,     0,
       0,     0,    41,   414,   415,   416,   417,   418,   419,   420,
     421,     0,   422,   423,   424,     0,     0,     0,     0,     0,
       0,     0,   425,   426,     0,   427,     0,   428,   429,   430,
       0,   136,     0,   138,   139,     0,   431,   432,   433,   434,
     435,     0,     0,   436,   437,   438,   140,   439,     0,   440,
     441,   442,   443,   144,     0,     0,   444,   445,   446,  1786,
     448,   449,     0,   450,   451,   452,   453,   454,   455,     0,
     456,   457,   458,     0,   459,     0,     0,     0,     0,     0,
       0,     0,     0,   460,   461,   462,   463,   464,   465,   153,
     154,   466,     0,   467,     0,   468,   469,   470,   471,   472,
       0,   473,   474,   475,     0,     0,   476,   477,   478,   479,
     480,     0,   481,   482,   483,     0,   484,   485,     0,   486,
     487,   488,   162,   489,   490,   164,     0,   491,     0,   492,
     166,   493,     0,   494,     0,   495,     0,     0,     0,   496,
     497,     0,   498,   170,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,   510,
     511,   512,   513,     0,     0,   173,     0,   514,   515,   516,
       0,   175,     0,   176,     0,   517,     0,     0,   518,     0,
     519,   520,   521,   522,   523,   524,   525,     0,   180,     0,
     526,     0,     0,   527,   528,   529,     0,     0,   530,   531,
     532,   533,   534,   535,   536,   537,   538,   539,   540,   541,
     542,   187,     0,   189,     0,   543,   544,   545,   546,   547,
     548,   549,   190,   550,     0,   551,   552,     0,   553,     0,
     193,   554,   194,   555,   556,     0,     0,   557,     0,     0,
       0,   558,   559,   560,     0,     0,   195,     0,     0,     0,
     199,   561,   562,   563,   564,   565,   566,     0,   567,   200,
     568,   201,   569,   570,   571,     0,   572,   573,   574,   575,
     576,   577,   578,   203,   579,   580,   581,     0,   582,   583,
     584,   585,   586,   587,   588,   589,   590,   591,     0,   592,
     593,     0,   594,   595,   211,   596,   597,   598,   599,   600,
     601,   602,   603,     0,   604,   605,   606,   607,     0,   608,
     215,   609,   610,     0,   611,   218,     0,   612,   613,   614,
     615,   616,   617,   618,   619,   620,   621,   220,   622,     0,
     623,   624,     0,   625,   626,   627,   628,   629,     0,   222,
     223,     0,     0,   631,   224,   632,   225,     0,   633,   634,
     635,   636,   637,   638,     0,     0,   639,   640,   641,   642,
       0,     0,   643,   644,   645,   646,   647,   233,     0,   648,
       0,   649,   650,   651,     0,     0,   652,     0,     0,   653,
     654,   655,   656,   657,   236,   237,   238,   239,   240,   241,
     242,   243,   658,   659,   660,     0,     0,     0,    55,    86,
      87,    88,   400,    90,    91,    92,   401,     0,   402,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   403,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   404,   405,
       0,     0,     0,   406,   407,     0,     0,     0,     0,   408,
       0,     0,     0,     0,     0,     0,     0,     0,   409,     0,
     410,     0,   411,   412,     0,    35,     0,     0,     0,     0,
       0,     0,     0,    41,   414,   415,   416,   417,   418,   419,
     420,   421,     0,   422,   423,   424,     0,     0,     0,     0,
       0,     0,     0,   425,   426,     0,   427,     0,   428,   429,
     430,     0,   136,     0,   138,   139,     0,   431,   432,   433,
     434,   435,     0,     0,   436,   437,   438,   140,   439,     0,
     440,   441,   442,   443,   144,     0,     0,   444,   445,   446,
     447,   448,   449,     0,   450,   451,   452,   453,   454,   455,
       0,   456,   457,   458,     0,   459,     0,     0,     0,     0,
       0,     0,     0,     0,   460,   461,   462,   463,   464,   465,
     153,   154,   466,     0,   467,     0,   468,   469,   470,   471,
     472,     0,   473,   474,   475,     0,     0,   476,   477,   478,
     479,   480,     0,   481,   482,   483,     0,   484,   485,     0,
     486,   487,   488,   162,   489,   490,   164,     0,   491,     0,
     492,   166,   493,     0,   494,     0,   495,     0,     0,     0,
     496,   497,     0,   498,   170,     0,   499,     0,   500,   501,
     502,   503,  1817,     0,   505,   506,   507,     0,   508,   509,
     510,   511,   512,   513,     0,     0,   173,     0,   514,   515,
     516,     0,   175,     0,   176,     0,   517,     0,     0,   518,
       0,   519,   520,   521,   522,   523,   524,   525,     0,   180,
       0,   526,     0,     0,   527,   528,   529,     0,     0,   530,
     531,   532,   533,   534,   535,   536,   537,   538,   539,   540,
     541,   542,   187,     0,   189,     0,   543,   544,   545,   546,
     547,   548,   549,   190,   550,     0,   551,   552,     0,   553,
       0,   193,   554,   194,   555,   556,     0,     0,   557,     0,
       0,     0,   558,   559,   560,     0,     0,   195,     0,     0,
       0,   199,   561,   562,   563,   564,   565,   566,     0,   567,
     200,   568,   201,   569,   570,   571,     0,   572,   573,   574,
     575,   576,   577,   578,   203,   579,   580,   581,     0,   582,
     583,   584,   585,   586,   587,   588,   589,   590,   591,     0,
     592,   593,     0,   594,   595,   211,   596,   597,   598,   599,
     600,   601,   602,   603,     0,   604,   605,   606,   607,     0,
     608,   215,   609,   610,     0,   611,   218,     0,   612,   613,
     614,   615,   616,   617,   618,   619,   620,   621,   220,   622,
       0,   623,   624,     0,   625,   626,   627,   628,   629,     0,
     222,   223,     0,     0,   631,   224,   632,   225,     0,   633,
     634,   635,   636,   637,   638,     0,     0,   639,   640,   641,
     642,     0,     0,   643,   644,   645,   646,   647,   233,     0,
     648,     0,   649,   650,   651,     0,     0,   652,     0,     0,
     653,   654,   655,   656,   657,   236,   237,   238,   239,   240,
     241,   242,   243,   658,   659,   660,     0,     0,     0,    55,
      86,    87,    88,   400,    90,    91,    92,   401,     0,   402,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   403,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   404,
     405,     0,     0,     0,   406,   407,     0,     0,     0,     0,
     408,     0,     0,     0,     0,     0,     0,     0,     0,   409,
       0,   410,     0,   411,   412,     0,    35,     0,     0,     0,
       0,     0,     0,     0,    41,   414,   415,   416,   417,   418,
     419,   420,   421,     0,   422,   423,   424,     0,     0,     0,
       0,     0,     0,     0,   425,   426,     0,   427,     0,   428,
     429,   430,     0,   136,     0,   138,   139,     0,   431,   432,
     433,   434,   435,     0,     0,   436,   437,   438,   140,   439,
       0,   440,   441,   442,   443,   144,     0,     0,   444,   445,
     446,   447,   448,   449,     0,   450,   451,   452,   453,   454,
     455,     0,   456,   457,   458,     0,   459,     0,     0,     0,
       0,     0,     0,     0,     0,   460,   461,   462,   463,   464,
     465,   153,   154,   466,     0,   467,     0,   468,   469,   470,
     471,   472,     0,   473,   474,   475,     0,     0,   476,   477,
     478,   479,   480,     0,   481,   482,   483,     0,   484,   485,
       0,   486,   487,   488,   162,   489,   490,   164,     0,   491,
       0,   492,   166,   493,     0,   494,     0,   495,     0,     0,
       0,   496,   497,     0,   498,   170,     0,   499,     0,   500,
     501,   502,   503,  1819,     0,   505,   506,   507,     0,   508,
     509,   510,   511,   512,   513,     0,     0,   173,     0,   514,
     515,   516,     0,   175,     0,   176,     0,   517,     0,     0,
     518,     0,   519,   520,   521,   522,   523,   524,   525,     0,
     180,     0,   526,     0,     0,   527,   528,   529,     0,     0,
     530,   531,   532,   533,   534,   535,   536,   537,   538,   539,
     540,   541,   542,   187,     0,   189,     0,   543,   544,   545,
     546,   547,   548,   549,   190,   550,     0,   551,   552,     0,
     553,     0,   193,   554,   194,   555,   556,     0,     0,   557,
       0,     0,     0,   558,   559,   560,     0,     0,   195,     0,
       0,     0,   199,   561,   562,   563,   564,   565,   566,     0,
     567,   200,   568,   201,   569,   570,   571,     0,   572,   573,
     574,   575,   576,   577,   578,   203,   579,   580,   581,     0,
     582,   583,   584,   585,   586,   587,   588,   589,   590,   591,
       0,   592,   593,     0,   594,   595,   211,   596,   597,   598,
     599,   600,   601,   602,   603,     0,   604,   605,   606,   607,
       0,   608,   215,   609,   610,     0,   611,   218,     0,   612,
     613,   614,   615,   616,   617,   618,   619,   620,   621,   220,
     622,     0,   623,   624,     0,   625,   626,   627,   628,   629,
       0,   222,   223,     0,     0,   631,   224,   632,   225,     0,
     633,   634,   635,   636,   637,   638,     0,     0,   639,   640,
     641,   642,     0,     0,   643,   644,   645,   646,   647,   233,
       0,   648,     0,   649,   650,   651,     0,     0,   652,     0,
       0,   653,   654,   655,   656,   657,   236,   237,   238,   239,
     240,   241,   242,   243,   658,   659,   660,     0,     0,     0,
      55,    86,    87,    88,   400,    90,    91,    92,   401,     0,
     402,    95,     0,     0,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   403,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     404,   405,     0,     0,     0,   406,   407,     0,     0,     0,
       0,   408,     0,     0,     0,     0,     0,     0,     0,     0,
     409,     0,   410,     0,   411,   412,     0,    35,     0,     0,
       0,     0,     0,     0,     0,    41,   414,   415,   416,   417,
     418,   419,   420,   421,     0,   422,   423,   424,     0,     0,
       0,     0,     0,     0,     0,   425,   426,     0,   427,     0,
     428,   429,   430,     0,   136,     0,   138,   139,     0,   431,
     432,   433,   434,   435,     0,     0,   436,   437,   438,   140,
     439,     0,   440,   441,   442,   443,   144,     0,     0,   444,
     445,   446,   447,   448,   449,     0,   450,   451,   452,   453,
     454,   455,     0,   456,   457,   458,     0,   459,     0,     0,
       0,     0,     0,     0,     0,     0,   460,   461,   462,   463,
     464,   465,   153,   154,   466,     0,   467,     0,   468,   469,
     470,   471,   472,     0,   473,   474,   475,     0,     0,   476,
     477,   478,   479,   480,     0,   481,   482,   483,     0,   484,
     485,     0,   486,   487,   488,   162,   489,   490,   164,     0,
     491,     0,   492,   166,   493,     0,   494,     0,   495,     0,
       0,     0,   496,   497,     0,   498,   170,     0,   499,     0,
     500,   501,   502,   503,   504,     0,   505,   506,   507,     0,
     508,   509,   510,   511,   512,   513,     0,     0,   173,     0,
     514,   515,   516,     0,   175,     0,   176,     0,   517,     0,
       0,   518,     0,   519,   520,   521,   522,   523,   524,   525,
       0,   180,     0,   526,     0,     0,   527,   528,   529,     0,
       0,   530,   531,   532,   533,   534,   535,   536,   537,   538,
     539,   540,   541,   542,   187,     0,   189,     0,   543,   544,
     545,   546,   547,   548,   549,   190,   550,     0,   551,   552,
       0,   553,     0,   193,   554,   194,   555,   556,     0,     0,
     557,     0,     0,     0,   558,   559,   560,     0,     0,   195,
       0,     0,     0,   199,   561,   562,   563,   564,   565,   566,
       0,   567,   200,   568,   201,   569,   570,   571,     0,   572,
     573,   574,   575,   576,   577,   578,   203,   579,   580,   581,
       0,   582,   583,   584,   585,   586,   587,   588,   589,   590,
     591,     0,   592,   593,     0,   594,   595,   211,   596,   597,
    1913,   599,   600,   601,   602,   603,     0,   604,   605,   606,
     607,     0,   608,   215,   609,   610,     0,   611,   218,     0,
     612,   613,   614,   615,   616,   617,   618,   619,   620,   621,
     220,   622,     0,   623,   624,     0,   625,   626,   627,   628,
     629,     0,   222,   223,     0,     0,   631,   224,   632,   225,
       0,   633,   634,   635,   636,   637,   638,     0,     0,   639,
     640,   641,   642,     0,     0,   643,   644,   645,   646,   647,
     233,     0,   648,     0,   649,   650,   651,     0,     0,   652,
       0,     0,   653,   654,   655,   656,   657,   236,   237,   238,
     239,   240,   241,   242,   243,   658,   659,   660,     0,     0,
       0,    55,    86,    87,    88,   400,    90,    91,    92,   401,
       0,   402,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   403,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   404,   405,     0,     0,     0,   406,   407,     0,     0,
       0,     0,   408,     0,     0,     0,     0,     0,     0,     0,
       0,   409,     0,   410,     0,   411,   412,     0,    35,     0,
       0,     0,     0,     0,     0,     0,    41,   414,   415,   416,
     417,   418,   419,   420,   421,     0,   422,   423,   424,     0,
       0,     0,     0,     0,     0,     0,   425,   426,     0,   427,
       0,   428,   429,   430,     0,   136,     0,   138,   139,     0,
     431,   432,   433,   434,   435,     0,     0,   436,   437,   438,
     140,   439,     0,   440,   441,   442,   443,   144,     0,     0,
     444,   445,   446,   447,   448,   449,     0,   450,   451,   452,
     453,   454,   455,     0,   456,   457,   458,     0,   459,     0,
       0,     0,     0,     0,     0,     0,     0,   460,   461,   462,
     463,   464,   465,   153,   154,   466,     0,   467,     0,   468,
     469,   470,   471,   472,     0,   473,   474,   475,     0,     0,
     476,   477,   478,   479,   480,     0,   481,   482,   483,     0,
     484,   485,     0,   486,   487,   488,   162,   489,   490,   164,
       0,   491,     0,   492,   166,   493,     0,   494,     0,   495,
       0,     0,     0,   496,   497,     0,   498,   170,     0,   499,
       0,   500,   501,   502,   503,  2419,     0,   505,   506,   507,
       0,   508,   509,   510,   511,   512,   513,     0,     0,   173,
       0,   514,   515,   516,     0,   175,     0,   176,     0,   517,
       0,     0,   518,     0,   519,   520,   521,   522,   523,   524,
     525,     0,   180,     0,   526,     0,     0,   527,   528,   529,
       0,     0,   530,   531,   532,   533,   534,   535,   536,   537,
     538,   539,   540,   541,   542,   187,     0,   189,     0,   543,
     544,   545,   546,   547,   548,   549,   190,   550,     0,   551,
     552,     0,   553,     0,   193,   554,   194,   555,   556,     0,
       0,   557,     0,     0,     0,   558,   559,   560,     0,     0,
     195,     0,     0,     0,   199,   561,   562,   563,   564,   565,
     566,     0,   567,   200,   568,   201,   569,   570,   571,     0,
     572,   573,   574,   575,   576,   577,   578,   203,   579,   580,
     581,     0,   582,   583,   584,   585,   586,   587,   588,   589,
     590,   591,     0,   592,   593,     0,   594,   595,   211,   596,
     597,   598,   599,   600,   601,   602,   603,     0,   604,   605,
     606,   607,     0,   608,   215,   609,   610,     0,   611,   218,
       0,   612,   613,   614,   615,   616,   617,   618,   619,   620,
     621,   220,   622,     0,   623,   624,     0,   625,   626,   627,
     628,   629,     0,   222,   223,     0,     0,   631,   224,   632,
     225,     0,   633,   634,   635,   636,   637,   638,     0,     0,
     639,   640,   641,   642,     0,     0,   643,   644,   645,   646,
     647,   233,     0,   648,     0,   649,   650,   651,     0,     0,
     652,     0,     0,   653,   654,   655,   656,   657,   236,   237,
     238,   239,   240,   241,   242,   243,   658,   659,   660,     0,
       0,     0,    55,    86,    87,    88,   400,    90,    91,    92,
     401,     0,   402,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,   403,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,   404,   405,     0,     0,     0,   406,   407,     0,
       0,     0,     0,   408,     0,     0,     0,     0,     0,     0,
       0,     0,   409,     0,   410,     0,   411,   412,     0,    35,
       0,     0,     0,     0,     0,     0,     0,    41,   414,   415,
     416,   417,   418,   419,   420,   421,     0,   422,   423,   424,
       0,     0,     0,     0,     0,     0,     0,   425,   426,     0,
     427,     0,   428,   429,   430,     0,   136,     0,   138,   139,
       0,   431,   432,   433,   434,   435,     0,     0,   999,   437,
     974,   140,   439,     0,   440,   441,   442,   443,   144,     0,
       0,   444,   445,   446,   447,   448,     0,     0,   450,   451,
     452,   453,   454,   455,     0,   456,   457,   458,     0,   459,
       0,     0,     0,     0,     0,     0,     0,     0,   460,   461,
     462,   463,   464,   465,   153,   154,   466,     0,   467,     0,
     468,   469,   470,   471,   472,     0,   473,   474,   475,     0,
       0,   476,   477,   478,   479,   480,     0,   481,   482,   483,
       0,   484,   485,     0,   486,   487,   488,   162,   489,   490,
     164,     0,   491,     0,   492,   166,   493,     0,   494,     0,
     495,     0,     0,     0,   496,   497,     0,   498,   170,     0,
     499,     0,   500,   501,   502,   503,   504,     0,   505,   506,
     507,     0,   508,   509,   510,   511,   512,   513,     0,     0,
     173,     0,   514,   515,   516,     0,   175,     0,   176,     0,
     517,     0,     0,   518,     0,   519,   520,   521,   522,   523,
     524,   525,     0,   180,     0,   526,     0,     0,   527,   528,
     529,     0,     0,   530,   531,   532,   533,   534,   535,   536,
     537,   538,   539,   540,   541,  1003,   187,     0,   189,     0,
     543,   544,   545,   546,   547,   548,   549,   190,   550,     0,
     551,   552,     0,   553,     0,   193,   554,   194,   555,   556,
       0,     0,   557,     0,     0,     0,   558,   559,   560,     0,
       0,   195,     0,     0,     0,   199,   561,   562,   563,   564,
     565,   566,     0,   567,   200,   568,   201,   569,   570,   571,
       0,   572,   573,   574,   575,   576,   577,   578,   203,   579,
     580,   581,     0,   582,   583,   584,   585,   586,   587,   588,
     589,   590,   591,     0,   592,   593,     0,  1004,   595,   211,
     596,   597,   598,  1005,   600,   601,   602,   603,     0,   604,
     605,   606,  1451,     0,   608,   215,   609,   610,     0,   611,
     218,     0,   612,   613,   614,   615,   616,   617,   618,   619,
     620,   621,   220,   622,     0,   623,   624,     0,   625,   626,
     627,   628,   629,     0,  1007,   223,     0,     0,  1008,   224,
     632,   225,     0,   633,   634,   635,   636,   637,   638,     0,
       0,   639,   640,   641,   642,     0,     0,   643,   644,   645,
     646,   978,   233,     0,   648,     0,   649,   650,   651,     0,
       0,   652,     0,     0,   653,   654,   655,   656,  1009,   236,
     237,   238,   239,   240,   241,   242,   243,   658,   659,   660,
       0,     0,     0,    55,    86,    87,    88,   400,    90,    91,
      92,   401,     0,   402,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   403,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   404,   405,     0,     0,     0,   406,   407,
       0,     0,     0,     0,   408,     0,     0,     0,     0,     0,
       0,     0,     0,   409,     0,   410,     0,   411,   412,     0,
      35,     0,     0,     0,     0,     0,     0,     0,    41,   414,
     415,   416,   417,   418,   419,   420,   421,     0,   422,   423,
     424,     0,     0,     0,     0,     0,     0,     0,   425,   426,
       0,   427,     0,   428,   429,   430,     0,   136,     0,   138,
     139,     0,   431,   432,   433,   434,   435,     0,     0,   999,
     437,   974,   140,   439,     0,   440,   441,   442,   443,   144,
       0,     0,   444,   445,   446,   447,   448,     0,     0,   450,
     451,   452,   453,   454,   455,     0,   456,   457,   458,     0,
     459,     0,     0,     0,     0,     0,     0,     0,     0,   460,
     461,   462,   463,   464,   465,   153,   154,   466,     0,   467,
       0,   468,   469,   470,   471,   472,     0,   473,   474,   475,
       0,     0,   476,   477,   478,   479,   480,     0,   481,   482,
     483,     0,   484,   485,     0,   486,   487,   488,   162,   489,
     490,   164,     0,   491,     0,   492,   166,   493,     0,   494,
       0,   495,     0,     0,     0,   496,   497,     0,   498,   170,
       0,   499,     0,   500,   501,   502,   503,   504,     0,   505,
     506,   507,     0,   508,   509,   510,   511,   512,   513,     0,
       0,   173,     0,   514,   515,   516,     0,   175,     0,   176,
       0,   517,     0,     0,   518,     0,   519,   520,   521,   522,
     523,   524,   525,     0,   180,     0,   526,     0,     0,   527,
     528,   529,     0,     0,   530,   531,   532,   533,   534,   535,
     536,   537,   538,   539,   540,   541,  1003,   187,     0,   189,
       0,   543,   544,   545,   546,   547,   548,   549,   190,   550,
       0,   551,   552,     0,   553,     0,   193,   554,   194,   555,
     556,     0,     0,   557,     0,     0,     0,   558,   559,   560,
       0,     0,   195,     0,     0,     0,   199,   561,   562,   563,
     564,   565,   566,     0,   567,   200,   568,   201,   569,   570,
     571,     0,   572,   573,   574,   575,   576,   577,   578,   203,
     579,   580,   581,     0,   582,   583,   584,   585,   586,   587,
     588,   589,   590,   591,     0,   592,   593,     0,  1004,   595,
     211,   596,   597,   598,  1005,   600,   601,   602,   603,     0,
     604,   605,   606,  1451,     0,   608,   215,   609,   610,     0,
     611,   218,     0,   612,   613,   614,   615,   616,   617,   618,
     619,   620,   621,   220,   622,     0,   623,   624,     0,  2175,
     626,   627,   628,   629,     0,  1007,   223,     0,     0,  1008,
     224,   632,   225,     0,   633,   634,   635,   636,   637,   638,
       0,     0,   639,   640,   641,   642,     0,     0,   643,   644,
     645,   646,   978,   233,     0,   648,     0,   649,   650,   651,
       0,     0,   652,     0,     0,   653,   654,   655,   656,  1009,
     236,   237,   238,   239,   240,   241,   242,   243,   658,   659,
     660,     0,     0,     0,    55,    86,    87,    88,   400,    90,
      91,    92,   401,     0,   402,    95,     0,     0,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   403,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   404,   405,     0,     0,     0,   406,
     407,     0,     0,     0,     0,   408,     0,     0,     0,     0,
       0,     0,     0,     0,   409,     0,   410,     0,   411,   412,
       0,    35,     0,     0,     0,     0,     0,     0,     0,    41,
     414,   415,   416,   417,   418,   419,   420,   421,     0,   422,
     423,   424,     0,     0,     0,     0,     0,     0,     0,   425,
     426,     0,   427,     0,   428,   429,   430,     0,   136,     0,
     138,   139,     0,   431,   432,   433,   434,   435,     0,     0,
     999,   437,   974,   140,   439,     0,   440,   441,   442,   443,
     144,     0,     0,   444,   445,   446,   447,   448,     0,     0,
     450,   451,   452,   453,   454,   455,     0,   456,   457,   458,
       0,   459,     0,     0,     0,     0,     0,     0,     0,     0,
     460,   461,   462,   463,   464,   465,   153,   154,   466,     0,
     467,     0,   468,   469,   470,   471,   472,     0,   473,   474,
     475,     0,     0,   476,   477,   478,   479,   480,     0,   481,
     482,   483,     0,   484,   485,     0,   486,   487,   488,   162,
     489,   490,   164,     0,   491,     0,   492,   166,   493,     0,
     494,     0,   495,     0,     0,     0,   496,   497,     0,   498,
     170,     0,   499,     0,   500,   501,   502,   503,   504,     0,
     505,   506,   507,     0,   508,   509,   510,   511,   512,   513,
       0,     0,   173,     0,   514,   515,   516,     0,   175,     0,
     176,     0,   517,     0,     0,   518,     0,   519,   520,   521,
     522,   523,   524,   525,     0,   180,     0,   526,     0,     0,
     527,   528,   529,     0,     0,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,  1003,   187,     0,
     189,     0,   543,   544,   545,   546,   547,   548,   549,   190,
     550,     0,   551,   552,     0,   553,     0,   193,   554,   194,
     555,   556,     0,     0,   557,     0,     0,     0,   558,   559,
     560,     0,     0,   195,     0,     0,     0,   199,   561,   562,
     563,   564,   565,   566,     0,   567,   200,   568,   201,   569,
     570,   571,     0,   572,   573,   574,   575,   576,   577,   578,
     203,   579,   580,   581,     0,   582,   583,   584,   585,   586,
     587,   588,   589,   590,   591,     0,   592,   593,     0,  1004,
     595,   211,   596,   597,   598,  2202,   600,   601,   602,   603,
       0,   604,   605,   606,  1451,     0,   608,   215,   609,   610,
       0,   611,   218,     0,   612,   613,   614,   615,   616,   617,
     618,   619,   620,   621,   220,   622,     0,   623,   624,     0,
     625,   626,   627,   628,   629,     0,  1007,   223,     0,     0,
    1008,   224,   632,   225,     0,   633,   634,   635,   636,   637,
     638,     0,     0,   639,   640,   641,   642,     0,     0,   643,
     644,   645,   646,   978,   233,     0,   648,     0,   649,   650,
     651,     0,     0,   652,     0,     0,   653,   654,   655,   656,
    1009,   236,   237,   238,   239,   240,   241,   242,   243,   658,
     659,   660,     0,     0,     0,    55,    86,    87,    88,   400,
      90,    91,    92,   401,     0,   402,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   403,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   404,   405,     0,     0,     0,
     406,   407,     0,     0,     0,     0,   408,     0,     0,     0,
       0,     0,     0,     0,     0,   409,     0,   410,     0,   411,
     412,     0,    35,     0,     0,     0,     0,     0,     0,     0,
      41,   414,   415,   416,   417,   418,   419,   420,   421,     0,
     422,   423,   424,     0,     0,     0,     0,     0,     0,     0,
     425,   426,     0,   427,     0,   428,   429,   430,     0,   136,
       0,   138,   139,     0,   431,   432,   433,   434,   435,     0,
       0,   436,   437,   438,   140,   439,     0,   440,   441,   442,
     443,   144,     0,     0,   444,   445,   446,   447,   448,   449,
       0,   450,   451,   452,   453,   454,   455,     0,   456,   457,
     458,     0,   459,     0,     0,     0,     0,     0,     0,     0,
       0,   460,   461,   462,   463,   464,   465,   153,   154,   466,
       0,   467,     0,   468,   469,   470,   471,   472,     0,   473,
     474,   475,     0,     0,   476,   477,   478,   479,   480,     0,
     481,   482,   483,     0,   484,   485,     0,   486,   487,   488,
     162,   489,   490,   164,     0,   491,     0,   492,   166,   493,
       0,   494,     0,   495,     0,     0,     0,   496,   497,     0,
     498,   170,     0,   499,     0,   500,   501,   502,   503,   504,
       0,   505,   506,   507,     0,   508,   509,   510,   511,   512,
     513,     0,     0,   173,     0,   514,   515,   516,     0,   175,
       0,   176,     0,   517,     0,     0,   518,     0,   519,   520,
     521,   522,   523,   524,   525,     0,   180,     0,   526,     0,
       0,   527,   528,   529,     0,     0,   530,   531,   532,   533,
     534,   535,   536,   537,   538,   539,   540,   541,   542,   187,
       0,   189,     0,   543,   544,   545,   546,   547,   548,   549,
     190,   550,     0,   551,   552,     0,   553,     0,   193,   554,
     194,   555,   556,     0,     0,   557,     0,     0,     0,   558,
     559,   560,     0,     0,   195,     0,     0,     0,   199,   561,
     562,   563,   564,     0,   566,     0,   567,   200,   568,   201,
     569,   570,   571,     0,   572,   573,   574,   575,   576,     0,
     578,   203,   579,   580,   581,     0,   582,   583,   584,   585,
     586,   587,   588,   589,   590,   591,     0,   592,   593,     0,
     594,   595,   211,     0,   597,   598,   599,   600,   601,   602,
     603,     0,   604,   605,   606,   607,     0,   608,   215,   609,
     610,     0,   611,   218,     0,   612,   613,   614,   615,   616,
     617,   618,   619,   620,   621,   220,   622,     0,   623,   624,
       0,   625,   626,   627,   628,   629,     0,   222,   223,     0,
       0,   631,   224,   632,   225,     0,   633,   634,   635,   636,
     637,   638,     0,     0,   639,   640,   641,   642,     0,     0,
     643,   644,   645,   646,   647,   233,     0,   648,     0,   649,
     650,   651,     0,     0,   652,     0,     0,   653,   654,   655,
     656,   657,   236,   237,   238,   239,   240,   241,   242,   243,
     658,   659,   660,    86,    87,    88,    55,    90,    91,    92,
       0,     0,     0,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,     0,     0,     0,   107,   108,
     109,   110,     0,   111,   112,   113,   114,   115, -2053,   116,
     117,   118,     0,     0,     0,     0,     0,   121,   122,     0,
       0,     0,     0,   123,     0,     0,     0,     0,     0,     0,
       0,     0,   124,     0,   125,     0,   126,   127,     0,    35,
       0,   394,     0,     0,     0,     0,     0,    41,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   133,     0,     0,     0,   135,   136,   137,   138,   139,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   140,     0,     0,     0,     0,     0,     0,   144,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   149,     0,
       0,     0,     0,     0,   150,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   153,   154,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   160,     0,     0,     0,     0,     0,   162,     0,     0,
     164,     0,     0,     0,     0,   166,     0,     0,     0,     0,
       0,   167,     0,   168,     0,     0,     0,     0,   170,     0,
       0,     0,     0,     0,     0,     0,     0,   171,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   172,
     173,     0,     0,     0,     0,     0,   175,     0,   176,     0,
       0,   177,   178,     0,   179,     0,     0,     0,     0,     0,
       0,     0,     0,   180,   181,     0,   182,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   187,   188,   189,     0,
       0,     0,     0,     0,     0,     0,     0,   190,     0,     0,
       0,     0,   192,     0,     0,   193,     0,   194,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   195,   196,   197,   198,   199,     0,     0,     0,     0,
       0,     0,     0,     0,   200,     0,   201,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   203,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   209,     0,     0,   211,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   215,     0,     0,   217,     0,
     218,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   220,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   222,   223,     0,     0,     0,   224,
       0,   225,     0,     0,     0,     0,     0,     0,     0,   228,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   233,     0,     0,   234,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   236,
     237,   238,   239,   240,   241,   242,   243,     0,     0,     0,
      86,    87,    88,    55,    90,    91,    92,     0,     0,     0,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,     0,     0,     0,   107,   108,   109,   110,     0,
     111,   112,   113,   114,   115, -2054,   116,   117,   118,     0,
       0,     0,     0,     0,   121,   122,     0,     0,     0,     0,
     123,     0,     0,     0,     0,     0,     0,     0,     0,   124,
       0,   125,     0,   126,   127,     0,    35,     0,  1083,     0,
       0,     0,     0,     0,    41,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   133,     0,
       0,     0,   135,   136,   137,   138,   139,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   140,     0,
       0,     0,     0,     0,     0,   144,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   149,     0,     0,     0,     0,
       0,   150,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   153,   154,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   160,     0,
       0,     0,     0,     0,   162,     0,     0,   164,     0,     0,
       0,     0,   166,     0,     0,     0,     0,     0,   167,     0,
     168,     0,     0,     0,     0,   170,     0,     0,     0,     0,
       0,     0,     0,     0,   171,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   172,   173,     0,     0,
       0,     0,     0,   175,     0,   176,     0,     0,   177,   178,
       0,   179,     0,     0,     0,     0,     0,     0,     0,     0,
     180,   181,     0,   182,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   187,   188,   189,     0,     0,     0,     0,
       0,     0,     0,     0,   190,     0,     0,     0,     0,   192,
       0,     0,   193,     0,   194,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   195,   196,
     197,   198,   199,     0,     0,     0,     0,     0,     0,     0,
       0,   200,     0,   201,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   203,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   209,     0,     0,   211,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   215,     0,     0,   217,     0,   218,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   220,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   222,   223,     0,     0,     0,   224,     0,   225,     0,
       0,     0,     0,     0,     0,     0,   228,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   233,
       0,     0,   234,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   236,   237,   238,   239,
     240,   241,   242,   243,     0,     0,     0,    86,    87,    88,
      55,    90,    91,    92,     0,     0,     0,    95,     0,     0,
      98,    99,   100,   101,   102,   103,     0,   104,   105,     0,
       0,     0,   107,   108,   109,   110,     0,   111,   112,   113,
     114,   115,     0,   116,   117,   118,     0,     0,     0,     0,
       0,   121,   122,     0,     0,     0,     0,   123,     0,     0,
       0,     0,     0,     0,     0,     0,   124,     0,   125,     0,
     126,     0,     0,    35,     0,     0,     0,     0,     0,     0,
       0,    41,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   133,     0,     0,     0,   135,
     136,   137,   138,   139,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   140,     0,     0,     0,     0,
       0,     0,   144,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   149,     0,     0,     0,     0,     0,   150,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   153,   154,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   160,     0,     0,     0,     0,
       0,   162,     0,     0,   164,     0,     0,     0,     0,   166,
       0,     0,     0,     0,     0,   167,     0,   168,     0,     0,
       0,     0,   170,     0,     0,     0,     0,     0,     0,     0,
       0,   171,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   172,   173,     0,     0,     0,     0,     0,
     175,     0,   176,     0,     0,   177,   178,     0,   179,     0,
       0,     0,     0,     0,     0,     0,     0,   180,   181,     0,
     182,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     187,   188,   189,     0,     0,     0,     0,     0,     0,     0,
       0,   190,     0,     0,     0,     0,   192,     0,     0,   193,
       0,   194,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   195,   196,   197,   198,   199,
       0,     0,     0,     0,     0,     0,     0,     0,   200,     0,
     201,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   203,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     209,     0,     0,   211,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   215,
       0,     0,   217,     0,   218,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   220,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   222,   223,
       0,     0,     0,   224,     0,   225,     0,     0,     0,     0,
       0,     0,     0,   228,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   233,     0,     0,   234,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   236,   237,   238,   239,   240,   241,   242,
     243,     0,     0,     0,    86,    87,    88,    55,    90,    91,
      92,     0,     0,     0,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,     0,     0,     0,   107,
     108,   109,   110,     0,   111,   112,   113,   114,   115,     0,
     116,   117,   118,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      35,     0,     0,     0,     0,     0,     0,     0,    41,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   133,     0,     0,     0,   135,   136,   137,   138,
     139,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   140,     0,     0,     0,     0,     0,     0,   144,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   149,
       0,     0,     0,     0,     0,   150,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   153,   154,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   160,     0,     0,     0,     0,     0,   162,     0,
       0,   164,     0,     0,     0,     0,   166,     0,     0,     0,
       0,     0,   167,     0,   168,     0,     0,     0,     0,   170,
       0,     0,     0,     0,     0,     0,     0,     0,   171,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     172,   173,     0,     0,     0,     0,     0,   175,     0,   176,
       0,     0,   177,   178,     0,   179,     0,     0,     0,     0,
       0,     0,     0,     0,   180,   181,     0,   182,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   187,   188,   189,
       0,     0,     0,     0,     0,     0,     0,     0,   190,     0,
       0,     0,     0,   192,     0,     0,   193,     0,   194,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   195,   196,   197,   198,   199,     0,     0,     0,
       0,     0,     0,     0,     0,   200,     0,   201,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   203,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   209,     0,     0,
     211,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   215,     0,     0,   217,
       0,   218,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   220,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   222,   223,     0,     0,     0,
     224,     0,   225,     0,     0,     0,     0,     0,     0,     0,
     228,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   233,     0,     0,   234,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     236,   237,   238,   239,   240,   241,   242,   243,     0,     0,
       0,    86,    87,    88,    55,    90,    91,    92,     0,     0,
       0,    95,     0,     0,    98,    99,   100,   101,   102,   103,
       0,   104,   105,     0,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    35,     0,     0,
       0,     0,     0,     0,     0,    41,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   133,
       0,     0,     0,   135,   136,   137,   138,   139,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   140,
       0,     0,     0,     0,     0,     0,   144,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   149,     0,     0,     0,
       0,     0,   150,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   153,   154,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   162,     0,     0,   164,     0,
       0,     0,     0,   166,     0,     0,     0,     0,     0,   167,
       0,   168,     0,     0,     0,     0,   170,     0,     0,     0,
       0,     0,     0,     0,     0,   171,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   172,   173,     0,
       0,     0,     0,     0,   175,     0,   176,     0,     0,   177,
     178,     0,   179,     0,     0,     0,     0,     0,     0,     0,
       0,   180,   181,     0,   182,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   187,   188,   189,     0,     0,     0,
       0,     0,     0,     0,     0,   190,     0,     0,     0,     0,
     192,     0,     0,   193,     0,   194,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   195,
     196,   197,   198,   199,     0,     0,     0,     0,     0,     0,
       0,     0,   200,     0,   201,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   203,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   209,     0,     0,   211,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   215,     0,     0,   217,     0,   218,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     220,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   222,   223,     0,     0,     0,   224,     0,   225,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     233,     0,     0,   234,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   236,   237,   238,
     239,   240,   241,   242,   243,     0,     0,     0,     0,     0,
       0,    55
};

static const short yycheck[] =
{
       2,  1097,   165,   244,   816,  1252,   854,  1052,  1052,     2,
     151,    78,  1001,  1054,   117,  1259,    78,   152,  1323,  1629,
     226,  1745,  1309,   186,   148,   117,    78,     2,  1016,  1004,
    1167,  1880,    84,   117,  2214,  1841,   948,   949,  1150,    78,
    1221,   953,   854,    78,    94,    84,  1126,   169,  1160,  1729,
    1357,  1358,    78,    78,   692,   903,   362,   160,  1848,  1386,
    2214,  2215,   208,  1008,  2027,  1662,  1336,   202,   160,  1376,
     901,   132,   362,  1802,   905,  2501,   160,  1116,   117,  2677,
     147,  1778,   132,  2968,   915,   221,   208,    89,  1916,  1764,
    1202,   903,  2639,  1764,   230,  1207,  2403,  1198,  2246,  1613,
    1764,   151,  1214,  1764,  1479,  1764,  2078,  1527,  1528,  1529,
    2830,  1223,  2832,  2475,  1097,   207,  1764,   214,   334,  2408,
    2409,   160,   214,  3205,   216,   228,    78,  2893,   348,  2414,
    3375,  2921,    84,  1656,   158,  2087,   228,  3423,    89,  1582,
    1837,  1291,  1282,  1244,   228,  1229,  1347,  1348,  2123,   151,
    2084,  3395,  1130,    21,  1049,  2921,    30,  1949,  1049,  1092,
    1093,  1266,  1097,   348,    73,    10,    73,    71,   124,    71,
     920,  1372,  1277,    72,  3101,    72,    73,   244,    73,    98,
     220,    80,   184,    80,  2159,   110,   143,  3898,  2163,   228,
     165,  2907,  2908,  2909,  2910,  2911,  2912,    85,    73,  2347,
     194,   103,  1577,    76,    77,    78,    79,   802,   252,   170,
     215,   186,    84,   136,   165,    73,    38,  2009,    40,   133,
     153,   102,   234,  2321,  1077,    76,    77,    78,    79,    73,
      37,    89,    71,   198,   215,   186,   215,   252,   252,    71,
     117,   108,   880,    78,  3445,    89,  3447,   102,    29,    84,
     330,    25,   117,    25,   117,  1979,   315,   294,    89,   170,
     117,   198,   217,   294,   103,    96,    73,   126,    78,    76,
      77,    78,    79,  3940,   353,   222,   172,   101,  2426,   359,
    2428,   348,   117,   160,  1196,    78,   153,   354,   117,   256,
     419,    84,   354,    76,    77,    78,    79,   170,   174,   187,
    1275,    71,  1678,  1291,   359,   254,   389,    83,   363,    76,
      77,    78,    79,   302,  1302,  1303,   172,   147,   117,   354,
      71,   210,   215,   362,   117,   160,   175,  1464,   354,   354,
      37,   160,   387,   103,  1182,   215,    76,    77,    78,    79,
     142,   124,   215,     0,   396,   241,   215,    92,  3593,   399,
     177,   228,   103,   212,   437,  2330,    78,   396,    14,   348,
     998,    76,    77,    78,    79,   234,    73,   160,   317,    89,
    1182,   500,   207,    76,    77,    78,    79,   253,   207,   214,
    1756,   216,   184,   350,    71,   214,  1762,   216,   252,   219,
    1429,   302,  1290,   228,   252,    76,    77,    78,    79,   228,
      71,   456,   189,  1779,   163,  1732,   302,   364,   252,   233,
     362,   442,   252,  1720,  1721,   254,   255,   497,   497,   374,
    1727,    71,   198,   370,   389,    76,    77,    78,    79,  1260,
      76,    77,    78,    79,   471,   228,   808,   252,   497,  1427,
     419,   813,   330,   124,   396,    76,    77,    78,    79,  1696,
      89,   307,   389,   103,    89,   499,  1700,    96,  4125,    73,
     500,    96,  3707,   244,    71,   376,   305,    76,    77,    78,
      79,   843,   361,  3263,   248,   326,   248,   252,  1508,    71,
     302,  1469,  1470,  1314,   343,  1460,   501,   501,   500,   630,
      76,    77,    78,    79,  1325,   500,   429,  3263,   804,   387,
     365,  3746,   365,   497,  4215,   419,  1337,   430,   365,  1407,
      76,    77,    78,    79,   804,  3231,   497,  1718,  1719,  1114,
      73,   893,   170,   484,   396,  1726,   407,   362,   900,  2209,
    1280,  1712,    76,    77,    78,    79,    76,    77,    78,    79,
    1652,   497,  1654,   500,   354,  2479,   419,    76,    77,    78,
      79,  1688,   407,    76,    77,    78,    79,    76,    77,    78,
      79,   396,   429,   394,  3491,  3766,   365,   254,   443,   362,
     126,   439,   497,   482,   433,   482,   169,   476,   497,   476,
     630,   488,   489,   254,   140,   482,  1873,   482,   437,   493,
     497,   493,  1693,   488,   489,  2192,   372,  1709,   443,   439,
    2754,  3846,  2756,   396,   254,   478,  1690,   500,  1541,  1544,
    1463,   484,   439,   389,  1467,  1468,   336,   362,  1513,  3166,
     500,   495,  1513,   491,   482,   384,   499,   478,   630,   374,
     488,   489,   354,   215,  1612,   500,   500,   500,   482,  2573,
    2015,  3357,   692,   501,   488,   489,  2021,   254,   319,   488,
     489,   490,   491,   492,   493,   138,   212,   501,   490,   491,
     492,   493,   254,  1494,   447,   452,   175,  1747,  3912,   810,
     477,   478,   479,   480,  2403,   482,  2983,   117,   423,   187,
    2987,   488,   489,  2646,  2659,   500,   822,    76,    77,    78,
      79,    89,   412,    71,   414,   478,   179,   800,   164,  3727,
    1805,   500,  1786,   345,  1854,  1845,   847,   447,   800,  1814,
     926,   478,  2664,    90,   497,  3350,   800,  1822,  1823,   163,
     490,   491,   492,   493,  2872,  2873,   501,   319,   495,  2172,
     497,   217,   499,   381,   252,  1840,   252,   246,   478,  2893,
    1941,  1942,   457,   419,   350,  1598,   314,   882,  2540,  2541,
      14,  1604,   888,  2545,   360,   394,   897,   497,   138,   394,
     475,   800,   410,   478,   927,   804,   929,  2921,   931,  2867,
     170,   237,  2870,  2871,   937,   478,  2874,   383,  4064,  4179,
     318,   170,   497,   448,   182,   147,  2884,   343,   307,  1637,
     138,  1644,  2584,  2585,  1647,  1648,   444,   478,   361,   179,
    1172,   488,   489,   490,   491,   492,   493,  1179,   456,  1784,
     481,   457,  2966,   837,   485,   486,   497,   488,   489,   490,
     491,   492,   493,   959,   500,  1637,   170,   478,   421,   475,
     880,   179,   478,   319,  4234,   372,   838,   419,   488,   489,
     490,   491,   492,   493,  1697,   869,   497,   478,   331,   497,
     294,   497,   804,   312,   294,   497,   234,   219,  1230,  3890,
    2383,  3746,   209,   477,  1852,   458,   497,  3924,   482,   478,
     247,  1783,   381,   923,   488,   489,   254,   433,  1866,   387,
     216,   488,   489,   490,   491,   492,   493,  4132,   497,   481,
    1026,  3919,   478,   456,  1883,  1884,   488,   489,   490,   491,
     492,   493,   484,   456,  2633,  1002,   126,   307,    85,  1006,
    1002,   497,   478,   133,  1006,  3200,   402,   499,   920,  1949,
     140,   439,   460,   800,   477,   365,  2650,   920,   437,   482,
     413,   497,   500,   282,   478,   488,   489,   500,   478,  1000,
     138,   319,   130,   409,   410,   920,   312,   387,   998,   478,
    1000,   331,   927,   497,   929,   478,   931,   497,   302,   478,
     497,   963,   937,   938,   939,   800,   172,   175,   497,   804,
    2075,   800,    85,  1821,   497,   182,   927,   184,   929,   187,
     931,   179,  4039,   331,  1815,   501,   937,  4018,  1027,   991,
    3710,   338,   212,  1824,   495,  1591,   332,   999,   499,   140,
     162,  1003,  1004,  1005,   366,  1836,   317,   800,   160,  1821,
     187,   804,   207,   147,  3561,  3562,  3563,  1915,  1916,    76,
      77,    78,    79,  1619,    76,    77,    78,    79,  1926,   170,
     379,  1929,  2339,   413,    76,    77,    78,    79,   497,  1937,
    1938,  3676,  3677,  3678,  3679,  3680,   218,  1878,  4130,  4131,
    1881,  1882,  1950,  1951,  1885,    73,   392,  4066,    76,    77,
      78,    79,  2158,  1961,  3854,   413,    76,    77,    78,    79,
      76,    77,    78,    79,   187,  1027,   228,   239,  2066,    76,
      77,    78,    79,   215,  1077,   219,    89,    89,  3854,   478,
    1092,  1093,    94,   482,   456,  1097,   302,   256,   293,  1947,
    2281,   273,  1077,   481,  1097,   312,   484,   485,   486,  3263,
     488,   489,   490,   491,   492,   493,  3478,   227,  2016,   281,
      97,   283,  1097,   343,  4206,   110,  1077,   315,   170,  3436,
     132,   497,   340,   331,  3441,  1947,   498,  3444,   419,   501,
     382,  1092,  1093,  3432,  2741,   206,  1097,   252,   141,   151,
     152,    76,    77,    78,    79,    76,    77,    78,    79,   161,
     216,   302,  4171,   165,   170,    71,  1407,  1002,   410,   218,
     456,  1006,   282,  1002,  2421,  2158,   161,  1006,   171,   182,
    3029,   410,   359,   217,   186,  2429,   242,  2368,  2369,  2370,
    2371,   350,  1027,   170,   374,  1197,  4205,   103,   173,   330,
     202,   257,   108,   484,    76,    77,    78,    79,   450,   270,
     173,   267,  3310,   433,   500,   413,   421,   330,  3316,  3317,
    3318,  3319,  3320,  3321,   273,  1292,  3198,   372,   359,  3057,
    1292,   139,   366,   118,  1027,    76,    77,    78,    79,  2753,
     412,   126,   414,   423,  3842,   238,   359,  4132,  2923,   108,
    1317,    87,  2923,   314,  2983,  1317,   231,  1292,  2987,  2923,
     245,   216,  2923,  1569,  2923,  3413,  1292,  1292,   231,   379,
     106,  1487,  1322,  1275,  1341,  2923,   175,  1279,  1280,  1569,
    1282,  1501,  1502,   191,  1504,   319,  1279,  1280,  2141,  1282,
    2665,  3083,   437,  1360,  3086,  3087,  3088,  3089,  3090,  3091,
    3092,  3093,  3094,  3095,  1279,  1280,  3454,  1282,  3456,   294,
    4030,   110,   196,   369,  2415,  2420,  1501,  1502,   350,  1504,
    3017,    25,   456,  1390,    76,    77,    78,    79,   234,  2434,
    2435,    35,   162,  2438,    76,    77,    78,    79,   329,  2444,
    1407,   500,  2952,    76,    77,    78,    79,   246,   254,   255,
     359,  3143,  3144,   173,   363,   263,   264,   389,  3784,  3847,
     104,   497,   161,   412,   498,   414,   250,   501,   276,   342,
     197,   230,  2411,   330,  1477,   234,   174,   501,   387,   456,
     165,   125,   307,  1444,  1445,  1477,   307,   165,   273,  2220,
     400,   401,   377,  1477,  1444,  1445,   163,   399,  2503,   305,
      85,   450,   359,   170,  2257,   437,    91,  1409,   235,   140,
     269,   231,  2265,   319,  2267,  3903,   484,  1419,   170,   123,
     342,   478,   330,   500,   321,    22,   478,   141,  1430,  1521,
    1802,   499,  1804,   330,  1501,  1502,   478,  1504,  1477,   323,
     497,  1813,   227,  3990,  2731,   497,   245,   456,   421,   227,
     294,   281,  2759,   283,   421,   253,  3763,   171,  1460,   477,
     478,  1463,    99,   500,   482,  1467,  1468,  2442,   478,   456,
    1463,   489,   478,   501,  1467,  1468,    73,   321,  1539,  1582,
    2900,   478,  1521,  1522,  1523,   458,   330,   218,  1463,  1539,
    1582,   458,  1467,  1468,  1586,   294,   374,   282,  1582,   421,
     285,    41,   187,   411,   282,   413,   237,   484,  1880,  3997,
    2540,  2541,  1463,   500,  1606,  2545,  1467,  1468,   495,  2157,
     497,   498,   499,   500,   238,  1620,   165,   426,  1623,   182,
    1569,   184,   391,  4061,  4062,   302,   458,  1576,   437,  1541,
    1533,   178,   273,  1582,   248,   423,   374,  1639,   432,   439,
    3648,  3649,   449,   478,  2584,  2585,  1531,   478,  1533,   175,
     165,   503,  1555,  1556,   282,  3745,   116,   285,  1663,  1127,
    1522,  1523,   248,   217,  1549,   481,  3368,     5,   377,   349,
    1555,  1556,   488,   489,   490,   491,   492,   493,   227,   330,
    1541,   322,  1150,   372,   379,   423,   146,    25,   442,   243,
    1477,   379,  1160,   373,    16,  1598,   478,    35,   382,  3572,
      73,  1604,  2510,    76,    77,    78,    79,  1569,   359,   398,
     940,  2996,   227,  1598,  1576,    93,    94,  2732,   630,  1604,
     246,  3355,   399,   376,  2465,   402,   410,   478,  3078,  4047,
     960,  4169,  1477,   282,  1521,   330,   285,  1598,  1477,   302,
    1891,  1644,   202,  1604,  1647,  1648,  1759,   378,  1660,   312,
    2558,   379,  3102,  3038,   411,  2770,  2771,  1759,   411,  1644,
    1811,  2751,  1647,  1648,   359,  1759,   450,   282,   260,   210,
     285,   412,   232,   414,  1477,   470,  1521,  1522,  1523,  2587,
     692,  2680,   423,  1644,   330,   123,  1647,  1648,   229,   457,
    3854,   477,   433,  2648,  1697,  1582,   482,  3436,  3305,   456,
     457,  4119,  3441,   456,   457,  3444,   412,   475,   414,  4127,
    1759,   206,  1697,   359,  2622,   210,   478,   376,  1521,  1522,
    1523,  1855,   163,   207,  1569,  1802,   478,  2635,  2636,   497,
     379,  1576,   216,  3535,  3536,   478,  1697,  1582,  3123,    51,
     497,  1586,   330,  1582,   497,   330,  2604,  1586,   186,  1895,
    4168,  3909,   411,  1765,  1910,   381,   495,    69,   330,    34,
    2076,  1606,   501,  3871,   379,   128,  1569,  1606,  3105,  3106,
    3050,   359,  1784,  1576,   359,   270,  2076,  1909,  3942,  1582,
     497,   115,  2604,   146,   410,  3585,   457,   359,  2651,   419,
     317,   363,    71,   210,  1639,   322,   159,   456,   457,  3533,
    1639,   317,   387,   363,   475,   365,   322,   367,  2456,  1794,
     248,   437,   229,   373,  1891,   387,    95,   423,   444,   314,
     380,   470,   147,   163,  1901,    71,  3141,   387,   162,  1901,
     456,   498,   361,  1845,   501,   395,  1848,   346,   497,   175,
    3530,     7,  1845,   403,   169,  1848,   378,   210,   497,    95,
     175,   133,  2674,    19,    20,   470,  1901,   144,   140,   498,
    1845,   457,   501,  1848,   376,  1901,  1901,   879,   880,  1982,
     882,   497,  1759,    39,   199,  4065,    42,   330,   381,   475,
    1982,   500,   497,   381,   456,   504,  3001,  1152,  1982,  1154,
    3005,   451,  3007,   492,  3009,  3010,  1161,   495,   497,   411,
     499,   497,   236,  3018,   502,  1964,   359,   410,  1967,  1986,
     246,   923,   410,   237,  1759,   927,   412,   929,   414,   931,
    1759,   246,  1934,   481,   492,   937,   206,  2100,  3245,   497,
     210,   499,   502,  1982,   387,   313,  3051,  3234,  3235,   317,
      73,   444,  1927,  1928,   456,   457,   444,   281,   500,   283,
    1935,   229,   504,   456,  1939,  1940,  1759,   495,  2799,   497,
     294,   499,   488,   489,   490,   491,   492,   303,   304,  1954,
     163,  1956,   498,   114,  2815,   254,   378,   143,  2819,   503,
    2965,   182,   495,   184,   497,   497,   998,  3789,  1000,   497,
     270,  1976,   496,  1978,   497,   329,   500,    72,    73,   497,
    2922,  3740,   260,   204,   477,   478,   479,   480,   254,   482,
     496,  3813,  3814,  2090,   500,   488,   489,   183,   490,   491,
     492,  2403,   196,  2174,  3763,   482,   497,  2076,   499,  3888,
     364,   175,   206,  2045,   314,  2557,   210,  2559,  2560,   252,
     319,  3039,  2027,  3083,  3191,   381,  3086,  3087,  3088,  3089,
    3090,  3091,  3092,  3093,  3094,  3095,   381,   317,   498,  2172,
     500,   497,  2124,   397,  2126,  1077,   498,    71,   500,   114,
    2172,  2893,   104,   319,   410,  2124,   250,  2126,  2172,   472,
    1092,  1093,  3326,  3327,  1096,   410,  3330,   499,  3332,  2997,
     498,    95,   500,   123,   124,  1982,   270,  2157,   498,  2921,
     500,   437,   246,  3143,  3144,  3839,   307,   498,   444,   500,
     256,   312,   437,   320,  2076,  2100,   498,   320,   500,   444,
     456,   126,    72,  2172,   419,  2238,    76,    77,    78,    79,
      80,   456,   498,  2145,   500,   140,  2238,  1982,  2141,  2100,
     314,   500,   501,  1982,  2238,   498,  2158,   500,  2160,   323,
    2162,  3241,  2403,   456,   457,  2158,  2141,  2160,   472,  2162,
     304,   497,  2124,   317,  2126,   170,  3968,   172,  2270,   498,
     317,   500,   497,  2158,   104,  2160,  2270,  2162,   320,  1982,
    2141,   498,   472,   500,  2145,   498,  3027,   500,   256,  2238,
    2202,   372,   373,  4009,  1200,  4011,  3935,  2158,   497,   490,
     499,   498,   481,   500,  3112,   484,   485,   486,  3049,   488,
     489,   490,   491,   492,   493,   165,   412,   498,   414,   500,
    2354,  2270,   372,   373,   425,   126,  3541,   498,   498,   500,
     500,  2076,   387,   434,  3425,   481,   241,   381,   484,   485,
     486,   214,   488,   489,   490,   491,   492,   493,   500,   501,
     254,  2633,   500,   498,  2257,   500,   498,   498,   432,   500,
     497,   182,  2265,   184,  2267,   498,   410,   500,  1046,   170,
    1048,   498,  2257,  2076,   498,   114,   500,   227,   501,  2124,
    2265,  2126,  2267,   204,   490,  2172,   488,   489,   490,   491,
     492,   503,  1304,   437,   496,   503,  2257,   302,   473,   474,
     444,  2313,   307,   498,  2265,   500,  2267,   456,   457,  2321,
    1322,   498,   456,   500,   412,   319,   414,  1323,   498,  4058,
     500,  2124,   248,  2126,   498,   419,  2403,  2172,  3368,   498,
     151,   500,   282,  2172,   419,   285,  2587,  3452,   343,   498,
     498,   500,   500,     8,  3459,  3460,    11,    12,   456,   457,
     355,  2238,  2337,   497,  2988,  2367,  2990,    22,    23,    24,
     419,    26,    27,  1327,  1328,  3662,    31,    32,    33,  2172,
     498,   498,   500,   500,   498,   498,   500,   500,  2390,    71,
     497,   302,     2,  2270,   151,   498,   307,   500,   498,   193,
     500,   312,   498,  2238,   500,   216,  2456,   419,   498,  2238,
     500,   302,   498,   498,   500,   500,   307,   498,   498,   500,
     500,   103,  2628,  2629,    98,   498,   108,   500,   498,   419,
     500,   242,   498,  1435,   500,  2270,  2681,  2682,   433,   379,
    2442,  2270,  1444,  1445,   114,  2238,   257,  3278,  3279,  2683,
    2684,  3263,   343,   498,   439,   500,   267,   248,   498,   216,
     500,  1463,  2565,   419,   355,  1467,  1468,  2570,    78,   498,
     498,   500,   500,  2565,    84,   254,    85,  2270,  2570,   290,
     497,  2565,    91,  1094,  1095,   242,  2570,   481,  3793,   499,
     484,   485,   486,   459,   488,   489,   490,   491,   492,   493,
     257,   498,   498,   500,   500,  3535,  3536,   117,   163,   498,
     267,   500,   499,   195,   425,   498,  4126,   500,   497,   497,
    2587,   130,   498,   434,   500,   498,  2565,   500,   110,   317,
     470,  2570,   210,   290,  2601,  3576,   476,  1539,   478,  1541,
     501,   151,   433,   268,   498,  3657,   500,  1549,   230,   498,
     160,   500,   234,  2620,  2540,  2541,   439,   317,   369,  2545,
     317,   498,   498,   500,   500,   498,  2633,   500,    71,   317,
     152,   180,   254,   255,   498,   498,   500,   500,   187,   497,
     311,   190,  1578,   498,   498,   500,   500,   269,   498,   378,
     500,  3878,    95,   260,   176,   815,  1598,   207,  2584,  2585,
     820,   498,  1604,   500,   214,   498,   216,   500,   828,   497,
     126,  2983,   369,   195,   456,  2987,   836,   498,   228,   500,
      98,   841,  3520,   305,   459,   497,   428,   104,   104,   211,
     239,   330,   287,   210,   260,    71,   502,   319,   439,  1635,
     200,   200,  1644,   225,   497,  1647,  1648,   200,   200,  2651,
     459,   200,   500,   200,   200,   200,   317,  3029,  2651,   200,
     200,   200,   200,   317,  3969,   200,   497,  3772,    98,  3774,
    3775,  2646,   268,   210,  2649,   211,  2651,   210,  3783,   497,
     497,   497,   439,   497,   339,   294,   339,   497,  2565,   497,
     497,   497,   497,  2570,   497,  1697,   327,  4002,  1694,   497,
    2651,  4006,  4007,   500,   497,   497,    98,   497,   153,   391,
     497,   497,   497,   497,   497,  1711,   497,   497,   268,   497,
     497,   330,   497,   497,   497,   307,   254,    98,   210,   210,
    2565,  3579,   490,   315,   954,  2570,  2565,   248,  2830,  2831,
    2832,  2570,   379,   285,   500,   169,  2830,  2831,  2832,   438,
     970,   254,   362,    37,   363,   500,  4003,   484,  1754,  3789,
    4004,    14,   500,   497,   497,   497,   348,  3579,   419,   419,
     499,   419,  2565,   428,   419,   419,   380,  2570,   387,   419,
     419,  1001,   307,  3813,  3814,   317,   396,   419,   133,   438,
     317,  2830,  2831,  2832,   419,   239,  3708,   497,   419,   481,
    1020,   439,  3633,  3634,  2939,  3636,   488,   489,   490,   491,
     492,   493,  2814,   500,  1810,   439,   319,  2920,   254,   419,
     330,   419,   419,   114,  1044,   114,   419,   419,  2920,   497,
     321,   419,  2973,   419,  2836,   419,  2920,   317,   419,   419,
     419,  2976,  2817,    72,    73,   376,   317,    76,    77,    78,
      79,    80,   254,   196,   456,  1857,   497,   447,    98,    97,
      87,  3966,   497,   206,   497,  2867,   170,   210,  2870,  2871,
    1872,   439,  2874,  2940,   450,   449,   276,    98,  2940,   210,
     317,  2920,  2884,   319,   497,    98,   453,  2889,  2955,   377,
     200,  2893,   499,  2955,   200,   439,   439,  2899,   200,   200,
    2893,    14,   419,   366,   215,   500,   497,   250,   306,  2976,
    3151,   417,   287,   287,  2976,   444,  2983,   472,  2893,  2921,
    2987,    71,   452,  2898,  2899,  3756,  3824,   270,  2921,   500,
     387,   417,  2934,   497,  3923,  3766,   497,   215,  3968,   318,
    4187,   170,  2893,   500,  3989,  3989,  2921,  3153,  3154,  3155,
    3156,   419,   421,  2830,  2831,  2832,   228,   228,   484,   312,
     250,   484,  2964,  2965,   498,   270,    85,    34,    10,  3036,
    2921,   314,    91,   419,  3036,   376,   500,   419,   481,   500,
     323,   484,   485,   486,  1980,   488,   489,   490,   491,   492,
     493,   498,   139,   498,   498,  2830,  2831,  2832,   497,   258,
     258,  2830,  2831,  2832,  1224,  1225,  1226,   497,   307,  2011,
    3858,   130,   307,  3116,   307,   324,  2018,   317,   315,   359,
     630,   500,   251,   419,  3116,  2027,   359,   359,   384,   419,
     419,   350,  3116,    98,   254,   254,   254,  2830,  2831,  2832,
     439,   315,  3854,  2920,   273,   481,  3858,   254,   484,   485,
     486,   439,   488,   489,   490,   491,   492,   493,   254,   484,
      97,   180,   495,   495,  3436,   419,   210,   419,   187,  3441,
    4166,   190,  3444,   484,   212,  3973,   497,  3116,   199,    98,
     223,   384,   317,   491,  3151,  2920,   226,   226,   210,   432,
     500,  2920,   497,  1313,    98,   200,   384,  3083,  2100,   210,
    3086,  3087,  3088,  3089,  3090,  3091,  3092,  3093,  3094,  3095,
     459,   317,   317,  3276,   410,   500,  1336,    86,   220,   284,
     239,   114,  3953,   317,   500,  3127,  4222,  2920,   498,   498,
     498,   215,   498,   498,   498,   498,   498,   498,   472,  2141,
     500,   498,   472,  2145,   215,    14,   497,  2149,   498,  2151,
     498,  4247,   498,   419,   498,  2157,   498,  3143,  3144,  3262,
     497,  3264,   498,   326,   484,   206,   453,  3169,   419,    98,
    3262,   500,  3264,   501,   498,   294,  4088,   500,  3262,   497,
    3264,   498,  4013,   270,   497,  4083,   442,   116,   244,   307,
     800,   270,   814,   334,   804,   436,   818,   334,   808,  3291,
     254,   279,   419,   813,   279,   827,   279,  3291,   419,   419,
     419,   330,   495,   498,   254,   419,   419,   146,   419,   419,
     254,   254,   254,  3262,   254,  3264,   254,   285,   319,   498,
     852,   270,   484,   843,   856,   321,   428,   361,   163,  3116,
     359,   498,   497,  3218,   363,   867,   500,   476,   477,   478,
     419,   315,  3291,   482,  1474,  2257,   317,   439,   317,   488,
     489,  3263,   498,  2265,   497,  2267,   257,   116,   387,   257,
    3263,   497,   325,   202,   312,  3277,   886,   439,   439,   198,
     198,  3116,  3284,   893,  3286,   320,   193,  3116,  3263,   215,
     900,    71,   449,   495,   210,   124,   484,   146,   215,   498,
     498,  3276,   497,   232,   484,    71,   318,   498,  3310,   498,
     920,   222,  3263,   500,  3316,  3317,  3318,  3319,  3320,  3321,
     498,   497,   244,  3116,   484,  3276,   419,   428,   428,    95,
     419,   260,   498,   210,   419,  2331,   419,   103,   258,   498,
     498,   254,   108,   498,   254,  3338,   497,   496,  3350,   456,
      98,   497,   210,   202,   240,   459,   135,  3359,  3360,  3361,
    3362,   456,  3337,  3338,   411,   497,   456,   500,  3740,  3436,
     497,  3346,   481,   257,  3441,  3350,   384,  3444,   498,   219,
     497,   497,  3368,   232,  3359,  3262,   996,  3264,   215,   497,
     481,  3763,  1002,   484,   485,   486,  1006,   488,   489,   490,
     491,   492,   493,   215,   498,  1625,   498,   114,   454,  3411,
     454,   224,   500,   428,  3291,   497,   307,  1027,   498,   307,
    3583,   484,   200,   500,   500,  1035,  3589,  3262,   254,  3264,
     177,   307,   172,  3262,   363,  3264,   241,   439,   367,   496,
    3603,   217,   215,   439,   373,   188,   199,   498,   497,   259,
     215,   380,  1672,   419,  2456,  2457,  3291,   320,   387,   210,
     215,   497,  3291,   443,   230,   396,   395,   498,   234,  3262,
     497,  3264,  1692,   497,   403,   497,   455,   498,   333,   439,
     498,   330,   355,   497,   497,  3857,   456,   210,   254,   255,
     500,    98,   307,   280,   347,  2491,   237,   163,  3291,    85,
     126,   373,   373,   269,   320,    91,   126,   484,   114,   323,
     359,   318,   210,   317,   363,   411,  3888,   205,   367,   320,
     320,  3684,   451,   456,   373,   481,   455,   456,   443,   500,
      98,   380,   353,   500,   188,   456,   302,    98,   387,   305,
     317,   183,   317,   497,   130,   497,   395,   498,   372,  3535,
    3536,   175,   437,   319,   403,   372,   322,    84,   199,    95,
     497,   347,  1172,  3935,   354,  2353,  1468,  2651,  2764,  1179,
    3572,  3573,  2244,  4124,  3262,  2889,  3874,  3398,  3401,  3572,
    2223,  3250,  3701,  3585,  2728,  2461,  4150,  4186,  4113,  4112,
    1200,  4158,  3585,  1780,   180,  3403,  2956,  3572,  2192,  3410,
    3291,   187,   451,  2831,   190,  1766,  1826,  2341,  3583,  2933,
    3585,  4247,  4222,  3670,  3589,  1835,  3669,  2920,  3710,  2892,
    1230,  4165,  3860,  4095,  1757,   391,  3710,  3863,  3603,   186,
    1315,  3935,  3583,  3470,  3412,  4058,  3611,  3612,  3589,  2215,
    4065,  3616,  3617,  3416,  2646,  3712,  3648,  3649,  4210,  2651,
    3712,  3910,  3603,   239,  4246,   163,  2085,  3659,  3660,  1017,
      71,  3663,  3664,  1883,  1884,  4037,  1498,  3396,  3037,  1279,
    1280,  3710,  1282,  1292,  3676,  3677,  3678,  3679,  3680,  2662,
    1290,  1292,  2454,  3465,  2118,  2671,  4058,  2685,  1511,  1493,
    1037,  3583,   103,  3217,  2117,  2103,  3763,   108,  2633,  2079,
    2403,  3676,  3677,  3678,  3679,  3680,  2989,   888,   294,  3684,
    3764,  1026,  2663,  1323,  3393,   481,  3718,  3126,   484,   485,
     486,  3971,   488,   489,   490,   491,   492,   493,  3118,  4144,
     496,  4145,  4148,  3684,  2674,  1345,   502,  2601,  2599,  2512,
    2480,  1292,  3744,   630,   330,    85,  2012,  2973,  1235,  2396,
    1796,    91,  2145,  4138,  1523,   363,  1517,  2121,   922,  1322,
    1115,  2158,  2151,  1373,  2645,  2152,  3221,  2763,  1095,  3222,
    3571,  3196,  1441,   359,  1521,  2457,   395,   363,  2162,  4151,
    1872,  3449,  1279,     2,    -1,    -1,    -1,    -1,    -1,    -1,
     130,  2011,    -1,    -1,  1404,  1405,    -1,  1407,  2794,    -1,
    2796,   387,    -1,  3789,    -1,    -1,    -1,    -1,    -1,    -1,
    1420,    -1,    -1,    -1,  1424,    -1,  2036,    -1,    -1,   230,
      -1,    -1,    -1,   234,    -1,    -1,    -1,  3813,  3814,    -1,
      -1,    -1,    -1,  3710,    -1,    -1,    -1,    -1,    -1,    -1,
     180,  3834,    -1,   254,   255,    -1,    -1,   187,    -1,    -1,
     190,    -1,  3854,  1463,    -1,    -1,    -1,    -1,   269,  3834,
      -1,  3854,    -1,    -1,  4236,  2085,  1476,  1477,    -1,  3871,
      -1,    -1,  2868,  3875,    -1,  3710,    -1,    -1,    71,  3854,
      -1,  3710,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2893,    -1,  1503,   305,    -1,  3963,  1507,  1508,   239,
      -1,  3963,    95,  3854,    -1,    -1,    -1,    -1,   319,    -1,
     103,  1521,  1522,  1523,    -1,   108,    -1,  3710,    -1,  2921,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3932,    -1,    -1,    -1,    -1,    -1,    -1,  2939,  4030,    -1,
      -1,  2937,    -1,    -1,    -1,    -1,  4030,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   294,  2951,    -1,    -1,    -1,  1569,
      -1,    -1,    -1,    -1,    -1,    -1,  1576,    -1,  1578,    -1,
      -1,    -1,  1582,    -1,  2976,    -1,  1586,    -1,    -1,    -1,
     391,    -1,  3968,    -1,    -1,  4226,    -1,    -1,    -1,    -1,
     330,  4030,    -1,    -1,    -1,    -1,  1606,    -1,    71,    -1,
      -1,    -1,    -1,  1613,    -1,    -1,  3002,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2235,    -1,    -1,    -1,   359,
      -1,    -1,    -1,   363,    -1,  1635,    -1,    -1,    -1,  1639,
     103,    -1,    -1,    -1,    -1,   108,    -1,   230,    -1,    -1,
      -1,   234,    -1,    -1,    -1,    -1,    -1,   387,    -1,    -1,
      -1,    -1,    -1,    -1,  1676,    -1,    -1,    -1,    -1,    -1,
      -1,   254,   255,    -1,    -1,    -1,    -1,  3063,    -1,    -1,
     481,    -1,    -1,   484,   485,   486,   269,   488,   489,   490,
     491,   492,   493,    -1,  1694,    -1,  3082,    -1,    -1,    -1,
      -1,    -1,  4067,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1711,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   302,
      -1,  3107,   305,    -1,    -1,    -1,  4067,    -1,    -1,  1729,
      -1,    -1,    -1,    -1,    -1,    -1,   319,    -1,    -1,   322,
      -1,  2351,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1763,    -1,  4210,  1754,  3141,    -1,    -1,    -1,  1759,
      -1,    -1,    -1,  4030,    -1,    -1,  1778,   230,    -1,  4226,
      -1,   234,    -1,    -1,  4166,  2385,    -1,    -1,    -1,    -1,
      -1,    -1,  2392,  4166,    -1,    98,    -1,    -1,    -1,  4246,
      -1,   254,   255,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  4166,  1802,   116,  1804,  4030,   269,    -1,   391,    -1,
    1810,  4030,    -1,  1813,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1837,    -1,    -1,    -1,  3221,
    4222,    -1,    -1,   146,    -1,    -1,    -1,    -1,    -1,  4222,
      -1,    -1,   305,    -1,    -1,  1845,    -1,  4030,  1848,    -1,
      -1,    -1,    -1,    -1,    -1,  4247,   319,  4222,    -1,    -1,
      -1,    -1,    -1,    -1,  4247,    -1,    -1,    -1,    -1,    -1,
      -1,  3263,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1880,    -1,  4247,    -1,  3276,    -1,    -1,    -1,    -1,   202,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   481,    -1,
      -1,   484,   485,   486,    -1,   488,   489,   490,   491,   492,
     493,    -1,    -1,    -1,    -1,  1915,  1916,   500,    -1,   232,
      -1,    -1,    -1,  1923,    -1,    -1,  1926,    -1,   391,  1929,
      -1,    -1,    -1,    -1,  1934,    71,    -1,  1937,  1938,    -1,
      -1,    -1,    -1,    -1,    -1,  1945,    -1,   260,  1948,  1949,
    1950,  1951,    -1,    -1,    -1,    -1,    -1,    -1,  1958,  1959,
      -1,  1961,    -1,  1963,    -1,    -1,  1966,   103,    -1,    -1,
      -1,    -1,   108,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1980,  1981,  1982,    -1,    -1,  1985,    -1,    -1,    -1,  1989,
      -1,    -1,    -1,  1993,    -1,  3381,  1996,  1997,  1998,  1999,
    2000,  2001,  2002,  2003,  2004,    -1,  2006,    -1,    -1,    -1,
      -1,    -1,  2012,    -1,    -1,    71,  2016,  2627,   481,    -1,
      -1,    -1,   485,   486,    -1,   488,   489,   490,   491,   492,
     493,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,
      -1,    -1,    -1,    -1,    -1,    -1,   809,   103,   811,    -1,
     363,    -1,   108,    -1,   367,    -1,    -1,    -1,    -1,   195,
     373,    -1,    -1,   826,    -1,    -1,    -1,   380,    -1,    -1,
    2680,    -1,    -1,    -1,   387,    -1,  2076,    -1,    -1,    -1,
      -1,    -1,   395,    -1,    -1,    -1,   849,  2087,    -1,    -1,
     403,    -1,    -1,    -1,   230,    -1,    -1,    -1,   234,    -1,
      -1,    -1,   865,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    96,    -1,    -1,    -1,    -1,    -1,   254,   255,
      -1,    -1,   106,    -1,  2124,    -1,  2126,    -1,    -1,    -1,
      -1,    -1,    -1,   269,    -1,    -1,    -1,    -1,   451,    -1,
      -1,    -1,   455,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3541,    -1,  2169,   142,    -1,
    2160,  2173,  2162,    -1,    -1,    -1,    -1,    -1,   152,   305,
      -1,   155,  2172,    -1,   230,    -1,  2188,   161,   234,    -1,
    3572,   165,    -1,   319,  2196,    -1,    -1,    -1,    -1,  2189,
      -1,  3583,    -1,    -1,    -1,    -1,    -1,  3589,   254,   255,
      -1,    -1,   186,    -1,    -1,    -1,    -1,  2219,    -1,  2209,
      -1,  3603,    -1,   269,  2214,  2215,    -1,    -1,   202,  3605,
      -1,    -1,    -1,    -1,  2236,    -1,    -1,  3613,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2238,  2251,
      -1,  2253,    -1,    -1,    -1,    -1,   302,    -1,    -1,   305,
      -1,   235,     5,    -1,    -1,   391,    -1,    -1,    -1,  2271,
      -1,    -1,    -1,   319,    -1,    -1,  2278,    -1,    -1,    -1,
    2270,    -1,    25,  2285,    -1,    -1,    -1,    -1,    -1,    -1,
    2292,    -1,    35,    36,    -1,    -1,    -1,    -1,    41,    -1,
      43,    44,  3684,    -1,    47,    48,    49,    50,    51,    52,
      53,    54,    55,    56,    57,    58,    59,    60,    61,    62,
      63,    64,    65,    66,    67,    68,    69,    70,    -1,    72,
      -1,    74,  2932,    76,    77,    78,    79,    80,    -1,  2329,
      -1,  2331,  2942,    -1,    -1,   391,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   481,    -1,    -1,  2958,    -1,
      -1,    -1,   488,   489,   490,   491,   492,   493,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     123,  1134,  1135,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3768,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2393,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3011,    -1,  2403,  3014,    -1,    -1,  3793,    -1,    -1,
      -1,  3021,    -1,  2413,    -1,   399,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   481,    -1,    -1,   484,   485,
     486,  1194,   488,   489,   490,   491,   492,   493,    -1,    -1,
    3050,   194,    -1,    -1,    -1,    -1,    -1,  1210,  1211,    -1,
    2450,    -1,    -1,    -1,    -1,   208,    -1,    -1,    -1,    -1,
      -1,  2473,  3854,    -1,    -1,  1228,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   227,    -1,    -1,    -1,    -1,    -1,
    2480,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2501,
      -1,  2491,    -1,  1256,  1257,   248,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    98,    -1,
    2510,  2511,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   116,    -1,    -1,   282,
      -1,    -1,   285,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2540,  2541,    -1,    -1,    -1,  2545,    -1,    -1,  3158,  3159,
      -1,    -1,    -1,    -1,   307,    -1,   146,  2557,  2558,  2559,
    2560,    -1,    -1,    -1,    -1,  2565,    -1,    -1,    -1,  2569,
    2570,    -1,  2572,    -1,  2574,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3969,  2584,  2585,    -1,  2587,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2600,    -1,  2602,    -1,    -1,    -1,  2606,    -1,    -1,    -1,
      -1,    85,   202,    -1,    -1,    -1,  4002,    91,    -1,    -1,
    4006,  4007,  2622,    -1,    -1,    -1,   379,    -1,    71,    -1,
      -1,    -1,    -1,  2633,    -1,  2635,  2636,  2637,    -1,    -1,
      -1,   115,   232,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2655,   130,    -1,    -1,    -1,
     103,    -1,    -1,    -1,  2664,   108,   419,    -1,    -1,    -1,
     260,  2671,    -1,    -1,    -1,  4067,  2676,    -1,    -1,   432,
      -1,    -1,    -1,  2683,  2684,  2685,    -1,    -1,   162,    -1,
      -1,    -1,   445,    -1,   678,   679,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2716,    -1,   180,    -1,   692,    -1,
      -1,    -1,    -1,   187,    -1,    -1,   190,   470,    -1,    -1,
      -1,    -1,    -1,   476,   477,   478,    -1,  2727,    -1,   482,
      -1,   484,    -1,    -1,    -1,   488,   489,   490,   491,   492,
      -1,    -1,   495,   496,   497,   498,  3356,   500,   501,   502,
     503,   504,    -1,  2753,  2754,    -1,  2756,    -1,    -1,    -1,
      -1,    -1,   236,  2763,  3374,   239,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   363,    -1,    -1,  3386,   367,    -1,    -1,
      -1,    -1,    -1,   373,    -1,  2797,    -1,   230,    -1,    -1,
     380,   234,    -1,    -1,  2794,    -1,  2796,   387,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   395,    -1,   281,    -1,   283,
      -1,   254,   255,   403,    -1,    -1,    -1,    -1,    -1,    -1,
     294,    -1,    -1,    -1,    -1,    -1,   269,    -1,    -1,    -1,
    2830,  2831,  2832,    -1,    -1,   819,    -1,   821,    -1,   823,
      -1,   825,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2862,    -1,    -1,    -1,    -1,   329,   330,    -1,    -1,   302,
     844,   451,   305,    -1,    -1,   455,    -1,    -1,  2868,    -1,
      -1,    -1,    -1,    -1,   858,   859,   319,    -1,    -1,   863,
      -1,    -1,    -1,    -1,    -1,   359,    -1,    -1,    -1,   363,
     364,    -1,  2892,  2893,    -1,    -1,   880,    -1,   882,    -1,
      -1,    -1,    -1,    -1,    -1,  1668,  1669,  1670,  1671,    -1,
     894,    -1,    -1,   387,    -1,    -1,    -1,    -1,    -1,    -1,
    2920,  2921,   906,   397,    -1,   909,    -1,   911,    -1,   913,
      -1,    -1,    -1,    -1,    -1,  1698,  1699,  2937,    -1,    -1,
      -1,  1704,  3552,  3553,  3554,  3555,    -1,    -1,   391,    -1,
      -1,  2951,    -1,    -1,    -1,    -1,   940,   941,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2966,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   966,  2983,   968,    -1,    -1,  2987,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2997,    -1,    -1,
      -1,    -1,  3002,    -1,    -1,  3017,  1769,  1770,  1771,  1772,
      -1,    -1,    -1,    -1,   998,    -1,    -1,    -1,  3030,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3029,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   481,    -1,
    3052,   484,   485,   486,    -1,   488,   489,   490,   491,   492,
     493,    -1,    -1,  1037,    -1,    -1,    -1,    -1,    -1,    -1,
    3060,    -1,    -1,  3063,    -1,    -1,    -1,    -1,    -1,  3069,
      -1,    -1,    -1,    -1,    -1,  3075,    -1,  3077,    -1,  1842,
      -1,    -1,  3082,  3083,    -1,    -1,  3086,  3087,  3088,  3089,
    3090,  3091,  3092,  3093,  3094,  3095,    -1,    -1,    -1,  3099,
    3100,    -1,    -1,    -1,    -1,    -1,    -1,  3107,    -1,    -1,
      -1,    -1,  3112,    -1,    -1,    -1,  3116,    -1,  3118,    -1,
      -1,  1105,    -1,  1107,    -1,    -1,    -1,  1111,  3128,    -1,
      -1,  3131,    -1,  3133,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3141,  3142,  3143,  3144,    -1,    -1,    -1,  3148,    -1,
      -1,  3151,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3161,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3170,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1162,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1175,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1184,    71,    -1,    -1,    -1,    -1,  1190,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1201,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    95,    -1,  3239,    -1,    71,
      -1,    -1,    -1,   103,    -1,    -1,    -1,    -1,   108,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1231,    -1,    -1,
      -1,    -1,    -1,    95,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   103,  3262,  3263,  3264,    -1,   108,    -1,    -1,    -1,
      -1,    71,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3298,  3897,  3300,    -1,
      -1,  3291,    -1,    -1,    -1,    95,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   103,    -1,    -1,    -1,    -1,   108,    -1,
      -1,    -1,    -1,  3923,    -1,    -1,    -1,  1301,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1320,  3947,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    89,    -1,
      -1,    -1,    -1,    94,    -1,    96,    -1,    -1,    -1,    -1,
     230,    -1,    -1,    -1,   234,   106,    -1,    -1,  3368,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3381,    -1,    -1,   254,   255,  3996,    -1,   230,    -1,
      -1,   132,   234,    -1,    -1,    -1,    -1,    -1,    -1,   269,
      -1,   142,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     151,   152,   254,   255,   155,    -1,  3416,  3417,  3418,    -1,
     161,    -1,    -1,    -1,   165,    -1,    -1,   269,   169,    -1,
     230,    -1,   302,    -1,   234,   305,  3436,    -1,    -1,    -1,
      -1,  3441,   183,    -1,  3444,   186,    -1,    -1,    -1,   319,
     191,    -1,   322,    -1,   254,   255,    -1,    -1,  3470,    -1,
     302,   202,    -1,   305,    -1,   206,    -1,   208,    -1,   269,
      -1,   212,    -1,    -1,    -1,    -1,    -1,   319,    -1,    -1,
     322,    -1,    -1,    -1,  3484,    -1,    -1,    -1,   229,    -1,
      -1,    -1,    -1,    -1,   235,    -1,    -1,    -1,    -1,    -1,
    2263,    -1,   302,    -1,    -1,   305,    -1,    -1,    -1,  1493,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   319,
    3520,   391,   322,    -1,    -1,    -1,    -1,  3527,  3528,    -1,
    3530,    -1,    -1,    -1,    -1,  3535,  3536,    -1,    -1,    -1,
    3540,  3541,    -1,    71,  2307,    -1,  3546,  3547,    -1,   391,
    3550,  2314,  2315,  2316,  2317,  2318,  2319,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    -1,    -1,
    3570,    -1,    71,    -1,    -1,   103,    -1,    -1,    -1,    -1,
     108,    -1,    -1,    -1,    -1,  3585,    -1,  1571,    -1,    -1,
      -1,   391,    -1,    -1,    -1,    -1,    95,  3609,    -1,    -1,
      -1,    71,    -1,    -1,   103,  3605,    -1,    -1,  3620,   108,
      -1,   481,  1596,  3613,   484,   485,   486,    -1,   488,   489,
     490,   491,   492,   493,    -1,    -1,    -1,    -1,    -1,    -1,
     500,    -1,    -1,   103,    -1,    -1,    -1,    -1,   108,   481,
      -1,    -1,   484,   485,   486,    -1,   488,   489,   490,   491,
     492,   493,    -1,    -1,    -1,    -1,   498,    -1,   399,    -1,
      -1,    -1,  2425,    -1,  2427,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   481,    -1,    -1,   484,   485,   486,    -1,   488,   489,
     490,   491,   492,   493,    -1,    -1,    -1,    -1,   498,    -1,
    3700,    -1,   230,    -1,    -1,    -1,   234,    -1,    -1,    -1,
    3710,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   195,   254,   255,    -1,    -1,
      -1,   230,    -1,    -1,    -1,   234,    -1,    -1,    -1,    -1,
    3740,   269,    -1,    -1,    -1,  3745,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   254,   255,    -1,    -1,  3759,
     230,    -1,    -1,  3763,   234,    -1,    -1,    -1,  3768,    -1,
     269,  1755,  3784,    -1,   302,    -1,    -1,   305,    -1,    -1,
      -1,    -1,    -1,  1767,   254,   255,    -1,    -1,    -1,  3789,
      -1,   319,    -1,  3793,   322,    -1,    -1,    -1,    -1,   269,
      -1,    -1,    -1,   302,    -1,    88,   305,    -1,    -1,    -1,
      -1,    -1,    -1,  3813,  3814,    -1,    -1,  3817,    -1,    -1,
     319,    -1,    -1,   322,  3824,  3825,    -1,    -1,  1812,    -1,
      -1,    -1,  1816,    -1,    -1,   305,    -1,    -1,    -1,    -1,
      -1,  1825,    -1,  1827,    -1,  1829,    -1,    -1,    -1,   319,
    1834,    -1,    -1,    -1,  3854,    -1,    -1,  3857,    -1,    -1,
      -1,   144,    -1,   391,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1856,  1857,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   164,    -1,    -1,    -1,    -1,    -1,    -1,  3888,   630,
      -1,    -1,   391,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   185,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   391,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   212,
      -1,    -1,    -1,    -1,   217,  3935,  3936,   678,   679,   222,
      -1,    -1,  3942,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   692,    -1,   481,   237,    -1,   484,   485,   486,    -1,
     488,   489,   490,   491,   492,   493,    -1,    -1,  3968,  3969,
     498,  3971,    -1,  3973,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   481,    -1,    -1,   484,   485,   486,    -1,   488,
     489,   490,   491,   492,   493,    -1,    -1,   496,    -1,  3999,
      -1,    -1,  4002,    -1,    -1,    -1,  4006,  4007,    -1,    -1,
      -1,   481,    -1,    -1,    -1,    -1,    -1,    -1,   488,   489,
     490,   491,   492,   493,    -1,    -1,    -1,    -1,    -1,    -1,
    4030,    -1,    -1,    -1,  2018,    -1,   319,  4037,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  4058,    -1,
      -1,    -1,    -1,   346,    -1,  4065,    -1,  4067,   809,   810,
     811,    -1,    -1,   814,    -1,   816,    -1,   818,   819,    -1,
     821,    -1,   823,  4083,   825,   826,   827,   370,    71,    -1,
      -1,    -1,    -1,   376,    -1,   836,    -1,    -1,    -1,   382,
      -1,   384,    -1,   844,    -1,    -1,   847,    -1,   849,    -1,
      -1,   852,    95,   854,    -1,   856,   857,   858,   859,    -1,
     103,    -1,   863,    -1,   865,   108,   867,   410,   411,    -1,
      -1,    -1,   415,    -1,    -1,    -1,    -1,    -1,    -1,   880,
     423,   882,    -1,    -1,    -1,   428,    -1,    -1,    -1,    -1,
      -1,  4151,    -1,   894,    -1,   438,   897,    -1,    -1,    -1,
     901,    -1,   903,    -1,   905,   906,    -1,   450,   909,    -1,
     911,    -1,   913,  2157,   915,    -1,    -1,   918,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2170,    -1,    -1,    -1,
      -1,  2175,    -1,    -1,    -1,  2179,    -1,    -1,    -1,   940,
     941,  2185,    71,    -1,    -1,    -1,    -1,  2191,    -1,    -1,
      -1,    -1,    -1,  2197,    -1,    -1,    -1,    -1,  2202,    -1,
      -1,    -1,    -1,    -1,    -1,   966,    -1,   968,    71,    -1,
     971,    -1,   215,    -1,   103,    -1,  4236,    -1,    -1,   108,
      -1,  2225,  2226,  2227,  2228,    -1,    -1,   230,  2232,  2233,
      -1,   234,    95,  2237,    -1,    -1,  2240,   998,    -1,  1000,
     103,    -1,    -1,  1004,    -1,   108,    -1,    -1,    -1,    -1,
    2254,   254,   255,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2264,   147,  2266,    -1,    -1,    -1,   269,    -1,    -1,    -1,
    1031,  2275,  2276,  2277,    -1,  2279,  1037,    -1,    -1,    -1,
      -1,    -1,  2286,  2287,    -1,    -1,    -1,    -1,    -1,    -1,
    2294,  2295,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   302,
      -1,    -1,   305,    -1,    -1,    -1,   195,    -1,    -1,    -1,
     196,    -1,    -1,    -1,    -1,    -1,   319,    -1,    -1,   322,
     206,    -1,    -1,    -1,   210,    -1,    -1,    -1,    -1,   215,
      -1,  1092,  1093,   219,    -1,    -1,   222,    -1,   224,    -1,
      -1,   230,    -1,    -1,  1105,   234,  1107,    -1,    -1,    -1,
    1111,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   250,   254,   255,   230,    -1,    -1,
      -1,   234,    -1,  1134,  1135,    -1,    -1,    -1,    -1,    -1,
     269,    -1,    -1,    -1,   270,    -1,    -1,    -1,   391,    -1,
      -1,   254,   255,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1162,    -1,    -1,    -1,    -1,   269,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1175,    -1,   305,    -1,    -1,    -1,
      -1,  1182,    -1,  1184,    -1,    -1,    -1,    -1,   314,  1190,
     319,    -1,    -1,  1194,    -1,    -1,    -1,   323,    -1,   302,
    1201,    -1,   305,    -1,    -1,    -1,    -1,    -1,    -1,  1210,
    1211,    -1,  2456,    -1,    -1,    -1,   319,    -1,    -1,   322,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1228,  1229,    -1,
    1231,  1232,    -1,    -1,    -1,    -1,    -1,    -1,   481,    -1,
     366,   484,   485,   486,    -1,   488,   489,   490,   491,   492,
     493,    -1,    -1,  2497,    -1,  1256,  1257,    -1,    -1,  1260,
      -1,    -1,   391,    -1,    -1,    -1,    71,     3,    -1,    -1,
      -1,    -1,    -1,     9,  1275,    -1,    -1,    13,    -1,    15,
      -1,    17,    18,    -1,   410,    -1,    -1,    -1,   391,    -1,
      95,    -1,    28,    -1,    -1,    -1,    -1,    -1,   103,    -1,
    1301,    -1,    -1,   108,    -1,    -1,   432,  1308,  1309,    45,
      46,    -1,    -1,  1314,  1315,    -1,    -1,    -1,    -1,  1320,
      -1,    -1,    -1,    -1,  1325,    -1,    -1,   453,    -1,   455,
     456,    -1,  1333,    -1,    -1,    -1,  1337,    -1,  1339,    -1,
      -1,    -1,    -1,    -1,    -1,    81,    -1,    -1,    -1,    -1,
      -1,    -1,   481,    -1,    -1,    91,    -1,    93,    94,   488,
     489,   490,   491,   492,   493,    -1,    -1,  1200,    -1,   495,
      -1,   107,   498,   499,    -1,   501,    -1,    -1,   481,    -1,
      -1,   484,   485,   486,    -1,   488,   489,   490,   491,   492,
     493,   127,    -1,   129,   130,   498,    -1,    -1,   134,   135,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   145,
      -1,   147,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   230,    -1,    -1,   164,   234,
     166,    -1,    -1,   169,    -1,    -1,    -1,    -1,    -1,   175,
      -1,    -1,    -1,  1444,  1445,   181,    -1,    -1,    -1,   254,
     255,   187,    -1,    -1,    -1,    -1,    -1,   193,    -1,  1460,
      -1,    -1,    -1,   199,   269,   201,  1467,  1468,    -1,    88,
     206,    -1,    -1,  2717,  2718,    -1,    -1,    -1,    -1,    -1,
      -1,   100,  1483,   219,  1485,    -1,    -1,    -1,    -1,    -1,
    1323,    -1,  1493,  1494,    -1,    -1,  2740,   302,    -1,    -1,
     305,   120,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     246,    -1,    -1,    -1,   319,    -1,    -1,   322,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   144,    -1,    -1,  2772,  2773,
    2774,  2775,    -1,    -1,    -1,   271,   272,    -1,  1539,    -1,
    1541,   277,    -1,    -1,    -1,   164,    -1,    -1,    -1,    -1,
     286,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   185,    -1,   304,    -1,
    1571,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   391,    -1,    -1,    -1,
      -1,    -1,    -1,   212,    -1,  1596,    -1,    -1,   217,    -1,
      -1,    -1,    -1,   222,    -1,   341,    -1,    -1,    -1,    -1,
      -1,    -1,  3635,    -1,  2858,    -1,   352,    -1,   237,  2863,
     356,    -1,   358,    -1,    -1,    -1,    -1,   363,    -1,    -1,
      -1,    -1,   368,    -1,    -1,   371,  1637,    -1,    -1,   375,
      -1,    -1,    -1,    -1,    -1,   381,    -1,    -1,    -1,    -1,
      -1,   387,    -1,    -1,   390,    -1,    -1,    -1,    -1,    -1,
      -1,   397,    -1,    -1,    -1,    -1,    -1,  1668,  1669,  1670,
    1671,    -1,    -1,    -1,   410,  1676,   481,    -1,    -1,   484,
     485,   486,    -1,   488,   489,   490,   491,   492,   493,  1690,
     426,    -1,   428,   498,  2938,  2939,    -1,  1698,  1699,   435,
     319,   437,    -1,  1704,   440,    -1,    -1,    -1,   444,    -1,
     329,    -1,  2956,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     456,    -1,    -1,    -1,    -1,    -1,    -1,   346,    -1,    -1,
      -1,    -1,  2976,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    71,    -1,    -1,  1578,    -1,    -1,    -1,    -1,
      -1,   370,    -1,    -1,  1755,   374,    -1,   376,    -1,  3003,
      -1,   497,  1763,   382,    -1,   384,  1767,    -1,  1769,  1770,
    1771,  1772,  3016,    -1,   103,    -1,    -1,  1778,    -1,   108,
    1613,    -1,    -1,  1784,    -1,  1786,    -1,    -1,    -1,    -1,
      -1,   410,   411,    -1,    -1,    -1,   415,    -1,    -1,    -1,
      -1,    -1,  1635,    -1,   423,    -1,    -1,    -1,    -1,   428,
    1811,  1812,    -1,    -1,  1815,  1816,    -1,    -1,    -1,   438,
    1821,    -1,    -1,  1824,  1825,    -1,  1827,    -1,  1829,    -1,
      -1,   450,    -1,  1834,    -1,  1836,  1837,    71,    -1,    -1,
    1841,  1842,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1856,  1857,    -1,    -1,    -1,
      -1,  1694,    -1,    -1,    -1,    -1,   195,    -1,    -1,   103,
      -1,    -1,  1873,    -1,   108,    -1,    -1,  1878,  1711,    -1,
    1881,  1882,    -1,    -1,  1885,    -1,    -1,    -1,    -1,    -1,
    1891,    -1,    -1,    -1,    -1,    -1,  1729,    -1,    -1,    -1,
      -1,   230,    -1,    -1,    -1,   234,    -1,    -1,  1909,  1910,
      -1,  3934,  1913,    -1,    -1,    -1,  3939,  3940,    -1,    -1,
      -1,  1754,    -1,    -1,    -1,   254,   255,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     269,    -1,    -1,    -1,    -1,    -1,  1947,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   195,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   305,  1810,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  4010,    -1,  4012,
     319,    -1,    -1,    -1,    -1,    -1,   230,    -1,    -1,   117,
     234,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2018,    -1,    -1,
     254,   255,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   269,  4059,    -1,    -1,    -1,
      -1,    -1,   160,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3294,    -1,    -1,    -1,    -1,  3299,    -1,  3301,  3302,  3303,
    3304,    -1,   391,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   305,    -1,    -1,    -1,    -1,    -1,  2078,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   319,    -1,    -1,    -1,   207,
      -1,    -1,    -1,  4116,    -1,    -1,   214,    -1,   216,    -1,
      -1,    -1,  4125,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     228,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3363,
    3364,  3365,    -1,  3367,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  4155,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2145,    -1,    -1,  1980,    -1,    -1,
      -1,    -1,   481,    -1,    -1,    -1,  2157,   391,    -1,   488,
     489,   490,   491,   492,   493,    71,    -1,    -1,  2169,  2170,
      -1,    -1,  2173,  2174,  2175,    -1,    -1,    -1,  2179,    -1,
      -1,    -1,    -1,    -1,  2185,    -1,    -1,  2188,    -1,    95,
    2191,    -1,    -1,    -1,    -1,  2196,  2197,   103,    -1,    -1,
      -1,  2202,   108,    -1,    -1,  3449,    71,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2219,  2220,
      -1,    -1,  2223,  2224,  2225,  2226,  2227,  2228,  2229,    -1,
      95,  2232,  2233,    -1,    -1,  2236,  2237,    -1,   103,  2240,
      -1,    -1,    -1,   108,  2245,  2246,    -1,   481,    -1,    -1,
    2251,    -1,  2253,  2254,   488,   489,   490,   491,   492,   493,
      -1,    -1,  2263,  2264,    -1,  2266,    -1,    -1,    -1,    -1,
    2271,    -1,    -1,    -1,  2275,  2276,  2277,  2278,  2279,    -1,
      -1,    -1,    -1,    -1,  2285,  2286,  2287,    -1,    -1,    -1,
      -1,  2292,    -1,  2294,  2295,    -1,  1200,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2307,    -1,    -1,    -1,
      -1,    -1,    -1,  2314,  2315,  2316,  2317,  2318,  2319,    -1,
      -1,    -1,    -1,    -1,   230,    -1,    -1,    -1,   234,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2347,    -1,   254,   255,
      -1,    -1,    -1,    -1,  2355,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   269,    -1,   230,  3610,    -1,    -1,   234,
      -1,    -1,    -1,    -1,    -1,    -1,  2209,  3621,  2379,    -1,
      -1,  2214,  2215,    -1,    -1,  2386,    -1,    -1,    -1,   254,
     255,    -1,    -1,    -1,    -1,  2396,   302,    -1,    -1,   305,
      -1,    -1,    -1,  2404,   269,    -1,    -1,  2408,  2409,    -1,
      -1,    -1,    -1,   319,    71,    -1,   322,    -1,    -1,  1323,
      -1,    -1,    -1,    -1,  2425,  2426,  2427,  2428,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   302,    95,    -1,
     305,  2442,    -1,    -1,    -1,    -1,   103,    -1,    -1,    -1,
      -1,   108,    -1,    -1,   319,  2456,    -1,   322,    -1,    -1,
    2461,    -1,    -1,    -1,  2465,    -1,    -1,    -1,    -1,    -1,
    3714,    -1,  2473,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   391,    -1,    -1,  3732,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2497,    -1,  2331,    -1,
    2501,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   391,    -1,    -1,    71,
      -1,    -1,    -1,    -1,  3778,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    95,    -1,    -1,    -1,    -1,    -1,  1463,
    2393,   103,    -1,    -1,    -1,    -1,   108,    -1,    -1,    -1,
      -1,    -1,    -1,   230,  2575,   481,    -1,   234,   484,   485,
     486,    -1,   488,   489,   490,   491,   492,   493,    -1,    -1,
      -1,    -1,   498,    -1,    -1,    -1,    -1,   254,   255,    -1,
      -1,    -1,    -1,  2604,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   269,    -1,    -1,    -1,   481,    -1,    -1,   484,
     485,   486,    -1,   488,   489,   490,   491,   492,   493,    -1,
      -1,    -1,    -1,   498,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   302,    -1,    -1,   305,    -1,
    2651,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2491,    -1,
      -1,  2662,   319,    -1,    -1,   322,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1578,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   800,    -1,    -1,    -1,    -1,    -1,   230,    -1,
     808,    -1,   234,    -1,    -1,   813,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1613,
      -1,    -1,   254,   255,    -1,  2716,  2717,  2718,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   843,    -1,   269,    -1,    -1,
    2731,  1635,    -1,    -1,   391,    -1,    -1,    -1,    -1,  2740,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     302,    -1,    -1,   305,    -1,    -1,    -1,    -1,    -1,    71,
      -1,  2772,  2773,  2774,  2775,   893,    -1,   319,    -1,    -1,
     322,    -1,   900,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1694,    -1,    -1,    95,    -1,    -1,  2797,    -1,  2799,    -1,
      -1,   103,    -1,    -1,    -1,    -1,   108,  1711,    -1,    -1,
      -1,    -1,    -1,    -1,  2815,    -1,    -1,    -1,  2819,    -1,
      -1,    -1,    -1,    -1,   481,  1729,    -1,   484,   485,   486,
      -1,   488,   489,   490,   491,   492,   493,    -1,    -1,    -1,
      -1,   498,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   391,
    1754,    -1,    -1,    -1,    -1,    -1,    -1,  2858,    -1,    -1,
      -1,  2862,  2863,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    4114,  2872,  2873,    -1,    -1,    -1,    -1,    -1,   996,    -1,
      -1,    -1,    -1,    -1,  1002,    -1,    -1,    -1,  1006,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2899,    -1,
      -1,    -1,    -1,    71,    -1,    -1,  1810,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1035,    -1,    -1,
    2753,  2754,    -1,  2756,    -1,    -1,    -1,    95,   230,    -1,
    2763,    -1,   234,    -1,    -1,   103,    -1,  2938,  2939,   481,
     108,    -1,   484,   485,   486,    -1,   488,   489,   490,   491,
     492,   493,   254,   255,    -1,  2956,   498,    -1,    -1,    -1,
      -1,  2794,    -1,  2796,  2965,    -1,    -1,   269,    -1,    -1,
      -1,    -1,  2973,    -1,    -1,  2976,  2977,    -1,    -1,  2980,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2993,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     302,    -1,  3003,   305,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3016,  3017,   319,    -1,    -1,
     322,    -1,    -1,    -1,    -1,    -1,  3027,    -1,    -1,  3030,
      -1,    -1,    -1,    -1,    -1,  2868,  3037,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3049,    -1,
      -1,  3052,    -1,    -1,  1172,    -1,    -1,    -1,    -1,    -1,
    2893,  1179,   230,    -1,    -1,    -1,   234,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1980,    -1,    -1,    -1,
      -1,    -1,  1200,    88,    -1,    -1,   254,   255,  2921,   391,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   269,    -1,    -1,  2937,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1230,    -1,    -1,   120,    -1,    -1,  2951,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   133,    -1,
      -1,    -1,    -1,  2966,   302,   140,    -1,   305,    -1,   144,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   319,    -1,    -1,   322,    -1,    -1,    -1,    -1,   164,
      -1,    -1,    -1,    -1,    -1,    -1,  3167,    -1,    -1,  3002,
      -1,    -1,  1290,    -1,    -1,    -1,    -1,    -1,    -1,   481,
     185,    -1,   484,   485,   486,    -1,   488,   489,   490,   491,
     492,   493,    -1,    -1,    -1,    -1,   498,  3198,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1323,    -1,    -1,    -1,    -1,
      -1,    -1,   217,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   391,    -1,    -1,    -1,  1345,    -1,    -1,
    3063,    -1,   237,  3234,  3235,    -1,    71,    -1,  3239,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3082,
      -1,    -1,    -1,    -1,    -1,  1373,   261,    -1,    -1,    -1,
      95,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   103,    -1,
      -1,    -1,    -1,   108,  3107,    -1,    -1,  3278,  3279,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1404,  1405,    -1,  1407,
      -1,    -1,    -1,  3294,    -1,    -1,    -1,  3298,  3299,  3300,
    3301,  3302,  3303,  3304,    -1,  2209,  1424,    -1,  3141,    -1,
    2214,  2215,    -1,   481,   319,    -1,   484,   485,   486,    -1,
     488,   489,   490,   491,   492,   493,    -1,    -1,    -1,    -1,
     498,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   346,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3350,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1476,  1477,
      -1,    -1,  3363,  3364,  3365,   370,  3367,    -1,    -1,   374,
      -1,   376,    -1,    -1,    -1,    -1,    -1,   382,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1503,    -1,    -1,    -1,  1507,
    1508,    -1,  3393,    -1,    -1,   230,    -1,  3398,    -1,   234,
    3401,    -1,  3403,    -1,    -1,   410,   411,    -1,    -1,    -1,
     415,    -1,  3413,    -1,    -1,    -1,    -1,    -1,   423,   254,
     255,    -1,    -1,   428,    -1,    -1,    -1,  2331,    -1,    -1,
    3263,  3432,    -1,  3434,   269,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3445,   450,  3447,    -1,  3449,    -1,
      -1,    -1,    -1,  3454,    -1,  3456,    -1,    -1,    -1,    -1,
    1578,    -1,    -1,    -1,  1582,    -1,    -1,   302,  1586,  3470,
     305,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   319,    -1,    -1,   322,  1606,  2393,
      -1,    -1,    -1,    -1,    -1,  1613,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    71,    72,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    80,    -1,  1635,    -1,    -1,
      -1,  1639,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      95,    -1,    -1,    98,    -1,    -1,    -1,    -1,   103,    -1,
      -1,    -1,    -1,   108,    -1,    -1,    -1,    -1,  3381,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   391,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3565,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1694,    -1,  3579,    -1,
      -1,    -1,    -1,  3416,    -1,    -1,    -1,  2491,    -1,    -1,
      -1,    -1,    -1,  1711,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3604,    -1,    -1,    -1,    -1,  3609,  3610,
      -1,  1729,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3620,
    3621,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3633,  3634,  3635,  3636,  1754,    -1,    -1,    -1,
      -1,  1759,    -1,    -1,    -1,    -1,   481,    -1,    -1,   484,
     485,   486,    -1,   488,   489,   490,   491,   492,   493,    -1,
      -1,  3662,    -1,   498,    -1,   230,    -1,    -1,    -1,   234,
      -1,    -1,    -1,    -1,    -1,  3676,  3677,  3678,  3679,  3680,
      -1,    -1,    -1,    -1,  1802,    -1,  1804,    -1,    -1,   254,
     255,    -1,  1810,    -1,    -1,  1813,    -1,  3530,    -1,    -1,
      -1,    -1,    -1,    -1,   269,    -1,    -1,    -1,  3541,    -1,
      -1,    -1,    -1,  3714,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3732,    -1,    -1,    -1,    -1,    -1,   302,    -1,  3740,
     305,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3753,    -1,   319,  3756,    -1,   322,    -1,    -1,
      -1,    -1,  1880,    -1,    -1,  3766,    -1,    -1,    -1,    -1,
      -1,    -1,  3605,    -1,    -1,    -1,    -1,  3778,  3779,    -1,
    3613,    -1,    -1,  3784,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1915,  1916,    -1,
      -1,    -1,    -1,    -1,    -1,  1923,    -1,    -1,  1926,    -1,
      -1,  1929,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1937,
    1938,    -1,    -1,    -1,    -1,    -1,   391,  1945,    -1,    -1,
    1948,  1949,  1950,  1951,    -1,    -1,    -1,    -1,    -1,    -1,
    1958,  1959,    -1,  1961,    -1,  1963,    -1,    -1,  1966,  2753,
    2754,    -1,  2756,    -1,    -1,    -1,    -1,  3858,    -1,  2763,
      -1,    -1,  1980,  1981,  1982,    -1,    -1,  1985,    -1,    -1,
      -1,  1989,    -1,    -1,    -1,  1993,    -1,  3878,  1996,  1997,
    1998,  1999,  2000,  2001,  2002,  2003,  2004,    -1,  2006,    -1,
    2794,    -1,  2796,    -1,  2012,    -1,    -1,    -1,  2016,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3909,    -1,
    3911,   476,  3745,    -1,    -1,    -1,   481,    -1,    -1,   484,
     485,   486,    -1,   488,   489,   490,   491,   492,   493,    -1,
      -1,    -1,    -1,  3934,  3935,  3768,    -1,    -1,  3939,  3940,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3953,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3793,    -1,    -1,    -1,  2868,    -1,    71,    -1,    -1,  2087,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3986,    -1,    -1,    -1,  2893,
      95,    -1,    -1,    -1,    99,    -1,    -1,    -1,   103,    -1,
      -1,    -1,    -1,   108,    -1,    -1,    -1,    -1,  4009,  4010,
    4011,  4012,  4013,    -1,    -1,   147,    -1,  2921,    -1,    -1,
      -1,  3854,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2937,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2951,    -1,    -1,
      -1,    -1,    -1,    -1,  2172,    -1,    -1,  4058,  4059,    -1,
      -1,    -1,  2966,    -1,   196,    -1,    -1,    -1,    -1,    -1,
      -1,  2189,    -1,   178,   206,    -1,    -1,    -1,   210,    71,
      -1,    -1,    -1,   215,    -1,    -1,    -1,   219,    -1,    -1,
     222,  2209,   224,    -1,    -1,    -1,  2214,  2215,  3002,    -1,
      -1,    -1,    -1,    95,    -1,    -1,    -1,    -1,    -1,  3942,
      -1,   103,    -1,  4114,    -1,  4116,   108,    -1,   250,    -1,
    2238,    -1,    -1,    -1,  4125,   230,    -1,    -1,    -1,   234,
      -1,    -1,    -1,    -1,    -1,    -1,  3969,  4138,   270,    -1,
      -1,    -1,    -1,  4144,    -1,    -1,    -1,    -1,    -1,   254,
     255,    -1,  2270,    -1,  4155,    -1,    -1,    -1,    -1,  3063,
      -1,    -1,    -1,    -1,   269,  4166,    -1,    -1,    -1,  4002,
      71,    -1,    -1,  4006,  4007,    -1,    -1,    -1,  3082,    -1,
      -1,    -1,   314,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   323,    -1,    -1,    95,    -1,    -1,   302,    -1,    -1,
     305,    -1,   103,  3107,    -1,    -1,    -1,   108,    -1,    -1,
      -1,  2329,    -1,  2331,   319,    -1,    -1,   322,   210,    -1,
      -1,  4222,    -1,   215,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  4065,    -1,   366,    -1,    -1,  3141,   230,    -1,
      -1,    -1,   234,    -1,    -1,    -1,  4247,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   207,   254,   255,    -1,    -1,    -1,    -1,   214,    -1,
     216,    -1,    -1,    -1,    -1,  2393,    -1,   269,   410,    -1,
      -1,    -1,    -1,    -1,    -1,  2403,   391,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2413,    -1,    -1,    -1,    -1,
     432,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     302,    -1,    -1,   305,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   453,    -1,   455,   456,    -1,    -1,   319,    -1,   230,
     322,    -1,  2450,   234,   439,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   254,   255,    -1,    -1,    -1,    -1,  3263,
      -1,    -1,  2480,   495,    -1,    -1,   498,   499,   269,   501,
      -1,    71,    -1,  2491,    -1,    -1,   481,    -1,    -1,   484,
     485,   486,    -1,   488,   489,   490,   491,   492,   493,    -1,
      -1,    -1,  2510,  2511,    -1,    95,    -1,    -1,    -1,   391,
      -1,   302,    -1,   103,   305,    -1,    -1,    -1,   108,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   319,    -1,
      -1,   322,  2540,  2541,    -1,    -1,    -1,  2545,    -1,    -1,
      -1,    -1,    -1,    -1,   335,    -1,    -1,    -1,    -1,  2557,
    2558,  2559,  2560,    -1,    -1,    -1,    -1,  2565,    -1,    -1,
      -1,  2569,  2570,    -1,  2572,    -1,  2574,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2584,  2585,    -1,  2587,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3381,    -1,    -1,
      -1,    -1,  2600,    -1,  2602,    -1,    -1,    -1,  2606,   481,
     391,    -1,   484,   485,   486,    -1,   488,   489,   490,   491,
     492,   493,    -1,    -1,  2622,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3416,    -1,    -1,  2633,    -1,  2635,  2636,  2637,
      -1,    -1,    -1,    -1,    -1,  1200,    -1,    -1,    -1,    -1,
     230,    -1,    -1,    -1,   234,    -1,    -1,  2655,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2664,    -1,    -1,    -1,
      86,    -1,    -1,  2671,   254,   255,    -1,    -1,  2676,    -1,
      -1,    -1,    -1,    -1,    -1,  2683,  2684,  2685,    -1,   269,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     481,    -1,    -1,   484,   485,   486,    -1,   488,   489,   490,
     491,   492,   493,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   302,   139,    -1,   305,    -1,    -1,    -1,  2727,
      -1,    -1,   148,   149,   150,    -1,    -1,    -1,    -1,   319,
      -1,    -1,   322,    -1,    -1,    -1,  3530,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2753,  2754,  3541,  2756,    -1,
     340,    -1,    -1,    -1,    -1,  2763,    -1,    -1,  1323,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   192,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    71,    -1,    -1,  2794,    -1,  2796,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   391,    -1,    -1,    -1,    -1,    -1,    95,   234,    -1,
      98,  3605,    -1,   239,   404,   103,    -1,    -1,    -1,  3613,
     108,    -1,  2830,  2831,  2832,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   278,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2868,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   295,
     296,   297,   298,   299,    -1,   301,    -1,    -1,   221,    -1,
      -1,    -1,    -1,    -1,    -1,  2893,    -1,   230,    -1,    -1,
      -1,   481,    -1,    -1,   484,   485,   486,    -1,   488,   489,
     490,   491,   492,   493,    -1,    -1,    -1,    -1,   334,    -1,
      -1,    -1,  2920,  2921,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2937,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   230,  2951,   370,    -1,   234,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2966,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   254,   255,    -1,    -1,
      -1,    -1,   808,    -1,  3768,  2983,    -1,   813,    -1,  2987,
     406,   269,   408,    -1,    -1,    -1,    -1,    -1,    -1,  2997,
      -1,    -1,    -1,    -1,  3002,    -1,    -1,    -1,    -1,  3793,
      -1,    -1,    -1,    -1,    -1,   431,    -1,   843,    -1,    -1,
      -1,    -1,   438,  1578,   302,   441,    -1,   305,    -1,    -1,
      -1,  3029,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   319,    -1,    -1,   322,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1613,    -1,
      -1,    -1,  3060,    -1,    -1,  3063,    -1,   893,    -1,    -1,
    3854,  3069,    -1,    -1,   900,    -1,    -1,  3075,    -1,  3077,
    1635,    -1,    -1,    -1,  3082,  3083,    -1,    -1,  3086,  3087,
    3088,  3089,  3090,  3091,  3092,  3093,  3094,  3095,    -1,    -1,
      -1,  3099,  3100,    -1,    -1,    -1,    -1,    -1,    -1,  3107,
      -1,    -1,    -1,   391,  3112,    -1,    -1,    -1,  3116,    -1,
    3118,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3128,    -1,    -1,  3131,    -1,  3133,    -1,    -1,    -1,  1694,
      -1,    -1,    -1,  3141,  3142,  3143,  3144,    -1,    -1,    -1,
    3148,    -1,    -1,  3151,    -1,    -1,  1711,    -1,  3942,    -1,
      -1,    -1,    -1,  3161,    -1,    -1,    -1,    -1,    -1,    -1,
     996,    -1,  3170,    -1,  1729,    -1,  1002,    -1,    -1,    -1,
    1006,    -1,    -1,    -1,    -1,  3969,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1754,
      -1,    -1,    -1,   481,    -1,    -1,   484,   485,   486,  1035,
     488,   489,   490,   491,   492,   493,    -1,    -1,  4002,    -1,
      -1,    -1,  4006,  4007,    -1,    71,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,
      -1,    -1,    98,    -1,    -1,  1810,    -1,   103,    -1,    -1,
      -1,    -1,   108,    -1,  3262,  3263,  3264,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3291,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1172,    -1,    -1,    -1,
      -1,    -1,    -1,  1179,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3368,    -1,    -1,    -1,  1200,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3381,   230,    -1,    -1,    -1,   234,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1230,    -1,    -1,    -1,   254,   255,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3416,  3417,
    3418,    -1,    -1,   269,    -1,  1980,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3436,    -1,
      -1,    -1,    -1,  3441,    -1,  1200,  3444,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   302,    -1,    -1,   305,
      -1,    -1,    -1,    -1,  1290,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   319,    -1,   808,   322,    -1,    -1,    -1,
     813,    -1,   815,    -1,    -1,    -1,  3484,   820,    -1,   822,
      -1,    -1,    -1,    -1,    -1,   828,    -1,  1323,    -1,    -1,
      -1,    -1,    71,   836,    -1,    -1,    -1,    -1,   841,    -1,
     843,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1345,
      -1,    -1,  3520,    -1,    -1,    -1,    95,    -1,    -1,  3527,
    3528,    -1,  3530,    71,   103,    -1,    -1,  3535,  3536,   108,
      -1,    -1,  3540,  3541,    -1,   391,    -1,  1373,  3546,  3547,
      -1,    -1,  3550,    -1,    -1,   888,    -1,    95,    -1,    -1,
     893,    -1,    -1,    -1,    -1,   103,    -1,   900,  1323,    -1,
     108,    -1,  3570,    -1,    -1,    -1,    -1,    -1,  1404,  1405,
      -1,  1407,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1424,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3605,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3613,    -1,    -1,    -1,    -1,
      -1,   954,    -1,    -1,    -1,    -1,   959,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   481,    -1,   970,   484,   485,
     486,    -1,   488,   489,   490,   491,   492,   493,    -1,    -1,
    1476,    -1,    -1,    -1,  2209,    -1,    -1,    -1,    -1,  2214,
    2215,   230,    -1,    -1,    -1,   234,    -1,    -1,  1001,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1503,    -1,    -1,
      -1,  1507,  1508,    -1,    -1,   254,   255,  1020,    -1,    -1,
      -1,    -1,   230,  1026,    -1,    -1,   234,    -1,    -1,    -1,
     269,    -1,  3700,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1044,  3710,    -1,    -1,    -1,   254,   255,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   269,    -1,   302,    -1,    -1,   305,    -1,    -1,    -1,
      -1,    -1,  3740,    -1,    -1,    -1,    -1,  3745,    -1,    -1,
     319,    -1,  1578,   322,    -1,    -1,    -1,    -1,    -1,    -1,
    1586,  3759,    -1,    -1,   302,  3763,    -1,   305,    -1,    -1,
    3768,    -1,    -1,    -1,    -1,    -1,  2331,    -1,    -1,    -1,
    1606,   319,    -1,    -1,   322,    -1,    -1,  1613,    -1,    -1,
      -1,  3789,    -1,    -1,    -1,  3793,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1635,
      -1,    -1,    -1,  1639,    -1,  3813,  3814,    -1,    -1,  3817,
      -1,    -1,   391,  1578,    -1,    -1,  3824,  3825,    -1,    -1,
      71,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2393,  1172,
      -1,    -1,    -1,    -1,    -1,    -1,  1179,   416,    -1,    -1,
      -1,    -1,    -1,   391,    95,    -1,  3854,    98,  1613,  3857,
      -1,    -1,   103,    -1,    -1,    -1,    -1,   108,  1694,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1635,    -1,    -1,    -1,    -1,  1711,    -1,    -1,    -1,    -1,
    3888,  1224,  1225,  1226,    -1,    -1,    -1,  1230,    -1,    -1,
      -1,    -1,    -1,  1729,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   481,    -1,    -1,   484,   485,   486,    -1,   488,
     489,   490,   491,   492,   493,    -1,    -1,    -1,  1754,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2491,  3935,  3936,  1694,
      -1,    -1,    -1,   481,  3942,    -1,   484,   485,   486,    -1,
     488,   489,   490,   491,   492,   493,  1711,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3968,  3969,    -1,  3971,  1729,  3973,  1802,    -1,  1804,    -1,
    1313,    -1,    -1,    -1,  1810,    -1,    -1,  1813,    -1,   230,
      -1,    -1,    -1,   234,    -1,    -1,    -1,    -1,    -1,  1754,
      -1,  3999,    -1,  1336,  4002,    -1,    -1,    -1,  4006,  4007,
      -1,    -1,    -1,   254,   255,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   269,    -1,
      -1,    -1,  4030,    -1,    -1,    -1,    -1,    -1,    -1,  4037,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1880,  1810,    -1,    -1,    -1,    -1,
    4058,   302,    -1,    -1,   305,    -1,    -1,  4065,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   319,    -1,
      -1,   322,    -1,    -1,    -1,  4083,    -1,    -1,    -1,  1915,
    1916,    -1,    -1,    -1,    -1,    -1,    -1,  1923,    -1,    -1,
    1926,    -1,    -1,  1929,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1937,  1938,    -1,    -1,    -1,    -1,    -1,    -1,  1945,
      71,    -1,  1948,  1949,  1950,  1951,    -1,    -1,    -1,    -1,
      -1,    -1,  1958,  1959,    -1,  1961,    -1,  1963,    -1,    -1,
    1966,  1474,    -1,    -1,    95,    -1,    -1,    98,    -1,    -1,
     391,    -1,   103,  4151,  1980,  1981,    -1,   108,    -1,  1985,
      -1,    -1,    -1,  1989,    -1,    -1,    -1,  1993,    -1,    -1,
    1996,  1997,  1998,  1999,  2000,  2001,  2002,  2003,  2004,    -1,
    2006,    -1,    -1,    -1,    -1,    -1,  2012,    -1,    -1,    -1,
    2016,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2753,  2754,
      -1,  2756,    -1,    -1,    -1,    -1,    -1,    -1,  2763,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1980,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  4236,  2794,
     481,  2796,    -1,   484,   485,   486,    -1,   488,   489,   490,
     491,   492,   493,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2087,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    88,    -1,    -1,    -1,    -1,    -1,   230,
      -1,    -1,    -1,   234,    -1,   100,    -1,    -1,    -1,    -1,
      -1,    -1,  1625,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   254,   255,   120,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2868,    -1,    -1,    -1,    -1,   269,    -1,
      -1,    -1,    -1,    -1,    -1,   140,    -1,    -1,    -1,   144,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2893,  1672,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   164,
      -1,   302,    -1,    -1,   305,   170,    -1,    -1,    -1,  1692,
      -1,    -1,    -1,  2189,    -1,    -1,  2921,    -1,   319,    -1,
     185,   322,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2937,  2209,    -1,    -1,    -1,    -1,  2214,  2215,
      -1,    -1,    -1,    -1,    -1,    -1,  2951,   212,    -1,    -1,
      -1,    -1,   217,   218,    -1,    -1,    -1,   222,    -1,    -1,
      -1,  2966,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   237,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     391,    -1,    -1,    -1,    -1,   260,    -1,  3002,    -1,    -1,
      -1,    -1,    -1,    -1,  2209,    -1,    -1,    -1,   273,  2214,
    2215,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1802,
      -1,  1804,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1813,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1826,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1835,  2329,   319,  2331,    -1,   322,  3063,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3082,    -1,    -1,
     481,   346,    -1,   484,   485,   486,    -1,   488,   489,   490,
     491,   492,   493,    -1,    -1,    -1,    -1,  1880,    -1,    -1,
    1883,  1884,  3107,    -1,    -1,   370,    -1,    -1,    -1,   374,
      -1,   376,  1895,    -1,    -1,    -1,    -1,  2393,    -1,   384,
      -1,    -1,    -1,    -1,    -1,    -1,  2331,  2403,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3141,  2413,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   411,   412,    -1,   414,
     415,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   423,    -1,
      -1,    -1,   427,   428,    -1,    -1,    -1,    -1,   433,    -1,
      -1,    -1,    -1,   438,  2450,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2393,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2480,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2491,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2011,    -1,
      -1,    -1,    -1,    -1,  2510,  2511,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2036,    -1,    -1,    -1,    -1,  3263,    -1,
      -1,    -1,    -1,    -1,  2540,  2541,    -1,    -1,    -1,  2545,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2557,  2558,  2559,  2560,    -1,  2491,    -1,    -1,    -1,
      -1,    -1,    -1,  2569,    -1,    -1,  2572,    -1,  2574,    -1,
      -1,    -1,  2085,    -1,    -1,    -1,    -1,    -1,  2584,  2585,
      -1,  2587,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2600,    -1,  2602,    -1,    -1,    -1,
    2606,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2622,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2633,    -1,  2635,
    2636,  2637,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3381,    -1,    -1,  2655,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2664,    -1,
      -1,    -1,    -1,    -1,    -1,  2671,    -1,    -1,    -1,    -1,
    2676,    -1,    -1,    -1,    -1,    -1,    -1,  2683,  2684,  2685,
      -1,  3416,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2727,  2235,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2753,  2754,    -1,
    2756,    -1,    -1,    -1,    -1,    -1,    -1,  2763,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1200,    -1,    -1,  2794,    -1,
    2796,    -1,    -1,    -1,    -1,  3530,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3541,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2753,  2754,
      -1,  2756,    -1,    -1,    -1,    -1,    -1,    -1,  2763,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2351,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2794,
      -1,  2796,  2868,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3605,    -1,  2385,    -1,    -1,    -1,    -1,    -1,  3613,  2392,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2893,    -1,    -1,
    2403,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1323,    -1,
      -1,    -1,    -1,    -1,    -1,  2921,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2937,    -1,  2868,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2951,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2893,    -1,
    2966,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2983,    -1,    -1,
      -1,  2987,    -1,    -1,    -1,    -1,  2921,    -1,    -1,    -1,
      -1,  2997,    -1,    -1,    -1,    -1,  3002,    -1,    -1,    -1,
      -1,    -1,  2937,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   808,    -1,    -1,    -1,  2951,   813,    -1,    -1,
      -1,    -1,    -1,  3029,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2966,    -1,  3768,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   843,    -1,    -1,
      -1,    -1,    -1,    -1,  3060,    -1,    -1,  3063,  3793,    -1,
      -1,    -1,    -1,  3069,    -1,    -1,    -1,  3002,    -1,  3075,
      -1,  3077,    -1,    -1,    -1,    -1,  3082,  3083,    -1,    -1,
    3086,  3087,  3088,  3089,  3090,  3091,  3092,  3093,  3094,  3095,
      -1,    -1,    -1,  3099,  3100,    -1,    -1,   893,    -1,    -1,
      -1,  3107,    -1,    -1,   900,    -1,  3112,    -1,    -1,    -1,
      -1,    -1,  3118,    -1,  2627,    -1,    -1,    -1,    -1,  3854,
    2633,    -1,  3128,    -1,    -1,  3131,    -1,  3133,  3063,    -1,
      -1,    -1,    -1,    -1,    -1,  3141,  3142,  3143,  3144,    -1,
      -1,    -1,  3148,    -1,    -1,  3151,    -1,  3082,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3161,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1578,  3170,    -1,    -1,  2680,    -1,    -1,
      -1,    -1,  3107,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1613,    -1,
     996,    -1,    -1,    -1,    -1,    -1,  3141,  3942,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1635,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3969,    -1,    -1,    -1,    -1,  1035,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3263,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  4002,    -1,    -1,
      -1,  4006,  4007,    -1,    -1,    -1,    -1,    -1,    -1,  1694,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1711,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1729,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3263,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1754,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3368,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3381,  1172,    -1,    -1,    -1,
      -1,    -1,    -1,  1179,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1810,    -1,    -1,    -1,    -1,
      -1,   996,    -1,    -1,  1200,    -1,    -1,    -1,    -1,    -1,
    3416,  3417,  3418,    -1,    -1,    -1,    -1,    -1,    -1,  2932,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2942,
    3436,    -1,    -1,    -1,  1230,  3441,    -1,    -1,  3444,    -1,
    1035,    -1,    -1,    -1,    -1,  2958,  3381,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2983,    -1,    -1,    -1,  2987,    -1,    -1,    -1,  3484,    -1,
      -1,  3416,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1290,    -1,    -1,    -1,  3011,    -1,
      -1,  3014,    -1,    -1,    -1,    -1,    -1,    -1,  3021,    -1,
      -1,    -1,    -1,    -1,  3520,    -1,  3029,    -1,    -1,    -1,
      -1,  3527,  3528,    -1,  3530,    -1,    -1,  1323,    -1,  3535,
    3536,    -1,    -1,    -1,  3540,  3541,    -1,  3050,    -1,    -1,
    3546,  3547,    -1,    -1,  3550,    -1,    -1,    -1,    -1,  1345,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3570,  1980,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1373,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3530,    -1,    -1,    -1,  3605,
      -1,    -1,    -1,    -1,    -1,    -1,  3541,  3613,  1404,  1405,
      -1,  1407,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1424,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3158,  3159,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3605,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3613,    -1,
    1476,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3700,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1503,    -1,    -1,
      -1,  1507,  1508,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3740,    -1,    -1,    -1,    -1,  3745,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1345,    -1,    -1,  3759,    -1,    -1,    -1,  3763,    -1,    -1,
      -1,    -1,  3768,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1373,    -1,
      -1,    -1,  1578,  3789,    -1,    -1,    -1,  3793,    -1,    -1,
      -1,    -1,    -1,    -1,  2209,    -1,    -1,    -1,    -1,  2214,
    2215,    -1,    -1,    -1,    -1,    -1,    -1,  3813,  3814,  1404,
    1405,  3817,  1407,    -1,    -1,    -1,    -1,  1613,  3824,  3825,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1424,
      -1,    -1,    -1,  3768,    -1,    -1,    -1,    -1,    -1,  1635,
      -1,    -1,    -1,  3356,    -1,    -1,    -1,    -1,  3854,    -1,
      -1,  3857,    -1,    -1,    -1,    -1,    -1,    -1,  3793,    -1,
      -1,  3374,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3386,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1476,  3888,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1694,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1503,    -1,
      -1,    -1,  1507,  1508,    -1,  1711,  2331,    -1,    -1,  3854,
      -1,    -1,    -1,  3436,    -1,    -1,    -1,    -1,  3441,  3935,
    3936,  3444,    -1,  1729,    -1,    -1,  3942,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1754,    -1,
      -1,    -1,  3968,  3969,    -1,  3971,    -1,  3973,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2393,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3999,    -1,    -1,  4002,    -1,    -1,    -1,
    4006,  4007,    -1,    -1,    -1,    -1,  1802,  3942,  1804,    -1,
      -1,    -1,    -1,    -1,  1810,    -1,    -1,  1813,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  4037,    -1,    -1,  3969,    -1,    -1,    -1,    -1,  3552,
    3553,  3554,  3555,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  4058,    -1,    -1,    -1,    -1,    -1,    -1,  4065,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  4002,    -1,    -1,
      -1,  4006,  4007,    -1,    -1,    -1,  2491,  4083,    -1,    -1,
      -1,    -1,    -1,    -1,  1880,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1915,
    1916,    -1,    -1,    -1,    -1,    -1,    -1,  1923,    -1,    -1,
    1926,    -1,    -1,  1929,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1937,  1938,    -1,    -1,  4151,    -1,    -1,    -1,  1945,
      -1,    -1,  1948,  1949,  1950,  1951,    -1,    -1,    -1,    -1,
      -1,    -1,  1958,  1959,    -1,  1961,    -1,  1963,    -1,    -1,
    1966,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1980,  1981,    -1,    -1,    -1,  1985,
      -1,    -1,    -1,  1989,    -1,    -1,    -1,  1993,    -1,    -1,
    1996,  1997,  1998,  1999,  2000,  2001,  2002,  2003,  2004,    -1,
    2006,    -1,    -1,    -1,    -1,    -1,  2012,    -1,    -1,    -1,
    2016,    -1,    -1,    -1,    -1,    -1,    -1,  3740,    -1,    -1,
    4236,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3763,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2087,    -1,    -1,    -1,    -1,    -1,    -1,  1200,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1923,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2753,  2754,
      -1,  2756,    -1,    -1,  3857,    -1,    -1,    -1,  2763,    -1,
    1945,    -1,    -1,  1948,    -1,    -1,  1951,    -1,    -1,    -1,
      -1,    -1,    -1,  1958,  1959,    -1,    -1,    -1,  1963,    -1,
      -1,  1966,    -1,    -1,    -1,  3888,    -1,    -1,    -1,  2794,
      -1,  2796,    -1,    -1,  3897,    -1,  1981,    -1,    -1,    -1,
    1985,    -1,    -1,  2189,  1989,    -1,    -1,    -1,  1993,    -1,
      -1,  1996,  1997,  1998,  1999,  2000,  2001,  2002,  2003,  2004,
    3923,  2006,    -1,  2209,    -1,    -1,    -1,  2012,  2214,  2215,
      -1,  1323,  3935,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3947,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2868,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2893,    -1,
      -1,    -1,    -1,  3996,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2087,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2921,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2937,    -1,  4037,    -1,    -1,    -1,  1200,    -1,
      -1,    -1,    -1,  2329,    -1,  2331,  2951,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  4058,    -1,    -1,    -1,    -1,
      -1,  2966,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3002,    -1,    -1,
      -1,    -1,    -1,    -1,  2189,    -1,    -1,  2393,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2403,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2413,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  4151,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3063,    -1,
      -1,  1323,    -1,    -1,  2450,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3082,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1578,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2480,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3107,    -1,    -1,  2491,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1200,    -1,    -1,    -1,    -1,
      -1,  1613,    -1,    -1,  2510,  2511,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  4236,    -1,    -1,  3141,    -1,    -1,    -1,
      -1,    -1,    -1,  1635,  2329,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2540,  2541,    -1,    -1,    -1,  2545,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2557,  2558,  2559,  2560,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2569,    -1,    -1,  2572,    -1,  2574,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2584,  2585,
      -1,  2587,  1694,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2600,    -1,  2602,    -1,    -1,  1711,
    2606,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2413,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2622,  1729,  1323,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2633,    -1,  2635,
    2636,  2637,    -1,    -1,    -1,    -1,    -1,    -1,  3263,    -1,
      -1,    -1,  1754,    -1,    -1,  2450,    -1,    -1,    -1,  2655,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2664,    -1,
      -1,    -1,    -1,    -1,    -1,  2671,    -1,    -1,    -1,    -1,
    2676,    -1,    -1,    -1,    -1,  2480,    -1,  2683,  2684,  2685,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1578,    -1,  1810,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2511,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2727,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1613,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2753,  2754,    -1,
    2756,    -1,  2557,  1635,  2559,  2560,  3381,  2763,    -1,    -1,
      -1,    -1,    -1,    -1,  2569,    -1,    -1,  2572,    -1,  2574,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2794,    -1,
    2796,  3416,    -1,    -1,    -1,  2600,    -1,  2602,    -1,    -1,
      -1,  2606,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1694,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1711,
      -1,    -1,  2637,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1729,    -1,    -1,
    2655,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2664,
      -1,    -1,  2868,    -1,    -1,    -1,  2671,    -1,  1980,    -1,
      -1,  2676,  1754,  1578,    -1,    -1,    -1,    -1,  2683,  2684,
    2685,    -1,    -1,    -1,    -1,    -1,    -1,  2893,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3530,    -1,    -1,  1613,    -1,
      -1,    -1,    -1,    -1,    -1,  2921,  3541,    -1,    -1,    -1,
      -1,    -1,  2727,    -1,    -1,    -1,    -1,    -1,  1810,    -1,
    1635,  2937,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2951,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2966,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2983,    -1,    -1,
    3605,  2987,    -1,    -1,    -1,    -1,    -1,    -1,  3613,  1694,
      -1,  2997,    -1,    -1,    -1,    -1,  3002,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1711,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3029,  1729,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1754,
      -1,    -1,    -1,    -1,  3060,    -1,    -1,  3063,    -1,    -1,
      -1,    -1,    -1,  3069,    -1,    -1,    -1,    -1,    -1,  3075,
      -1,  3077,    -1,    -1,    -1,    -1,  3082,  3083,    -1,    -1,
    3086,  3087,  3088,  3089,  3090,  3091,  3092,  3093,  3094,  3095,
      -1,    -1,    -1,  3099,  3100,    -1,    -1,  2209,  1980,    -1,
      -1,  3107,  2214,  2215,    -1,  1810,  3112,    -1,    -1,    -1,
      -1,    -1,  3118,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3128,    -1,    -1,  3131,    -1,  3133,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3141,  3142,  3143,  3144,    -1,
      -1,    -1,  3148,  3768,    -1,  3151,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3161,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3170,    -1,    -1,    -1,  3793,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2331,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3854,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3060,    -1,  3263,    -1,    -1,
      -1,    -1,    -1,    -1,  3069,    -1,    -1,    -1,    -1,    -1,
    3075,    -1,  3077,    -1,    -1,  1980,    -1,    -1,    -1,    -1,
      -1,  2393,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3099,  3100,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3118,    -1,    -1,    -1,  3942,    -1,    -1,
      -1,    -1,    -1,  3128,    -1,    -1,  3131,  2209,  3133,    -1,
      -1,    -1,  2214,  2215,    -1,    -1,    -1,  3142,    -1,    -1,
      -1,    -1,    -1,  3148,  3969,    -1,  3151,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3161,    -1,    -1,    -1,
      -1,    -1,  3368,    -1,    -1,  3170,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3381,    -1,  4002,    -1,  2491,
      -1,  4006,  4007,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3416,  3417,  3418,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3436,    -1,  1420,    -1,    -1,  3441,    -1,    -1,  3444,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2331,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3484,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1489,    -1,    -1,  2209,    -1,    -1,    -1,    -1,  2214,
    2215,  2393,    -1,    -1,  3520,    -1,    -1,    -1,    -1,    -1,
      -1,  3527,  3528,    -1,  3530,    -1,    -1,    -1,    -1,  3535,
    3536,    -1,    -1,    -1,  3540,  3541,    -1,    -1,    -1,    -1,
    3546,  3547,    -1,    -1,  3550,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3570,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3605,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3613,    -1,  2491,
      -1,    -1,  3417,  3418,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2331,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2753,  2754,    -1,  2756,    -1,    -1,    -1,    -1,    -1,
      -1,  2763,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3484,
      -1,    -1,  2794,    -1,  2796,    -1,    -1,    -1,  2393,    -1,
      -1,    -1,    -1,    -1,  3700,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -