/***************************************************************************
 $RCSfile$
                             -------------------
    cvs         : $Id$
    begin       : Mon Mar 01 2004
    copyright   : (C) 2004 by Martin Preuss
    email       : martin@libchipcard.de

 ***************************************************************************
 *          Please see toplevel file COPYING for license details           *
 ***************************************************************************/


#ifdef HAVE_CONFIG_H
# include <config.h>
#endif


#include "editsto.h"
#include "kbanking.h"
#include "refpointer.h"
#include "selectpayee.h"
#include "payee.h"
#include <qbanking/qbselectbank.h>

#include <qcombobox.h>
#include <qtextedit.h>
#include <qlineedit.h>
#include <qregexp.h>
#include <qvalidator.h>
#include <qmessagebox.h>
#include <qlabel.h>
#include <qgroupbox.h>
#include <qlayout.h>
#include <qradiobutton.h>
#include <qdatetime.h>
#include <qdatetimeedit.h>
#include <qtimer.h>
#include <qpushbutton.h>

#include <list>
#include <string>

#include <gwenhywfar/debug.h>
#include <gwenhywfar/text.h>

#include <aqbanking/jobsingledebitnote.h>
#include <aqbanking/jobsingletransfer.h>
#include <aqbanking/jobcreatesto.h>
#include <aqbanking/jobmodifysto.h>
#include <aqbanking/jobdeletesto.h>


#ifdef WIN32
# define strcasecmp stricmp
#endif

#ifndef I18N_NOOP
# define I18N_NOOP(msg) msg
#endif


#define EDIT_STO_STRING_LAST_MINUS_2 I18N_NOOP("edit_sto|last-2")
#define EDIT_STO_STRING_LAST_MINUS_1 I18N_NOOP("edit_sto|last-1")
#define EDIT_STO_STRING_LAST I18N_NOOP("edit_sto|last")

#define EDIT_STO_STRING_SELECT I18N_NOOP("edit_sto|-- select --")


EditStandingOrder::EditStandingOrder(KBanking *app,
				     RefPointer<StandingOrder> t,
				     bool createMode,
				     QWidget* parent,
				     const char* name,
				     bool modal,
				     WFlags fl)
:EditStandingOrderUi(parent, name, modal, fl)
,_app(app)
,_isCreateMode(createMode)
,_allowChangePeriod(true)
,_allowChangeCycle(true)
,_allowChangeDay(true)
,_minDelay(0)
,_maxDelay(0)
,_transfer(t)
,_maxPurpose(1){
  int found;
  std::list<Account*>::const_iterator ait;
  int i;
  QString recipientName;
  QString s, cs;
  std::list<std::string>::const_iterator sit;
  const AB_VALUE *v;
  //QRegExp valueRx("^[0-9]{1,12}.[0-9]{1,2}$");
  QRegExp bankCodeRx(QString("^[0-9]{1,8}$"));
  //QValidator *valueValidator=new QRegExpValidator(valueRx, this);
  QValidator *bankCodeValidator=new QRegExpValidator(bankCodeRx, this);
  const GWEN_TIME *ti;

  QLayout *lo=layout();
  if (lo) {
    QSize csi;
    QSize nsi;

    csi=size();
    nsi=lo->sizeHint();
    if (csi.width()>nsi.width())
      nsi.setWidth(csi.width());
    if (csi.height()>nsi.height())
      nsi.setWidth(csi.height());
    DBG_ERROR(0, "Resizing dialog.");
    resize(nsi);
  }

  if (createMode)
    startDateEdit->setMinValue(QDate::currentDate());
  else {
    startDateLabel->hide();
    startDateEdit->hide();
  }

  /* set validators */
  //valueEdit->setValidator(valueValidator);
  remoteBankCodeEdit->setValidator(bankCodeValidator);
  //localAccountCombo->lineEdit()->
  // setValidator(new QRegExpValidator(QRegExp("^[0-9,A-Z,a-z]{1,12}$"),this));
  // -- unfortunately setting this on the localAccountCombo crashes
  // the dialog, therefore it is commented out for now

  remoteNameEdit->setMaxLength(27);

  remoteAccountIdEdit
    ->setText(QString::fromUtf8(t.ref().getRemoteAccountNumber().c_str()));
  remoteBankCodeEdit
    ->setText(QString::fromUtf8(t.ref().getRemoteBankCode().c_str()));

  remoteBankNameEdit
    ->setText(QString::fromUtf8(t.ref().getRemoteBankName().c_str()));
  remoteBankLocationEdit
    ->setText(QString::fromUtf8(t.ref().getRemoteBankLocation().c_str()));

  // set recipient name(s)
  for (sit=t.ref().getRemoteName().begin();
       sit!=t.ref().getRemoteName().end();
       sit++) {
    s=QString::fromUtf8(sit->c_str());
    if (!s.isEmpty()) {
      if (!recipientName.isEmpty())
        recipientName+=" ";
      recipientName+=s;
    }
  } // for
  remoteNameEdit->setText(recipientName);

  // setup account combo
  found=0;
  i=0;
  localAccountCombo->insertItem(_tr("Select Account"), -1);
  for (ait=app->getAppAccounts().begin();
       ait!=app->getAppAccounts().end();
       ait++) {
    i++;
    cs="";

    s=QString::fromUtf8((*ait)->getBankName().c_str());
    if (s.isEmpty())
      s=QString::fromUtf8((*ait)->getBankCode().c_str());
    cs+=s;
    cs+=" / ";
    s=QString::fromUtf8((*ait)->getAccountNumber().c_str());
    cs+=s;
    cs+=" - ";
    s=QString::fromUtf8((*ait)->getAccountName().c_str());
    cs+=s;
    cs+=" (";
    cs+=QString::number((*ait)->getBankingId());
    cs+=")";

    _setComboTextNoDup(localAccountCombo, cs);
    if ((strcasecmp((*ait)->getBankCode().c_str(),
                    t.ref().getLocalBankCode().c_str())==0) &&
        (strcasecmp((*ait)->getAccountNumber().c_str(),
		    t.ref().getLocalAccountNumber().c_str())==0))
      found=i;
  } // for
  localAccountCombo->setCurrentItem(found);
  slotAccountChanged(found);

  // setup purpose
  cs="";
  for (sit=t.ref().getPurpose().begin();
       sit!=t.ref().getPurpose().end();
       sit++) {
    i++;
    s=QString::fromUtf8(sit->c_str());
    if (!s.isEmpty()) {
      if (!cs.isEmpty())
        cs+="\n";
      cs+=s;
    }
  } // for
  purposeEdit->setText(cs);

  // set value
  v=t.ref().getValue();
  if (v) {
    const char *st;

    valueEdit->setText(QString::number(AB_Value_GetValueAsDouble(v), 'f', 2));
    st=AB_Value_GetCurrency(v);
    if (!st)
      st="EUR";
    _setComboTextNoDup(currencyCombo, QString::fromUtf8(st));
  }

  // set Text key
  _setComboTextNoDup(textKeyCombo, QString::number(t.ref().getTextKey()));

  // setup standing order specifica
  monthlyRadio->setChecked(false);
  weeklyRadio->setChecked(false);

  ti=_transfer.ref().getFirstExecutionDate();
  if (ti) {
    int days, months, year;

    GWEN_Time_GetBrokenDownUtcDate(ti, &days, &months, &year);
    startDateEdit->setDate(QDate(year, months+1, days));
  }
  else {
    startDateEdit->setDate(QDate::currentDate());
  }

  switch(t.ref().getPeriod()) {
  case AB_Transaction_PeriodWeekly:
    weeklyRadio->setChecked(true);
    i=t.ref().getExecutionDay();
    switch(i) {
    case 1: s=_tr("Monday"); break;
    case 2: s=_tr("Tuesday"); break;
    case 3: s=_tr("Wednesday"); break;
    case 4: s=_tr("Thursday"); break;
    case 5: s=_tr("Friday"); break;
    case 6: s=_tr("Saturday"); break;
    case 7: s=_tr("Sunday"); break;
    default: s=_tr("Monday"); break;
    }
    _setComboTextIfPossible(dayWeekCombo, s);

    s=QString::number(t.ref().getCycle());
    _setComboTextIfPossible(cycleWeekCombo, s);
    break;

  case AB_Transaction_PeriodMonthly:
    monthlyRadio->setChecked(true);
    i=t.ref().getExecutionDay();
    switch(i) {
    case 97: s=_tr(EDIT_STO_STRING_LAST_MINUS_2); break;
    case 98: s=_tr(EDIT_STO_STRING_LAST_MINUS_1); break;
    case 99: s=_tr(EDIT_STO_STRING_LAST); break;
    break;
    default:
      if (i>30)
	s="";
      else
	s=QString::number(i);
      break;
    }
    if (s.isEmpty())
      dayMonthCombo->setCurrentItem(0);
    else
      _setComboTextIfPossible(dayMonthCombo, s);

    s=QString::number(t.ref().getCycle());
    _setComboTextIfPossible(cycleMonthCombo, s);
    break;

  default:
    break;
  } // switch
  slotMonthlyToggled(monthlyRadio->isOn());


  // connect buttons
  QObject::connect(bankCodeButton, SIGNAL(clicked()),
                   this, SLOT(slotBankCode()));
  QObject::connect(payeeButton, SIGNAL(clicked()),
                   this, SLOT(slotGetPayee()));
  QObject::connect(bankCodeButton, SIGNAL(clicked()),
                   this, SLOT(slotGetBankCode()));

  QObject::connect(localAccountCombo, SIGNAL(activated(int)),
                   this, SLOT(slotAccountChanged(int)));

  QObject::connect(monthlyRadio, SIGNAL(toggled(bool)),
		   this, SLOT(slotMonthlyToggled(bool)));
  QObject::connect(weeklyRadio, SIGNAL(toggled(bool)),
		   this, SLOT(slotWeeklyToggled(bool)));

  if (_isCreateMode) {
    QObject::connect(dayMonthCombo, SIGNAL(activated(int)),
		     this, SLOT(slotAdjustStartDate(int)));
    QObject::connect(dayWeekCombo, SIGNAL(activated(int)),
		     this, SLOT(slotAdjustStartDate(int)));
  }


  QTimer::singleShot(0, this, SLOT(adjustSize()));

}



EditStandingOrder::~EditStandingOrder(){
}



void EditStandingOrder::_setComboTextNoDup(QComboBox *qb, const QString &s){
  int i;

  for (i=0; i<qb->count(); i++) {
    if (qb->text(i)==s)
      return;
  }
  qb->insertItem(s, -1);
}



void EditStandingOrder::_setComboTextIfPossible(QComboBox *qb,
						const QString &s){
  int i;

  for (i=0; i<qb->count(); i++) {
    if (qb->text(i)==s) {
      qb->setCurrentItem(i);
      break;
    }
  }
}






void EditStandingOrder::accept(){
  int pos;
  QString qs;
  std::list<Account*>::const_iterator ait;
  int i;
  Account *a;
  AB_VALUE *value;
  QCString utfData;
  QRegExp valueRx(QString("^[0-9]{1,12}.[0-9]{1,2}$"));
  QRegExpValidator qv(valueRx, this);
  QDate qd;
  GWEN_TIME *ti=0;

  pos=0;

  qs=valueEdit->text();
  if (qv.validate(qs, pos)!=
      QValidator::Acceptable) {
    QMessageBox::critical(this,
                          _tr("Bad Value"),
                          _tr("<qt>"
                             "<p>"
                             "The value needs to be in the following "
                             "format: "
                             "\"<b>XX,YY</b>\".<br>"
                             "<b>XX</b> are between 1 and 12 digits before "
                             "the comma, <b>YY</b> are 1 or 2 digits "
                             "after it"
                             "</p>"
                             "<p>"
                             "Examples:"
                             "<ul>"
                             "<li>123,45</li>"
                             "<li>0,12</li>"
                             "<li>123,00</li>"
                             "</ul>"
                             "</p>"
                             "<p>"
                             "Please correct the value."
                             "</p>"
                             "</qt>"
                            ),
                          _tr("Dismiss"), QString::null);
    return;
  }

  if (localAccountCombo->currentItem()==0) {
    QMessageBox::critical(this,
                          _tr("No Source Account"),
                          _tr("<qt>"
                             "<p>"
                             "Please select the source account."
                             "</p>"
                             "</qt>"
                            ),
                          _tr("Dismiss"), QString::null);
    return;
  }

  if (remoteNameEdit->text().isEmpty() ||
      remoteAccountIdEdit->text().isEmpty() ||
      remoteBankCodeEdit->text().isEmpty() ||
      purposeEdit->text().isEmpty()) {
    QMessageBox::critical(this,
                          _tr("Empty Fields"),
                          _tr("<qt>"
                             "<p>"
                             "Please fill out all fields."
                             "</p>"
                             "</qt>"
                            ),
                          _tr("Dismiss"), QString::null);
    return;
  }

  qs=textKeyCombo->currentText();
  if (!qs.isEmpty()) {
    bool isOk;

    i=qs.toInt(&isOk);
    if (!isOk) {
      QMessageBox::critical(this,
                            _tr("Bad Text Key"),
                            _tr("<qt>"
                               "<p>"
                               "The text key must be a positive integer."
                               "</p>"
                               "</qt>"
                              ),
                            _tr("Dismiss"), QString::null);
      return;
    }
  }


  qs=purposeEdit->text();
  DBG_NOTICE(0, "Got this string (%d lines):",
             purposeEdit->lines());
#ifndef WIN32
  // In MSVC this function crashes
  GWEN_Text_DumpString(qs.latin1(), qs.length(), stderr, 2);
#endif
  if (_maxPurpose!=-1) {
    int lines;

    lines=purposeEdit->lines();
    if (qs.endsWith("\n"))
      lines--;
    if (lines>_maxPurpose) {
      QString qs=QString(_tr("<qt>"
                            "<p>"
                            "Your purpose input exceeds the limit of "
                            "%1 lines."
                            "</p>"
                            "<p>"
                            "Please remove %2 lines."
                            "</p>"
                            "</qt>"
                           )
                         )
        .arg(_maxPurpose)
        .arg(lines-_maxPurpose);
      QMessageBox::critical(this,
                            _tr("Field Error"),
                            qs,
                            _tr("Dismiss"), QString::null);
      return;
    }
    if (lines<1) {
      QMessageBox::critical(this,
                            _tr("Field Error"),
                            _tr("Please enter the purpose."),
                            _tr("Dismiss"), QString::null);
      return;
    }
  }

  // find account
  i=localAccountCombo->currentItem();
  a=0;
  for (ait=_app->getAppAccounts().begin();
       ait!=_app->getAppAccounts().end();
       ait++) {
    if (!--i) {
      a=*ait;
      break;
    }
  } // for
  assert(a);

  if (a) {
    AB_ACCOUNT *ba;

    ba=AB_Banking_GetAccount(_app->getCInterface(),
			     a->getBankingId());
    if (ba) {
      AB_JOB *j=0;
      const AB_TRANSACTION_LIMITS *lim=0;

      if (_isCreateMode) {
	j=AB_JobCreateStandingOrder_new(ba);
	if (AB_Job_CheckAvailability(j)==0) {
	  standingOrderGroup->setEnabled(true);
	  lim=AB_JobCreateStandingOrder_GetFieldLimits(j);
	}
	else {
	  DBG_ERROR(0, "Job not supported with this account");
	  QMessageBox::critical(this,
				_tr("Job not Supported"),
				_tr("<qt>"
				    "<p>"
				    "This account does not support this job."
				    "</p>"
				    "</qt>"
				   ),
				_tr("Dismiss"), QString::null);
	  AB_Job_free(j);
	  return;
	}
      }
      else {
	j=AB_JobModifyStandingOrder_new(ba);
	if (AB_Job_CheckAvailability(j)==0) {
	  standingOrderGroup->setEnabled(true);
	  lim=AB_JobModifyStandingOrder_GetFieldLimits(j);
	}
	else {
	  DBG_ERROR(0, "Job not supported with this account");
	  QMessageBox::critical(this,
				_tr("Job not Supported"),
				_tr("<qt>"
				    "<p>"
				    "This account does not support this job."
				    "</p>"
				    "</qt>"
				   ),
				_tr("Dismiss"), QString::null);
	  AB_Job_free(j);
	  return;
	}
      }

      if (lim && _isCreateMode) {
	QDate currentDate=QDate::currentDate();
	QDate d=startDateEdit->date();
	int minDelay, maxDelay;
        int dt;

	minDelay=AB_TransactionLimits_GetMinValueSetupTime(lim);
        maxDelay=AB_TransactionLimits_GetMaxValueSetupTime(lim);
	dt=currentDate.daysTo(d);
	if (dt<0) {
	  QMessageBox::critical(this,
				_tr("Invalid Input"),
				_tr("<qt>"
				    "<p>"
				    "Start date is in the past."
				    "</p>"
				    "</qt>"
				   ),
				_tr("Dismiss"), QString::null);
	  AB_Job_free(j);
	  return;
	}
	else if (dt<minDelay) {
	  QMessageBox::critical(this,
				_tr("Invalid Input"),
				_tr("<qt>"
				    "<p>"
				    "Start date is too near."
				    "</p>"
				    "</qt>"
				   ),
				_tr("Dismiss"), QString::null);
	  AB_Job_free(j);
	  return;
	}
	if (maxDelay) {
	  if (dt>maxDelay) {
	    QMessageBox::critical(this,
				  _tr("Invalid Input"),
				  _tr("<qt>"
				      "<p>"
				      "Start date is too far."
				      "</p>"
				      "</qt>"
				     ),
				  _tr("Dismiss"), QString::null);
	    AB_Job_free(j);
	    return;
	  }
	}
      }
      AB_Job_free(j);
    } // if ba
  } // if a


  // all checks performed, now copy data back to transaction

  _transfer.ref().setLocalCountry(a->getCountry());
  _transfer.ref().setRemoteCountry(a->getCountry());
  _transfer.ref().setLocalBankCode(a->getBankCode());
  _transfer.ref().setLocalAccountNumber(a->getAccountNumber());
  _transfer.ref().setLocalName(a->getOwnerName());

  _transfer.ref().setRemoteBankCode
    (KBanking::QStringToUtf8String(remoteBankCodeEdit->text()));

  _transfer.ref().setRemoteAccountNumber
    (KBanking::QStringToUtf8String(remoteAccountIdEdit->text()));

  _transfer.ref().setRemoteBankName
    (KBanking::QStringToUtf8String(remoteBankNameEdit->text()));
  _transfer.ref().setRemoteBankLocation
    (KBanking::QStringToUtf8String(remoteBankLocationEdit->text()));

  _transfer.ref().clearRemoteName();
  _transfer.ref().addRemoteName
    (KBanking::QStringToUtf8String(remoteNameEdit->text()));

  qs=textKeyCombo->currentText();
  if (!qs.isEmpty()) {
    bool isOk;

    i=qs.toInt(&isOk);
    if (isOk)
      _transfer.ref().setTextKey(i);
  }

  qs=valueEdit->text();
  qs+=":";
  qs+=currencyCombo->currentText();
  value=AB_Value_fromString(qs.latin1());
  _transfer.ref().setValue(value);
  AB_Value_free(value);

  // get purpose
  _transfer.ref().clearPurpose();
  qs=purposeEdit->text();
  if (!qs.isEmpty()) {
    QString currLine;
    unsigned int i;
    int lastBlank;

    lastBlank=-1;
    // In qt4 QString::length() will return a signed int
    for (i=0; i < unsigned(qs.length()); i++) {
      if (qs.at(i)=='\n') {
        // next line
        if (!currLine.isEmpty()) {
          _transfer.ref().addPurpose
            (KBanking::QStringToUtf8String(currLine.upper()));
        }
        currLine="";
        lastBlank=-1;
      }
      else {
        if (qs.at(i).isSpace())
          lastBlank=i;
        if (currLine.length()>=27) {
          // wrap word at word boundary
          if (lastBlank==-1)
            // force word wrap here if no preceeding blank
            lastBlank=i;
          _transfer.ref().addPurpose
            (KBanking::QStringToUtf8String(currLine.left(lastBlank).upper()));
          currLine=currLine.mid(lastBlank+1);
          if (!qs.at(i).isSpace())
	    currLine+=qs.at(i);
          lastBlank=-1;
        }
        else
          currLine+=qs.at(i);
      }
    } // for
    if (!currLine.isEmpty()) {
      _transfer.ref().addPurpose
        (KBanking::QStringToUtf8String(currLine.upper()));
    }
  }

  // get standing order stuff
  if (monthlyRadio->isOn()) {
    if (cycleMonthCombo->currentItem()==0 ||
	dayMonthCombo->currentItem()==0) {
      QMessageBox::critical(this,
			    _tr("Field Error"),
			    _tr("Please select all fields for this "
				"standing order."),
			    _tr("Dismiss"), QString::null);
      return;
    }
    _transfer.ref().setPeriod(AB_Transaction_PeriodMonthly);
    qs=dayMonthCombo->currentText();
    if (qs==_tr(EDIT_STO_STRING_LAST_MINUS_2))
      i=97;
    else if (qs==_tr(EDIT_STO_STRING_LAST_MINUS_1))
      i=98;
    else if (qs==_tr(EDIT_STO_STRING_LAST))
      i=99;
    else
      i=qs.toInt();

    if (i<31) {
      if (startDateEdit->date().day()!=i) {
	QMessageBox::critical(this,
			      _tr("Field Error"),
			      _tr("Please select start date according to "
				  "standing order settings."),
			      _tr("Dismiss"), QString::null);
	return;
      }
    }
    else {
      QDate tdFirst;
      int daysTo;

      if (startDateEdit->date().month()==12)
	tdFirst=QDate(startDateEdit->date().year()+1, 1, 1);
      else
	tdFirst=QDate(startDateEdit->date().year(),
		      startDateEdit->date().month()+1, 1);
      daysTo=startDateEdit->date().daysTo(tdFirst);
      if ((i==97 && daysTo!=3) ||
	  (i==98 && daysTo!=2) ||
	  (i==99 && daysTo!=1)) {
	QMessageBox::critical(this,
			      _tr("Field Error"),
			      _tr("Please select start date according to "
				  "standing order settings."),
			      _tr("Dismiss"), QString::null);
	return;
      }
    }

    _transfer.ref().setExecutionDay(i);
    i=cycleMonthCombo->currentText().toInt();
      _transfer.ref().setCycle(i);
  }
  else {
    if (cycleWeekCombo->currentItem()==0 ||
	dayWeekCombo->currentItem()==0) {
      QMessageBox::critical(this,
			    _tr("Field Error"),
			    _tr("Please select all fields for this "
				"standing order."),
			    _tr("Dismiss"), QString::null);
      return;
    }
    _transfer.ref().setPeriod(AB_Transaction_PeriodWeekly);
    qs=dayWeekCombo->currentText();
    if (qs==_tr("Monday"))
      i=1;
    else if (qs==_tr("Tuesday"))
      i=2;
    else if (qs==_tr("Wednesday"))
      i=3;
    else if (qs==_tr("Thursday"))
      i=4;
    else if (qs==_tr("Friday"))
      i=5;
    else if (qs==_tr("Saturday"))
      i=6;
    else if (qs==_tr("Sunday"))
      i=7;
    else {
      DBG_ERROR(0, "Unknown weekday");
      abort();
    }
    _transfer.ref().setExecutionDay(i);
    i=cycleWeekCombo->currentText().toInt();
    _transfer.ref().setCycle(i);
  }

  qd=startDateEdit->date();
  ti=GWEN_Time_new(qd.year(),
		   qd.month()-1,
		   qd.day(),
		   12, 00, 00, 1);
  _transfer.ref().setFirstExecutionDate(ti);
  GWEN_Time_free(ti);

  return QDialog::accept();
}



void EditStandingOrder::reject(){
  return QDialog::reject();
}



void EditStandingOrder::slotBankCode(){
  AB_BANKINFO *bi;

  bi=QBSelectBank::selectBank(_app,
                              this,
                              _tr("Select a Bank"),
                              QString("de"),
                              remoteBankCodeEdit->text());
  if (bi) {
    const char *s;

    s=AB_BankInfo_GetBankId(bi);
    if (s)
      remoteBankCodeEdit->setText(QString::fromUtf8(s));
    s=AB_BankInfo_GetBankName(bi);
    if (s)
      remoteBankNameEdit->setText(QString::fromUtf8(s));
    s=AB_BankInfo_GetLocation(bi);
    if (s)
      remoteBankLocationEdit->setText(QString::fromUtf8(s));
    AB_BankInfo_free(bi);
  }
}



void EditStandingOrder::slotMonthlyToggled(bool on){
  if (!on && weeklyRadio->isEnabled())
    weeklyRadio->setChecked(!on);
  else {
    on=true;
    monthlyRadio->setChecked(on);
  }

  everyWeekLabel->setEnabled(!on);
  cycleWeekCombo->setEnabled(!on && _allowChangeCycle);
  weeksOnLabel->setEnabled(!on);
  dayWeekCombo->setEnabled(!on && _allowChangeDay);

  everyMonthLabel->setEnabled(on);
  cycleMonthCombo->setEnabled(on && _allowChangeCycle);
  monthsOnLabel->setEnabled(on);
  dayMonthCombo->setEnabled(on && _allowChangeDay);

}



void EditStandingOrder::slotWeeklyToggled(bool on){
  monthlyRadio->setChecked(!on);
}



void EditStandingOrder::slotAccountChanged(int i){
  std::list<Account*>::const_iterator ait;
  Account *a;
  QString qs;

  qs=textKeyCombo->currentText();
  fprintf(stderr, "Current textKey: %s\n", qs.latin1());
  textKeyCombo->clear();

  standingOrderGroup->setEnabled(false);
  _minDelay=0;
  _maxDelay=0;

  a=0;
  for (ait=_app->getAppAccounts().begin();
       ait!=_app->getAppAccounts().end();
       ait++) {
    if (!--i) {
      a=*ait;
      break;
    }
  } // for
  if (a) {
    AB_ACCOUNT *ba;

    ba=AB_Banking_GetAccount(_app->getCInterface(),
                             a->getBankingId());
    if (ba) {
      AB_JOB *j=0;
      const AB_TRANSACTION_LIMITS *lim=0;

      if (_isCreateMode) {
	j=AB_JobCreateStandingOrder_new(ba);
	if (AB_Job_CheckAvailability(j)==0) {
	  standingOrderGroup->setEnabled(true);
	  lim=AB_JobCreateStandingOrder_GetFieldLimits(j);
	}
	else {
	  DBG_ERROR(0, "Job not supported with this account");
	  QMessageBox::critical(this,
				_tr("Job not Supported"),
				_tr("<qt>"
				    "<p>"
				    "This account does not support this job."
				    "</p>"
				    "</qt>"
				   ),
				_tr("Dismiss"), QString::null);
	}
      }
      else {
	j=AB_JobModifyStandingOrder_new(ba);
	if (AB_Job_CheckAvailability(j)==0) {
	  standingOrderGroup->setEnabled(true);
	  lim=AB_JobModifyStandingOrder_GetFieldLimits(j);
	}
	else {
	  DBG_ERROR(0, "Job not supported with this account");
	  QMessageBox::critical(this,
				_tr("Job not Supported"),
				_tr("<qt>"
				    "<p>"
				    "This account does not support this job."
				    "</p>"
				    "</qt>"
				   ),
				_tr("Dismiss"), QString::null);
	}
      }

      _maxPurpose=1;
      if (lim) {
        GWEN_STRINGLISTENTRY *se;

        _maxPurpose=AB_TransactionLimits_GetMaxLinesPurpose(lim);
        if (_maxPurpose==-1)
          _maxPurpose=1;

	if (_isCreateMode) {
	  _minDelay=AB_TransactionLimits_GetMinValueSetupTime(lim);
	  _maxDelay=AB_TransactionLimits_GetMaxValueSetupTime(lim);
	}

        // read text keys
        se=GWEN_StringList_FirstEntry(AB_TransactionLimits_GetValuesTextKey(lim));
        while(se) {
          const char *s;

          s=GWEN_StringListEntry_Data(se);
          assert(s);
          fprintf(stderr, "Adding textkey %s\n",
                  s);
          textKeyCombo->insertItem(QString::fromUtf8(s));
          se=GWEN_StringListEntry_Next(se);
        } // while
      }

      // select previously selected textkey
      if (!qs.isEmpty()) {
        fprintf(stderr, "Setting back to text key %s\n",
		qs.latin1());
        _setComboTextIfPossible(textKeyCombo, qs);
      }

      // handle execution day week
      qs=dayWeekCombo->currentText();
      dayWeekCombo->clear();
      dayWeekCombo->insertItem(_tr(EDIT_STO_STRING_SELECT));
      if (lim &&
	  GWEN_StringList_Count(AB_TransactionLimits_GetValuesExecutionDayWeek(lim))) {
	GWEN_STRINGLISTENTRY *se;
        QString qi;

	// read execution days of the week
	se=GWEN_StringList_FirstEntry(AB_TransactionLimits_GetValuesExecutionDayWeek(lim));
	while(se) {
	  const char *s;

          s=GWEN_StringListEntry_Data(se);
	  assert(s);
	  if (sscanf(s, "%d", &i)!=1) {
	    DBG_ERROR(0,
		      "Bad entry for ValuesExecutionDayWeek: \"%s\"\n",
		      s);
	    i=0;
	  }

	  if (i==0) {
	    dayWeekCombo->clear();
	    dayWeekCombo->insertItem(_tr(EDIT_STO_STRING_SELECT));
	    dayWeekCombo->insertItem(_tr("Monday"));
	    dayWeekCombo->insertItem(_tr("Tuesday"));
	    dayWeekCombo->insertItem(_tr("Wednesday"));
	    dayWeekCombo->insertItem(_tr("Thursday"));
	    dayWeekCombo->insertItem(_tr("Friday"));
            break;
	  }
	  else {
	    switch(i) {
	    case 1: qi=_tr("Monday"); break;
	    case 2: qi=_tr("Tuesday"); break;
	    case 3: qi=_tr("Wednesday"); break;
	    case 4: qi=_tr("Thursday"); break;
	    case 5: qi=_tr("Friday"); break;
	    case 6: qi=_tr("Saturday"); break;
	    case 7: qi=_tr("Sunday"); break;
	    default:
	      DBG_ERROR(0, "Unknown day %d, assuming \"monday\"", i);
	      i=1;
	      qi=qi=_tr("Monday"); break;
	    }
	    dayWeekCombo->insertItem(qi);
	  }
	  se=GWEN_StringListEntry_Next(se);
	} // while
      }
      else {
	dayWeekCombo->insertItem(_tr("Monday"));
	dayWeekCombo->insertItem(_tr("Tuesday"));
	dayWeekCombo->insertItem(_tr("Wednesday"));
	dayWeekCombo->insertItem(_tr("Thursday"));
	dayWeekCombo->insertItem(_tr("Friday"));
      }
      // select previously selected week day
      if (!qs.isEmpty()) {
	_setComboTextNoDup(dayWeekCombo, qs);
        _setComboTextIfPossible(dayWeekCombo, qs);
      }

      // handle cycle week
      qs=cycleWeekCombo->currentText();
      cycleWeekCombo->clear();
      if (lim &&
	  GWEN_StringList_Count(AB_TransactionLimits_GetValuesCycleWeek(lim))) {
	GWEN_STRINGLISTENTRY *se;
	QString qi;

	// read cycle (week)
	se=GWEN_StringList_FirstEntry(AB_TransactionLimits_GetValuesCycleWeek(lim));
	while(se) {
	  const char *s;

	  s=GWEN_StringListEntry_Data(se);
	  assert(s);
	  if (sscanf(s, "%d", &i)!=1) {
	    DBG_ERROR(0,
		      "Bad entry for ValuesCycleWeek: \"%s\"\n",
		      s);
	    i=0;
	  }

	  if (i==0) {
	    cycleWeekCombo->clear();
	    cycleWeekCombo->insertItem(_tr(EDIT_STO_STRING_SELECT));
	    for (i=1; i<53; i++)
	      cycleWeekCombo->insertItem(QString::number(i));
	    break;
	  }
	  else {
	    cycleWeekCombo->insertItem(QString::number(i));
	  }
	  se=GWEN_StringListEntry_Next(se);
	} // while
      }
      else {
	cycleWeekCombo->clear();
	cycleWeekCombo->insertItem(_tr(EDIT_STO_STRING_SELECT));
	for (i=1; i<53; i++)
	  cycleWeekCombo->insertItem(QString::number(i));
      }
      // select previously selected week day
      if (!qs.isEmpty()) {
        _setComboTextIfPossible(cycleWeekCombo, qs);
      }

      // handle execution day month
      qs=dayMonthCombo->currentText();
      dayMonthCombo->clear();
      dayMonthCombo->insertItem(_tr(EDIT_STO_STRING_SELECT));
      if (lim &&
	  GWEN_StringList_Count(AB_TransactionLimits_GetValuesExecutionDayMonth(lim))) {
	GWEN_STRINGLISTENTRY *se;
        QString qi;

	// read execution days of the week
	se=GWEN_StringList_FirstEntry(AB_TransactionLimits_GetValuesExecutionDayMonth(lim));
	while(se) {
	  const char *s;

          s=GWEN_StringListEntry_Data(se);
	  assert(s);
	  if (sscanf(s, "%d", &i)!=1) {
	    DBG_ERROR(0,
		      "Bad entry for ValuesExecutionDayMonth: \"%s\"\n",
		      s);
	    i=0;
	  }

	  if (i==0) {
	    dayMonthCombo->clear();
	    dayMonthCombo->insertItem(_tr(EDIT_STO_STRING_SELECT));
	    for (i=1; i<31; i++)
	      dayMonthCombo->insertItem(QString::number(i));
	    dayMonthCombo->insertItem(_tr(EDIT_STO_STRING_LAST_MINUS_2));
	    dayMonthCombo->insertItem(_tr(EDIT_STO_STRING_LAST_MINUS_1));
	    dayMonthCombo->insertItem(_tr(EDIT_STO_STRING_LAST));
	    break;
	  }
	  else {
	    switch(i) {
	    case 97:
	      dayMonthCombo->insertItem(_tr(EDIT_STO_STRING_LAST_MINUS_2));
	      break;
	    case 98:
	      dayMonthCombo->insertItem(_tr(EDIT_STO_STRING_LAST_MINUS_1));
	      break;
	    case 99:
	      dayMonthCombo->insertItem(_tr(EDIT_STO_STRING_LAST));
	      break;
	    default:
	      dayMonthCombo->insertItem(QString::number(i));
	    }
	  }
	  se=GWEN_StringListEntry_Next(se);
	} // while
      }
      else {
	dayMonthCombo->clear();
	dayMonthCombo->insertItem(_tr(EDIT_STO_STRING_SELECT));
	for (i=1; i<31; i++)
	  dayMonthCombo->insertItem(QString::number(i));
	dayMonthCombo->insertItem(_tr(EDIT_STO_STRING_LAST_MINUS_2));
	dayMonthCombo->insertItem(_tr(EDIT_STO_STRING_LAST_MINUS_1));
	dayMonthCombo->insertItem(_tr(EDIT_STO_STRING_LAST));
      }
      // select previously selected week day
      if (!qs.isEmpty()) {
        _setComboTextIfPossible(dayMonthCombo, qs);
      }

      // handle cycle month
      qs=cycleMonthCombo->currentText();
      cycleMonthCombo->clear();
      cycleMonthCombo->insertItem(_tr(EDIT_STO_STRING_SELECT));
      if (lim &&
	  GWEN_StringList_Count(AB_TransactionLimits_GetValuesCycleMonth(lim))) {
	GWEN_STRINGLISTENTRY *se;
	QString qi;

	// read cycle (week)
	se=GWEN_StringList_FirstEntry(AB_TransactionLimits_GetValuesCycleMonth(lim));
	while(se) {
	  const char *s;

	  s=GWEN_StringListEntry_Data(se);
	  assert(s);
	  if (sscanf(s, "%d", &i)!=1) {
	    DBG_ERROR(0,
		      "Bad entry for ValuesCycleMonth: \"%s\"\n",
		      s);
	    i=0;
	  }

	  if (i==0) {
	    cycleMonthCombo->clear();
	    cycleMonthCombo->insertItem(_tr(EDIT_STO_STRING_SELECT));
	    for (i=1; i<13; i++)
	      cycleMonthCombo->insertItem(QString::number(i));
	    break;
	  }
	  else {
	    cycleMonthCombo->insertItem(QString::number(i));
	  }
	  se=GWEN_StringListEntry_Next(se);
	} // while
      }
      else {
	cycleMonthCombo->clear();
	cycleMonthCombo->insertItem(_tr(EDIT_STO_STRING_SELECT));
	for (i=1; i<13; i++)
	  cycleMonthCombo->insertItem(QString::number(i));
      }
      // select previously selected week day
      if (!qs.isEmpty()) {
        _setComboTextIfPossible(cycleMonthCombo, qs);
      }

      if (!_isCreateMode) {
	startDateEdit->setEnabled(false);
        localAccountCombo->setEnabled(false);
      }

      if (lim && !_isCreateMode) {
	bool b;

	b=(AB_TransactionLimits_GetAllowChangeRecipientAccount(lim)!=-1);
	remoteBankLocationEdit->setEnabled(b);
	remoteBankCodeEdit->setEnabled(b);
	bankCodeButton->setEnabled(b);
	remoteAccountIdEdit->setEnabled(b);
	remoteBankNameEdit->setEnabled(b);

	b=(AB_TransactionLimits_GetAllowChangeRecipientName(lim)!=-1);
	remoteNameEdit->setEnabled(b);
	payeeButton->setEnabled(b);

	b=(AB_TransactionLimits_GetAllowChangeValue(lim)!=-1);
	valueEdit->setEnabled(b);
	currencyCombo->setEnabled(b);

	b=(AB_TransactionLimits_GetAllowChangeTextKey(lim)!=-1);
	textKeyCombo->setEnabled(b);

	b=(AB_TransactionLimits_GetAllowChangePurpose(lim)!=-1);
	purposeEdit->setEnabled(b);

	b=(AB_TransactionLimits_GetAllowChangeCycle(lim)!=-1);
        cycleMonthCombo->setEnabled(b);
	cycleWeekCombo->setEnabled(b);
        _allowChangeCycle=b;

	b=(AB_TransactionLimits_GetAllowChangeExecutionDay(lim)!=-1);
	dayMonthCombo->setEnabled(b);
	dayWeekCombo->setEnabled(b);
        _allowChangeDay=b;

	b=(AB_TransactionLimits_GetAllowChangePeriod(lim)!=-1);
	weeklyRadio->setEnabled(b);
	monthlyRadio->setEnabled(b);
        _allowChangePeriod=b;
      }
      else {
	remoteBankLocationEdit->setEnabled(true);
	remoteBankCodeEdit->setEnabled(true);
	bankCodeButton->setEnabled(true);
	remoteAccountIdEdit->setEnabled(true);
	remoteBankNameEdit->setEnabled(true);

	remoteNameEdit->setEnabled(true);
	payeeButton->setEnabled(true);

	valueEdit->setEnabled(true);
	currencyCombo->setEnabled(true);

	textKeyCombo->setEnabled(true);

	purposeEdit->setEnabled(true);

        cycleMonthCombo->setEnabled(true);
	cycleWeekCombo->setEnabled(true);
	_allowChangeCycle=true;

	dayMonthCombo->setEnabled(true);
	dayWeekCombo->setEnabled(true);
	_allowChangeDay=true;

	weeklyRadio->setEnabled(true);
	monthlyRadio->setEnabled(true);
	_allowChangePeriod=true;
      }

      if (lim) {
        if (AB_TransactionLimits_GetAllowMonthly(lim)==-1) {
          monthlyRadio->setChecked(false);
          monthlyRadio->setEnabled(false);
          weeklyRadio->setChecked(true);
        }
	//else
          //monthlyRadio->setEnabled(true);
        if (AB_TransactionLimits_GetAllowWeekly(lim)==-1) {
          weeklyRadio->setChecked(false);
          monthlyRadio->setChecked(true);
          weeklyRadio->setEnabled(false);
        }
        //else
          //weeklyRadio->setEnabled(true);

        if (AB_TransactionLimits_GetAllowMonthly(lim)==-1 &&
            AB_TransactionLimits_GetAllowWeekly(lim)==-1)
          standingOrderGroup->setEnabled(false);

	slotMonthlyToggled(monthlyRadio->isOn());
      }
    } // if account
  } // if account
  else {
    standingOrderGroup->setEnabled(false);
  }
}



void EditStandingOrder::slotGetBankCode(){
}



void EditStandingOrder::slotGetPayee(){
  Payee *p;

  p=SelectPayee::selectPayee(_app,
                             _tr("Select Payee"),
                             _tr("Select the payee from the list below"),
                             this);
  if (p) {
    std::string s;

    s=p->accountNumber();
    if (!s.empty())
      remoteAccountIdEdit
        ->setText(QString::fromUtf8(s.c_str()));
    s=p->bankCode();
    if (!s.empty())
      remoteBankCodeEdit
        ->setText(QString::fromUtf8(s.c_str()));
    s=p->name();
    if (!s.empty())
      remoteNameEdit
        ->setText(QString::fromUtf8(s.c_str()));
  }
}



bool EditStandingOrder::createStandingOrder(KBanking *app,
					    RefPointer<StandingOrder> t,
					    const QString &title,
					    QWidget* parent,
					    bool modal,
					    WFlags fl) {
  EditStandingOrder w(app, t, true, parent, 0, modal, fl);

  if (t.ref().getTextKey()==0)
    t.ref().setTextKey(51);

  if (!title.isEmpty())
    w.setCaption(title);
  w.titleLabel->setText(_tr("<qt>"
			    "<h3>Standing Order</h3>"
			    "Let your bank do a transfer of money from your "
			    "account to someone elses' (within your country) "
			    "automatically."
			    "</qt>"));
  w.grp_myaccount->setTitle(_tr("editTransfer|Payee"));
  w.grp_recipient->setTitle(_tr("editTransfer|Recipient"));
  return (w.exec()==QDialog::Accepted);
}



bool EditStandingOrder::modifyStandingOrder(KBanking *app,
					    RefPointer<StandingOrder> t,
					    const QString &title,
					    QWidget* parent,
					    bool modal,
					    WFlags fl) {
  EditStandingOrder w(app, t, false, parent, 0, modal, fl);

  if (t.ref().getTextKey()==0)
    t.ref().setTextKey(51);

  if (!title.isEmpty())
    w.setCaption(title);
  w.titleLabel->setText(_tr("<qt>"
			    "<h3>Standing Order</h3>"
                            "Modify an existing standing order."
                            "</qt>"));
  w.grp_myaccount->setTitle(_tr("editTransfer|Payee"));
  w.grp_recipient->setTitle(_tr("editTransfer|Recipient"));
  return (w.exec()==QDialog::Accepted);
}



QString EditStandingOrder::_tr(const char * sourceText){
  QString qs;
  int i;

  qs=tr(sourceText);
  i=qs.find('|');
  if (i) {
    qs=qs.mid(i+1);
  }
  return qs;
}



void EditStandingOrder::slotAdjustStartDate(int) {
  if (monthlyRadio->isOn()) {
    QString qs;
    int i;

    qs=dayMonthCombo->currentText();
    if (qs==_tr(EDIT_STO_STRING_LAST_MINUS_2))
      i=97;
    else if (qs==_tr(EDIT_STO_STRING_LAST_MINUS_1))
      i=98;
    else if (qs==_tr(EDIT_STO_STRING_LAST))
      i=99;
    else
      i=qs.toInt();

    if (i<31) {
      QDate td;

      td=QDate::currentDate();
      td=QDate(td.year(), td.month(), i);
      if (QDate::currentDate().daysTo(td)<(_minDelay?_minDelay:1))
        td=td.addMonths((((_minDelay?_minDelay:1)+29)/30)*1);
      startDateEdit->setDate(td);
    }
    else {
      QDate tdFirst;
      QDate td;

      if (startDateEdit->date().month()==12)
	tdFirst=QDate(startDateEdit->date().year()+1, 1, 1);
      else
	tdFirst=QDate(startDateEdit->date().year(),
		      startDateEdit->date().month()+1, 1);
      if (i==97)
	td=tdFirst.addDays(-3);
      else if (i==98)
	td=tdFirst.addDays(-2);
      else if (i==99)
	td=tdFirst.addDays(-1);

      if (QDate::currentDate().daysTo(td)<(_minDelay?_minDelay:1)) {
        /* whoops, too near, add more months and recalculate */
	if (startDateEdit->date().month()==12)
	  tdFirst=QDate(startDateEdit->date().year()+1, 1, 1);
	else
	  tdFirst=QDate(startDateEdit->date().year(),
			startDateEdit->date().month()+1, 1);
	tdFirst=tdFirst.addMonths((((_minDelay?_minDelay:1)+29)/30)*1);
	if (i==97)
	  td=tdFirst.addDays(-3);
	else if (i==98)
	  td=tdFirst.addDays(-2);
	else if (i==99)
	  td=tdFirst.addDays(-1);


      }
      startDateEdit->setDate(td);
    }
  }
  else {
    // weekly
  }
}


