/***************************************************************************
 $RCSfile$
                             -------------------
    cvs         : $Id$
    begin       : Mon Mar 01 2004
    copyright   : (C) 2004 by Martin Preuss
    email       : martin@libchipcard.de

 ***************************************************************************
 *          Please see toplevel file COPYING for license details           *
 ***************************************************************************/


#ifdef HAVE_CONFIG_H
# include <config.h>
#endif



#include "handledupe.h"
#include "transactionlist.h"
#include "kbanking.h"

#include <qlayout.h>
#include <qgroupbox.h>
#include <qpushbutton.h>
#include <qlabel.h>
#include <qmessagebox.h>
#include <qcheckbox.h>

#include <string>
#include <list>





HandleDupe::HandleDupe(Account *a,
                       RefPointer<Transaction> tnew,
                       RefPointer<Transaction> told,
                       const std::list<RefPointer<Transaction> > &dnl,
                       const std::list<RefPointer<Transaction> > &dol,
                       QWidget* parent,
                       const char* name,
                       bool modal,
                       WFlags fl)
:HandleDupeUi(parent, name, modal, fl)
,_app(0)
,_account(a)
,_tnew(tnew)
,_told(told)
,_newList(dnl)
,_oldList(dol)
,_transactionList(0)
,_result(TransactionImporter::DupeCheck_Error){
  std::string tx;
  _app=(KBanking*)a->getApi();
  assert(_app);

  // setup new transaction
  tx=tnew.ref().toHtmlInfo();
  tx="<qt>"+tx+"</qt>";
  newTransactionLabel->setText(QString::fromUtf8(tx.c_str()));

  // setup list for old transactions
  oldTransactionsBox->setColumnLayout(0, Qt::Vertical );
  QBoxLayout *oldTransactionsBoxLayout=
    new QHBoxLayout(oldTransactionsBox->layout() );
  oldTransactionsBoxLayout->setAlignment(Qt::AlignTop);
  _transactionList=
    new TransactionListView(false, oldTransactionsBox, "TransactionList");
  oldTransactionsBoxLayout->addWidget(_transactionList);

  _transactionList->addTransactions(dol);
  _transactionList->setSelectionMode(QListView::NoSelection);

  // mark duplicate
  TransactionListViewItem *entry;

  QListViewItemIterator it(_transactionList);
  // iterate through all items of the listview
  for (;it.current();++it) {
    entry=dynamic_cast<TransactionListViewItem*>(it.current());
    if (entry) {
      if (entry->getTransaction().ref().getTransactionId()==
          told.ref().getTransactionId()) {
        // found it
        entry->setColour("light green");
        _transactionList->ensureItemVisible(entry);
        break;
      }
    }
  } // for

  QObject::connect(helpButton, SIGNAL(clicked()),
                   this, SLOT(slotHelp()));
  QObject::connect(discardNewButton, SIGNAL(clicked()),
                   this, SLOT(slotDiscardNew()));
  QObject::connect(addNewButton, SIGNAL(clicked()),
                   this, SLOT(slotAddNew()));
  QObject::connect(replaceButton, SIGNAL(clicked()),
                   this, SLOT(slotReplace()));
}



HandleDupe::~HandleDupe(){
}



void HandleDupe::accept(){
}



void HandleDupe::reject(){
  QDialog::reject();
}



void HandleDupe::slotHelp(){
  _app->invokeHelp("HandleDupe", "dialog/askdate");
}



void HandleDupe::slotDiscardNew(){
  _result=TransactionImporter::DupeCheck_DismissNew;
  QDialog::accept();
}



void HandleDupe::slotAddNew(){
  _result=TransactionImporter::DupeCheck_AddNew;
  QDialog::accept();
}



void HandleDupe::slotReplace(){
  _result=TransactionImporter::DupeCheck_ReplaceOld;
  QDialog::accept();
}



TransactionImporter::DupeCheckResult HandleDupe::getResult() const{
  return _result;
}




TransactionImporter::DupeCheckResult
HandleDupe::askUser(Account *a,
                    RefPointer<Transaction> tnew,
                    RefPointer<Transaction> told,
                    const std::list<RefPointer<Transaction> > &dnl,
                    const std::list<RefPointer<Transaction> > &dol,
                    bool &askNoMore,
                    QWidget* parent) {
  TransactionImporter::DupeCheckResult res;
  HandleDupe w(a,
               tnew,
               told,
               dnl,
               dol,
               parent,
               "HandleDupe",
               true);
  w.show();
  res=TransactionImporter::DupeCheck_Error;
  // mark duplicate
  TransactionListViewItem *entry;

  QListViewItemIterator it(w._transactionList);
  // iterate through all items of the listview
  for (;it.current();++it) {
    entry=dynamic_cast<TransactionListViewItem*>(it.current());
    if (entry) {
      if (entry->getTransaction().ref().getTransactionId()==
          told.ref().getTransactionId()) {
        // found it
        entry->setColour("light green");
        w._transactionList->ensureItemVisible(entry);
        break;
      }
    }
  } // for

  if (w.exec()==QDialog::Accepted) {
    res=w.getResult();
    askNoMore=w.againCheckBox->isChecked();
  }
  return res;
}










