/***************************************************************************
 $RCSfile$
                             -------------------
    cvs         : $Id$
    begin       : Mon Mar 01 2004
    copyright   : (C) 2004 by Martin Preuss
    email       : martin@libchipcard.de

 ***************************************************************************
 *          Please see toplevel file COPYING for license details           *
 ***************************************************************************/

#ifndef AQBANKING_KDE_RULEEDITOR_H
#define AQBANKING_KDE_RULEEDITOR_H


class KBanking;

#include "ruleeditor.ui.h"

#include <gwenhywfar/db.h>
#include <qstring.h>


class RuleEditor : public RuleEditorUi {
  Q_OBJECT
public:
  RuleEditor(QWidget* parent=0,
             const char* name=0,
             WFlags fl=0);
  virtual ~RuleEditor();

  void init(KBanking *kb, GWEN_DB_NODE *dbRules, bool readOnly,
            uint32_t tfFlags);
  GWEN_DB_NODE *getRules() const;

  void setRules(GWEN_DB_NODE *dbRules);

public slots:
  void slotAddRule();
  void slotDelRule();
  void slotEditRule();

private:
  KBanking *_app;
  GWEN_DB_NODE *_dbRules;
  uint32_t _tfFlags;

  void _updateRules();
  QString _ruleToShort(GWEN_DB_NODE *dbRule);

};





#endif
