/* server functions auto-generated by pidl */
#include "librpc/gen_ndr/ndr_dfs.h"

/* netdfs - dcerpc server boilerplate generated by pidl */


static NTSTATUS netdfs__op_bind(struct dcesrv_call_state *dce_call, const struct dcesrv_interface *iface, uint32_t if_version)
{
#ifdef DCESRV_INTERFACE_NETDFS_BIND
	return DCESRV_INTERFACE_NETDFS_BIND(dce_call,iface);
#else
	return NT_STATUS_OK;
#endif
}

static void netdfs__op_unbind(struct dcesrv_connection_context *context, const struct dcesrv_interface *iface)
{
#ifdef DCESRV_INTERFACE_NETDFS_UNBIND
	DCESRV_INTERFACE_NETDFS_UNBIND(context, iface);
#else
	return;
#endif
}

static NTSTATUS netdfs__op_ndr_pull(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, struct ndr_pull *pull, void **r)
{
	enum ndr_err_code ndr_err;
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	dce_call->fault_code = 0;

	if (opnum >= ndr_table_netdfs.num_calls) {
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	*r = talloc_named(mem_ctx,
			  ndr_table_netdfs.calls[opnum].struct_size,
			  "struct %s",
			  ndr_table_netdfs.calls[opnum].name);
	NT_STATUS_HAVE_NO_MEMORY(*r);

        /* unravel the NDR for the packet */
	ndr_err = ndr_table_netdfs.calls[opnum].ndr_pull(pull, NDR_IN, *r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		dcerpc_log_packet(dce_call->conn->packet_log_dir, 
				  &ndr_table_netdfs, opnum, NDR_IN,
				  &dce_call->pkt.u.request.stub_and_verifier);
		dce_call->fault_code = DCERPC_FAULT_NDR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

static NTSTATUS netdfs__op_dispatch(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, void *r)
{
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	switch (opnum) {
	case 0: {
		struct dfs_GetManagerVersion *r2 = (struct dfs_GetManagerVersion *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(dfs_GetManagerVersion, NDR_IN, r2);
		}
		dcesrv_dfs_GetManagerVersion(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function dfs_GetManagerVersion will reply async\n"));
		}
		break;
	}
	case 1: {
		struct dfs_Add *r2 = (struct dfs_Add *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(dfs_Add, NDR_IN, r2);
		}
		r2->out.result = dcesrv_dfs_Add(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function dfs_Add will reply async\n"));
		}
		break;
	}
	case 2: {
		struct dfs_Remove *r2 = (struct dfs_Remove *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(dfs_Remove, NDR_IN, r2);
		}
		r2->out.result = dcesrv_dfs_Remove(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function dfs_Remove will reply async\n"));
		}
		break;
	}
	case 3: {
		struct dfs_SetInfo *r2 = (struct dfs_SetInfo *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(dfs_SetInfo, NDR_IN, r2);
		}
		r2->out.result = dcesrv_dfs_SetInfo(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function dfs_SetInfo will reply async\n"));
		}
		break;
	}
	case 4: {
		struct dfs_GetInfo *r2 = (struct dfs_GetInfo *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(dfs_GetInfo, NDR_IN, r2);
		}
		r2->out.result = dcesrv_dfs_GetInfo(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function dfs_GetInfo will reply async\n"));
		}
		break;
	}
	case 5: {
		struct dfs_Enum *r2 = (struct dfs_Enum *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(dfs_Enum, NDR_IN, r2);
		}
		r2->out.result = dcesrv_dfs_Enum(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function dfs_Enum will reply async\n"));
		}
		break;
	}
	case 6: {
		struct dfs_Rename *r2 = (struct dfs_Rename *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(dfs_Rename, NDR_IN, r2);
		}
		r2->out.result = dcesrv_dfs_Rename(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function dfs_Rename will reply async\n"));
		}
		break;
	}
	case 7: {
		struct dfs_Move *r2 = (struct dfs_Move *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(dfs_Move, NDR_IN, r2);
		}
		r2->out.result = dcesrv_dfs_Move(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function dfs_Move will reply async\n"));
		}
		break;
	}
	case 8: {
		struct dfs_ManagerGetConfigInfo *r2 = (struct dfs_ManagerGetConfigInfo *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(dfs_ManagerGetConfigInfo, NDR_IN, r2);
		}
		r2->out.result = dcesrv_dfs_ManagerGetConfigInfo(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function dfs_ManagerGetConfigInfo will reply async\n"));
		}
		break;
	}
	case 9: {
		struct dfs_ManagerSendSiteInfo *r2 = (struct dfs_ManagerSendSiteInfo *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(dfs_ManagerSendSiteInfo, NDR_IN, r2);
		}
		r2->out.result = dcesrv_dfs_ManagerSendSiteInfo(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function dfs_ManagerSendSiteInfo will reply async\n"));
		}
		break;
	}
	case 10: {
		struct dfs_AddFtRoot *r2 = (struct dfs_AddFtRoot *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(dfs_AddFtRoot, NDR_IN, r2);
		}
		r2->out.result = dcesrv_dfs_AddFtRoot(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function dfs_AddFtRoot will reply async\n"));
		}
		break;
	}
	case 11: {
		struct dfs_RemoveFtRoot *r2 = (struct dfs_RemoveFtRoot *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(dfs_RemoveFtRoot, NDR_IN, r2);
		}
		r2->out.result = dcesrv_dfs_RemoveFtRoot(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function dfs_RemoveFtRoot will reply async\n"));
		}
		break;
	}
	case 12: {
		struct dfs_AddStdRoot *r2 = (struct dfs_AddStdRoot *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(dfs_AddStdRoot, NDR_IN, r2);
		}
		r2->out.result = dcesrv_dfs_AddStdRoot(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function dfs_AddStdRoot will reply async\n"));
		}
		break;
	}
	case 13: {
		struct dfs_RemoveStdRoot *r2 = (struct dfs_RemoveStdRoot *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(dfs_RemoveStdRoot, NDR_IN, r2);
		}
		r2->out.result = dcesrv_dfs_RemoveStdRoot(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function dfs_RemoveStdRoot will reply async\n"));
		}
		break;
	}
	case 14: {
		struct dfs_ManagerInitialize *r2 = (struct dfs_ManagerInitialize *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(dfs_ManagerInitialize, NDR_IN, r2);
		}
		r2->out.result = dcesrv_dfs_ManagerInitialize(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function dfs_ManagerInitialize will reply async\n"));
		}
		break;
	}
	case 15: {
		struct dfs_AddStdRootForced *r2 = (struct dfs_AddStdRootForced *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(dfs_AddStdRootForced, NDR_IN, r2);
		}
		r2->out.result = dcesrv_dfs_AddStdRootForced(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function dfs_AddStdRootForced will reply async\n"));
		}
		break;
	}
	case 16: {
		struct dfs_GetDcAddress *r2 = (struct dfs_GetDcAddress *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(dfs_GetDcAddress, NDR_IN, r2);
		}
		r2->out.result = dcesrv_dfs_GetDcAddress(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function dfs_GetDcAddress will reply async\n"));
		}
		break;
	}
	case 17: {
		struct dfs_SetDcAddress *r2 = (struct dfs_SetDcAddress *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(dfs_SetDcAddress, NDR_IN, r2);
		}
		r2->out.result = dcesrv_dfs_SetDcAddress(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function dfs_SetDcAddress will reply async\n"));
		}
		break;
	}
	case 18: {
		struct dfs_FlushFtTable *r2 = (struct dfs_FlushFtTable *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(dfs_FlushFtTable, NDR_IN, r2);
		}
		r2->out.result = dcesrv_dfs_FlushFtTable(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function dfs_FlushFtTable will reply async\n"));
		}
		break;
	}
	case 19: {
		struct dfs_Add2 *r2 = (struct dfs_Add2 *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(dfs_Add2, NDR_IN, r2);
		}
		r2->out.result = dcesrv_dfs_Add2(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function dfs_Add2 will reply async\n"));
		}
		break;
	}
	case 20: {
		struct dfs_Remove2 *r2 = (struct dfs_Remove2 *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(dfs_Remove2, NDR_IN, r2);
		}
		r2->out.result = dcesrv_dfs_Remove2(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function dfs_Remove2 will reply async\n"));
		}
		break;
	}
	case 21: {
		struct dfs_EnumEx *r2 = (struct dfs_EnumEx *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(dfs_EnumEx, NDR_IN, r2);
		}
		r2->out.result = dcesrv_dfs_EnumEx(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function dfs_EnumEx will reply async\n"));
		}
		break;
	}
	case 22: {
		struct dfs_SetInfo2 *r2 = (struct dfs_SetInfo2 *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(dfs_SetInfo2, NDR_IN, r2);
		}
		r2->out.result = dcesrv_dfs_SetInfo2(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function dfs_SetInfo2 will reply async\n"));
		}
		break;
	}

	default:
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		break;
	}

	if (dce_call->fault_code != 0) {
		dcerpc_log_packet(dce_call->conn->packet_log_dir, 
		          &ndr_table_netdfs, opnum, NDR_IN,
				  &dce_call->pkt.u.request.stub_and_verifier);
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

static NTSTATUS netdfs__op_reply(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, void *r)
{
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	switch (opnum) {
	case 0: {
		struct dfs_GetManagerVersion *r2 = (struct dfs_GetManagerVersion *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function dfs_GetManagerVersion replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(dfs_GetManagerVersion, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in dfs_GetManagerVersion\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 1: {
		struct dfs_Add *r2 = (struct dfs_Add *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function dfs_Add replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(dfs_Add, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in dfs_Add\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 2: {
		struct dfs_Remove *r2 = (struct dfs_Remove *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function dfs_Remove replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(dfs_Remove, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in dfs_Remove\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 3: {
		struct dfs_SetInfo *r2 = (struct dfs_SetInfo *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function dfs_SetInfo replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(dfs_SetInfo, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in dfs_SetInfo\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 4: {
		struct dfs_GetInfo *r2 = (struct dfs_GetInfo *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function dfs_GetInfo replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(dfs_GetInfo, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in dfs_GetInfo\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 5: {
		struct dfs_Enum *r2 = (struct dfs_Enum *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function dfs_Enum replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(dfs_Enum, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in dfs_Enum\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 6: {
		struct dfs_Rename *r2 = (struct dfs_Rename *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function dfs_Rename replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(dfs_Rename, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in dfs_Rename\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 7: {
		struct dfs_Move *r2 = (struct dfs_Move *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function dfs_Move replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(dfs_Move, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in dfs_Move\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 8: {
		struct dfs_ManagerGetConfigInfo *r2 = (struct dfs_ManagerGetConfigInfo *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function dfs_ManagerGetConfigInfo replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(dfs_ManagerGetConfigInfo, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in dfs_ManagerGetConfigInfo\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 9: {
		struct dfs_ManagerSendSiteInfo *r2 = (struct dfs_ManagerSendSiteInfo *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function dfs_ManagerSendSiteInfo replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(dfs_ManagerSendSiteInfo, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in dfs_ManagerSendSiteInfo\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 10: {
		struct dfs_AddFtRoot *r2 = (struct dfs_AddFtRoot *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function dfs_AddFtRoot replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(dfs_AddFtRoot, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in dfs_AddFtRoot\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 11: {
		struct dfs_RemoveFtRoot *r2 = (struct dfs_RemoveFtRoot *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function dfs_RemoveFtRoot replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(dfs_RemoveFtRoot, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in dfs_RemoveFtRoot\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 12: {
		struct dfs_AddStdRoot *r2 = (struct dfs_AddStdRoot *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function dfs_AddStdRoot replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(dfs_AddStdRoot, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in dfs_AddStdRoot\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 13: {
		struct dfs_RemoveStdRoot *r2 = (struct dfs_RemoveStdRoot *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function dfs_RemoveStdRoot replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(dfs_RemoveStdRoot, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in dfs_RemoveStdRoot\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 14: {
		struct dfs_ManagerInitialize *r2 = (struct dfs_ManagerInitialize *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function dfs_ManagerInitialize replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(dfs_ManagerInitialize, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in dfs_ManagerInitialize\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 15: {
		struct dfs_AddStdRootForced *r2 = (struct dfs_AddStdRootForced *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function dfs_AddStdRootForced replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(dfs_AddStdRootForced, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in dfs_AddStdRootForced\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 16: {
		struct dfs_GetDcAddress *r2 = (struct dfs_GetDcAddress *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function dfs_GetDcAddress replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(dfs_GetDcAddress, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in dfs_GetDcAddress\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 17: {
		struct dfs_SetDcAddress *r2 = (struct dfs_SetDcAddress *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function dfs_SetDcAddress replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(dfs_SetDcAddress, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in dfs_SetDcAddress\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 18: {
		struct dfs_FlushFtTable *r2 = (struct dfs_FlushFtTable *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function dfs_FlushFtTable replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(dfs_FlushFtTable, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in dfs_FlushFtTable\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 19: {
		struct dfs_Add2 *r2 = (struct dfs_Add2 *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function dfs_Add2 replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(dfs_Add2, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in dfs_Add2\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 20: {
		struct dfs_Remove2 *r2 = (struct dfs_Remove2 *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function dfs_Remove2 replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(dfs_Remove2, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in dfs_Remove2\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 21: {
		struct dfs_EnumEx *r2 = (struct dfs_EnumEx *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function dfs_EnumEx replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(dfs_EnumEx, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in dfs_EnumEx\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 22: {
		struct dfs_SetInfo2 *r2 = (struct dfs_SetInfo2 *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function dfs_SetInfo2 replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(dfs_SetInfo2, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in dfs_SetInfo2\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}

	default:
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		break;
	}

	if (dce_call->fault_code != 0) {
		dcerpc_log_packet(dce_call->conn->packet_log_dir,
		          &ndr_table_netdfs, opnum, NDR_IN,
				  &dce_call->pkt.u.request.stub_and_verifier);
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

static NTSTATUS netdfs__op_ndr_push(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, struct ndr_push *push, const void *r)
{
	enum ndr_err_code ndr_err;
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	ndr_err = ndr_table_netdfs.calls[opnum].ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		dce_call->fault_code = DCERPC_FAULT_NDR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

const struct dcesrv_interface dcesrv_netdfs_interface = {
	.name		= "netdfs",
	.syntax_id  = {{0x4fc742e0,0x4a10,0x11cf,{0x82,0x73},{0x00,0xaa,0x00,0x4a,0xe6,0x73}},3.0},
	.bind		= netdfs__op_bind,
	.unbind		= netdfs__op_unbind,
	.ndr_pull	= netdfs__op_ndr_pull,
	.dispatch	= netdfs__op_dispatch,
	.reply		= netdfs__op_reply,
	.ndr_push	= netdfs__op_ndr_push
};


static NTSTATUS netdfs__op_init_server(struct dcesrv_context *dce_ctx, const struct dcesrv_endpoint_server *ep_server)
{
	int i;

	for (i=0;i<ndr_table_netdfs.endpoints->count;i++) {
		NTSTATUS ret;
		const char *name = ndr_table_netdfs.endpoints->names[i];

		ret = dcesrv_interface_register(dce_ctx, name, &dcesrv_netdfs_interface, NULL);
		if (!NT_STATUS_IS_OK(ret)) {
			DEBUG(1,("netdfs_op_init_server: failed to register endpoint '%s'\n",name));
			return ret;
		}
	}

	return NT_STATUS_OK;
}

static bool netdfs__op_interface_by_uuid(struct dcesrv_interface *iface, const struct GUID *uuid, uint32_t if_version)
{
	if (dcesrv_netdfs_interface.syntax_id.if_version == if_version &&
		GUID_equal(&dcesrv_netdfs_interface.syntax_id.uuid, uuid)) {
		memcpy(iface,&dcesrv_netdfs_interface, sizeof(*iface));
		return true;
	}

	return false;
}

static bool netdfs__op_interface_by_name(struct dcesrv_interface *iface, const char *name)
{
	if (strcmp(dcesrv_netdfs_interface.name, name)==0) {
		memcpy(iface, &dcesrv_netdfs_interface, sizeof(*iface));
		return true;
	}

	return false;	
}
	
NTSTATUS dcerpc_server_netdfs_init(void)
{
	NTSTATUS ret;
	struct dcesrv_endpoint_server ep_server;

	/* fill in our name */
	ep_server.name = "netdfs";

	/* fill in all the operations */
	ep_server.init_server = netdfs__op_init_server;

	ep_server.interface_by_uuid = netdfs__op_interface_by_uuid;
	ep_server.interface_by_name = netdfs__op_interface_by_name;

	/* register ourselves with the DCERPC subsystem. */
	ret = dcerpc_register_ep_server(&ep_server);

	if (!NT_STATUS_IS_OK(ret)) {
		DEBUG(0,("Failed to register 'netdfs' endpoint server!\n"));
		return ret;
	}

	return ret;
}

